
include(CheckSymbolExists)

FIND_PATH(SCITOKENS_CPP_INCLUDE_DIR scitokens/scitokens.h
  HINTS
  ${SCITOKENS_CPP_DIR}
  $ENV{SCITOKENS_CPP_DIR}
  /usr
  PATH_SUFFIXES include
)

FIND_LIBRARY(SCITOKENS_CPP_LIBRARIES SciTokens
  HINTS
  ${SCITOKENS_CPP_DIR}
  $ENV{SCITOKENS_CPP_DIR}
  /usr
  PATH_SUFFIXES lib
)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(SciTokensCpp DEFAULT_MSG SCITOKENS_CPP_LIBRARIES SCITOKENS_CPP_INCLUDE_DIR)

IF (SCITOKENS_CPP_INCLUDE_DIR)
  SET( CMAKE_REQUIRED_INCLUDES ${SCITOKENS_CPP_INCLUDE_DIR} )
  SET( CMAKE_REQUIRED_LIBRARIES ${SCITOKENS_CPP_LIBRARIES} )
  CHECK_SYMBOL_EXISTS(scitoken_config_set_str "scitokens/scitokens.h" HAVE_SCITOKEN_CONFIG_SET_STR)
  MARK_AS_ADVANCED(HAVE_SCITOKEN_CONFIG_SET_STR)
ENDIF ()
