/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import rene.gui.Global;
import rene.gui.Keyboard;
import rene.gui.KeyboardInterface;

public class KeyboardController
implements KeyListener {
    boolean Escape = false;
    boolean IgnoreTyped = false;
    int CommandType = 0;
    Component C = null;
    KeyboardInterface Primary = null;
    KeyboardInterface Secondary = null;
    boolean scaled = false;
    long scale;

    public synchronized void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            return;
        }
        if (keyEvent.getKeyCode() == 17) {
            return;
        }
        if (keyEvent.getKeyCode() == 18) {
            return;
        }
        if (this.old(keyEvent)) {
            return;
        }
        String string = Keyboard.findKey(keyEvent, this.CommandType);
        this.IgnoreTyped = false;
        if (string.startsWith("command.")) {
            if (string.equals("command.escape")) {
                this.Escape = !this.Escape;
            } else {
                try {
                    this.CommandType = Integer.parseInt(string.substring(8));
                    this.Escape = false;
                }
                catch (Exception exception) {
                    this.CommandType = 0;
                }
            }
            this.IgnoreTyped = true;
        } else if (string.startsWith("charkey.")) {
            this.keyboardCommand(keyEvent, string);
            this.IgnoreTyped = true;
            this.Escape = false;
            this.CommandType = 0;
        } else if (this.Escape) {
            char c2 = keyEvent.getKeyChar();
            this.IgnoreTyped = true;
            this.keyboardEscape(keyEvent, c2);
            this.Escape = false;
        } else if (!string.equals("")) {
            this.keyboardCommand(keyEvent, string);
            this.IgnoreTyped = false;
            this.Escape = false;
            this.CommandType = 0;
        } else if (!keyEvent.isActionKey()) {
            if (!Global.getParameter("keyboard.compose", true)) {
                this.keyboardChar(keyEvent, keyEvent.getKeyChar());
                this.Escape = false;
                this.CommandType = 0;
            } else {
                this.Escape = false;
                this.CommandType = 0;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!Global.getParameter("keyboard.compose", true)) {
            return;
        }
        if (this.IgnoreTyped) {
            return;
        }
        this.IgnoreTyped = false;
        this.keyboardChar(keyEvent, keyEvent.getKeyChar());
        this.Escape = false;
        this.CommandType = 0;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyboardCommand(KeyEvent keyEvent, String string) {
        if (!(this.Primary != null && this.Primary.keyboardCommand(keyEvent, string) || this.Secondary == null)) {
            this.Secondary.keyboardCommand(keyEvent, string);
        }
    }

    public void keyboardEscape(KeyEvent keyEvent, char c2) {
        if (!(this.Primary != null && this.Primary.keyboardEscape(keyEvent, c2) || this.Secondary == null)) {
            this.Secondary.keyboardEscape(keyEvent, c2);
        }
    }

    public void keyboardChar(KeyEvent keyEvent, char c2) {
        if (!(this.Primary != null && this.Primary.keyboardChar(keyEvent, c2) || this.Secondary == null)) {
            this.Secondary.keyboardChar(keyEvent, c2);
        }
    }

    boolean old(KeyEvent keyEvent) {
        if (!this.scaled) {
            this.scaled = true;
            this.scale = System.currentTimeMillis() - keyEvent.getWhen();
            return false;
        }
        long l = System.currentTimeMillis() - keyEvent.getWhen() - this.scale;
        if (l > 10000L) {
            return false;
        }
        return l > 200L;
    }

    public void listenTo(Component component) {
        if (this.C != null) {
            this.C.removeKeyListener(this);
        }
        this.C = component;
        if (this.C != null) {
            this.C.addKeyListener(this);
        }
    }

    public void setPrimary(KeyboardInterface keyboardInterface) {
        this.Primary = keyboardInterface;
    }

    public void setSecondary(KeyboardInterface keyboardInterface) {
        this.Secondary = keyboardInterface;
    }
}

