## TFSA-2020-012: Segfault by calling session-only ops in eager mode

### CVE Number
CVE-2020-15204

### Impact
In eager mode, TensorFlow does not set the session state. Hence, calling
`tf.raw_ops.GetSessionHandle` or `tf.raw_ops.GetSessionHandleV2` results in a
[null pointer
dereference](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/session_ops.cc#L45):
```cc
  int64 id = ctx->session_state()->GetNewId();
```

In the above snippet, in eager mode, `ctx->session_state()` returns `nullptr`.
Since code immediately dereferences this, we get a segmentation fault.

### Vulnerable Versions
TensorFlow 1.15.0, 1.15.1, 1.15.2, 1.15.3, 2.0.0, 2.0.1, 2.0.2, 2.1.0, 2.1.1,
2.2.0, 2.3.0.

### Patches
We have patched the issue in
[9a133d73ae4b4664d22bd1aa6d654fec13c52ee1](https://github.com/tensorflow/tensorflow/commit/9a133d73ae4b4664d22bd1aa6d654fec13c52ee1)
and will release patch releases for all versions between 1.15 and 2.3.

We recommend users to upgrade to TensorFlow 1.15.4, 2.0.3, 2.1.2, 2.2.1, or
2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
