---
title: Developer
---

# Developer Documentation

- [Libraries Licenses](../Libraries_Licenses.md) - which libraries are used and under which licenses
- [CodeStyle](CodeStyle.md) - information about how the source code should look like
- [Tests](Tests.md) - information about performed software tests
- [Unit Tests](Unit_Tests.md) - information about how to set up Unit Tests
- [GUI Testing](GUI_Testing.md) - information about how to set up "interactive" GUI Tests with PyAutoGUI
- [Debugging](Debugging.md) - information about debugging SUMO
- [Exploring the structure](ExploringTheStructure.md) - explore the structure of SUMO with the doxygen documentation
- [Inline code documentation (doxygen)](https://sumo.dlr.de/daily/doxygen/)
- [Used Tools](Used_Tools.md) - tools used for developing SUMO
- [Managing Publications](Managing_Publications.md) - how to work with the publications bibtex-file
- [FMI](FMI.md) - information about the current state of the FMI 2.0 support in SUMO
- [Maven](Maven.md) - information about using libsumo/libtraci in maven builds
- [How to Update Homebrew Formula](HowToUpdateHomebrewFormula.md) - how to update the macOS Homebrew Formula for a new SUMO release
- [Translating](Translating.md) - how to add translations for GUI and messaging
- [Issue Workflow](Workflow.md) - how tickets are being processed

## Build instructions

- [Linux Build](../Installing/Linux_Build.md) - how to
  build on Linux
- [Windows Build](../Installing/Windows_Build.md) -
  how to build on Windows
- [macOS Build](../Installing/MacOS_Build.md) - how to
  build on macOS
- [Documentation Build](Documentation_Build.md) - how to build the
  documentation
- [Nightly Build](Nightly_Build.md) - what
  happens every night
- [Status page](https://sumo.dlr.de/daily/) - log files and test
  results of nightly builds

## How Tos

- [How To write an own network importer](How_To/Net_Importer.md)
- [How To extend the vehicle class](How_To/Extend_Vehicles.md)
- [How To implement an own car-following model](How_To/Car-Following_Model.md)
- [How To implement an own lane-changing model](How_To/Lane-Changing_Model.md)
- [How To implement a new device](How_To/Device.md)
- [How To contribute to this documentation](../FAQ.md#how_do_i_contribute_to_the_documentation)
- [How To contribute to SUMO in general](../FAQ.md#how_can_i_contribute_to_sumo)

## Methods, Algorithms, and Subsystems

- [Implementation Notes](Implementation_Notes/index.md) - more information about several subtopics (error handling, options sub system)
- [Network Building Process](Network_Building_Process.md)

## Current Development

- [How To add more car-following models](Implementation_Notes/Vehicle_Models.md)
- [Progress on implementing an XML validation](XML_Validation.md)
- [HowToRelease](HowToRelease.md) - how to do a release
- [Docker](Docker.md) - how to use containerized SUMO
- [How To create a CI Test with GitHub Actions](Github_Actions_CI_Test.md) - projects depending on SUMO
- [Git](GitStuff.md)
- [Profiling](Profiling.md)
- [Visual Studio Code](VisualStudioCode.md) - how to use Visual Studio Code with the SUMO code base

## Continuous integration, code analysis and other external references

- [GitHub project](https://github.com/eclipse-sumo/sumo)
- [SourceForge project](https://sourceforge.net/projects/sumo/)
- [Packages on the open build service](https://software.opensuse.org/package/sumo)
- [Nightly builds on the open build service](https://build.opensuse.org/package/show/science:dlr/sumo_nightly)
- [SUMO brew formula on Github Actions](https://github.com/DLR-TS/homebrew-sumo/actions)
- [SUMO on OpenHub](https://www.openhub.net/p/sumo/)
- [SUMO on the Helmholtz RSD](https://helmholtz.software/software/sumo)
