# Spyder Logo Guidelines
These guidelines are meant to help keep the Spyder logo consistent and recognizable across all its uses. 
They also provide a common language for referring to the logos and their components.

The primary logo is the horizontal option (logomark and text next to each other).
You may also use the logomark on its own (meaning the logomark without text). 
When in doubt, it’s preferable to use the primary logo that includes text over the logomark alone. 

If you have a case where you do not know what background the logo will be on or it is a variable background (such as the application icon on a desktop), it is best to use a logo option with the light grey background.

## Color
Colors used in the various logos are as follows:
- Full color options are a combination of red (`#8c0000` or `rgb(140, 0, 0)`) and grey (`#303030` or `rgb(48,48,48)`).
- Full color options with a background have the same red and grey as other full color options and add a light grey (`#fafafa` or `rgb(250, 250, 250)`) rectangle behind it.
- Light options are white (`#ffffff` or `rgb(255, 255, 255)`). 
- Dark options are black (`#000000` or `rgb(0, 0, 0)`).

Whenever possible, use the full color logos. One color logos (light or dark) are to be used when full color will not have enough contrast or cannot be produced.

## Minimum Size
Please do not make the primary logo smaller than 75 px wide or the logomark smaller than 14 px wide.

## Logo Integrity
A few other notes to keep in mind when using the logo:
- Be sure to scale the logo proportionally.
- Maintain a good amount of space around the logo. Don’t let it overlap with text, images, or other elements without giving it a single color background.
- Do not try and recreate or modify the logo. For example, do not use the logomark and then try to write Spyder in another font.