/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIPool;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.NSProperty;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Hashtable;

public class TestDasl {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: TestDasl <url> <inputfile>");
            System.exit(-1);
        }
        DSIPool pool = DSIPool.getDSIPool();
        String url2 = args[0];
        String file = args[1];
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url2, dal);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String query = "";
            while ((line = reader.readLine()) != null) {
                query = query + line;
            }
            System.out.println("Executing query: " + query);
            System.out.println("BEFORE dasl query");
            Hashtable properties = dsi.doDaslQuery(query, Integer.MAX_VALUE);
            System.out.println("AFTER dasl query");
            if (properties != null) {
                System.out.println("Num matches: " + properties.size());
                for (String url2 : properties.keySet()) {
                    System.out.println("\nurl " + url2);
                    Hashtable propcoll = (Hashtable)properties.get(url2);
                    System.out.println("property size" + propcoll.size());
                    for (NSProperty ns : propcoll.keySet()) {
                        DSIProperty prop = (DSIProperty)propcoll.get(ns);
                        String propVal = prop.getPropertyAsString().trim();
                        if (propVal.length() == 0) {
                            propVal = prop.getPropertyAsXMLString(true).trim();
                        }
                        System.out.println(prop.getPropertyKey() + "=" + propVal);
                    }
                }
            } else {
                System.out.println("result set is null.");
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        System.exit(0);
    }
}

