/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xslt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.xslt.XSLTService;
import org.apache.xalan.xslt.StylesheetRoot;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.w3c.dom.Node;

public class TurbineXSLTService
extends TurbineBaseService
implements XSLTService {
    protected boolean caching = false;
    protected String path;
    protected Hashtable cache = new Hashtable();

    public void init() {
        if (this.getInit()) {
            return;
        }
        this.path = TurbineResources.getString("services.XSLTService.path");
        this.path = TurbineServlet.getRealPath(this.path);
        if (!this.path.endsWith("/") && !this.path.endsWith("\\")) {
            this.path = this.path + File.separator;
        }
        this.caching = TurbineResources.getBoolean("services.XSLTService.cache");
        this.setInit(true);
    }

    protected String getFileName(String templateName) {
        File f;
        int colon = templateName.lastIndexOf(".");
        if (colon > 0) {
            templateName = templateName.substring(0, colon);
        }
        if ((f = new File(this.path + templateName + ".xsl")).exists()) {
            return this.path + templateName + ".xsl";
        }
        f = new File(this.path + "default.xsl");
        if (f.exists()) {
            return this.path + "default.xsl";
        }
        return null;
    }

    protected StylesheetRoot compileStylesheetRoot(String source) throws Exception {
        XSLTProcessor processor = XSLTProcessorFactory.getProcessor();
        XSLTInputSource xslin = new XSLTInputSource("file:///" + source);
        StylesheetRoot root = processor.processStylesheet(xslin);
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected StylesheetRoot getStylesheetRoot(String xslName) throws Exception {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            if (this.caching && this.cache.containsKey(xslName)) {
                return (StylesheetRoot)this.cache.get(xslName);
            }
            String fn = this.getFileName(xslName);
            if (fn == null) {
                return null;
            }
            StylesheetRoot sr = this.compileStylesheetRoot(fn);
            if (!this.caching) return sr;
            this.cache.put(xslName, sr);
            return sr;
        }
    }

    protected void transform(String xslName, XSLTProcessor processor, XSLTInputSource xmlin, XSLTResultTarget xmlout) throws Exception {
        StylesheetRoot sr = this.getStylesheetRoot(xslName);
        if (sr == null) {
            BufferedReader br = new BufferedReader(xmlin.getCharacterStream());
            BufferedWriter bw = new BufferedWriter(xmlout.getCharacterStream());
            String line = br.readLine();
            while (line != null) {
                try {
                    bw.write(line);
                    line = br.readLine();
                }
                finally {
                    Object var10_9 = null;
                    bw.flush();
                }
            }
        } else {
            processor.setStylesheet(sr);
            processor.process(xmlin, null, xmlout);
        }
    }

    public void transform(String xslName, Reader in, Writer out) throws Exception {
        XSLTProcessor processor = XSLTProcessorFactory.getProcessor();
        XSLTInputSource xmlin = new XSLTInputSource(in);
        XSLTResultTarget xmlout = new XSLTResultTarget(out);
        this.transform(xslName, processor, xmlin, xmlout);
    }

    public String transform(String xslName, Reader in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public void transform(String xslName, Node in, Writer out) throws Exception {
        XSLTProcessor processor = XSLTProcessorFactory.getProcessor();
        XSLTInputSource xmlin = new XSLTInputSource(in);
        XSLTResultTarget xmlout = new XSLTResultTarget(out);
        this.transform(xslName, processor, xmlin, xmlout);
    }

    public String transform(String xslName, Node in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }
}

