Welcome to NSCA-ng!
===================

The NSCA-ng package provides a client-server pair which makes the "Nagios
command file" accessible to remote systems.  This allows for submitting
passive check results, downtimes, and many other [commands][1] to Nagios (or
compatible monitoring solutions).

NSCA-ng supports TLS encryption and shared-secret authentication with
client-specific passwords (based on [RFC 4279][2]), as well as fine-grained
authorization control.

Prerequisites
-------------

1.  [OpenSSL][3] 1.0.0 or newer is required for building NSCA-ng (as older
    releases don't support pre-shared key authentication).  This is the only
    hard dependency of the NSCA-ng client.  If the OpenSSL version provided
    by your operating system vendor is too old, you might want to build a
    private copy of OpenSSL and embed it into NSCA-ng.  This could be done
    by running the `./build-aux/make-openssl` script, which downloads the
    most recent OpenSSL version and installs it into the NSCA-ng source
    tree.  The `./configure` script (see below) will then pick that up
    automatically.

2.  The NSCA-ng *server* also requires [libConfuse][4] 2.6 or newer.  In
    order to embed a private copy of libConfuse into NSCA-ng, the
    `./build-aux/make-confuse` script could be run before calling
    `./configure`.

3.  If [libev][5] 4.00 or newer is available and found by the `./configure`
    script, NSCA-ng will (by default) use it.  Otherwise, a bundled copy of
    libev is embedded into NSCA-ng, so this dependency is optional.

4.  Optional [systemd][6] integration code is added to the NSCA-ng *server*
    if systemd's `sd-daemon(3)` library is found.  This can be disabled by
    specifying the `--without-systemd` option on the `./configure` command
    line.

Installation
------------

If only the client should be built, issuing the following three commands in
NSCA-ng's source directory should do the trick:

    $ ./configure
    $ make
    $ su root -c 'make install'

This installs the NSCA-ng client into appropriate subdirectories of
`/usr/local`.

The installation process can be customized by setting environment variables
and/or passing options to the `./configure` script.  Some of the more
frequently used `./configure` options include:

* `--enable-server`

    Build and install the NSCA-ng server (in addition to the client, unless
    `--disable-client` is specified).

* `--disable-client`

    Don't build and install the NSCA-ng client.

* `--disable-posix-aio`

    Don't use the POSIX AIO API.  By default, the NSCA-ng server will use
    the POSIX AIO API if available.

* `--prefix=PATH`

    Install NSCA-ng into subdirectories of `PATH` instead of `/usr/local`.

* `--with-confuse=PATH`

    Search for the libConfuse header files in `PATH/include`, and search for
    the libConfuse library files in `PATH/lib`.  If this option isn't
    specified, `./configure` will look for libConfuse in a few typical
    locations.

* `--with-ev=PATH`

    Search for the libev header files in `PATH/include`, and search for the
    libev library files in `PATH/lib`.  If this option isn't specified,
    `./configure` will look for libev in a few typical locations; and if no
    usable version is found, a bundled copy of libev will be embedded into
    NSCA-ng.  In order to force usage of the included copy,
    `--with-ev=embedded` can be specified; while `--with-ev=external` would
    disallow falling back to the bundled libev code.

* `--with-openssl=PATH`

    Search for the OpenSSL header files in `PATH/include`, and search for
    the OpenSSL library files in `PATH/lib`.  If this option isn't
    specified, `./configure` will look for OpenSSL in a few typical
    locations.

For a full list of available options and environment variables, run
`./configure --help`.  See the file `INSTALL` for detailed installation
instructions.

Configuration
-------------

The NSCA-ng client is configured using the `send_nsca.cfg(5)` file, the
NSCA-ng server uses the `nsca-ng.cfg(5)` file.  Examples of these files are
installed if they don't already exist.

> **Important:**  Please set the permissions of the configuration files
> appropriately to make sure that only authorized users can access them.

A script such as `nsca-ng.init` (as provided in the `contrib` directory of
this package) could be used to start and stop the NSCA-ng server.

Usage
-----

Please see the scripts in the `contrib` directory for various usage
examples.

NSCA Compatibility
------------------

The NSCA-ng client (`send_nsca`) is a drop-in replacement for the
`send_nsca` binary provided with the original NSCA 2.x package in the sense
that NSCA-ng's `send_nsca` accepts all input, command line arguments, and
configuration files accepted by the original `send_nsca`.  NSCA-ng clients
cannot talk to NSCA servers (nor vice versa), but NSCA and NSCA-ng servers
can happily run side by side, and they use different ports by default.

Documentation
-------------

Detailed information regarding the build and installation process can be
found in the file `INSTALL`.

The NSCA-ng usage and configuration is documented in the `nsca-ng(8)`,
`send_nsca(8)`, `nsca-ng.cfg(5)`, and `send_nsca.cfg(5)` manual pages.  The
commands `send_nsca -h` and `nsca-ng -h` spit out short summaries of the
available command line options.

For each release, noteworthy changes are listed in the file `NEWS`.  Feature
additions which are planned for future releases are added to the `TODO`
file.

For copyright and license information, see the file `COPYING`.

Support
-------

Bug reports and patches can be sent to the <developers@nsca-ng.org> list (no
subscription required).  For usage support, please subscribe to the
<users@nsca-ng.org> list.  See the [NSCA-ng][7] website for details.

[1]: http://www.nagios.org/developerinfo/externalcommands/
[2]: http://tools.ietf.org/html/rfc4279
[3]: http://www.openssl.org/
[4]: https://github.com/libconfuse/libconfuse
[5]: http://libev.schmorp.de/
[6]: http://www.freedesktop.org/wiki/Software/systemd/
[7]: http://www.nsca-ng.org/

<!-- vim:set filetype=markdown textwidth=76 joinspaces: -->
