# Node.js Foundation TSC Meeting 2015-07-22

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-07-22
* **GitHub Issue**: https://github.com/nodejs/node-convergence-archive/issues/69
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1r8boI4E67Cq7PEsYeIpXkFZM0be4Ww5UDlNr_uXOop0

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests prior to meeting.

### nodejs/io.js

* doc: add GPG fingerprint for cjihrig [#2217](https://github.com/nodejs/io.js/pull/2217)
* Process & Approval for Collab Summit Travel Fund [#2213](https://github.com/nodejs/io.js/issues/2213)
* TC39 representation for the Node.js Foundation [#2153](https://github.com/nodejs/io.js/issues/2153)
* Next branch release versioning [#2215](https://github.com/nodejs/io.js/issues/2215)

## Minutes


### Present

* Mikeal Rogers
* Rod Vagg (TSC)
* Colin Ihrig (TSC)
* James Snell (TSC)
* Fedor Indutny (TSC)
* Michael Dawson (TSC)
* Steven R Loomis (TSC)
* Jeremiah Senkpiel (TSC)
* Brian White (TSC)
* Ben Noordhuis (TSC)
* Trevor Norris (TSC)
* Chris Dickinson (TSC)
* Mike Dolan (Linux F)
* Emily Ratliff (Linux F)

### Security Policy Discussion

Emily Ratliff from the LF has joined us to help with our security and disclosure policy. TSC members were sent a briefing prior to the meeting.

Discussed ISO 29147 “Vulnerability Disclosure Overview” and ISO 30111 “Vulnerability Handling Processes Overview”.


### Review of the previous meeting

* Foundation Discussion (@mikeal leading)
* Intl [#238](https://github.com/nodejs/io.js/issues/238)
* TC39 representation [#2153](https://github.com/nodejs/io.js/issues/2153)
* lts: LTS Proposal (https://github.com/nodejs/LTS#proposed-lts)[ Proposal: Release Process] [#1997](https://github.com/nodejs/io.js/issues/1997)

### Standup:

* Mikeal Rogers: preparing for the foundation board meeting
* Rod Vagg: working on 3.0 and release candidates / NAN
* Colin Ihrig: reviewing issues  & PRs, worked with julien to do releases from joyent/node 0.x branches
* James Snell: working on smoke-testing npm modules
* Fedor Indutny: doing so bug fixes, and reviewing PRs
* Michael Dawson: some joyent/node issue triage, PPC build work
* Steven R Loomis: some Intl WG work, working on getting the Intl commits from joyent/node into io.js
* Jeremiah Senkpiel: reviewing issues + prs, doing work on REPL in light of 3.0; fixing bugs in REPL
* Brian White: working more on the in-browser node.js/io.js benchmarking tool, which is now in a usable state. using it now to test current and future performance improvement techniques for the the js http parser
* Ben Noordhuis: (no mic)
* Trevor Norris: did a fix for the buffer implementation for the 3.0 release
* Chris Dickinson: npm work.

### doc: add GPG fingerprint for cjihrig [#2217](https://github.com/nodejs/io.js/pull/2217)

* Rod +1
* James +1
* Fedor +1
* Michael +1
* Steven +1
* Jeremiah +1
* Brian +1
* Ben +1
* Trevor +1
* Chris +1

Action: make sure Colin’s GPG key setup is correct on the PR, after we can merge and Rod can add Colin’s credentials to the build server.

### Process & Approval for Collab Summit Travel Fund [#2213](https://github.com/nodejs/io.js/issues/2213)

* Mikeal: budget auditing requires that spending be approved by the board - need to approve the budget and the process for expenditure of those funds. Mikeal has a proposal for the process with basic limits and a process for having the TSC approve expenditure beyond that.


**Process as outlined**

* TSC approves target budget (max amount to spend on travel) and caps on each type of spend (with the possibility that the TSC can approve a specific spend over if need be).
* Contributors in need of the fund apply (this will happen in the GitHub thread) but should explicitly state if they need flight, accommodation or both.
* If the number of contributors in need of the fund exceeds the target budget the TSC will prioritize the list of contributors applying for the fund.


Voting on approving the process stated above:

* Rod: +1
* James: +1
* Fedor: +1
* Michael: +1
* Steven: +1
* Jeremiah: +1 
* Brian: +1
* Ben: +1
* Trevor: +1
* Chris: +1


Specific proposal for August

* 15K max budget (we had previously talked about 10K but I don't think that is enough)
* Approve a $900 max spend per person on accommodations.
* Approve a $500 max spend on domestic travel
* Approve a $1500 max spend on international travel (if someone has to go over it just requires additional TSC approval)

* Rod: +1
* James: +1
* Fedor: +1
* Michael: +1
* Steven: +1
* Jeremiah: +1 
* Brian: +1
* Ben: +1
* Trevor: +1
* Chris: +1


Approval for extra expenditure for @joaocgreis (from Portugal): $1,742.66

* Rod: +1
* James: +1
* Fedor: +1
* Michael: +1
* Steven: +1
* Jeremiah: +1 
* Brian: +1
* Ben: +1
* Trevor: +1
* Chris: +1

Approval for expenditure on @yosuke-furukawa (from Japan) max spend of $2400

* Rod: +1
* James: +1
* Fedor: +1
* Michael: +1
* Steven: +1
* Jeremiah: +1 
* Brian: +1
* Ben: +1
* Trevor: +1
* Chris: +1

### Next branch release versioning [#2215](https://github.com/nodejs/io.js/issues/2215)

* Rod outlined the state of play:
  - LTS WG moved from “proposal” to “plan” but are still depending on the stable release branch having a clear process
  - LTS WG discussed a proposal by Trevor for how to handle next/canary/alpha & master & release branches & LTS branches: https://gist.github.com/trevnorris/7620a64b086e95271197
* Mikeal: it’s more helpful if we think about V8 upgrades as a pull-request to master rather than a separate “next” that has to be separately managed.

Much bikeshedding was had in an attempt to move forward.

Group agreed in general with Trevor’s proposal, will organise further discussions amongst the group of interested parties at another time.

### Next Meeting

July 29th 2015
