<p align="center">
  <a href="https://github.com/node-base/base">
    <img height="250" width="250" src="https://raw.githubusercontent.com/node-base/base/master/docs/logo.png">
  </a>
</p>

# {%= name %} 

{%= badge("npm") %} {%= badge('downloads') %} {%= ifExists(["test", "test.js"], badge('travis')) %} {%= badge('gitter') %} 

## Table of contents
<details>
<summary><strong>Table of contents</strong></summary>

<!-- toc -->

</details>

<details>
<summary><strong>About</strong></summary>

## Why use Base?

Base is a foundation for creating modular, unit testable and highly pluggable server-side node.js APIs.

* Go from zero to working application within minutes
* Use [community plugins](https://www.npmjs.com/browse/keyword/baseplugin) to add feature-functionality to your application
* Create your own custom plugins to add features
* Like building blocks, plugins are stackable. Allowing you to build [sophisticated applications](#toolkit-suite) from simple plugins. Moreover, those applications can also be used as plugins themselves. 

Most importantly, once you learn Base, you will be familiar with the core API of all applications built on Base. This means you will not only benefit as a developer, but as a user as well.

### Guiding principles

The core team follows these principles to help guide API decisions:

- **Compact API surface**: The smaller the API surface, the easier the library will be to learn and use.
- **Easy to extend**: Implementors can use any npm package, and write plugins in pure JavaScript. If you're building complex apps, Base dramatically simplifies inheritance.
- **Easy to test**: No special setup should be required to unit test `Base` or base plugins 
- **100% Node.js core style**
  * No API sugar (left for higher level projects)
  * Written in readable vanilla JavaScript

### Minimal API surface

[The API](#api) was designed to provide only the minimum necessary functionality for creating a useful application, with or without [plugins](#plugins). 

**Base core**

Base itself ships with only a handful of [useful methods](#api), such as:

- `.set`: for setting values on the instance
- `.get`: for getting values from the instance
- `.has`: to check if a property exists on the instance
- `.define`: for setting non-enumerable values on the instance
- `.use`: for adding plugins

**Be generic**

When deciding on method to add or remove, we try to answer these questions: 

1. Will all or most Base applications need this method? 
1. Will this method encourage practices or enforce conventions that are beneficial to implementors?
1. Can or should this be done in a plugin instead?

### Composability

**Plugin system**

It couldn't be easier to extend Base with any features or custom functionality you can think of. 

Base plugins are just functions that take an instance of `Base`:

```js
var base = new Base();

function plugin(base) {
  // do plugin stuff, in pure JavaScript
}
// use the plugin
base.use(plugin);
```

Add "smart plugin" functionality with the [base-plugins][] plugin. 

**Inheritance**

Easily inherit Base using `.extend`:

```js
var Base = require('{%= name %}');

function MyApp() {
  Base.call(this);
}
Base.extend(MyApp);

var app = new MyApp();
app.set('a', 'b');
app.get('a');
//=> 'b';
```

**Inherit or instantiate with a namespace**

By default, the `.get`, `.set` and `.has` methods set and get values from the root of the `base` instance. You can customize this using the `.namespace` method exposed on the exported function. For example:

```js
var Base = require('{%= name %}');
// get and set values on the `base.cache` object
var base = Base.namespace('cache');

var app = base();
app.set('foo', 'bar');
console.log(app.cache.foo);
//=> 'bar'
```
</details>


## Install

**NPM**

## Install

{%= include("install-npm", {save: true}) %}

**yarn**

Install with [yarn](yarnpkg.com):

```sh
$ yarn add base && yarn upgrade
```

## Usage

```js
var Base = require('base');
var app = new Base();

// set a value
app.set('foo', 'bar');
console.log(app.foo);
//=> 'bar'

// register a plugin
app.use(function() {
  // do stuff (see API docs for ".use")
});
```

## API
{%= apidocs("index.js") %}

## cache object

**Cache**

User-defined properties go on the `cache` object. This keeps the root of the instance clean, so that only reserved methods and properties on the root.

```js
Base { cache: {} }
```

You can pass a custom object to use as the `cache` as the first argument to the `Base` class when instantiating.

```js
const myObject = {};
const Base = require('base');
const base = new Base(myObject);
```


## Toolkit suite

Base is part of the [Toolkit suite](https://github.com/node-toolkit/getting-started) of applications.

### What is Toolkit?

Toolkit is a collection of node.js libraries, applications and frameworks for helping developers quickly create high quality node.js applications, web projects, and command-line experiences. There are many other libraries on NPM for handling specific tasks, Toolkit provides the _systems_ and _building blocks_ for creating higher level workflows and processes around those libraries.

Toolkit can be used to create a static site generator, blog framework, documentaton system, command line, task or plugin runner, and more!

**Building Blocks**

The following libraries can be used as "building blocks" for creating modular applications.

- [base][]: (you are here!) framework for rapidly creating high quality node.js applications, using plugins like building blocks. Base serves as the foundation for several other applications in the [Toolkit suite](https://github.com/node-toolkit/getting-started).
- [templates][]: Render templates with any node.js template engine, create and manage template collections. Use helpers, layouts, partials, includes...
- [enquirer][]: Plugin-based prompt system for creating highly customizable command line experiences.
- [composer][]: Plugin-based, async task runner.

**Lifecycle Applications**

The following applications provide workflows and automation for common phases of the software development lifecycle. Each of these tools can be used entirely standalone or bundled together.

- [generate][]: create projects
- [assemble][]: build projects
- [verb][]: document projects
- [update][]: maintain projects

## About
### Related projects
{%= related(verb.related.list) %}  

### Tests
{%= include("tests") %}

### Contributing
{%= include("contributing") %}

If Base doesn't do what you need, [please let us know](../../issues).

### Release History

See the [changelog](CHANGELOG.md);

### Authors

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

**Brian Woodward**

* [github/doowb](https://github.com/doowb)
* [twitter/doowb](http://twitter.com/doowb)

### License
{%= copyright() %}
{%= license %}

***

{%= include("footer") %}

{%= reflinks(verb.reflinks) %}
