#line 6 "ncx.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 8
/*
 *  Copyright (C) 2014, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: ncx.m4 2601 2016-11-07 04:54:42Z wkliao $ */

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

#line 22

#line 26


#line 34

#line 41

#line 41
#if HAVE_CONFIG_H
#line 41
#include <config.h>
#line 41
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#line 53

#line 53
#pragma GCC diagnostic ignored "-Wdeprecated"
#line 53
#include "ncx.h"
#line 53
#include "nc3dispatch.h"

#line 72




#ifdef HAVE_INTTYPES_H
#include <inttypes.h> /* uint16_t, uint32_t, uint64_t */
#elif defined(HAVE_STDINT_H)
#include <stdint.h>   /* uint16_t, uint32_t, uint64_t */
#endif

#line 103

#line 121

/*
 * The only error code returned from subroutines in this file is NC_ERANGE,
 * if errors are detected.
 */

/*
 * An external data representation interface.
 */

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONGLONG_MAX
#define LONGLONG_MAX LONG_LONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef LONGLONG_MIN
#define LONGLONG_MIN LONG_LONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#ifndef ULONGLONG_MAX
#define ULONGLONG_MAX ULONG_LONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#ifndef SIZEOF_UCHAR
#ifdef  SIZEOF_UNSIGNED_CHAR
#define SIZEOF_UCHAR SIZEOF_UNSIGNED_CHAR
#else
#error "unknown SIZEOF_UCHAR"
#endif
#endif

#ifndef SIZEOF_USHORT
#ifdef  SIZEOF_UNSIGNED_SHORT_INT
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT_INT
#elif defined(SIZEOF_UNSIGNED_SHORT)
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT
#else
#error "unknown SIZEOF_USHORT"
#endif
#endif

#ifndef SIZEOF_UINT
#ifdef  SIZEOF_UNSIGNED_INT
#define SIZEOF_UINT SIZEOF_UNSIGNED_INT
#else
#error "unknown SIZEOF_UINT"
#endif
#endif

#ifndef SIZEOF_LONGLONG
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_LONGLONG SIZEOF_LONG_LONG
#else
#error "unknown SIZEOF_LONGLONG"
#endif
#endif

#ifndef SIZEOF_INT64
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_INT64 SIZEOF_LONG_LONG
#elif defined(SIZEOF_LONGLONG)
#define SIZEOF_INT64 SIZEOF_LONGLONG
#else
#error "unknown SIZEOF_INT64"
#endif
#endif

#ifndef SIZEOF_ULONGLONG
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_ULONGLONG SIZEOF_UNSIGNED_LONG_LONG
#else
#error "unknown SIZEOF_ULONGLONG"
#endif
#endif

#ifndef SIZEOF_UINT64
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_UINT64 SIZEOF_UNSIGNED_LONG_LONG
#elif defined(SIZEOF_ULONGLONG)
#define SIZEOF_UINT64 SIZEOF_ULONGLONG
#else
#error "unknown SIZEOF_UINT64"
#endif
#endif

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if defined(_SX) && _SX != 0 /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIG ENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressively.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
                   (((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
                  (((a) <<  8) & 0x00ff0000) | \
                  (((a) >>  8) & 0x0000ff00) | \
                  (((a) >> 24) & 0x000000ff) )

#define SWAP8(a) ( (((a) & 0x00000000000000FFULL) << 56) | \
                   (((a) & 0x000000000000FF00ULL) << 40) | \
                   (((a) & 0x0000000000FF0000ULL) << 24) | \
                   (((a) & 0x00000000FF000000ULL) <<  8) | \
                   (((a) & 0x000000FF00000000ULL) >>  8) | \
                   (((a) & 0x0000FF0000000000ULL) >> 24) | \
                   (((a) & 0x00FF000000000000ULL) >> 40) | \
                   (((a) & 0xFF00000000000000ULL) >> 56) )


inline static void
swapn2b(void *dst, const void *src, size_t nn)
{
    /* it is OK if dst == src */
    int i;
    uint16_t *op = (uint16_t*) dst;
    uint16_t *ip = (uint16_t*) src;
    for (i=0; i<nn; i++) {
        op[i] = ip[i];
        op[i] = (uint16_t)SWAP2(op[i]);
    }
#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *
 *	while (nn-- > 0)
 *	{
 *		*op++ = *(++ip);
 *		*op++ = *(ip++ -1);
 *	}
 */
	while (nn > 3)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		nn -= 4;
	}
	while (nn-- > 0)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
	}
#endif
}

# ifndef vax
inline static void
swap4b(void *dst, const void *src)
{
    /* copy over, make the below swap in-place */
    uint32_t tmp = *(uint32_t*)src;
    tmp = SWAP4(tmp);
    memcpy(dst, &tmp, 4);

    /* Codes below will cause "break strict-aliasing rules" in gcc
    uint32_t *op = (uint32_t*)dst;
    *op = *(uint32_t*)src;
    *op = SWAP4(*op);
    */

    /* Below are copied from netCDF-4.
     * See https://bugtracking.unidata.ucar.edu/browse/NCF-338
     * Quote "One issue we are wrestling with is how compilers optimize this
     * code.  For some reason, we are actually needing to add an artificial
     * move to a 4 byte space to get it to work.  I think what is happening is
     * that the optimizer is bit shifting within a double, which is incorrect.
     * The following code actually does work correctly.
     *  This is in Linux land, gcc.
     *
     * However, the above in-place byte-swap does not appear affected by this.
     */
#if 0
    uint32_t *ip = (uint32_t*)src;
    uint32_t tempOut;  /* cannot use pointer when gcc O2 optimizer is used */
    tempOut = SWAP4(*ip);

    *(float *)dst = *(float *)(&tempOut);
#endif

    /* OLD implementation that results in four load and four store CPU
       instructions
    char *op = dst;
    const char *ip = src;
    op[0] = ip[3];
    op[1] = ip[2];
    op[2] = ip[1];
    op[3] = ip[0];
    */

}
# endif /* !vax */

inline static void
swapn4b(void *dst, const void *src, size_t nn)
{
    int i;
    uint32_t *op = (uint32_t*) dst;
    uint32_t *ip = (uint32_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        op[i] = ip[i];
        op[i] = SWAP4(op[i]);
    }

#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while (nn-- > 0)
 *	{
 *		op[0] = ip[3];
 *		op[1] = ip[2];
 *		op[2] = ip[1];
 *		op[3] = ip[0];
 *		op += 4;
 *		ip += 4;
 *	}
 */
	while (nn > 3)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op[8] = ip[11];
		op[9] = ip[10];
		op[10] = ip[9];
		op[11] = ip[8];
		op[12] = ip[15];
		op[13] = ip[14];
		op[14] = ip[13];
		op[15] = ip[12];
		op += 16;
		ip += 16;
		nn -= 4;
	}
	while (nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op += 4;
		ip += 4;
	}
#endif
}

# ifndef vax
inline static void
swap8b(void *dst, const void *src)
{
#ifdef FLOAT_WORDS_BIGENDIAN
    /* copy over, make the below swap in-place */
    *(uint64_t*)dst = *(uint64_t*)src;

    uint32_t *op = (uint32_t*)dst;
    *op = SWAP4(*op);
    op = (uint32_t*)((char*)dst+4);
    *op = SWAP4(*op);
#else
    uint64_t tmp = *(uint64_t*)src;
    tmp = SWAP8(tmp);
    memcpy(dst, &tmp, 8);

    /* Codes below will cause "break strict-aliasing rules" in gcc
    uint64_t *op = (uint64_t*)dst;
    *op = *(uint64_t*)src;
    *op = SWAP8(*op);
    */
#endif

#if 0
	char *op = dst;
	const char *ip = src;
#  ifndef FLOAT_WORDS_BIGENDIAN
	op[0] = ip[7];
	op[1] = ip[6];
	op[2] = ip[5];
	op[3] = ip[4];
	op[4] = ip[3];
	op[5] = ip[2];
	op[6] = ip[1];
	op[7] = ip[0];
#  else
	op[0] = ip[3];
	op[1] = ip[2];
	op[2] = ip[1];
	op[3] = ip[0];
	op[4] = ip[7];
	op[5] = ip[6];
	op[6] = ip[5];
	op[7] = ip[4];
#endif
#endif
}
# endif /* !vax */

# ifndef vax
inline static void
swapn8b(void *dst, const void *src, size_t nn)
{
#ifdef FLOAT_WORDS_BIGENDIAN
    int i;
    uint64_t *dst_p = (uint64_t*) dst;
    uint64_t *src_p = (uint64_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        dst_p[i] = src_p[i];
        uint32_t *op = (uint32_t*)(&dst_p[i]);
        *op = SWAP4(*op);
        op = (uint32_t*)((char*)op+4);
        *op = SWAP4(*op);
    }
#else
    int i;
    uint64_t *op = (uint64_t*) dst;
    uint64_t *ip = (uint64_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        op[i] = ip[i];
        op[i] = SWAP8(op[i]);
    }
#endif

#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while (nn-- > 0)
 *	{
 *		op[0] = ip[7];
 *		op[1] = ip[6];
 *		op[2] = ip[5];
 *		op[3] = ip[4];
 *		op[4] = ip[3];
 *		op[5] = ip[2];
 *		op[6] = ip[1];
 *		op[7] = ip[0];
 *		op += 8;
 *		ip += 8;
 *	}
 */
#  ifndef FLOAT_WORDS_BIGENDIAN
	while (nn > 1)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op[8] = ip[15];
		op[9] = ip[14];
		op[10] = ip[13];
		op[11] = ip[12];
		op[12] = ip[11];
		op[13] = ip[10];
		op[14] = ip[9];
		op[15] = ip[8];
		op += 16;
		ip += 16;
		nn -= 2;
	}
	while (nn-- > 0)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op += 8;
		ip += 8;
	}
#  else
	while (nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op += 8;
		ip += 8;
	}
#endif
#endif
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */

#line 627

#line 631

#line 643

#line 658


/*
 * Primitive numeric conversion functions.
 */

#line 686

#line 734

#line 767

#line 813

/* x_schar */
/* x_uchar */

/* We don't implement any x_schar and x_uchar primitives. */


/* external NC_SHORT --------------------------------------------------------*/

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONGLONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_short)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_short)(*ip | *cp);
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 865
ncx_get_short_schar(const void *xp, schar *ip)
#line 865
{
#line 865
    int err=NC_NOERR;
#line 865
    ix_short xx;
#line 865
    get_ix_short(xp, &xx);
#line 865

#line 865
#if IX_SHORT_MAX > SCHAR_MAX
#line 865
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 865
#ifdef ERANGE_FILL
#line 865
        *ip = NC_FILL_BYTE;
#line 865
        return NC_ERANGE;
#line 865
#else
#line 865
        err = NC_ERANGE;
#line 865
#endif
#line 865
    }
#line 865
#endif
#line 865

#line 865

#line 865
    *ip = (schar) xx;
#line 865
    return err;
#line 865
}
#line 865

static int
#line 866
ncx_get_short_short(const void *xp, short *ip)
#line 866
{
#line 866
    int err=NC_NOERR;
#line 866
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 866
    get_ix_short(xp, (ix_short *)ip);
#line 866
#else
#line 866
    ix_short xx;
#line 866
    get_ix_short(xp, &xx);
#line 866

#line 866
#if IX_SHORT_MAX > SHORT_MAX
#line 866
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 866
#ifdef ERANGE_FILL
#line 866
        *ip = NC_FILL_SHORT;
#line 866
        return NC_ERANGE;
#line 866
#else
#line 866
        err = NC_ERANGE;
#line 866
#endif
#line 866
    }
#line 866
#endif
#line 866

#line 866

#line 866
    *ip = (short) xx;
#line 866
#endif
#line 866
    return err;
#line 866
}
#line 866

static int
#line 867
ncx_get_short_int(const void *xp, int *ip)
#line 867
{
#line 867
    int err=NC_NOERR;
#line 867
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 867
    get_ix_short(xp, (ix_short *)ip);
#line 867
#else
#line 867
    ix_short xx;
#line 867
    get_ix_short(xp, &xx);
#line 867

#line 867
#if IX_SHORT_MAX > INT_MAX
#line 867
    if (xx > INT_MAX || xx < INT_MIN) {
#line 867
#ifdef ERANGE_FILL
#line 867
        *ip = NC_FILL_INT;
#line 867
        return NC_ERANGE;
#line 867
#else
#line 867
        err = NC_ERANGE;
#line 867
#endif
#line 867
    }
#line 867
#endif
#line 867

#line 867

#line 867
    *ip = (int) xx;
#line 867
#endif
#line 867
    return err;
#line 867
}
#line 867

static int
#line 868
ncx_get_short_long(const void *xp, long *ip)
#line 868
{
#line 868
    int err=NC_NOERR;
#line 868
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 868
    get_ix_short(xp, (ix_short *)ip);
#line 868
#else
#line 868
    ix_short xx;
#line 868
    get_ix_short(xp, &xx);
#line 868

#line 868
#if IX_SHORT_MAX > LONG_MAX
#line 868
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 868
#ifdef ERANGE_FILL
#line 868
        *ip = NC_FILL_INT;
#line 868
        return NC_ERANGE;
#line 868
#else
#line 868
        err = NC_ERANGE;
#line 868
#endif
#line 868
    }
#line 868
#endif
#line 868

#line 868

#line 868
    *ip = (long) xx;
#line 868
#endif
#line 868
    return err;
#line 868
}
#line 868

static int
#line 869
ncx_get_short_longlong(const void *xp, longlong *ip)
#line 869
{
#line 869
    int err=NC_NOERR;
#line 869
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 869
    get_ix_short(xp, (ix_short *)ip);
#line 869
#else
#line 869
    ix_short xx;
#line 869
    get_ix_short(xp, &xx);
#line 869

#line 869
#if IX_SHORT_MAX > LONGLONG_MAX
#line 869
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 869
#ifdef ERANGE_FILL
#line 869
        *ip = NC_FILL_INT64;
#line 869
        return NC_ERANGE;
#line 869
#else
#line 869
        err = NC_ERANGE;
#line 869
#endif
#line 869
    }
#line 869
#endif
#line 869

#line 869

#line 869
    *ip = (longlong) xx;
#line 869
#endif
#line 869
    return err;
#line 869
}
#line 869

static int
#line 870
ncx_get_short_ushort(const void *xp, ushort *ip)
#line 870
{
#line 870
    int err=NC_NOERR;
#line 870
    ix_short xx;
#line 870
    get_ix_short(xp, &xx);
#line 870

#line 870
#if IX_SHORT_MAX > USHORT_MAX
#line 870
    if (xx > USHORT_MAX) {
#line 870
#ifdef ERANGE_FILL
#line 870
        *ip = NC_FILL_USHORT;
#line 870
        return NC_ERANGE;
#line 870
#else
#line 870
        err = NC_ERANGE;
#line 870
#endif
#line 870
    }
#line 870
#endif
#line 870

#line 870
    if (xx < 0) {
#line 870
#ifdef ERANGE_FILL
#line 870
        *ip = NC_FILL_USHORT;
#line 870
        return NC_ERANGE;
#line 870
#else
#line 870
        err = NC_ERANGE; /* because ip is unsigned */
#line 870
#endif
#line 870
    }
#line 870
    *ip = (ushort) xx;
#line 870
    return err;
#line 870
}
#line 870

static int
#line 871
ncx_get_short_uchar(const void *xp, uchar *ip)
#line 871
{
#line 871
    int err=NC_NOERR;
#line 871
    ix_short xx;
#line 871
    get_ix_short(xp, &xx);
#line 871

#line 871
#if IX_SHORT_MAX > UCHAR_MAX
#line 871
    if (xx > UCHAR_MAX) {
#line 871
#ifdef ERANGE_FILL
#line 871
        *ip = NC_FILL_UBYTE;
#line 871
        return NC_ERANGE;
#line 871
#else
#line 871
        err = NC_ERANGE;
#line 871
#endif
#line 871
    }
#line 871
#endif
#line 871

#line 871
    if (xx < 0) {
#line 871
#ifdef ERANGE_FILL
#line 871
        *ip = NC_FILL_UBYTE;
#line 871
        return NC_ERANGE;
#line 871
#else
#line 871
        err = NC_ERANGE; /* because ip is unsigned */
#line 871
#endif
#line 871
    }
#line 871
    *ip = (uchar) xx;
#line 871
    return err;
#line 871
}
#line 871

static int
#line 872
ncx_get_short_uint(const void *xp, uint *ip)
#line 872
{
#line 872
    int err=NC_NOERR;
#line 872
    ix_short xx;
#line 872
    get_ix_short(xp, &xx);
#line 872

#line 872
#if IX_SHORT_MAX > UINT_MAX
#line 872
    if (xx > UINT_MAX) {
#line 872
#ifdef ERANGE_FILL
#line 872
        *ip = NC_FILL_UINT;
#line 872
        return NC_ERANGE;
#line 872
#else
#line 872
        err = NC_ERANGE;
#line 872
#endif
#line 872
    }
#line 872
#endif
#line 872

#line 872
    if (xx < 0) {
#line 872
#ifdef ERANGE_FILL
#line 872
        *ip = NC_FILL_UINT;
#line 872
        return NC_ERANGE;
#line 872
#else
#line 872
        err = NC_ERANGE; /* because ip is unsigned */
#line 872
#endif
#line 872
    }
#line 872
    *ip = (uint) xx;
#line 872
    return err;
#line 872
}
#line 872

static int
#line 873
ncx_get_short_ulonglong(const void *xp, ulonglong *ip)
#line 873
{
#line 873
    int err=NC_NOERR;
#line 873
    ix_short xx;
#line 873
    get_ix_short(xp, &xx);
#line 873

#line 873
#if IX_SHORT_MAX > ULONGLONG_MAX
#line 873
    if (xx > ULONGLONG_MAX) {
#line 873
#ifdef ERANGE_FILL
#line 873
        *ip = NC_FILL_UINT64;
#line 873
        return NC_ERANGE;
#line 873
#else
#line 873
        err = NC_ERANGE;
#line 873
#endif
#line 873
    }
#line 873
#endif
#line 873

#line 873
    if (xx < 0) {
#line 873
#ifdef ERANGE_FILL
#line 873
        *ip = NC_FILL_UINT64;
#line 873
        return NC_ERANGE;
#line 873
#else
#line 873
        err = NC_ERANGE; /* because ip is unsigned */
#line 873
#endif
#line 873
    }
#line 873
    *ip = (ulonglong) xx;
#line 873
    return err;
#line 873
}
#line 873

static int
#line 874
ncx_get_short_float(const void *xp, float *ip)
#line 874
{
#line 874
	ix_short xx;
#line 874
	get_ix_short(xp, &xx);
#line 874
	*ip = (float)xx;
#line 874
	return NC_NOERR;
#line 874
}
#line 874

static int
#line 875
ncx_get_short_double(const void *xp, double *ip)
#line 875
{
#line 875
	ix_short xx;
#line 875
	get_ix_short(xp, &xx);
#line 875
	*ip = (double)xx;
#line 875
	return NC_NOERR;
#line 875
}
#line 875


static int
ncx_put_short_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_short_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 898
ncx_put_short_short(void *xp, const short *ip, void *fillp)
#line 898
{
#line 898
    int err=NC_NOERR;
#line 898
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 898
    put_ix_short(xp, (const ix_short *)ip);
#line 898
#else
#line 898
    ix_short xx = NC_FILL_SHORT;
#line 898

#line 898
#if IX_SHORT_MAX < SHORT_MAX
#line 898
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 898
        
#line 898
#ifdef ERANGE_FILL
#line 898
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 898
#endif
#line 898
        err = NC_ERANGE;
#line 898
    }
#line 898
#ifdef ERANGE_FILL
#line 898
    else
#line 898
#endif
#line 898
#endif
#line 898
        xx = (ix_short)*ip;
#line 898

#line 898
    put_ix_short(xp, &xx);
#line 898
#endif
#line 898
    return err;
#line 898
}
#line 898

static int
#line 899
ncx_put_short_int(void *xp, const int *ip, void *fillp)
#line 899
{
#line 899
    int err=NC_NOERR;
#line 899
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 899
    put_ix_short(xp, (const ix_short *)ip);
#line 899
#else
#line 899
    ix_short xx = NC_FILL_SHORT;
#line 899

#line 899
#if IX_SHORT_MAX < INT_MAX
#line 899
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 899
        
#line 899
#ifdef ERANGE_FILL
#line 899
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 899
#endif
#line 899
        err = NC_ERANGE;
#line 899
    }
#line 899
#ifdef ERANGE_FILL
#line 899
    else
#line 899
#endif
#line 899
#endif
#line 899
        xx = (ix_short)*ip;
#line 899

#line 899
    put_ix_short(xp, &xx);
#line 899
#endif
#line 899
    return err;
#line 899
}
#line 899

static int
#line 900
ncx_put_short_long(void *xp, const long *ip, void *fillp)
#line 900
{
#line 900
    int err=NC_NOERR;
#line 900
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 900
    put_ix_short(xp, (const ix_short *)ip);
#line 900
#else
#line 900
    ix_short xx = NC_FILL_SHORT;
#line 900

#line 900
#if IX_SHORT_MAX < LONG_MAX
#line 900
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 900
        
#line 900
#ifdef ERANGE_FILL
#line 900
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 900
#endif
#line 900
        err = NC_ERANGE;
#line 900
    }
#line 900
#ifdef ERANGE_FILL
#line 900
    else
#line 900
#endif
#line 900
#endif
#line 900
        xx = (ix_short)*ip;
#line 900

#line 900
    put_ix_short(xp, &xx);
#line 900
#endif
#line 900
    return err;
#line 900
}
#line 900

static int
#line 901
ncx_put_short_longlong(void *xp, const longlong *ip, void *fillp)
#line 901
{
#line 901
    int err=NC_NOERR;
#line 901
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 901
    put_ix_short(xp, (const ix_short *)ip);
#line 901
#else
#line 901
    ix_short xx = NC_FILL_SHORT;
#line 901

#line 901
#if IX_SHORT_MAX < LONGLONG_MAX
#line 901
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 901
        
#line 901
#ifdef ERANGE_FILL
#line 901
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 901
#endif
#line 901
        err = NC_ERANGE;
#line 901
    }
#line 901
#ifdef ERANGE_FILL
#line 901
    else
#line 901
#endif
#line 901
#endif
#line 901
        xx = (ix_short)*ip;
#line 901

#line 901
    put_ix_short(xp, &xx);
#line 901
#endif
#line 901
    return err;
#line 901
}
#line 901

static int
#line 902
ncx_put_short_ushort(void *xp, const ushort *ip, void *fillp)
#line 902
{
#line 902
    int err=NC_NOERR;
#line 902
    ix_short xx = NC_FILL_SHORT;
#line 902

#line 902
#if IX_SHORT_MAX < USHORT_MAX
#line 902
    if (*ip > IX_SHORT_MAX) {
#line 902
        
#line 902
#ifdef ERANGE_FILL
#line 902
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 902
#endif
#line 902
        err = NC_ERANGE;
#line 902
    }
#line 902
#ifdef ERANGE_FILL
#line 902
    else
#line 902
#endif
#line 902
#endif
#line 902
        xx = (ix_short)*ip;
#line 902

#line 902
    put_ix_short(xp, &xx);
#line 902
    return err;
#line 902
}
#line 902

static int
#line 903
ncx_put_short_uint(void *xp, const uint *ip, void *fillp)
#line 903
{
#line 903
    int err=NC_NOERR;
#line 903
    ix_short xx = NC_FILL_SHORT;
#line 903

#line 903
#if IX_SHORT_MAX < UINT_MAX
#line 903
    if (*ip > IX_SHORT_MAX) {
#line 903
        
#line 903
#ifdef ERANGE_FILL
#line 903
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 903
#endif
#line 903
        err = NC_ERANGE;
#line 903
    }
#line 903
#ifdef ERANGE_FILL
#line 903
    else
#line 903
#endif
#line 903
#endif
#line 903
        xx = (ix_short)*ip;
#line 903

#line 903
    put_ix_short(xp, &xx);
#line 903
    return err;
#line 903
}
#line 903

static int
#line 904
ncx_put_short_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 904
{
#line 904
    int err=NC_NOERR;
#line 904
    ix_short xx = NC_FILL_SHORT;
#line 904

#line 904
#if IX_SHORT_MAX < ULONGLONG_MAX
#line 904
    if (*ip > IX_SHORT_MAX) {
#line 904
        
#line 904
#ifdef ERANGE_FILL
#line 904
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 904
#endif
#line 904
        err = NC_ERANGE;
#line 904
    }
#line 904
#ifdef ERANGE_FILL
#line 904
    else
#line 904
#endif
#line 904
#endif
#line 904
        xx = (ix_short)*ip;
#line 904

#line 904
    put_ix_short(xp, &xx);
#line 904
    return err;
#line 904
}
#line 904

static int
#line 905
ncx_put_short_float(void *xp, const float *ip, void *fillp)
#line 905
{
#line 905
    int err=NC_NOERR;
#line 905
    ix_short xx = NC_FILL_SHORT;
#line 905

#line 905
    if (*ip > (double)X_SHORT_MAX || *ip < (double)X_SHORT_MIN) {
#line 905
        
#line 905
#ifdef ERANGE_FILL
#line 905
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 905
#endif
#line 905
        err = NC_ERANGE;
#line 905
    }
#line 905
#ifdef ERANGE_FILL
#line 905
    else
#line 905
#endif
#line 905
        xx = (ix_short)*ip;
#line 905

#line 905
    put_ix_short(xp, &xx);
#line 905
    return err;
#line 905
}
#line 905

static int
#line 906
ncx_put_short_double(void *xp, const double *ip, void *fillp)
#line 906
{
#line 906
    int err=NC_NOERR;
#line 906
    ix_short xx = NC_FILL_SHORT;
#line 906

#line 906
    if (*ip > X_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 906
        
#line 906
#ifdef ERANGE_FILL
#line 906
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 906
#endif
#line 906
        err = NC_ERANGE;
#line 906
    }
#line 906
#ifdef ERANGE_FILL
#line 906
    else
#line 906
#endif
#line 906
        xx = (ix_short)*ip;
#line 906

#line 906
    put_ix_short(xp, &xx);
#line 906
    return err;
#line 906
}
#line 906


/* external NC_USHORT -------------------------------------------------------*/

#if USHORT_MAX == X_USHORT_MAX
typedef unsigned short ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_USHORT
#define IX_USHORT_MAX USHORT_MAX
#elif UINT_MAX >= X_USHORT_MAX
typedef unsigned int ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_UINT
#define IX_USHORT_MAX UINT_MAX
#elif ULONG_MAX >= X_USHORT_MAX
typedef unsigned long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG
#define IX_USHORT_MAX ULONG_MAX
#elif ULLONG_MAX >= X_USHORT_MAX
typedef unsigned long long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONGLONG
#define IX_USHORT_MAX ULLONG_MAX
#else
#error "ix_ushort implementation"
#endif

static void
get_ix_ushort(const void *xp, ix_ushort *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_ushort)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_ushort)(*ip | *cp);
}

static void
put_ix_ushort(void *xp, const ix_ushort *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 953
ncx_get_ushort_schar(const void *xp, schar *ip)
#line 953
{
#line 953
    int err=NC_NOERR;
#line 953
    ix_ushort xx;
#line 953
    get_ix_ushort(xp, &xx);
#line 953

#line 953
#if IX_USHORT_MAX > SCHAR_MAX
#line 953
    if (xx > SCHAR_MAX) {
#line 953
#ifdef ERANGE_FILL
#line 953
        *ip = NC_FILL_BYTE;
#line 953
        return NC_ERANGE;
#line 953
#else
#line 953
        err = NC_ERANGE;
#line 953
#endif
#line 953
    }
#line 953
#endif
#line 953

#line 953

#line 953
    *ip = (schar) xx;
#line 953
    return err;
#line 953
}
#line 953

static int
#line 954
ncx_get_ushort_short(const void *xp, short *ip)
#line 954
{
#line 954
    int err=NC_NOERR;
#line 954
    ix_ushort xx;
#line 954
    get_ix_ushort(xp, &xx);
#line 954

#line 954
#if IX_USHORT_MAX > SHORT_MAX
#line 954
    if (xx > SHORT_MAX) {
#line 954
#ifdef ERANGE_FILL
#line 954
        *ip = NC_FILL_SHORT;
#line 954
        return NC_ERANGE;
#line 954
#else
#line 954
        err = NC_ERANGE;
#line 954
#endif
#line 954
    }
#line 954
#endif
#line 954

#line 954

#line 954
    *ip = (short) xx;
#line 954
    return err;
#line 954
}
#line 954

static int
#line 955
ncx_get_ushort_int(const void *xp, int *ip)
#line 955
{
#line 955
    int err=NC_NOERR;
#line 955
    ix_ushort xx;
#line 955
    get_ix_ushort(xp, &xx);
#line 955

#line 955
#if IX_USHORT_MAX > INT_MAX
#line 955
    if (xx > INT_MAX) {
#line 955
#ifdef ERANGE_FILL
#line 955
        *ip = NC_FILL_INT;
#line 955
        return NC_ERANGE;
#line 955
#else
#line 955
        err = NC_ERANGE;
#line 955
#endif
#line 955
    }
#line 955
#endif
#line 955

#line 955

#line 955
    *ip = (int) xx;
#line 955
    return err;
#line 955
}
#line 955

static int
#line 956
ncx_get_ushort_long(const void *xp, long *ip)
#line 956
{
#line 956
    int err=NC_NOERR;
#line 956
    ix_ushort xx;
#line 956
    get_ix_ushort(xp, &xx);
#line 956

#line 956
#if IX_USHORT_MAX > LONG_MAX
#line 956
    if (xx > LONG_MAX) {
#line 956
#ifdef ERANGE_FILL
#line 956
        *ip = NC_FILL_INT;
#line 956
        return NC_ERANGE;
#line 956
#else
#line 956
        err = NC_ERANGE;
#line 956
#endif
#line 956
    }
#line 956
#endif
#line 956

#line 956

#line 956
    *ip = (long) xx;
#line 956
    return err;
#line 956
}
#line 956

static int
#line 957
ncx_get_ushort_longlong(const void *xp, longlong *ip)
#line 957
{
#line 957
    int err=NC_NOERR;
#line 957
    ix_ushort xx;
#line 957
    get_ix_ushort(xp, &xx);
#line 957

#line 957
#if IX_USHORT_MAX > LONGLONG_MAX
#line 957
    if (xx > LONGLONG_MAX) {
#line 957
#ifdef ERANGE_FILL
#line 957
        *ip = NC_FILL_INT64;
#line 957
        return NC_ERANGE;
#line 957
#else
#line 957
        err = NC_ERANGE;
#line 957
#endif
#line 957
    }
#line 957
#endif
#line 957

#line 957

#line 957
    *ip = (longlong) xx;
#line 957
    return err;
#line 957
}
#line 957

static int
#line 958
ncx_get_ushort_ushort(const void *xp, ushort *ip)
#line 958
{
#line 958
    int err=NC_NOERR;
#line 958
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 958
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 958
#else
#line 958
    ix_ushort xx;
#line 958
    get_ix_ushort(xp, &xx);
#line 958

#line 958
#if IX_USHORT_MAX > USHORT_MAX
#line 958
    if (xx > USHORT_MAX) {
#line 958
#ifdef ERANGE_FILL
#line 958
        *ip = NC_FILL_USHORT;
#line 958
        return NC_ERANGE;
#line 958
#else
#line 958
        err = NC_ERANGE;
#line 958
#endif
#line 958
    }
#line 958
#endif
#line 958

#line 958

#line 958
    *ip = (ushort) xx;
#line 958
#endif
#line 958
    return err;
#line 958
}
#line 958

static int
#line 959
ncx_get_ushort_uchar(const void *xp, uchar *ip)
#line 959
{
#line 959
    int err=NC_NOERR;
#line 959
#if SIZEOF_IX_USHORT == SIZEOF_UCHAR && IX_USHORT_MAX == UCHAR_MAX
#line 959
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 959
#else
#line 959
    ix_ushort xx;
#line 959
    get_ix_ushort(xp, &xx);
#line 959

#line 959
#if IX_USHORT_MAX > UCHAR_MAX
#line 959
    if (xx > UCHAR_MAX) {
#line 959
#ifdef ERANGE_FILL
#line 959
        *ip = NC_FILL_UBYTE;
#line 959
        return NC_ERANGE;
#line 959
#else
#line 959
        err = NC_ERANGE;
#line 959
#endif
#line 959
    }
#line 959
#endif
#line 959

#line 959

#line 959
    *ip = (uchar) xx;
#line 959
#endif
#line 959
    return err;
#line 959
}
#line 959

static int
#line 960
ncx_get_ushort_uint(const void *xp, uint *ip)
#line 960
{
#line 960
    int err=NC_NOERR;
#line 960
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 960
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 960
#else
#line 960
    ix_ushort xx;
#line 960
    get_ix_ushort(xp, &xx);
#line 960

#line 960
#if IX_USHORT_MAX > UINT_MAX
#line 960
    if (xx > UINT_MAX) {
#line 960
#ifdef ERANGE_FILL
#line 960
        *ip = NC_FILL_UINT;
#line 960
        return NC_ERANGE;
#line 960
#else
#line 960
        err = NC_ERANGE;
#line 960
#endif
#line 960
    }
#line 960
#endif
#line 960

#line 960

#line 960
    *ip = (uint) xx;
#line 960
#endif
#line 960
    return err;
#line 960
}
#line 960

static int
#line 961
ncx_get_ushort_ulonglong(const void *xp, ulonglong *ip)
#line 961
{
#line 961
    int err=NC_NOERR;
#line 961
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 961
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 961
#else
#line 961
    ix_ushort xx;
#line 961
    get_ix_ushort(xp, &xx);
#line 961

#line 961
#if IX_USHORT_MAX > ULONGLONG_MAX
#line 961
    if (xx > ULONGLONG_MAX) {
#line 961
#ifdef ERANGE_FILL
#line 961
        *ip = NC_FILL_UINT64;
#line 961
        return NC_ERANGE;
#line 961
#else
#line 961
        err = NC_ERANGE;
#line 961
#endif
#line 961
    }
#line 961
#endif
#line 961

#line 961

#line 961
    *ip = (ulonglong) xx;
#line 961
#endif
#line 961
    return err;
#line 961
}
#line 961

static int
#line 962
ncx_get_ushort_float(const void *xp, float *ip)
#line 962
{
#line 962
	ix_ushort xx;
#line 962
	get_ix_ushort(xp, &xx);
#line 962
	*ip = (float)xx;
#line 962
	return NC_NOERR;
#line 962
}
#line 962

static int
#line 963
ncx_get_ushort_double(const void *xp, double *ip)
#line 963
{
#line 963
	ix_ushort xx;
#line 963
	get_ix_ushort(xp, &xx);
#line 963
	*ip = (double)xx;
#line 963
	return NC_NOERR;
#line 963
}
#line 963


static int
ncx_put_ushort_schar(void *xp, const schar *ip, void *fillp)
{
    int err=NC_NOERR;
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 2);
#ifndef WORDS_BIGENDIAN
        swapn2b(xp, xp, 1);
#endif
        return NC_ERANGE;
#else
        err = NC_ERANGE;
#endif
    }

    cp = (uchar *) xp;
    if (*ip & 0x80)
        *cp++ = 0xff;
    else
        *cp++ = 0;
    *cp = (uchar)*ip;

    return err;
}

static int
ncx_put_ushort_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 1001
ncx_put_ushort_short(void *xp, const short *ip, void *fillp)
#line 1001
{
#line 1001
    int err=NC_NOERR;
#line 1001
    ix_ushort xx = NC_FILL_USHORT;
#line 1001

#line 1001
#if IX_USHORT_MAX < SHORT_MAX
#line 1001
    if (*ip > IX_USHORT_MAX) {
#line 1001
        
#line 1001
#ifdef ERANGE_FILL
#line 1001
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1001
#endif
#line 1001
        err = NC_ERANGE;
#line 1001
    }
#line 1001
#ifdef ERANGE_FILL
#line 1001
    else
#line 1001
#endif
#line 1001
#endif
#line 1001
    if (*ip < 0) {
#line 1001
        
#line 1001
#ifdef ERANGE_FILL
#line 1001
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1001
#endif
#line 1001
        err = NC_ERANGE; /* because xp is unsigned */
#line 1001
    }
#line 1001
#ifdef ERANGE_FILL
#line 1001
    else
#line 1001
#endif
#line 1001
        xx = (ix_ushort)*ip;
#line 1001

#line 1001
    put_ix_ushort(xp, &xx);
#line 1001
    return err;
#line 1001
}
#line 1001

static int
#line 1002
ncx_put_ushort_int(void *xp, const int *ip, void *fillp)
#line 1002
{
#line 1002
    int err=NC_NOERR;
#line 1002
    ix_ushort xx = NC_FILL_USHORT;
#line 1002

#line 1002
#if IX_USHORT_MAX < INT_MAX
#line 1002
    if (*ip > IX_USHORT_MAX) {
#line 1002
        
#line 1002
#ifdef ERANGE_FILL
#line 1002
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1002
#endif
#line 1002
        err = NC_ERANGE;
#line 1002
    }
#line 1002
#ifdef ERANGE_FILL
#line 1002
    else
#line 1002
#endif
#line 1002
#endif
#line 1002
    if (*ip < 0) {
#line 1002
        
#line 1002
#ifdef ERANGE_FILL
#line 1002
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1002
#endif
#line 1002
        err = NC_ERANGE; /* because xp is unsigned */
#line 1002
    }
#line 1002
#ifdef ERANGE_FILL
#line 1002
    else
#line 1002
#endif
#line 1002
        xx = (ix_ushort)*ip;
#line 1002

#line 1002
    put_ix_ushort(xp, &xx);
#line 1002
    return err;
#line 1002
}
#line 1002

static int
#line 1003
ncx_put_ushort_long(void *xp, const long *ip, void *fillp)
#line 1003
{
#line 1003
    int err=NC_NOERR;
#line 1003
    ix_ushort xx = NC_FILL_USHORT;
#line 1003

#line 1003
#if IX_USHORT_MAX < LONG_MAX
#line 1003
    if (*ip > IX_USHORT_MAX) {
#line 1003
        
#line 1003
#ifdef ERANGE_FILL
#line 1003
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1003
#endif
#line 1003
        err = NC_ERANGE;
#line 1003
    }
#line 1003
#ifdef ERANGE_FILL
#line 1003
    else
#line 1003
#endif
#line 1003
#endif
#line 1003
    if (*ip < 0) {
#line 1003
        
#line 1003
#ifdef ERANGE_FILL
#line 1003
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1003
#endif
#line 1003
        err = NC_ERANGE; /* because xp is unsigned */
#line 1003
    }
#line 1003
#ifdef ERANGE_FILL
#line 1003
    else
#line 1003
#endif
#line 1003
        xx = (ix_ushort)*ip;
#line 1003

#line 1003
    put_ix_ushort(xp, &xx);
#line 1003
    return err;
#line 1003
}
#line 1003

static int
#line 1004
ncx_put_ushort_longlong(void *xp, const longlong *ip, void *fillp)
#line 1004
{
#line 1004
    int err=NC_NOERR;
#line 1004
    ix_ushort xx = NC_FILL_USHORT;
#line 1004

#line 1004
#if IX_USHORT_MAX < LONGLONG_MAX
#line 1004
    if (*ip > IX_USHORT_MAX) {
#line 1004
        
#line 1004
#ifdef ERANGE_FILL
#line 1004
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1004
#endif
#line 1004
        err = NC_ERANGE;
#line 1004
    }
#line 1004
#ifdef ERANGE_FILL
#line 1004
    else
#line 1004
#endif
#line 1004
#endif
#line 1004
    if (*ip < 0) {
#line 1004
        
#line 1004
#ifdef ERANGE_FILL
#line 1004
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1004
#endif
#line 1004
        err = NC_ERANGE; /* because xp is unsigned */
#line 1004
    }
#line 1004
#ifdef ERANGE_FILL
#line 1004
    else
#line 1004
#endif
#line 1004
        xx = (ix_ushort)*ip;
#line 1004

#line 1004
    put_ix_ushort(xp, &xx);
#line 1004
    return err;
#line 1004
}
#line 1004

static int
#line 1005
ncx_put_ushort_ushort(void *xp, const ushort *ip, void *fillp)
#line 1005
{
#line 1005
    int err=NC_NOERR;
#line 1005
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 1005
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1005
#else
#line 1005
    ix_ushort xx = NC_FILL_USHORT;
#line 1005

#line 1005
#if IX_USHORT_MAX < USHORT_MAX
#line 1005
    if (*ip > IX_USHORT_MAX) {
#line 1005
        
#line 1005
#ifdef ERANGE_FILL
#line 1005
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1005
#endif
#line 1005
        err = NC_ERANGE;
#line 1005
    }
#line 1005
#ifdef ERANGE_FILL
#line 1005
    else
#line 1005
#endif
#line 1005
#endif
#line 1005
        xx = (ix_ushort)*ip;
#line 1005

#line 1005
    put_ix_ushort(xp, &xx);
#line 1005
#endif
#line 1005
    return err;
#line 1005
}
#line 1005

static int
#line 1006
ncx_put_ushort_uint(void *xp, const uint *ip, void *fillp)
#line 1006
{
#line 1006
    int err=NC_NOERR;
#line 1006
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 1006
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1006
#else
#line 1006
    ix_ushort xx = NC_FILL_USHORT;
#line 1006

#line 1006
#if IX_USHORT_MAX < UINT_MAX
#line 1006
    if (*ip > IX_USHORT_MAX) {
#line 1006
        
#line 1006
#ifdef ERANGE_FILL
#line 1006
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1006
#endif
#line 1006
        err = NC_ERANGE;
#line 1006
    }
#line 1006
#ifdef ERANGE_FILL
#line 1006
    else
#line 1006
#endif
#line 1006
#endif
#line 1006
        xx = (ix_ushort)*ip;
#line 1006

#line 1006
    put_ix_ushort(xp, &xx);
#line 1006
#endif
#line 1006
    return err;
#line 1006
}
#line 1006

static int
#line 1007
ncx_put_ushort_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1007
{
#line 1007
    int err=NC_NOERR;
#line 1007
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 1007
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1007
#else
#line 1007
    ix_ushort xx = NC_FILL_USHORT;
#line 1007

#line 1007
#if IX_USHORT_MAX < ULONGLONG_MAX
#line 1007
    if (*ip > IX_USHORT_MAX) {
#line 1007
        
#line 1007
#ifdef ERANGE_FILL
#line 1007
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1007
#endif
#line 1007
        err = NC_ERANGE;
#line 1007
    }
#line 1007
#ifdef ERANGE_FILL
#line 1007
    else
#line 1007
#endif
#line 1007
#endif
#line 1007
        xx = (ix_ushort)*ip;
#line 1007

#line 1007
    put_ix_ushort(xp, &xx);
#line 1007
#endif
#line 1007
    return err;
#line 1007
}
#line 1007

static int
#line 1008
ncx_put_ushort_float(void *xp, const float *ip, void *fillp)
#line 1008
{
#line 1008
    int err=NC_NOERR;
#line 1008
    ix_ushort xx = NC_FILL_USHORT;
#line 1008

#line 1008
    if (*ip > (double)X_USHORT_MAX || *ip < 0) {
#line 1008
        
#line 1008
#ifdef ERANGE_FILL
#line 1008
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1008
#endif
#line 1008
        err = NC_ERANGE;
#line 1008
    }
#line 1008
#ifdef ERANGE_FILL
#line 1008
    else
#line 1008
#endif
#line 1008
        xx = (ix_ushort)*ip;
#line 1008

#line 1008
    put_ix_ushort(xp, &xx);
#line 1008
    return err;
#line 1008
}
#line 1008

static int
#line 1009
ncx_put_ushort_double(void *xp, const double *ip, void *fillp)
#line 1009
{
#line 1009
    int err=NC_NOERR;
#line 1009
    ix_ushort xx = NC_FILL_USHORT;
#line 1009

#line 1009
    if (*ip > X_USHORT_MAX || *ip < 0) {
#line 1009
        
#line 1009
#ifdef ERANGE_FILL
#line 1009
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1009
#endif
#line 1009
        err = NC_ERANGE;
#line 1009
    }
#line 1009
#ifdef ERANGE_FILL
#line 1009
    else
#line 1009
#endif
#line 1009
        xx = (ix_ushort)*ip;
#line 1009

#line 1009
    put_ix_ushort(xp, &xx);
#line 1009
    return err;
#line 1009
}
#line 1009


/* external NC_INT ----------------------------------------------------------*/

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

#if INT_MAX  >= X_INT_MAX
	*ip = (ix_int)((unsigned)(*cp++) << 24);
#else
	*ip = *cp++ << 24;
#endif
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if (*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)( (*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 1064
ncx_get_int_int(const void *xp, int *ip)
#line 1064
{
#line 1064
    int err=NC_NOERR;
#line 1064
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 1064
    get_ix_int(xp, (ix_int *)ip);
#line 1064
#else
#line 1064
    ix_int xx;
#line 1064
    get_ix_int(xp, &xx);
#line 1064

#line 1064
#if IX_INT_MAX > INT_MAX
#line 1064
    if (xx > INT_MAX || xx < INT_MIN) {
#line 1064
#ifdef ERANGE_FILL
#line 1064
        *ip = NC_FILL_INT;
#line 1064
        return NC_ERANGE;
#line 1064
#else
#line 1064
        err = NC_ERANGE;
#line 1064
#endif
#line 1064
    }
#line 1064
#endif
#line 1064

#line 1064

#line 1064
    *ip = (int) xx;
#line 1064
#endif
#line 1064
    return err;
#line 1064
}
#line 1064

#endif
static int
#line 1066
ncx_get_int_schar(const void *xp, schar *ip)
#line 1066
{
#line 1066
    int err=NC_NOERR;
#line 1066
    ix_int xx;
#line 1066
    get_ix_int(xp, &xx);
#line 1066

#line 1066
#if IX_INT_MAX > SCHAR_MAX
#line 1066
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 1066
#ifdef ERANGE_FILL
#line 1066
        *ip = NC_FILL_BYTE;
#line 1066
        return NC_ERANGE;
#line 1066
#else
#line 1066
        err = NC_ERANGE;
#line 1066
#endif
#line 1066
    }
#line 1066
#endif
#line 1066

#line 1066

#line 1066
    *ip = (schar) xx;
#line 1066
    return err;
#line 1066
}
#line 1066

static int
#line 1067
ncx_get_int_short(const void *xp, short *ip)
#line 1067
{
#line 1067
    int err=NC_NOERR;
#line 1067
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 1067
    get_ix_int(xp, (ix_int *)ip);
#line 1067
#else
#line 1067
    ix_int xx;
#line 1067
    get_ix_int(xp, &xx);
#line 1067

#line 1067
#if IX_INT_MAX > SHORT_MAX
#line 1067
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 1067
#ifdef ERANGE_FILL
#line 1067
        *ip = NC_FILL_SHORT;
#line 1067
        return NC_ERANGE;
#line 1067
#else
#line 1067
        err = NC_ERANGE;
#line 1067
#endif
#line 1067
    }
#line 1067
#endif
#line 1067

#line 1067

#line 1067
    *ip = (short) xx;
#line 1067
#endif
#line 1067
    return err;
#line 1067
}
#line 1067

static int
#line 1068
ncx_get_int_long(const void *xp, long *ip)
#line 1068
{
#line 1068
    int err=NC_NOERR;
#line 1068
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 1068
    get_ix_int(xp, (ix_int *)ip);
#line 1068
#else
#line 1068
    ix_int xx;
#line 1068
    get_ix_int(xp, &xx);
#line 1068

#line 1068
#if IX_INT_MAX > LONG_MAX
#line 1068
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 1068
#ifdef ERANGE_FILL
#line 1068
        *ip = NC_FILL_INT;
#line 1068
        return NC_ERANGE;
#line 1068
#else
#line 1068
        err = NC_ERANGE;
#line 1068
#endif
#line 1068
    }
#line 1068
#endif
#line 1068

#line 1068

#line 1068
    *ip = (long) xx;
#line 1068
#endif
#line 1068
    return err;
#line 1068
}
#line 1068

static int
#line 1069
ncx_get_int_longlong(const void *xp, longlong *ip)
#line 1069
{
#line 1069
    int err=NC_NOERR;
#line 1069
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 1069
    get_ix_int(xp, (ix_int *)ip);
#line 1069
#else
#line 1069
    ix_int xx;
#line 1069
    get_ix_int(xp, &xx);
#line 1069

#line 1069
#if IX_INT_MAX > LONGLONG_MAX
#line 1069
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 1069
#ifdef ERANGE_FILL
#line 1069
        *ip = NC_FILL_INT64;
#line 1069
        return NC_ERANGE;
#line 1069
#else
#line 1069
        err = NC_ERANGE;
#line 1069
#endif
#line 1069
    }
#line 1069
#endif
#line 1069

#line 1069

#line 1069
    *ip = (longlong) xx;
#line 1069
#endif
#line 1069
    return err;
#line 1069
}
#line 1069

static int
#line 1070
ncx_get_int_ushort(const void *xp, ushort *ip)
#line 1070
{
#line 1070
    int err=NC_NOERR;
#line 1070
    ix_int xx;
#line 1070
    get_ix_int(xp, &xx);
#line 1070

#line 1070
#if IX_INT_MAX > USHORT_MAX
#line 1070
    if (xx > USHORT_MAX) {
#line 1070
#ifdef ERANGE_FILL
#line 1070
        *ip = NC_FILL_USHORT;
#line 1070
        return NC_ERANGE;
#line 1070
#else
#line 1070
        err = NC_ERANGE;
#line 1070
#endif
#line 1070
    }
#line 1070
#endif
#line 1070

#line 1070
    if (xx < 0) {
#line 1070
#ifdef ERANGE_FILL
#line 1070
        *ip = NC_FILL_USHORT;
#line 1070
        return NC_ERANGE;
#line 1070
#else
#line 1070
        err = NC_ERANGE; /* because ip is unsigned */
#line 1070
#endif
#line 1070
    }
#line 1070
    *ip = (ushort) xx;
#line 1070
    return err;
#line 1070
}
#line 1070

static int
#line 1071
ncx_get_int_uchar(const void *xp, uchar *ip)
#line 1071
{
#line 1071
    int err=NC_NOERR;
#line 1071
    ix_int xx;
#line 1071
    get_ix_int(xp, &xx);
#line 1071

#line 1071
#if IX_INT_MAX > UCHAR_MAX
#line 1071
    if (xx > UCHAR_MAX) {
#line 1071
#ifdef ERANGE_FILL
#line 1071
        *ip = NC_FILL_UBYTE;
#line 1071
        return NC_ERANGE;
#line 1071
#else
#line 1071
        err = NC_ERANGE;
#line 1071
#endif
#line 1071
    }
#line 1071
#endif
#line 1071

#line 1071
    if (xx < 0) {
#line 1071
#ifdef ERANGE_FILL
#line 1071
        *ip = NC_FILL_UBYTE;
#line 1071
        return NC_ERANGE;
#line 1071
#else
#line 1071
        err = NC_ERANGE; /* because ip is unsigned */
#line 1071
#endif
#line 1071
    }
#line 1071
    *ip = (uchar) xx;
#line 1071
    return err;
#line 1071
}
#line 1071

static int
#line 1072
ncx_get_int_uint(const void *xp, uint *ip)
#line 1072
{
#line 1072
    int err=NC_NOERR;
#line 1072
    ix_int xx;
#line 1072
    get_ix_int(xp, &xx);
#line 1072

#line 1072
#if IX_INT_MAX > UINT_MAX
#line 1072
    if (xx > UINT_MAX) {
#line 1072
#ifdef ERANGE_FILL
#line 1072
        *ip = NC_FILL_UINT;
#line 1072
        return NC_ERANGE;
#line 1072
#else
#line 1072
        err = NC_ERANGE;
#line 1072
#endif
#line 1072
    }
#line 1072
#endif
#line 1072

#line 1072
    if (xx < 0) {
#line 1072
#ifdef ERANGE_FILL
#line 1072
        *ip = NC_FILL_UINT;
#line 1072
        return NC_ERANGE;
#line 1072
#else
#line 1072
        err = NC_ERANGE; /* because ip is unsigned */
#line 1072
#endif
#line 1072
    }
#line 1072
    *ip = (uint) xx;
#line 1072
    return err;
#line 1072
}
#line 1072

static int
#line 1073
ncx_get_int_ulonglong(const void *xp, ulonglong *ip)
#line 1073
{
#line 1073
    int err=NC_NOERR;
#line 1073
    ix_int xx;
#line 1073
    get_ix_int(xp, &xx);
#line 1073

#line 1073
#if IX_INT_MAX > ULONGLONG_MAX
#line 1073
    if (xx > ULONGLONG_MAX) {
#line 1073
#ifdef ERANGE_FILL
#line 1073
        *ip = NC_FILL_UINT64;
#line 1073
        return NC_ERANGE;
#line 1073
#else
#line 1073
        err = NC_ERANGE;
#line 1073
#endif
#line 1073
    }
#line 1073
#endif
#line 1073

#line 1073
    if (xx < 0) {
#line 1073
#ifdef ERANGE_FILL
#line 1073
        *ip = NC_FILL_UINT64;
#line 1073
        return NC_ERANGE;
#line 1073
#else
#line 1073
        err = NC_ERANGE; /* because ip is unsigned */
#line 1073
#endif
#line 1073
    }
#line 1073
    *ip = (ulonglong) xx;
#line 1073
    return err;
#line 1073
}
#line 1073

static int
#line 1074
ncx_get_int_float(const void *xp, float *ip)
#line 1074
{
#line 1074
	ix_int xx;
#line 1074
	get_ix_int(xp, &xx);
#line 1074
	*ip = (float)xx;
#line 1074
	return NC_NOERR;
#line 1074
}
#line 1074

static int
#line 1075
ncx_get_int_double(const void *xp, double *ip)
#line 1075
{
#line 1075
	ix_int xx;
#line 1075
	get_ix_int(xp, &xx);
#line 1075
	*ip = (double)xx;
#line 1075
	return NC_NOERR;
#line 1075
}
#line 1075


static int
ncx_put_int_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_int_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 1109
ncx_put_int_int(void *xp, const int *ip, void *fillp)
#line 1109
{
#line 1109
    int err=NC_NOERR;
#line 1109
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 1109
    put_ix_int(xp, (const ix_int *)ip);
#line 1109
#else
#line 1109
    ix_int xx = NC_FILL_INT;
#line 1109

#line 1109
#if IX_INT_MAX < INT_MAX
#line 1109
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1109
        
#line 1109
#ifdef ERANGE_FILL
#line 1109
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1109
#endif
#line 1109
        err = NC_ERANGE;
#line 1109
    }
#line 1109
#ifdef ERANGE_FILL
#line 1109
    else
#line 1109
#endif
#line 1109
#endif
#line 1109
        xx = (ix_int)*ip;
#line 1109

#line 1109
    put_ix_int(xp, &xx);
#line 1109
#endif
#line 1109
    return err;
#line 1109
}
#line 1109

#endif
static int
#line 1111
ncx_put_int_short(void *xp, const short *ip, void *fillp)
#line 1111
{
#line 1111
    int err=NC_NOERR;
#line 1111
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 1111
    put_ix_int(xp, (const ix_int *)ip);
#line 1111
#else
#line 1111
    ix_int xx = NC_FILL_INT;
#line 1111

#line 1111
#if IX_INT_MAX < SHORT_MAX
#line 1111
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1111
        
#line 1111
#ifdef ERANGE_FILL
#line 1111
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1111
#endif
#line 1111
        err = NC_ERANGE;
#line 1111
    }
#line 1111
#ifdef ERANGE_FILL
#line 1111
    else
#line 1111
#endif
#line 1111
#endif
#line 1111
        xx = (ix_int)*ip;
#line 1111

#line 1111
    put_ix_int(xp, &xx);
#line 1111
#endif
#line 1111
    return err;
#line 1111
}
#line 1111

static int
#line 1112
ncx_put_int_long(void *xp, const long *ip, void *fillp)
#line 1112
{
#line 1112
    int err=NC_NOERR;
#line 1112
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 1112
    put_ix_int(xp, (const ix_int *)ip);
#line 1112
#else
#line 1112
    ix_int xx = NC_FILL_INT;
#line 1112

#line 1112
#if IX_INT_MAX < LONG_MAX
#line 1112
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1112
        
#line 1112
#ifdef ERANGE_FILL
#line 1112
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1112
#endif
#line 1112
        err = NC_ERANGE;
#line 1112
    }
#line 1112
#ifdef ERANGE_FILL
#line 1112
    else
#line 1112
#endif
#line 1112
#endif
#line 1112
        xx = (ix_int)*ip;
#line 1112

#line 1112
    put_ix_int(xp, &xx);
#line 1112
#endif
#line 1112
    return err;
#line 1112
}
#line 1112

static int
#line 1113
ncx_put_int_longlong(void *xp, const longlong *ip, void *fillp)
#line 1113
{
#line 1113
    int err=NC_NOERR;
#line 1113
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 1113
    put_ix_int(xp, (const ix_int *)ip);
#line 1113
#else
#line 1113
    ix_int xx = NC_FILL_INT;
#line 1113

#line 1113
#if IX_INT_MAX < LONGLONG_MAX
#line 1113
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1113
        
#line 1113
#ifdef ERANGE_FILL
#line 1113
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1113
#endif
#line 1113
        err = NC_ERANGE;
#line 1113
    }
#line 1113
#ifdef ERANGE_FILL
#line 1113
    else
#line 1113
#endif
#line 1113
#endif
#line 1113
        xx = (ix_int)*ip;
#line 1113

#line 1113
    put_ix_int(xp, &xx);
#line 1113
#endif
#line 1113
    return err;
#line 1113
}
#line 1113

static int
#line 1114
ncx_put_int_ushort(void *xp, const ushort *ip, void *fillp)
#line 1114
{
#line 1114
    int err=NC_NOERR;
#line 1114
    ix_int xx = NC_FILL_INT;
#line 1114

#line 1114
#if IX_INT_MAX < USHORT_MAX
#line 1114
    if (*ip > IX_INT_MAX) {
#line 1114
        
#line 1114
#ifdef ERANGE_FILL
#line 1114
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1114
#endif
#line 1114
        err = NC_ERANGE;
#line 1114
    }
#line 1114
#ifdef ERANGE_FILL
#line 1114
    else
#line 1114
#endif
#line 1114
#endif
#line 1114
        xx = (ix_int)*ip;
#line 1114

#line 1114
    put_ix_int(xp, &xx);
#line 1114
    return err;
#line 1114
}
#line 1114

static int
#line 1115
ncx_put_int_uint(void *xp, const uint *ip, void *fillp)
#line 1115
{
#line 1115
    int err=NC_NOERR;
#line 1115
    ix_int xx = NC_FILL_INT;
#line 1115

#line 1115
#if IX_INT_MAX < UINT_MAX
#line 1115
    if (*ip > IX_INT_MAX) {
#line 1115
        
#line 1115
#ifdef ERANGE_FILL
#line 1115
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1115
#endif
#line 1115
        err = NC_ERANGE;
#line 1115
    }
#line 1115
#ifdef ERANGE_FILL
#line 1115
    else
#line 1115
#endif
#line 1115
#endif
#line 1115
        xx = (ix_int)*ip;
#line 1115

#line 1115
    put_ix_int(xp, &xx);
#line 1115
    return err;
#line 1115
}
#line 1115

static int
#line 1116
ncx_put_int_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1116
{
#line 1116
    int err=NC_NOERR;
#line 1116
    ix_int xx = NC_FILL_INT;
#line 1116

#line 1116
#if IX_INT_MAX < ULONGLONG_MAX
#line 1116
    if (*ip > IX_INT_MAX) {
#line 1116
        
#line 1116
#ifdef ERANGE_FILL
#line 1116
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1116
#endif
#line 1116
        err = NC_ERANGE;
#line 1116
    }
#line 1116
#ifdef ERANGE_FILL
#line 1116
    else
#line 1116
#endif
#line 1116
#endif
#line 1116
        xx = (ix_int)*ip;
#line 1116

#line 1116
    put_ix_int(xp, &xx);
#line 1116
    return err;
#line 1116
}
#line 1116

static int
#line 1117
ncx_put_int_float(void *xp, const float *ip, void *fillp)
#line 1117
{
#line 1117
    int err=NC_NOERR;
#line 1117
    ix_int xx = NC_FILL_INT;
#line 1117

#line 1117
    if (*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN) {
#line 1117
        
#line 1117
#ifdef ERANGE_FILL
#line 1117
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1117
#endif
#line 1117
        err = NC_ERANGE;
#line 1117
    }
#line 1117
#ifdef ERANGE_FILL
#line 1117
    else
#line 1117
#endif
#line 1117
        xx = (ix_int)*ip;
#line 1117

#line 1117
    put_ix_int(xp, &xx);
#line 1117
    return err;
#line 1117
}
#line 1117

static int
#line 1118
ncx_put_int_double(void *xp, const double *ip, void *fillp)
#line 1118
{
#line 1118
    int err=NC_NOERR;
#line 1118
    ix_int xx = NC_FILL_INT;
#line 1118

#line 1118
    if (*ip > X_INT_MAX || *ip < X_INT_MIN) {
#line 1118
        
#line 1118
#ifdef ERANGE_FILL
#line 1118
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1118
#endif
#line 1118
        err = NC_ERANGE;
#line 1118
    }
#line 1118
#ifdef ERANGE_FILL
#line 1118
    else
#line 1118
#endif
#line 1118
        xx = (ix_int)*ip;
#line 1118

#line 1118
    put_ix_int(xp, &xx);
#line 1118
    return err;
#line 1118
}
#line 1118



/* external NC_UINT ---------------------------------------------------------*/

#if USHORT_MAX == X_UINT_MAX
typedef ushort ix_uint;
#define SIZEOF_IX_UINT SIZEOF_USHORT
#define IX_UINT_MAX USHORT_MAX
#elif UINT_MAX  >= X_UINT_MAX
typedef uint ix_uint;
#define SIZEOF_IX_UINT SIZEOF_UINT
#define IX_UINT_MAX UINT_MAX
#elif ULONG_MAX  >= X_UINT_MAX
typedef ulong ix_uint;
#define SIZEOF_IX_UINT SIZEOF_ULONG
#define IX_UINT_MAX ULONG_MAX
#else
#error "ix_uint implementation"
#endif


static void
get_ix_uint(const void *xp, ix_uint *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = (ix_uint)(*cp++ << 24);
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 16));
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 8));
	*ip = (ix_uint)(*ip | *cp);
}

static void
put_ix_uint(void *xp, const ix_uint *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)((*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 1163
ncx_get_uint_uint(const void *xp, uint *ip)
#line 1163
{
#line 1163
    int err=NC_NOERR;
#line 1163
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 1163
    get_ix_uint(xp, (ix_uint *)ip);
#line 1163
#else
#line 1163
    ix_uint xx;
#line 1163
    get_ix_uint(xp, &xx);
#line 1163

#line 1163
#if IX_UINT_MAX > UINT_MAX
#line 1163
    if (xx > UINT_MAX) {
#line 1163
#ifdef ERANGE_FILL
#line 1163
        *ip = NC_FILL_UINT;
#line 1163
        return NC_ERANGE;
#line 1163
#else
#line 1163
        err = NC_ERANGE;
#line 1163
#endif
#line 1163
    }
#line 1163
#endif
#line 1163

#line 1163

#line 1163
    *ip = (uint) xx;
#line 1163
#endif
#line 1163
    return err;
#line 1163
}
#line 1163

#endif

static int
#line 1166
ncx_get_uint_schar(const void *xp, schar *ip)
#line 1166
{
#line 1166
    int err=NC_NOERR;
#line 1166
    ix_uint xx;
#line 1166
    get_ix_uint(xp, &xx);
#line 1166

#line 1166
#if IX_UINT_MAX > SCHAR_MAX
#line 1166
    if (xx > SCHAR_MAX) {
#line 1166
#ifdef ERANGE_FILL
#line 1166
        *ip = NC_FILL_BYTE;
#line 1166
        return NC_ERANGE;
#line 1166
#else
#line 1166
        err = NC_ERANGE;
#line 1166
#endif
#line 1166
    }
#line 1166
#endif
#line 1166

#line 1166

#line 1166
    *ip = (schar) xx;
#line 1166
    return err;
#line 1166
}
#line 1166

static int
#line 1167
ncx_get_uint_short(const void *xp, short *ip)
#line 1167
{
#line 1167
    int err=NC_NOERR;
#line 1167
    ix_uint xx;
#line 1167
    get_ix_uint(xp, &xx);
#line 1167

#line 1167
#if IX_UINT_MAX > SHORT_MAX
#line 1167
    if (xx > SHORT_MAX) {
#line 1167
#ifdef ERANGE_FILL
#line 1167
        *ip = NC_FILL_SHORT;
#line 1167
        return NC_ERANGE;
#line 1167
#else
#line 1167
        err = NC_ERANGE;
#line 1167
#endif
#line 1167
    }
#line 1167
#endif
#line 1167

#line 1167

#line 1167
    *ip = (short) xx;
#line 1167
    return err;
#line 1167
}
#line 1167

static int
#line 1168
ncx_get_uint_int(const void *xp, int *ip)
#line 1168
{
#line 1168
    int err=NC_NOERR;
#line 1168
    ix_uint xx;
#line 1168
    get_ix_uint(xp, &xx);
#line 1168

#line 1168
#if IX_UINT_MAX > INT_MAX
#line 1168
    if (xx > INT_MAX) {
#line 1168
#ifdef ERANGE_FILL
#line 1168
        *ip = NC_FILL_INT;
#line 1168
        return NC_ERANGE;
#line 1168
#else
#line 1168
        err = NC_ERANGE;
#line 1168
#endif
#line 1168
    }
#line 1168
#endif
#line 1168

#line 1168

#line 1168
    *ip = (int) xx;
#line 1168
    return err;
#line 1168
}
#line 1168

static int
#line 1169
ncx_get_uint_long(const void *xp, long *ip)
#line 1169
{
#line 1169
    int err=NC_NOERR;
#line 1169
    ix_uint xx;
#line 1169
    get_ix_uint(xp, &xx);
#line 1169

#line 1169
#if IX_UINT_MAX > LONG_MAX
#line 1169
    if (xx > LONG_MAX) {
#line 1169
#ifdef ERANGE_FILL
#line 1169
        *ip = NC_FILL_INT;
#line 1169
        return NC_ERANGE;
#line 1169
#else
#line 1169
        err = NC_ERANGE;
#line 1169
#endif
#line 1169
    }
#line 1169
#endif
#line 1169

#line 1169

#line 1169
    *ip = (long) xx;
#line 1169
    return err;
#line 1169
}
#line 1169

static int
#line 1170
ncx_get_uint_longlong(const void *xp, longlong *ip)
#line 1170
{
#line 1170
    int err=NC_NOERR;
#line 1170
    ix_uint xx;
#line 1170
    get_ix_uint(xp, &xx);
#line 1170

#line 1170
#if IX_UINT_MAX > LONGLONG_MAX
#line 1170
    if (xx > LONGLONG_MAX) {
#line 1170
#ifdef ERANGE_FILL
#line 1170
        *ip = NC_FILL_INT64;
#line 1170
        return NC_ERANGE;
#line 1170
#else
#line 1170
        err = NC_ERANGE;
#line 1170
#endif
#line 1170
    }
#line 1170
#endif
#line 1170

#line 1170

#line 1170
    *ip = (longlong) xx;
#line 1170
    return err;
#line 1170
}
#line 1170

static int
#line 1171
ncx_get_uint_ushort(const void *xp, ushort *ip)
#line 1171
{
#line 1171
    int err=NC_NOERR;
#line 1171
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 1171
    get_ix_uint(xp, (ix_uint *)ip);
#line 1171
#else
#line 1171
    ix_uint xx;
#line 1171
    get_ix_uint(xp, &xx);
#line 1171

#line 1171
#if IX_UINT_MAX > USHORT_MAX
#line 1171
    if (xx > USHORT_MAX) {
#line 1171
#ifdef ERANGE_FILL
#line 1171
        *ip = NC_FILL_USHORT;
#line 1171
        return NC_ERANGE;
#line 1171
#else
#line 1171
        err = NC_ERANGE;
#line 1171
#endif
#line 1171
    }
#line 1171
#endif
#line 1171

#line 1171

#line 1171
    *ip = (ushort) xx;
#line 1171
#endif
#line 1171
    return err;
#line 1171
}
#line 1171

static int
#line 1172
ncx_get_uint_uchar(const void *xp, uchar *ip)
#line 1172
{
#line 1172
    int err=NC_NOERR;
#line 1172
#if SIZEOF_IX_UINT == SIZEOF_UCHAR && IX_UINT_MAX == UCHAR_MAX
#line 1172
    get_ix_uint(xp, (ix_uint *)ip);
#line 1172
#else
#line 1172
    ix_uint xx;
#line 1172
    get_ix_uint(xp, &xx);
#line 1172

#line 1172
#if IX_UINT_MAX > UCHAR_MAX
#line 1172
    if (xx > UCHAR_MAX) {
#line 1172
#ifdef ERANGE_FILL
#line 1172
        *ip = NC_FILL_UBYTE;
#line 1172
        return NC_ERANGE;
#line 1172
#else
#line 1172
        err = NC_ERANGE;
#line 1172
#endif
#line 1172
    }
#line 1172
#endif
#line 1172

#line 1172

#line 1172
    *ip = (uchar) xx;
#line 1172
#endif
#line 1172
    return err;
#line 1172
}
#line 1172

static int
#line 1173
ncx_get_uint_ulonglong(const void *xp, ulonglong *ip)
#line 1173
{
#line 1173
    int err=NC_NOERR;
#line 1173
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 1173
    get_ix_uint(xp, (ix_uint *)ip);
#line 1173
#else
#line 1173
    ix_uint xx;
#line 1173
    get_ix_uint(xp, &xx);
#line 1173

#line 1173
#if IX_UINT_MAX > ULONGLONG_MAX
#line 1173
    if (xx > ULONGLONG_MAX) {
#line 1173
#ifdef ERANGE_FILL
#line 1173
        *ip = NC_FILL_UINT64;
#line 1173
        return NC_ERANGE;
#line 1173
#else
#line 1173
        err = NC_ERANGE;
#line 1173
#endif
#line 1173
    }
#line 1173
#endif
#line 1173

#line 1173

#line 1173
    *ip = (ulonglong) xx;
#line 1173
#endif
#line 1173
    return err;
#line 1173
}
#line 1173

static int
#line 1174
ncx_get_uint_float(const void *xp, float *ip)
#line 1174
{
#line 1174
	ix_uint xx;
#line 1174
	get_ix_uint(xp, &xx);
#line 1174
	*ip = (float)xx;
#line 1174
	return NC_NOERR;
#line 1174
}
#line 1174

static int
#line 1175
ncx_get_uint_double(const void *xp, double *ip)
#line 1175
{
#line 1175
	ix_uint xx;
#line 1175
	get_ix_uint(xp, &xx);
#line 1175
	*ip = (double)xx;
#line 1175
	return NC_NOERR;
#line 1175
}
#line 1175


static int
ncx_put_uint_schar(void *xp, const schar *ip, void *fillp)
{
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 4);
#ifndef WORDS_BIGENDIAN
        swapn4b(xp, xp, 1);
#endif
#endif
        return NC_ERANGE;
    }

    cp = (uchar *) xp;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp = (uchar)*ip;

    return NC_NOERR;
}

static int
ncx_put_uint_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 1212
ncx_put_uint_uint(void *xp, const uint *ip, void *fillp)
#line 1212
{
#line 1212
    int err=NC_NOERR;
#line 1212
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 1212
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1212
#else
#line 1212
    ix_uint xx = NC_FILL_UINT;
#line 1212

#line 1212
#if IX_UINT_MAX < UINT_MAX
#line 1212
    if (*ip > IX_UINT_MAX) {
#line 1212
        
#line 1212
#ifdef ERANGE_FILL
#line 1212
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1212
#endif
#line 1212
        err = NC_ERANGE;
#line 1212
    }
#line 1212
#ifdef ERANGE_FILL
#line 1212
    else
#line 1212
#endif
#line 1212
#endif
#line 1212
        xx = (ix_uint)*ip;
#line 1212

#line 1212
    put_ix_uint(xp, &xx);
#line 1212
#endif
#line 1212
    return err;
#line 1212
}
#line 1212

#endif

static int
#line 1215
ncx_put_uint_short(void *xp, const short *ip, void *fillp)
#line 1215
{
#line 1215
    int err=NC_NOERR;
#line 1215
    ix_uint xx = NC_FILL_UINT;
#line 1215

#line 1215
#if IX_UINT_MAX < SHORT_MAX
#line 1215
    if (*ip > IX_UINT_MAX) {
#line 1215
        
#line 1215
#ifdef ERANGE_FILL
#line 1215
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1215
#endif
#line 1215
        err = NC_ERANGE;
#line 1215
    }
#line 1215
#ifdef ERANGE_FILL
#line 1215
    else
#line 1215
#endif
#line 1215
#endif
#line 1215
    if (*ip < 0) {
#line 1215
        
#line 1215
#ifdef ERANGE_FILL
#line 1215
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1215
#endif
#line 1215
        err = NC_ERANGE; /* because xp is unsigned */
#line 1215
    }
#line 1215
#ifdef ERANGE_FILL
#line 1215
    else
#line 1215
#endif
#line 1215
        xx = (ix_uint)*ip;
#line 1215

#line 1215
    put_ix_uint(xp, &xx);
#line 1215
    return err;
#line 1215
}
#line 1215

static int
#line 1216
ncx_put_uint_int(void *xp, const int *ip, void *fillp)
#line 1216
{
#line 1216
    int err=NC_NOERR;
#line 1216
    ix_uint xx = NC_FILL_UINT;
#line 1216

#line 1216
#if IX_UINT_MAX < INT_MAX
#line 1216
    if (*ip > IX_UINT_MAX) {
#line 1216
        
#line 1216
#ifdef ERANGE_FILL
#line 1216
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1216
#endif
#line 1216
        err = NC_ERANGE;
#line 1216
    }
#line 1216
#ifdef ERANGE_FILL
#line 1216
    else
#line 1216
#endif
#line 1216
#endif
#line 1216
    if (*ip < 0) {
#line 1216
        
#line 1216
#ifdef ERANGE_FILL
#line 1216
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1216
#endif
#line 1216
        err = NC_ERANGE; /* because xp is unsigned */
#line 1216
    }
#line 1216
#ifdef ERANGE_FILL
#line 1216
    else
#line 1216
#endif
#line 1216
        xx = (ix_uint)*ip;
#line 1216

#line 1216
    put_ix_uint(xp, &xx);
#line 1216
    return err;
#line 1216
}
#line 1216

static int
#line 1217
ncx_put_uint_long(void *xp, const long *ip, void *fillp)
#line 1217
{
#line 1217
    int err=NC_NOERR;
#line 1217
    ix_uint xx = NC_FILL_UINT;
#line 1217

#line 1217
#if IX_UINT_MAX < LONG_MAX
#line 1217
    if (*ip > IX_UINT_MAX) {
#line 1217
        
#line 1217
#ifdef ERANGE_FILL
#line 1217
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1217
#endif
#line 1217
        err = NC_ERANGE;
#line 1217
    }
#line 1217
#ifdef ERANGE_FILL
#line 1217
    else
#line 1217
#endif
#line 1217
#endif
#line 1217
    if (*ip < 0) {
#line 1217
        
#line 1217
#ifdef ERANGE_FILL
#line 1217
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1217
#endif
#line 1217
        err = NC_ERANGE; /* because xp is unsigned */
#line 1217
    }
#line 1217
#ifdef ERANGE_FILL
#line 1217
    else
#line 1217
#endif
#line 1217
        xx = (ix_uint)*ip;
#line 1217

#line 1217
    put_ix_uint(xp, &xx);
#line 1217
    return err;
#line 1217
}
#line 1217

static int
#line 1218
ncx_put_uint_longlong(void *xp, const longlong *ip, void *fillp)
#line 1218
{
#line 1218
    int err=NC_NOERR;
#line 1218
    ix_uint xx = NC_FILL_UINT;
#line 1218

#line 1218
#if IX_UINT_MAX < LONGLONG_MAX
#line 1218
    if (*ip > IX_UINT_MAX) {
#line 1218
        
#line 1218
#ifdef ERANGE_FILL
#line 1218
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1218
#endif
#line 1218
        err = NC_ERANGE;
#line 1218
    }
#line 1218
#ifdef ERANGE_FILL
#line 1218
    else
#line 1218
#endif
#line 1218
#endif
#line 1218
    if (*ip < 0) {
#line 1218
        
#line 1218
#ifdef ERANGE_FILL
#line 1218
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1218
#endif
#line 1218
        err = NC_ERANGE; /* because xp is unsigned */
#line 1218
    }
#line 1218
#ifdef ERANGE_FILL
#line 1218
    else
#line 1218
#endif
#line 1218
        xx = (ix_uint)*ip;
#line 1218

#line 1218
    put_ix_uint(xp, &xx);
#line 1218
    return err;
#line 1218
}
#line 1218

static int
#line 1219
ncx_put_uint_ushort(void *xp, const ushort *ip, void *fillp)
#line 1219
{
#line 1219
    int err=NC_NOERR;
#line 1219
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 1219
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1219
#else
#line 1219
    ix_uint xx = NC_FILL_UINT;
#line 1219

#line 1219
#if IX_UINT_MAX < USHORT_MAX
#line 1219
    if (*ip > IX_UINT_MAX) {
#line 1219
        
#line 1219
#ifdef ERANGE_FILL
#line 1219
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1219
#endif
#line 1219
        err = NC_ERANGE;
#line 1219
    }
#line 1219
#ifdef ERANGE_FILL
#line 1219
    else
#line 1219
#endif
#line 1219
#endif
#line 1219
        xx = (ix_uint)*ip;
#line 1219

#line 1219
    put_ix_uint(xp, &xx);
#line 1219
#endif
#line 1219
    return err;
#line 1219
}
#line 1219

static int
#line 1220
ncx_put_uint_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1220
{
#line 1220
    int err=NC_NOERR;
#line 1220
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 1220
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1220
#else
#line 1220
    ix_uint xx = NC_FILL_UINT;
#line 1220

#line 1220
#if IX_UINT_MAX < ULONGLONG_MAX
#line 1220
    if (*ip > IX_UINT_MAX) {
#line 1220
        
#line 1220
#ifdef ERANGE_FILL
#line 1220
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1220
#endif
#line 1220
        err = NC_ERANGE;
#line 1220
    }
#line 1220
#ifdef ERANGE_FILL
#line 1220
    else
#line 1220
#endif
#line 1220
#endif
#line 1220
        xx = (ix_uint)*ip;
#line 1220

#line 1220
    put_ix_uint(xp, &xx);
#line 1220
#endif
#line 1220
    return err;
#line 1220
}
#line 1220

static int
#line 1221
ncx_put_uint_float(void *xp, const float *ip, void *fillp)
#line 1221
{
#line 1221
    int err=NC_NOERR;
#line 1221
    ix_uint xx = NC_FILL_UINT;
#line 1221

#line 1221
    if (*ip > (double)X_UINT_MAX || *ip < 0) {
#line 1221
        
#line 1221
#ifdef ERANGE_FILL
#line 1221
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1221
#endif
#line 1221
        err = NC_ERANGE;
#line 1221
    }
#line 1221
#ifdef ERANGE_FILL
#line 1221
    else
#line 1221
#endif
#line 1221
        xx = (ix_uint)*ip;
#line 1221

#line 1221
    put_ix_uint(xp, &xx);
#line 1221
    return err;
#line 1221
}
#line 1221

static int
#line 1222
ncx_put_uint_double(void *xp, const double *ip, void *fillp)
#line 1222
{
#line 1222
    int err=NC_NOERR;
#line 1222
    ix_uint xx = NC_FILL_UINT;
#line 1222

#line 1222
    if (*ip > X_UINT_MAX || *ip < 0) {
#line 1222
        
#line 1222
#ifdef ERANGE_FILL
#line 1222
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1222
#endif
#line 1222
        err = NC_ERANGE;
#line 1222
    }
#line 1222
#ifdef ERANGE_FILL
#line 1222
    else
#line 1222
#endif
#line 1222
        xx = (ix_uint)*ip;
#line 1222

#line 1222
    put_ix_uint(xp, &xx);
#line 1222
    return err;
#line 1222
}
#line 1222



/* external NC_FLOAT --------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

inline static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_FLOAT);
#else
	swap4b(ip, xp);
#endif
}

inline static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

#line 1336
static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 1339
		const struct ieee_single *const isp =
#line 1339
			 (const struct ieee_single *) xp;
#line 1339
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 1339

#line 1339
		switch(exp) {
#line 1339
		case 0 :
#line 1339
			/* ieee subnormal */
#line 1339
			if (isp->mant_hi == min.ieee.mant_hi
#line 1339
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 1339
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 1339
			{
#line 1339
				*vsp = min.s;
#line 1339
			}
#line 1339
			else
#line 1339
			{
#line 1339
				unsigned mantissa = (isp->mant_hi << 16)
#line 1339
					 | isp->mant_lo_hi << 8
#line 1339
					 | isp->mant_lo_lo;
#line 1339
				unsigned tmp = mantissa >> 20;
#line 1339
				if (tmp >= 4) {
#line 1339
					vsp->exp = 2;
#line 1339
				} else if (tmp >= 2) {
#line 1339
					vsp->exp = 1;
#line 1339
				} else {
#line 1339
					*vsp = min.s;
#line 1339
					break;
#line 1339
				} /* else */
#line 1339
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 1339
				tmp <<= 3 - vsp->exp;
#line 1339
				vsp->mantissa2 = tmp;
#line 1339
				vsp->mantissa1 = (tmp >> 16);
#line 1339
			}
#line 1339
			break;
#line 1339
		case 0xfe :
#line 1339
		case 0xff :
#line 1339
			*vsp = max.s;
#line 1339
			break;
#line 1339
		default :
#line 1339
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 1339
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 1339
			vsp->mantissa1 = isp->mant_hi;
#line 1339
		}
#line 1339

#line 1339
		vsp->sign = isp->sign;
#line 1339

}

#line 1393

static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
#line 1397
			 (const struct vax_single *)ip;
#line 1397
		struct ieee_single *const isp = (struct ieee_single *) xp;
#line 1397

#line 1397
		switch(vsp->exp){
#line 1397
		case 0 :
#line 1397
			/* all vax float with zero exponent map to zero */
#line 1397
			*isp = min.ieee;
#line 1397
			break;
#line 1397
		case 2 :
#line 1397
		case 1 :
#line 1397
		{
#line 1397
			/* These will map to subnormals */
#line 1397
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 1397
					 | vsp->mantissa2;
#line 1397
			mantissa >>= 3 - vsp->exp;
#line 1397
			mantissa += (1 << (20 + vsp->exp));
#line 1397
			isp->mant_lo_lo = mantissa;
#line 1397
			isp->mant_lo_hi = mantissa >> 8;
#line 1397
			isp->mant_hi = mantissa >> 16;
#line 1397
			isp->exp_lo = 0;
#line 1397
			isp->exp_hi = 0;
#line 1397
		}
#line 1397
			break;
#line 1397
		case 0xff : /* max.s.exp */
#line 1397
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 1397
			    vsp->mantissa1 == max.s.mantissa1)
#line 1397
			{
#line 1397
				/* map largest vax float to ieee infinity */
#line 1397
				*isp = max.ieee;
#line 1397
				break;
#line 1397
			} /* else, fall thru */
#line 1397
		default :
#line 1397
		{
#line 1397
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 1397
			isp->exp_hi = exp >> 1;
#line 1397
			isp->exp_lo = exp;
#line 1397
			isp->mant_lo_lo = vsp->mantissa2;
#line 1397
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 1397
			isp->mant_hi = vsp->mantissa1;
#line 1397
		}
#line 1397
		}
#line 1397

#line 1397
		isp->sign = vsp->sign;
#line 1397

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very weird YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;

#line 1532

static void
get_ix_float(const void *xp, float *ip)
{

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1540

#line 1540
		if (isp->exp == 0)
#line 1540
		{
#line 1540
			/* ieee subnormal */
#line 1540
			*ip = (double)isp->mant;
#line 1540
			if (isp->mant != 0)
#line 1540
			{
#line 1540
				csp->exp -= (ieee_single_bias + 22);
#line 1540
			}
#line 1540
		}
#line 1540
		else
#line 1540
		{
#line 1540
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1540
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1540
			csp->mant |= (1 << (48 - 1));
#line 1540
		}
#line 1540
		csp->sign = isp->sign;
#line 1540

#line 1540

	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1545

#line 1545
		if (isp->exp == 0)
#line 1545
		{
#line 1545
			/* ieee subnormal */
#line 1545
			*ip = (double)isp->mant;
#line 1545
			if (isp->mant != 0)
#line 1545
			{
#line 1545
				csp->exp -= (ieee_single_bias + 22);
#line 1545
			}
#line 1545
		}
#line 1545
		else
#line 1545
		{
#line 1545
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1545
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1545
			csp->mant |= (1 << (48 - 1));
#line 1545
		}
#line 1545
		csp->sign = isp->sign;
#line 1545

#line 1545

	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1555
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1555

#line 1555
	isp->sign = csp->sign;
#line 1555

#line 1555
	if (ieee_exp >= 0xff)
#line 1555
	{
#line 1555
		/* NC_ERANGE => ieee Inf */
#line 1555
		isp->exp = 0xff;
#line 1555
		isp->mant = 0x0;
#line 1555
	}
#line 1555
	else if (ieee_exp > 0)
#line 1555
	{
#line 1555
		/* normal ieee representation */
#line 1555
		isp->exp  = ieee_exp;
#line 1555
		/* assumes cray rep is in normal form */
#line 1555
		assert(csp->mant & 0x800000000000);
#line 1555
		isp->mant = (((csp->mant << 1) &
#line 1555
				0xffffffffffff) >> (48 - 23));
#line 1555
	}
#line 1555
	else if (ieee_exp > -23)
#line 1555
	{
#line 1555
		/* ieee subnormal, right shift */
#line 1555
		const int rshift = (48 - 23 - ieee_exp);
#line 1555

#line 1555
		isp->mant = csp->mant >> rshift;
#line 1555

#line 1555
#if 0
#line 1555
		if (csp->mant & (1 << (rshift -1)))
#line 1555
		{
#line 1555
			/* round up */
#line 1555
			isp->mant++;
#line 1555
		}
#line 1555
#endif
#line 1555

#line 1555
		isp->exp  = 0;
#line 1555
	}
#line 1555
	else
#line 1555
	{
#line 1555
		/* smaller than ieee can represent */
#line 1555
		isp->exp = 0;
#line 1555
		isp->mant = 0;
#line 1555
	}
#line 1555

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1560
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1560

#line 1560
	isp->sign = csp->sign;
#line 1560

#line 1560
	if (ieee_exp >= 0xff)
#line 1560
	{
#line 1560
		/* NC_ERANGE => ieee Inf */
#line 1560
		isp->exp = 0xff;
#line 1560
		isp->mant = 0x0;
#line 1560
	}
#line 1560
	else if (ieee_exp > 0)
#line 1560
	{
#line 1560
		/* normal ieee representation */
#line 1560
		isp->exp  = ieee_exp;
#line 1560
		/* assumes cray rep is in normal form */
#line 1560
		assert(csp->mant & 0x800000000000);
#line 1560
		isp->mant = (((csp->mant << 1) &
#line 1560
				0xffffffffffff) >> (48 - 23));
#line 1560
	}
#line 1560
	else if (ieee_exp > -23)
#line 1560
	{
#line 1560
		/* ieee subnormal, right shift */
#line 1560
		const int rshift = (48 - 23 - ieee_exp);
#line 1560

#line 1560
		isp->mant = csp->mant >> rshift;
#line 1560

#line 1560
#if 0
#line 1560
		if (csp->mant & (1 << (rshift -1)))
#line 1560
		{
#line 1560
			/* round up */
#line 1560
			isp->mant++;
#line 1560
		}
#line 1560
#endif
#line 1560

#line 1560
		isp->exp  = 0;
#line 1560
	}
#line 1560
	else
#line 1560
	{
#line 1560
		/* smaller than ieee can represent */
#line 1560
		isp->exp = 0;
#line 1560
		isp->mant = 0;
#line 1560
	}
#line 1560

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif

#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_get_float_float(const void *xp, float *ip, void *fillp)
{
	/* TODO */
	get_ix_float(xp, ip);
	return NC_NOERR;
}
#endif

#define ix_float float

static int
#line 1647
ncx_get_float_schar(const void *xp, schar *ip)
#line 1647
{
#line 1647
	ix_float xx;
#line 1647
	get_ix_float(xp, &xx);
#line 1647
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1647
#ifdef ERANGE_FILL
#line 1647
            *ip = NC_FILL_BYTE;
#line 1647
#endif
#line 1647
            return NC_ERANGE;
#line 1647
        }
#line 1647
	*ip = (schar)xx;
#line 1647
	return NC_NOERR;
#line 1647
}
#line 1647

static int
#line 1648
ncx_get_float_short(const void *xp, short *ip)
#line 1648
{
#line 1648
	ix_float xx;
#line 1648
	get_ix_float(xp, &xx);
#line 1648
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1648
#ifdef ERANGE_FILL
#line 1648
            *ip = NC_FILL_SHORT;
#line 1648
#endif
#line 1648
            return NC_ERANGE;
#line 1648
        }
#line 1648
	*ip = (short)xx;
#line 1648
	return NC_NOERR;
#line 1648
}
#line 1648

static int
#line 1649
ncx_get_float_int(const void *xp, int *ip)
#line 1649
{
#line 1649
	ix_float xx;
#line 1649
	get_ix_float(xp, &xx);
#line 1649
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1649
#ifdef ERANGE_FILL
#line 1649
            *ip = NC_FILL_INT;
#line 1649
#endif
#line 1649
            return NC_ERANGE;
#line 1649
        }
#line 1649
	*ip = (int)xx;
#line 1649
	return NC_NOERR;
#line 1649
}
#line 1649

static int
#line 1650
ncx_get_float_long(const void *xp, long *ip)
#line 1650
{
#line 1650
	ix_float xx;
#line 1650
	get_ix_float(xp, &xx);
#line 1650
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1650
#ifdef ERANGE_FILL
#line 1650
            *ip = NC_FILL_INT;
#line 1650
#endif
#line 1650
            return NC_ERANGE;
#line 1650
        }
#line 1650
	*ip = (long)xx;
#line 1650
	return NC_NOERR;
#line 1650
}
#line 1650

static int
#line 1651
ncx_get_float_double(const void *xp, double *ip)
#line 1651
{
#line 1651
	ix_float xx;
#line 1651
	get_ix_float(xp, &xx);
#line 1651
	*ip = (double)xx;
#line 1651
	return NC_NOERR;
#line 1651
}
#line 1651

static int
#line 1652
ncx_get_float_longlong(const void *xp, longlong *ip)
#line 1652
{
#line 1652
	ix_float xx;
#line 1652
	get_ix_float(xp, &xx);
#line 1652
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1652
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1652
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1652
#ifdef ERANGE_FILL
#line 1652
            *ip = NC_FILL_INT64;
#line 1652
#endif
#line 1652
            return NC_ERANGE;
#line 1652
        }
#line 1652
	else *ip = (longlong)xx;
#line 1652
	return NC_NOERR;
#line 1652
}
#line 1652

static int
#line 1653
ncx_get_float_uchar(const void *xp, uchar *ip)
#line 1653
{
#line 1653
	ix_float xx;
#line 1653
	get_ix_float(xp, &xx);
#line 1653
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1653
#ifdef ERANGE_FILL
#line 1653
            *ip = NC_FILL_UBYTE;
#line 1653
#endif
#line 1653
            return NC_ERANGE;
#line 1653
        }
#line 1653
	*ip = (uchar)xx;
#line 1653
	return NC_NOERR;
#line 1653
}
#line 1653

static int
#line 1654
ncx_get_float_ushort(const void *xp, ushort *ip)
#line 1654
{
#line 1654
	ix_float xx;
#line 1654
	get_ix_float(xp, &xx);
#line 1654
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1654
#ifdef ERANGE_FILL
#line 1654
            *ip = NC_FILL_USHORT;
#line 1654
#endif
#line 1654
            return NC_ERANGE;
#line 1654
        }
#line 1654
	*ip = (ushort)xx;
#line 1654
	return NC_NOERR;
#line 1654
}
#line 1654

static int
#line 1655
ncx_get_float_uint(const void *xp, uint *ip)
#line 1655
{
#line 1655
	ix_float xx;
#line 1655
	get_ix_float(xp, &xx);
#line 1655
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1655
#ifdef ERANGE_FILL
#line 1655
            *ip = NC_FILL_UINT;
#line 1655
#endif
#line 1655
            return NC_ERANGE;
#line 1655
        }
#line 1655
	*ip = (uint)xx;
#line 1655
	return NC_NOERR;
#line 1655
}
#line 1655

static int
#line 1656
ncx_get_float_ulonglong(const void *xp, ulonglong *ip)
#line 1656
{
#line 1656
	ix_float xx;
#line 1656
	get_ix_float(xp, &xx);
#line 1656
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1656
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1656
#ifdef ERANGE_FILL
#line 1656
            *ip = NC_FILL_UINT64;
#line 1656
#endif
#line 1656
            return NC_ERANGE;
#line 1656
        }
#line 1656
	else *ip = (ulonglong)xx;
#line 1656
	return NC_NOERR;
#line 1656
}
#line 1656


#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_put_float_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    float *_ip=ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    float tmp;
#endif
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
        
#line 1669
#ifdef ERANGE_FILL
#line 1669
            if (fillp != NULL) memcpy(&tmp, fillp, 4);
#line 1669
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_float(xp, _ip);
    return err;
}
#endif

static int
#line 1681
ncx_put_float_schar(void *xp, const schar *ip, void *fillp)
#line 1681
{
#line 1681
    int err=NC_NOERR;
#line 1681
    ix_float xx = NC_FILL_FLOAT;
#line 1681

#line 1681
    
#line 1681
        xx = (ix_float)*ip;
#line 1681

#line 1681
    put_ix_float(xp, &xx);
#line 1681
    return err;
#line 1681
}
#line 1681

static int
#line 1682
ncx_put_float_short(void *xp, const short *ip, void *fillp)
#line 1682
{
#line 1682
    int err=NC_NOERR;
#line 1682
    ix_float xx = NC_FILL_FLOAT;
#line 1682

#line 1682
    
#line 1682
        xx = (ix_float)*ip;
#line 1682

#line 1682
    put_ix_float(xp, &xx);
#line 1682
    return err;
#line 1682
}
#line 1682

static int
#line 1683
ncx_put_float_int(void *xp, const int *ip, void *fillp)
#line 1683
{
#line 1683
    int err=NC_NOERR;
#line 1683
    ix_float xx = NC_FILL_FLOAT;
#line 1683

#line 1683
    
#line 1683
        xx = (ix_float)*ip;
#line 1683

#line 1683
    put_ix_float(xp, &xx);
#line 1683
    return err;
#line 1683
}
#line 1683

static int
#line 1684
ncx_put_float_long(void *xp, const long *ip, void *fillp)
#line 1684
{
#line 1684
    int err=NC_NOERR;
#line 1684
    ix_float xx = NC_FILL_FLOAT;
#line 1684

#line 1684
    
#line 1684
        xx = (ix_float)*ip;
#line 1684

#line 1684
    put_ix_float(xp, &xx);
#line 1684
    return err;
#line 1684
}
#line 1684

static int
#line 1685
ncx_put_float_double(void *xp, const double *ip, void *fillp)
#line 1685
{
#line 1685
    int err=NC_NOERR;
#line 1685
    ix_float xx = NC_FILL_FLOAT;
#line 1685

#line 1685
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
#line 1685
        
#line 1685
#ifdef ERANGE_FILL
#line 1685
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1685
#endif
#line 1685
        err = NC_ERANGE;
#line 1685
    }
#line 1685
#ifdef ERANGE_FILL
#line 1685
    else
#line 1685
#endif
#line 1685
        xx = (ix_float)*ip;
#line 1685

#line 1685
    put_ix_float(xp, &xx);
#line 1685
    return err;
#line 1685
}
#line 1685

static int
#line 1686
ncx_put_float_longlong(void *xp, const longlong *ip, void *fillp)
#line 1686
{
#line 1686
    int err=NC_NOERR;
#line 1686
    ix_float xx = NC_FILL_FLOAT;
#line 1686

#line 1686
    
#line 1686
        xx = (ix_float)*ip;
#line 1686

#line 1686
    put_ix_float(xp, &xx);
#line 1686
    return err;
#line 1686
}
#line 1686

static int
#line 1687
ncx_put_float_uchar(void *xp, const uchar *ip, void *fillp)
#line 1687
{
#line 1687
    int err=NC_NOERR;
#line 1687
    ix_float xx = NC_FILL_FLOAT;
#line 1687

#line 1687
    
#line 1687
        xx = (ix_float)*ip;
#line 1687

#line 1687
    put_ix_float(xp, &xx);
#line 1687
    return err;
#line 1687
}
#line 1687

static int
#line 1688
ncx_put_float_ushort(void *xp, const ushort *ip, void *fillp)
#line 1688
{
#line 1688
    int err=NC_NOERR;
#line 1688
    ix_float xx = NC_FILL_FLOAT;
#line 1688

#line 1688
    
#line 1688
        xx = (ix_float)*ip;
#line 1688

#line 1688
    put_ix_float(xp, &xx);
#line 1688
    return err;
#line 1688
}
#line 1688

static int
#line 1689
ncx_put_float_uint(void *xp, const uint *ip, void *fillp)
#line 1689
{
#line 1689
    int err=NC_NOERR;
#line 1689
    ix_float xx = NC_FILL_FLOAT;
#line 1689

#line 1689
    
#line 1689
        xx = (ix_float)*ip;
#line 1689

#line 1689
    put_ix_float(xp, &xx);
#line 1689
    return err;
#line 1689
}
#line 1689

static int
#line 1690
ncx_put_float_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1690
{
#line 1690
    int err=NC_NOERR;
#line 1690
    ix_float xx = NC_FILL_FLOAT;
#line 1690

#line 1690
    
#line 1690
        xx = (ix_float)*ip;
#line 1690

#line 1690
    put_ix_float(xp, &xx);
#line 1690
    return err;
#line 1690
}
#line 1690



/* external NC_DOUBLE -------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_DOUBLE);
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


#line 1804
static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
#line 1807
			 (struct vax_double *)ip;
#line 1807
	const struct ieee_double *const idp =
#line 1807
			 (const struct ieee_double *) xp;
#line 1807
	{
#line 1807
		const struct dbl_limits *lim;
#line 1807
		int ii;
#line 1807
		for (ii = 0, lim = dbl_limits;
#line 1807
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 1807
			ii++, lim++)
#line 1807
		{
#line 1807
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 1807
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 1807
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 1807
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 1807
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 1807
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 1807
				)
#line 1807
			{
#line 1807
				*vdp = lim->d;
#line 1807
				goto doneit;
#line 1807
			}
#line 1807
		}
#line 1807
	}
#line 1807
	{
#line 1807
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 1807
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 1807
	}
#line 1807
	{
#line 1807
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 1807
				 | (idp->mant_5 << 8)
#line 1807
				 | idp->mant_4);
#line 1807
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 1807
		vdp->mantissa1 = (mant_hi >> 13);
#line 1807
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 1807
				| (mant_lo >> 29);
#line 1807
		vdp->mantissa3 = (mant_lo >> 13);
#line 1807
		vdp->mantissa4 = (mant_lo << 3);
#line 1807
	}
#line 1807
	doneit:
#line 1807
		vdp->sign = idp->sign;
#line 1807

}


#line 1877
static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp =
#line 1880
			(const struct vax_double *)ip;
#line 1880
	struct ieee_double *const idp =
#line 1880
			 (struct ieee_double *) xp;
#line 1880

#line 1880
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 1880
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 1880
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 1880
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 1880
		(vdp->exp == dbl_limits[0].d.exp))
#line 1880
	{
#line 1880
		*idp = dbl_limits[0].ieee;
#line 1880
		goto shipit;
#line 1880
	}
#line 1880
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 1880
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 1880
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 1880
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 1880
		(vdp->exp == dbl_limits[1].d.exp))
#line 1880
	{
#line 1880
		*idp = dbl_limits[1].ieee;
#line 1880
		goto shipit;
#line 1880
	}
#line 1880

#line 1880
	{
#line 1880
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 1880

#line 1880
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 1880
			(vdp->mantissa3 << 13) |
#line 1880
			((vdp->mantissa4 >> 3) & MASK(13));
#line 1880

#line 1880
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 1880
				 | (vdp->mantissa2 >> 3);
#line 1880

#line 1880
		if ((vdp->mantissa4 & 7) > 4)
#line 1880
		{
#line 1880
			/* round up */
#line 1880
			mant_lo++;
#line 1880
			if (mant_lo == 0)
#line 1880
			{
#line 1880
				mant_hi++;
#line 1880
				if (mant_hi > 0xffffff)
#line 1880
				{
#line 1880
					mant_hi = 0;
#line 1880
					exp++;
#line 1880
				}
#line 1880
			}
#line 1880
		}
#line 1880

#line 1880
		idp->mant_lo = SWAP4(mant_lo);
#line 1880
		idp->mant_6 = mant_hi >> 16;
#line 1880
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 1880
		idp->mant_4 = mant_hi;
#line 1880
		idp->exp_hi = exp >> 4;
#line 1880
		idp->exp_lo = exp;
#line 1880
	}
#line 1880

#line 1880
	shipit:
#line 1880
		idp->sign = vdp->sign;
#line 1880

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if (idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if (idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if (ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if (ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if (ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if (ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if (csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

#define ix_double double

static int
#line 1972
ncx_get_double_schar(const void *xp, schar *ip)
#line 1972
{
#line 1972
	ix_double xx;
#line 1972
	get_ix_double(xp, &xx);
#line 1972
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1972
#ifdef ERANGE_FILL
#line 1972
            *ip = NC_FILL_BYTE;
#line 1972
#endif
#line 1972
            return NC_ERANGE;
#line 1972
        }
#line 1972
	*ip = (schar)xx;
#line 1972
	return NC_NOERR;
#line 1972
}
#line 1972

static int
#line 1973
ncx_get_double_short(const void *xp, short *ip)
#line 1973
{
#line 1973
	ix_double xx;
#line 1973
	get_ix_double(xp, &xx);
#line 1973
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1973
#ifdef ERANGE_FILL
#line 1973
            *ip = NC_FILL_SHORT;
#line 1973
#endif
#line 1973
            return NC_ERANGE;
#line 1973
        }
#line 1973
	*ip = (short)xx;
#line 1973
	return NC_NOERR;
#line 1973
}
#line 1973

static int
#line 1974
ncx_get_double_int(const void *xp, int *ip)
#line 1974
{
#line 1974
	ix_double xx;
#line 1974
	get_ix_double(xp, &xx);
#line 1974
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1974
#ifdef ERANGE_FILL
#line 1974
            *ip = NC_FILL_INT;
#line 1974
#endif
#line 1974
            return NC_ERANGE;
#line 1974
        }
#line 1974
	*ip = (int)xx;
#line 1974
	return NC_NOERR;
#line 1974
}
#line 1974

static int
#line 1975
ncx_get_double_long(const void *xp, long *ip)
#line 1975
{
#line 1975
	ix_double xx;
#line 1975
	get_ix_double(xp, &xx);
#line 1975
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1975
#ifdef ERANGE_FILL
#line 1975
            *ip = NC_FILL_INT;
#line 1975
#endif
#line 1975
            return NC_ERANGE;
#line 1975
        }
#line 1975
	*ip = (long)xx;
#line 1975
	return NC_NOERR;
#line 1975
}
#line 1975

static int
#line 1976
ncx_get_double_longlong(const void *xp, longlong *ip)
#line 1976
{
#line 1976
	ix_double xx;
#line 1976
	get_ix_double(xp, &xx);
#line 1976
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1976
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1976
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1976
#ifdef ERANGE_FILL
#line 1976
            *ip = NC_FILL_INT64;
#line 1976
#endif
#line 1976
            return NC_ERANGE;
#line 1976
        }
#line 1976
	else *ip = (longlong)xx;
#line 1976
	return NC_NOERR;
#line 1976
}
#line 1976

static int
#line 1977
ncx_get_double_uchar(const void *xp, uchar *ip)
#line 1977
{
#line 1977
	ix_double xx;
#line 1977
	get_ix_double(xp, &xx);
#line 1977
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1977
#ifdef ERANGE_FILL
#line 1977
            *ip = NC_FILL_UBYTE;
#line 1977
#endif
#line 1977
            return NC_ERANGE;
#line 1977
        }
#line 1977
	*ip = (uchar)xx;
#line 1977
	return NC_NOERR;
#line 1977
}
#line 1977

static int
#line 1978
ncx_get_double_ushort(const void *xp, ushort *ip)
#line 1978
{
#line 1978
	ix_double xx;
#line 1978
	get_ix_double(xp, &xx);
#line 1978
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1978
#ifdef ERANGE_FILL
#line 1978
            *ip = NC_FILL_USHORT;
#line 1978
#endif
#line 1978
            return NC_ERANGE;
#line 1978
        }
#line 1978
	*ip = (ushort)xx;
#line 1978
	return NC_NOERR;
#line 1978
}
#line 1978

static int
#line 1979
ncx_get_double_uint(const void *xp, uint *ip)
#line 1979
{
#line 1979
	ix_double xx;
#line 1979
	get_ix_double(xp, &xx);
#line 1979
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1979
#ifdef ERANGE_FILL
#line 1979
            *ip = NC_FILL_UINT;
#line 1979
#endif
#line 1979
            return NC_ERANGE;
#line 1979
        }
#line 1979
	*ip = (uint)xx;
#line 1979
	return NC_NOERR;
#line 1979
}
#line 1979

static int
#line 1980
ncx_get_double_ulonglong(const void *xp, ulonglong *ip)
#line 1980
{
#line 1980
	ix_double xx;
#line 1980
	get_ix_double(xp, &xx);
#line 1980
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1980
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1980
#ifdef ERANGE_FILL
#line 1980
            *ip = NC_FILL_UINT64;
#line 1980
#endif
#line 1980
            return NC_ERANGE;
#line 1980
        }
#line 1980
	else *ip = (ulonglong)xx;
#line 1980
	return NC_NOERR;
#line 1980
}
#line 1980


static int
ncx_get_double_float(const void *xp, float *ip)
{
    double xx;
    get_ix_double(xp, &xx);
    if (xx > FLT_MAX) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = FLT_MAX;
#endif
        return NC_ERANGE;
    }
    if (xx < (-FLT_MAX)) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = (-FLT_MAX);
#endif
        return NC_ERANGE;
    }
    *ip = (float) xx;
    return NC_NOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_get_double_double(const void *xp, double *ip, void *fillp)
{
	/* TODO */
	get_ix_double(xp, ip);
	return NC_NOERR;
}
#endif

static int
#line 2017
ncx_put_double_schar(void *xp, const schar *ip, void *fillp)
#line 2017
{
#line 2017
    int err=NC_NOERR;
#line 2017
    ix_double xx = NC_FILL_DOUBLE;
#line 2017

#line 2017
    
#line 2017
        xx = (ix_double)*ip;
#line 2017

#line 2017
    put_ix_double(xp, &xx);
#line 2017
    return err;
#line 2017
}
#line 2017

static int
#line 2018
ncx_put_double_uchar(void *xp, const uchar *ip, void *fillp)
#line 2018
{
#line 2018
    int err=NC_NOERR;
#line 2018
    ix_double xx = NC_FILL_DOUBLE;
#line 2018

#line 2018
    
#line 2018
        xx = (ix_double)*ip;
#line 2018

#line 2018
    put_ix_double(xp, &xx);
#line 2018
    return err;
#line 2018
}
#line 2018

static int
#line 2019
ncx_put_double_short(void *xp, const short *ip, void *fillp)
#line 2019
{
#line 2019
    int err=NC_NOERR;
#line 2019
    ix_double xx = NC_FILL_DOUBLE;
#line 2019

#line 2019
    
#line 2019
        xx = (ix_double)*ip;
#line 2019

#line 2019
    put_ix_double(xp, &xx);
#line 2019
    return err;
#line 2019
}
#line 2019

static int
#line 2020
ncx_put_double_ushort(void *xp, const ushort *ip, void *fillp)
#line 2020
{
#line 2020
    int err=NC_NOERR;
#line 2020
    ix_double xx = NC_FILL_DOUBLE;
#line 2020

#line 2020
    
#line 2020
        xx = (ix_double)*ip;
#line 2020

#line 2020
    put_ix_double(xp, &xx);
#line 2020
    return err;
#line 2020
}
#line 2020

static int
#line 2021
ncx_put_double_int(void *xp, const int *ip, void *fillp)
#line 2021
{
#line 2021
    int err=NC_NOERR;
#line 2021
    ix_double xx = NC_FILL_DOUBLE;
#line 2021

#line 2021
    
#line 2021
        xx = (ix_double)*ip;
#line 2021

#line 2021
    put_ix_double(xp, &xx);
#line 2021
    return err;
#line 2021
}
#line 2021

static int
#line 2022
ncx_put_double_long(void *xp, const long *ip, void *fillp)
#line 2022
{
#line 2022
    int err=NC_NOERR;
#line 2022
    ix_double xx = NC_FILL_DOUBLE;
#line 2022

#line 2022
    
#line 2022
        xx = (ix_double)*ip;
#line 2022

#line 2022
    put_ix_double(xp, &xx);
#line 2022
    return err;
#line 2022
}
#line 2022

static int
#line 2023
ncx_put_double_uint(void *xp, const uint *ip, void *fillp)
#line 2023
{
#line 2023
    int err=NC_NOERR;
#line 2023
    ix_double xx = NC_FILL_DOUBLE;
#line 2023

#line 2023
    
#line 2023
        xx = (ix_double)*ip;
#line 2023

#line 2023
    put_ix_double(xp, &xx);
#line 2023
    return err;
#line 2023
}
#line 2023

static int
#line 2024
ncx_put_double_longlong(void *xp, const longlong *ip, void *fillp)
#line 2024
{
#line 2024
    int err=NC_NOERR;
#line 2024
    ix_double xx = NC_FILL_DOUBLE;
#line 2024

#line 2024
    
#line 2024
        xx = (ix_double)*ip;
#line 2024

#line 2024
    put_ix_double(xp, &xx);
#line 2024
    return err;
#line 2024
}
#line 2024

static int
#line 2025
ncx_put_double_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2025
{
#line 2025
    int err=NC_NOERR;
#line 2025
    ix_double xx = NC_FILL_DOUBLE;
#line 2025

#line 2025
    
#line 2025
        xx = (ix_double)*ip;
#line 2025

#line 2025
    put_ix_double(xp, &xx);
#line 2025
    return err;
#line 2025
}
#line 2025


static int
ncx_put_double_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    double xx = NC_FILL_DOUBLE;
#if 1	/* TODO: figure this out (if condition below will never be true)*/
    if ((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN) {
        
#line 2034
#ifdef ERANGE_FILL
#line 2034
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2034
#endif
        err = NC_ERANGE;
    }
#ifdef ERANGE_FILL
    else
#endif
#endif
        xx = (double) *ip;

    put_ix_double(xp, &xx);
    return err;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_put_double_double(void *xp, const double *ip, void *fillp)
{
    int err=NC_NOERR;
    double *_ip = ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    double tmp=NC_FILL_DOUBLE;
#endif
    if (*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN) {
        
#line 2058
#ifdef ERANGE_FILL
#line 2058
            if (fillp != NULL) memcpy(&tmp, fillp, 8);
#line 2058
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_double(xp, _ip);
    return err;
}
#endif


/* external NC_INT64 --------------------------------------------------------*/

#if SHORT_MAX == X_INT64_MAX
typedef short ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_SHORT
#define IX_INT64_MAX SHORT_MAX
#elif LONG_LONG_MAX  >= X_INT64_MAX
typedef longlong ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONGLONG
#define IX_INT64_MAX LONG_LONG_MAX
#elif LONG_MAX  >= X_INT64_MAX
typedef long ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONG
#define IX_INT64_MAX LONG_MAX
#else
#error "ix_int64 implementation"
#endif


static void
get_ix_int64(const void *xp, ix_int64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_int64)(*cp++) << 56);
    *ip |= ((ix_int64)(*cp++) << 48);
    *ip |= ((ix_int64)(*cp++) << 40);
    *ip |= ((ix_int64)(*cp++) << 32);
    *ip |= ((ix_int64)(*cp++) << 24);
    *ip |= ((ix_int64)(*cp++) << 16);
    *ip |= ((ix_int64)(*cp++) <<  8);
    *ip |=  (ix_int64)*cp;
}

static void
put_ix_int64(void *xp, const ix_int64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffLL);
}

#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 2121
ncx_get_longlong_longlong(const void *xp, longlong *ip)
#line 2121
{
#line 2121
    int err=NC_NOERR;
#line 2121
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 2121
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2121
#else
#line 2121
    ix_int64 xx;
#line 2121
    get_ix_int64(xp, &xx);
#line 2121

#line 2121
#if IX_INT64_MAX > LONGLONG_MAX
#line 2121
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 2121
#ifdef ERANGE_FILL
#line 2121
        *ip = NC_FILL_INT64;
#line 2121
        return NC_ERANGE;
#line 2121
#else
#line 2121
        err = NC_ERANGE;
#line 2121
#endif
#line 2121
    }
#line 2121
#endif
#line 2121

#line 2121

#line 2121
    *ip = (longlong) xx;
#line 2121
#endif
#line 2121
    return err;
#line 2121
}
#line 2121

#endif
static int
#line 2123
ncx_get_longlong_schar(const void *xp, schar *ip)
#line 2123
{
#line 2123
    int err=NC_NOERR;
#line 2123
    ix_int64 xx;
#line 2123
    get_ix_int64(xp, &xx);
#line 2123

#line 2123
#if IX_INT64_MAX > SCHAR_MAX
#line 2123
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 2123
#ifdef ERANGE_FILL
#line 2123
        *ip = NC_FILL_BYTE;
#line 2123
        return NC_ERANGE;
#line 2123
#else
#line 2123
        err = NC_ERANGE;
#line 2123
#endif
#line 2123
    }
#line 2123
#endif
#line 2123

#line 2123

#line 2123
    *ip = (schar) xx;
#line 2123
    return err;
#line 2123
}
#line 2123

static int
#line 2124
ncx_get_longlong_short(const void *xp, short *ip)
#line 2124
{
#line 2124
    int err=NC_NOERR;
#line 2124
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 2124
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2124
#else
#line 2124
    ix_int64 xx;
#line 2124
    get_ix_int64(xp, &xx);
#line 2124

#line 2124
#if IX_INT64_MAX > SHORT_MAX
#line 2124
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 2124
#ifdef ERANGE_FILL
#line 2124
        *ip = NC_FILL_SHORT;
#line 2124
        return NC_ERANGE;
#line 2124
#else
#line 2124
        err = NC_ERANGE;
#line 2124
#endif
#line 2124
    }
#line 2124
#endif
#line 2124

#line 2124

#line 2124
    *ip = (short) xx;
#line 2124
#endif
#line 2124
    return err;
#line 2124
}
#line 2124

static int
#line 2125
ncx_get_longlong_int(const void *xp, int *ip)
#line 2125
{
#line 2125
    int err=NC_NOERR;
#line 2125
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 2125
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2125
#else
#line 2125
    ix_int64 xx;
#line 2125
    get_ix_int64(xp, &xx);
#line 2125

#line 2125
#if IX_INT64_MAX > INT_MAX
#line 2125
    if (xx > INT_MAX || xx < INT_MIN) {
#line 2125
#ifdef ERANGE_FILL
#line 2125
        *ip = NC_FILL_INT;
#line 2125
        return NC_ERANGE;
#line 2125
#else
#line 2125
        err = NC_ERANGE;
#line 2125
#endif
#line 2125
    }
#line 2125
#endif
#line 2125

#line 2125

#line 2125
    *ip = (int) xx;
#line 2125
#endif
#line 2125
    return err;
#line 2125
}
#line 2125

static int
#line 2126
ncx_get_longlong_long(const void *xp, long *ip)
#line 2126
{
#line 2126
    int err=NC_NOERR;
#line 2126
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 2126
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2126
#else
#line 2126
    ix_int64 xx;
#line 2126
    get_ix_int64(xp, &xx);
#line 2126

#line 2126
#if IX_INT64_MAX > LONG_MAX
#line 2126
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 2126
#ifdef ERANGE_FILL
#line 2126
        *ip = NC_FILL_INT;
#line 2126
        return NC_ERANGE;
#line 2126
#else
#line 2126
        err = NC_ERANGE;
#line 2126
#endif
#line 2126
    }
#line 2126
#endif
#line 2126

#line 2126

#line 2126
    *ip = (long) xx;
#line 2126
#endif
#line 2126
    return err;
#line 2126
}
#line 2126

static int
#line 2127
ncx_get_longlong_ushort(const void *xp, ushort *ip)
#line 2127
{
#line 2127
    int err=NC_NOERR;
#line 2127
    ix_int64 xx;
#line 2127
    get_ix_int64(xp, &xx);
#line 2127

#line 2127
#if IX_INT64_MAX > USHORT_MAX
#line 2127
    if (xx > USHORT_MAX) {
#line 2127
#ifdef ERANGE_FILL
#line 2127
        *ip = NC_FILL_USHORT;
#line 2127
        return NC_ERANGE;
#line 2127
#else
#line 2127
        err = NC_ERANGE;
#line 2127
#endif
#line 2127
    }
#line 2127
#endif
#line 2127

#line 2127
    if (xx < 0) {
#line 2127
#ifdef ERANGE_FILL
#line 2127
        *ip = NC_FILL_USHORT;
#line 2127
        return NC_ERANGE;
#line 2127
#else
#line 2127
        err = NC_ERANGE; /* because ip is unsigned */
#line 2127
#endif
#line 2127
    }
#line 2127
    *ip = (ushort) xx;
#line 2127
    return err;
#line 2127
}
#line 2127

static int
#line 2128
ncx_get_longlong_uchar(const void *xp, uchar *ip)
#line 2128
{
#line 2128
    int err=NC_NOERR;
#line 2128
    ix_int64 xx;
#line 2128
    get_ix_int64(xp, &xx);
#line 2128

#line 2128
#if IX_INT64_MAX > UCHAR_MAX
#line 2128
    if (xx > UCHAR_MAX) {
#line 2128
#ifdef ERANGE_FILL
#line 2128
        *ip = NC_FILL_UBYTE;
#line 2128
        return NC_ERANGE;
#line 2128
#else
#line 2128
        err = NC_ERANGE;
#line 2128
#endif
#line 2128
    }
#line 2128
#endif
#line 2128

#line 2128
    if (xx < 0) {
#line 2128
#ifdef ERANGE_FILL
#line 2128
        *ip = NC_FILL_UBYTE;
#line 2128
        return NC_ERANGE;
#line 2128
#else
#line 2128
        err = NC_ERANGE; /* because ip is unsigned */
#line 2128
#endif
#line 2128
    }
#line 2128
    *ip = (uchar) xx;
#line 2128
    return err;
#line 2128
}
#line 2128

static int
#line 2129
ncx_get_longlong_uint(const void *xp, uint *ip)
#line 2129
{
#line 2129
    int err=NC_NOERR;
#line 2129
    ix_int64 xx;
#line 2129
    get_ix_int64(xp, &xx);
#line 2129

#line 2129
#if IX_INT64_MAX > UINT_MAX
#line 2129
    if (xx > UINT_MAX) {
#line 2129
#ifdef ERANGE_FILL
#line 2129
        *ip = NC_FILL_UINT;
#line 2129
        return NC_ERANGE;
#line 2129
#else
#line 2129
        err = NC_ERANGE;
#line 2129
#endif
#line 2129
    }
#line 2129
#endif
#line 2129

#line 2129
    if (xx < 0) {
#line 2129
#ifdef ERANGE_FILL
#line 2129
        *ip = NC_FILL_UINT;
#line 2129
        return NC_ERANGE;
#line 2129
#else
#line 2129
        err = NC_ERANGE; /* because ip is unsigned */
#line 2129
#endif
#line 2129
    }
#line 2129
    *ip = (uint) xx;
#line 2129
    return err;
#line 2129
}
#line 2129

static int
#line 2130
ncx_get_longlong_ulonglong(const void *xp, ulonglong *ip)
#line 2130
{
#line 2130
    int err=NC_NOERR;
#line 2130
    ix_int64 xx;
#line 2130
    get_ix_int64(xp, &xx);
#line 2130

#line 2130
#if IX_INT64_MAX > ULONGLONG_MAX
#line 2130
    if (xx > ULONGLONG_MAX) {
#line 2130
#ifdef ERANGE_FILL
#line 2130
        *ip = NC_FILL_UINT64;
#line 2130
        return NC_ERANGE;
#line 2130
#else
#line 2130
        err = NC_ERANGE;
#line 2130
#endif
#line 2130
    }
#line 2130
#endif
#line 2130

#line 2130
    if (xx < 0) {
#line 2130
#ifdef ERANGE_FILL
#line 2130
        *ip = NC_FILL_UINT64;
#line 2130
        return NC_ERANGE;
#line 2130
#else
#line 2130
        err = NC_ERANGE; /* because ip is unsigned */
#line 2130
#endif
#line 2130
    }
#line 2130
    *ip = (ulonglong) xx;
#line 2130
    return err;
#line 2130
}
#line 2130

static int
#line 2131
ncx_get_longlong_float(const void *xp, float *ip)
#line 2131
{
#line 2131
	ix_int64 xx;
#line 2131
	get_ix_int64(xp, &xx);
#line 2131
	*ip = (float)xx;
#line 2131
	return NC_NOERR;
#line 2131
}
#line 2131

static int
#line 2132
ncx_get_longlong_double(const void *xp, double *ip)
#line 2132
{
#line 2132
	ix_int64 xx;
#line 2132
	get_ix_int64(xp, &xx);
#line 2132
	*ip = (double)xx;
#line 2132
	return NC_NOERR;
#line 2132
}
#line 2132


#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 2135
ncx_put_longlong_longlong(void *xp, const longlong *ip, void *fillp)
#line 2135
{
#line 2135
    int err=NC_NOERR;
#line 2135
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 2135
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2135
#else
#line 2135
    ix_int64 xx = NC_FILL_INT64;
#line 2135

#line 2135
#if IX_INT64_MAX < LONGLONG_MAX
#line 2135
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2135
        
#line 2135
#ifdef ERANGE_FILL
#line 2135
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2135
#endif
#line 2135
        err = NC_ERANGE;
#line 2135
    }
#line 2135
#ifdef ERANGE_FILL
#line 2135
    else
#line 2135
#endif
#line 2135
#endif
#line 2135
        xx = (ix_int64)*ip;
#line 2135

#line 2135
    put_ix_int64(xp, &xx);
#line 2135
#endif
#line 2135
    return err;
#line 2135
}
#line 2135

#endif
static int
#line 2137
ncx_put_longlong_schar(void *xp, const schar *ip, void *fillp)
#line 2137
{
#line 2137
    int err=NC_NOERR;
#line 2137
    ix_int64 xx = NC_FILL_INT64;
#line 2137

#line 2137
#if IX_INT64_MAX < SCHAR_MAX
#line 2137
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2137
        
#line 2137
#ifdef ERANGE_FILL
#line 2137
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2137
#endif
#line 2137
        err = NC_ERANGE;
#line 2137
    }
#line 2137
#ifdef ERANGE_FILL
#line 2137
    else
#line 2137
#endif
#line 2137
#endif
#line 2137
        xx = (ix_int64)*ip;
#line 2137

#line 2137
    put_ix_int64(xp, &xx);
#line 2137
    return err;
#line 2137
}
#line 2137

static int
#line 2138
ncx_put_longlong_short(void *xp, const short *ip, void *fillp)
#line 2138
{
#line 2138
    int err=NC_NOERR;
#line 2138
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 2138
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2138
#else
#line 2138
    ix_int64 xx = NC_FILL_INT64;
#line 2138

#line 2138
#if IX_INT64_MAX < SHORT_MAX
#line 2138
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2138
        
#line 2138
#ifdef ERANGE_FILL
#line 2138
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2138
#endif
#line 2138
        err = NC_ERANGE;
#line 2138
    }
#line 2138
#ifdef ERANGE_FILL
#line 2138
    else
#line 2138
#endif
#line 2138
#endif
#line 2138
        xx = (ix_int64)*ip;
#line 2138

#line 2138
    put_ix_int64(xp, &xx);
#line 2138
#endif
#line 2138
    return err;
#line 2138
}
#line 2138

static int
#line 2139
ncx_put_longlong_int(void *xp, const int *ip, void *fillp)
#line 2139
{
#line 2139
    int err=NC_NOERR;
#line 2139
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 2139
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2139
#else
#line 2139
    ix_int64 xx = NC_FILL_INT64;
#line 2139

#line 2139
#if IX_INT64_MAX < INT_MAX
#line 2139
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2139
        
#line 2139
#ifdef ERANGE_FILL
#line 2139
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2139
#endif
#line 2139
        err = NC_ERANGE;
#line 2139
    }
#line 2139
#ifdef ERANGE_FILL
#line 2139
    else
#line 2139
#endif
#line 2139
#endif
#line 2139
        xx = (ix_int64)*ip;
#line 2139

#line 2139
    put_ix_int64(xp, &xx);
#line 2139
#endif
#line 2139
    return err;
#line 2139
}
#line 2139

static int
#line 2140
ncx_put_longlong_long(void *xp, const long *ip, void *fillp)
#line 2140
{
#line 2140
    int err=NC_NOERR;
#line 2140
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 2140
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2140
#else
#line 2140
    ix_int64 xx = NC_FILL_INT64;
#line 2140

#line 2140
#if IX_INT64_MAX < LONG_MAX
#line 2140
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2140
        
#line 2140
#ifdef ERANGE_FILL
#line 2140
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2140
#endif
#line 2140
        err = NC_ERANGE;
#line 2140
    }
#line 2140
#ifdef ERANGE_FILL
#line 2140
    else
#line 2140
#endif
#line 2140
#endif
#line 2140
        xx = (ix_int64)*ip;
#line 2140

#line 2140
    put_ix_int64(xp, &xx);
#line 2140
#endif
#line 2140
    return err;
#line 2140
}
#line 2140

static int
#line 2141
ncx_put_longlong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2141
{
#line 2141
    int err=NC_NOERR;
#line 2141
    ix_int64 xx = NC_FILL_INT64;
#line 2141

#line 2141
#if IX_INT64_MAX < USHORT_MAX
#line 2141
    if (*ip > IX_INT64_MAX) {
#line 2141
        
#line 2141
#ifdef ERANGE_FILL
#line 2141
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2141
#endif
#line 2141
        err = NC_ERANGE;
#line 2141
    }
#line 2141
#ifdef ERANGE_FILL
#line 2141
    else
#line 2141
#endif
#line 2141
#endif
#line 2141
        xx = (ix_int64)*ip;
#line 2141

#line 2141
    put_ix_int64(xp, &xx);
#line 2141
    return err;
#line 2141
}
#line 2141

static int
#line 2142
ncx_put_longlong_uchar(void *xp, const uchar *ip, void *fillp)
#line 2142
{
#line 2142
    int err=NC_NOERR;
#line 2142
    ix_int64 xx = NC_FILL_INT64;
#line 2142

#line 2142
#if IX_INT64_MAX < UCHAR_MAX
#line 2142
    if (*ip > IX_INT64_MAX) {
#line 2142
        
#line 2142
#ifdef ERANGE_FILL
#line 2142
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2142
#endif
#line 2142
        err = NC_ERANGE;
#line 2142
    }
#line 2142
#ifdef ERANGE_FILL
#line 2142
    else
#line 2142
#endif
#line 2142
#endif
#line 2142
        xx = (ix_int64)*ip;
#line 2142

#line 2142
    put_ix_int64(xp, &xx);
#line 2142
    return err;
#line 2142
}
#line 2142

static int
#line 2143
ncx_put_longlong_uint(void *xp, const uint *ip, void *fillp)
#line 2143
{
#line 2143
    int err=NC_NOERR;
#line 2143
    ix_int64 xx = NC_FILL_INT64;
#line 2143

#line 2143
#if IX_INT64_MAX < UINT_MAX
#line 2143
    if (*ip > IX_INT64_MAX) {
#line 2143
        
#line 2143
#ifdef ERANGE_FILL
#line 2143
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2143
#endif
#line 2143
        err = NC_ERANGE;
#line 2143
    }
#line 2143
#ifdef ERANGE_FILL
#line 2143
    else
#line 2143
#endif
#line 2143
#endif
#line 2143
        xx = (ix_int64)*ip;
#line 2143

#line 2143
    put_ix_int64(xp, &xx);
#line 2143
    return err;
#line 2143
}
#line 2143

static int
#line 2144
ncx_put_longlong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2144
{
#line 2144
    int err=NC_NOERR;
#line 2144
    ix_int64 xx = NC_FILL_INT64;
#line 2144

#line 2144
#if IX_INT64_MAX < ULONGLONG_MAX
#line 2144
    if (*ip > IX_INT64_MAX) {
#line 2144
        
#line 2144
#ifdef ERANGE_FILL
#line 2144
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2144
#endif
#line 2144
        err = NC_ERANGE;
#line 2144
    }
#line 2144
#ifdef ERANGE_FILL
#line 2144
    else
#line 2144
#endif
#line 2144
#endif
#line 2144
        xx = (ix_int64)*ip;
#line 2144

#line 2144
    put_ix_int64(xp, &xx);
#line 2144
    return err;
#line 2144
}
#line 2144

static int
#line 2145
ncx_put_longlong_float(void *xp, const float *ip, void *fillp)
#line 2145
{
#line 2145
    int err=NC_NOERR;
#line 2145
    ix_int64 xx = NC_FILL_INT64;
#line 2145

#line 2145
    if (*ip > (double)X_INT64_MAX || *ip < (double)X_INT64_MIN) {
#line 2145
        
#line 2145
#ifdef ERANGE_FILL
#line 2145
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2145
#endif
#line 2145
        err = NC_ERANGE;
#line 2145
    }
#line 2145
#ifdef ERANGE_FILL
#line 2145
    else
#line 2145
#endif
#line 2145
        xx = (ix_int64)*ip;
#line 2145

#line 2145
    put_ix_int64(xp, &xx);
#line 2145
    return err;
#line 2145
}
#line 2145

static int
#line 2146
ncx_put_longlong_double(void *xp, const double *ip, void *fillp)
#line 2146
{
#line 2146
    int err=NC_NOERR;
#line 2146
    ix_int64 xx = NC_FILL_INT64;
#line 2146

#line 2146
    if (*ip > X_INT64_MAX || *ip < X_INT64_MIN) {
#line 2146
        
#line 2146
#ifdef ERANGE_FILL
#line 2146
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2146
#endif
#line 2146
        err = NC_ERANGE;
#line 2146
    }
#line 2146
#ifdef ERANGE_FILL
#line 2146
    else
#line 2146
#endif
#line 2146
        xx = (ix_int64)*ip;
#line 2146

#line 2146
    put_ix_int64(xp, &xx);
#line 2146
    return err;
#line 2146
}
#line 2146



/* external NC_UINT64 -------------------------------------------------------*/

#if USHORT_MAX == X_UINT64_MAX
typedef ushort ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_USHORT
#define IX_UINT64_MAX USHORT_MAX
#elif ULONG_LONG_MAX  >= X_UINT64_MAX
typedef ulonglong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONGLONG
#define IX_UINT64_MAX ULONG_LONG_MAX
#elif ULONG_MAX  >= X_UINT64_MAX
typedef ulong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONG
#define IX_UINT64_MAX ULONG_MAX
#else
#error "ix_uint64 implementation"
#endif


static void
get_ix_uint64(const void *xp, ix_uint64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_uint64)(*cp++) << 56);
    *ip |= ((ix_uint64)(*cp++) << 48);
    *ip |= ((ix_uint64)(*cp++) << 40);
    *ip |= ((ix_uint64)(*cp++) << 32);
    *ip |= ((ix_uint64)(*cp++) << 24);
    *ip |= ((ix_uint64)(*cp++) << 16);
    *ip |= ((ix_uint64)(*cp++) <<  8);
    *ip |=  (ix_uint64)*cp;
}

static void
put_ix_uint64(void *xp, const ix_uint64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000ULL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000ULL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000ULL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000ULL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000ULL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00ULL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffULL);
}

#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 2199
ncx_get_ulonglong_ulonglong(const void *xp, ulonglong *ip)
#line 2199
{
#line 2199
    int err=NC_NOERR;
#line 2199
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 2199
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2199
#else
#line 2199
    ix_uint64 xx;
#line 2199
    get_ix_uint64(xp, &xx);
#line 2199

#line 2199
#if IX_UINT64_MAX > ULONGLONG_MAX
#line 2199
    if (xx > ULONGLONG_MAX) {
#line 2199
#ifdef ERANGE_FILL
#line 2199
        *ip = NC_FILL_UINT64;
#line 2199
        return NC_ERANGE;
#line 2199
#else
#line 2199
        err = NC_ERANGE;
#line 2199
#endif
#line 2199
    }
#line 2199
#endif
#line 2199

#line 2199

#line 2199
    *ip = (ulonglong) xx;
#line 2199
#endif
#line 2199
    return err;
#line 2199
}
#line 2199

#endif
static int
#line 2201
ncx_get_ulonglong_schar(const void *xp, schar *ip)
#line 2201
{
#line 2201
    int err=NC_NOERR;
#line 2201
    ix_uint64 xx;
#line 2201
    get_ix_uint64(xp, &xx);
#line 2201

#line 2201
#if IX_UINT64_MAX > SCHAR_MAX
#line 2201
    if (xx > SCHAR_MAX) {
#line 2201
#ifdef ERANGE_FILL
#line 2201
        *ip = NC_FILL_BYTE;
#line 2201
        return NC_ERANGE;
#line 2201
#else
#line 2201
        err = NC_ERANGE;
#line 2201
#endif
#line 2201
    }
#line 2201
#endif
#line 2201

#line 2201

#line 2201
    *ip = (schar) xx;
#line 2201
    return err;
#line 2201
}
#line 2201

static int
#line 2202
ncx_get_ulonglong_short(const void *xp, short *ip)
#line 2202
{
#line 2202
    int err=NC_NOERR;
#line 2202
    ix_uint64 xx;
#line 2202
    get_ix_uint64(xp, &xx);
#line 2202

#line 2202
#if IX_UINT64_MAX > SHORT_MAX
#line 2202
    if (xx > SHORT_MAX) {
#line 2202
#ifdef ERANGE_FILL
#line 2202
        *ip = NC_FILL_SHORT;
#line 2202
        return NC_ERANGE;
#line 2202
#else
#line 2202
        err = NC_ERANGE;
#line 2202
#endif
#line 2202
    }
#line 2202
#endif
#line 2202

#line 2202

#line 2202
    *ip = (short) xx;
#line 2202
    return err;
#line 2202
}
#line 2202

static int
#line 2203
ncx_get_ulonglong_int(const void *xp, int *ip)
#line 2203
{
#line 2203
    int err=NC_NOERR;
#line 2203
    ix_uint64 xx;
#line 2203
    get_ix_uint64(xp, &xx);
#line 2203

#line 2203
#if IX_UINT64_MAX > INT_MAX
#line 2203
    if (xx > INT_MAX) {
#line 2203
#ifdef ERANGE_FILL
#line 2203
        *ip = NC_FILL_INT;
#line 2203
        return NC_ERANGE;
#line 2203
#else
#line 2203
        err = NC_ERANGE;
#line 2203
#endif
#line 2203
    }
#line 2203
#endif
#line 2203

#line 2203

#line 2203
    *ip = (int) xx;
#line 2203
    return err;
#line 2203
}
#line 2203

static int
#line 2204
ncx_get_ulonglong_long(const void *xp, long *ip)
#line 2204
{
#line 2204
    int err=NC_NOERR;
#line 2204
    ix_uint64 xx;
#line 2204
    get_ix_uint64(xp, &xx);
#line 2204

#line 2204
#if IX_UINT64_MAX > LONG_MAX
#line 2204
    if (xx > LONG_MAX) {
#line 2204
#ifdef ERANGE_FILL
#line 2204
        *ip = NC_FILL_INT;
#line 2204
        return NC_ERANGE;
#line 2204
#else
#line 2204
        err = NC_ERANGE;
#line 2204
#endif
#line 2204
    }
#line 2204
#endif
#line 2204

#line 2204

#line 2204
    *ip = (long) xx;
#line 2204
    return err;
#line 2204
}
#line 2204

static int
#line 2205
ncx_get_ulonglong_longlong(const void *xp, longlong *ip)
#line 2205
{
#line 2205
    int err=NC_NOERR;
#line 2205
    ix_uint64 xx;
#line 2205
    get_ix_uint64(xp, &xx);
#line 2205

#line 2205
#if IX_UINT64_MAX > LONGLONG_MAX
#line 2205
    if (xx > LONGLONG_MAX) {
#line 2205
#ifdef ERANGE_FILL
#line 2205
        *ip = NC_FILL_INT64;
#line 2205
        return NC_ERANGE;
#line 2205
#else
#line 2205
        err = NC_ERANGE;
#line 2205
#endif
#line 2205
    }
#line 2205
#endif
#line 2205

#line 2205

#line 2205
    *ip = (longlong) xx;
#line 2205
    return err;
#line 2205
}
#line 2205

static int
#line 2206
ncx_get_ulonglong_ushort(const void *xp, ushort *ip)
#line 2206
{
#line 2206
    int err=NC_NOERR;
#line 2206
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2206
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2206
#else
#line 2206
    ix_uint64 xx;
#line 2206
    get_ix_uint64(xp, &xx);
#line 2206

#line 2206
#if IX_UINT64_MAX > USHORT_MAX
#line 2206
    if (xx > USHORT_MAX) {
#line 2206
#ifdef ERANGE_FILL
#line 2206
        *ip = NC_FILL_USHORT;
#line 2206
        return NC_ERANGE;
#line 2206
#else
#line 2206
        err = NC_ERANGE;
#line 2206
#endif
#line 2206
    }
#line 2206
#endif
#line 2206

#line 2206

#line 2206
    *ip = (ushort) xx;
#line 2206
#endif
#line 2206
    return err;
#line 2206
}
#line 2206

static int
#line 2207
ncx_get_ulonglong_uchar(const void *xp, uchar *ip)
#line 2207
{
#line 2207
    int err=NC_NOERR;
#line 2207
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 2207
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2207
#else
#line 2207
    ix_uint64 xx;
#line 2207
    get_ix_uint64(xp, &xx);
#line 2207

#line 2207
#if IX_UINT64_MAX > UCHAR_MAX
#line 2207
    if (xx > UCHAR_MAX) {
#line 2207
#ifdef ERANGE_FILL
#line 2207
        *ip = NC_FILL_UBYTE;
#line 2207
        return NC_ERANGE;
#line 2207
#else
#line 2207
        err = NC_ERANGE;
#line 2207
#endif
#line 2207
    }
#line 2207
#endif
#line 2207

#line 2207

#line 2207
    *ip = (uchar) xx;
#line 2207
#endif
#line 2207
    return err;
#line 2207
}
#line 2207

static int
#line 2208
ncx_get_ulonglong_uint(const void *xp, uint *ip)
#line 2208
{
#line 2208
    int err=NC_NOERR;
#line 2208
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2208
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2208
#else
#line 2208
    ix_uint64 xx;
#line 2208
    get_ix_uint64(xp, &xx);
#line 2208

#line 2208
#if IX_UINT64_MAX > UINT_MAX
#line 2208
    if (xx > UINT_MAX) {
#line 2208
#ifdef ERANGE_FILL
#line 2208
        *ip = NC_FILL_UINT;
#line 2208
        return NC_ERANGE;
#line 2208
#else
#line 2208
        err = NC_ERANGE;
#line 2208
#endif
#line 2208
    }
#line 2208
#endif
#line 2208

#line 2208

#line 2208
    *ip = (uint) xx;
#line 2208
#endif
#line 2208
    return err;
#line 2208
}
#line 2208

static int
#line 2209
ncx_get_ulonglong_float(const void *xp, float *ip)
#line 2209
{
#line 2209
	ix_uint64 xx;
#line 2209
	get_ix_uint64(xp, &xx);
#line 2209
	*ip = (float)xx;
#line 2209
	return NC_NOERR;
#line 2209
}
#line 2209

static int
#line 2210
ncx_get_ulonglong_double(const void *xp, double *ip)
#line 2210
{
#line 2210
	ix_uint64 xx;
#line 2210
	get_ix_uint64(xp, &xx);
#line 2210
	*ip = (double)xx;
#line 2210
	return NC_NOERR;
#line 2210
}
#line 2210


#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 2213
ncx_put_ulonglong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2213
{
#line 2213
    int err=NC_NOERR;
#line 2213
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 2213
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2213
#else
#line 2213
    ix_uint64 xx = NC_FILL_UINT64;
#line 2213

#line 2213
#if IX_UINT64_MAX < ULONGLONG_MAX
#line 2213
    if (*ip > IX_UINT64_MAX) {
#line 2213
        
#line 2213
#ifdef ERANGE_FILL
#line 2213
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2213
#endif
#line 2213
        err = NC_ERANGE;
#line 2213
    }
#line 2213
#ifdef ERANGE_FILL
#line 2213
    else
#line 2213
#endif
#line 2213
#endif
#line 2213
        xx = (ix_uint64)*ip;
#line 2213

#line 2213
    put_ix_uint64(xp, &xx);
#line 2213
#endif
#line 2213
    return err;
#line 2213
}
#line 2213

#endif
static int
#line 2215
ncx_put_ulonglong_schar(void *xp, const schar *ip, void *fillp)
#line 2215
{
#line 2215
    int err=NC_NOERR;
#line 2215
    ix_uint64 xx = NC_FILL_UINT64;
#line 2215

#line 2215
#if IX_UINT64_MAX < SCHAR_MAX
#line 2215
    if (*ip > IX_UINT64_MAX) {
#line 2215
        
#line 2215
#ifdef ERANGE_FILL
#line 2215
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2215
#endif
#line 2215
        err = NC_ERANGE;
#line 2215
    }
#line 2215
#ifdef ERANGE_FILL
#line 2215
    else
#line 2215
#endif
#line 2215
#endif
#line 2215
    if (*ip < 0) {
#line 2215
        
#line 2215
#ifdef ERANGE_FILL
#line 2215
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2215
#endif
#line 2215
        err = NC_ERANGE; /* because xp is unsigned */
#line 2215
    }
#line 2215
#ifdef ERANGE_FILL
#line 2215
    else
#line 2215
#endif
#line 2215
        xx = (ix_uint64)*ip;
#line 2215

#line 2215
    put_ix_uint64(xp, &xx);
#line 2215
    return err;
#line 2215
}
#line 2215

static int
#line 2216
ncx_put_ulonglong_short(void *xp, const short *ip, void *fillp)
#line 2216
{
#line 2216
    int err=NC_NOERR;
#line 2216
    ix_uint64 xx = NC_FILL_UINT64;
#line 2216

#line 2216
#if IX_UINT64_MAX < SHORT_MAX
#line 2216
    if (*ip > IX_UINT64_MAX) {
#line 2216
        
#line 2216
#ifdef ERANGE_FILL
#line 2216
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2216
#endif
#line 2216
        err = NC_ERANGE;
#line 2216
    }
#line 2216
#ifdef ERANGE_FILL
#line 2216
    else
#line 2216
#endif
#line 2216
#endif
#line 2216
    if (*ip < 0) {
#line 2216
        
#line 2216
#ifdef ERANGE_FILL
#line 2216
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2216
#endif
#line 2216
        err = NC_ERANGE; /* because xp is unsigned */
#line 2216
    }
#line 2216
#ifdef ERANGE_FILL
#line 2216
    else
#line 2216
#endif
#line 2216
        xx = (ix_uint64)*ip;
#line 2216

#line 2216
    put_ix_uint64(xp, &xx);
#line 2216
    return err;
#line 2216
}
#line 2216

static int
#line 2217
ncx_put_ulonglong_int(void *xp, const int *ip, void *fillp)
#line 2217
{
#line 2217
    int err=NC_NOERR;
#line 2217
    ix_uint64 xx = NC_FILL_UINT64;
#line 2217

#line 2217
#if IX_UINT64_MAX < INT_MAX
#line 2217
    if (*ip > IX_UINT64_MAX) {
#line 2217
        
#line 2217
#ifdef ERANGE_FILL
#line 2217
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2217
#endif
#line 2217
        err = NC_ERANGE;
#line 2217
    }
#line 2217
#ifdef ERANGE_FILL
#line 2217
    else
#line 2217
#endif
#line 2217
#endif
#line 2217
    if (*ip < 0) {
#line 2217
        
#line 2217
#ifdef ERANGE_FILL
#line 2217
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2217
#endif
#line 2217
        err = NC_ERANGE; /* because xp is unsigned */
#line 2217
    }
#line 2217
#ifdef ERANGE_FILL
#line 2217
    else
#line 2217
#endif
#line 2217
        xx = (ix_uint64)*ip;
#line 2217

#line 2217
    put_ix_uint64(xp, &xx);
#line 2217
    return err;
#line 2217
}
#line 2217

static int
#line 2218
ncx_put_ulonglong_long(void *xp, const long *ip, void *fillp)
#line 2218
{
#line 2218
    int err=NC_NOERR;
#line 2218
    ix_uint64 xx = NC_FILL_UINT64;
#line 2218

#line 2218
#if IX_UINT64_MAX < LONG_MAX
#line 2218
    if (*ip > IX_UINT64_MAX) {
#line 2218
        
#line 2218
#ifdef ERANGE_FILL
#line 2218
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2218
#endif
#line 2218
        err = NC_ERANGE;
#line 2218
    }
#line 2218
#ifdef ERANGE_FILL
#line 2218
    else
#line 2218
#endif
#line 2218
#endif
#line 2218
    if (*ip < 0) {
#line 2218
        
#line 2218
#ifdef ERANGE_FILL
#line 2218
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2218
#endif
#line 2218
        err = NC_ERANGE; /* because xp is unsigned */
#line 2218
    }
#line 2218
#ifdef ERANGE_FILL
#line 2218
    else
#line 2218
#endif
#line 2218
        xx = (ix_uint64)*ip;
#line 2218

#line 2218
    put_ix_uint64(xp, &xx);
#line 2218
    return err;
#line 2218
}
#line 2218

static int
#line 2219
ncx_put_ulonglong_longlong(void *xp, const longlong *ip, void *fillp)
#line 2219
{
#line 2219
    int err=NC_NOERR;
#line 2219
    ix_uint64 xx = NC_FILL_UINT64;
#line 2219

#line 2219
#if IX_UINT64_MAX < LONGLONG_MAX
#line 2219
    if (*ip > IX_UINT64_MAX) {
#line 2219
        
#line 2219
#ifdef ERANGE_FILL
#line 2219
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2219
#endif
#line 2219
        err = NC_ERANGE;
#line 2219
    }
#line 2219
#ifdef ERANGE_FILL
#line 2219
    else
#line 2219
#endif
#line 2219
#endif
#line 2219
    if (*ip < 0) {
#line 2219
        
#line 2219
#ifdef ERANGE_FILL
#line 2219
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2219
#endif
#line 2219
        err = NC_ERANGE; /* because xp is unsigned */
#line 2219
    }
#line 2219
#ifdef ERANGE_FILL
#line 2219
    else
#line 2219
#endif
#line 2219
        xx = (ix_uint64)*ip;
#line 2219

#line 2219
    put_ix_uint64(xp, &xx);
#line 2219
    return err;
#line 2219
}
#line 2219

static int
#line 2220
ncx_put_ulonglong_uchar(void *xp, const uchar *ip, void *fillp)
#line 2220
{
#line 2220
    int err=NC_NOERR;
#line 2220
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 2220
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2220
#else
#line 2220
    ix_uint64 xx = NC_FILL_UINT64;
#line 2220

#line 2220
#if IX_UINT64_MAX < UCHAR_MAX
#line 2220
    if (*ip > IX_UINT64_MAX) {
#line 2220
        
#line 2220
#ifdef ERANGE_FILL
#line 2220
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2220
#endif
#line 2220
        err = NC_ERANGE;
#line 2220
    }
#line 2220
#ifdef ERANGE_FILL
#line 2220
    else
#line 2220
#endif
#line 2220
#endif
#line 2220
        xx = (ix_uint64)*ip;
#line 2220

#line 2220
    put_ix_uint64(xp, &xx);
#line 2220
#endif
#line 2220
    return err;
#line 2220
}
#line 2220

static int
#line 2221
ncx_put_ulonglong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2221
{
#line 2221
    int err=NC_NOERR;
#line 2221
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2221
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2221
#else
#line 2221
    ix_uint64 xx = NC_FILL_UINT64;
#line 2221

#line 2221
#if IX_UINT64_MAX < USHORT_MAX
#line 2221
    if (*ip > IX_UINT64_MAX) {
#line 2221
        
#line 2221
#ifdef ERANGE_FILL
#line 2221
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2221
#endif
#line 2221
        err = NC_ERANGE;
#line 2221
    }
#line 2221
#ifdef ERANGE_FILL
#line 2221
    else
#line 2221
#endif
#line 2221
#endif
#line 2221
        xx = (ix_uint64)*ip;
#line 2221

#line 2221
    put_ix_uint64(xp, &xx);
#line 2221
#endif
#line 2221
    return err;
#line 2221
}
#line 2221

static int
#line 2222
ncx_put_ulonglong_uint(void *xp, const uint *ip, void *fillp)
#line 2222
{
#line 2222
    int err=NC_NOERR;
#line 2222
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2222
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2222
#else
#line 2222
    ix_uint64 xx = NC_FILL_UINT64;
#line 2222

#line 2222
#if IX_UINT64_MAX < UINT_MAX
#line 2222
    if (*ip > IX_UINT64_MAX) {
#line 2222
        
#line 2222
#ifdef ERANGE_FILL
#line 2222
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2222
#endif
#line 2222
        err = NC_ERANGE;
#line 2222
    }
#line 2222
#ifdef ERANGE_FILL
#line 2222
    else
#line 2222
#endif
#line 2222
#endif
#line 2222
        xx = (ix_uint64)*ip;
#line 2222

#line 2222
    put_ix_uint64(xp, &xx);
#line 2222
#endif
#line 2222
    return err;
#line 2222
}
#line 2222

static int
#line 2223
ncx_put_ulonglong_float(void *xp, const float *ip, void *fillp)
#line 2223
{
#line 2223
    int err=NC_NOERR;
#line 2223
    ix_uint64 xx = NC_FILL_UINT64;
#line 2223

#line 2223
    if (*ip > (double)X_UINT64_MAX || *ip < 0) {
#line 2223
        
#line 2223
#ifdef ERANGE_FILL
#line 2223
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2223
#endif
#line 2223
        err = NC_ERANGE;
#line 2223
    }
#line 2223
#ifdef ERANGE_FILL
#line 2223
    else
#line 2223
#endif
#line 2223
        xx = (ix_uint64)*ip;
#line 2223

#line 2223
    put_ix_uint64(xp, &xx);
#line 2223
    return err;
#line 2223
}
#line 2223

static int
#line 2224
ncx_put_ulonglong_double(void *xp, const double *ip, void *fillp)
#line 2224
{
#line 2224
    int err=NC_NOERR;
#line 2224
    ix_uint64 xx = NC_FILL_UINT64;
#line 2224

#line 2224
    if (*ip > X_UINT64_MAX || *ip < 0) {
#line 2224
        
#line 2224
#ifdef ERANGE_FILL
#line 2224
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2224
#endif
#line 2224
        err = NC_ERANGE;
#line 2224
    }
#line 2224
#ifdef ERANGE_FILL
#line 2224
    else
#line 2224
#endif
#line 2224
        xx = (ix_uint64)*ip;
#line 2224

#line 2224
    put_ix_uint64(xp, &xx);
#line 2224
    return err;
#line 2224
}
#line 2224



/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp  = (unsigned)(*cp++) << 24;
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp;

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;

	/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return NC_ERANGE;
	}

	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000LL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000LL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000LL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000LL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000LL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00LL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffLL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp;
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return NC_ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return NC_ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

/*----< ncx_get_uint32() >------------------------------------------*/
int
ncx_get_uint32(const void **xpp, uint *ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ip, *xpp, SIZEOF_UINT);
#else
    const uchar *cp = (const uchar *) *xpp;

    *ip = (uint)(*cp++ << 24);
    *ip = (uint)(*ip | (uint)(*cp++ << 16));
    *ip = (uint)(*ip | (uint)(*cp++ <<  8));
    *ip = (uint)(*ip | *cp);
#endif
    /* advance *xpp 4 bytes */
    *xpp = (void *)((const char *)(*xpp) + 4);

    return NC_NOERR;
}

/*----< ncx_get_uint64() >------------------------------------------*/
int
ncx_get_uint64(const void **xpp, unsigned long long *ullp)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ullp, *xpp, SIZEOF_UINT64);
#else
    const uchar *cp = (const uchar *) *xpp;

    /* below is the same as calling swap8b(ullp, *xpp) */
    *ullp = (unsigned long long)(*cp++) << 56;
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 48);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 40);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 32);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 24);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 16);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) <<  8);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp));
#endif
    /* advance *xpp 8 bytes */
    *xpp = (void *)((const char *)(*xpp) + 8);

    return NC_NOERR;
}

/*---< ncx_put_uint32() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 32-bit integer) to xpp in Big Endian
 * form and advance *xpp 4 bytes
 */
int
ncx_put_uint32(void **xpp, const unsigned int ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT);
#else
    /* bitwise shifts below are to produce an integer in Big Endian */
    uchar *cp = (uchar *) *xpp;
    *cp++ = (uchar)((ip & 0xff000000) >> 24);
    *cp++ = (uchar)((ip & 0x00ff0000) >> 16);
    *cp++ = (uchar)((ip & 0x0000ff00) >>  8);
    *cp   = (uchar)( ip & 0x000000ff);
#endif
    /* advance *xpp 4 bytes */
    *xpp  = (void *)((char *)(*xpp) + 4);

    return NC_NOERR;
}

/*---< ncx_put_uint64() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 64-bit integer) to xpp in Big Endian
 * form and advance *xpp 8 bytes
 */
int
ncx_put_uint64(void **xpp, const unsigned long long ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT64);
#else
    uchar *cp = (uchar *) *xpp;
    /* below is the same as calling swap8b(*xpp, &ip) */
    *cp++ = (uchar) (ip                         >> 56);
    *cp++ = (uchar)((ip & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)((ip & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)((ip & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)((ip & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)((ip & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)((ip & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar) (ip & 0x00000000000000ffLL);
#endif
    /* advance *xpp 8 bytes */
    *xpp  = (void *)((char *)(*xpp) + 8);

    return NC_NOERR;
}


/*
 * Aggregate numeric conversion functions.
 */
#line 2480

#line 2883

#line 2889

/* schar ---------------------------------------------------------------------*/

#line 2893
int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2896
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2896
	return NC_NOERR;
#line 2896

}
int
#line 2898
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2898
{
#line 2898
    int status = NC_NOERR;
#line 2898
    schar *xp = (schar *)(*xpp);
#line 2898

#line 2898
    while (nelems-- != 0) {
#line 2898
        
#line 2898
        if (*xp < 0) {
#line 2898
#ifdef ERANGE_FILL
#line 2898
            *tp = NC_FILL_UBYTE;
#line 2898
#endif
#line 2898
            status = NC_ERANGE; /* because tp is unsigned */
#line 2898
            
#line 2898
#ifdef ERANGE_FILL
#line 2898
            xp++; tp++; continue;
#line 2898
#endif
#line 2898
        }
#line 2898
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2898
    }
#line 2898

#line 2898
    *xpp = (const void *)xp;
#line 2898
    return status;
#line 2898
}
#line 2898

int
#line 2899
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2899
{
#line 2899
    int status = NC_NOERR;
#line 2899
    schar *xp = (schar *)(*xpp);
#line 2899

#line 2899
    while (nelems-- != 0) {
#line 2899
        
#line 2899
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2899
    }
#line 2899

#line 2899
    *xpp = (const void *)xp;
#line 2899
    return status;
#line 2899
}
#line 2899

int
#line 2900
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2900
{
#line 2900
    int status = NC_NOERR;
#line 2900
    schar *xp = (schar *)(*xpp);
#line 2900

#line 2900
    while (nelems-- != 0) {
#line 2900
        
#line 2900
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2900
    }
#line 2900

#line 2900
    *xpp = (const void *)xp;
#line 2900
    return status;
#line 2900
}
#line 2900

int
#line 2901
ncx_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2901
{
#line 2901
    int status = NC_NOERR;
#line 2901
    schar *xp = (schar *)(*xpp);
#line 2901

#line 2901
    while (nelems-- != 0) {
#line 2901
        
#line 2901
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2901
    }
#line 2901

#line 2901
    *xpp = (const void *)xp;
#line 2901
    return status;
#line 2901
}
#line 2901

int
#line 2902
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2902
{
#line 2902
    int status = NC_NOERR;
#line 2902
    schar *xp = (schar *)(*xpp);
#line 2902

#line 2902
    while (nelems-- != 0) {
#line 2902
        
#line 2902
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2902
    }
#line 2902

#line 2902
    *xpp = (const void *)xp;
#line 2902
    return status;
#line 2902
}
#line 2902

int
#line 2903
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2903
{
#line 2903
    int status = NC_NOERR;
#line 2903
    schar *xp = (schar *)(*xpp);
#line 2903

#line 2903
    while (nelems-- != 0) {
#line 2903
        
#line 2903
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2903
    }
#line 2903

#line 2903
    *xpp = (const void *)xp;
#line 2903
    return status;
#line 2903
}
#line 2903

int
#line 2904
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2904
{
#line 2904
    int status = NC_NOERR;
#line 2904
    schar *xp = (schar *)(*xpp);
#line 2904

#line 2904
    while (nelems-- != 0) {
#line 2904
        
#line 2904
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2904
    }
#line 2904

#line 2904
    *xpp = (const void *)xp;
#line 2904
    return status;
#line 2904
}
#line 2904

int
#line 2905
ncx_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2905
{
#line 2905
    int status = NC_NOERR;
#line 2905
    schar *xp = (schar *)(*xpp);
#line 2905

#line 2905
    while (nelems-- != 0) {
#line 2905
        
#line 2905
        if (*xp < 0) {
#line 2905
#ifdef ERANGE_FILL
#line 2905
            *tp = NC_FILL_USHORT;
#line 2905
#endif
#line 2905
            status = NC_ERANGE; /* because tp is unsigned */
#line 2905
            
#line 2905
#ifdef ERANGE_FILL
#line 2905
            xp++; tp++; continue;
#line 2905
#endif
#line 2905
        }
#line 2905
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2905
    }
#line 2905

#line 2905
    *xpp = (const void *)xp;
#line 2905
    return status;
#line 2905
}
#line 2905

int
#line 2906
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2906
{
#line 2906
    int status = NC_NOERR;
#line 2906
    schar *xp = (schar *)(*xpp);
#line 2906

#line 2906
    while (nelems-- != 0) {
#line 2906
        
#line 2906
        if (*xp < 0) {
#line 2906
#ifdef ERANGE_FILL
#line 2906
            *tp = NC_FILL_UINT;
#line 2906
#endif
#line 2906
            status = NC_ERANGE; /* because tp is unsigned */
#line 2906
            
#line 2906
#ifdef ERANGE_FILL
#line 2906
            xp++; tp++; continue;
#line 2906
#endif
#line 2906
        }
#line 2906
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2906
    }
#line 2906

#line 2906
    *xpp = (const void *)xp;
#line 2906
    return status;
#line 2906
}
#line 2906

int
#line 2907
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2907
{
#line 2907
    int status = NC_NOERR;
#line 2907
    schar *xp = (schar *)(*xpp);
#line 2907

#line 2907
    while (nelems-- != 0) {
#line 2907
        
#line 2907
        if (*xp < 0) {
#line 2907
#ifdef ERANGE_FILL
#line 2907
            *tp = NC_FILL_UINT64;
#line 2907
#endif
#line 2907
            status = NC_ERANGE; /* because tp is unsigned */
#line 2907
            
#line 2907
#ifdef ERANGE_FILL
#line 2907
            xp++; tp++; continue;
#line 2907
#endif
#line 2907
        }
#line 2907
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2907
    }
#line 2907

#line 2907
    *xpp = (const void *)xp;
#line 2907
    return status;
#line 2907
}
#line 2907


#line 2910
int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2913

#line 2913
	if (rndup)
#line 2913
		rndup = X_ALIGN - rndup;
#line 2913

#line 2913
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2913
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2913

#line 2913
	return NC_NOERR;
#line 2913

}
int
#line 2915
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2915
{
#line 2915
    int status = NC_NOERR;
#line 2915
    size_t rndup = nelems % X_ALIGN;
#line 2915
    schar *xp = (schar *) *xpp;
#line 2915

#line 2915
    if (rndup)
#line 2915
        rndup = X_ALIGN - rndup;
#line 2915

#line 2915
    while (nelems-- != 0) {
#line 2915
        
#line 2915
        if (*xp < 0) {
#line 2915
#ifdef ERANGE_FILL
#line 2915
            *tp = NC_FILL_UBYTE;
#line 2915
#endif
#line 2915
            status = NC_ERANGE; /* because tp is unsigned */
#line 2915
            
#line 2915
#ifdef ERANGE_FILL
#line 2915
            xp++; tp++; continue;
#line 2915
#endif
#line 2915
        }
#line 2915
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2915
    }
#line 2915

#line 2915
    *xpp = (void *)(xp + rndup);
#line 2915
    return status;
#line 2915
}
#line 2915

int
#line 2916
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2916
{
#line 2916
    int status = NC_NOERR;
#line 2916
    size_t rndup = nelems % X_ALIGN;
#line 2916
    schar *xp = (schar *) *xpp;
#line 2916

#line 2916
    if (rndup)
#line 2916
        rndup = X_ALIGN - rndup;
#line 2916

#line 2916
    while (nelems-- != 0) {
#line 2916
        
#line 2916
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2916
    }
#line 2916

#line 2916
    *xpp = (void *)(xp + rndup);
#line 2916
    return status;
#line 2916
}
#line 2916

int
#line 2917
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2917
{
#line 2917
    int status = NC_NOERR;
#line 2917
    size_t rndup = nelems % X_ALIGN;
#line 2917
    schar *xp = (schar *) *xpp;
#line 2917

#line 2917
    if (rndup)
#line 2917
        rndup = X_ALIGN - rndup;
#line 2917

#line 2917
    while (nelems-- != 0) {
#line 2917
        
#line 2917
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2917
    }
#line 2917

#line 2917
    *xpp = (void *)(xp + rndup);
#line 2917
    return status;
#line 2917
}
#line 2917

int
#line 2918
ncx_pad_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2918
{
#line 2918
    int status = NC_NOERR;
#line 2918
    size_t rndup = nelems % X_ALIGN;
#line 2918
    schar *xp = (schar *) *xpp;
#line 2918

#line 2918
    if (rndup)
#line 2918
        rndup = X_ALIGN - rndup;
#line 2918

#line 2918
    while (nelems-- != 0) {
#line 2918
        
#line 2918
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2918
    }
#line 2918

#line 2918
    *xpp = (void *)(xp + rndup);
#line 2918
    return status;
#line 2918
}
#line 2918

int
#line 2919
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2919
{
#line 2919
    int status = NC_NOERR;
#line 2919
    size_t rndup = nelems % X_ALIGN;
#line 2919
    schar *xp = (schar *) *xpp;
#line 2919

#line 2919
    if (rndup)
#line 2919
        rndup = X_ALIGN - rndup;
#line 2919

#line 2919
    while (nelems-- != 0) {
#line 2919
        
#line 2919
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2919
    }
#line 2919

#line 2919
    *xpp = (void *)(xp + rndup);
#line 2919
    return status;
#line 2919
}
#line 2919

int
#line 2920
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2920
{
#line 2920
    int status = NC_NOERR;
#line 2920
    size_t rndup = nelems % X_ALIGN;
#line 2920
    schar *xp = (schar *) *xpp;
#line 2920

#line 2920
    if (rndup)
#line 2920
        rndup = X_ALIGN - rndup;
#line 2920

#line 2920
    while (nelems-- != 0) {
#line 2920
        
#line 2920
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2920
    }
#line 2920

#line 2920
    *xpp = (void *)(xp + rndup);
#line 2920
    return status;
#line 2920
}
#line 2920

int
#line 2921
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2921
{
#line 2921
    int status = NC_NOERR;
#line 2921
    size_t rndup = nelems % X_ALIGN;
#line 2921
    schar *xp = (schar *) *xpp;
#line 2921

#line 2921
    if (rndup)
#line 2921
        rndup = X_ALIGN - rndup;
#line 2921

#line 2921
    while (nelems-- != 0) {
#line 2921
        
#line 2921
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2921
    }
#line 2921

#line 2921
    *xpp = (void *)(xp + rndup);
#line 2921
    return status;
#line 2921
}
#line 2921

int
#line 2922
ncx_pad_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2922
{
#line 2922
    int status = NC_NOERR;
#line 2922
    size_t rndup = nelems % X_ALIGN;
#line 2922
    schar *xp = (schar *) *xpp;
#line 2922

#line 2922
    if (rndup)
#line 2922
        rndup = X_ALIGN - rndup;
#line 2922

#line 2922
    while (nelems-- != 0) {
#line 2922
        
#line 2922
        if (*xp < 0) {
#line 2922
#ifdef ERANGE_FILL
#line 2922
            *tp = NC_FILL_USHORT;
#line 2922
#endif
#line 2922
            status = NC_ERANGE; /* because tp is unsigned */
#line 2922
            
#line 2922
#ifdef ERANGE_FILL
#line 2922
            xp++; tp++; continue;
#line 2922
#endif
#line 2922
        }
#line 2922
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2922
    }
#line 2922

#line 2922
    *xpp = (void *)(xp + rndup);
#line 2922
    return status;
#line 2922
}
#line 2922

int
#line 2923
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2923
{
#line 2923
    int status = NC_NOERR;
#line 2923
    size_t rndup = nelems % X_ALIGN;
#line 2923
    schar *xp = (schar *) *xpp;
#line 2923

#line 2923
    if (rndup)
#line 2923
        rndup = X_ALIGN - rndup;
#line 2923

#line 2923
    while (nelems-- != 0) {
#line 2923
        
#line 2923
        if (*xp < 0) {
#line 2923
#ifdef ERANGE_FILL
#line 2923
            *tp = NC_FILL_UINT;
#line 2923
#endif
#line 2923
            status = NC_ERANGE; /* because tp is unsigned */
#line 2923
            
#line 2923
#ifdef ERANGE_FILL
#line 2923
            xp++; tp++; continue;
#line 2923
#endif
#line 2923
        }
#line 2923
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2923
    }
#line 2923

#line 2923
    *xpp = (void *)(xp + rndup);
#line 2923
    return status;
#line 2923
}
#line 2923

int
#line 2924
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2924
{
#line 2924
    int status = NC_NOERR;
#line 2924
    size_t rndup = nelems % X_ALIGN;
#line 2924
    schar *xp = (schar *) *xpp;
#line 2924

#line 2924
    if (rndup)
#line 2924
        rndup = X_ALIGN - rndup;
#line 2924

#line 2924
    while (nelems-- != 0) {
#line 2924
        
#line 2924
        if (*xp < 0) {
#line 2924
#ifdef ERANGE_FILL
#line 2924
            *tp = NC_FILL_UINT64;
#line 2924
#endif
#line 2924
            status = NC_ERANGE; /* because tp is unsigned */
#line 2924
            
#line 2924
#ifdef ERANGE_FILL
#line 2924
            xp++; tp++; continue;
#line 2924
#endif
#line 2924
        }
#line 2924
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2924
    }
#line 2924

#line 2924
    *xpp = (void *)(xp + rndup);
#line 2924
    return status;
#line 2924
}
#line 2924


#line 2927
int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2930
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2930

#line 2930
	return NC_NOERR;
#line 2930

}
int
#line 2932
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2932
{
#line 2932
    int status = NC_NOERR;
#line 2932
    schar *xp = (schar *) *xpp;
#line 2932

#line 2932
    while (nelems-- != 0) {
#line 2932
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2932
            
#line 2932
#ifdef ERANGE_FILL
#line 2932
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2932
#endif
#line 2932
            status = NC_ERANGE;
#line 2932
            
#line 2932
#ifdef ERANGE_FILL
#line 2932
            xp++; tp++; continue;
#line 2932
#endif
#line 2932
        }
#line 2932
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2932
    }
#line 2932

#line 2932
    *xpp = (void *)xp;
#line 2932
    return status;
#line 2932
}
#line 2932

int
#line 2933
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2933
{
#line 2933
    int status = NC_NOERR;
#line 2933
    schar *xp = (schar *) *xpp;
#line 2933

#line 2933
    while (nelems-- != 0) {
#line 2933
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2933
            
#line 2933
#ifdef ERANGE_FILL
#line 2933
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2933
#endif
#line 2933
            status = NC_ERANGE;
#line 2933
            
#line 2933
#ifdef ERANGE_FILL
#line 2933
            xp++; tp++; continue;
#line 2933
#endif
#line 2933
        }
#line 2933
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2933
    }
#line 2933

#line 2933
    *xpp = (void *)xp;
#line 2933
    return status;
#line 2933
}
#line 2933

int
#line 2934
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2934
{
#line 2934
    int status = NC_NOERR;
#line 2934
    schar *xp = (schar *) *xpp;
#line 2934

#line 2934
    while (nelems-- != 0) {
#line 2934
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2934
            
#line 2934
#ifdef ERANGE_FILL
#line 2934
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2934
#endif
#line 2934
            status = NC_ERANGE;
#line 2934
            
#line 2934
#ifdef ERANGE_FILL
#line 2934
            xp++; tp++; continue;
#line 2934
#endif
#line 2934
        }
#line 2934
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2934
    }
#line 2934

#line 2934
    *xpp = (void *)xp;
#line 2934
    return status;
#line 2934
}
#line 2934

int
#line 2935
ncx_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2935
{
#line 2935
    int status = NC_NOERR;
#line 2935
    schar *xp = (schar *) *xpp;
#line 2935

#line 2935
    while (nelems-- != 0) {
#line 2935
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2935
            
#line 2935
#ifdef ERANGE_FILL
#line 2935
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2935
#endif
#line 2935
            status = NC_ERANGE;
#line 2935
            
#line 2935
#ifdef ERANGE_FILL
#line 2935
            xp++; tp++; continue;
#line 2935
#endif
#line 2935
        }
#line 2935
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2935
    }
#line 2935

#line 2935
    *xpp = (void *)xp;
#line 2935
    return status;
#line 2935
}
#line 2935

int
#line 2936
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2936
{
#line 2936
    int status = NC_NOERR;
#line 2936
    schar *xp = (schar *) *xpp;
#line 2936

#line 2936
    while (nelems-- != 0) {
#line 2936
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2936
            
#line 2936
#ifdef ERANGE_FILL
#line 2936
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2936
#endif
#line 2936
            status = NC_ERANGE;
#line 2936
            
#line 2936
#ifdef ERANGE_FILL
#line 2936
            xp++; tp++; continue;
#line 2936
#endif
#line 2936
        }
#line 2936
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2936
    }
#line 2936

#line 2936
    *xpp = (void *)xp;
#line 2936
    return status;
#line 2936
}
#line 2936

int
#line 2937
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2937
{
#line 2937
    int status = NC_NOERR;
#line 2937
    schar *xp = (schar *) *xpp;
#line 2937

#line 2937
    while (nelems-- != 0) {
#line 2937
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2937
            
#line 2937
#ifdef ERANGE_FILL
#line 2937
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2937
#endif
#line 2937
            status = NC_ERANGE;
#line 2937
            
#line 2937
#ifdef ERANGE_FILL
#line 2937
            xp++; tp++; continue;
#line 2937
#endif
#line 2937
        }
#line 2937
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2937
    }
#line 2937

#line 2937
    *xpp = (void *)xp;
#line 2937
    return status;
#line 2937
}
#line 2937

int
#line 2938
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2938
{
#line 2938
    int status = NC_NOERR;
#line 2938
    schar *xp = (schar *) *xpp;
#line 2938

#line 2938
    while (nelems-- != 0) {
#line 2938
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2938
            
#line 2938
#ifdef ERANGE_FILL
#line 2938
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2938
#endif
#line 2938
            status = NC_ERANGE;
#line 2938
            
#line 2938
#ifdef ERANGE_FILL
#line 2938
            xp++; tp++; continue;
#line 2938
#endif
#line 2938
        }
#line 2938
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2938
    }
#line 2938

#line 2938
    *xpp = (void *)xp;
#line 2938
    return status;
#line 2938
}
#line 2938

int
#line 2939
ncx_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2939
{
#line 2939
    int status = NC_NOERR;
#line 2939
    schar *xp = (schar *) *xpp;
#line 2939

#line 2939
    while (nelems-- != 0) {
#line 2939
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2939
            
#line 2939
#ifdef ERANGE_FILL
#line 2939
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2939
#endif
#line 2939
            status = NC_ERANGE;
#line 2939
            
#line 2939
#ifdef ERANGE_FILL
#line 2939
            xp++; tp++; continue;
#line 2939
#endif
#line 2939
        }
#line 2939
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2939
    }
#line 2939

#line 2939
    *xpp = (void *)xp;
#line 2939
    return status;
#line 2939
}
#line 2939

int
#line 2940
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2940
{
#line 2940
    int status = NC_NOERR;
#line 2940
    schar *xp = (schar *) *xpp;
#line 2940

#line 2940
    while (nelems-- != 0) {
#line 2940
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2940
            
#line 2940
#ifdef ERANGE_FILL
#line 2940
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2940
#endif
#line 2940
            status = NC_ERANGE;
#line 2940
            
#line 2940
#ifdef ERANGE_FILL
#line 2940
            xp++; tp++; continue;
#line 2940
#endif
#line 2940
        }
#line 2940
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2940
    }
#line 2940

#line 2940
    *xpp = (void *)xp;
#line 2940
    return status;
#line 2940
}
#line 2940

int
#line 2941
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2941
{
#line 2941
    int status = NC_NOERR;
#line 2941
    schar *xp = (schar *) *xpp;
#line 2941

#line 2941
    while (nelems-- != 0) {
#line 2941
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2941
            
#line 2941
#ifdef ERANGE_FILL
#line 2941
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2941
#endif
#line 2941
            status = NC_ERANGE;
#line 2941
            
#line 2941
#ifdef ERANGE_FILL
#line 2941
            xp++; tp++; continue;
#line 2941
#endif
#line 2941
        }
#line 2941
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2941
    }
#line 2941

#line 2941
    *xpp = (void *)xp;
#line 2941
    return status;
#line 2941
}
#line 2941


#line 2944
int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2947

#line 2947
	if (rndup)
#line 2947
		rndup = X_ALIGN - rndup;
#line 2947

#line 2947
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2947
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2947

#line 2947
	if (rndup)
#line 2947
	{
#line 2947
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 2947
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2947
	}
#line 2947

#line 2947
	return NC_NOERR;
#line 2947

}
int
#line 2949
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2949
{
#line 2949
    int status = NC_NOERR;
#line 2949
    size_t rndup = nelems % X_ALIGN;
#line 2949
    schar *xp = (schar *) *xpp;
#line 2949

#line 2949
    if (rndup) rndup = X_ALIGN - rndup;
#line 2949

#line 2949
    while (nelems-- != 0) {
#line 2949
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2949
            
#line 2949
#ifdef ERANGE_FILL
#line 2949
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2949
#endif
#line 2949
            status = NC_ERANGE;
#line 2949
            
#line 2949
#ifdef ERANGE_FILL
#line 2949
            xp++; tp++; continue;
#line 2949
#endif
#line 2949
        }
#line 2949
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2949
    }
#line 2949

#line 2949

#line 2949
    if (rndup) {
#line 2949
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2949
        xp += rndup;
#line 2949
    }
#line 2949

#line 2949
    *xpp = (void *)xp;
#line 2949
    return status;
#line 2949
}
#line 2949

int
#line 2950
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2950
{
#line 2950
    int status = NC_NOERR;
#line 2950
    size_t rndup = nelems % X_ALIGN;
#line 2950
    schar *xp = (schar *) *xpp;
#line 2950

#line 2950
    if (rndup) rndup = X_ALIGN - rndup;
#line 2950

#line 2950
    while (nelems-- != 0) {
#line 2950
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2950
            
#line 2950
#ifdef ERANGE_FILL
#line 2950
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2950
#endif
#line 2950
            status = NC_ERANGE;
#line 2950
            
#line 2950
#ifdef ERANGE_FILL
#line 2950
            xp++; tp++; continue;
#line 2950
#endif
#line 2950
        }
#line 2950
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2950
    }
#line 2950

#line 2950

#line 2950
    if (rndup) {
#line 2950
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2950
        xp += rndup;
#line 2950
    }
#line 2950

#line 2950
    *xpp = (void *)xp;
#line 2950
    return status;
#line 2950
}
#line 2950

int
#line 2951
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2951
{
#line 2951
    int status = NC_NOERR;
#line 2951
    size_t rndup = nelems % X_ALIGN;
#line 2951
    schar *xp = (schar *) *xpp;
#line 2951

#line 2951
    if (rndup) rndup = X_ALIGN - rndup;
#line 2951

#line 2951
    while (nelems-- != 0) {
#line 2951
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2951
            
#line 2951
#ifdef ERANGE_FILL
#line 2951
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2951
#endif
#line 2951
            status = NC_ERANGE;
#line 2951
            
#line 2951
#ifdef ERANGE_FILL
#line 2951
            xp++; tp++; continue;
#line 2951
#endif
#line 2951
        }
#line 2951
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2951
    }
#line 2951

#line 2951

#line 2951
    if (rndup) {
#line 2951
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2951
        xp += rndup;
#line 2951
    }
#line 2951

#line 2951
    *xpp = (void *)xp;
#line 2951
    return status;
#line 2951
}
#line 2951

int
#line 2952
ncx_pad_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2952
{
#line 2952
    int status = NC_NOERR;
#line 2952
    size_t rndup = nelems % X_ALIGN;
#line 2952
    schar *xp = (schar *) *xpp;
#line 2952

#line 2952
    if (rndup) rndup = X_ALIGN - rndup;
#line 2952

#line 2952
    while (nelems-- != 0) {
#line 2952
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2952
            
#line 2952
#ifdef ERANGE_FILL
#line 2952
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2952
#endif
#line 2952
            status = NC_ERANGE;
#line 2952
            
#line 2952
#ifdef ERANGE_FILL
#line 2952
            xp++; tp++; continue;
#line 2952
#endif
#line 2952
        }
#line 2952
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2952
    }
#line 2952

#line 2952

#line 2952
    if (rndup) {
#line 2952
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2952
        xp += rndup;
#line 2952
    }
#line 2952

#line 2952
    *xpp = (void *)xp;
#line 2952
    return status;
#line 2952
}
#line 2952

int
#line 2953
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2953
{
#line 2953
    int status = NC_NOERR;
#line 2953
    size_t rndup = nelems % X_ALIGN;
#line 2953
    schar *xp = (schar *) *xpp;
#line 2953

#line 2953
    if (rndup) rndup = X_ALIGN - rndup;
#line 2953

#line 2953
    while (nelems-- != 0) {
#line 2953
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2953
            
#line 2953
#ifdef ERANGE_FILL
#line 2953
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2953
#endif
#line 2953
            status = NC_ERANGE;
#line 2953
            
#line 2953
#ifdef ERANGE_FILL
#line 2953
            xp++; tp++; continue;
#line 2953
#endif
#line 2953
        }
#line 2953
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2953
    }
#line 2953

#line 2953

#line 2953
    if (rndup) {
#line 2953
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2953
        xp += rndup;
#line 2953
    }
#line 2953

#line 2953
    *xpp = (void *)xp;
#line 2953
    return status;
#line 2953
}
#line 2953

int
#line 2954
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2954
{
#line 2954
    int status = NC_NOERR;
#line 2954
    size_t rndup = nelems % X_ALIGN;
#line 2954
    schar *xp = (schar *) *xpp;
#line 2954

#line 2954
    if (rndup) rndup = X_ALIGN - rndup;
#line 2954

#line 2954
    while (nelems-- != 0) {
#line 2954
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2954
            
#line 2954
#ifdef ERANGE_FILL
#line 2954
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2954
#endif
#line 2954
            status = NC_ERANGE;
#line 2954
            
#line 2954
#ifdef ERANGE_FILL
#line 2954
            xp++; tp++; continue;
#line 2954
#endif
#line 2954
        }
#line 2954
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2954
    }
#line 2954

#line 2954

#line 2954
    if (rndup) {
#line 2954
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2954
        xp += rndup;
#line 2954
    }
#line 2954

#line 2954
    *xpp = (void *)xp;
#line 2954
    return status;
#line 2954
}
#line 2954

int
#line 2955
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2955
{
#line 2955
    int status = NC_NOERR;
#line 2955
    size_t rndup = nelems % X_ALIGN;
#line 2955
    schar *xp = (schar *) *xpp;
#line 2955

#line 2955
    if (rndup) rndup = X_ALIGN - rndup;
#line 2955

#line 2955
    while (nelems-- != 0) {
#line 2955
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2955
            
#line 2955
#ifdef ERANGE_FILL
#line 2955
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2955
#endif
#line 2955
            status = NC_ERANGE;
#line 2955
            
#line 2955
#ifdef ERANGE_FILL
#line 2955
            xp++; tp++; continue;
#line 2955
#endif
#line 2955
        }
#line 2955
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2955
    }
#line 2955

#line 2955

#line 2955
    if (rndup) {
#line 2955
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2955
        xp += rndup;
#line 2955
    }
#line 2955

#line 2955
    *xpp = (void *)xp;
#line 2955
    return status;
#line 2955
}
#line 2955

int
#line 2956
ncx_pad_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2956
{
#line 2956
    int status = NC_NOERR;
#line 2956
    size_t rndup = nelems % X_ALIGN;
#line 2956
    schar *xp = (schar *) *xpp;
#line 2956

#line 2956
    if (rndup) rndup = X_ALIGN - rndup;
#line 2956

#line 2956
    while (nelems-- != 0) {
#line 2956
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2956
            
#line 2956
#ifdef ERANGE_FILL
#line 2956
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2956
#endif
#line 2956
            status = NC_ERANGE;
#line 2956
            
#line 2956
#ifdef ERANGE_FILL
#line 2956
            xp++; tp++; continue;
#line 2956
#endif
#line 2956
        }
#line 2956
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2956
    }
#line 2956

#line 2956

#line 2956
    if (rndup) {
#line 2956
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2956
        xp += rndup;
#line 2956
    }
#line 2956

#line 2956
    *xpp = (void *)xp;
#line 2956
    return status;
#line 2956
}
#line 2956

int
#line 2957
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2957
{
#line 2957
    int status = NC_NOERR;
#line 2957
    size_t rndup = nelems % X_ALIGN;
#line 2957
    schar *xp = (schar *) *xpp;
#line 2957

#line 2957
    if (rndup) rndup = X_ALIGN - rndup;
#line 2957

#line 2957
    while (nelems-- != 0) {
#line 2957
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2957
            
#line 2957
#ifdef ERANGE_FILL
#line 2957
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2957
#endif
#line 2957
            status = NC_ERANGE;
#line 2957
            
#line 2957
#ifdef ERANGE_FILL
#line 2957
            xp++; tp++; continue;
#line 2957
#endif
#line 2957
        }
#line 2957
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2957
    }
#line 2957

#line 2957

#line 2957
    if (rndup) {
#line 2957
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2957
        xp += rndup;
#line 2957
    }
#line 2957

#line 2957
    *xpp = (void *)xp;
#line 2957
    return status;
#line 2957
}
#line 2957

int
#line 2958
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2958
{
#line 2958
    int status = NC_NOERR;
#line 2958
    size_t rndup = nelems % X_ALIGN;
#line 2958
    schar *xp = (schar *) *xpp;
#line 2958

#line 2958
    if (rndup) rndup = X_ALIGN - rndup;
#line 2958

#line 2958
    while (nelems-- != 0) {
#line 2958
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2958
            
#line 2958
#ifdef ERANGE_FILL
#line 2958
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2958
#endif
#line 2958
            status = NC_ERANGE;
#line 2958
            
#line 2958
#ifdef ERANGE_FILL
#line 2958
            xp++; tp++; continue;
#line 2958
#endif
#line 2958
        }
#line 2958
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2958
    }
#line 2958

#line 2958

#line 2958
    if (rndup) {
#line 2958
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2958
        xp += rndup;
#line 2958
    }
#line 2958

#line 2958
    *xpp = (void *)xp;
#line 2958
    return status;
#line 2958
}
#line 2958



/* uchar ---------------------------------------------------------------------*/
#line 2964
int
ncx_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *)(*xpp);

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
       	    status = NC_ERANGE;
            
#line 2974
#ifdef ERANGE_FILL
#line 2974
            xp++; tp++; continue;
#line 2974
#endif
        }
	*tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (const void *)xp;
    return status;
}
#line 2983
int
ncx_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2986
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2986
	return NC_NOERR;
#line 2986

}
int
#line 2988
ncx_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2988
{
#line 2988
    int status = NC_NOERR;
#line 2988
    uchar *xp = (uchar *)(*xpp);
#line 2988

#line 2988
    while (nelems-- != 0) {
#line 2988
        
#line 2988
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 2988
    }
#line 2988

#line 2988
    *xpp = (const void *)xp;
#line 2988
    return status;
#line 2988
}
#line 2988

int
#line 2989
ncx_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2989
{
#line 2989
    int status = NC_NOERR;
#line 2989
    uchar *xp = (uchar *)(*xpp);
#line 2989

#line 2989
    while (nelems-- != 0) {
#line 2989
        
#line 2989
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 2989
    }
#line 2989

#line 2989
    *xpp = (const void *)xp;
#line 2989
    return status;
#line 2989
}
#line 2989

int
#line 2990
ncx_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 2990
{
#line 2990
    int status = NC_NOERR;
#line 2990
    uchar *xp = (uchar *)(*xpp);
#line 2990

#line 2990
    while (nelems-- != 0) {
#line 2990
        
#line 2990
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 2990
    }
#line 2990

#line 2990
    *xpp = (const void *)xp;
#line 2990
    return status;
#line 2990
}
#line 2990

int
#line 2991
ncx_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2991
{
#line 2991
    int status = NC_NOERR;
#line 2991
    uchar *xp = (uchar *)(*xpp);
#line 2991

#line 2991
    while (nelems-- != 0) {
#line 2991
        
#line 2991
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 2991
    }
#line 2991

#line 2991
    *xpp = (const void *)xp;
#line 2991
    return status;
#line 2991
}
#line 2991

int
#line 2992
ncx_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2992
{
#line 2992
    int status = NC_NOERR;
#line 2992
    uchar *xp = (uchar *)(*xpp);
#line 2992

#line 2992
    while (nelems-- != 0) {
#line 2992
        
#line 2992
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 2992
    }
#line 2992

#line 2992
    *xpp = (const void *)xp;
#line 2992
    return status;
#line 2992
}
#line 2992

int
#line 2993
ncx_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2993
{
#line 2993
    int status = NC_NOERR;
#line 2993
    uchar *xp = (uchar *)(*xpp);
#line 2993

#line 2993
    while (nelems-- != 0) {
#line 2993
        
#line 2993
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 2993
    }
#line 2993

#line 2993
    *xpp = (const void *)xp;
#line 2993
    return status;
#line 2993
}
#line 2993

int
#line 2994
ncx_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2994
{
#line 2994
    int status = NC_NOERR;
#line 2994
    uchar *xp = (uchar *)(*xpp);
#line 2994

#line 2994
    while (nelems-- != 0) {
#line 2994
        
#line 2994
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 2994
    }
#line 2994

#line 2994
    *xpp = (const void *)xp;
#line 2994
    return status;
#line 2994
}
#line 2994

int
#line 2995
ncx_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2995
{
#line 2995
    int status = NC_NOERR;
#line 2995
    uchar *xp = (uchar *)(*xpp);
#line 2995

#line 2995
    while (nelems-- != 0) {
#line 2995
        
#line 2995
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 2995
    }
#line 2995

#line 2995
    *xpp = (const void *)xp;
#line 2995
    return status;
#line 2995
}
#line 2995

int
#line 2996
ncx_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2996
{
#line 2996
    int status = NC_NOERR;
#line 2996
    uchar *xp = (uchar *)(*xpp);
#line 2996

#line 2996
    while (nelems-- != 0) {
#line 2996
        
#line 2996
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 2996
    }
#line 2996

#line 2996
    *xpp = (const void *)xp;
#line 2996
    return status;
#line 2996
}
#line 2996


#line 2999
int
ncx_pad_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
            status = NC_ERANGE;
            
#line 3012
#ifdef ERANGE_FILL
#line 3012
            xp++; tp++; continue;
#line 3012
#endif
        }
        *tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (void *)(xp + rndup);
    return status;
}
#line 3021
int
ncx_pad_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 3024

#line 3024
	if (rndup)
#line 3024
		rndup = X_ALIGN - rndup;
#line 3024

#line 3024
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3024
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3024

#line 3024
	return NC_NOERR;
#line 3024

}
int
#line 3026
ncx_pad_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 3026
{
#line 3026
    int status = NC_NOERR;
#line 3026
    size_t rndup = nelems % X_ALIGN;
#line 3026
    uchar *xp = (uchar *) *xpp;
#line 3026

#line 3026
    if (rndup)
#line 3026
        rndup = X_ALIGN - rndup;
#line 3026

#line 3026
    while (nelems-- != 0) {
#line 3026
        
#line 3026
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 3026
    }
#line 3026

#line 3026
    *xpp = (void *)(xp + rndup);
#line 3026
    return status;
#line 3026
}
#line 3026

int
#line 3027
ncx_pad_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 3027
{
#line 3027
    int status = NC_NOERR;
#line 3027
    size_t rndup = nelems % X_ALIGN;
#line 3027
    uchar *xp = (uchar *) *xpp;
#line 3027

#line 3027
    if (rndup)
#line 3027
        rndup = X_ALIGN - rndup;
#line 3027

#line 3027
    while (nelems-- != 0) {
#line 3027
        
#line 3027
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 3027
    }
#line 3027

#line 3027
    *xpp = (void *)(xp + rndup);
#line 3027
    return status;
#line 3027
}
#line 3027

int
#line 3028
ncx_pad_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 3028
{
#line 3028
    int status = NC_NOERR;
#line 3028
    size_t rndup = nelems % X_ALIGN;
#line 3028
    uchar *xp = (uchar *) *xpp;
#line 3028

#line 3028
    if (rndup)
#line 3028
        rndup = X_ALIGN - rndup;
#line 3028

#line 3028
    while (nelems-- != 0) {
#line 3028
        
#line 3028
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 3028
    }
#line 3028

#line 3028
    *xpp = (void *)(xp + rndup);
#line 3028
    return status;
#line 3028
}
#line 3028

int
#line 3029
ncx_pad_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 3029
{
#line 3029
    int status = NC_NOERR;
#line 3029
    size_t rndup = nelems % X_ALIGN;
#line 3029
    uchar *xp = (uchar *) *xpp;
#line 3029

#line 3029
    if (rndup)
#line 3029
        rndup = X_ALIGN - rndup;
#line 3029

#line 3029
    while (nelems-- != 0) {
#line 3029
        
#line 3029
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 3029
    }
#line 3029

#line 3029
    *xpp = (void *)(xp + rndup);
#line 3029
    return status;
#line 3029
}
#line 3029

int
#line 3030
ncx_pad_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 3030
{
#line 3030
    int status = NC_NOERR;
#line 3030
    size_t rndup = nelems % X_ALIGN;
#line 3030
    uchar *xp = (uchar *) *xpp;
#line 3030

#line 3030
    if (rndup)
#line 3030
        rndup = X_ALIGN - rndup;
#line 3030

#line 3030
    while (nelems-- != 0) {
#line 3030
        
#line 3030
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 3030
    }
#line 3030

#line 3030
    *xpp = (void *)(xp + rndup);
#line 3030
    return status;
#line 3030
}
#line 3030

int
#line 3031
ncx_pad_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3031
{
#line 3031
    int status = NC_NOERR;
#line 3031
    size_t rndup = nelems % X_ALIGN;
#line 3031
    uchar *xp = (uchar *) *xpp;
#line 3031

#line 3031
    if (rndup)
#line 3031
        rndup = X_ALIGN - rndup;
#line 3031

#line 3031
    while (nelems-- != 0) {
#line 3031
        
#line 3031
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 3031
    }
#line 3031

#line 3031
    *xpp = (void *)(xp + rndup);
#line 3031
    return status;
#line 3031
}
#line 3031

int
#line 3032
ncx_pad_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3032
{
#line 3032
    int status = NC_NOERR;
#line 3032
    size_t rndup = nelems % X_ALIGN;
#line 3032
    uchar *xp = (uchar *) *xpp;
#line 3032

#line 3032
    if (rndup)
#line 3032
        rndup = X_ALIGN - rndup;
#line 3032

#line 3032
    while (nelems-- != 0) {
#line 3032
        
#line 3032
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 3032
    }
#line 3032

#line 3032
    *xpp = (void *)(xp + rndup);
#line 3032
    return status;
#line 3032
}
#line 3032

int
#line 3033
ncx_pad_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 3033
{
#line 3033
    int status = NC_NOERR;
#line 3033
    size_t rndup = nelems % X_ALIGN;
#line 3033
    uchar *xp = (uchar *) *xpp;
#line 3033

#line 3033
    if (rndup)
#line 3033
        rndup = X_ALIGN - rndup;
#line 3033

#line 3033
    while (nelems-- != 0) {
#line 3033
        
#line 3033
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 3033
    }
#line 3033

#line 3033
    *xpp = (void *)(xp + rndup);
#line 3033
    return status;
#line 3033
}
#line 3033

int
#line 3034
ncx_pad_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3034
{
#line 3034
    int status = NC_NOERR;
#line 3034
    size_t rndup = nelems % X_ALIGN;
#line 3034
    uchar *xp = (uchar *) *xpp;
#line 3034

#line 3034
    if (rndup)
#line 3034
        rndup = X_ALIGN - rndup;
#line 3034

#line 3034
    while (nelems-- != 0) {
#line 3034
        
#line 3034
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 3034
    }
#line 3034

#line 3034
    *xpp = (void *)(xp + rndup);
#line 3034
    return status;
#line 3034
}
#line 3034


#line 3037
int
ncx_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *) *xpp;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 3045
#ifdef ERANGE_FILL
#line 3045
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3045
#endif
            status = NC_ERANGE;
            
#line 3047
#ifdef ERANGE_FILL
#line 3047
            xp++; tp++; continue;
#line 3047
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    *xpp = (void *)xp;
    return status;
}
#line 3056
int
ncx_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3059
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3059

#line 3059
	return NC_NOERR;
#line 3059

}
int
#line 3061
ncx_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3061
{
#line 3061
    int status = NC_NOERR;
#line 3061
    uchar *xp = (uchar *) *xpp;
#line 3061

#line 3061
    while (nelems-- != 0) {
#line 3061
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 3061
            
#line 3061
#ifdef ERANGE_FILL
#line 3061
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3061
#endif
#line 3061
            status = NC_ERANGE;
#line 3061
            
#line 3061
#ifdef ERANGE_FILL
#line 3061
            xp++; tp++; continue;
#line 3061
#endif
#line 3061
        }
#line 3061
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 3061
    }
#line 3061

#line 3061
    *xpp = (void *)xp;
#line 3061
    return status;
#line 3061
}
#line 3061

int
#line 3062
ncx_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3062
{
#line 3062
    int status = NC_NOERR;
#line 3062
    uchar *xp = (uchar *) *xpp;
#line 3062

#line 3062
    while (nelems-- != 0) {
#line 3062
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 3062
            
#line 3062
#ifdef ERANGE_FILL
#line 3062
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3062
#endif
#line 3062
            status = NC_ERANGE;
#line 3062
            
#line 3062
#ifdef ERANGE_FILL
#line 3062
            xp++; tp++; continue;
#line 3062
#endif
#line 3062
        }
#line 3062
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 3062
    }
#line 3062

#line 3062
    *xpp = (void *)xp;
#line 3062
    return status;
#line 3062
}
#line 3062

int
#line 3063
ncx_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3063
{
#line 3063
    int status = NC_NOERR;
#line 3063
    uchar *xp = (uchar *) *xpp;
#line 3063

#line 3063
    while (nelems-- != 0) {
#line 3063
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 3063
            
#line 3063
#ifdef ERANGE_FILL
#line 3063
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3063
#endif
#line 3063
            status = NC_ERANGE;
#line 3063
            
#line 3063
#ifdef ERANGE_FILL
#line 3063
            xp++; tp++; continue;
#line 3063
#endif
#line 3063
        }
#line 3063
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 3063
    }
#line 3063

#line 3063
    *xpp = (void *)xp;
#line 3063
    return status;
#line 3063
}
#line 3063

int
#line 3064
ncx_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3064
{
#line 3064
    int status = NC_NOERR;
#line 3064
    uchar *xp = (uchar *) *xpp;
#line 3064

#line 3064
    while (nelems-- != 0) {
#line 3064
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 3064
            
#line 3064
#ifdef ERANGE_FILL
#line 3064
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3064
#endif
#line 3064
            status = NC_ERANGE;
#line 3064
            
#line 3064
#ifdef ERANGE_FILL
#line 3064
            xp++; tp++; continue;
#line 3064
#endif
#line 3064
        }
#line 3064
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 3064
    }
#line 3064

#line 3064
    *xpp = (void *)xp;
#line 3064
    return status;
#line 3064
}
#line 3064

int
#line 3065
ncx_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3065
{
#line 3065
    int status = NC_NOERR;
#line 3065
    uchar *xp = (uchar *) *xpp;
#line 3065

#line 3065
    while (nelems-- != 0) {
#line 3065
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 3065
            
#line 3065
#ifdef ERANGE_FILL
#line 3065
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3065
#endif
#line 3065
            status = NC_ERANGE;
#line 3065
            
#line 3065
#ifdef ERANGE_FILL
#line 3065
            xp++; tp++; continue;
#line 3065
#endif
#line 3065
        }
#line 3065
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 3065
    }
#line 3065

#line 3065
    *xpp = (void *)xp;
#line 3065
    return status;
#line 3065
}
#line 3065

int
#line 3066
ncx_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3066
{
#line 3066
    int status = NC_NOERR;
#line 3066
    uchar *xp = (uchar *) *xpp;
#line 3066

#line 3066
    while (nelems-- != 0) {
#line 3066
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 3066
            
#line 3066
#ifdef ERANGE_FILL
#line 3066
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3066
#endif
#line 3066
            status = NC_ERANGE;
#line 3066
            
#line 3066
#ifdef ERANGE_FILL
#line 3066
            xp++; tp++; continue;
#line 3066
#endif
#line 3066
        }
#line 3066
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 3066
    }
#line 3066

#line 3066
    *xpp = (void *)xp;
#line 3066
    return status;
#line 3066
}
#line 3066

int
#line 3067
ncx_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3067
{
#line 3067
    int status = NC_NOERR;
#line 3067
    uchar *xp = (uchar *) *xpp;
#line 3067

#line 3067
    while (nelems-- != 0) {
#line 3067
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 3067
            
#line 3067
#ifdef ERANGE_FILL
#line 3067
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3067
#endif
#line 3067
            status = NC_ERANGE;
#line 3067
            
#line 3067
#ifdef ERANGE_FILL
#line 3067
            xp++; tp++; continue;
#line 3067
#endif
#line 3067
        }
#line 3067
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 3067
    }
#line 3067

#line 3067
    *xpp = (void *)xp;
#line 3067
    return status;
#line 3067
}
#line 3067

int
#line 3068
ncx_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3068
{
#line 3068
    int status = NC_NOERR;
#line 3068
    uchar *xp = (uchar *) *xpp;
#line 3068

#line 3068
    while (nelems-- != 0) {
#line 3068
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 3068
            
#line 3068
#ifdef ERANGE_FILL
#line 3068
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3068
#endif
#line 3068
            status = NC_ERANGE;
#line 3068
            
#line 3068
#ifdef ERANGE_FILL
#line 3068
            xp++; tp++; continue;
#line 3068
#endif
#line 3068
        }
#line 3068
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 3068
    }
#line 3068

#line 3068
    *xpp = (void *)xp;
#line 3068
    return status;
#line 3068
}
#line 3068

int
#line 3069
ncx_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3069
{
#line 3069
    int status = NC_NOERR;
#line 3069
    uchar *xp = (uchar *) *xpp;
#line 3069

#line 3069
    while (nelems-- != 0) {
#line 3069
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 3069
            
#line 3069
#ifdef ERANGE_FILL
#line 3069
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3069
#endif
#line 3069
            status = NC_ERANGE;
#line 3069
            
#line 3069
#ifdef ERANGE_FILL
#line 3069
            xp++; tp++; continue;
#line 3069
#endif
#line 3069
        }
#line 3069
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 3069
    }
#line 3069

#line 3069
    *xpp = (void *)xp;
#line 3069
    return status;
#line 3069
}
#line 3069


#line 3072
int
ncx_pad_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 3083
#ifdef ERANGE_FILL
#line 3083
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3083
#endif
            status = NC_ERANGE;
            
#line 3085
#ifdef ERANGE_FILL
#line 3085
            xp++; tp++; continue;
#line 3085
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    if (rndup) {
        (void) memcpy(xp, nada, (size_t)rndup);
        xp += rndup;
    }

    *xpp = (void *)xp;
    return status;
}
#line 3099
int
ncx_pad_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 3102

#line 3102
	if (rndup)
#line 3102
		rndup = X_ALIGN - rndup;
#line 3102

#line 3102
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3102
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3102

#line 3102
	if (rndup)
#line 3102
	{
#line 3102
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3102
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3102
	}
#line 3102

#line 3102
	return NC_NOERR;
#line 3102

}
int
#line 3104
ncx_pad_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3104
{
#line 3104
    int status = NC_NOERR;
#line 3104
    size_t rndup = nelems % X_ALIGN;
#line 3104
    uchar *xp = (uchar *) *xpp;
#line 3104

#line 3104
    if (rndup) rndup = X_ALIGN - rndup;
#line 3104

#line 3104
    while (nelems-- != 0) {
#line 3104
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 3104
            
#line 3104
#ifdef ERANGE_FILL
#line 3104
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3104
#endif
#line 3104
            status = NC_ERANGE;
#line 3104
            
#line 3104
#ifdef ERANGE_FILL
#line 3104
            xp++; tp++; continue;
#line 3104
#endif
#line 3104
        }
#line 3104
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 3104
    }
#line 3104

#line 3104

#line 3104
    if (rndup) {
#line 3104
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3104
        xp += rndup;
#line 3104
    }
#line 3104

#line 3104
    *xpp = (void *)xp;
#line 3104
    return status;
#line 3104
}
#line 3104

int
#line 3105
ncx_pad_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3105
{
#line 3105
    int status = NC_NOERR;
#line 3105
    size_t rndup = nelems % X_ALIGN;
#line 3105
    uchar *xp = (uchar *) *xpp;
#line 3105

#line 3105
    if (rndup) rndup = X_ALIGN - rndup;
#line 3105

#line 3105
    while (nelems-- != 0) {
#line 3105
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 3105
            
#line 3105
#ifdef ERANGE_FILL
#line 3105
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3105
#endif
#line 3105
            status = NC_ERANGE;
#line 3105
            
#line 3105
#ifdef ERANGE_FILL
#line 3105
            xp++; tp++; continue;
#line 3105
#endif
#line 3105
        }
#line 3105
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 3105
    }
#line 3105

#line 3105

#line 3105
    if (rndup) {
#line 3105
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3105
        xp += rndup;
#line 3105
    }
#line 3105

#line 3105
    *xpp = (void *)xp;
#line 3105
    return status;
#line 3105
}
#line 3105

int
#line 3106
ncx_pad_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3106
{
#line 3106
    int status = NC_NOERR;
#line 3106
    size_t rndup = nelems % X_ALIGN;
#line 3106
    uchar *xp = (uchar *) *xpp;
#line 3106

#line 3106
    if (rndup) rndup = X_ALIGN - rndup;
#line 3106

#line 3106
    while (nelems-- != 0) {
#line 3106
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 3106
            
#line 3106
#ifdef ERANGE_FILL
#line 3106
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3106
#endif
#line 3106
            status = NC_ERANGE;
#line 3106
            
#line 3106
#ifdef ERANGE_FILL
#line 3106
            xp++; tp++; continue;
#line 3106
#endif
#line 3106
        }
#line 3106
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 3106
    }
#line 3106

#line 3106

#line 3106
    if (rndup) {
#line 3106
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3106
        xp += rndup;
#line 3106
    }
#line 3106

#line 3106
    *xpp = (void *)xp;
#line 3106
    return status;
#line 3106
}
#line 3106

int
#line 3107
ncx_pad_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3107
{
#line 3107
    int status = NC_NOERR;
#line 3107
    size_t rndup = nelems % X_ALIGN;
#line 3107
    uchar *xp = (uchar *) *xpp;
#line 3107

#line 3107
    if (rndup) rndup = X_ALIGN - rndup;
#line 3107

#line 3107
    while (nelems-- != 0) {
#line 3107
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 3107
            
#line 3107
#ifdef ERANGE_FILL
#line 3107
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3107
#endif
#line 3107
            status = NC_ERANGE;
#line 3107
            
#line 3107
#ifdef ERANGE_FILL
#line 3107
            xp++; tp++; continue;
#line 3107
#endif
#line 3107
        }
#line 3107
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 3107
    }
#line 3107

#line 3107

#line 3107
    if (rndup) {
#line 3107
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3107
        xp += rndup;
#line 3107
    }
#line 3107

#line 3107
    *xpp = (void *)xp;
#line 3107
    return status;
#line 3107
}
#line 3107

int
#line 3108
ncx_pad_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3108
{
#line 3108
    int status = NC_NOERR;
#line 3108
    size_t rndup = nelems % X_ALIGN;
#line 3108
    uchar *xp = (uchar *) *xpp;
#line 3108

#line 3108
    if (rndup) rndup = X_ALIGN - rndup;
#line 3108

#line 3108
    while (nelems-- != 0) {
#line 3108
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 3108
            
#line 3108
#ifdef ERANGE_FILL
#line 3108
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3108
#endif
#line 3108
            status = NC_ERANGE;
#line 3108
            
#line 3108
#ifdef ERANGE_FILL
#line 3108
            xp++; tp++; continue;
#line 3108
#endif
#line 3108
        }
#line 3108
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 3108
    }
#line 3108

#line 3108

#line 3108
    if (rndup) {
#line 3108
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3108
        xp += rndup;
#line 3108
    }
#line 3108

#line 3108
    *xpp = (void *)xp;
#line 3108
    return status;
#line 3108
}
#line 3108

int
#line 3109
ncx_pad_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3109
{
#line 3109
    int status = NC_NOERR;
#line 3109
    size_t rndup = nelems % X_ALIGN;
#line 3109
    uchar *xp = (uchar *) *xpp;
#line 3109

#line 3109
    if (rndup) rndup = X_ALIGN - rndup;
#line 3109

#line 3109
    while (nelems-- != 0) {
#line 3109
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 3109
            
#line 3109
#ifdef ERANGE_FILL
#line 3109
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3109
#endif
#line 3109
            status = NC_ERANGE;
#line 3109
            
#line 3109
#ifdef ERANGE_FILL
#line 3109
            xp++; tp++; continue;
#line 3109
#endif
#line 3109
        }
#line 3109
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 3109
    }
#line 3109

#line 3109

#line 3109
    if (rndup) {
#line 3109
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3109
        xp += rndup;
#line 3109
    }
#line 3109

#line 3109
    *xpp = (void *)xp;
#line 3109
    return status;
#line 3109
}
#line 3109

int
#line 3110
ncx_pad_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3110
{
#line 3110
    int status = NC_NOERR;
#line 3110
    size_t rndup = nelems % X_ALIGN;
#line 3110
    uchar *xp = (uchar *) *xpp;
#line 3110

#line 3110
    if (rndup) rndup = X_ALIGN - rndup;
#line 3110

#line 3110
    while (nelems-- != 0) {
#line 3110
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 3110
            
#line 3110
#ifdef ERANGE_FILL
#line 3110
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3110
#endif
#line 3110
            status = NC_ERANGE;
#line 3110
            
#line 3110
#ifdef ERANGE_FILL
#line 3110
            xp++; tp++; continue;
#line 3110
#endif
#line 3110
        }
#line 3110
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 3110
    }
#line 3110

#line 3110

#line 3110
    if (rndup) {
#line 3110
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3110
        xp += rndup;
#line 3110
    }
#line 3110

#line 3110
    *xpp = (void *)xp;
#line 3110
    return status;
#line 3110
}
#line 3110

int
#line 3111
ncx_pad_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3111
{
#line 3111
    int status = NC_NOERR;
#line 3111
    size_t rndup = nelems % X_ALIGN;
#line 3111
    uchar *xp = (uchar *) *xpp;
#line 3111

#line 3111
    if (rndup) rndup = X_ALIGN - rndup;
#line 3111

#line 3111
    while (nelems-- != 0) {
#line 3111
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 3111
            
#line 3111
#ifdef ERANGE_FILL
#line 3111
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3111
#endif
#line 3111
            status = NC_ERANGE;
#line 3111
            
#line 3111
#ifdef ERANGE_FILL
#line 3111
            xp++; tp++; continue;
#line 3111
#endif
#line 3111
        }
#line 3111
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 3111
    }
#line 3111

#line 3111

#line 3111
    if (rndup) {
#line 3111
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3111
        xp += rndup;
#line 3111
    }
#line 3111

#line 3111
    *xpp = (void *)xp;
#line 3111
    return status;
#line 3111
}
#line 3111

int
#line 3112
ncx_pad_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3112
{
#line 3112
    int status = NC_NOERR;
#line 3112
    size_t rndup = nelems % X_ALIGN;
#line 3112
    uchar *xp = (uchar *) *xpp;
#line 3112

#line 3112
    if (rndup) rndup = X_ALIGN - rndup;
#line 3112

#line 3112
    while (nelems-- != 0) {
#line 3112
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 3112
            
#line 3112
#ifdef ERANGE_FILL
#line 3112
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3112
#endif
#line 3112
            status = NC_ERANGE;
#line 3112
            
#line 3112
#ifdef ERANGE_FILL
#line 3112
            xp++; tp++; continue;
#line 3112
#endif
#line 3112
        }
#line 3112
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 3112
    }
#line 3112

#line 3112

#line 3112
    if (rndup) {
#line 3112
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3112
        xp += rndup;
#line 3112
    }
#line 3112

#line 3112
    *xpp = (void *)xp;
#line 3112
    return status;
#line 3112
}
#line 3112


/* short ---------------------------------------------------------------------*/

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_SHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 3130
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 3130
{
#line 3130
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3130

#line 3130
 /* basic algorithm is:
#line 3130
  *   - ensure sane alignment of input data
#line 3130
  *   - copy (conversion happens automatically) input data
#line 3130
  *     to output
#line 3130
  *   - update xpp to point at next unconverted input, and tp to point
#line 3130
  *     at next location for converted output
#line 3130
  */
#line 3130
  long i, j, ni;
#line 3130
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3130
  short *xp;
#line 3130
  int nrange = 0;         /* number of range errors */
#line 3130
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3130
  long cxp = (long) *((char**)xpp);
#line 3130

#line 3130
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3130
  /* sjl: manually stripmine so we can limit amount of
#line 3130
   * vector work space reserved to LOOPCNT elements. Also
#line 3130
   * makes vectorisation easy */
#line 3130
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3130
    ni=Min(nelems-j,LOOPCNT);
#line 3130
    if (realign) {
#line 3130
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3130
      xp = tmp;
#line 3130
    } else {
#line 3130
      xp = (short *) *xpp;
#line 3130
    }
#line 3130
   /* copy the next block */
#line 3130
#pragma cdir loopcnt=LOOPCNT
#line 3130
#pragma cdir shortloop
#line 3130
    for (i=0; i<ni; i++) {
#line 3130
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3130
     /* test for range errors (not always needed but do it anyway) */
#line 3130
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3130
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3130
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3130
    }
#line 3130
   /* update xpp and tp */
#line 3130
    if (realign) xp = (short *) *xpp;
#line 3130
    xp += ni;
#line 3130
    tp += ni;
#line 3130
    *xpp = (void*)xp;
#line 3130
  }
#line 3130
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3130

#line 3130
#else   /* not SX */
#line 3130
	const char *xp = (const char *) *xpp;
#line 3130
	int status = NC_NOERR;
#line 3130

#line 3130
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3130
	{
#line 3130
		const int lstatus = ncx_get_short_short(xp, tp);
#line 3130
		if (status == NC_NOERR) /* report the first encountered error */
#line 3130
			status = lstatus;
#line 3130
	}
#line 3130

#line 3130
	*xpp = (const void *)xp;
#line 3130
	return status;
#line 3130
#endif
#line 3130
}
#line 3130

#endif
int
#line 3132
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 3132
{
#line 3132
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3132

#line 3132
 /* basic algorithm is:
#line 3132
  *   - ensure sane alignment of input data
#line 3132
  *   - copy (conversion happens automatically) input data
#line 3132
  *     to output
#line 3132
  *   - update xpp to point at next unconverted input, and tp to point
#line 3132
  *     at next location for converted output
#line 3132
  */
#line 3132
  long i, j, ni;
#line 3132
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3132
  short *xp;
#line 3132
  int nrange = 0;         /* number of range errors */
#line 3132
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3132
  long cxp = (long) *((char**)xpp);
#line 3132

#line 3132
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3132
  /* sjl: manually stripmine so we can limit amount of
#line 3132
   * vector work space reserved to LOOPCNT elements. Also
#line 3132
   * makes vectorisation easy */
#line 3132
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3132
    ni=Min(nelems-j,LOOPCNT);
#line 3132
    if (realign) {
#line 3132
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3132
      xp = tmp;
#line 3132
    } else {
#line 3132
      xp = (short *) *xpp;
#line 3132
    }
#line 3132
   /* copy the next block */
#line 3132
#pragma cdir loopcnt=LOOPCNT
#line 3132
#pragma cdir shortloop
#line 3132
    for (i=0; i<ni; i++) {
#line 3132
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3132
     /* test for range errors (not always needed but do it anyway) */
#line 3132
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3132
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3132
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3132
    }
#line 3132
   /* update xpp and tp */
#line 3132
    if (realign) xp = (short *) *xpp;
#line 3132
    xp += ni;
#line 3132
    tp += ni;
#line 3132
    *xpp = (void*)xp;
#line 3132
  }
#line 3132
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3132

#line 3132
#else   /* not SX */
#line 3132
	const char *xp = (const char *) *xpp;
#line 3132
	int status = NC_NOERR;
#line 3132

#line 3132
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3132
	{
#line 3132
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 3132
		if (status == NC_NOERR) /* report the first encountered error */
#line 3132
			status = lstatus;
#line 3132
	}
#line 3132

#line 3132
	*xpp = (const void *)xp;
#line 3132
	return status;
#line 3132
#endif
#line 3132
}
#line 3132

int
#line 3133
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 3133
{
#line 3133
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3133

#line 3133
 /* basic algorithm is:
#line 3133
  *   - ensure sane alignment of input data
#line 3133
  *   - copy (conversion happens automatically) input data
#line 3133
  *     to output
#line 3133
  *   - update xpp to point at next unconverted input, and tp to point
#line 3133
  *     at next location for converted output
#line 3133
  */
#line 3133
  long i, j, ni;
#line 3133
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3133
  short *xp;
#line 3133
  int nrange = 0;         /* number of range errors */
#line 3133
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3133
  long cxp = (long) *((char**)xpp);
#line 3133

#line 3133
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3133
  /* sjl: manually stripmine so we can limit amount of
#line 3133
   * vector work space reserved to LOOPCNT elements. Also
#line 3133
   * makes vectorisation easy */
#line 3133
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3133
    ni=Min(nelems-j,LOOPCNT);
#line 3133
    if (realign) {
#line 3133
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3133
      xp = tmp;
#line 3133
    } else {
#line 3133
      xp = (short *) *xpp;
#line 3133
    }
#line 3133
   /* copy the next block */
#line 3133
#pragma cdir loopcnt=LOOPCNT
#line 3133
#pragma cdir shortloop
#line 3133
    for (i=0; i<ni; i++) {
#line 3133
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3133
     /* test for range errors (not always needed but do it anyway) */
#line 3133
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3133
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3133
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3133
    }
#line 3133
   /* update xpp and tp */
#line 3133
    if (realign) xp = (short *) *xpp;
#line 3133
    xp += ni;
#line 3133
    tp += ni;
#line 3133
    *xpp = (void*)xp;
#line 3133
  }
#line 3133
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3133

#line 3133
#else   /* not SX */
#line 3133
	const char *xp = (const char *) *xpp;
#line 3133
	int status = NC_NOERR;
#line 3133

#line 3133
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3133
	{
#line 3133
		const int lstatus = ncx_get_short_int(xp, tp);
#line 3133
		if (status == NC_NOERR) /* report the first encountered error */
#line 3133
			status = lstatus;
#line 3133
	}
#line 3133

#line 3133
	*xpp = (const void *)xp;
#line 3133
	return status;
#line 3133
#endif
#line 3133
}
#line 3133

int
#line 3134
ncx_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 3134
{
#line 3134
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3134

#line 3134
 /* basic algorithm is:
#line 3134
  *   - ensure sane alignment of input data
#line 3134
  *   - copy (conversion happens automatically) input data
#line 3134
  *     to output
#line 3134
  *   - update xpp to point at next unconverted input, and tp to point
#line 3134
  *     at next location for converted output
#line 3134
  */
#line 3134
  long i, j, ni;
#line 3134
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3134
  short *xp;
#line 3134
  int nrange = 0;         /* number of range errors */
#line 3134
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3134
  long cxp = (long) *((char**)xpp);
#line 3134

#line 3134
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3134
  /* sjl: manually stripmine so we can limit amount of
#line 3134
   * vector work space reserved to LOOPCNT elements. Also
#line 3134
   * makes vectorisation easy */
#line 3134
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3134
    ni=Min(nelems-j,LOOPCNT);
#line 3134
    if (realign) {
#line 3134
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3134
      xp = tmp;
#line 3134
    } else {
#line 3134
      xp = (short *) *xpp;
#line 3134
    }
#line 3134
   /* copy the next block */
#line 3134
#pragma cdir loopcnt=LOOPCNT
#line 3134
#pragma cdir shortloop
#line 3134
    for (i=0; i<ni; i++) {
#line 3134
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3134
     /* test for range errors (not always needed but do it anyway) */
#line 3134
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3134
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3134
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3134
    }
#line 3134
   /* update xpp and tp */
#line 3134
    if (realign) xp = (short *) *xpp;
#line 3134
    xp += ni;
#line 3134
    tp += ni;
#line 3134
    *xpp = (void*)xp;
#line 3134
  }
#line 3134
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3134

#line 3134
#else   /* not SX */
#line 3134
	const char *xp = (const char *) *xpp;
#line 3134
	int status = NC_NOERR;
#line 3134

#line 3134
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3134
	{
#line 3134
		const int lstatus = ncx_get_short_long(xp, tp);
#line 3134
		if (status == NC_NOERR) /* report the first encountered error */
#line 3134
			status = lstatus;
#line 3134
	}
#line 3134

#line 3134
	*xpp = (const void *)xp;
#line 3134
	return status;
#line 3134
#endif
#line 3134
}
#line 3134

int
#line 3135
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 3135
{
#line 3135
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3135

#line 3135
 /* basic algorithm is:
#line 3135
  *   - ensure sane alignment of input data
#line 3135
  *   - copy (conversion happens automatically) input data
#line 3135
  *     to output
#line 3135
  *   - update xpp to point at next unconverted input, and tp to point
#line 3135
  *     at next location for converted output
#line 3135
  */
#line 3135
  long i, j, ni;
#line 3135
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3135
  short *xp;
#line 3135
  int nrange = 0;         /* number of range errors */
#line 3135
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3135
  long cxp = (long) *((char**)xpp);
#line 3135

#line 3135
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3135
  /* sjl: manually stripmine so we can limit amount of
#line 3135
   * vector work space reserved to LOOPCNT elements. Also
#line 3135
   * makes vectorisation easy */
#line 3135
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3135
    ni=Min(nelems-j,LOOPCNT);
#line 3135
    if (realign) {
#line 3135
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3135
      xp = tmp;
#line 3135
    } else {
#line 3135
      xp = (short *) *xpp;
#line 3135
    }
#line 3135
   /* copy the next block */
#line 3135
#pragma cdir loopcnt=LOOPCNT
#line 3135
#pragma cdir shortloop
#line 3135
    for (i=0; i<ni; i++) {
#line 3135
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3135
     /* test for range errors (not always needed but do it anyway) */
#line 3135
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3135
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3135
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3135
    }
#line 3135
   /* update xpp and tp */
#line 3135
    if (realign) xp = (short *) *xpp;
#line 3135
    xp += ni;
#line 3135
    tp += ni;
#line 3135
    *xpp = (void*)xp;
#line 3135
  }
#line 3135
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3135

#line 3135
#else   /* not SX */
#line 3135
	const char *xp = (const char *) *xpp;
#line 3135
	int status = NC_NOERR;
#line 3135

#line 3135
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3135
	{
#line 3135
		const int lstatus = ncx_get_short_float(xp, tp);
#line 3135
		if (status == NC_NOERR) /* report the first encountered error */
#line 3135
			status = lstatus;
#line 3135
	}
#line 3135

#line 3135
	*xpp = (const void *)xp;
#line 3135
	return status;
#line 3135
#endif
#line 3135
}
#line 3135

int
#line 3136
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 3136
{
#line 3136
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3136

#line 3136
 /* basic algorithm is:
#line 3136
  *   - ensure sane alignment of input data
#line 3136
  *   - copy (conversion happens automatically) input data
#line 3136
  *     to output
#line 3136
  *   - update xpp to point at next unconverted input, and tp to point
#line 3136
  *     at next location for converted output
#line 3136
  */
#line 3136
  long i, j, ni;
#line 3136
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3136
  short *xp;
#line 3136
  int nrange = 0;         /* number of range errors */
#line 3136
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3136
  long cxp = (long) *((char**)xpp);
#line 3136

#line 3136
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3136
  /* sjl: manually stripmine so we can limit amount of
#line 3136
   * vector work space reserved to LOOPCNT elements. Also
#line 3136
   * makes vectorisation easy */
#line 3136
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3136
    ni=Min(nelems-j,LOOPCNT);
#line 3136
    if (realign) {
#line 3136
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3136
      xp = tmp;
#line 3136
    } else {
#line 3136
      xp = (short *) *xpp;
#line 3136
    }
#line 3136
   /* copy the next block */
#line 3136
#pragma cdir loopcnt=LOOPCNT
#line 3136
#pragma cdir shortloop
#line 3136
    for (i=0; i<ni; i++) {
#line 3136
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3136
     /* test for range errors (not always needed but do it anyway) */
#line 3136
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3136
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3136
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3136
    }
#line 3136
   /* update xpp and tp */
#line 3136
    if (realign) xp = (short *) *xpp;
#line 3136
    xp += ni;
#line 3136
    tp += ni;
#line 3136
    *xpp = (void*)xp;
#line 3136
  }
#line 3136
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3136

#line 3136
#else   /* not SX */
#line 3136
	const char *xp = (const char *) *xpp;
#line 3136
	int status = NC_NOERR;
#line 3136

#line 3136
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3136
	{
#line 3136
		const int lstatus = ncx_get_short_double(xp, tp);
#line 3136
		if (status == NC_NOERR) /* report the first encountered error */
#line 3136
			status = lstatus;
#line 3136
	}
#line 3136

#line 3136
	*xpp = (const void *)xp;
#line 3136
	return status;
#line 3136
#endif
#line 3136
}
#line 3136

int
#line 3137
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3137
{
#line 3137
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3137

#line 3137
 /* basic algorithm is:
#line 3137
  *   - ensure sane alignment of input data
#line 3137
  *   - copy (conversion happens automatically) input data
#line 3137
  *     to output
#line 3137
  *   - update xpp to point at next unconverted input, and tp to point
#line 3137
  *     at next location for converted output
#line 3137
  */
#line 3137
  long i, j, ni;
#line 3137
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3137
  short *xp;
#line 3137
  int nrange = 0;         /* number of range errors */
#line 3137
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3137
  long cxp = (long) *((char**)xpp);
#line 3137

#line 3137
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3137
  /* sjl: manually stripmine so we can limit amount of
#line 3137
   * vector work space reserved to LOOPCNT elements. Also
#line 3137
   * makes vectorisation easy */
#line 3137
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3137
    ni=Min(nelems-j,LOOPCNT);
#line 3137
    if (realign) {
#line 3137
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3137
      xp = tmp;
#line 3137
    } else {
#line 3137
      xp = (short *) *xpp;
#line 3137
    }
#line 3137
   /* copy the next block */
#line 3137
#pragma cdir loopcnt=LOOPCNT
#line 3137
#pragma cdir shortloop
#line 3137
    for (i=0; i<ni; i++) {
#line 3137
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3137
     /* test for range errors (not always needed but do it anyway) */
#line 3137
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3137
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3137
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3137
    }
#line 3137
   /* update xpp and tp */
#line 3137
    if (realign) xp = (short *) *xpp;
#line 3137
    xp += ni;
#line 3137
    tp += ni;
#line 3137
    *xpp = (void*)xp;
#line 3137
  }
#line 3137
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3137

#line 3137
#else   /* not SX */
#line 3137
	const char *xp = (const char *) *xpp;
#line 3137
	int status = NC_NOERR;
#line 3137

#line 3137
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3137
	{
#line 3137
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 3137
		if (status == NC_NOERR) /* report the first encountered error */
#line 3137
			status = lstatus;
#line 3137
	}
#line 3137

#line 3137
	*xpp = (const void *)xp;
#line 3137
	return status;
#line 3137
#endif
#line 3137
}
#line 3137

int
#line 3138
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3138
{
#line 3138
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3138

#line 3138
 /* basic algorithm is:
#line 3138
  *   - ensure sane alignment of input data
#line 3138
  *   - copy (conversion happens automatically) input data
#line 3138
  *     to output
#line 3138
  *   - update xpp to point at next unconverted input, and tp to point
#line 3138
  *     at next location for converted output
#line 3138
  */
#line 3138
  long i, j, ni;
#line 3138
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3138
  short *xp;
#line 3138
  int nrange = 0;         /* number of range errors */
#line 3138
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3138
  long cxp = (long) *((char**)xpp);
#line 3138

#line 3138
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3138
  /* sjl: manually stripmine so we can limit amount of
#line 3138
   * vector work space reserved to LOOPCNT elements. Also
#line 3138
   * makes vectorisation easy */
#line 3138
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3138
    ni=Min(nelems-j,LOOPCNT);
#line 3138
    if (realign) {
#line 3138
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3138
      xp = tmp;
#line 3138
    } else {
#line 3138
      xp = (short *) *xpp;
#line 3138
    }
#line 3138
   /* copy the next block */
#line 3138
#pragma cdir loopcnt=LOOPCNT
#line 3138
#pragma cdir shortloop
#line 3138
    for (i=0; i<ni; i++) {
#line 3138
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3138
     /* test for range errors (not always needed but do it anyway) */
#line 3138
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3138
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3138
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3138
    }
#line 3138
   /* update xpp and tp */
#line 3138
    if (realign) xp = (short *) *xpp;
#line 3138
    xp += ni;
#line 3138
    tp += ni;
#line 3138
    *xpp = (void*)xp;
#line 3138
  }
#line 3138
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3138

#line 3138
#else   /* not SX */
#line 3138
	const char *xp = (const char *) *xpp;
#line 3138
	int status = NC_NOERR;
#line 3138

#line 3138
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3138
	{
#line 3138
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 3138
		if (status == NC_NOERR) /* report the first encountered error */
#line 3138
			status = lstatus;
#line 3138
	}
#line 3138

#line 3138
	*xpp = (const void *)xp;
#line 3138
	return status;
#line 3138
#endif
#line 3138
}
#line 3138

int
#line 3139
ncx_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3139
{
#line 3139
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3139

#line 3139
 /* basic algorithm is:
#line 3139
  *   - ensure sane alignment of input data
#line 3139
  *   - copy (conversion happens automatically) input data
#line 3139
  *     to output
#line 3139
  *   - update xpp to point at next unconverted input, and tp to point
#line 3139
  *     at next location for converted output
#line 3139
  */
#line 3139
  long i, j, ni;
#line 3139
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3139
  short *xp;
#line 3139
  int nrange = 0;         /* number of range errors */
#line 3139
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3139
  long cxp = (long) *((char**)xpp);
#line 3139

#line 3139
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3139
  /* sjl: manually stripmine so we can limit amount of
#line 3139
   * vector work space reserved to LOOPCNT elements. Also
#line 3139
   * makes vectorisation easy */
#line 3139
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3139
    ni=Min(nelems-j,LOOPCNT);
#line 3139
    if (realign) {
#line 3139
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3139
      xp = tmp;
#line 3139
    } else {
#line 3139
      xp = (short *) *xpp;
#line 3139
    }
#line 3139
   /* copy the next block */
#line 3139
#pragma cdir loopcnt=LOOPCNT
#line 3139
#pragma cdir shortloop
#line 3139
    for (i=0; i<ni; i++) {
#line 3139
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3139
     /* test for range errors (not always needed but do it anyway) */
#line 3139
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3139
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3139
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3139
    }
#line 3139
   /* update xpp and tp */
#line 3139
    if (realign) xp = (short *) *xpp;
#line 3139
    xp += ni;
#line 3139
    tp += ni;
#line 3139
    *xpp = (void*)xp;
#line 3139
  }
#line 3139
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3139

#line 3139
#else   /* not SX */
#line 3139
	const char *xp = (const char *) *xpp;
#line 3139
	int status = NC_NOERR;
#line 3139

#line 3139
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3139
	{
#line 3139
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 3139
		if (status == NC_NOERR) /* report the first encountered error */
#line 3139
			status = lstatus;
#line 3139
	}
#line 3139

#line 3139
	*xpp = (const void *)xp;
#line 3139
	return status;
#line 3139
#endif
#line 3139
}
#line 3139

int
#line 3140
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 3140
{
#line 3140
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3140

#line 3140
 /* basic algorithm is:
#line 3140
  *   - ensure sane alignment of input data
#line 3140
  *   - copy (conversion happens automatically) input data
#line 3140
  *     to output
#line 3140
  *   - update xpp to point at next unconverted input, and tp to point
#line 3140
  *     at next location for converted output
#line 3140
  */
#line 3140
  long i, j, ni;
#line 3140
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3140
  short *xp;
#line 3140
  int nrange = 0;         /* number of range errors */
#line 3140
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3140
  long cxp = (long) *((char**)xpp);
#line 3140

#line 3140
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3140
  /* sjl: manually stripmine so we can limit amount of
#line 3140
   * vector work space reserved to LOOPCNT elements. Also
#line 3140
   * makes vectorisation easy */
#line 3140
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3140
    ni=Min(nelems-j,LOOPCNT);
#line 3140
    if (realign) {
#line 3140
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3140
      xp = tmp;
#line 3140
    } else {
#line 3140
      xp = (short *) *xpp;
#line 3140
    }
#line 3140
   /* copy the next block */
#line 3140
#pragma cdir loopcnt=LOOPCNT
#line 3140
#pragma cdir shortloop
#line 3140
    for (i=0; i<ni; i++) {
#line 3140
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3140
     /* test for range errors (not always needed but do it anyway) */
#line 3140
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3140
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3140
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3140
    }
#line 3140
   /* update xpp and tp */
#line 3140
    if (realign) xp = (short *) *xpp;
#line 3140
    xp += ni;
#line 3140
    tp += ni;
#line 3140
    *xpp = (void*)xp;
#line 3140
  }
#line 3140
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3140

#line 3140
#else   /* not SX */
#line 3140
	const char *xp = (const char *) *xpp;
#line 3140
	int status = NC_NOERR;
#line 3140

#line 3140
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3140
	{
#line 3140
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 3140
		if (status == NC_NOERR) /* report the first encountered error */
#line 3140
			status = lstatus;
#line 3140
	}
#line 3140

#line 3140
	*xpp = (const void *)xp;
#line 3140
	return status;
#line 3140
#endif
#line 3140
}
#line 3140

int
#line 3141
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3141
{
#line 3141
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3141

#line 3141
 /* basic algorithm is:
#line 3141
  *   - ensure sane alignment of input data
#line 3141
  *   - copy (conversion happens automatically) input data
#line 3141
  *     to output
#line 3141
  *   - update xpp to point at next unconverted input, and tp to point
#line 3141
  *     at next location for converted output
#line 3141
  */
#line 3141
  long i, j, ni;
#line 3141
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3141
  short *xp;
#line 3141
  int nrange = 0;         /* number of range errors */
#line 3141
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3141
  long cxp = (long) *((char**)xpp);
#line 3141

#line 3141
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3141
  /* sjl: manually stripmine so we can limit amount of
#line 3141
   * vector work space reserved to LOOPCNT elements. Also
#line 3141
   * makes vectorisation easy */
#line 3141
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3141
    ni=Min(nelems-j,LOOPCNT);
#line 3141
    if (realign) {
#line 3141
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3141
      xp = tmp;
#line 3141
    } else {
#line 3141
      xp = (short *) *xpp;
#line 3141
    }
#line 3141
   /* copy the next block */
#line 3141
#pragma cdir loopcnt=LOOPCNT
#line 3141
#pragma cdir shortloop
#line 3141
    for (i=0; i<ni; i++) {
#line 3141
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3141
     /* test for range errors (not always needed but do it anyway) */
#line 3141
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3141
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3141
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3141
    }
#line 3141
   /* update xpp and tp */
#line 3141
    if (realign) xp = (short *) *xpp;
#line 3141
    xp += ni;
#line 3141
    tp += ni;
#line 3141
    *xpp = (void*)xp;
#line 3141
  }
#line 3141
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3141

#line 3141
#else   /* not SX */
#line 3141
	const char *xp = (const char *) *xpp;
#line 3141
	int status = NC_NOERR;
#line 3141

#line 3141
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3141
	{
#line 3141
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 3141
		if (status == NC_NOERR) /* report the first encountered error */
#line 3141
			status = lstatus;
#line 3141
	}
#line 3141

#line 3141
	*xpp = (const void *)xp;
#line 3141
	return status;
#line 3141
#endif
#line 3141
}
#line 3141


int
#line 3143
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 3143
{
#line 3143
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3143

#line 3143
	const char *xp = (const char *) *xpp;
#line 3143
	int status = NC_NOERR;
#line 3143

#line 3143
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3143
	{
#line 3143
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 3143
		if (status == NC_NOERR) /* report the first encountered error */
#line 3143
			status = lstatus;
#line 3143
	}
#line 3143

#line 3143
	if (rndup != 0)
#line 3143
		xp += X_SIZEOF_SHORT;
#line 3143

#line 3143
	*xpp = (void *)xp;
#line 3143
	return status;
#line 3143
}
#line 3143

int
#line 3144
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3144
{
#line 3144
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3144

#line 3144
	const char *xp = (const char *) *xpp;
#line 3144
	int status = NC_NOERR;
#line 3144

#line 3144
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3144
	{
#line 3144
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 3144
		if (status == NC_NOERR) /* report the first encountered error */
#line 3144
			status = lstatus;
#line 3144
	}
#line 3144

#line 3144
	if (rndup != 0)
#line 3144
		xp += X_SIZEOF_SHORT;
#line 3144

#line 3144
	*xpp = (void *)xp;
#line 3144
	return status;
#line 3144
}
#line 3144

int
#line 3145
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 3145
{
#line 3145
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3145

#line 3145
	const char *xp = (const char *) *xpp;
#line 3145
	int status = NC_NOERR;
#line 3145

#line 3145
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3145
	{
#line 3145
		const int lstatus = ncx_get_short_short(xp, tp);
#line 3145
		if (status == NC_NOERR) /* report the first encountered error */
#line 3145
			status = lstatus;
#line 3145
	}
#line 3145

#line 3145
	if (rndup != 0)
#line 3145
		xp += X_SIZEOF_SHORT;
#line 3145

#line 3145
	*xpp = (void *)xp;
#line 3145
	return status;
#line 3145
}
#line 3145

int
#line 3146
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 3146
{
#line 3146
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3146

#line 3146
	const char *xp = (const char *) *xpp;
#line 3146
	int status = NC_NOERR;
#line 3146

#line 3146
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3146
	{
#line 3146
		const int lstatus = ncx_get_short_int(xp, tp);
#line 3146
		if (status == NC_NOERR) /* report the first encountered error */
#line 3146
			status = lstatus;
#line 3146
	}
#line 3146

#line 3146
	if (rndup != 0)
#line 3146
		xp += X_SIZEOF_SHORT;
#line 3146

#line 3146
	*xpp = (void *)xp;
#line 3146
	return status;
#line 3146
}
#line 3146

int
#line 3147
ncx_pad_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 3147
{
#line 3147
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3147

#line 3147
	const char *xp = (const char *) *xpp;
#line 3147
	int status = NC_NOERR;
#line 3147

#line 3147
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3147
	{
#line 3147
		const int lstatus = ncx_get_short_long(xp, tp);
#line 3147
		if (status == NC_NOERR) /* report the first encountered error */
#line 3147
			status = lstatus;
#line 3147
	}
#line 3147

#line 3147
	if (rndup != 0)
#line 3147
		xp += X_SIZEOF_SHORT;
#line 3147

#line 3147
	*xpp = (void *)xp;
#line 3147
	return status;
#line 3147
}
#line 3147

int
#line 3148
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 3148
{
#line 3148
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3148

#line 3148
	const char *xp = (const char *) *xpp;
#line 3148
	int status = NC_NOERR;
#line 3148

#line 3148
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3148
	{
#line 3148
		const int lstatus = ncx_get_short_float(xp, tp);
#line 3148
		if (status == NC_NOERR) /* report the first encountered error */
#line 3148
			status = lstatus;
#line 3148
	}
#line 3148

#line 3148
	if (rndup != 0)
#line 3148
		xp += X_SIZEOF_SHORT;
#line 3148

#line 3148
	*xpp = (void *)xp;
#line 3148
	return status;
#line 3148
}
#line 3148

int
#line 3149
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 3149
{
#line 3149
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3149

#line 3149
	const char *xp = (const char *) *xpp;
#line 3149
	int status = NC_NOERR;
#line 3149

#line 3149
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3149
	{
#line 3149
		const int lstatus = ncx_get_short_double(xp, tp);
#line 3149
		if (status == NC_NOERR) /* report the first encountered error */
#line 3149
			status = lstatus;
#line 3149
	}
#line 3149

#line 3149
	if (rndup != 0)
#line 3149
		xp += X_SIZEOF_SHORT;
#line 3149

#line 3149
	*xpp = (void *)xp;
#line 3149
	return status;
#line 3149
}
#line 3149

int
#line 3150
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 3150
{
#line 3150
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3150

#line 3150
	const char *xp = (const char *) *xpp;
#line 3150
	int status = NC_NOERR;
#line 3150

#line 3150
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3150
	{
#line 3150
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 3150
		if (status == NC_NOERR) /* report the first encountered error */
#line 3150
			status = lstatus;
#line 3150
	}
#line 3150

#line 3150
	if (rndup != 0)
#line 3150
		xp += X_SIZEOF_SHORT;
#line 3150

#line 3150
	*xpp = (void *)xp;
#line 3150
	return status;
#line 3150
}
#line 3150

int
#line 3151
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3151
{
#line 3151
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3151

#line 3151
	const char *xp = (const char *) *xpp;
#line 3151
	int status = NC_NOERR;
#line 3151

#line 3151
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3151
	{
#line 3151
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 3151
		if (status == NC_NOERR) /* report the first encountered error */
#line 3151
			status = lstatus;
#line 3151
	}
#line 3151

#line 3151
	if (rndup != 0)
#line 3151
		xp += X_SIZEOF_SHORT;
#line 3151

#line 3151
	*xpp = (void *)xp;
#line 3151
	return status;
#line 3151
}
#line 3151

int
#line 3152
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3152
{
#line 3152
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3152

#line 3152
	const char *xp = (const char *) *xpp;
#line 3152
	int status = NC_NOERR;
#line 3152

#line 3152
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3152
	{
#line 3152
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 3152
		if (status == NC_NOERR) /* report the first encountered error */
#line 3152
			status = lstatus;
#line 3152
	}
#line 3152

#line 3152
	if (rndup != 0)
#line 3152
		xp += X_SIZEOF_SHORT;
#line 3152

#line 3152
	*xpp = (void *)xp;
#line 3152
	return status;
#line 3152
}
#line 3152

int
#line 3153
ncx_pad_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3153
{
#line 3153
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3153

#line 3153
	const char *xp = (const char *) *xpp;
#line 3153
	int status = NC_NOERR;
#line 3153

#line 3153
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3153
	{
#line 3153
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 3153
		if (status == NC_NOERR) /* report the first encountered error */
#line 3153
			status = lstatus;
#line 3153
	}
#line 3153

#line 3153
	if (rndup != 0)
#line 3153
		xp += X_SIZEOF_SHORT;
#line 3153

#line 3153
	*xpp = (void *)xp;
#line 3153
	return status;
#line 3153
}
#line 3153


#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 3169
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3169
{
#line 3169
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3169

#line 3169
 /* basic algorithm is:
#line 3169
  *   - ensure sane alignment of output data
#line 3169
  *   - copy (conversion happens automatically) input data
#line 3169
  *     to output
#line 3169
  *   - update tp to point at next unconverted input, and xpp to point
#line 3169
  *     at next location for converted output
#line 3169
  */
#line 3169
  long i, j, ni;
#line 3169
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3169
  short *xp;
#line 3169
  int nrange = 0;         /* number of range errors */
#line 3169
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3169
  long cxp = (long) *((char**)xpp);
#line 3169

#line 3169
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3169
  /* sjl: manually stripmine so we can limit amount of
#line 3169
   * vector work space reserved to LOOPCNT elements. Also
#line 3169
   * makes vectorisation easy */
#line 3169
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3169
    ni=Min(nelems-j,LOOPCNT);
#line 3169
    if (realign) {
#line 3169
      xp = tmp;
#line 3169
    } else {
#line 3169
      xp = (short *) *xpp;
#line 3169
    }
#line 3169
   /* copy the next block */
#line 3169
#pragma cdir loopcnt=LOOPCNT
#line 3169
#pragma cdir shortloop
#line 3169
    for (i=0; i<ni; i++) {
#line 3169
      /* the normal case: */
#line 3169
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3169
     /* test for range errors (not always needed but do it anyway) */
#line 3169
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3169
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3169
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3169
    }
#line 3169
   /* copy workspace back if necessary */
#line 3169
    if (realign) {
#line 3169
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3169
      xp = (short *) *xpp;
#line 3169
    }
#line 3169
   /* update xpp and tp */
#line 3169
    xp += ni;
#line 3169
    tp += ni;
#line 3169
    *xpp = (void*)xp;
#line 3169
  }
#line 3169
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3169

#line 3169
#else   /* not SX */
#line 3169

#line 3169
	char *xp = (char *) *xpp;
#line 3169
	int status = NC_NOERR;
#line 3169

#line 3169
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3169
	{
#line 3169
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 3169
		if (status == NC_NOERR) /* report the first encountered error */
#line 3169
			status = lstatus;
#line 3169
	}
#line 3169

#line 3169
	*xpp = (void *)xp;
#line 3169
	return status;
#line 3169
#endif
#line 3169
}
#line 3169

#endif
int
#line 3171
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3171
{
#line 3171
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3171

#line 3171
 /* basic algorithm is:
#line 3171
  *   - ensure sane alignment of output data
#line 3171
  *   - copy (conversion happens automatically) input data
#line 3171
  *     to output
#line 3171
  *   - update tp to point at next unconverted input, and xpp to point
#line 3171
  *     at next location for converted output
#line 3171
  */
#line 3171
  long i, j, ni;
#line 3171
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3171
  short *xp;
#line 3171
  int nrange = 0;         /* number of range errors */
#line 3171
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3171
  long cxp = (long) *((char**)xpp);
#line 3171

#line 3171
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3171
  /* sjl: manually stripmine so we can limit amount of
#line 3171
   * vector work space reserved to LOOPCNT elements. Also
#line 3171
   * makes vectorisation easy */
#line 3171
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3171
    ni=Min(nelems-j,LOOPCNT);
#line 3171
    if (realign) {
#line 3171
      xp = tmp;
#line 3171
    } else {
#line 3171
      xp = (short *) *xpp;
#line 3171
    }
#line 3171
   /* copy the next block */
#line 3171
#pragma cdir loopcnt=LOOPCNT
#line 3171
#pragma cdir shortloop
#line 3171
    for (i=0; i<ni; i++) {
#line 3171
      /* the normal case: */
#line 3171
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3171
     /* test for range errors (not always needed but do it anyway) */
#line 3171
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3171
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3171
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3171
    }
#line 3171
   /* copy workspace back if necessary */
#line 3171
    if (realign) {
#line 3171
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3171
      xp = (short *) *xpp;
#line 3171
    }
#line 3171
   /* update xpp and tp */
#line 3171
    xp += ni;
#line 3171
    tp += ni;
#line 3171
    *xpp = (void*)xp;
#line 3171
  }
#line 3171
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3171

#line 3171
#else   /* not SX */
#line 3171

#line 3171
	char *xp = (char *) *xpp;
#line 3171
	int status = NC_NOERR;
#line 3171

#line 3171
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3171
	{
#line 3171
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 3171
		if (status == NC_NOERR) /* report the first encountered error */
#line 3171
			status = lstatus;
#line 3171
	}
#line 3171

#line 3171
	*xpp = (void *)xp;
#line 3171
	return status;
#line 3171
#endif
#line 3171
}
#line 3171

int
#line 3172
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3172
{
#line 3172
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3172

#line 3172
 /* basic algorithm is:
#line 3172
  *   - ensure sane alignment of output data
#line 3172
  *   - copy (conversion happens automatically) input data
#line 3172
  *     to output
#line 3172
  *   - update tp to point at next unconverted input, and xpp to point
#line 3172
  *     at next location for converted output
#line 3172
  */
#line 3172
  long i, j, ni;
#line 3172
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3172
  short *xp;
#line 3172
  int nrange = 0;         /* number of range errors */
#line 3172
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3172
  long cxp = (long) *((char**)xpp);
#line 3172

#line 3172
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3172
  /* sjl: manually stripmine so we can limit amount of
#line 3172
   * vector work space reserved to LOOPCNT elements. Also
#line 3172
   * makes vectorisation easy */
#line 3172
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3172
    ni=Min(nelems-j,LOOPCNT);
#line 3172
    if (realign) {
#line 3172
      xp = tmp;
#line 3172
    } else {
#line 3172
      xp = (short *) *xpp;
#line 3172
    }
#line 3172
   /* copy the next block */
#line 3172
#pragma cdir loopcnt=LOOPCNT
#line 3172
#pragma cdir shortloop
#line 3172
    for (i=0; i<ni; i++) {
#line 3172
      /* the normal case: */
#line 3172
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3172
     /* test for range errors (not always needed but do it anyway) */
#line 3172
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3172
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3172
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3172
    }
#line 3172
   /* copy workspace back if necessary */
#line 3172
    if (realign) {
#line 3172
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3172
      xp = (short *) *xpp;
#line 3172
    }
#line 3172
   /* update xpp and tp */
#line 3172
    xp += ni;
#line 3172
    tp += ni;
#line 3172
    *xpp = (void*)xp;
#line 3172
  }
#line 3172
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3172

#line 3172
#else   /* not SX */
#line 3172

#line 3172
	char *xp = (char *) *xpp;
#line 3172
	int status = NC_NOERR;
#line 3172

#line 3172
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3172
	{
#line 3172
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 3172
		if (status == NC_NOERR) /* report the first encountered error */
#line 3172
			status = lstatus;
#line 3172
	}
#line 3172

#line 3172
	*xpp = (void *)xp;
#line 3172
	return status;
#line 3172
#endif
#line 3172
}
#line 3172

int
#line 3173
ncx_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3173
{
#line 3173
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3173

#line 3173
 /* basic algorithm is:
#line 3173
  *   - ensure sane alignment of output data
#line 3173
  *   - copy (conversion happens automatically) input data
#line 3173
  *     to output
#line 3173
  *   - update tp to point at next unconverted input, and xpp to point
#line 3173
  *     at next location for converted output
#line 3173
  */
#line 3173
  long i, j, ni;
#line 3173
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3173
  short *xp;
#line 3173
  int nrange = 0;         /* number of range errors */
#line 3173
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3173
  long cxp = (long) *((char**)xpp);
#line 3173

#line 3173
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3173
  /* sjl: manually stripmine so we can limit amount of
#line 3173
   * vector work space reserved to LOOPCNT elements. Also
#line 3173
   * makes vectorisation easy */
#line 3173
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3173
    ni=Min(nelems-j,LOOPCNT);
#line 3173
    if (realign) {
#line 3173
      xp = tmp;
#line 3173
    } else {
#line 3173
      xp = (short *) *xpp;
#line 3173
    }
#line 3173
   /* copy the next block */
#line 3173
#pragma cdir loopcnt=LOOPCNT
#line 3173
#pragma cdir shortloop
#line 3173
    for (i=0; i<ni; i++) {
#line 3173
      /* the normal case: */
#line 3173
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3173
     /* test for range errors (not always needed but do it anyway) */
#line 3173
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3173
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3173
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3173
    }
#line 3173
   /* copy workspace back if necessary */
#line 3173
    if (realign) {
#line 3173
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3173
      xp = (short *) *xpp;
#line 3173
    }
#line 3173
   /* update xpp and tp */
#line 3173
    xp += ni;
#line 3173
    tp += ni;
#line 3173
    *xpp = (void*)xp;
#line 3173
  }
#line 3173
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3173

#line 3173
#else   /* not SX */
#line 3173

#line 3173
	char *xp = (char *) *xpp;
#line 3173
	int status = NC_NOERR;
#line 3173

#line 3173
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3173
	{
#line 3173
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 3173
		if (status == NC_NOERR) /* report the first encountered error */
#line 3173
			status = lstatus;
#line 3173
	}
#line 3173

#line 3173
	*xpp = (void *)xp;
#line 3173
	return status;
#line 3173
#endif
#line 3173
}
#line 3173

int
#line 3174
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3174
{
#line 3174
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3174

#line 3174
 /* basic algorithm is:
#line 3174
  *   - ensure sane alignment of output data
#line 3174
  *   - copy (conversion happens automatically) input data
#line 3174
  *     to output
#line 3174
  *   - update tp to point at next unconverted input, and xpp to point
#line 3174
  *     at next location for converted output
#line 3174
  */
#line 3174
  long i, j, ni;
#line 3174
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3174
  short *xp;
#line 3174
  int nrange = 0;         /* number of range errors */
#line 3174
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3174
  long cxp = (long) *((char**)xpp);
#line 3174

#line 3174
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3174
  /* sjl: manually stripmine so we can limit amount of
#line 3174
   * vector work space reserved to LOOPCNT elements. Also
#line 3174
   * makes vectorisation easy */
#line 3174
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3174
    ni=Min(nelems-j,LOOPCNT);
#line 3174
    if (realign) {
#line 3174
      xp = tmp;
#line 3174
    } else {
#line 3174
      xp = (short *) *xpp;
#line 3174
    }
#line 3174
   /* copy the next block */
#line 3174
#pragma cdir loopcnt=LOOPCNT
#line 3174
#pragma cdir shortloop
#line 3174
    for (i=0; i<ni; i++) {
#line 3174
      /* the normal case: */
#line 3174
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3174
     /* test for range errors (not always needed but do it anyway) */
#line 3174
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3174
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3174
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3174
    }
#line 3174
   /* copy workspace back if necessary */
#line 3174
    if (realign) {
#line 3174
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3174
      xp = (short *) *xpp;
#line 3174
    }
#line 3174
   /* update xpp and tp */
#line 3174
    xp += ni;
#line 3174
    tp += ni;
#line 3174
    *xpp = (void*)xp;
#line 3174
  }
#line 3174
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3174

#line 3174
#else   /* not SX */
#line 3174

#line 3174
	char *xp = (char *) *xpp;
#line 3174
	int status = NC_NOERR;
#line 3174

#line 3174
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3174
	{
#line 3174
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 3174
		if (status == NC_NOERR) /* report the first encountered error */
#line 3174
			status = lstatus;
#line 3174
	}
#line 3174

#line 3174
	*xpp = (void *)xp;
#line 3174
	return status;
#line 3174
#endif
#line 3174
}
#line 3174

int
#line 3175
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3175
{
#line 3175
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3175

#line 3175
 /* basic algorithm is:
#line 3175
  *   - ensure sane alignment of output data
#line 3175
  *   - copy (conversion happens automatically) input data
#line 3175
  *     to output
#line 3175
  *   - update tp to point at next unconverted input, and xpp to point
#line 3175
  *     at next location for converted output
#line 3175
  */
#line 3175
  long i, j, ni;
#line 3175
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3175
  short *xp;
#line 3175
  int nrange = 0;         /* number of range errors */
#line 3175
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3175
  long cxp = (long) *((char**)xpp);
#line 3175

#line 3175
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3175
  /* sjl: manually stripmine so we can limit amount of
#line 3175
   * vector work space reserved to LOOPCNT elements. Also
#line 3175
   * makes vectorisation easy */
#line 3175
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3175
    ni=Min(nelems-j,LOOPCNT);
#line 3175
    if (realign) {
#line 3175
      xp = tmp;
#line 3175
    } else {
#line 3175
      xp = (short *) *xpp;
#line 3175
    }
#line 3175
   /* copy the next block */
#line 3175
#pragma cdir loopcnt=LOOPCNT
#line 3175
#pragma cdir shortloop
#line 3175
    for (i=0; i<ni; i++) {
#line 3175
      /* the normal case: */
#line 3175
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3175
     /* test for range errors (not always needed but do it anyway) */
#line 3175
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3175
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3175
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3175
    }
#line 3175
   /* copy workspace back if necessary */
#line 3175
    if (realign) {
#line 3175
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3175
      xp = (short *) *xpp;
#line 3175
    }
#line 3175
   /* update xpp and tp */
#line 3175
    xp += ni;
#line 3175
    tp += ni;
#line 3175
    *xpp = (void*)xp;
#line 3175
  }
#line 3175
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3175

#line 3175
#else   /* not SX */
#line 3175

#line 3175
	char *xp = (char *) *xpp;
#line 3175
	int status = NC_NOERR;
#line 3175

#line 3175
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3175
	{
#line 3175
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 3175
		if (status == NC_NOERR) /* report the first encountered error */
#line 3175
			status = lstatus;
#line 3175
	}
#line 3175

#line 3175
	*xpp = (void *)xp;
#line 3175
	return status;
#line 3175
#endif
#line 3175
}
#line 3175

int
#line 3176
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3176
{
#line 3176
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3176

#line 3176
 /* basic algorithm is:
#line 3176
  *   - ensure sane alignment of output data
#line 3176
  *   - copy (conversion happens automatically) input data
#line 3176
  *     to output
#line 3176
  *   - update tp to point at next unconverted input, and xpp to point
#line 3176
  *     at next location for converted output
#line 3176
  */
#line 3176
  long i, j, ni;
#line 3176
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3176
  short *xp;
#line 3176
  int nrange = 0;         /* number of range errors */
#line 3176
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3176
  long cxp = (long) *((char**)xpp);
#line 3176

#line 3176
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3176
  /* sjl: manually stripmine so we can limit amount of
#line 3176
   * vector work space reserved to LOOPCNT elements. Also
#line 3176
   * makes vectorisation easy */
#line 3176
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3176
    ni=Min(nelems-j,LOOPCNT);
#line 3176
    if (realign) {
#line 3176
      xp = tmp;
#line 3176
    } else {
#line 3176
      xp = (short *) *xpp;
#line 3176
    }
#line 3176
   /* copy the next block */
#line 3176
#pragma cdir loopcnt=LOOPCNT
#line 3176
#pragma cdir shortloop
#line 3176
    for (i=0; i<ni; i++) {
#line 3176
      /* the normal case: */
#line 3176
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3176
     /* test for range errors (not always needed but do it anyway) */
#line 3176
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3176
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3176
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3176
    }
#line 3176
   /* copy workspace back if necessary */
#line 3176
    if (realign) {
#line 3176
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3176
      xp = (short *) *xpp;
#line 3176
    }
#line 3176
   /* update xpp and tp */
#line 3176
    xp += ni;
#line 3176
    tp += ni;
#line 3176
    *xpp = (void*)xp;
#line 3176
  }
#line 3176
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3176

#line 3176
#else   /* not SX */
#line 3176

#line 3176
	char *xp = (char *) *xpp;
#line 3176
	int status = NC_NOERR;
#line 3176

#line 3176
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3176
	{
#line 3176
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 3176
		if (status == NC_NOERR) /* report the first encountered error */
#line 3176
			status = lstatus;
#line 3176
	}
#line 3176

#line 3176
	*xpp = (void *)xp;
#line 3176
	return status;
#line 3176
#endif
#line 3176
}
#line 3176

int
#line 3177
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3177
{
#line 3177
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3177

#line 3177
 /* basic algorithm is:
#line 3177
  *   - ensure sane alignment of output data
#line 3177
  *   - copy (conversion happens automatically) input data
#line 3177
  *     to output
#line 3177
  *   - update tp to point at next unconverted input, and xpp to point
#line 3177
  *     at next location for converted output
#line 3177
  */
#line 3177
  long i, j, ni;
#line 3177
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3177
  short *xp;
#line 3177
  int nrange = 0;         /* number of range errors */
#line 3177
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3177
  long cxp = (long) *((char**)xpp);
#line 3177

#line 3177
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3177
  /* sjl: manually stripmine so we can limit amount of
#line 3177
   * vector work space reserved to LOOPCNT elements. Also
#line 3177
   * makes vectorisation easy */
#line 3177
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3177
    ni=Min(nelems-j,LOOPCNT);
#line 3177
    if (realign) {
#line 3177
      xp = tmp;
#line 3177
    } else {
#line 3177
      xp = (short *) *xpp;
#line 3177
    }
#line 3177
   /* copy the next block */
#line 3177
#pragma cdir loopcnt=LOOPCNT
#line 3177
#pragma cdir shortloop
#line 3177
    for (i=0; i<ni; i++) {
#line 3177
      /* the normal case: */
#line 3177
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3177
     /* test for range errors (not always needed but do it anyway) */
#line 3177
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3177
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3177
      nrange += tp[i] > X_SHORT_MAX ;
#line 3177
    }
#line 3177
   /* copy workspace back if necessary */
#line 3177
    if (realign) {
#line 3177
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3177
      xp = (short *) *xpp;
#line 3177
    }
#line 3177
   /* update xpp and tp */
#line 3177
    xp += ni;
#line 3177
    tp += ni;
#line 3177
    *xpp = (void*)xp;
#line 3177
  }
#line 3177
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3177

#line 3177
#else   /* not SX */
#line 3177

#line 3177
	char *xp = (char *) *xpp;
#line 3177
	int status = NC_NOERR;
#line 3177

#line 3177
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3177
	{
#line 3177
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 3177
		if (status == NC_NOERR) /* report the first encountered error */
#line 3177
			status = lstatus;
#line 3177
	}
#line 3177

#line 3177
	*xpp = (void *)xp;
#line 3177
	return status;
#line 3177
#endif
#line 3177
}
#line 3177

int
#line 3178
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3178
{
#line 3178
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3178

#line 3178
 /* basic algorithm is:
#line 3178
  *   - ensure sane alignment of output data
#line 3178
  *   - copy (conversion happens automatically) input data
#line 3178
  *     to output
#line 3178
  *   - update tp to point at next unconverted input, and xpp to point
#line 3178
  *     at next location for converted output
#line 3178
  */
#line 3178
  long i, j, ni;
#line 3178
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3178
  short *xp;
#line 3178
  int nrange = 0;         /* number of range errors */
#line 3178
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3178
  long cxp = (long) *((char**)xpp);
#line 3178

#line 3178
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3178
  /* sjl: manually stripmine so we can limit amount of
#line 3178
   * vector work space reserved to LOOPCNT elements. Also
#line 3178
   * makes vectorisation easy */
#line 3178
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3178
    ni=Min(nelems-j,LOOPCNT);
#line 3178
    if (realign) {
#line 3178
      xp = tmp;
#line 3178
    } else {
#line 3178
      xp = (short *) *xpp;
#line 3178
    }
#line 3178
   /* copy the next block */
#line 3178
#pragma cdir loopcnt=LOOPCNT
#line 3178
#pragma cdir shortloop
#line 3178
    for (i=0; i<ni; i++) {
#line 3178
      /* the normal case: */
#line 3178
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3178
     /* test for range errors (not always needed but do it anyway) */
#line 3178
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3178
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3178
      nrange += tp[i] > X_SHORT_MAX ;
#line 3178
    }
#line 3178
   /* copy workspace back if necessary */
#line 3178
    if (realign) {
#line 3178
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3178
      xp = (short *) *xpp;
#line 3178
    }
#line 3178
   /* update xpp and tp */
#line 3178
    xp += ni;
#line 3178
    tp += ni;
#line 3178
    *xpp = (void*)xp;
#line 3178
  }
#line 3178
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3178

#line 3178
#else   /* not SX */
#line 3178

#line 3178
	char *xp = (char *) *xpp;
#line 3178
	int status = NC_NOERR;
#line 3178

#line 3178
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3178
	{
#line 3178
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 3178
		if (status == NC_NOERR) /* report the first encountered error */
#line 3178
			status = lstatus;
#line 3178
	}
#line 3178

#line 3178
	*xpp = (void *)xp;
#line 3178
	return status;
#line 3178
#endif
#line 3178
}
#line 3178

int
#line 3179
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3179
{
#line 3179
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3179

#line 3179
 /* basic algorithm is:
#line 3179
  *   - ensure sane alignment of output data
#line 3179
  *   - copy (conversion happens automatically) input data
#line 3179
  *     to output
#line 3179
  *   - update tp to point at next unconverted input, and xpp to point
#line 3179
  *     at next location for converted output
#line 3179
  */
#line 3179
  long i, j, ni;
#line 3179
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3179
  short *xp;
#line 3179
  int nrange = 0;         /* number of range errors */
#line 3179
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3179
  long cxp = (long) *((char**)xpp);
#line 3179

#line 3179
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3179
  /* sjl: manually stripmine so we can limit amount of
#line 3179
   * vector work space reserved to LOOPCNT elements. Also
#line 3179
   * makes vectorisation easy */
#line 3179
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3179
    ni=Min(nelems-j,LOOPCNT);
#line 3179
    if (realign) {
#line 3179
      xp = tmp;
#line 3179
    } else {
#line 3179
      xp = (short *) *xpp;
#line 3179
    }
#line 3179
   /* copy the next block */
#line 3179
#pragma cdir loopcnt=LOOPCNT
#line 3179
#pragma cdir shortloop
#line 3179
    for (i=0; i<ni; i++) {
#line 3179
      /* the normal case: */
#line 3179
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3179
     /* test for range errors (not always needed but do it anyway) */
#line 3179
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3179
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3179
      nrange += tp[i] > X_SHORT_MAX ;
#line 3179
    }
#line 3179
   /* copy workspace back if necessary */
#line 3179
    if (realign) {
#line 3179
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3179
      xp = (short *) *xpp;
#line 3179
    }
#line 3179
   /* update xpp and tp */
#line 3179
    xp += ni;
#line 3179
    tp += ni;
#line 3179
    *xpp = (void*)xp;
#line 3179
  }
#line 3179
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3179

#line 3179
#else   /* not SX */
#line 3179

#line 3179
	char *xp = (char *) *xpp;
#line 3179
	int status = NC_NOERR;
#line 3179

#line 3179
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3179
	{
#line 3179
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 3179
		if (status == NC_NOERR) /* report the first encountered error */
#line 3179
			status = lstatus;
#line 3179
	}
#line 3179

#line 3179
	*xpp = (void *)xp;
#line 3179
	return status;
#line 3179
#endif
#line 3179
}
#line 3179

int
#line 3180
ncx_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3180
{
#line 3180
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3180

#line 3180
 /* basic algorithm is:
#line 3180
  *   - ensure sane alignment of output data
#line 3180
  *   - copy (conversion happens automatically) input data
#line 3180
  *     to output
#line 3180
  *   - update tp to point at next unconverted input, and xpp to point
#line 3180
  *     at next location for converted output
#line 3180
  */
#line 3180
  long i, j, ni;
#line 3180
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3180
  short *xp;
#line 3180
  int nrange = 0;         /* number of range errors */
#line 3180
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3180
  long cxp = (long) *((char**)xpp);
#line 3180

#line 3180
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3180
  /* sjl: manually stripmine so we can limit amount of
#line 3180
   * vector work space reserved to LOOPCNT elements. Also
#line 3180
   * makes vectorisation easy */
#line 3180
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3180
    ni=Min(nelems-j,LOOPCNT);
#line 3180
    if (realign) {
#line 3180
      xp = tmp;
#line 3180
    } else {
#line 3180
      xp = (short *) *xpp;
#line 3180
    }
#line 3180
   /* copy the next block */
#line 3180
#pragma cdir loopcnt=LOOPCNT
#line 3180
#pragma cdir shortloop
#line 3180
    for (i=0; i<ni; i++) {
#line 3180
      /* the normal case: */
#line 3180
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3180
     /* test for range errors (not always needed but do it anyway) */
#line 3180
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3180
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3180
      nrange += tp[i] > X_SHORT_MAX ;
#line 3180
    }
#line 3180
   /* copy workspace back if necessary */
#line 3180
    if (realign) {
#line 3180
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3180
      xp = (short *) *xpp;
#line 3180
    }
#line 3180
   /* update xpp and tp */
#line 3180
    xp += ni;
#line 3180
    tp += ni;
#line 3180
    *xpp = (void*)xp;
#line 3180
  }
#line 3180
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3180

#line 3180
#else   /* not SX */
#line 3180

#line 3180
	char *xp = (char *) *xpp;
#line 3180
	int status = NC_NOERR;
#line 3180

#line 3180
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3180
	{
#line 3180
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 3180
		if (status == NC_NOERR) /* report the first encountered error */
#line 3180
			status = lstatus;
#line 3180
	}
#line 3180

#line 3180
	*xpp = (void *)xp;
#line 3180
	return status;
#line 3180
#endif
#line 3180
}
#line 3180


int
#line 3182
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3182
{
#line 3182
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3182

#line 3182
	char *xp = (char *) *xpp;
#line 3182
	int status = NC_NOERR;
#line 3182

#line 3182
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3182
	{
#line 3182
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 3182
		if (status == NC_NOERR) /* report the first encountered error */
#line 3182
			status = lstatus;
#line 3182
	}
#line 3182

#line 3182
	if (rndup != 0)
#line 3182
	{
#line 3182
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3182
		xp += X_SIZEOF_SHORT;
#line 3182
	}
#line 3182

#line 3182
	*xpp = (void *)xp;
#line 3182
	return status;
#line 3182
}
#line 3182

int
#line 3183
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3183
{
#line 3183
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3183

#line 3183
	char *xp = (char *) *xpp;
#line 3183
	int status = NC_NOERR;
#line 3183

#line 3183
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3183
	{
#line 3183
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 3183
		if (status == NC_NOERR) /* report the first encountered error */
#line 3183
			status = lstatus;
#line 3183
	}
#line 3183

#line 3183
	if (rndup != 0)
#line 3183
	{
#line 3183
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3183
		xp += X_SIZEOF_SHORT;
#line 3183
	}
#line 3183

#line 3183
	*xpp = (void *)xp;
#line 3183
	return status;
#line 3183
}
#line 3183

int
#line 3184
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3184
{
#line 3184
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3184

#line 3184
	char *xp = (char *) *xpp;
#line 3184
	int status = NC_NOERR;
#line 3184

#line 3184
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3184
	{
#line 3184
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 3184
		if (status == NC_NOERR) /* report the first encountered error */
#line 3184
			status = lstatus;
#line 3184
	}
#line 3184

#line 3184
	if (rndup != 0)
#line 3184
	{
#line 3184
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3184
		xp += X_SIZEOF_SHORT;
#line 3184
	}
#line 3184

#line 3184
	*xpp = (void *)xp;
#line 3184
	return status;
#line 3184
}
#line 3184

int
#line 3185
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3185
{
#line 3185
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3185

#line 3185
	char *xp = (char *) *xpp;
#line 3185
	int status = NC_NOERR;
#line 3185

#line 3185
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3185
	{
#line 3185
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 3185
		if (status == NC_NOERR) /* report the first encountered error */
#line 3185
			status = lstatus;
#line 3185
	}
#line 3185

#line 3185
	if (rndup != 0)
#line 3185
	{
#line 3185
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3185
		xp += X_SIZEOF_SHORT;
#line 3185
	}
#line 3185

#line 3185
	*xpp = (void *)xp;
#line 3185
	return status;
#line 3185
}
#line 3185

int
#line 3186
ncx_pad_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3186
{
#line 3186
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3186

#line 3186
	char *xp = (char *) *xpp;
#line 3186
	int status = NC_NOERR;
#line 3186

#line 3186
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3186
	{
#line 3186
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 3186
		if (status == NC_NOERR) /* report the first encountered error */
#line 3186
			status = lstatus;
#line 3186
	}
#line 3186

#line 3186
	if (rndup != 0)
#line 3186
	{
#line 3186
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3186
		xp += X_SIZEOF_SHORT;
#line 3186
	}
#line 3186

#line 3186
	*xpp = (void *)xp;
#line 3186
	return status;
#line 3186
}
#line 3186

int
#line 3187
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3187
{
#line 3187
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3187

#line 3187
	char *xp = (char *) *xpp;
#line 3187
	int status = NC_NOERR;
#line 3187

#line 3187
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3187
	{
#line 3187
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 3187
		if (status == NC_NOERR) /* report the first encountered error */
#line 3187
			status = lstatus;
#line 3187
	}
#line 3187

#line 3187
	if (rndup != 0)
#line 3187
	{
#line 3187
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3187
		xp += X_SIZEOF_SHORT;
#line 3187
	}
#line 3187

#line 3187
	*xpp = (void *)xp;
#line 3187
	return status;
#line 3187
}
#line 3187

int
#line 3188
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3188
{
#line 3188
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3188

#line 3188
	char *xp = (char *) *xpp;
#line 3188
	int status = NC_NOERR;
#line 3188

#line 3188
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3188
	{
#line 3188
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 3188
		if (status == NC_NOERR) /* report the first encountered error */
#line 3188
			status = lstatus;
#line 3188
	}
#line 3188

#line 3188
	if (rndup != 0)
#line 3188
	{
#line 3188
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3188
		xp += X_SIZEOF_SHORT;
#line 3188
	}
#line 3188

#line 3188
	*xpp = (void *)xp;
#line 3188
	return status;
#line 3188
}
#line 3188

int
#line 3189
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3189
{
#line 3189
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3189

#line 3189
	char *xp = (char *) *xpp;
#line 3189
	int status = NC_NOERR;
#line 3189

#line 3189
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3189
	{
#line 3189
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 3189
		if (status == NC_NOERR) /* report the first encountered error */
#line 3189
			status = lstatus;
#line 3189
	}
#line 3189

#line 3189
	if (rndup != 0)
#line 3189
	{
#line 3189
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3189
		xp += X_SIZEOF_SHORT;
#line 3189
	}
#line 3189

#line 3189
	*xpp = (void *)xp;
#line 3189
	return status;
#line 3189
}
#line 3189

int
#line 3190
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3190
{
#line 3190
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3190

#line 3190
	char *xp = (char *) *xpp;
#line 3190
	int status = NC_NOERR;
#line 3190

#line 3190
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3190
	{
#line 3190
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 3190
		if (status == NC_NOERR) /* report the first encountered error */
#line 3190
			status = lstatus;
#line 3190
	}
#line 3190

#line 3190
	if (rndup != 0)
#line 3190
	{
#line 3190
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3190
		xp += X_SIZEOF_SHORT;
#line 3190
	}
#line 3190

#line 3190
	*xpp = (void *)xp;
#line 3190
	return status;
#line 3190
}
#line 3190

int
#line 3191
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3191
{
#line 3191
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3191

#line 3191
	char *xp = (char *) *xpp;
#line 3191
	int status = NC_NOERR;
#line 3191

#line 3191
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3191
	{
#line 3191
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 3191
		if (status == NC_NOERR) /* report the first encountered error */
#line 3191
			status = lstatus;
#line 3191
	}
#line 3191

#line 3191
	if (rndup != 0)
#line 3191
	{
#line 3191
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3191
		xp += X_SIZEOF_SHORT;
#line 3191
	}
#line 3191

#line 3191
	*xpp = (void *)xp;
#line 3191
	return status;
#line 3191
}
#line 3191

int
#line 3192
ncx_pad_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3192
{
#line 3192
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3192

#line 3192
	char *xp = (char *) *xpp;
#line 3192
	int status = NC_NOERR;
#line 3192

#line 3192
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3192
	{
#line 3192
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 3192
		if (status == NC_NOERR) /* report the first encountered error */
#line 3192
			status = lstatus;
#line 3192
	}
#line 3192

#line 3192
	if (rndup != 0)
#line 3192
	{
#line 3192
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3192
		xp += X_SIZEOF_SHORT;
#line 3192
	}
#line 3192

#line 3192
	*xpp = (void *)xp;
#line 3192
	return status;
#line 3192
}
#line 3192



/* ushort --------------------------------------------------------------------*/

#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_USHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3211
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3211
{
#line 3211
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3211

#line 3211
 /* basic algorithm is:
#line 3211
  *   - ensure sane alignment of input data
#line 3211
  *   - copy (conversion happens automatically) input data
#line 3211
  *     to output
#line 3211
  *   - update xpp to point at next unconverted input, and tp to point
#line 3211
  *     at next location for converted output
#line 3211
  */
#line 3211
  long i, j, ni;
#line 3211
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3211
  ushort *xp;
#line 3211
  int nrange = 0;         /* number of range errors */
#line 3211
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3211
  long cxp = (long) *((char**)xpp);
#line 3211

#line 3211
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3211
  /* sjl: manually stripmine so we can limit amount of
#line 3211
   * vector work space reserved to LOOPCNT elements. Also
#line 3211
   * makes vectorisation easy */
#line 3211
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3211
    ni=Min(nelems-j,LOOPCNT);
#line 3211
    if (realign) {
#line 3211
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3211
      xp = tmp;
#line 3211
    } else {
#line 3211
      xp = (ushort *) *xpp;
#line 3211
    }
#line 3211
   /* copy the next block */
#line 3211
#pragma cdir loopcnt=LOOPCNT
#line 3211
#pragma cdir shortloop
#line 3211
    for (i=0; i<ni; i++) {
#line 3211
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3211
     /* test for range errors (not always needed but do it anyway) */
#line 3211
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3211
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3211
      nrange += xp[i] > USHORT_MAX ;
#line 3211
    }
#line 3211
   /* update xpp and tp */
#line 3211
    if (realign) xp = (ushort *) *xpp;
#line 3211
    xp += ni;
#line 3211
    tp += ni;
#line 3211
    *xpp = (void*)xp;
#line 3211
  }
#line 3211
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3211

#line 3211
#else   /* not SX */
#line 3211
	const char *xp = (const char *) *xpp;
#line 3211
	int status = NC_NOERR;
#line 3211

#line 3211
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3211
	{
#line 3211
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3211
		if (status == NC_NOERR) /* report the first encountered error */
#line 3211
			status = lstatus;
#line 3211
	}
#line 3211

#line 3211
	*xpp = (const void *)xp;
#line 3211
	return status;
#line 3211
#endif
#line 3211
}
#line 3211

#endif
int
#line 3213
ncx_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3213
{
#line 3213
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3213

#line 3213
 /* basic algorithm is:
#line 3213
  *   - ensure sane alignment of input data
#line 3213
  *   - copy (conversion happens automatically) input data
#line 3213
  *     to output
#line 3213
  *   - update xpp to point at next unconverted input, and tp to point
#line 3213
  *     at next location for converted output
#line 3213
  */
#line 3213
  long i, j, ni;
#line 3213
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3213
  ushort *xp;
#line 3213
  int nrange = 0;         /* number of range errors */
#line 3213
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3213
  long cxp = (long) *((char**)xpp);
#line 3213

#line 3213
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3213
  /* sjl: manually stripmine so we can limit amount of
#line 3213
   * vector work space reserved to LOOPCNT elements. Also
#line 3213
   * makes vectorisation easy */
#line 3213
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3213
    ni=Min(nelems-j,LOOPCNT);
#line 3213
    if (realign) {
#line 3213
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3213
      xp = tmp;
#line 3213
    } else {
#line 3213
      xp = (ushort *) *xpp;
#line 3213
    }
#line 3213
   /* copy the next block */
#line 3213
#pragma cdir loopcnt=LOOPCNT
#line 3213
#pragma cdir shortloop
#line 3213
    for (i=0; i<ni; i++) {
#line 3213
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3213
     /* test for range errors (not always needed but do it anyway) */
#line 3213
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3213
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3213
      nrange += xp[i] > SCHAR_MAX ;
#line 3213
    }
#line 3213
   /* update xpp and tp */
#line 3213
    if (realign) xp = (ushort *) *xpp;
#line 3213
    xp += ni;
#line 3213
    tp += ni;
#line 3213
    *xpp = (void*)xp;
#line 3213
  }
#line 3213
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3213

#line 3213
#else   /* not SX */
#line 3213
	const char *xp = (const char *) *xpp;
#line 3213
	int status = NC_NOERR;
#line 3213

#line 3213
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3213
	{
#line 3213
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3213
		if (status == NC_NOERR) /* report the first encountered error */
#line 3213
			status = lstatus;
#line 3213
	}
#line 3213

#line 3213
	*xpp = (const void *)xp;
#line 3213
	return status;
#line 3213
#endif
#line 3213
}
#line 3213

int
#line 3214
ncx_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3214
{
#line 3214
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3214

#line 3214
 /* basic algorithm is:
#line 3214
  *   - ensure sane alignment of input data
#line 3214
  *   - copy (conversion happens automatically) input data
#line 3214
  *     to output
#line 3214
  *   - update xpp to point at next unconverted input, and tp to point
#line 3214
  *     at next location for converted output
#line 3214
  */
#line 3214
  long i, j, ni;
#line 3214
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3214
  ushort *xp;
#line 3214
  int nrange = 0;         /* number of range errors */
#line 3214
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3214
  long cxp = (long) *((char**)xpp);
#line 3214

#line 3214
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3214
  /* sjl: manually stripmine so we can limit amount of
#line 3214
   * vector work space reserved to LOOPCNT elements. Also
#line 3214
   * makes vectorisation easy */
#line 3214
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3214
    ni=Min(nelems-j,LOOPCNT);
#line 3214
    if (realign) {
#line 3214
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3214
      xp = tmp;
#line 3214
    } else {
#line 3214
      xp = (ushort *) *xpp;
#line 3214
    }
#line 3214
   /* copy the next block */
#line 3214
#pragma cdir loopcnt=LOOPCNT
#line 3214
#pragma cdir shortloop
#line 3214
    for (i=0; i<ni; i++) {
#line 3214
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3214
     /* test for range errors (not always needed but do it anyway) */
#line 3214
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3214
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3214
      nrange += xp[i] > SHORT_MAX ;
#line 3214
    }
#line 3214
   /* update xpp and tp */
#line 3214
    if (realign) xp = (ushort *) *xpp;
#line 3214
    xp += ni;
#line 3214
    tp += ni;
#line 3214
    *xpp = (void*)xp;
#line 3214
  }
#line 3214
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3214

#line 3214
#else   /* not SX */
#line 3214
	const char *xp = (const char *) *xpp;
#line 3214
	int status = NC_NOERR;
#line 3214

#line 3214
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3214
	{
#line 3214
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3214
		if (status == NC_NOERR) /* report the first encountered error */
#line 3214
			status = lstatus;
#line 3214
	}
#line 3214

#line 3214
	*xpp = (const void *)xp;
#line 3214
	return status;
#line 3214
#endif
#line 3214
}
#line 3214

int
#line 3215
ncx_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3215
{
#line 3215
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3215

#line 3215
 /* basic algorithm is:
#line 3215
  *   - ensure sane alignment of input data
#line 3215
  *   - copy (conversion happens automatically) input data
#line 3215
  *     to output
#line 3215
  *   - update xpp to point at next unconverted input, and tp to point
#line 3215
  *     at next location for converted output
#line 3215
  */
#line 3215
  long i, j, ni;
#line 3215
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3215
  ushort *xp;
#line 3215
  int nrange = 0;         /* number of range errors */
#line 3215
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3215
  long cxp = (long) *((char**)xpp);
#line 3215

#line 3215
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3215
  /* sjl: manually stripmine so we can limit amount of
#line 3215
   * vector work space reserved to LOOPCNT elements. Also
#line 3215
   * makes vectorisation easy */
#line 3215
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3215
    ni=Min(nelems-j,LOOPCNT);
#line 3215
    if (realign) {
#line 3215
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3215
      xp = tmp;
#line 3215
    } else {
#line 3215
      xp = (ushort *) *xpp;
#line 3215
    }
#line 3215
   /* copy the next block */
#line 3215
#pragma cdir loopcnt=LOOPCNT
#line 3215
#pragma cdir shortloop
#line 3215
    for (i=0; i<ni; i++) {
#line 3215
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3215
     /* test for range errors (not always needed but do it anyway) */
#line 3215
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3215
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3215
      nrange += xp[i] > INT_MAX ;
#line 3215
    }
#line 3215
   /* update xpp and tp */
#line 3215
    if (realign) xp = (ushort *) *xpp;
#line 3215
    xp += ni;
#line 3215
    tp += ni;
#line 3215
    *xpp = (void*)xp;
#line 3215
  }
#line 3215
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3215

#line 3215
#else   /* not SX */
#line 3215
	const char *xp = (const char *) *xpp;
#line 3215
	int status = NC_NOERR;
#line 3215

#line 3215
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3215
	{
#line 3215
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3215
		if (status == NC_NOERR) /* report the first encountered error */
#line 3215
			status = lstatus;
#line 3215
	}
#line 3215

#line 3215
	*xpp = (const void *)xp;
#line 3215
	return status;
#line 3215
#endif
#line 3215
}
#line 3215

int
#line 3216
ncx_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3216
{
#line 3216
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3216

#line 3216
 /* basic algorithm is:
#line 3216
  *   - ensure sane alignment of input data
#line 3216
  *   - copy (conversion happens automatically) input data
#line 3216
  *     to output
#line 3216
  *   - update xpp to point at next unconverted input, and tp to point
#line 3216
  *     at next location for converted output
#line 3216
  */
#line 3216
  long i, j, ni;
#line 3216
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3216
  ushort *xp;
#line 3216
  int nrange = 0;         /* number of range errors */
#line 3216
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3216
  long cxp = (long) *((char**)xpp);
#line 3216

#line 3216
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3216
  /* sjl: manually stripmine so we can limit amount of
#line 3216
   * vector work space reserved to LOOPCNT elements. Also
#line 3216
   * makes vectorisation easy */
#line 3216
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3216
    ni=Min(nelems-j,LOOPCNT);
#line 3216
    if (realign) {
#line 3216
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3216
      xp = tmp;
#line 3216
    } else {
#line 3216
      xp = (ushort *) *xpp;
#line 3216
    }
#line 3216
   /* copy the next block */
#line 3216
#pragma cdir loopcnt=LOOPCNT
#line 3216
#pragma cdir shortloop
#line 3216
    for (i=0; i<ni; i++) {
#line 3216
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3216
     /* test for range errors (not always needed but do it anyway) */
#line 3216
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3216
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3216
      nrange += xp[i] > LONG_MAX ;
#line 3216
    }
#line 3216
   /* update xpp and tp */
#line 3216
    if (realign) xp = (ushort *) *xpp;
#line 3216
    xp += ni;
#line 3216
    tp += ni;
#line 3216
    *xpp = (void*)xp;
#line 3216
  }
#line 3216
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3216

#line 3216
#else   /* not SX */
#line 3216
	const char *xp = (const char *) *xpp;
#line 3216
	int status = NC_NOERR;
#line 3216

#line 3216
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3216
	{
#line 3216
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3216
		if (status == NC_NOERR) /* report the first encountered error */
#line 3216
			status = lstatus;
#line 3216
	}
#line 3216

#line 3216
	*xpp = (const void *)xp;
#line 3216
	return status;
#line 3216
#endif
#line 3216
}
#line 3216

int
#line 3217
ncx_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3217
{
#line 3217
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3217

#line 3217
 /* basic algorithm is:
#line 3217
  *   - ensure sane alignment of input data
#line 3217
  *   - copy (conversion happens automatically) input data
#line 3217
  *     to output
#line 3217
  *   - update xpp to point at next unconverted input, and tp to point
#line 3217
  *     at next location for converted output
#line 3217
  */
#line 3217
  long i, j, ni;
#line 3217
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3217
  ushort *xp;
#line 3217
  int nrange = 0;         /* number of range errors */
#line 3217
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3217
  long cxp = (long) *((char**)xpp);
#line 3217

#line 3217
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3217
  /* sjl: manually stripmine so we can limit amount of
#line 3217
   * vector work space reserved to LOOPCNT elements. Also
#line 3217
   * makes vectorisation easy */
#line 3217
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3217
    ni=Min(nelems-j,LOOPCNT);
#line 3217
    if (realign) {
#line 3217
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3217
      xp = tmp;
#line 3217
    } else {
#line 3217
      xp = (ushort *) *xpp;
#line 3217
    }
#line 3217
   /* copy the next block */
#line 3217
#pragma cdir loopcnt=LOOPCNT
#line 3217
#pragma cdir shortloop
#line 3217
    for (i=0; i<ni; i++) {
#line 3217
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3217
     /* test for range errors (not always needed but do it anyway) */
#line 3217
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3217
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3217
      nrange += xp[i] > FLOAT_MAX ;
#line 3217
    }
#line 3217
   /* update xpp and tp */
#line 3217
    if (realign) xp = (ushort *) *xpp;
#line 3217
    xp += ni;
#line 3217
    tp += ni;
#line 3217
    *xpp = (void*)xp;
#line 3217
  }
#line 3217
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3217

#line 3217
#else   /* not SX */
#line 3217
	const char *xp = (const char *) *xpp;
#line 3217
	int status = NC_NOERR;
#line 3217

#line 3217
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3217
	{
#line 3217
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3217
		if (status == NC_NOERR) /* report the first encountered error */
#line 3217
			status = lstatus;
#line 3217
	}
#line 3217

#line 3217
	*xpp = (const void *)xp;
#line 3217
	return status;
#line 3217
#endif
#line 3217
}
#line 3217

int
#line 3218
ncx_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3218
{
#line 3218
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3218

#line 3218
 /* basic algorithm is:
#line 3218
  *   - ensure sane alignment of input data
#line 3218
  *   - copy (conversion happens automatically) input data
#line 3218
  *     to output
#line 3218
  *   - update xpp to point at next unconverted input, and tp to point
#line 3218
  *     at next location for converted output
#line 3218
  */
#line 3218
  long i, j, ni;
#line 3218
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3218
  ushort *xp;
#line 3218
  int nrange = 0;         /* number of range errors */
#line 3218
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3218
  long cxp = (long) *((char**)xpp);
#line 3218

#line 3218
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3218
  /* sjl: manually stripmine so we can limit amount of
#line 3218
   * vector work space reserved to LOOPCNT elements. Also
#line 3218
   * makes vectorisation easy */
#line 3218
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3218
    ni=Min(nelems-j,LOOPCNT);
#line 3218
    if (realign) {
#line 3218
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3218
      xp = tmp;
#line 3218
    } else {
#line 3218
      xp = (ushort *) *xpp;
#line 3218
    }
#line 3218
   /* copy the next block */
#line 3218
#pragma cdir loopcnt=LOOPCNT
#line 3218
#pragma cdir shortloop
#line 3218
    for (i=0; i<ni; i++) {
#line 3218
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3218
     /* test for range errors (not always needed but do it anyway) */
#line 3218
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3218
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3218
      nrange += xp[i] > DOUBLE_MAX ;
#line 3218
    }
#line 3218
   /* update xpp and tp */
#line 3218
    if (realign) xp = (ushort *) *xpp;
#line 3218
    xp += ni;
#line 3218
    tp += ni;
#line 3218
    *xpp = (void*)xp;
#line 3218
  }
#line 3218
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3218

#line 3218
#else   /* not SX */
#line 3218
	const char *xp = (const char *) *xpp;
#line 3218
	int status = NC_NOERR;
#line 3218

#line 3218
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3218
	{
#line 3218
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3218
		if (status == NC_NOERR) /* report the first encountered error */
#line 3218
			status = lstatus;
#line 3218
	}
#line 3218

#line 3218
	*xpp = (const void *)xp;
#line 3218
	return status;
#line 3218
#endif
#line 3218
}
#line 3218

int
#line 3219
ncx_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3219
{
#line 3219
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3219

#line 3219
 /* basic algorithm is:
#line 3219
  *   - ensure sane alignment of input data
#line 3219
  *   - copy (conversion happens automatically) input data
#line 3219
  *     to output
#line 3219
  *   - update xpp to point at next unconverted input, and tp to point
#line 3219
  *     at next location for converted output
#line 3219
  */
#line 3219
  long i, j, ni;
#line 3219
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3219
  ushort *xp;
#line 3219
  int nrange = 0;         /* number of range errors */
#line 3219
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3219
  long cxp = (long) *((char**)xpp);
#line 3219

#line 3219
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3219
  /* sjl: manually stripmine so we can limit amount of
#line 3219
   * vector work space reserved to LOOPCNT elements. Also
#line 3219
   * makes vectorisation easy */
#line 3219
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3219
    ni=Min(nelems-j,LOOPCNT);
#line 3219
    if (realign) {
#line 3219
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3219
      xp = tmp;
#line 3219
    } else {
#line 3219
      xp = (ushort *) *xpp;
#line 3219
    }
#line 3219
   /* copy the next block */
#line 3219
#pragma cdir loopcnt=LOOPCNT
#line 3219
#pragma cdir shortloop
#line 3219
    for (i=0; i<ni; i++) {
#line 3219
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3219
     /* test for range errors (not always needed but do it anyway) */
#line 3219
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3219
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3219
      nrange += xp[i] > LONGLONG_MAX ;
#line 3219
    }
#line 3219
   /* update xpp and tp */
#line 3219
    if (realign) xp = (ushort *) *xpp;
#line 3219
    xp += ni;
#line 3219
    tp += ni;
#line 3219
    *xpp = (void*)xp;
#line 3219
  }
#line 3219
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3219

#line 3219
#else   /* not SX */
#line 3219
	const char *xp = (const char *) *xpp;
#line 3219
	int status = NC_NOERR;
#line 3219

#line 3219
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3219
	{
#line 3219
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3219
		if (status == NC_NOERR) /* report the first encountered error */
#line 3219
			status = lstatus;
#line 3219
	}
#line 3219

#line 3219
	*xpp = (const void *)xp;
#line 3219
	return status;
#line 3219
#endif
#line 3219
}
#line 3219

int
#line 3220
ncx_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3220
{
#line 3220
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3220

#line 3220
 /* basic algorithm is:
#line 3220
  *   - ensure sane alignment of input data
#line 3220
  *   - copy (conversion happens automatically) input data
#line 3220
  *     to output
#line 3220
  *   - update xpp to point at next unconverted input, and tp to point
#line 3220
  *     at next location for converted output
#line 3220
  */
#line 3220
  long i, j, ni;
#line 3220
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3220
  ushort *xp;
#line 3220
  int nrange = 0;         /* number of range errors */
#line 3220
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3220
  long cxp = (long) *((char**)xpp);
#line 3220

#line 3220
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3220
  /* sjl: manually stripmine so we can limit amount of
#line 3220
   * vector work space reserved to LOOPCNT elements. Also
#line 3220
   * makes vectorisation easy */
#line 3220
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3220
    ni=Min(nelems-j,LOOPCNT);
#line 3220
    if (realign) {
#line 3220
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3220
      xp = tmp;
#line 3220
    } else {
#line 3220
      xp = (ushort *) *xpp;
#line 3220
    }
#line 3220
   /* copy the next block */
#line 3220
#pragma cdir loopcnt=LOOPCNT
#line 3220
#pragma cdir shortloop
#line 3220
    for (i=0; i<ni; i++) {
#line 3220
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3220
     /* test for range errors (not always needed but do it anyway) */
#line 3220
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3220
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3220
      nrange += xp[i] > UCHAR_MAX ;
#line 3220
    }
#line 3220
   /* update xpp and tp */
#line 3220
    if (realign) xp = (ushort *) *xpp;
#line 3220
    xp += ni;
#line 3220
    tp += ni;
#line 3220
    *xpp = (void*)xp;
#line 3220
  }
#line 3220
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3220

#line 3220
#else   /* not SX */
#line 3220
	const char *xp = (const char *) *xpp;
#line 3220
	int status = NC_NOERR;
#line 3220

#line 3220
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3220
	{
#line 3220
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3220
		if (status == NC_NOERR) /* report the first encountered error */
#line 3220
			status = lstatus;
#line 3220
	}
#line 3220

#line 3220
	*xpp = (const void *)xp;
#line 3220
	return status;
#line 3220
#endif
#line 3220
}
#line 3220

int
#line 3221
ncx_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3221
{
#line 3221
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3221

#line 3221
 /* basic algorithm is:
#line 3221
  *   - ensure sane alignment of input data
#line 3221
  *   - copy (conversion happens automatically) input data
#line 3221
  *     to output
#line 3221
  *   - update xpp to point at next unconverted input, and tp to point
#line 3221
  *     at next location for converted output
#line 3221
  */
#line 3221
  long i, j, ni;
#line 3221
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3221
  ushort *xp;
#line 3221
  int nrange = 0;         /* number of range errors */
#line 3221
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3221
  long cxp = (long) *((char**)xpp);
#line 3221

#line 3221
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3221
  /* sjl: manually stripmine so we can limit amount of
#line 3221
   * vector work space reserved to LOOPCNT elements. Also
#line 3221
   * makes vectorisation easy */
#line 3221
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3221
    ni=Min(nelems-j,LOOPCNT);
#line 3221
    if (realign) {
#line 3221
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3221
      xp = tmp;
#line 3221
    } else {
#line 3221
      xp = (ushort *) *xpp;
#line 3221
    }
#line 3221
   /* copy the next block */
#line 3221
#pragma cdir loopcnt=LOOPCNT
#line 3221
#pragma cdir shortloop
#line 3221
    for (i=0; i<ni; i++) {
#line 3221
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3221
     /* test for range errors (not always needed but do it anyway) */
#line 3221
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3221
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3221
      nrange += xp[i] > UINT_MAX ;
#line 3221
    }
#line 3221
   /* update xpp and tp */
#line 3221
    if (realign) xp = (ushort *) *xpp;
#line 3221
    xp += ni;
#line 3221
    tp += ni;
#line 3221
    *xpp = (void*)xp;
#line 3221
  }
#line 3221
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3221

#line 3221
#else   /* not SX */
#line 3221
	const char *xp = (const char *) *xpp;
#line 3221
	int status = NC_NOERR;
#line 3221

#line 3221
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3221
	{
#line 3221
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3221
		if (status == NC_NOERR) /* report the first encountered error */
#line 3221
			status = lstatus;
#line 3221
	}
#line 3221

#line 3221
	*xpp = (const void *)xp;
#line 3221
	return status;
#line 3221
#endif
#line 3221
}
#line 3221

int
#line 3222
ncx_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3222
{
#line 3222
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3222

#line 3222
 /* basic algorithm is:
#line 3222
  *   - ensure sane alignment of input data
#line 3222
  *   - copy (conversion happens automatically) input data
#line 3222
  *     to output
#line 3222
  *   - update xpp to point at next unconverted input, and tp to point
#line 3222
  *     at next location for converted output
#line 3222
  */
#line 3222
  long i, j, ni;
#line 3222
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3222
  ushort *xp;
#line 3222
  int nrange = 0;         /* number of range errors */
#line 3222
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3222
  long cxp = (long) *((char**)xpp);
#line 3222

#line 3222
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3222
  /* sjl: manually stripmine so we can limit amount of
#line 3222
   * vector work space reserved to LOOPCNT elements. Also
#line 3222
   * makes vectorisation easy */
#line 3222
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3222
    ni=Min(nelems-j,LOOPCNT);
#line 3222
    if (realign) {
#line 3222
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3222
      xp = tmp;
#line 3222
    } else {
#line 3222
      xp = (ushort *) *xpp;
#line 3222
    }
#line 3222
   /* copy the next block */
#line 3222
#pragma cdir loopcnt=LOOPCNT
#line 3222
#pragma cdir shortloop
#line 3222
    for (i=0; i<ni; i++) {
#line 3222
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3222
     /* test for range errors (not always needed but do it anyway) */
#line 3222
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3222
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3222
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3222
    }
#line 3222
   /* update xpp and tp */
#line 3222
    if (realign) xp = (ushort *) *xpp;
#line 3222
    xp += ni;
#line 3222
    tp += ni;
#line 3222
    *xpp = (void*)xp;
#line 3222
  }
#line 3222
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3222

#line 3222
#else   /* not SX */
#line 3222
	const char *xp = (const char *) *xpp;
#line 3222
	int status = NC_NOERR;
#line 3222

#line 3222
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3222
	{
#line 3222
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3222
		if (status == NC_NOERR) /* report the first encountered error */
#line 3222
			status = lstatus;
#line 3222
	}
#line 3222

#line 3222
	*xpp = (const void *)xp;
#line 3222
	return status;
#line 3222
#endif
#line 3222
}
#line 3222


int
#line 3224
ncx_pad_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3224
{
#line 3224
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3224

#line 3224
	const char *xp = (const char *) *xpp;
#line 3224
	int status = NC_NOERR;
#line 3224

#line 3224
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3224
	{
#line 3224
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3224
		if (status == NC_NOERR) /* report the first encountered error */
#line 3224
			status = lstatus;
#line 3224
	}
#line 3224

#line 3224
	if (rndup != 0)
#line 3224
		xp += X_SIZEOF_USHORT;
#line 3224

#line 3224
	*xpp = (void *)xp;
#line 3224
	return status;
#line 3224
}
#line 3224

int
#line 3225
ncx_pad_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3225
{
#line 3225
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3225

#line 3225
	const char *xp = (const char *) *xpp;
#line 3225
	int status = NC_NOERR;
#line 3225

#line 3225
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3225
	{
#line 3225
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3225
		if (status == NC_NOERR) /* report the first encountered error */
#line 3225
			status = lstatus;
#line 3225
	}
#line 3225

#line 3225
	if (rndup != 0)
#line 3225
		xp += X_SIZEOF_USHORT;
#line 3225

#line 3225
	*xpp = (void *)xp;
#line 3225
	return status;
#line 3225
}
#line 3225

int
#line 3226
ncx_pad_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3226
{
#line 3226
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3226

#line 3226
	const char *xp = (const char *) *xpp;
#line 3226
	int status = NC_NOERR;
#line 3226

#line 3226
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3226
	{
#line 3226
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3226
		if (status == NC_NOERR) /* report the first encountered error */
#line 3226
			status = lstatus;
#line 3226
	}
#line 3226

#line 3226
	if (rndup != 0)
#line 3226
		xp += X_SIZEOF_USHORT;
#line 3226

#line 3226
	*xpp = (void *)xp;
#line 3226
	return status;
#line 3226
}
#line 3226

int
#line 3227
ncx_pad_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3227
{
#line 3227
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3227

#line 3227
	const char *xp = (const char *) *xpp;
#line 3227
	int status = NC_NOERR;
#line 3227

#line 3227
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3227
	{
#line 3227
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3227
		if (status == NC_NOERR) /* report the first encountered error */
#line 3227
			status = lstatus;
#line 3227
	}
#line 3227

#line 3227
	if (rndup != 0)
#line 3227
		xp += X_SIZEOF_USHORT;
#line 3227

#line 3227
	*xpp = (void *)xp;
#line 3227
	return status;
#line 3227
}
#line 3227

int
#line 3228
ncx_pad_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3228
{
#line 3228
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3228

#line 3228
	const char *xp = (const char *) *xpp;
#line 3228
	int status = NC_NOERR;
#line 3228

#line 3228
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3228
	{
#line 3228
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3228
		if (status == NC_NOERR) /* report the first encountered error */
#line 3228
			status = lstatus;
#line 3228
	}
#line 3228

#line 3228
	if (rndup != 0)
#line 3228
		xp += X_SIZEOF_USHORT;
#line 3228

#line 3228
	*xpp = (void *)xp;
#line 3228
	return status;
#line 3228
}
#line 3228

int
#line 3229
ncx_pad_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3229
{
#line 3229
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3229

#line 3229
	const char *xp = (const char *) *xpp;
#line 3229
	int status = NC_NOERR;
#line 3229

#line 3229
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3229
	{
#line 3229
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3229
		if (status == NC_NOERR) /* report the first encountered error */
#line 3229
			status = lstatus;
#line 3229
	}
#line 3229

#line 3229
	if (rndup != 0)
#line 3229
		xp += X_SIZEOF_USHORT;
#line 3229

#line 3229
	*xpp = (void *)xp;
#line 3229
	return status;
#line 3229
}
#line 3229

int
#line 3230
ncx_pad_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3230
{
#line 3230
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3230

#line 3230
	const char *xp = (const char *) *xpp;
#line 3230
	int status = NC_NOERR;
#line 3230

#line 3230
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3230
	{
#line 3230
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3230
		if (status == NC_NOERR) /* report the first encountered error */
#line 3230
			status = lstatus;
#line 3230
	}
#line 3230

#line 3230
	if (rndup != 0)
#line 3230
		xp += X_SIZEOF_USHORT;
#line 3230

#line 3230
	*xpp = (void *)xp;
#line 3230
	return status;
#line 3230
}
#line 3230

int
#line 3231
ncx_pad_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3231
{
#line 3231
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3231

#line 3231
	const char *xp = (const char *) *xpp;
#line 3231
	int status = NC_NOERR;
#line 3231

#line 3231
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3231
	{
#line 3231
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3231
		if (status == NC_NOERR) /* report the first encountered error */
#line 3231
			status = lstatus;
#line 3231
	}
#line 3231

#line 3231
	if (rndup != 0)
#line 3231
		xp += X_SIZEOF_USHORT;
#line 3231

#line 3231
	*xpp = (void *)xp;
#line 3231
	return status;
#line 3231
}
#line 3231

int
#line 3232
ncx_pad_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3232
{
#line 3232
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3232

#line 3232
	const char *xp = (const char *) *xpp;
#line 3232
	int status = NC_NOERR;
#line 3232

#line 3232
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3232
	{
#line 3232
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3232
		if (status == NC_NOERR) /* report the first encountered error */
#line 3232
			status = lstatus;
#line 3232
	}
#line 3232

#line 3232
	if (rndup != 0)
#line 3232
		xp += X_SIZEOF_USHORT;
#line 3232

#line 3232
	*xpp = (void *)xp;
#line 3232
	return status;
#line 3232
}
#line 3232

int
#line 3233
ncx_pad_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3233
{
#line 3233
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3233

#line 3233
	const char *xp = (const char *) *xpp;
#line 3233
	int status = NC_NOERR;
#line 3233

#line 3233
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3233
	{
#line 3233
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3233
		if (status == NC_NOERR) /* report the first encountered error */
#line 3233
			status = lstatus;
#line 3233
	}
#line 3233

#line 3233
	if (rndup != 0)
#line 3233
		xp += X_SIZEOF_USHORT;
#line 3233

#line 3233
	*xpp = (void *)xp;
#line 3233
	return status;
#line 3233
}
#line 3233

int
#line 3234
ncx_pad_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3234
{
#line 3234
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3234

#line 3234
	const char *xp = (const char *) *xpp;
#line 3234
	int status = NC_NOERR;
#line 3234

#line 3234
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3234
	{
#line 3234
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3234
		if (status == NC_NOERR) /* report the first encountered error */
#line 3234
			status = lstatus;
#line 3234
	}
#line 3234

#line 3234
	if (rndup != 0)
#line 3234
		xp += X_SIZEOF_USHORT;
#line 3234

#line 3234
	*xpp = (void *)xp;
#line 3234
	return status;
#line 3234
}
#line 3234


#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const unsigned short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_USHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3250
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3250
{
#line 3250
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3250

#line 3250
 /* basic algorithm is:
#line 3250
  *   - ensure sane alignment of output data
#line 3250
  *   - copy (conversion happens automatically) input data
#line 3250
  *     to output
#line 3250
  *   - update tp to point at next unconverted input, and xpp to point
#line 3250
  *     at next location for converted output
#line 3250
  */
#line 3250
  long i, j, ni;
#line 3250
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3250
  ushort *xp;
#line 3250
  int nrange = 0;         /* number of range errors */
#line 3250
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3250
  long cxp = (long) *((char**)xpp);
#line 3250

#line 3250
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3250
  /* sjl: manually stripmine so we can limit amount of
#line 3250
   * vector work space reserved to LOOPCNT elements. Also
#line 3250
   * makes vectorisation easy */
#line 3250
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3250
    ni=Min(nelems-j,LOOPCNT);
#line 3250
    if (realign) {
#line 3250
      xp = tmp;
#line 3250
    } else {
#line 3250
      xp = (ushort *) *xpp;
#line 3250
    }
#line 3250
   /* copy the next block */
#line 3250
#pragma cdir loopcnt=LOOPCNT
#line 3250
#pragma cdir shortloop
#line 3250
    for (i=0; i<ni; i++) {
#line 3250
      /* the normal case: */
#line 3250
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3250
     /* test for range errors (not always needed but do it anyway) */
#line 3250
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3250
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3250
      nrange += tp[i] > X_USHORT_MAX ;
#line 3250
    }
#line 3250
   /* copy workspace back if necessary */
#line 3250
    if (realign) {
#line 3250
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3250
      xp = (ushort *) *xpp;
#line 3250
    }
#line 3250
   /* update xpp and tp */
#line 3250
    xp += ni;
#line 3250
    tp += ni;
#line 3250
    *xpp = (void*)xp;
#line 3250
  }
#line 3250
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3250

#line 3250
#else   /* not SX */
#line 3250

#line 3250
	char *xp = (char *) *xpp;
#line 3250
	int status = NC_NOERR;
#line 3250

#line 3250
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3250
	{
#line 3250
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3250
		if (status == NC_NOERR) /* report the first encountered error */
#line 3250
			status = lstatus;
#line 3250
	}
#line 3250

#line 3250
	*xpp = (void *)xp;
#line 3250
	return status;
#line 3250
#endif
#line 3250
}
#line 3250

#endif
int
#line 3252
ncx_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3252
{
#line 3252
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3252

#line 3252
 /* basic algorithm is:
#line 3252
  *   - ensure sane alignment of output data
#line 3252
  *   - copy (conversion happens automatically) input data
#line 3252
  *     to output
#line 3252
  *   - update tp to point at next unconverted input, and xpp to point
#line 3252
  *     at next location for converted output
#line 3252
  */
#line 3252
  long i, j, ni;
#line 3252
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3252
  ushort *xp;
#line 3252
  int nrange = 0;         /* number of range errors */
#line 3252
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3252
  long cxp = (long) *((char**)xpp);
#line 3252

#line 3252
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3252
  /* sjl: manually stripmine so we can limit amount of
#line 3252
   * vector work space reserved to LOOPCNT elements. Also
#line 3252
   * makes vectorisation easy */
#line 3252
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3252
    ni=Min(nelems-j,LOOPCNT);
#line 3252
    if (realign) {
#line 3252
      xp = tmp;
#line 3252
    } else {
#line 3252
      xp = (ushort *) *xpp;
#line 3252
    }
#line 3252
   /* copy the next block */
#line 3252
#pragma cdir loopcnt=LOOPCNT
#line 3252
#pragma cdir shortloop
#line 3252
    for (i=0; i<ni; i++) {
#line 3252
      /* the normal case: */
#line 3252
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3252
     /* test for range errors (not always needed but do it anyway) */
#line 3252
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3252
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3252
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3252
    }
#line 3252
   /* copy workspace back if necessary */
#line 3252
    if (realign) {
#line 3252
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3252
      xp = (ushort *) *xpp;
#line 3252
    }
#line 3252
   /* update xpp and tp */
#line 3252
    xp += ni;
#line 3252
    tp += ni;
#line 3252
    *xpp = (void*)xp;
#line 3252
  }
#line 3252
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3252

#line 3252
#else   /* not SX */
#line 3252

#line 3252
	char *xp = (char *) *xpp;
#line 3252
	int status = NC_NOERR;
#line 3252

#line 3252
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3252
	{
#line 3252
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3252
		if (status == NC_NOERR) /* report the first encountered error */
#line 3252
			status = lstatus;
#line 3252
	}
#line 3252

#line 3252
	*xpp = (void *)xp;
#line 3252
	return status;
#line 3252
#endif
#line 3252
}
#line 3252

int
#line 3253
ncx_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3253
{
#line 3253
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3253

#line 3253
 /* basic algorithm is:
#line 3253
  *   - ensure sane alignment of output data
#line 3253
  *   - copy (conversion happens automatically) input data
#line 3253
  *     to output
#line 3253
  *   - update tp to point at next unconverted input, and xpp to point
#line 3253
  *     at next location for converted output
#line 3253
  */
#line 3253
  long i, j, ni;
#line 3253
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3253
  ushort *xp;
#line 3253
  int nrange = 0;         /* number of range errors */
#line 3253
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3253
  long cxp = (long) *((char**)xpp);
#line 3253

#line 3253
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3253
  /* sjl: manually stripmine so we can limit amount of
#line 3253
   * vector work space reserved to LOOPCNT elements. Also
#line 3253
   * makes vectorisation easy */
#line 3253
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3253
    ni=Min(nelems-j,LOOPCNT);
#line 3253
    if (realign) {
#line 3253
      xp = tmp;
#line 3253
    } else {
#line 3253
      xp = (ushort *) *xpp;
#line 3253
    }
#line 3253
   /* copy the next block */
#line 3253
#pragma cdir loopcnt=LOOPCNT
#line 3253
#pragma cdir shortloop
#line 3253
    for (i=0; i<ni; i++) {
#line 3253
      /* the normal case: */
#line 3253
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3253
     /* test for range errors (not always needed but do it anyway) */
#line 3253
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3253
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3253
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3253
    }
#line 3253
   /* copy workspace back if necessary */
#line 3253
    if (realign) {
#line 3253
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3253
      xp = (ushort *) *xpp;
#line 3253
    }
#line 3253
   /* update xpp and tp */
#line 3253
    xp += ni;
#line 3253
    tp += ni;
#line 3253
    *xpp = (void*)xp;
#line 3253
  }
#line 3253
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3253

#line 3253
#else   /* not SX */
#line 3253

#line 3253
	char *xp = (char *) *xpp;
#line 3253
	int status = NC_NOERR;
#line 3253

#line 3253
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3253
	{
#line 3253
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3253
		if (status == NC_NOERR) /* report the first encountered error */
#line 3253
			status = lstatus;
#line 3253
	}
#line 3253

#line 3253
	*xpp = (void *)xp;
#line 3253
	return status;
#line 3253
#endif
#line 3253
}
#line 3253

int
#line 3254
ncx_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3254
{
#line 3254
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3254

#line 3254
 /* basic algorithm is:
#line 3254
  *   - ensure sane alignment of output data
#line 3254
  *   - copy (conversion happens automatically) input data
#line 3254
  *     to output
#line 3254
  *   - update tp to point at next unconverted input, and xpp to point
#line 3254
  *     at next location for converted output
#line 3254
  */
#line 3254
  long i, j, ni;
#line 3254
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3254
  ushort *xp;
#line 3254
  int nrange = 0;         /* number of range errors */
#line 3254
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3254
  long cxp = (long) *((char**)xpp);
#line 3254

#line 3254
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3254
  /* sjl: manually stripmine so we can limit amount of
#line 3254
   * vector work space reserved to LOOPCNT elements. Also
#line 3254
   * makes vectorisation easy */
#line 3254
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3254
    ni=Min(nelems-j,LOOPCNT);
#line 3254
    if (realign) {
#line 3254
      xp = tmp;
#line 3254
    } else {
#line 3254
      xp = (ushort *) *xpp;
#line 3254
    }
#line 3254
   /* copy the next block */
#line 3254
#pragma cdir loopcnt=LOOPCNT
#line 3254
#pragma cdir shortloop
#line 3254
    for (i=0; i<ni; i++) {
#line 3254
      /* the normal case: */
#line 3254
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3254
     /* test for range errors (not always needed but do it anyway) */
#line 3254
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3254
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3254
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3254
    }
#line 3254
   /* copy workspace back if necessary */
#line 3254
    if (realign) {
#line 3254
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3254
      xp = (ushort *) *xpp;
#line 3254
    }
#line 3254
   /* update xpp and tp */
#line 3254
    xp += ni;
#line 3254
    tp += ni;
#line 3254
    *xpp = (void*)xp;
#line 3254
  }
#line 3254
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3254

#line 3254
#else   /* not SX */
#line 3254

#line 3254
	char *xp = (char *) *xpp;
#line 3254
	int status = NC_NOERR;
#line 3254

#line 3254
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3254
	{
#line 3254
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3254
		if (status == NC_NOERR) /* report the first encountered error */
#line 3254
			status = lstatus;
#line 3254
	}
#line 3254

#line 3254
	*xpp = (void *)xp;
#line 3254
	return status;
#line 3254
#endif
#line 3254
}
#line 3254

int
#line 3255
ncx_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3255
{
#line 3255
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3255

#line 3255
 /* basic algorithm is:
#line 3255
  *   - ensure sane alignment of output data
#line 3255
  *   - copy (conversion happens automatically) input data
#line 3255
  *     to output
#line 3255
  *   - update tp to point at next unconverted input, and xpp to point
#line 3255
  *     at next location for converted output
#line 3255
  */
#line 3255
  long i, j, ni;
#line 3255
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3255
  ushort *xp;
#line 3255
  int nrange = 0;         /* number of range errors */
#line 3255
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3255
  long cxp = (long) *((char**)xpp);
#line 3255

#line 3255
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3255
  /* sjl: manually stripmine so we can limit amount of
#line 3255
   * vector work space reserved to LOOPCNT elements. Also
#line 3255
   * makes vectorisation easy */
#line 3255
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3255
    ni=Min(nelems-j,LOOPCNT);
#line 3255
    if (realign) {
#line 3255
      xp = tmp;
#line 3255
    } else {
#line 3255
      xp = (ushort *) *xpp;
#line 3255
    }
#line 3255
   /* copy the next block */
#line 3255
#pragma cdir loopcnt=LOOPCNT
#line 3255
#pragma cdir shortloop
#line 3255
    for (i=0; i<ni; i++) {
#line 3255
      /* the normal case: */
#line 3255
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3255
     /* test for range errors (not always needed but do it anyway) */
#line 3255
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3255
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3255
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3255
    }
#line 3255
   /* copy workspace back if necessary */
#line 3255
    if (realign) {
#line 3255
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3255
      xp = (ushort *) *xpp;
#line 3255
    }
#line 3255
   /* update xpp and tp */
#line 3255
    xp += ni;
#line 3255
    tp += ni;
#line 3255
    *xpp = (void*)xp;
#line 3255
  }
#line 3255
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3255

#line 3255
#else   /* not SX */
#line 3255

#line 3255
	char *xp = (char *) *xpp;
#line 3255
	int status = NC_NOERR;
#line 3255

#line 3255
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3255
	{
#line 3255
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3255
		if (status == NC_NOERR) /* report the first encountered error */
#line 3255
			status = lstatus;
#line 3255
	}
#line 3255

#line 3255
	*xpp = (void *)xp;
#line 3255
	return status;
#line 3255
#endif
#line 3255
}
#line 3255

int
#line 3256
ncx_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3256
{
#line 3256
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3256

#line 3256
 /* basic algorithm is:
#line 3256
  *   - ensure sane alignment of output data
#line 3256
  *   - copy (conversion happens automatically) input data
#line 3256
  *     to output
#line 3256
  *   - update tp to point at next unconverted input, and xpp to point
#line 3256
  *     at next location for converted output
#line 3256
  */
#line 3256
  long i, j, ni;
#line 3256
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3256
  ushort *xp;
#line 3256
  int nrange = 0;         /* number of range errors */
#line 3256
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3256
  long cxp = (long) *((char**)xpp);
#line 3256

#line 3256
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3256
  /* sjl: manually stripmine so we can limit amount of
#line 3256
   * vector work space reserved to LOOPCNT elements. Also
#line 3256
   * makes vectorisation easy */
#line 3256
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3256
    ni=Min(nelems-j,LOOPCNT);
#line 3256
    if (realign) {
#line 3256
      xp = tmp;
#line 3256
    } else {
#line 3256
      xp = (ushort *) *xpp;
#line 3256
    }
#line 3256
   /* copy the next block */
#line 3256
#pragma cdir loopcnt=LOOPCNT
#line 3256
#pragma cdir shortloop
#line 3256
    for (i=0; i<ni; i++) {
#line 3256
      /* the normal case: */
#line 3256
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3256
     /* test for range errors (not always needed but do it anyway) */
#line 3256
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3256
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3256
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3256
    }
#line 3256
   /* copy workspace back if necessary */
#line 3256
    if (realign) {
#line 3256
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3256
      xp = (ushort *) *xpp;
#line 3256
    }
#line 3256
   /* update xpp and tp */
#line 3256
    xp += ni;
#line 3256
    tp += ni;
#line 3256
    *xpp = (void*)xp;
#line 3256
  }
#line 3256
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3256

#line 3256
#else   /* not SX */
#line 3256

#line 3256
	char *xp = (char *) *xpp;
#line 3256
	int status = NC_NOERR;
#line 3256

#line 3256
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3256
	{
#line 3256
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3256
		if (status == NC_NOERR) /* report the first encountered error */
#line 3256
			status = lstatus;
#line 3256
	}
#line 3256

#line 3256
	*xpp = (void *)xp;
#line 3256
	return status;
#line 3256
#endif
#line 3256
}
#line 3256

int
#line 3257
ncx_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3257
{
#line 3257
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3257

#line 3257
 /* basic algorithm is:
#line 3257
  *   - ensure sane alignment of output data
#line 3257
  *   - copy (conversion happens automatically) input data
#line 3257
  *     to output
#line 3257
  *   - update tp to point at next unconverted input, and xpp to point
#line 3257
  *     at next location for converted output
#line 3257
  */
#line 3257
  long i, j, ni;
#line 3257
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3257
  ushort *xp;
#line 3257
  int nrange = 0;         /* number of range errors */
#line 3257
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3257
  long cxp = (long) *((char**)xpp);
#line 3257

#line 3257
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3257
  /* sjl: manually stripmine so we can limit amount of
#line 3257
   * vector work space reserved to LOOPCNT elements. Also
#line 3257
   * makes vectorisation easy */
#line 3257
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3257
    ni=Min(nelems-j,LOOPCNT);
#line 3257
    if (realign) {
#line 3257
      xp = tmp;
#line 3257
    } else {
#line 3257
      xp = (ushort *) *xpp;
#line 3257
    }
#line 3257
   /* copy the next block */
#line 3257
#pragma cdir loopcnt=LOOPCNT
#line 3257
#pragma cdir shortloop
#line 3257
    for (i=0; i<ni; i++) {
#line 3257
      /* the normal case: */
#line 3257
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3257
     /* test for range errors (not always needed but do it anyway) */
#line 3257
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3257
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3257
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3257
    }
#line 3257
   /* copy workspace back if necessary */
#line 3257
    if (realign) {
#line 3257
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3257
      xp = (ushort *) *xpp;
#line 3257
    }
#line 3257
   /* update xpp and tp */
#line 3257
    xp += ni;
#line 3257
    tp += ni;
#line 3257
    *xpp = (void*)xp;
#line 3257
  }
#line 3257
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3257

#line 3257
#else   /* not SX */
#line 3257

#line 3257
	char *xp = (char *) *xpp;
#line 3257
	int status = NC_NOERR;
#line 3257

#line 3257
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3257
	{
#line 3257
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3257
		if (status == NC_NOERR) /* report the first encountered error */
#line 3257
			status = lstatus;
#line 3257
	}
#line 3257

#line 3257
	*xpp = (void *)xp;
#line 3257
	return status;
#line 3257
#endif
#line 3257
}
#line 3257

int
#line 3258
ncx_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3258
{
#line 3258
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3258

#line 3258
 /* basic algorithm is:
#line 3258
  *   - ensure sane alignment of output data
#line 3258
  *   - copy (conversion happens automatically) input data
#line 3258
  *     to output
#line 3258
  *   - update tp to point at next unconverted input, and xpp to point
#line 3258
  *     at next location for converted output
#line 3258
  */
#line 3258
  long i, j, ni;
#line 3258
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3258
  ushort *xp;
#line 3258
  int nrange = 0;         /* number of range errors */
#line 3258
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3258
  long cxp = (long) *((char**)xpp);
#line 3258

#line 3258
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3258
  /* sjl: manually stripmine so we can limit amount of
#line 3258
   * vector work space reserved to LOOPCNT elements. Also
#line 3258
   * makes vectorisation easy */
#line 3258
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3258
    ni=Min(nelems-j,LOOPCNT);
#line 3258
    if (realign) {
#line 3258
      xp = tmp;
#line 3258
    } else {
#line 3258
      xp = (ushort *) *xpp;
#line 3258
    }
#line 3258
   /* copy the next block */
#line 3258
#pragma cdir loopcnt=LOOPCNT
#line 3258
#pragma cdir shortloop
#line 3258
    for (i=0; i<ni; i++) {
#line 3258
      /* the normal case: */
#line 3258
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3258
     /* test for range errors (not always needed but do it anyway) */
#line 3258
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3258
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3258
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3258
    }
#line 3258
   /* copy workspace back if necessary */
#line 3258
    if (realign) {
#line 3258
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3258
      xp = (ushort *) *xpp;
#line 3258
    }
#line 3258
   /* update xpp and tp */
#line 3258
    xp += ni;
#line 3258
    tp += ni;
#line 3258
    *xpp = (void*)xp;
#line 3258
  }
#line 3258
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3258

#line 3258
#else   /* not SX */
#line 3258

#line 3258
	char *xp = (char *) *xpp;
#line 3258
	int status = NC_NOERR;
#line 3258

#line 3258
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3258
	{
#line 3258
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3258
		if (status == NC_NOERR) /* report the first encountered error */
#line 3258
			status = lstatus;
#line 3258
	}
#line 3258

#line 3258
	*xpp = (void *)xp;
#line 3258
	return status;
#line 3258
#endif
#line 3258
}
#line 3258

int
#line 3259
ncx_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3259
{
#line 3259
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3259

#line 3259
 /* basic algorithm is:
#line 3259
  *   - ensure sane alignment of output data
#line 3259
  *   - copy (conversion happens automatically) input data
#line 3259
  *     to output
#line 3259
  *   - update tp to point at next unconverted input, and xpp to point
#line 3259
  *     at next location for converted output
#line 3259
  */
#line 3259
  long i, j, ni;
#line 3259
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3259
  ushort *xp;
#line 3259
  int nrange = 0;         /* number of range errors */
#line 3259
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3259
  long cxp = (long) *((char**)xpp);
#line 3259

#line 3259
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3259
  /* sjl: manually stripmine so we can limit amount of
#line 3259
   * vector work space reserved to LOOPCNT elements. Also
#line 3259
   * makes vectorisation easy */
#line 3259
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3259
    ni=Min(nelems-j,LOOPCNT);
#line 3259
    if (realign) {
#line 3259
      xp = tmp;
#line 3259
    } else {
#line 3259
      xp = (ushort *) *xpp;
#line 3259
    }
#line 3259
   /* copy the next block */
#line 3259
#pragma cdir loopcnt=LOOPCNT
#line 3259
#pragma cdir shortloop
#line 3259
    for (i=0; i<ni; i++) {
#line 3259
      /* the normal case: */
#line 3259
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3259
     /* test for range errors (not always needed but do it anyway) */
#line 3259
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3259
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3259
      nrange += tp[i] > X_USHORT_MAX ;
#line 3259
    }
#line 3259
   /* copy workspace back if necessary */
#line 3259
    if (realign) {
#line 3259
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3259
      xp = (ushort *) *xpp;
#line 3259
    }
#line 3259
   /* update xpp and tp */
#line 3259
    xp += ni;
#line 3259
    tp += ni;
#line 3259
    *xpp = (void*)xp;
#line 3259
  }
#line 3259
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3259

#line 3259
#else   /* not SX */
#line 3259

#line 3259
	char *xp = (char *) *xpp;
#line 3259
	int status = NC_NOERR;
#line 3259

#line 3259
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3259
	{
#line 3259
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3259
		if (status == NC_NOERR) /* report the first encountered error */
#line 3259
			status = lstatus;
#line 3259
	}
#line 3259

#line 3259
	*xpp = (void *)xp;
#line 3259
	return status;
#line 3259
#endif
#line 3259
}
#line 3259

int
#line 3260
ncx_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3260
{
#line 3260
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3260

#line 3260
 /* basic algorithm is:
#line 3260
  *   - ensure sane alignment of output data
#line 3260
  *   - copy (conversion happens automatically) input data
#line 3260
  *     to output
#line 3260
  *   - update tp to point at next unconverted input, and xpp to point
#line 3260
  *     at next location for converted output
#line 3260
  */
#line 3260
  long i, j, ni;
#line 3260
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3260
  ushort *xp;
#line 3260
  int nrange = 0;         /* number of range errors */
#line 3260
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3260
  long cxp = (long) *((char**)xpp);
#line 3260

#line 3260
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3260
  /* sjl: manually stripmine so we can limit amount of
#line 3260
   * vector work space reserved to LOOPCNT elements. Also
#line 3260
   * makes vectorisation easy */
#line 3260
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3260
    ni=Min(nelems-j,LOOPCNT);
#line 3260
    if (realign) {
#line 3260
      xp = tmp;
#line 3260
    } else {
#line 3260
      xp = (ushort *) *xpp;
#line 3260
    }
#line 3260
   /* copy the next block */
#line 3260
#pragma cdir loopcnt=LOOPCNT
#line 3260
#pragma cdir shortloop
#line 3260
    for (i=0; i<ni; i++) {
#line 3260
      /* the normal case: */
#line 3260
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3260
     /* test for range errors (not always needed but do it anyway) */
#line 3260
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3260
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3260
      nrange += tp[i] > X_USHORT_MAX ;
#line 3260
    }
#line 3260
   /* copy workspace back if necessary */
#line 3260
    if (realign) {
#line 3260
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3260
      xp = (ushort *) *xpp;
#line 3260
    }
#line 3260
   /* update xpp and tp */
#line 3260
    xp += ni;
#line 3260
    tp += ni;
#line 3260
    *xpp = (void*)xp;
#line 3260
  }
#line 3260
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3260

#line 3260
#else   /* not SX */
#line 3260

#line 3260
	char *xp = (char *) *xpp;
#line 3260
	int status = NC_NOERR;
#line 3260

#line 3260
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3260
	{
#line 3260
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3260
		if (status == NC_NOERR) /* report the first encountered error */
#line 3260
			status = lstatus;
#line 3260
	}
#line 3260

#line 3260
	*xpp = (void *)xp;
#line 3260
	return status;
#line 3260
#endif
#line 3260
}
#line 3260

int
#line 3261
ncx_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3261
{
#line 3261
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3261

#line 3261
 /* basic algorithm is:
#line 3261
  *   - ensure sane alignment of output data
#line 3261
  *   - copy (conversion happens automatically) input data
#line 3261
  *     to output
#line 3261
  *   - update tp to point at next unconverted input, and xpp to point
#line 3261
  *     at next location for converted output
#line 3261
  */
#line 3261
  long i, j, ni;
#line 3261
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3261
  ushort *xp;
#line 3261
  int nrange = 0;         /* number of range errors */
#line 3261
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3261
  long cxp = (long) *((char**)xpp);
#line 3261

#line 3261
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3261
  /* sjl: manually stripmine so we can limit amount of
#line 3261
   * vector work space reserved to LOOPCNT elements. Also
#line 3261
   * makes vectorisation easy */
#line 3261
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3261
    ni=Min(nelems-j,LOOPCNT);
#line 3261
    if (realign) {
#line 3261
      xp = tmp;
#line 3261
    } else {
#line 3261
      xp = (ushort *) *xpp;
#line 3261
    }
#line 3261
   /* copy the next block */
#line 3261
#pragma cdir loopcnt=LOOPCNT
#line 3261
#pragma cdir shortloop
#line 3261
    for (i=0; i<ni; i++) {
#line 3261
      /* the normal case: */
#line 3261
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3261
     /* test for range errors (not always needed but do it anyway) */
#line 3261
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3261
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3261
      nrange += tp[i] > X_USHORT_MAX ;
#line 3261
    }
#line 3261
   /* copy workspace back if necessary */
#line 3261
    if (realign) {
#line 3261
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3261
      xp = (ushort *) *xpp;
#line 3261
    }
#line 3261
   /* update xpp and tp */
#line 3261
    xp += ni;
#line 3261
    tp += ni;
#line 3261
    *xpp = (void*)xp;
#line 3261
  }
#line 3261
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3261

#line 3261
#else   /* not SX */
#line 3261

#line 3261
	char *xp = (char *) *xpp;
#line 3261
	int status = NC_NOERR;
#line 3261

#line 3261
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3261
	{
#line 3261
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3261
		if (status == NC_NOERR) /* report the first encountered error */
#line 3261
			status = lstatus;
#line 3261
	}
#line 3261

#line 3261
	*xpp = (void *)xp;
#line 3261
	return status;
#line 3261
#endif
#line 3261
}
#line 3261


int
#line 3263
ncx_pad_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3263
{
#line 3263
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3263

#line 3263
	char *xp = (char *) *xpp;
#line 3263
	int status = NC_NOERR;
#line 3263

#line 3263
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3263
	{
#line 3263
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3263
		if (status == NC_NOERR) /* report the first encountered error */
#line 3263
			status = lstatus;
#line 3263
	}
#line 3263

#line 3263
	if (rndup != 0)
#line 3263
	{
#line 3263
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3263
		xp += X_SIZEOF_USHORT;
#line 3263
	}
#line 3263

#line 3263
	*xpp = (void *)xp;
#line 3263
	return status;
#line 3263
}
#line 3263

int
#line 3264
ncx_pad_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3264
{
#line 3264
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3264

#line 3264
	char *xp = (char *) *xpp;
#line 3264
	int status = NC_NOERR;
#line 3264

#line 3264
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3264
	{
#line 3264
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3264
		if (status == NC_NOERR) /* report the first encountered error */
#line 3264
			status = lstatus;
#line 3264
	}
#line 3264

#line 3264
	if (rndup != 0)
#line 3264
	{
#line 3264
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3264
		xp += X_SIZEOF_USHORT;
#line 3264
	}
#line 3264

#line 3264
	*xpp = (void *)xp;
#line 3264
	return status;
#line 3264
}
#line 3264

int
#line 3265
ncx_pad_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3265
{
#line 3265
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3265

#line 3265
	char *xp = (char *) *xpp;
#line 3265
	int status = NC_NOERR;
#line 3265

#line 3265
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3265
	{
#line 3265
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3265
		if (status == NC_NOERR) /* report the first encountered error */
#line 3265
			status = lstatus;
#line 3265
	}
#line 3265

#line 3265
	if (rndup != 0)
#line 3265
	{
#line 3265
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3265
		xp += X_SIZEOF_USHORT;
#line 3265
	}
#line 3265

#line 3265
	*xpp = (void *)xp;
#line 3265
	return status;
#line 3265
}
#line 3265

int
#line 3266
ncx_pad_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3266
{
#line 3266
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3266

#line 3266
	char *xp = (char *) *xpp;
#line 3266
	int status = NC_NOERR;
#line 3266

#line 3266
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3266
	{
#line 3266
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3266
		if (status == NC_NOERR) /* report the first encountered error */
#line 3266
			status = lstatus;
#line 3266
	}
#line 3266

#line 3266
	if (rndup != 0)
#line 3266
	{
#line 3266
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3266
		xp += X_SIZEOF_USHORT;
#line 3266
	}
#line 3266

#line 3266
	*xpp = (void *)xp;
#line 3266
	return status;
#line 3266
}
#line 3266

int
#line 3267
ncx_pad_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3267
{
#line 3267
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3267

#line 3267
	char *xp = (char *) *xpp;
#line 3267
	int status = NC_NOERR;
#line 3267

#line 3267
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3267
	{
#line 3267
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3267
		if (status == NC_NOERR) /* report the first encountered error */
#line 3267
			status = lstatus;
#line 3267
	}
#line 3267

#line 3267
	if (rndup != 0)
#line 3267
	{
#line 3267
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3267
		xp += X_SIZEOF_USHORT;
#line 3267
	}
#line 3267

#line 3267
	*xpp = (void *)xp;
#line 3267
	return status;
#line 3267
}
#line 3267

int
#line 3268
ncx_pad_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3268
{
#line 3268
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3268

#line 3268
	char *xp = (char *) *xpp;
#line 3268
	int status = NC_NOERR;
#line 3268

#line 3268
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3268
	{
#line 3268
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3268
		if (status == NC_NOERR) /* report the first encountered error */
#line 3268
			status = lstatus;
#line 3268
	}
#line 3268

#line 3268
	if (rndup != 0)
#line 3268
	{
#line 3268
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3268
		xp += X_SIZEOF_USHORT;
#line 3268
	}
#line 3268

#line 3268
	*xpp = (void *)xp;
#line 3268
	return status;
#line 3268
}
#line 3268

int
#line 3269
ncx_pad_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3269
{
#line 3269
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3269

#line 3269
	char *xp = (char *) *xpp;
#line 3269
	int status = NC_NOERR;
#line 3269

#line 3269
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3269
	{
#line 3269
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3269
		if (status == NC_NOERR) /* report the first encountered error */
#line 3269
			status = lstatus;
#line 3269
	}
#line 3269

#line 3269
	if (rndup != 0)
#line 3269
	{
#line 3269
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3269
		xp += X_SIZEOF_USHORT;
#line 3269
	}
#line 3269

#line 3269
	*xpp = (void *)xp;
#line 3269
	return status;
#line 3269
}
#line 3269

int
#line 3270
ncx_pad_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3270
{
#line 3270
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3270

#line 3270
	char *xp = (char *) *xpp;
#line 3270
	int status = NC_NOERR;
#line 3270

#line 3270
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3270
	{
#line 3270
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3270
		if (status == NC_NOERR) /* report the first encountered error */
#line 3270
			status = lstatus;
#line 3270
	}
#line 3270

#line 3270
	if (rndup != 0)
#line 3270
	{
#line 3270
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3270
		xp += X_SIZEOF_USHORT;
#line 3270
	}
#line 3270

#line 3270
	*xpp = (void *)xp;
#line 3270
	return status;
#line 3270
}
#line 3270

int
#line 3271
ncx_pad_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3271
{
#line 3271
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3271

#line 3271
	char *xp = (char *) *xpp;
#line 3271
	int status = NC_NOERR;
#line 3271

#line 3271
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3271
	{
#line 3271
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3271
		if (status == NC_NOERR) /* report the first encountered error */
#line 3271
			status = lstatus;
#line 3271
	}
#line 3271

#line 3271
	if (rndup != 0)
#line 3271
	{
#line 3271
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3271
		xp += X_SIZEOF_USHORT;
#line 3271
	}
#line 3271

#line 3271
	*xpp = (void *)xp;
#line 3271
	return status;
#line 3271
}
#line 3271

int
#line 3272
ncx_pad_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3272
{
#line 3272
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3272

#line 3272
	char *xp = (char *) *xpp;
#line 3272
	int status = NC_NOERR;
#line 3272

#line 3272
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3272
	{
#line 3272
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3272
		if (status == NC_NOERR) /* report the first encountered error */
#line 3272
			status = lstatus;
#line 3272
	}
#line 3272

#line 3272
	if (rndup != 0)
#line 3272
	{
#line 3272
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3272
		xp += X_SIZEOF_USHORT;
#line 3272
	}
#line 3272

#line 3272
	*xpp = (void *)xp;
#line 3272
	return status;
#line 3272
}
#line 3272

int
#line 3273
ncx_pad_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3273
{
#line 3273
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3273

#line 3273
	char *xp = (char *) *xpp;
#line 3273
	int status = NC_NOERR;
#line 3273

#line 3273
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3273
	{
#line 3273
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3273
		if (status == NC_NOERR) /* report the first encountered error */
#line 3273
			status = lstatus;
#line 3273
	}
#line 3273

#line 3273
	if (rndup != 0)
#line 3273
	{
#line 3273
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3273
		xp += X_SIZEOF_USHORT;
#line 3273
	}
#line 3273

#line 3273
	*xpp = (void *)xp;
#line 3273
	return status;
#line 3273
}
#line 3273



/* int -----------------------------------------------------------------------*/

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_INT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3292
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
#line 3292
{
#line 3292
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3292

#line 3292
 /* basic algorithm is:
#line 3292
  *   - ensure sane alignment of input data
#line 3292
  *   - copy (conversion happens automatically) input data
#line 3292
  *     to output
#line 3292
  *   - update xpp to point at next unconverted input, and tp to point
#line 3292
  *     at next location for converted output
#line 3292
  */
#line 3292
  long i, j, ni;
#line 3292
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3292
  int *xp;
#line 3292
  int nrange = 0;         /* number of range errors */
#line 3292
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3292
  long cxp = (long) *((char**)xpp);
#line 3292

#line 3292
  realign = (cxp & 7) % SIZEOF_INT;
#line 3292
  /* sjl: manually stripmine so we can limit amount of
#line 3292
   * vector work space reserved to LOOPCNT elements. Also
#line 3292
   * makes vectorisation easy */
#line 3292
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3292
    ni=Min(nelems-j,LOOPCNT);
#line 3292
    if (realign) {
#line 3292
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3292
      xp = tmp;
#line 3292
    } else {
#line 3292
      xp = (int *) *xpp;
#line 3292
    }
#line 3292
   /* copy the next block */
#line 3292
#pragma cdir loopcnt=LOOPCNT
#line 3292
#pragma cdir shortloop
#line 3292
    for (i=0; i<ni; i++) {
#line 3292
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3292
     /* test for range errors (not always needed but do it anyway) */
#line 3292
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3292
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3292
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3292
    }
#line 3292
   /* update xpp and tp */
#line 3292
    if (realign) xp = (int *) *xpp;
#line 3292
    xp += ni;
#line 3292
    tp += ni;
#line 3292
    *xpp = (void*)xp;
#line 3292
  }
#line 3292
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3292

#line 3292
#else   /* not SX */
#line 3292
	const char *xp = (const char *) *xpp;
#line 3292
	int status = NC_NOERR;
#line 3292

#line 3292
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3292
	{
#line 3292
		const int lstatus = ncx_get_int_int(xp, tp);
#line 3292
		if (status == NC_NOERR) /* report the first encountered error */
#line 3292
			status = lstatus;
#line 3292
	}
#line 3292

#line 3292
	*xpp = (const void *)xp;
#line 3292
	return status;
#line 3292
#endif
#line 3292
}
#line 3292

#endif
int
#line 3294
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
#line 3294
{
#line 3294
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3294

#line 3294
 /* basic algorithm is:
#line 3294
  *   - ensure sane alignment of input data
#line 3294
  *   - copy (conversion happens automatically) input data
#line 3294
  *     to output
#line 3294
  *   - update xpp to point at next unconverted input, and tp to point
#line 3294
  *     at next location for converted output
#line 3294
  */
#line 3294
  long i, j, ni;
#line 3294
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3294
  int *xp;
#line 3294
  int nrange = 0;         /* number of range errors */
#line 3294
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3294
  long cxp = (long) *((char**)xpp);
#line 3294

#line 3294
  realign = (cxp & 7) % SIZEOF_INT;
#line 3294
  /* sjl: manually stripmine so we can limit amount of
#line 3294
   * vector work space reserved to LOOPCNT elements. Also
#line 3294
   * makes vectorisation easy */
#line 3294
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3294
    ni=Min(nelems-j,LOOPCNT);
#line 3294
    if (realign) {
#line 3294
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3294
      xp = tmp;
#line 3294
    } else {
#line 3294
      xp = (int *) *xpp;
#line 3294
    }
#line 3294
   /* copy the next block */
#line 3294
#pragma cdir loopcnt=LOOPCNT
#line 3294
#pragma cdir shortloop
#line 3294
    for (i=0; i<ni; i++) {
#line 3294
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3294
     /* test for range errors (not always needed but do it anyway) */
#line 3294
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3294
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3294
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3294
    }
#line 3294
   /* update xpp and tp */
#line 3294
    if (realign) xp = (int *) *xpp;
#line 3294
    xp += ni;
#line 3294
    tp += ni;
#line 3294
    *xpp = (void*)xp;
#line 3294
  }
#line 3294
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3294

#line 3294
#else   /* not SX */
#line 3294
	const char *xp = (const char *) *xpp;
#line 3294
	int status = NC_NOERR;
#line 3294

#line 3294
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3294
	{
#line 3294
		const int lstatus = ncx_get_int_schar(xp, tp);
#line 3294
		if (status == NC_NOERR) /* report the first encountered error */
#line 3294
			status = lstatus;
#line 3294
	}
#line 3294

#line 3294
	*xpp = (const void *)xp;
#line 3294
	return status;
#line 3294
#endif
#line 3294
}
#line 3294

int
#line 3295
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
#line 3295
{
#line 3295
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3295

#line 3295
 /* basic algorithm is:
#line 3295
  *   - ensure sane alignment of input data
#line 3295
  *   - copy (conversion happens automatically) input data
#line 3295
  *     to output
#line 3295
  *   - update xpp to point at next unconverted input, and tp to point
#line 3295
  *     at next location for converted output
#line 3295
  */
#line 3295
  long i, j, ni;
#line 3295
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3295
  int *xp;
#line 3295
  int nrange = 0;         /* number of range errors */
#line 3295
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3295
  long cxp = (long) *((char**)xpp);
#line 3295

#line 3295
  realign = (cxp & 7) % SIZEOF_INT;
#line 3295
  /* sjl: manually stripmine so we can limit amount of
#line 3295
   * vector work space reserved to LOOPCNT elements. Also
#line 3295
   * makes vectorisation easy */
#line 3295
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3295
    ni=Min(nelems-j,LOOPCNT);
#line 3295
    if (realign) {
#line 3295
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3295
      xp = tmp;
#line 3295
    } else {
#line 3295
      xp = (int *) *xpp;
#line 3295
    }
#line 3295
   /* copy the next block */
#line 3295
#pragma cdir loopcnt=LOOPCNT
#line 3295
#pragma cdir shortloop
#line 3295
    for (i=0; i<ni; i++) {
#line 3295
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3295
     /* test for range errors (not always needed but do it anyway) */
#line 3295
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3295
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3295
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3295
    }
#line 3295
   /* update xpp and tp */
#line 3295
    if (realign) xp = (int *) *xpp;
#line 3295
    xp += ni;
#line 3295
    tp += ni;
#line 3295
    *xpp = (void*)xp;
#line 3295
  }
#line 3295
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3295

#line 3295
#else   /* not SX */
#line 3295
	const char *xp = (const char *) *xpp;
#line 3295
	int status = NC_NOERR;
#line 3295

#line 3295
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3295
	{
#line 3295
		const int lstatus = ncx_get_int_short(xp, tp);
#line 3295
		if (status == NC_NOERR) /* report the first encountered error */
#line 3295
			status = lstatus;
#line 3295
	}
#line 3295

#line 3295
	*xpp = (const void *)xp;
#line 3295
	return status;
#line 3295
#endif
#line 3295
}
#line 3295

int
#line 3296
ncx_getn_int_long(const void **xpp, size_t nelems, long *tp)
#line 3296
{
#line 3296
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3296

#line 3296
 /* basic algorithm is:
#line 3296
  *   - ensure sane alignment of input data
#line 3296
  *   - copy (conversion happens automatically) input data
#line 3296
  *     to output
#line 3296
  *   - update xpp to point at next unconverted input, and tp to point
#line 3296
  *     at next location for converted output
#line 3296
  */
#line 3296
  long i, j, ni;
#line 3296
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3296
  int *xp;
#line 3296
  int nrange = 0;         /* number of range errors */
#line 3296
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3296
  long cxp = (long) *((char**)xpp);
#line 3296

#line 3296
  realign = (cxp & 7) % SIZEOF_INT;
#line 3296
  /* sjl: manually stripmine so we can limit amount of
#line 3296
   * vector work space reserved to LOOPCNT elements. Also
#line 3296
   * makes vectorisation easy */
#line 3296
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3296
    ni=Min(nelems-j,LOOPCNT);
#line 3296
    if (realign) {
#line 3296
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3296
      xp = tmp;
#line 3296
    } else {
#line 3296
      xp = (int *) *xpp;
#line 3296
    }
#line 3296
   /* copy the next block */
#line 3296
#pragma cdir loopcnt=LOOPCNT
#line 3296
#pragma cdir shortloop
#line 3296
    for (i=0; i<ni; i++) {
#line 3296
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3296
     /* test for range errors (not always needed but do it anyway) */
#line 3296
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3296
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3296
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3296
    }
#line 3296
   /* update xpp and tp */
#line 3296
    if (realign) xp = (int *) *xpp;
#line 3296
    xp += ni;
#line 3296
    tp += ni;
#line 3296
    *xpp = (void*)xp;
#line 3296
  }
#line 3296
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3296

#line 3296
#else   /* not SX */
#line 3296
	const char *xp = (const char *) *xpp;
#line 3296
	int status = NC_NOERR;
#line 3296

#line 3296
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3296
	{
#line 3296
		const int lstatus = ncx_get_int_long(xp, tp);
#line 3296
		if (status == NC_NOERR) /* report the first encountered error */
#line 3296
			status = lstatus;
#line 3296
	}
#line 3296

#line 3296
	*xpp = (const void *)xp;
#line 3296
	return status;
#line 3296
#endif
#line 3296
}
#line 3296

int
#line 3297
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
#line 3297
{
#line 3297
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3297

#line 3297
 /* basic algorithm is:
#line 3297
  *   - ensure sane alignment of input data
#line 3297
  *   - copy (conversion happens automatically) input data
#line 3297
  *     to output
#line 3297
  *   - update xpp to point at next unconverted input, and tp to point
#line 3297
  *     at next location for converted output
#line 3297
  */
#line 3297
  long i, j, ni;
#line 3297
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3297
  int *xp;
#line 3297
  int nrange = 0;         /* number of range errors */
#line 3297
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3297
  long cxp = (long) *((char**)xpp);
#line 3297

#line 3297
  realign = (cxp & 7) % SIZEOF_INT;
#line 3297
  /* sjl: manually stripmine so we can limit amount of
#line 3297
   * vector work space reserved to LOOPCNT elements. Also
#line 3297
   * makes vectorisation easy */
#line 3297
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3297
    ni=Min(nelems-j,LOOPCNT);
#line 3297
    if (realign) {
#line 3297
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3297
      xp = tmp;
#line 3297
    } else {
#line 3297
      xp = (int *) *xpp;
#line 3297
    }
#line 3297
   /* copy the next block */
#line 3297
#pragma cdir loopcnt=LOOPCNT
#line 3297
#pragma cdir shortloop
#line 3297
    for (i=0; i<ni; i++) {
#line 3297
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3297
     /* test for range errors (not always needed but do it anyway) */
#line 3297
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3297
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3297
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3297
    }
#line 3297
   /* update xpp and tp */
#line 3297
    if (realign) xp = (int *) *xpp;
#line 3297
    xp += ni;
#line 3297
    tp += ni;
#line 3297
    *xpp = (void*)xp;
#line 3297
  }
#line 3297
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3297

#line 3297
#else   /* not SX */
#line 3297
	const char *xp = (const char *) *xpp;
#line 3297
	int status = NC_NOERR;
#line 3297

#line 3297
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3297
	{
#line 3297
		const int lstatus = ncx_get_int_float(xp, tp);
#line 3297
		if (status == NC_NOERR) /* report the first encountered error */
#line 3297
			status = lstatus;
#line 3297
	}
#line 3297

#line 3297
	*xpp = (const void *)xp;
#line 3297
	return status;
#line 3297
#endif
#line 3297
}
#line 3297

int
#line 3298
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
#line 3298
{
#line 3298
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3298

#line 3298
 /* basic algorithm is:
#line 3298
  *   - ensure sane alignment of input data
#line 3298
  *   - copy (conversion happens automatically) input data
#line 3298
  *     to output
#line 3298
  *   - update xpp to point at next unconverted input, and tp to point
#line 3298
  *     at next location for converted output
#line 3298
  */
#line 3298
  long i, j, ni;
#line 3298
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3298
  int *xp;
#line 3298
  int nrange = 0;         /* number of range errors */
#line 3298
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3298
  long cxp = (long) *((char**)xpp);
#line 3298

#line 3298
  realign = (cxp & 7) % SIZEOF_INT;
#line 3298
  /* sjl: manually stripmine so we can limit amount of
#line 3298
   * vector work space reserved to LOOPCNT elements. Also
#line 3298
   * makes vectorisation easy */
#line 3298
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3298
    ni=Min(nelems-j,LOOPCNT);
#line 3298
    if (realign) {
#line 3298
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3298
      xp = tmp;
#line 3298
    } else {
#line 3298
      xp = (int *) *xpp;
#line 3298
    }
#line 3298
   /* copy the next block */
#line 3298
#pragma cdir loopcnt=LOOPCNT
#line 3298
#pragma cdir shortloop
#line 3298
    for (i=0; i<ni; i++) {
#line 3298
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3298
     /* test for range errors (not always needed but do it anyway) */
#line 3298
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3298
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3298
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3298
    }
#line 3298
   /* update xpp and tp */
#line 3298
    if (realign) xp = (int *) *xpp;
#line 3298
    xp += ni;
#line 3298
    tp += ni;
#line 3298
    *xpp = (void*)xp;
#line 3298
  }
#line 3298
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3298

#line 3298
#else   /* not SX */
#line 3298
	const char *xp = (const char *) *xpp;
#line 3298
	int status = NC_NOERR;
#line 3298

#line 3298
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3298
	{
#line 3298
		const int lstatus = ncx_get_int_double(xp, tp);
#line 3298
		if (status == NC_NOERR) /* report the first encountered error */
#line 3298
			status = lstatus;
#line 3298
	}
#line 3298

#line 3298
	*xpp = (const void *)xp;
#line 3298
	return status;
#line 3298
#endif
#line 3298
}
#line 3298

int
#line 3299
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3299
{
#line 3299
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3299

#line 3299
 /* basic algorithm is:
#line 3299
  *   - ensure sane alignment of input data
#line 3299
  *   - copy (conversion happens automatically) input data
#line 3299
  *     to output
#line 3299
  *   - update xpp to point at next unconverted input, and tp to point
#line 3299
  *     at next location for converted output
#line 3299
  */
#line 3299
  long i, j, ni;
#line 3299
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3299
  int *xp;
#line 3299
  int nrange = 0;         /* number of range errors */
#line 3299
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3299
  long cxp = (long) *((char**)xpp);
#line 3299

#line 3299
  realign = (cxp & 7) % SIZEOF_INT;
#line 3299
  /* sjl: manually stripmine so we can limit amount of
#line 3299
   * vector work space reserved to LOOPCNT elements. Also
#line 3299
   * makes vectorisation easy */
#line 3299
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3299
    ni=Min(nelems-j,LOOPCNT);
#line 3299
    if (realign) {
#line 3299
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3299
      xp = tmp;
#line 3299
    } else {
#line 3299
      xp = (int *) *xpp;
#line 3299
    }
#line 3299
   /* copy the next block */
#line 3299
#pragma cdir loopcnt=LOOPCNT
#line 3299
#pragma cdir shortloop
#line 3299
    for (i=0; i<ni; i++) {
#line 3299
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3299
     /* test for range errors (not always needed but do it anyway) */
#line 3299
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3299
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3299
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3299
    }
#line 3299
   /* update xpp and tp */
#line 3299
    if (realign) xp = (int *) *xpp;
#line 3299
    xp += ni;
#line 3299
    tp += ni;
#line 3299
    *xpp = (void*)xp;
#line 3299
  }
#line 3299
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3299

#line 3299
#else   /* not SX */
#line 3299
	const char *xp = (const char *) *xpp;
#line 3299
	int status = NC_NOERR;
#line 3299

#line 3299
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3299
	{
#line 3299
		const int lstatus = ncx_get_int_longlong(xp, tp);
#line 3299
		if (status == NC_NOERR) /* report the first encountered error */
#line 3299
			status = lstatus;
#line 3299
	}
#line 3299

#line 3299
	*xpp = (const void *)xp;
#line 3299
	return status;
#line 3299
#endif
#line 3299
}
#line 3299

int
#line 3300
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3300
{
#line 3300
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3300

#line 3300
 /* basic algorithm is:
#line 3300
  *   - ensure sane alignment of input data
#line 3300
  *   - copy (conversion happens automatically) input data
#line 3300
  *     to output
#line 3300
  *   - update xpp to point at next unconverted input, and tp to point
#line 3300
  *     at next location for converted output
#line 3300
  */
#line 3300
  long i, j, ni;
#line 3300
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3300
  int *xp;
#line 3300
  int nrange = 0;         /* number of range errors */
#line 3300
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3300
  long cxp = (long) *((char**)xpp);
#line 3300

#line 3300
  realign = (cxp & 7) % SIZEOF_INT;
#line 3300
  /* sjl: manually stripmine so we can limit amount of
#line 3300
   * vector work space reserved to LOOPCNT elements. Also
#line 3300
   * makes vectorisation easy */
#line 3300
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3300
    ni=Min(nelems-j,LOOPCNT);
#line 3300
    if (realign) {
#line 3300
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3300
      xp = tmp;
#line 3300
    } else {
#line 3300
      xp = (int *) *xpp;
#line 3300
    }
#line 3300
   /* copy the next block */
#line 3300
#pragma cdir loopcnt=LOOPCNT
#line 3300
#pragma cdir shortloop
#line 3300
    for (i=0; i<ni; i++) {
#line 3300
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3300
     /* test for range errors (not always needed but do it anyway) */
#line 3300
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3300
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3300
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3300
    }
#line 3300
   /* update xpp and tp */
#line 3300
    if (realign) xp = (int *) *xpp;
#line 3300
    xp += ni;
#line 3300
    tp += ni;
#line 3300
    *xpp = (void*)xp;
#line 3300
  }
#line 3300
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3300

#line 3300
#else   /* not SX */
#line 3300
	const char *xp = (const char *) *xpp;
#line 3300
	int status = NC_NOERR;
#line 3300

#line 3300
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3300
	{
#line 3300
		const int lstatus = ncx_get_int_uchar(xp, tp);
#line 3300
		if (status == NC_NOERR) /* report the first encountered error */
#line 3300
			status = lstatus;
#line 3300
	}
#line 3300

#line 3300
	*xpp = (const void *)xp;
#line 3300
	return status;
#line 3300
#endif
#line 3300
}
#line 3300

int
#line 3301
ncx_getn_int_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3301
{
#line 3301
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3301

#line 3301
 /* basic algorithm is:
#line 3301
  *   - ensure sane alignment of input data
#line 3301
  *   - copy (conversion happens automatically) input data
#line 3301
  *     to output
#line 3301
  *   - update xpp to point at next unconverted input, and tp to point
#line 3301
  *     at next location for converted output
#line 3301
  */
#line 3301
  long i, j, ni;
#line 3301
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3301
  int *xp;
#line 3301
  int nrange = 0;         /* number of range errors */
#line 3301
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3301
  long cxp = (long) *((char**)xpp);
#line 3301

#line 3301
  realign = (cxp & 7) % SIZEOF_INT;
#line 3301
  /* sjl: manually stripmine so we can limit amount of
#line 3301
   * vector work space reserved to LOOPCNT elements. Also
#line 3301
   * makes vectorisation easy */
#line 3301
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3301
    ni=Min(nelems-j,LOOPCNT);
#line 3301
    if (realign) {
#line 3301
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3301
      xp = tmp;
#line 3301
    } else {
#line 3301
      xp = (int *) *xpp;
#line 3301
    }
#line 3301
   /* copy the next block */
#line 3301
#pragma cdir loopcnt=LOOPCNT
#line 3301
#pragma cdir shortloop
#line 3301
    for (i=0; i<ni; i++) {
#line 3301
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3301
     /* test for range errors (not always needed but do it anyway) */
#line 3301
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3301
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3301
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3301
    }
#line 3301
   /* update xpp and tp */
#line 3301
    if (realign) xp = (int *) *xpp;
#line 3301
    xp += ni;
#line 3301
    tp += ni;
#line 3301
    *xpp = (void*)xp;
#line 3301
  }
#line 3301
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3301

#line 3301
#else   /* not SX */
#line 3301
	const char *xp = (const char *) *xpp;
#line 3301
	int status = NC_NOERR;
#line 3301

#line 3301
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3301
	{
#line 3301
		const int lstatus = ncx_get_int_ushort(xp, tp);
#line 3301
		if (status == NC_NOERR) /* report the first encountered error */
#line 3301
			status = lstatus;
#line 3301
	}
#line 3301

#line 3301
	*xpp = (const void *)xp;
#line 3301
	return status;
#line 3301
#endif
#line 3301
}
#line 3301

int
#line 3302
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
#line 3302
{
#line 3302
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3302

#line 3302
 /* basic algorithm is:
#line 3302
  *   - ensure sane alignment of input data
#line 3302
  *   - copy (conversion happens automatically) input data
#line 3302
  *     to output
#line 3302
  *   - update xpp to point at next unconverted input, and tp to point
#line 3302
  *     at next location for converted output
#line 3302
  */
#line 3302
  long i, j, ni;
#line 3302
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3302
  int *xp;
#line 3302
  int nrange = 0;         /* number of range errors */
#line 3302
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3302
  long cxp = (long) *((char**)xpp);
#line 3302

#line 3302
  realign = (cxp & 7) % SIZEOF_INT;
#line 3302
  /* sjl: manually stripmine so we can limit amount of
#line 3302
   * vector work space reserved to LOOPCNT elements. Also
#line 3302
   * makes vectorisation easy */
#line 3302
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3302
    ni=Min(nelems-j,LOOPCNT);
#line 3302
    if (realign) {
#line 3302
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3302
      xp = tmp;
#line 3302
    } else {
#line 3302
      xp = (int *) *xpp;
#line 3302
    }
#line 3302
   /* copy the next block */
#line 3302
#pragma cdir loopcnt=LOOPCNT
#line 3302
#pragma cdir shortloop
#line 3302
    for (i=0; i<ni; i++) {
#line 3302
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3302
     /* test for range errors (not always needed but do it anyway) */
#line 3302
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3302
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3302
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3302
    }
#line 3302
   /* update xpp and tp */
#line 3302
    if (realign) xp = (int *) *xpp;
#line 3302
    xp += ni;
#line 3302
    tp += ni;
#line 3302
    *xpp = (void*)xp;
#line 3302
  }
#line 3302
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3302

#line 3302
#else   /* not SX */
#line 3302
	const char *xp = (const char *) *xpp;
#line 3302
	int status = NC_NOERR;
#line 3302

#line 3302
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3302
	{
#line 3302
		const int lstatus = ncx_get_int_uint(xp, tp);
#line 3302
		if (status == NC_NOERR) /* report the first encountered error */
#line 3302
			status = lstatus;
#line 3302
	}
#line 3302

#line 3302
	*xpp = (const void *)xp;
#line 3302
	return status;
#line 3302
#endif
#line 3302
}
#line 3302

int
#line 3303
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3303
{
#line 3303
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3303

#line 3303
 /* basic algorithm is:
#line 3303
  *   - ensure sane alignment of input data
#line 3303
  *   - copy (conversion happens automatically) input data
#line 3303
  *     to output
#line 3303
  *   - update xpp to point at next unconverted input, and tp to point
#line 3303
  *     at next location for converted output
#line 3303
  */
#line 3303
  long i, j, ni;
#line 3303
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3303
  int *xp;
#line 3303
  int nrange = 0;         /* number of range errors */
#line 3303
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3303
  long cxp = (long) *((char**)xpp);
#line 3303

#line 3303
  realign = (cxp & 7) % SIZEOF_INT;
#line 3303
  /* sjl: manually stripmine so we can limit amount of
#line 3303
   * vector work space reserved to LOOPCNT elements. Also
#line 3303
   * makes vectorisation easy */
#line 3303
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3303
    ni=Min(nelems-j,LOOPCNT);
#line 3303
    if (realign) {
#line 3303
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3303
      xp = tmp;
#line 3303
    } else {
#line 3303
      xp = (int *) *xpp;
#line 3303
    }
#line 3303
   /* copy the next block */
#line 3303
#pragma cdir loopcnt=LOOPCNT
#line 3303
#pragma cdir shortloop
#line 3303
    for (i=0; i<ni; i++) {
#line 3303
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3303
     /* test for range errors (not always needed but do it anyway) */
#line 3303
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3303
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3303
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3303
    }
#line 3303
   /* update xpp and tp */
#line 3303
    if (realign) xp = (int *) *xpp;
#line 3303
    xp += ni;
#line 3303
    tp += ni;
#line 3303
    *xpp = (void*)xp;
#line 3303
  }
#line 3303
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3303

#line 3303
#else   /* not SX */
#line 3303
	const char *xp = (const char *) *xpp;
#line 3303
	int status = NC_NOERR;
#line 3303

#line 3303
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3303
	{
#line 3303
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
#line 3303
		if (status == NC_NOERR) /* report the first encountered error */
#line 3303
			status = lstatus;
#line 3303
	}
#line 3303

#line 3303
	*xpp = (const void *)xp;
#line 3303
	return status;
#line 3303
#endif
#line 3303
}
#line 3303


#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3319
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3319
{
#line 3319
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3319

#line 3319
 /* basic algorithm is:
#line 3319
  *   - ensure sane alignment of output data
#line 3319
  *   - copy (conversion happens automatically) input data
#line 3319
  *     to output
#line 3319
  *   - update tp to point at next unconverted input, and xpp to point
#line 3319
  *     at next location for converted output
#line 3319
  */
#line 3319
  long i, j, ni;
#line 3319
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3319
  int *xp;
#line 3319
  int nrange = 0;         /* number of range errors */
#line 3319
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3319
  long cxp = (long) *((char**)xpp);
#line 3319

#line 3319
  realign = (cxp & 7) % SIZEOF_INT;
#line 3319
  /* sjl: manually stripmine so we can limit amount of
#line 3319
   * vector work space reserved to LOOPCNT elements. Also
#line 3319
   * makes vectorisation easy */
#line 3319
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3319
    ni=Min(nelems-j,LOOPCNT);
#line 3319
    if (realign) {
#line 3319
      xp = tmp;
#line 3319
    } else {
#line 3319
      xp = (int *) *xpp;
#line 3319
    }
#line 3319
   /* copy the next block */
#line 3319
#pragma cdir loopcnt=LOOPCNT
#line 3319
#pragma cdir shortloop
#line 3319
    for (i=0; i<ni; i++) {
#line 3319
      /* the normal case: */
#line 3319
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3319
     /* test for range errors (not always needed but do it anyway) */
#line 3319
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3319
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3319
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3319
    }
#line 3319
   /* copy workspace back if necessary */
#line 3319
    if (realign) {
#line 3319
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3319
      xp = (int *) *xpp;
#line 3319
    }
#line 3319
   /* update xpp and tp */
#line 3319
    xp += ni;
#line 3319
    tp += ni;
#line 3319
    *xpp = (void*)xp;
#line 3319
  }
#line 3319
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3319

#line 3319
#else   /* not SX */
#line 3319

#line 3319
	char *xp = (char *) *xpp;
#line 3319
	int status = NC_NOERR;
#line 3319

#line 3319
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3319
	{
#line 3319
		int lstatus = ncx_put_int_int(xp, tp, fillp);
#line 3319
		if (status == NC_NOERR) /* report the first encountered error */
#line 3319
			status = lstatus;
#line 3319
	}
#line 3319

#line 3319
	*xpp = (void *)xp;
#line 3319
	return status;
#line 3319
#endif
#line 3319
}
#line 3319

#endif
int
#line 3321
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3321
{
#line 3321
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3321

#line 3321
 /* basic algorithm is:
#line 3321
  *   - ensure sane alignment of output data
#line 3321
  *   - copy (conversion happens automatically) input data
#line 3321
  *     to output
#line 3321
  *   - update tp to point at next unconverted input, and xpp to point
#line 3321
  *     at next location for converted output
#line 3321
  */
#line 3321
  long i, j, ni;
#line 3321
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3321
  int *xp;
#line 3321
  int nrange = 0;         /* number of range errors */
#line 3321
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3321
  long cxp = (long) *((char**)xpp);
#line 3321

#line 3321
  realign = (cxp & 7) % SIZEOF_INT;
#line 3321
  /* sjl: manually stripmine so we can limit amount of
#line 3321
   * vector work space reserved to LOOPCNT elements. Also
#line 3321
   * makes vectorisation easy */
#line 3321
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3321
    ni=Min(nelems-j,LOOPCNT);
#line 3321
    if (realign) {
#line 3321
      xp = tmp;
#line 3321
    } else {
#line 3321
      xp = (int *) *xpp;
#line 3321
    }
#line 3321
   /* copy the next block */
#line 3321
#pragma cdir loopcnt=LOOPCNT
#line 3321
#pragma cdir shortloop
#line 3321
    for (i=0; i<ni; i++) {
#line 3321
      /* the normal case: */
#line 3321
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3321
     /* test for range errors (not always needed but do it anyway) */
#line 3321
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3321
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3321
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3321
    }
#line 3321
   /* copy workspace back if necessary */
#line 3321
    if (realign) {
#line 3321
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3321
      xp = (int *) *xpp;
#line 3321
    }
#line 3321
   /* update xpp and tp */
#line 3321
    xp += ni;
#line 3321
    tp += ni;
#line 3321
    *xpp = (void*)xp;
#line 3321
  }
#line 3321
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3321

#line 3321
#else   /* not SX */
#line 3321

#line 3321
	char *xp = (char *) *xpp;
#line 3321
	int status = NC_NOERR;
#line 3321

#line 3321
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3321
	{
#line 3321
		int lstatus = ncx_put_int_schar(xp, tp, fillp);
#line 3321
		if (status == NC_NOERR) /* report the first encountered error */
#line 3321
			status = lstatus;
#line 3321
	}
#line 3321

#line 3321
	*xpp = (void *)xp;
#line 3321
	return status;
#line 3321
#endif
#line 3321
}
#line 3321

int
#line 3322
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3322
{
#line 3322
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3322

#line 3322
 /* basic algorithm is:
#line 3322
  *   - ensure sane alignment of output data
#line 3322
  *   - copy (conversion happens automatically) input data
#line 3322
  *     to output
#line 3322
  *   - update tp to point at next unconverted input, and xpp to point
#line 3322
  *     at next location for converted output
#line 3322
  */
#line 3322
  long i, j, ni;
#line 3322
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3322
  int *xp;
#line 3322
  int nrange = 0;         /* number of range errors */
#line 3322
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3322
  long cxp = (long) *((char**)xpp);
#line 3322

#line 3322
  realign = (cxp & 7) % SIZEOF_INT;
#line 3322
  /* sjl: manually stripmine so we can limit amount of
#line 3322
   * vector work space reserved to LOOPCNT elements. Also
#line 3322
   * makes vectorisation easy */
#line 3322
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3322
    ni=Min(nelems-j,LOOPCNT);
#line 3322
    if (realign) {
#line 3322
      xp = tmp;
#line 3322
    } else {
#line 3322
      xp = (int *) *xpp;
#line 3322
    }
#line 3322
   /* copy the next block */
#line 3322
#pragma cdir loopcnt=LOOPCNT
#line 3322
#pragma cdir shortloop
#line 3322
    for (i=0; i<ni; i++) {
#line 3322
      /* the normal case: */
#line 3322
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3322
     /* test for range errors (not always needed but do it anyway) */
#line 3322
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3322
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3322
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3322
    }
#line 3322
   /* copy workspace back if necessary */
#line 3322
    if (realign) {
#line 3322
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3322
      xp = (int *) *xpp;
#line 3322
    }
#line 3322
   /* update xpp and tp */
#line 3322
    xp += ni;
#line 3322
    tp += ni;
#line 3322
    *xpp = (void*)xp;
#line 3322
  }
#line 3322
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3322

#line 3322
#else   /* not SX */
#line 3322

#line 3322
	char *xp = (char *) *xpp;
#line 3322
	int status = NC_NOERR;
#line 3322

#line 3322
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3322
	{
#line 3322
		int lstatus = ncx_put_int_short(xp, tp, fillp);
#line 3322
		if (status == NC_NOERR) /* report the first encountered error */
#line 3322
			status = lstatus;
#line 3322
	}
#line 3322

#line 3322
	*xpp = (void *)xp;
#line 3322
	return status;
#line 3322
#endif
#line 3322
}
#line 3322

int
#line 3323
ncx_putn_int_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3323
{
#line 3323
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3323

#line 3323
 /* basic algorithm is:
#line 3323
  *   - ensure sane alignment of output data
#line 3323
  *   - copy (conversion happens automatically) input data
#line 3323
  *     to output
#line 3323
  *   - update tp to point at next unconverted input, and xpp to point
#line 3323
  *     at next location for converted output
#line 3323
  */
#line 3323
  long i, j, ni;
#line 3323
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3323
  int *xp;
#line 3323
  int nrange = 0;         /* number of range errors */
#line 3323
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3323
  long cxp = (long) *((char**)xpp);
#line 3323

#line 3323
  realign = (cxp & 7) % SIZEOF_INT;
#line 3323
  /* sjl: manually stripmine so we can limit amount of
#line 3323
   * vector work space reserved to LOOPCNT elements. Also
#line 3323
   * makes vectorisation easy */
#line 3323
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3323
    ni=Min(nelems-j,LOOPCNT);
#line 3323
    if (realign) {
#line 3323
      xp = tmp;
#line 3323
    } else {
#line 3323
      xp = (int *) *xpp;
#line 3323
    }
#line 3323
   /* copy the next block */
#line 3323
#pragma cdir loopcnt=LOOPCNT
#line 3323
#pragma cdir shortloop
#line 3323
    for (i=0; i<ni; i++) {
#line 3323
      /* the normal case: */
#line 3323
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3323
     /* test for range errors (not always needed but do it anyway) */
#line 3323
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3323
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3323
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3323
    }
#line 3323
   /* copy workspace back if necessary */
#line 3323
    if (realign) {
#line 3323
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3323
      xp = (int *) *xpp;
#line 3323
    }
#line 3323
   /* update xpp and tp */
#line 3323
    xp += ni;
#line 3323
    tp += ni;
#line 3323
    *xpp = (void*)xp;
#line 3323
  }
#line 3323
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3323

#line 3323
#else   /* not SX */
#line 3323

#line 3323
	char *xp = (char *) *xpp;
#line 3323
	int status = NC_NOERR;
#line 3323

#line 3323
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3323
	{
#line 3323
		int lstatus = ncx_put_int_long(xp, tp, fillp);
#line 3323
		if (status == NC_NOERR) /* report the first encountered error */
#line 3323
			status = lstatus;
#line 3323
	}
#line 3323

#line 3323
	*xpp = (void *)xp;
#line 3323
	return status;
#line 3323
#endif
#line 3323
}
#line 3323

int
#line 3324
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3324
{
#line 3324
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3324

#line 3324
 /* basic algorithm is:
#line 3324
  *   - ensure sane alignment of output data
#line 3324
  *   - copy (conversion happens automatically) input data
#line 3324
  *     to output
#line 3324
  *   - update tp to point at next unconverted input, and xpp to point
#line 3324
  *     at next location for converted output
#line 3324
  */
#line 3324
  long i, j, ni;
#line 3324
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3324
  int *xp;
#line 3324
  double d;               /* special case for ncx_putn_int_float */
#line 3324
  int nrange = 0;         /* number of range errors */
#line 3324
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3324
  long cxp = (long) *((char**)xpp);
#line 3324

#line 3324
  realign = (cxp & 7) % SIZEOF_INT;
#line 3324
  /* sjl: manually stripmine so we can limit amount of
#line 3324
   * vector work space reserved to LOOPCNT elements. Also
#line 3324
   * makes vectorisation easy */
#line 3324
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3324
    ni=Min(nelems-j,LOOPCNT);
#line 3324
    if (realign) {
#line 3324
      xp = tmp;
#line 3324
    } else {
#line 3324
      xp = (int *) *xpp;
#line 3324
    }
#line 3324
   /* copy the next block */
#line 3324
#pragma cdir loopcnt=LOOPCNT
#line 3324
#pragma cdir shortloop
#line 3324
    for (i=0; i<ni; i++) {
#line 3324
      /* for some reason int to float, for putn, requires a special case */
#line 3324
      d = tp[i];
#line 3324
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
#line 3324
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3324
    }
#line 3324
   /* copy workspace back if necessary */
#line 3324
    if (realign) {
#line 3324
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3324
      xp = (int *) *xpp;
#line 3324
    }
#line 3324
   /* update xpp and tp */
#line 3324
    xp += ni;
#line 3324
    tp += ni;
#line 3324
    *xpp = (void*)xp;
#line 3324
  }
#line 3324
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3324

#line 3324
#else   /* not SX */
#line 3324

#line 3324
	char *xp = (char *) *xpp;
#line 3324
	int status = NC_NOERR;
#line 3324

#line 3324
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3324
	{
#line 3324
		int lstatus = ncx_put_int_float(xp, tp, fillp);
#line 3324
		if (status == NC_NOERR) /* report the first encountered error */
#line 3324
			status = lstatus;
#line 3324
	}
#line 3324

#line 3324
	*xpp = (void *)xp;
#line 3324
	return status;
#line 3324
#endif
#line 3324
}
#line 3324

int
#line 3325
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3325
{
#line 3325
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3325

#line 3325
 /* basic algorithm is:
#line 3325
  *   - ensure sane alignment of output data
#line 3325
  *   - copy (conversion happens automatically) input data
#line 3325
  *     to output
#line 3325
  *   - update tp to point at next unconverted input, and xpp to point
#line 3325
  *     at next location for converted output
#line 3325
  */
#line 3325
  long i, j, ni;
#line 3325
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3325
  int *xp;
#line 3325
  int nrange = 0;         /* number of range errors */
#line 3325
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3325
  long cxp = (long) *((char**)xpp);
#line 3325

#line 3325
  realign = (cxp & 7) % SIZEOF_INT;
#line 3325
  /* sjl: manually stripmine so we can limit amount of
#line 3325
   * vector work space reserved to LOOPCNT elements. Also
#line 3325
   * makes vectorisation easy */
#line 3325
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3325
    ni=Min(nelems-j,LOOPCNT);
#line 3325
    if (realign) {
#line 3325
      xp = tmp;
#line 3325
    } else {
#line 3325
      xp = (int *) *xpp;
#line 3325
    }
#line 3325
   /* copy the next block */
#line 3325
#pragma cdir loopcnt=LOOPCNT
#line 3325
#pragma cdir shortloop
#line 3325
    for (i=0; i<ni; i++) {
#line 3325
      /* the normal case: */
#line 3325
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3325
     /* test for range errors (not always needed but do it anyway) */
#line 3325
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3325
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3325
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3325
    }
#line 3325
   /* copy workspace back if necessary */
#line 3325
    if (realign) {
#line 3325
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3325
      xp = (int *) *xpp;
#line 3325
    }
#line 3325
   /* update xpp and tp */
#line 3325
    xp += ni;
#line 3325
    tp += ni;
#line 3325
    *xpp = (void*)xp;
#line 3325
  }
#line 3325
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3325

#line 3325
#else   /* not SX */
#line 3325

#line 3325
	char *xp = (char *) *xpp;
#line 3325
	int status = NC_NOERR;
#line 3325

#line 3325
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3325
	{
#line 3325
		int lstatus = ncx_put_int_double(xp, tp, fillp);
#line 3325
		if (status == NC_NOERR) /* report the first encountered error */
#line 3325
			status = lstatus;
#line 3325
	}
#line 3325

#line 3325
	*xpp = (void *)xp;
#line 3325
	return status;
#line 3325
#endif
#line 3325
}
#line 3325

int
#line 3326
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3326
{
#line 3326
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3326

#line 3326
 /* basic algorithm is:
#line 3326
  *   - ensure sane alignment of output data
#line 3326
  *   - copy (conversion happens automatically) input data
#line 3326
  *     to output
#line 3326
  *   - update tp to point at next unconverted input, and xpp to point
#line 3326
  *     at next location for converted output
#line 3326
  */
#line 3326
  long i, j, ni;
#line 3326
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3326
  int *xp;
#line 3326
  int nrange = 0;         /* number of range errors */
#line 3326
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3326
  long cxp = (long) *((char**)xpp);
#line 3326

#line 3326
  realign = (cxp & 7) % SIZEOF_INT;
#line 3326
  /* sjl: manually stripmine so we can limit amount of
#line 3326
   * vector work space reserved to LOOPCNT elements. Also
#line 3326
   * makes vectorisation easy */
#line 3326
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3326
    ni=Min(nelems-j,LOOPCNT);
#line 3326
    if (realign) {
#line 3326
      xp = tmp;
#line 3326
    } else {
#line 3326
      xp = (int *) *xpp;
#line 3326
    }
#line 3326
   /* copy the next block */
#line 3326
#pragma cdir loopcnt=LOOPCNT
#line 3326
#pragma cdir shortloop
#line 3326
    for (i=0; i<ni; i++) {
#line 3326
      /* the normal case: */
#line 3326
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3326
     /* test for range errors (not always needed but do it anyway) */
#line 3326
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3326
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3326
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3326
    }
#line 3326
   /* copy workspace back if necessary */
#line 3326
    if (realign) {
#line 3326
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3326
      xp = (int *) *xpp;
#line 3326
    }
#line 3326
   /* update xpp and tp */
#line 3326
    xp += ni;
#line 3326
    tp += ni;
#line 3326
    *xpp = (void*)xp;
#line 3326
  }
#line 3326
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3326

#line 3326
#else   /* not SX */
#line 3326

#line 3326
	char *xp = (char *) *xpp;
#line 3326
	int status = NC_NOERR;
#line 3326

#line 3326
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3326
	{
#line 3326
		int lstatus = ncx_put_int_longlong(xp, tp, fillp);
#line 3326
		if (status == NC_NOERR) /* report the first encountered error */
#line 3326
			status = lstatus;
#line 3326
	}
#line 3326

#line 3326
	*xpp = (void *)xp;
#line 3326
	return status;
#line 3326
#endif
#line 3326
}
#line 3326

int
#line 3327
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3327
{
#line 3327
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3327

#line 3327
 /* basic algorithm is:
#line 3327
  *   - ensure sane alignment of output data
#line 3327
  *   - copy (conversion happens automatically) input data
#line 3327
  *     to output
#line 3327
  *   - update tp to point at next unconverted input, and xpp to point
#line 3327
  *     at next location for converted output
#line 3327
  */
#line 3327
  long i, j, ni;
#line 3327
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3327
  int *xp;
#line 3327
  int nrange = 0;         /* number of range errors */
#line 3327
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3327
  long cxp = (long) *((char**)xpp);
#line 3327

#line 3327
  realign = (cxp & 7) % SIZEOF_INT;
#line 3327
  /* sjl: manually stripmine so we can limit amount of
#line 3327
   * vector work space reserved to LOOPCNT elements. Also
#line 3327
   * makes vectorisation easy */
#line 3327
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3327
    ni=Min(nelems-j,LOOPCNT);
#line 3327
    if (realign) {
#line 3327
      xp = tmp;
#line 3327
    } else {
#line 3327
      xp = (int *) *xpp;
#line 3327
    }
#line 3327
   /* copy the next block */
#line 3327
#pragma cdir loopcnt=LOOPCNT
#line 3327
#pragma cdir shortloop
#line 3327
    for (i=0; i<ni; i++) {
#line 3327
      /* the normal case: */
#line 3327
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3327
     /* test for range errors (not always needed but do it anyway) */
#line 3327
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3327
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3327
      nrange += tp[i] > X_INT_MAX ;
#line 3327
    }
#line 3327
   /* copy workspace back if necessary */
#line 3327
    if (realign) {
#line 3327
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3327
      xp = (int *) *xpp;
#line 3327
    }
#line 3327
   /* update xpp and tp */
#line 3327
    xp += ni;
#line 3327
    tp += ni;
#line 3327
    *xpp = (void*)xp;
#line 3327
  }
#line 3327
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3327

#line 3327
#else   /* not SX */
#line 3327

#line 3327
	char *xp = (char *) *xpp;
#line 3327
	int status = NC_NOERR;
#line 3327

#line 3327
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3327
	{
#line 3327
		int lstatus = ncx_put_int_uchar(xp, tp, fillp);
#line 3327
		if (status == NC_NOERR) /* report the first encountered error */
#line 3327
			status = lstatus;
#line 3327
	}
#line 3327

#line 3327
	*xpp = (void *)xp;
#line 3327
	return status;
#line 3327
#endif
#line 3327
}
#line 3327

int
#line 3328
ncx_putn_int_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3328
{
#line 3328
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3328

#line 3328
 /* basic algorithm is:
#line 3328
  *   - ensure sane alignment of output data
#line 3328
  *   - copy (conversion happens automatically) input data
#line 3328
  *     to output
#line 3328
  *   - update tp to point at next unconverted input, and xpp to point
#line 3328
  *     at next location for converted output
#line 3328
  */
#line 3328
  long i, j, ni;
#line 3328
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3328
  int *xp;
#line 3328
  int nrange = 0;         /* number of range errors */
#line 3328
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3328
  long cxp = (long) *((char**)xpp);
#line 3328

#line 3328
  realign = (cxp & 7) % SIZEOF_INT;
#line 3328
  /* sjl: manually stripmine so we can limit amount of
#line 3328
   * vector work space reserved to LOOPCNT elements. Also
#line 3328
   * makes vectorisation easy */
#line 3328
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3328
    ni=Min(nelems-j,LOOPCNT);
#line 3328
    if (realign) {
#line 3328
      xp = tmp;
#line 3328
    } else {
#line 3328
      xp = (int *) *xpp;
#line 3328
    }
#line 3328
   /* copy the next block */
#line 3328
#pragma cdir loopcnt=LOOPCNT
#line 3328
#pragma cdir shortloop
#line 3328
    for (i=0; i<ni; i++) {
#line 3328
      /* the normal case: */
#line 3328
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3328
     /* test for range errors (not always needed but do it anyway) */
#line 3328
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3328
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3328
      nrange += tp[i] > X_INT_MAX ;
#line 3328
    }
#line 3328
   /* copy workspace back if necessary */
#line 3328
    if (realign) {
#line 3328
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3328
      xp = (int *) *xpp;
#line 3328
    }
#line 3328
   /* update xpp and tp */
#line 3328
    xp += ni;
#line 3328
    tp += ni;
#line 3328
    *xpp = (void*)xp;
#line 3328
  }
#line 3328
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3328

#line 3328
#else   /* not SX */
#line 3328

#line 3328
	char *xp = (char *) *xpp;
#line 3328
	int status = NC_NOERR;
#line 3328

#line 3328
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3328
	{
#line 3328
		int lstatus = ncx_put_int_ushort(xp, tp, fillp);
#line 3328
		if (status == NC_NOERR) /* report the first encountered error */
#line 3328
			status = lstatus;
#line 3328
	}
#line 3328

#line 3328
	*xpp = (void *)xp;
#line 3328
	return status;
#line 3328
#endif
#line 3328
}
#line 3328

int
#line 3329
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3329
{
#line 3329
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3329

#line 3329
 /* basic algorithm is:
#line 3329
  *   - ensure sane alignment of output data
#line 3329
  *   - copy (conversion happens automatically) input data
#line 3329
  *     to output
#line 3329
  *   - update tp to point at next unconverted input, and xpp to point
#line 3329
  *     at next location for converted output
#line 3329
  */
#line 3329
  long i, j, ni;
#line 3329
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3329
  int *xp;
#line 3329
  int nrange = 0;         /* number of range errors */
#line 3329
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3329
  long cxp = (long) *((char**)xpp);
#line 3329

#line 3329
  realign = (cxp & 7) % SIZEOF_INT;
#line 3329
  /* sjl: manually stripmine so we can limit amount of
#line 3329
   * vector work space reserved to LOOPCNT elements. Also
#line 3329
   * makes vectorisation easy */
#line 3329
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3329
    ni=Min(nelems-j,LOOPCNT);
#line 3329
    if (realign) {
#line 3329
      xp = tmp;
#line 3329
    } else {
#line 3329
      xp = (int *) *xpp;
#line 3329
    }
#line 3329
   /* copy the next block */
#line 3329
#pragma cdir loopcnt=LOOPCNT
#line 3329
#pragma cdir shortloop
#line 3329
    for (i=0; i<ni; i++) {
#line 3329
      /* the normal case: */
#line 3329
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3329
     /* test for range errors (not always needed but do it anyway) */
#line 3329
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3329
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3329
      nrange += tp[i] > X_INT_MAX ;
#line 3329
    }
#line 3329
   /* copy workspace back if necessary */
#line 3329
    if (realign) {
#line 3329
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3329
      xp = (int *) *xpp;
#line 3329
    }
#line 3329
   /* update xpp and tp */
#line 3329
    xp += ni;
#line 3329
    tp += ni;
#line 3329
    *xpp = (void*)xp;
#line 3329
  }
#line 3329
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3329

#line 3329
#else   /* not SX */
#line 3329

#line 3329
	char *xp = (char *) *xpp;
#line 3329
	int status = NC_NOERR;
#line 3329

#line 3329
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3329
	{
#line 3329
		int lstatus = ncx_put_int_uint(xp, tp, fillp);
#line 3329
		if (status == NC_NOERR) /* report the first encountered error */
#line 3329
			status = lstatus;
#line 3329
	}
#line 3329

#line 3329
	*xpp = (void *)xp;
#line 3329
	return status;
#line 3329
#endif
#line 3329
}
#line 3329

int
#line 3330
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3330
{
#line 3330
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3330

#line 3330
 /* basic algorithm is:
#line 3330
  *   - ensure sane alignment of output data
#line 3330
  *   - copy (conversion happens automatically) input data
#line 3330
  *     to output
#line 3330
  *   - update tp to point at next unconverted input, and xpp to point
#line 3330
  *     at next location for converted output
#line 3330
  */
#line 3330
  long i, j, ni;
#line 3330
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3330
  int *xp;
#line 3330
  int nrange = 0;         /* number of range errors */
#line 3330
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3330
  long cxp = (long) *((char**)xpp);
#line 3330

#line 3330
  realign = (cxp & 7) % SIZEOF_INT;
#line 3330
  /* sjl: manually stripmine so we can limit amount of
#line 3330
   * vector work space reserved to LOOPCNT elements. Also
#line 3330
   * makes vectorisation easy */
#line 3330
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3330
    ni=Min(nelems-j,LOOPCNT);
#line 3330
    if (realign) {
#line 3330
      xp = tmp;
#line 3330
    } else {
#line 3330
      xp = (int *) *xpp;
#line 3330
    }
#line 3330
   /* copy the next block */
#line 3330
#pragma cdir loopcnt=LOOPCNT
#line 3330
#pragma cdir shortloop
#line 3330
    for (i=0; i<ni; i++) {
#line 3330
      /* the normal case: */
#line 3330
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3330
     /* test for range errors (not always needed but do it anyway) */
#line 3330
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3330
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3330
      nrange += tp[i] > X_INT_MAX ;
#line 3330
    }
#line 3330
   /* copy workspace back if necessary */
#line 3330
    if (realign) {
#line 3330
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3330
      xp = (int *) *xpp;
#line 3330
    }
#line 3330
   /* update xpp and tp */
#line 3330
    xp += ni;
#line 3330
    tp += ni;
#line 3330
    *xpp = (void*)xp;
#line 3330
  }
#line 3330
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3330

#line 3330
#else   /* not SX */
#line 3330

#line 3330
	char *xp = (char *) *xpp;
#line 3330
	int status = NC_NOERR;
#line 3330

#line 3330
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3330
	{
#line 3330
		int lstatus = ncx_put_int_ulonglong(xp, tp, fillp);
#line 3330
		if (status == NC_NOERR) /* report the first encountered error */
#line 3330
			status = lstatus;
#line 3330
	}
#line 3330

#line 3330
	*xpp = (void *)xp;
#line 3330
	return status;
#line 3330
#endif
#line 3330
}
#line 3330


/* uint ----------------------------------------------------------------------*/

#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UINT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3348
ncx_getn_uint_uint(const void **xpp, size_t nelems, uint *tp)
#line 3348
{
#line 3348
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3348

#line 3348
 /* basic algorithm is:
#line 3348
  *   - ensure sane alignment of input data
#line 3348
  *   - copy (conversion happens automatically) input data
#line 3348
  *     to output
#line 3348
  *   - update xpp to point at next unconverted input, and tp to point
#line 3348
  *     at next location for converted output
#line 3348
  */
#line 3348
  long i, j, ni;
#line 3348
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3348
  uint *xp;
#line 3348
  int nrange = 0;         /* number of range errors */
#line 3348
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3348
  long cxp = (long) *((char**)xpp);
#line 3348

#line 3348
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3348
  /* sjl: manually stripmine so we can limit amount of
#line 3348
   * vector work space reserved to LOOPCNT elements. Also
#line 3348
   * makes vectorisation easy */
#line 3348
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3348
    ni=Min(nelems-j,LOOPCNT);
#line 3348
    if (realign) {
#line 3348
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3348
      xp = tmp;
#line 3348
    } else {
#line 3348
      xp = (uint *) *xpp;
#line 3348
    }
#line 3348
   /* copy the next block */
#line 3348
#pragma cdir loopcnt=LOOPCNT
#line 3348
#pragma cdir shortloop
#line 3348
    for (i=0; i<ni; i++) {
#line 3348
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3348
     /* test for range errors (not always needed but do it anyway) */
#line 3348
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3348
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3348
      nrange += xp[i] > UINT_MAX ;
#line 3348
    }
#line 3348
   /* update xpp and tp */
#line 3348
    if (realign) xp = (uint *) *xpp;
#line 3348
    xp += ni;
#line 3348
    tp += ni;
#line 3348
    *xpp = (void*)xp;
#line 3348
  }
#line 3348
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3348

#line 3348
#else   /* not SX */
#line 3348
	const char *xp = (const char *) *xpp;
#line 3348
	int status = NC_NOERR;
#line 3348

#line 3348
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3348
	{
#line 3348
		const int lstatus = ncx_get_uint_uint(xp, tp);
#line 3348
		if (status == NC_NOERR) /* report the first encountered error */
#line 3348
			status = lstatus;
#line 3348
	}
#line 3348

#line 3348
	*xpp = (const void *)xp;
#line 3348
	return status;
#line 3348
#endif
#line 3348
}
#line 3348

#endif
int
#line 3350
ncx_getn_uint_schar(const void **xpp, size_t nelems, schar *tp)
#line 3350
{
#line 3350
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3350

#line 3350
 /* basic algorithm is:
#line 3350
  *   - ensure sane alignment of input data
#line 3350
  *   - copy (conversion happens automatically) input data
#line 3350
  *     to output
#line 3350
  *   - update xpp to point at next unconverted input, and tp to point
#line 3350
  *     at next location for converted output
#line 3350
  */
#line 3350
  long i, j, ni;
#line 3350
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3350
  uint *xp;
#line 3350
  int nrange = 0;         /* number of range errors */
#line 3350
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3350
  long cxp = (long) *((char**)xpp);
#line 3350

#line 3350
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3350
  /* sjl: manually stripmine so we can limit amount of
#line 3350
   * vector work space reserved to LOOPCNT elements. Also
#line 3350
   * makes vectorisation easy */
#line 3350
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3350
    ni=Min(nelems-j,LOOPCNT);
#line 3350
    if (realign) {
#line 3350
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3350
      xp = tmp;
#line 3350
    } else {
#line 3350
      xp = (uint *) *xpp;
#line 3350
    }
#line 3350
   /* copy the next block */
#line 3350
#pragma cdir loopcnt=LOOPCNT
#line 3350
#pragma cdir shortloop
#line 3350
    for (i=0; i<ni; i++) {
#line 3350
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3350
     /* test for range errors (not always needed but do it anyway) */
#line 3350
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3350
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3350
      nrange += xp[i] > SCHAR_MAX ;
#line 3350
    }
#line 3350
   /* update xpp and tp */
#line 3350
    if (realign) xp = (uint *) *xpp;
#line 3350
    xp += ni;
#line 3350
    tp += ni;
#line 3350
    *xpp = (void*)xp;
#line 3350
  }
#line 3350
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3350

#line 3350
#else   /* not SX */
#line 3350
	const char *xp = (const char *) *xpp;
#line 3350
	int status = NC_NOERR;
#line 3350

#line 3350
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3350
	{
#line 3350
		const int lstatus = ncx_get_uint_schar(xp, tp);
#line 3350
		if (status == NC_NOERR) /* report the first encountered error */
#line 3350
			status = lstatus;
#line 3350
	}
#line 3350

#line 3350
	*xpp = (const void *)xp;
#line 3350
	return status;
#line 3350
#endif
#line 3350
}
#line 3350

int
#line 3351
ncx_getn_uint_short(const void **xpp, size_t nelems, short *tp)
#line 3351
{
#line 3351
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3351

#line 3351
 /* basic algorithm is:
#line 3351
  *   - ensure sane alignment of input data
#line 3351
  *   - copy (conversion happens automatically) input data
#line 3351
  *     to output
#line 3351
  *   - update xpp to point at next unconverted input, and tp to point
#line 3351
  *     at next location for converted output
#line 3351
  */
#line 3351
  long i, j, ni;
#line 3351
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3351
  uint *xp;
#line 3351
  int nrange = 0;         /* number of range errors */
#line 3351
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3351
  long cxp = (long) *((char**)xpp);
#line 3351

#line 3351
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3351
  /* sjl: manually stripmine so we can limit amount of
#line 3351
   * vector work space reserved to LOOPCNT elements. Also
#line 3351
   * makes vectorisation easy */
#line 3351
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3351
    ni=Min(nelems-j,LOOPCNT);
#line 3351
    if (realign) {
#line 3351
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3351
      xp = tmp;
#line 3351
    } else {
#line 3351
      xp = (uint *) *xpp;
#line 3351
    }
#line 3351
   /* copy the next block */
#line 3351
#pragma cdir loopcnt=LOOPCNT
#line 3351
#pragma cdir shortloop
#line 3351
    for (i=0; i<ni; i++) {
#line 3351
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3351
     /* test for range errors (not always needed but do it anyway) */
#line 3351
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3351
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3351
      nrange += xp[i] > SHORT_MAX ;
#line 3351
    }
#line 3351
   /* update xpp and tp */
#line 3351
    if (realign) xp = (uint *) *xpp;
#line 3351
    xp += ni;
#line 3351
    tp += ni;
#line 3351
    *xpp = (void*)xp;
#line 3351
  }
#line 3351
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3351

#line 3351
#else   /* not SX */
#line 3351
	const char *xp = (const char *) *xpp;
#line 3351
	int status = NC_NOERR;
#line 3351

#line 3351
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3351
	{
#line 3351
		const int lstatus = ncx_get_uint_short(xp, tp);
#line 3351
		if (status == NC_NOERR) /* report the first encountered error */
#line 3351
			status = lstatus;
#line 3351
	}
#line 3351

#line 3351
	*xpp = (const void *)xp;
#line 3351
	return status;
#line 3351
#endif
#line 3351
}
#line 3351

int
#line 3352
ncx_getn_uint_int(const void **xpp, size_t nelems, int *tp)
#line 3352
{
#line 3352
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3352

#line 3352
 /* basic algorithm is:
#line 3352
  *   - ensure sane alignment of input data
#line 3352
  *   - copy (conversion happens automatically) input data
#line 3352
  *     to output
#line 3352
  *   - update xpp to point at next unconverted input, and tp to point
#line 3352
  *     at next location for converted output
#line 3352
  */
#line 3352
  long i, j, ni;
#line 3352
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3352
  uint *xp;
#line 3352
  int nrange = 0;         /* number of range errors */
#line 3352
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3352
  long cxp = (long) *((char**)xpp);
#line 3352

#line 3352
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3352
  /* sjl: manually stripmine so we can limit amount of
#line 3352
   * vector work space reserved to LOOPCNT elements. Also
#line 3352
   * makes vectorisation easy */
#line 3352
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3352
    ni=Min(nelems-j,LOOPCNT);
#line 3352
    if (realign) {
#line 3352
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3352
      xp = tmp;
#line 3352
    } else {
#line 3352
      xp = (uint *) *xpp;
#line 3352
    }
#line 3352
   /* copy the next block */
#line 3352
#pragma cdir loopcnt=LOOPCNT
#line 3352
#pragma cdir shortloop
#line 3352
    for (i=0; i<ni; i++) {
#line 3352
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3352
     /* test for range errors (not always needed but do it anyway) */
#line 3352
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3352
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3352
      nrange += xp[i] > INT_MAX ;
#line 3352
    }
#line 3352
   /* update xpp and tp */
#line 3352
    if (realign) xp = (uint *) *xpp;
#line 3352
    xp += ni;
#line 3352
    tp += ni;
#line 3352
    *xpp = (void*)xp;
#line 3352
  }
#line 3352
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3352

#line 3352
#else   /* not SX */
#line 3352
	const char *xp = (const char *) *xpp;
#line 3352
	int status = NC_NOERR;
#line 3352

#line 3352
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3352
	{
#line 3352
		const int lstatus = ncx_get_uint_int(xp, tp);
#line 3352
		if (status == NC_NOERR) /* report the first encountered error */
#line 3352
			status = lstatus;
#line 3352
	}
#line 3352

#line 3352
	*xpp = (const void *)xp;
#line 3352
	return status;
#line 3352
#endif
#line 3352
}
#line 3352

int
#line 3353
ncx_getn_uint_long(const void **xpp, size_t nelems, long *tp)
#line 3353
{
#line 3353
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3353

#line 3353
 /* basic algorithm is:
#line 3353
  *   - ensure sane alignment of input data
#line 3353
  *   - copy (conversion happens automatically) input data
#line 3353
  *     to output
#line 3353
  *   - update xpp to point at next unconverted input, and tp to point
#line 3353
  *     at next location for converted output
#line 3353
  */
#line 3353
  long i, j, ni;
#line 3353
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3353
  uint *xp;
#line 3353
  int nrange = 0;         /* number of range errors */
#line 3353
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3353
  long cxp = (long) *((char**)xpp);
#line 3353

#line 3353
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3353
  /* sjl: manually stripmine so we can limit amount of
#line 3353
   * vector work space reserved to LOOPCNT elements. Also
#line 3353
   * makes vectorisation easy */
#line 3353
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3353
    ni=Min(nelems-j,LOOPCNT);
#line 3353
    if (realign) {
#line 3353
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3353
      xp = tmp;
#line 3353
    } else {
#line 3353
      xp = (uint *) *xpp;
#line 3353
    }
#line 3353
   /* copy the next block */
#line 3353
#pragma cdir loopcnt=LOOPCNT
#line 3353
#pragma cdir shortloop
#line 3353
    for (i=0; i<ni; i++) {
#line 3353
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3353
     /* test for range errors (not always needed but do it anyway) */
#line 3353
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3353
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3353
      nrange += xp[i] > LONG_MAX ;
#line 3353
    }
#line 3353
   /* update xpp and tp */
#line 3353
    if (realign) xp = (uint *) *xpp;
#line 3353
    xp += ni;
#line 3353
    tp += ni;
#line 3353
    *xpp = (void*)xp;
#line 3353
  }
#line 3353
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3353

#line 3353
#else   /* not SX */
#line 3353
	const char *xp = (const char *) *xpp;
#line 3353
	int status = NC_NOERR;
#line 3353

#line 3353
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3353
	{
#line 3353
		const int lstatus = ncx_get_uint_long(xp, tp);
#line 3353
		if (status == NC_NOERR) /* report the first encountered error */
#line 3353
			status = lstatus;
#line 3353
	}
#line 3353

#line 3353
	*xpp = (const void *)xp;
#line 3353
	return status;
#line 3353
#endif
#line 3353
}
#line 3353

int
#line 3354
ncx_getn_uint_float(const void **xpp, size_t nelems, float *tp)
#line 3354
{
#line 3354
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3354

#line 3354
 /* basic algorithm is:
#line 3354
  *   - ensure sane alignment of input data
#line 3354
  *   - copy (conversion happens automatically) input data
#line 3354
  *     to output
#line 3354
  *   - update xpp to point at next unconverted input, and tp to point
#line 3354
  *     at next location for converted output
#line 3354
  */
#line 3354
  long i, j, ni;
#line 3354
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3354
  uint *xp;
#line 3354
  int nrange = 0;         /* number of range errors */
#line 3354
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3354
  long cxp = (long) *((char**)xpp);
#line 3354

#line 3354
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3354
  /* sjl: manually stripmine so we can limit amount of
#line 3354
   * vector work space reserved to LOOPCNT elements. Also
#line 3354
   * makes vectorisation easy */
#line 3354
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3354
    ni=Min(nelems-j,LOOPCNT);
#line 3354
    if (realign) {
#line 3354
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3354
      xp = tmp;
#line 3354
    } else {
#line 3354
      xp = (uint *) *xpp;
#line 3354
    }
#line 3354
   /* copy the next block */
#line 3354
#pragma cdir loopcnt=LOOPCNT
#line 3354
#pragma cdir shortloop
#line 3354
    for (i=0; i<ni; i++) {
#line 3354
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3354
     /* test for range errors (not always needed but do it anyway) */
#line 3354
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3354
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3354
      nrange += xp[i] > FLOAT_MAX ;
#line 3354
    }
#line 3354
   /* update xpp and tp */
#line 3354
    if (realign) xp = (uint *) *xpp;
#line 3354
    xp += ni;
#line 3354
    tp += ni;
#line 3354
    *xpp = (void*)xp;
#line 3354
  }
#line 3354
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3354

#line 3354
#else   /* not SX */
#line 3354
	const char *xp = (const char *) *xpp;
#line 3354
	int status = NC_NOERR;
#line 3354

#line 3354
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3354
	{
#line 3354
		const int lstatus = ncx_get_uint_float(xp, tp);
#line 3354
		if (status == NC_NOERR) /* report the first encountered error */
#line 3354
			status = lstatus;
#line 3354
	}
#line 3354

#line 3354
	*xpp = (const void *)xp;
#line 3354
	return status;
#line 3354
#endif
#line 3354
}
#line 3354

int
#line 3355
ncx_getn_uint_double(const void **xpp, size_t nelems, double *tp)
#line 3355
{
#line 3355
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3355

#line 3355
 /* basic algorithm is:
#line 3355
  *   - ensure sane alignment of input data
#line 3355
  *   - copy (conversion happens automatically) input data
#line 3355
  *     to output
#line 3355
  *   - update xpp to point at next unconverted input, and tp to point
#line 3355
  *     at next location for converted output
#line 3355
  */
#line 3355
  long i, j, ni;
#line 3355
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3355
  uint *xp;
#line 3355
  int nrange = 0;         /* number of range errors */
#line 3355
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3355
  long cxp = (long) *((char**)xpp);
#line 3355

#line 3355
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3355
  /* sjl: manually stripmine so we can limit amount of
#line 3355
   * vector work space reserved to LOOPCNT elements. Also
#line 3355
   * makes vectorisation easy */
#line 3355
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3355
    ni=Min(nelems-j,LOOPCNT);
#line 3355
    if (realign) {
#line 3355
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3355
      xp = tmp;
#line 3355
    } else {
#line 3355
      xp = (uint *) *xpp;
#line 3355
    }
#line 3355
   /* copy the next block */
#line 3355
#pragma cdir loopcnt=LOOPCNT
#line 3355
#pragma cdir shortloop
#line 3355
    for (i=0; i<ni; i++) {
#line 3355
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3355
     /* test for range errors (not always needed but do it anyway) */
#line 3355
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3355
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3355
      nrange += xp[i] > DOUBLE_MAX ;
#line 3355
    }
#line 3355
   /* update xpp and tp */
#line 3355
    if (realign) xp = (uint *) *xpp;
#line 3355
    xp += ni;
#line 3355
    tp += ni;
#line 3355
    *xpp = (void*)xp;
#line 3355
  }
#line 3355
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3355

#line 3355
#else   /* not SX */
#line 3355
	const char *xp = (const char *) *xpp;
#line 3355
	int status = NC_NOERR;
#line 3355

#line 3355
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3355
	{
#line 3355
		const int lstatus = ncx_get_uint_double(xp, tp);
#line 3355
		if (status == NC_NOERR) /* report the first encountered error */
#line 3355
			status = lstatus;
#line 3355
	}
#line 3355

#line 3355
	*xpp = (const void *)xp;
#line 3355
	return status;
#line 3355
#endif
#line 3355
}
#line 3355

int
#line 3356
ncx_getn_uint_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3356
{
#line 3356
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3356

#line 3356
 /* basic algorithm is:
#line 3356
  *   - ensure sane alignment of input data
#line 3356
  *   - copy (conversion happens automatically) input data
#line 3356
  *     to output
#line 3356
  *   - update xpp to point at next unconverted input, and tp to point
#line 3356
  *     at next location for converted output
#line 3356
  */
#line 3356
  long i, j, ni;
#line 3356
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3356
  uint *xp;
#line 3356
  int nrange = 0;         /* number of range errors */
#line 3356
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3356
  long cxp = (long) *((char**)xpp);
#line 3356

#line 3356
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3356
  /* sjl: manually stripmine so we can limit amount of
#line 3356
   * vector work space reserved to LOOPCNT elements. Also
#line 3356
   * makes vectorisation easy */
#line 3356
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3356
    ni=Min(nelems-j,LOOPCNT);
#line 3356
    if (realign) {
#line 3356
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3356
      xp = tmp;
#line 3356
    } else {
#line 3356
      xp = (uint *) *xpp;
#line 3356
    }
#line 3356
   /* copy the next block */
#line 3356
#pragma cdir loopcnt=LOOPCNT
#line 3356
#pragma cdir shortloop
#line 3356
    for (i=0; i<ni; i++) {
#line 3356
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3356
     /* test for range errors (not always needed but do it anyway) */
#line 3356
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3356
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3356
      nrange += xp[i] > LONGLONG_MAX ;
#line 3356
    }
#line 3356
   /* update xpp and tp */
#line 3356
    if (realign) xp = (uint *) *xpp;
#line 3356
    xp += ni;
#line 3356
    tp += ni;
#line 3356
    *xpp = (void*)xp;
#line 3356
  }
#line 3356
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3356

#line 3356
#else   /* not SX */
#line 3356
	const char *xp = (const char *) *xpp;
#line 3356
	int status = NC_NOERR;
#line 3356

#line 3356
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3356
	{
#line 3356
		const int lstatus = ncx_get_uint_longlong(xp, tp);
#line 3356
		if (status == NC_NOERR) /* report the first encountered error */
#line 3356
			status = lstatus;
#line 3356
	}
#line 3356

#line 3356
	*xpp = (const void *)xp;
#line 3356
	return status;
#line 3356
#endif
#line 3356
}
#line 3356

int
#line 3357
ncx_getn_uint_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3357
{
#line 3357
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3357

#line 3357
 /* basic algorithm is:
#line 3357
  *   - ensure sane alignment of input data
#line 3357
  *   - copy (conversion happens automatically) input data
#line 3357
  *     to output
#line 3357
  *   - update xpp to point at next unconverted input, and tp to point
#line 3357
  *     at next location for converted output
#line 3357
  */
#line 3357
  long i, j, ni;
#line 3357
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3357
  uint *xp;
#line 3357
  int nrange = 0;         /* number of range errors */
#line 3357
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3357
  long cxp = (long) *((char**)xpp);
#line 3357

#line 3357
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3357
  /* sjl: manually stripmine so we can limit amount of
#line 3357
   * vector work space reserved to LOOPCNT elements. Also
#line 3357
   * makes vectorisation easy */
#line 3357
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3357
    ni=Min(nelems-j,LOOPCNT);
#line 3357
    if (realign) {
#line 3357
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3357
      xp = tmp;
#line 3357
    } else {
#line 3357
      xp = (uint *) *xpp;
#line 3357
    }
#line 3357
   /* copy the next block */
#line 3357
#pragma cdir loopcnt=LOOPCNT
#line 3357
#pragma cdir shortloop
#line 3357
    for (i=0; i<ni; i++) {
#line 3357
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3357
     /* test for range errors (not always needed but do it anyway) */
#line 3357
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3357
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3357
      nrange += xp[i] > UCHAR_MAX ;
#line 3357
    }
#line 3357
   /* update xpp and tp */
#line 3357
    if (realign) xp = (uint *) *xpp;
#line 3357
    xp += ni;
#line 3357
    tp += ni;
#line 3357
    *xpp = (void*)xp;
#line 3357
  }
#line 3357
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3357

#line 3357
#else   /* not SX */
#line 3357
	const char *xp = (const char *) *xpp;
#line 3357
	int status = NC_NOERR;
#line 3357

#line 3357
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3357
	{
#line 3357
		const int lstatus = ncx_get_uint_uchar(xp, tp);
#line 3357
		if (status == NC_NOERR) /* report the first encountered error */
#line 3357
			status = lstatus;
#line 3357
	}
#line 3357

#line 3357
	*xpp = (const void *)xp;
#line 3357
	return status;
#line 3357
#endif
#line 3357
}
#line 3357

int
#line 3358
ncx_getn_uint_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3358
{
#line 3358
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3358

#line 3358
 /* basic algorithm is:
#line 3358
  *   - ensure sane alignment of input data
#line 3358
  *   - copy (conversion happens automatically) input data
#line 3358
  *     to output
#line 3358
  *   - update xpp to point at next unconverted input, and tp to point
#line 3358
  *     at next location for converted output
#line 3358
  */
#line 3358
  long i, j, ni;
#line 3358
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3358
  uint *xp;
#line 3358
  int nrange = 0;         /* number of range errors */
#line 3358
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3358
  long cxp = (long) *((char**)xpp);
#line 3358

#line 3358
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3358
  /* sjl: manually stripmine so we can limit amount of
#line 3358
   * vector work space reserved to LOOPCNT elements. Also
#line 3358
   * makes vectorisation easy */
#line 3358
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3358
    ni=Min(nelems-j,LOOPCNT);
#line 3358
    if (realign) {
#line 3358
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3358
      xp = tmp;
#line 3358
    } else {
#line 3358
      xp = (uint *) *xpp;
#line 3358
    }
#line 3358
   /* copy the next block */
#line 3358
#pragma cdir loopcnt=LOOPCNT
#line 3358
#pragma cdir shortloop
#line 3358
    for (i=0; i<ni; i++) {
#line 3358
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3358
     /* test for range errors (not always needed but do it anyway) */
#line 3358
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3358
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3358
      nrange += xp[i] > USHORT_MAX ;
#line 3358
    }
#line 3358
   /* update xpp and tp */
#line 3358
    if (realign) xp = (uint *) *xpp;
#line 3358
    xp += ni;
#line 3358
    tp += ni;
#line 3358
    *xpp = (void*)xp;
#line 3358
  }
#line 3358
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3358

#line 3358
#else   /* not SX */
#line 3358
	const char *xp = (const char *) *xpp;
#line 3358
	int status = NC_NOERR;
#line 3358

#line 3358
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3358
	{
#line 3358
		const int lstatus = ncx_get_uint_ushort(xp, tp);
#line 3358
		if (status == NC_NOERR) /* report the first encountered error */
#line 3358
			status = lstatus;
#line 3358
	}
#line 3358

#line 3358
	*xpp = (const void *)xp;
#line 3358
	return status;
#line 3358
#endif
#line 3358
}
#line 3358

int
#line 3359
ncx_getn_uint_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3359
{
#line 3359
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3359

#line 3359
 /* basic algorithm is:
#line 3359
  *   - ensure sane alignment of input data
#line 3359
  *   - copy (conversion happens automatically) input data
#line 3359
  *     to output
#line 3359
  *   - update xpp to point at next unconverted input, and tp to point
#line 3359
  *     at next location for converted output
#line 3359
  */
#line 3359
  long i, j, ni;
#line 3359
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3359
  uint *xp;
#line 3359
  int nrange = 0;         /* number of range errors */
#line 3359
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3359
  long cxp = (long) *((char**)xpp);
#line 3359

#line 3359
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3359
  /* sjl: manually stripmine so we can limit amount of
#line 3359
   * vector work space reserved to LOOPCNT elements. Also
#line 3359
   * makes vectorisation easy */
#line 3359
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3359
    ni=Min(nelems-j,LOOPCNT);
#line 3359
    if (realign) {
#line 3359
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3359
      xp = tmp;
#line 3359
    } else {
#line 3359
      xp = (uint *) *xpp;
#line 3359
    }
#line 3359
   /* copy the next block */
#line 3359
#pragma cdir loopcnt=LOOPCNT
#line 3359
#pragma cdir shortloop
#line 3359
    for (i=0; i<ni; i++) {
#line 3359
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3359
     /* test for range errors (not always needed but do it anyway) */
#line 3359
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3359
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3359
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3359
    }
#line 3359
   /* update xpp and tp */
#line 3359
    if (realign) xp = (uint *) *xpp;
#line 3359
    xp += ni;
#line 3359
    tp += ni;
#line 3359
    *xpp = (void*)xp;
#line 3359
  }
#line 3359
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3359

#line 3359
#else   /* not SX */
#line 3359
	const char *xp = (const char *) *xpp;
#line 3359
	int status = NC_NOERR;
#line 3359

#line 3359
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3359
	{
#line 3359
		const int lstatus = ncx_get_uint_ulonglong(xp, tp);
#line 3359
		if (status == NC_NOERR) /* report the first encountered error */
#line 3359
			status = lstatus;
#line 3359
	}
#line 3359

#line 3359
	*xpp = (const void *)xp;
#line 3359
	return status;
#line 3359
#endif
#line 3359
}
#line 3359


#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const unsigned int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3375
ncx_putn_uint_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3375
{
#line 3375
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3375

#line 3375
 /* basic algorithm is:
#line 3375
  *   - ensure sane alignment of output data
#line 3375
  *   - copy (conversion happens automatically) input data
#line 3375
  *     to output
#line 3375
  *   - update tp to point at next unconverted input, and xpp to point
#line 3375
  *     at next location for converted output
#line 3375
  */
#line 3375
  long i, j, ni;
#line 3375
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3375
  uint *xp;
#line 3375
  int nrange = 0;         /* number of range errors */
#line 3375
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3375
  long cxp = (long) *((char**)xpp);
#line 3375

#line 3375
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3375
  /* sjl: manually stripmine so we can limit amount of
#line 3375
   * vector work space reserved to LOOPCNT elements. Also
#line 3375
   * makes vectorisation easy */
#line 3375
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3375
    ni=Min(nelems-j,LOOPCNT);
#line 3375
    if (realign) {
#line 3375
      xp = tmp;
#line 3375
    } else {
#line 3375
      xp = (uint *) *xpp;
#line 3375
    }
#line 3375
   /* copy the next block */
#line 3375
#pragma cdir loopcnt=LOOPCNT
#line 3375
#pragma cdir shortloop
#line 3375
    for (i=0; i<ni; i++) {
#line 3375
      /* the normal case: */
#line 3375
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3375
     /* test for range errors (not always needed but do it anyway) */
#line 3375
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3375
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3375
      nrange += tp[i] > X_UINT_MAX ;
#line 3375
    }
#line 3375
   /* copy workspace back if necessary */
#line 3375
    if (realign) {
#line 3375
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3375
      xp = (uint *) *xpp;
#line 3375
    }
#line 3375
   /* update xpp and tp */
#line 3375
    xp += ni;
#line 3375
    tp += ni;
#line 3375
    *xpp = (void*)xp;
#line 3375
  }
#line 3375
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3375

#line 3375
#else   /* not SX */
#line 3375

#line 3375
	char *xp = (char *) *xpp;
#line 3375
	int status = NC_NOERR;
#line 3375

#line 3375
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3375
	{
#line 3375
		int lstatus = ncx_put_uint_uint(xp, tp, fillp);
#line 3375
		if (status == NC_NOERR) /* report the first encountered error */
#line 3375
			status = lstatus;
#line 3375
	}
#line 3375

#line 3375
	*xpp = (void *)xp;
#line 3375
	return status;
#line 3375
#endif
#line 3375
}
#line 3375

#endif
int
#line 3377
ncx_putn_uint_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3377
{
#line 3377
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3377

#line 3377
 /* basic algorithm is:
#line 3377
  *   - ensure sane alignment of output data
#line 3377
  *   - copy (conversion happens automatically) input data
#line 3377
  *     to output
#line 3377
  *   - update tp to point at next unconverted input, and xpp to point
#line 3377
  *     at next location for converted output
#line 3377
  */
#line 3377
  long i, j, ni;
#line 3377
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3377
  uint *xp;
#line 3377
  int nrange = 0;         /* number of range errors */
#line 3377
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3377
  long cxp = (long) *((char**)xpp);
#line 3377

#line 3377
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3377
  /* sjl: manually stripmine so we can limit amount of
#line 3377
   * vector work space reserved to LOOPCNT elements. Also
#line 3377
   * makes vectorisation easy */
#line 3377
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3377
    ni=Min(nelems-j,LOOPCNT);
#line 3377
    if (realign) {
#line 3377
      xp = tmp;
#line 3377
    } else {
#line 3377
      xp = (uint *) *xpp;
#line 3377
    }
#line 3377
   /* copy the next block */
#line 3377
#pragma cdir loopcnt=LOOPCNT
#line 3377
#pragma cdir shortloop
#line 3377
    for (i=0; i<ni; i++) {
#line 3377
      /* the normal case: */
#line 3377
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3377
     /* test for range errors (not always needed but do it anyway) */
#line 3377
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3377
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3377
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3377
    }
#line 3377
   /* copy workspace back if necessary */
#line 3377
    if (realign) {
#line 3377
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3377
      xp = (uint *) *xpp;
#line 3377
    }
#line 3377
   /* update xpp and tp */
#line 3377
    xp += ni;
#line 3377
    tp += ni;
#line 3377
    *xpp = (void*)xp;
#line 3377
  }
#line 3377
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3377

#line 3377
#else   /* not SX */
#line 3377

#line 3377
	char *xp = (char *) *xpp;
#line 3377
	int status = NC_NOERR;
#line 3377

#line 3377
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3377
	{
#line 3377
		int lstatus = ncx_put_uint_schar(xp, tp, fillp);
#line 3377
		if (status == NC_NOERR) /* report the first encountered error */
#line 3377
			status = lstatus;
#line 3377
	}
#line 3377

#line 3377
	*xpp = (void *)xp;
#line 3377
	return status;
#line 3377
#endif
#line 3377
}
#line 3377

int
#line 3378
ncx_putn_uint_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3378
{
#line 3378
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3378

#line 3378
 /* basic algorithm is:
#line 3378
  *   - ensure sane alignment of output data
#line 3378
  *   - copy (conversion happens automatically) input data
#line 3378
  *     to output
#line 3378
  *   - update tp to point at next unconverted input, and xpp to point
#line 3378
  *     at next location for converted output
#line 3378
  */
#line 3378
  long i, j, ni;
#line 3378
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3378
  uint *xp;
#line 3378
  int nrange = 0;         /* number of range errors */
#line 3378
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3378
  long cxp = (long) *((char**)xpp);
#line 3378

#line 3378
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3378
  /* sjl: manually stripmine so we can limit amount of
#line 3378
   * vector work space reserved to LOOPCNT elements. Also
#line 3378
   * makes vectorisation easy */
#line 3378
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3378
    ni=Min(nelems-j,LOOPCNT);
#line 3378
    if (realign) {
#line 3378
      xp = tmp;
#line 3378
    } else {
#line 3378
      xp = (uint *) *xpp;
#line 3378
    }
#line 3378
   /* copy the next block */
#line 3378
#pragma cdir loopcnt=LOOPCNT
#line 3378
#pragma cdir shortloop
#line 3378
    for (i=0; i<ni; i++) {
#line 3378
      /* the normal case: */
#line 3378
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3378
     /* test for range errors (not always needed but do it anyway) */
#line 3378
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3378
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3378
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3378
    }
#line 3378
   /* copy workspace back if necessary */
#line 3378
    if (realign) {
#line 3378
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3378
      xp = (uint *) *xpp;
#line 3378
    }
#line 3378
   /* update xpp and tp */
#line 3378
    xp += ni;
#line 3378
    tp += ni;
#line 3378
    *xpp = (void*)xp;
#line 3378
  }
#line 3378
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3378

#line 3378
#else   /* not SX */
#line 3378

#line 3378
	char *xp = (char *) *xpp;
#line 3378
	int status = NC_NOERR;
#line 3378

#line 3378
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3378
	{
#line 3378
		int lstatus = ncx_put_uint_short(xp, tp, fillp);
#line 3378
		if (status == NC_NOERR) /* report the first encountered error */
#line 3378
			status = lstatus;
#line 3378
	}
#line 3378

#line 3378
	*xpp = (void *)xp;
#line 3378
	return status;
#line 3378
#endif
#line 3378
}
#line 3378

int
#line 3379
ncx_putn_uint_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3379
{
#line 3379
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3379

#line 3379
 /* basic algorithm is:
#line 3379
  *   - ensure sane alignment of output data
#line 3379
  *   - copy (conversion happens automatically) input data
#line 3379
  *     to output
#line 3379
  *   - update tp to point at next unconverted input, and xpp to point
#line 3379
  *     at next location for converted output
#line 3379
  */
#line 3379
  long i, j, ni;
#line 3379
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3379
  uint *xp;
#line 3379
  int nrange = 0;         /* number of range errors */
#line 3379
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3379
  long cxp = (long) *((char**)xpp);
#line 3379

#line 3379
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3379
  /* sjl: manually stripmine so we can limit amount of
#line 3379
   * vector work space reserved to LOOPCNT elements. Also
#line 3379
   * makes vectorisation easy */
#line 3379
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3379
    ni=Min(nelems-j,LOOPCNT);
#line 3379
    if (realign) {
#line 3379
      xp = tmp;
#line 3379
    } else {
#line 3379
      xp = (uint *) *xpp;
#line 3379
    }
#line 3379
   /* copy the next block */
#line 3379
#pragma cdir loopcnt=LOOPCNT
#line 3379
#pragma cdir shortloop
#line 3379
    for (i=0; i<ni; i++) {
#line 3379
      /* the normal case: */
#line 3379
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3379
     /* test for range errors (not always needed but do it anyway) */
#line 3379
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3379
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3379
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3379
    }
#line 3379
   /* copy workspace back if necessary */
#line 3379
    if (realign) {
#line 3379
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3379
      xp = (uint *) *xpp;
#line 3379
    }
#line 3379
   /* update xpp and tp */
#line 3379
    xp += ni;
#line 3379
    tp += ni;
#line 3379
    *xpp = (void*)xp;
#line 3379
  }
#line 3379
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3379

#line 3379
#else   /* not SX */
#line 3379

#line 3379
	char *xp = (char *) *xpp;
#line 3379
	int status = NC_NOERR;
#line 3379

#line 3379
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3379
	{
#line 3379
		int lstatus = ncx_put_uint_int(xp, tp, fillp);
#line 3379
		if (status == NC_NOERR) /* report the first encountered error */
#line 3379
			status = lstatus;
#line 3379
	}
#line 3379

#line 3379
	*xpp = (void *)xp;
#line 3379
	return status;
#line 3379
#endif
#line 3379
}
#line 3379

int
#line 3380
ncx_putn_uint_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3380
{
#line 3380
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3380

#line 3380
 /* basic algorithm is:
#line 3380
  *   - ensure sane alignment of output data
#line 3380
  *   - copy (conversion happens automatically) input data
#line 3380
  *     to output
#line 3380
  *   - update tp to point at next unconverted input, and xpp to point
#line 3380
  *     at next location for converted output
#line 3380
  */
#line 3380
  long i, j, ni;
#line 3380
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3380
  uint *xp;
#line 3380
  int nrange = 0;         /* number of range errors */
#line 3380
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3380
  long cxp = (long) *((char**)xpp);
#line 3380

#line 3380
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3380
  /* sjl: manually stripmine so we can limit amount of
#line 3380
   * vector work space reserved to LOOPCNT elements. Also
#line 3380
   * makes vectorisation easy */
#line 3380
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3380
    ni=Min(nelems-j,LOOPCNT);
#line 3380
    if (realign) {
#line 3380
      xp = tmp;
#line 3380
    } else {
#line 3380
      xp = (uint *) *xpp;
#line 3380
    }
#line 3380
   /* copy the next block */
#line 3380
#pragma cdir loopcnt=LOOPCNT
#line 3380
#pragma cdir shortloop
#line 3380
    for (i=0; i<ni; i++) {
#line 3380
      /* the normal case: */
#line 3380
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3380
     /* test for range errors (not always needed but do it anyway) */
#line 3380
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3380
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3380
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3380
    }
#line 3380
   /* copy workspace back if necessary */
#line 3380
    if (realign) {
#line 3380
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3380
      xp = (uint *) *xpp;
#line 3380
    }
#line 3380
   /* update xpp and tp */
#line 3380
    xp += ni;
#line 3380
    tp += ni;
#line 3380
    *xpp = (void*)xp;
#line 3380
  }
#line 3380
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3380

#line 3380
#else   /* not SX */
#line 3380

#line 3380
	char *xp = (char *) *xpp;
#line 3380
	int status = NC_NOERR;
#line 3380

#line 3380
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3380
	{
#line 3380
		int lstatus = ncx_put_uint_long(xp, tp, fillp);
#line 3380
		if (status == NC_NOERR) /* report the first encountered error */
#line 3380
			status = lstatus;
#line 3380
	}
#line 3380

#line 3380
	*xpp = (void *)xp;
#line 3380
	return status;
#line 3380
#endif
#line 3380
}
#line 3380

int
#line 3381
ncx_putn_uint_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3381
{
#line 3381
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3381

#line 3381
 /* basic algorithm is:
#line 3381
  *   - ensure sane alignment of output data
#line 3381
  *   - copy (conversion happens automatically) input data
#line 3381
  *     to output
#line 3381
  *   - update tp to point at next unconverted input, and xpp to point
#line 3381
  *     at next location for converted output
#line 3381
  */
#line 3381
  long i, j, ni;
#line 3381
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3381
  uint *xp;
#line 3381
  int nrange = 0;         /* number of range errors */
#line 3381
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3381
  long cxp = (long) *((char**)xpp);
#line 3381

#line 3381
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3381
  /* sjl: manually stripmine so we can limit amount of
#line 3381
   * vector work space reserved to LOOPCNT elements. Also
#line 3381
   * makes vectorisation easy */
#line 3381
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3381
    ni=Min(nelems-j,LOOPCNT);
#line 3381
    if (realign) {
#line 3381
      xp = tmp;
#line 3381
    } else {
#line 3381
      xp = (uint *) *xpp;
#line 3381
    }
#line 3381
   /* copy the next block */
#line 3381
#pragma cdir loopcnt=LOOPCNT
#line 3381
#pragma cdir shortloop
#line 3381
    for (i=0; i<ni; i++) {
#line 3381
      /* the normal case: */
#line 3381
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3381
     /* test for range errors (not always needed but do it anyway) */
#line 3381
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3381
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3381
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3381
    }
#line 3381
   /* copy workspace back if necessary */
#line 3381
    if (realign) {
#line 3381
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3381
      xp = (uint *) *xpp;
#line 3381
    }
#line 3381
   /* update xpp and tp */
#line 3381
    xp += ni;
#line 3381
    tp += ni;
#line 3381
    *xpp = (void*)xp;
#line 3381
  }
#line 3381
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3381

#line 3381
#else   /* not SX */
#line 3381

#line 3381
	char *xp = (char *) *xpp;
#line 3381
	int status = NC_NOERR;
#line 3381

#line 3381
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3381
	{
#line 3381
		int lstatus = ncx_put_uint_float(xp, tp, fillp);
#line 3381
		if (status == NC_NOERR) /* report the first encountered error */
#line 3381
			status = lstatus;
#line 3381
	}
#line 3381

#line 3381
	*xpp = (void *)xp;
#line 3381
	return status;
#line 3381
#endif
#line 3381
}
#line 3381

int
#line 3382
ncx_putn_uint_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3382
{
#line 3382
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3382

#line 3382
 /* basic algorithm is:
#line 3382
  *   - ensure sane alignment of output data
#line 3382
  *   - copy (conversion happens automatically) input data
#line 3382
  *     to output
#line 3382
  *   - update tp to point at next unconverted input, and xpp to point
#line 3382
  *     at next location for converted output
#line 3382
  */
#line 3382
  long i, j, ni;
#line 3382
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3382
  uint *xp;
#line 3382
  int nrange = 0;         /* number of range errors */
#line 3382
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3382
  long cxp = (long) *((char**)xpp);
#line 3382

#line 3382
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3382
  /* sjl: manually stripmine so we can limit amount of
#line 3382
   * vector work space reserved to LOOPCNT elements. Also
#line 3382
   * makes vectorisation easy */
#line 3382
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3382
    ni=Min(nelems-j,LOOPCNT);
#line 3382
    if (realign) {
#line 3382
      xp = tmp;
#line 3382
    } else {
#line 3382
      xp = (uint *) *xpp;
#line 3382
    }
#line 3382
   /* copy the next block */
#line 3382
#pragma cdir loopcnt=LOOPCNT
#line 3382
#pragma cdir shortloop
#line 3382
    for (i=0; i<ni; i++) {
#line 3382
      /* the normal case: */
#line 3382
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3382
     /* test for range errors (not always needed but do it anyway) */
#line 3382
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3382
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3382
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3382
    }
#line 3382
   /* copy workspace back if necessary */
#line 3382
    if (realign) {
#line 3382
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3382
      xp = (uint *) *xpp;
#line 3382
    }
#line 3382
   /* update xpp and tp */
#line 3382
    xp += ni;
#line 3382
    tp += ni;
#line 3382
    *xpp = (void*)xp;
#line 3382
  }
#line 3382
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3382

#line 3382
#else   /* not SX */
#line 3382

#line 3382
	char *xp = (char *) *xpp;
#line 3382
	int status = NC_NOERR;
#line 3382

#line 3382
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3382
	{
#line 3382
		int lstatus = ncx_put_uint_double(xp, tp, fillp);
#line 3382
		if (status == NC_NOERR) /* report the first encountered error */
#line 3382
			status = lstatus;
#line 3382
	}
#line 3382

#line 3382
	*xpp = (void *)xp;
#line 3382
	return status;
#line 3382
#endif
#line 3382
}
#line 3382

int
#line 3383
ncx_putn_uint_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3383
{
#line 3383
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3383

#line 3383
 /* basic algorithm is:
#line 3383
  *   - ensure sane alignment of output data
#line 3383
  *   - copy (conversion happens automatically) input data
#line 3383
  *     to output
#line 3383
  *   - update tp to point at next unconverted input, and xpp to point
#line 3383
  *     at next location for converted output
#line 3383
  */
#line 3383
  long i, j, ni;
#line 3383
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3383
  uint *xp;
#line 3383
  int nrange = 0;         /* number of range errors */
#line 3383
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3383
  long cxp = (long) *((char**)xpp);
#line 3383

#line 3383
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3383
  /* sjl: manually stripmine so we can limit amount of
#line 3383
   * vector work space reserved to LOOPCNT elements. Also
#line 3383
   * makes vectorisation easy */
#line 3383
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3383
    ni=Min(nelems-j,LOOPCNT);
#line 3383
    if (realign) {
#line 3383
      xp = tmp;
#line 3383
    } else {
#line 3383
      xp = (uint *) *xpp;
#line 3383
    }
#line 3383
   /* copy the next block */
#line 3383
#pragma cdir loopcnt=LOOPCNT
#line 3383
#pragma cdir shortloop
#line 3383
    for (i=0; i<ni; i++) {
#line 3383
      /* the normal case: */
#line 3383
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3383
     /* test for range errors (not always needed but do it anyway) */
#line 3383
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3383
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3383
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3383
    }
#line 3383
   /* copy workspace back if necessary */
#line 3383
    if (realign) {
#line 3383
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3383
      xp = (uint *) *xpp;
#line 3383
    }
#line 3383
   /* update xpp and tp */
#line 3383
    xp += ni;
#line 3383
    tp += ni;
#line 3383
    *xpp = (void*)xp;
#line 3383
  }
#line 3383
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3383

#line 3383
#else   /* not SX */
#line 3383

#line 3383
	char *xp = (char *) *xpp;
#line 3383
	int status = NC_NOERR;
#line 3383

#line 3383
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3383
	{
#line 3383
		int lstatus = ncx_put_uint_longlong(xp, tp, fillp);
#line 3383
		if (status == NC_NOERR) /* report the first encountered error */
#line 3383
			status = lstatus;
#line 3383
	}
#line 3383

#line 3383
	*xpp = (void *)xp;
#line 3383
	return status;
#line 3383
#endif
#line 3383
}
#line 3383

int
#line 3384
ncx_putn_uint_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3384
{
#line 3384
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3384

#line 3384
 /* basic algorithm is:
#line 3384
  *   - ensure sane alignment of output data
#line 3384
  *   - copy (conversion happens automatically) input data
#line 3384
  *     to output
#line 3384
  *   - update tp to point at next unconverted input, and xpp to point
#line 3384
  *     at next location for converted output
#line 3384
  */
#line 3384
  long i, j, ni;
#line 3384
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3384
  uint *xp;
#line 3384
  int nrange = 0;         /* number of range errors */
#line 3384
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3384
  long cxp = (long) *((char**)xpp);
#line 3384

#line 3384
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3384
  /* sjl: manually stripmine so we can limit amount of
#line 3384
   * vector work space reserved to LOOPCNT elements. Also
#line 3384
   * makes vectorisation easy */
#line 3384
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3384
    ni=Min(nelems-j,LOOPCNT);
#line 3384
    if (realign) {
#line 3384
      xp = tmp;
#line 3384
    } else {
#line 3384
      xp = (uint *) *xpp;
#line 3384
    }
#line 3384
   /* copy the next block */
#line 3384
#pragma cdir loopcnt=LOOPCNT
#line 3384
#pragma cdir shortloop
#line 3384
    for (i=0; i<ni; i++) {
#line 3384
      /* the normal case: */
#line 3384
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3384
     /* test for range errors (not always needed but do it anyway) */
#line 3384
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3384
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3384
      nrange += tp[i] > X_UINT_MAX ;
#line 3384
    }
#line 3384
   /* copy workspace back if necessary */
#line 3384
    if (realign) {
#line 3384
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3384
      xp = (uint *) *xpp;
#line 3384
    }
#line 3384
   /* update xpp and tp */
#line 3384
    xp += ni;
#line 3384
    tp += ni;
#line 3384
    *xpp = (void*)xp;
#line 3384
  }
#line 3384
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3384

#line 3384
#else   /* not SX */
#line 3384

#line 3384
	char *xp = (char *) *xpp;
#line 3384
	int status = NC_NOERR;
#line 3384

#line 3384
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3384
	{
#line 3384
		int lstatus = ncx_put_uint_uchar(xp, tp, fillp);
#line 3384
		if (status == NC_NOERR) /* report the first encountered error */
#line 3384
			status = lstatus;
#line 3384
	}
#line 3384

#line 3384
	*xpp = (void *)xp;
#line 3384
	return status;
#line 3384
#endif
#line 3384
}
#line 3384

int
#line 3385
ncx_putn_uint_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3385
{
#line 3385
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3385

#line 3385
 /* basic algorithm is:
#line 3385
  *   - ensure sane alignment of output data
#line 3385
  *   - copy (conversion happens automatically) input data
#line 3385
  *     to output
#line 3385
  *   - update tp to point at next unconverted input, and xpp to point
#line 3385
  *     at next location for converted output
#line 3385
  */
#line 3385
  long i, j, ni;
#line 3385
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3385
  uint *xp;
#line 3385
  int nrange = 0;         /* number of range errors */
#line 3385
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3385
  long cxp = (long) *((char**)xpp);
#line 3385

#line 3385
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3385
  /* sjl: manually stripmine so we can limit amount of
#line 3385
   * vector work space reserved to LOOPCNT elements. Also
#line 3385
   * makes vectorisation easy */
#line 3385
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3385
    ni=Min(nelems-j,LOOPCNT);
#line 3385
    if (realign) {
#line 3385
      xp = tmp;
#line 3385
    } else {
#line 3385
      xp = (uint *) *xpp;
#line 3385
    }
#line 3385
   /* copy the next block */
#line 3385
#pragma cdir loopcnt=LOOPCNT
#line 3385
#pragma cdir shortloop
#line 3385
    for (i=0; i<ni; i++) {
#line 3385
      /* the normal case: */
#line 3385
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3385
     /* test for range errors (not always needed but do it anyway) */
#line 3385
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3385
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3385
      nrange += tp[i] > X_UINT_MAX ;
#line 3385
    }
#line 3385
   /* copy workspace back if necessary */
#line 3385
    if (realign) {
#line 3385
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3385
      xp = (uint *) *xpp;
#line 3385
    }
#line 3385
   /* update xpp and tp */
#line 3385
    xp += ni;
#line 3385
    tp += ni;
#line 3385
    *xpp = (void*)xp;
#line 3385
  }
#line 3385
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3385

#line 3385
#else   /* not SX */
#line 3385

#line 3385
	char *xp = (char *) *xpp;
#line 3385
	int status = NC_NOERR;
#line 3385

#line 3385
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3385
	{
#line 3385
		int lstatus = ncx_put_uint_ushort(xp, tp, fillp);
#line 3385
		if (status == NC_NOERR) /* report the first encountered error */
#line 3385
			status = lstatus;
#line 3385
	}
#line 3385

#line 3385
	*xpp = (void *)xp;
#line 3385
	return status;
#line 3385
#endif
#line 3385
}
#line 3385

int
#line 3386
ncx_putn_uint_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3386
{
#line 3386
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3386

#line 3386
 /* basic algorithm is:
#line 3386
  *   - ensure sane alignment of output data
#line 3386
  *   - copy (conversion happens automatically) input data
#line 3386
  *     to output
#line 3386
  *   - update tp to point at next unconverted input, and xpp to point
#line 3386
  *     at next location for converted output
#line 3386
  */
#line 3386
  long i, j, ni;
#line 3386
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3386
  uint *xp;
#line 3386
  int nrange = 0;         /* number of range errors */
#line 3386
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3386
  long cxp = (long) *((char**)xpp);
#line 3386

#line 3386
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3386
  /* sjl: manually stripmine so we can limit amount of
#line 3386
   * vector work space reserved to LOOPCNT elements. Also
#line 3386
   * makes vectorisation easy */
#line 3386
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3386
    ni=Min(nelems-j,LOOPCNT);
#line 3386
    if (realign) {
#line 3386
      xp = tmp;
#line 3386
    } else {
#line 3386
      xp = (uint *) *xpp;
#line 3386
    }
#line 3386
   /* copy the next block */
#line 3386
#pragma cdir loopcnt=LOOPCNT
#line 3386
#pragma cdir shortloop
#line 3386
    for (i=0; i<ni; i++) {
#line 3386
      /* the normal case: */
#line 3386
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3386
     /* test for range errors (not always needed but do it anyway) */
#line 3386
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3386
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3386
      nrange += tp[i] > X_UINT_MAX ;
#line 3386
    }
#line 3386
   /* copy workspace back if necessary */
#line 3386
    if (realign) {
#line 3386
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3386
      xp = (uint *) *xpp;
#line 3386
    }
#line 3386
   /* update xpp and tp */
#line 3386
    xp += ni;
#line 3386
    tp += ni;
#line 3386
    *xpp = (void*)xp;
#line 3386
  }
#line 3386
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3386

#line 3386
#else   /* not SX */
#line 3386

#line 3386
	char *xp = (char *) *xpp;
#line 3386
	int status = NC_NOERR;
#line 3386

#line 3386
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3386
	{
#line 3386
		int lstatus = ncx_put_uint_ulonglong(xp, tp, fillp);
#line 3386
		if (status == NC_NOERR) /* report the first encountered error */
#line 3386
			status = lstatus;
#line 3386
	}
#line 3386

#line 3386
	*xpp = (void *)xp;
#line 3386
	return status;
#line 3386
#endif
#line 3386
}
#line 3386



/* float ---------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_FLOAT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while (ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 3412
		const struct ieee_single *const isp =
#line 3412
			 (const struct ieee_single *) (*xpp);
#line 3412
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 3412

#line 3412
		switch(exp) {
#line 3412
		case 0 :
#line 3412
			/* ieee subnormal */
#line 3412
			if (isp->mant_hi == min.ieee.mant_hi
#line 3412
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 3412
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 3412
			{
#line 3412
				*vsp = min.s;
#line 3412
			}
#line 3412
			else
#line 3412
			{
#line 3412
				unsigned mantissa = (isp->mant_hi << 16)
#line 3412
					 | isp->mant_lo_hi << 8
#line 3412
					 | isp->mant_lo_lo;
#line 3412
				unsigned tmp = mantissa >> 20;
#line 3412
				if (tmp >= 4) {
#line 3412
					vsp->exp = 2;
#line 3412
				} else if (tmp >= 2) {
#line 3412
					vsp->exp = 1;
#line 3412
				} else {
#line 3412
					*vsp = min.s;
#line 3412
					break;
#line 3412
				} /* else */
#line 3412
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 3412
				tmp <<= 3 - vsp->exp;
#line 3412
				vsp->mantissa2 = tmp;
#line 3412
				vsp->mantissa1 = (tmp >> 16);
#line 3412
			}
#line 3412
			break;
#line 3412
		case 0xfe :
#line 3412
		case 0xff :
#line 3412
			*vsp = max.s;
#line 3412
			break;
#line 3412
		default :
#line 3412
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 3412
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 3412
			vsp->mantissa1 = isp->mant_hi;
#line 3412
		}
#line 3412

#line 3412
		vsp->sign = isp->sign;
#line 3412


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
#line 3438
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
#line 3438
{
#line 3438
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3438

#line 3438
 /* basic algorithm is:
#line 3438
  *   - ensure sane alignment of input data
#line 3438
  *   - copy (conversion happens automatically) input data
#line 3438
  *     to output
#line 3438
  *   - update xpp to point at next unconverted input, and tp to point
#line 3438
  *     at next location for converted output
#line 3438
  */
#line 3438
  long i, j, ni;
#line 3438
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3438
  float *xp;
#line 3438
  int nrange = 0;         /* number of range errors */
#line 3438
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3438
  long cxp = (long) *((char**)xpp);
#line 3438

#line 3438
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3438
  /* sjl: manually stripmine so we can limit amount of
#line 3438
   * vector work space reserved to LOOPCNT elements. Also
#line 3438
   * makes vectorisation easy */
#line 3438
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3438
    ni=Min(nelems-j,LOOPCNT);
#line 3438
    if (realign) {
#line 3438
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3438
      xp = tmp;
#line 3438
    } else {
#line 3438
      xp = (float *) *xpp;
#line 3438
    }
#line 3438
   /* copy the next block */
#line 3438
#pragma cdir loopcnt=LOOPCNT
#line 3438
#pragma cdir shortloop
#line 3438
    for (i=0; i<ni; i++) {
#line 3438
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3438
     /* test for range errors (not always needed but do it anyway) */
#line 3438
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3438
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3438
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3438
    }
#line 3438
   /* update xpp and tp */
#line 3438
    if (realign) xp = (float *) *xpp;
#line 3438
    xp += ni;
#line 3438
    tp += ni;
#line 3438
    *xpp = (void*)xp;
#line 3438
  }
#line 3438
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3438

#line 3438
#else   /* not SX */
#line 3438
	const char *xp = (const char *) *xpp;
#line 3438
	int status = NC_NOERR;
#line 3438

#line 3438
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3438
	{
#line 3438
		const int lstatus = ncx_get_float_schar(xp, tp);
#line 3438
		if (status == NC_NOERR) /* report the first encountered error */
#line 3438
			status = lstatus;
#line 3438
	}
#line 3438

#line 3438
	*xpp = (const void *)xp;
#line 3438
	return status;
#line 3438
#endif
#line 3438
}
#line 3438

int
#line 3439
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
#line 3439
{
#line 3439
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3439

#line 3439
 /* basic algorithm is:
#line 3439
  *   - ensure sane alignment of input data
#line 3439
  *   - copy (conversion happens automatically) input data
#line 3439
  *     to output
#line 3439
  *   - update xpp to point at next unconverted input, and tp to point
#line 3439
  *     at next location for converted output
#line 3439
  */
#line 3439
  long i, j, ni;
#line 3439
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3439
  float *xp;
#line 3439
  int nrange = 0;         /* number of range errors */
#line 3439
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3439
  long cxp = (long) *((char**)xpp);
#line 3439

#line 3439
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3439
  /* sjl: manually stripmine so we can limit amount of
#line 3439
   * vector work space reserved to LOOPCNT elements. Also
#line 3439
   * makes vectorisation easy */
#line 3439
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3439
    ni=Min(nelems-j,LOOPCNT);
#line 3439
    if (realign) {
#line 3439
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3439
      xp = tmp;
#line 3439
    } else {
#line 3439
      xp = (float *) *xpp;
#line 3439
    }
#line 3439
   /* copy the next block */
#line 3439
#pragma cdir loopcnt=LOOPCNT
#line 3439
#pragma cdir shortloop
#line 3439
    for (i=0; i<ni; i++) {
#line 3439
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3439
     /* test for range errors (not always needed but do it anyway) */
#line 3439
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3439
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3439
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3439
    }
#line 3439
   /* update xpp and tp */
#line 3439
    if (realign) xp = (float *) *xpp;
#line 3439
    xp += ni;
#line 3439
    tp += ni;
#line 3439
    *xpp = (void*)xp;
#line 3439
  }
#line 3439
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3439

#line 3439
#else   /* not SX */
#line 3439
	const char *xp = (const char *) *xpp;
#line 3439
	int status = NC_NOERR;
#line 3439

#line 3439
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3439
	{
#line 3439
		const int lstatus = ncx_get_float_short(xp, tp);
#line 3439
		if (status == NC_NOERR) /* report the first encountered error */
#line 3439
			status = lstatus;
#line 3439
	}
#line 3439

#line 3439
	*xpp = (const void *)xp;
#line 3439
	return status;
#line 3439
#endif
#line 3439
}
#line 3439

int
#line 3440
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
#line 3440
{
#line 3440
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3440

#line 3440
 /* basic algorithm is:
#line 3440
  *   - ensure sane alignment of input data
#line 3440
  *   - copy (conversion happens automatically) input data
#line 3440
  *     to output
#line 3440
  *   - update xpp to point at next unconverted input, and tp to point
#line 3440
  *     at next location for converted output
#line 3440
  */
#line 3440
  long i, j, ni;
#line 3440
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3440
  float *xp;
#line 3440
  int nrange = 0;         /* number of range errors */
#line 3440
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3440
  long cxp = (long) *((char**)xpp);
#line 3440

#line 3440
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3440
  /* sjl: manually stripmine so we can limit amount of
#line 3440
   * vector work space reserved to LOOPCNT elements. Also
#line 3440
   * makes vectorisation easy */
#line 3440
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3440
    ni=Min(nelems-j,LOOPCNT);
#line 3440
    if (realign) {
#line 3440
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3440
      xp = tmp;
#line 3440
    } else {
#line 3440
      xp = (float *) *xpp;
#line 3440
    }
#line 3440
   /* copy the next block */
#line 3440
#pragma cdir loopcnt=LOOPCNT
#line 3440
#pragma cdir shortloop
#line 3440
    for (i=0; i<ni; i++) {
#line 3440
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3440
     /* test for range errors (not always needed but do it anyway) */
#line 3440
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3440
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3440
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3440
    }
#line 3440
   /* update xpp and tp */
#line 3440
    if (realign) xp = (float *) *xpp;
#line 3440
    xp += ni;
#line 3440
    tp += ni;
#line 3440
    *xpp = (void*)xp;
#line 3440
  }
#line 3440
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3440

#line 3440
#else   /* not SX */
#line 3440
	const char *xp = (const char *) *xpp;
#line 3440
	int status = NC_NOERR;
#line 3440

#line 3440
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3440
	{
#line 3440
		const int lstatus = ncx_get_float_int(xp, tp);
#line 3440
		if (status == NC_NOERR) /* report the first encountered error */
#line 3440
			status = lstatus;
#line 3440
	}
#line 3440

#line 3440
	*xpp = (const void *)xp;
#line 3440
	return status;
#line 3440
#endif
#line 3440
}
#line 3440

int
#line 3441
ncx_getn_float_long(const void **xpp, size_t nelems, long *tp)
#line 3441
{
#line 3441
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3441

#line 3441
 /* basic algorithm is:
#line 3441
  *   - ensure sane alignment of input data
#line 3441
  *   - copy (conversion happens automatically) input data
#line 3441
  *     to output
#line 3441
  *   - update xpp to point at next unconverted input, and tp to point
#line 3441
  *     at next location for converted output
#line 3441
  */
#line 3441
  long i, j, ni;
#line 3441
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3441
  float *xp;
#line 3441
  int nrange = 0;         /* number of range errors */
#line 3441
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3441
  long cxp = (long) *((char**)xpp);
#line 3441

#line 3441
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3441
  /* sjl: manually stripmine so we can limit amount of
#line 3441
   * vector work space reserved to LOOPCNT elements. Also
#line 3441
   * makes vectorisation easy */
#line 3441
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3441
    ni=Min(nelems-j,LOOPCNT);
#line 3441
    if (realign) {
#line 3441
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3441
      xp = tmp;
#line 3441
    } else {
#line 3441
      xp = (float *) *xpp;
#line 3441
    }
#line 3441
   /* copy the next block */
#line 3441
#pragma cdir loopcnt=LOOPCNT
#line 3441
#pragma cdir shortloop
#line 3441
    for (i=0; i<ni; i++) {
#line 3441
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3441
     /* test for range errors (not always needed but do it anyway) */
#line 3441
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3441
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3441
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3441
    }
#line 3441
   /* update xpp and tp */
#line 3441
    if (realign) xp = (float *) *xpp;
#line 3441
    xp += ni;
#line 3441
    tp += ni;
#line 3441
    *xpp = (void*)xp;
#line 3441
  }
#line 3441
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3441

#line 3441
#else   /* not SX */
#line 3441
	const char *xp = (const char *) *xpp;
#line 3441
	int status = NC_NOERR;
#line 3441

#line 3441
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3441
	{
#line 3441
		const int lstatus = ncx_get_float_long(xp, tp);
#line 3441
		if (status == NC_NOERR) /* report the first encountered error */
#line 3441
			status = lstatus;
#line 3441
	}
#line 3441

#line 3441
	*xpp = (const void *)xp;
#line 3441
	return status;
#line 3441
#endif
#line 3441
}
#line 3441

int
#line 3442
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
#line 3442
{
#line 3442
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3442

#line 3442
 /* basic algorithm is:
#line 3442
  *   - ensure sane alignment of input data
#line 3442
  *   - copy (conversion happens automatically) input data
#line 3442
  *     to output
#line 3442
  *   - update xpp to point at next unconverted input, and tp to point
#line 3442
  *     at next location for converted output
#line 3442
  */
#line 3442
  long i, j, ni;
#line 3442
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3442
  float *xp;
#line 3442
  int nrange = 0;         /* number of range errors */
#line 3442
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3442
  long cxp = (long) *((char**)xpp);
#line 3442

#line 3442
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3442
  /* sjl: manually stripmine so we can limit amount of
#line 3442
   * vector work space reserved to LOOPCNT elements. Also
#line 3442
   * makes vectorisation easy */
#line 3442
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3442
    ni=Min(nelems-j,LOOPCNT);
#line 3442
    if (realign) {
#line 3442
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3442
      xp = tmp;
#line 3442
    } else {
#line 3442
      xp = (float *) *xpp;
#line 3442
    }
#line 3442
   /* copy the next block */
#line 3442
#pragma cdir loopcnt=LOOPCNT
#line 3442
#pragma cdir shortloop
#line 3442
    for (i=0; i<ni; i++) {
#line 3442
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3442
     /* test for range errors (not always needed but do it anyway) */
#line 3442
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3442
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3442
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3442
    }
#line 3442
   /* update xpp and tp */
#line 3442
    if (realign) xp = (float *) *xpp;
#line 3442
    xp += ni;
#line 3442
    tp += ni;
#line 3442
    *xpp = (void*)xp;
#line 3442
  }
#line 3442
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3442

#line 3442
#else   /* not SX */
#line 3442
	const char *xp = (const char *) *xpp;
#line 3442
	int status = NC_NOERR;
#line 3442

#line 3442
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3442
	{
#line 3442
		const int lstatus = ncx_get_float_double(xp, tp);
#line 3442
		if (status == NC_NOERR) /* report the first encountered error */
#line 3442
			status = lstatus;
#line 3442
	}
#line 3442

#line 3442
	*xpp = (const void *)xp;
#line 3442
	return status;
#line 3442
#endif
#line 3442
}
#line 3442

int
#line 3443
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3443
{
#line 3443
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3443

#line 3443
 /* basic algorithm is:
#line 3443
  *   - ensure sane alignment of input data
#line 3443
  *   - copy (conversion happens automatically) input data
#line 3443
  *     to output
#line 3443
  *   - update xpp to point at next unconverted input, and tp to point
#line 3443
  *     at next location for converted output
#line 3443
  */
#line 3443
  long i, j, ni;
#line 3443
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3443
  float *xp;
#line 3443
  int nrange = 0;         /* number of range errors */
#line 3443
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3443
  long cxp = (long) *((char**)xpp);
#line 3443

#line 3443
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3443
  /* sjl: manually stripmine so we can limit amount of
#line 3443
   * vector work space reserved to LOOPCNT elements. Also
#line 3443
   * makes vectorisation easy */
#line 3443
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3443
    ni=Min(nelems-j,LOOPCNT);
#line 3443
    if (realign) {
#line 3443
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3443
      xp = tmp;
#line 3443
    } else {
#line 3443
      xp = (float *) *xpp;
#line 3443
    }
#line 3443
   /* copy the next block */
#line 3443
#pragma cdir loopcnt=LOOPCNT
#line 3443
#pragma cdir shortloop
#line 3443
    for (i=0; i<ni; i++) {
#line 3443
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3443
     /* test for range errors (not always needed but do it anyway) */
#line 3443
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3443
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3443
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3443
    }
#line 3443
   /* update xpp and tp */
#line 3443
    if (realign) xp = (float *) *xpp;
#line 3443
    xp += ni;
#line 3443
    tp += ni;
#line 3443
    *xpp = (void*)xp;
#line 3443
  }
#line 3443
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3443

#line 3443
#else   /* not SX */
#line 3443
	const char *xp = (const char *) *xpp;
#line 3443
	int status = NC_NOERR;
#line 3443

#line 3443
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3443
	{
#line 3443
		const int lstatus = ncx_get_float_longlong(xp, tp);
#line 3443
		if (status == NC_NOERR) /* report the first encountered error */
#line 3443
			status = lstatus;
#line 3443
	}
#line 3443

#line 3443
	*xpp = (const void *)xp;
#line 3443
	return status;
#line 3443
#endif
#line 3443
}
#line 3443

int
#line 3444
ncx_getn_float_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3444
{
#line 3444
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3444

#line 3444
 /* basic algorithm is:
#line 3444
  *   - ensure sane alignment of input data
#line 3444
  *   - copy (conversion happens automatically) input data
#line 3444
  *     to output
#line 3444
  *   - update xpp to point at next unconverted input, and tp to point
#line 3444
  *     at next location for converted output
#line 3444
  */
#line 3444
  long i, j, ni;
#line 3444
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3444
  float *xp;
#line 3444
  int nrange = 0;         /* number of range errors */
#line 3444
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3444
  long cxp = (long) *((char**)xpp);
#line 3444

#line 3444
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3444
  /* sjl: manually stripmine so we can limit amount of
#line 3444
   * vector work space reserved to LOOPCNT elements. Also
#line 3444
   * makes vectorisation easy */
#line 3444
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3444
    ni=Min(nelems-j,LOOPCNT);
#line 3444
    if (realign) {
#line 3444
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3444
      xp = tmp;
#line 3444
    } else {
#line 3444
      xp = (float *) *xpp;
#line 3444
    }
#line 3444
   /* copy the next block */
#line 3444
#pragma cdir loopcnt=LOOPCNT
#line 3444
#pragma cdir shortloop
#line 3444
    for (i=0; i<ni; i++) {
#line 3444
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3444
     /* test for range errors (not always needed but do it anyway) */
#line 3444
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3444
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3444
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3444
    }
#line 3444
   /* update xpp and tp */
#line 3444
    if (realign) xp = (float *) *xpp;
#line 3444
    xp += ni;
#line 3444
    tp += ni;
#line 3444
    *xpp = (void*)xp;
#line 3444
  }
#line 3444
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3444

#line 3444
#else   /* not SX */
#line 3444
	const char *xp = (const char *) *xpp;
#line 3444
	int status = NC_NOERR;
#line 3444

#line 3444
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3444
	{
#line 3444
		const int lstatus = ncx_get_float_ushort(xp, tp);
#line 3444
		if (status == NC_NOERR) /* report the first encountered error */
#line 3444
			status = lstatus;
#line 3444
	}
#line 3444

#line 3444
	*xpp = (const void *)xp;
#line 3444
	return status;
#line 3444
#endif
#line 3444
}
#line 3444

int
#line 3445
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3445
{
#line 3445
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3445

#line 3445
 /* basic algorithm is:
#line 3445
  *   - ensure sane alignment of input data
#line 3445
  *   - copy (conversion happens automatically) input data
#line 3445
  *     to output
#line 3445
  *   - update xpp to point at next unconverted input, and tp to point
#line 3445
  *     at next location for converted output
#line 3445
  */
#line 3445
  long i, j, ni;
#line 3445
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3445
  float *xp;
#line 3445
  int nrange = 0;         /* number of range errors */
#line 3445
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3445
  long cxp = (long) *((char**)xpp);
#line 3445

#line 3445
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3445
  /* sjl: manually stripmine so we can limit amount of
#line 3445
   * vector work space reserved to LOOPCNT elements. Also
#line 3445
   * makes vectorisation easy */
#line 3445
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3445
    ni=Min(nelems-j,LOOPCNT);
#line 3445
    if (realign) {
#line 3445
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3445
      xp = tmp;
#line 3445
    } else {
#line 3445
      xp = (float *) *xpp;
#line 3445
    }
#line 3445
   /* copy the next block */
#line 3445
#pragma cdir loopcnt=LOOPCNT
#line 3445
#pragma cdir shortloop
#line 3445
    for (i=0; i<ni; i++) {
#line 3445
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3445
     /* test for range errors (not always needed but do it anyway) */
#line 3445
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3445
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3445
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3445
    }
#line 3445
   /* update xpp and tp */
#line 3445
    if (realign) xp = (float *) *xpp;
#line 3445
    xp += ni;
#line 3445
    tp += ni;
#line 3445
    *xpp = (void*)xp;
#line 3445
  }
#line 3445
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3445

#line 3445
#else   /* not SX */
#line 3445
	const char *xp = (const char *) *xpp;
#line 3445
	int status = NC_NOERR;
#line 3445

#line 3445
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3445
	{
#line 3445
		const int lstatus = ncx_get_float_uchar(xp, tp);
#line 3445
		if (status == NC_NOERR) /* report the first encountered error */
#line 3445
			status = lstatus;
#line 3445
	}
#line 3445

#line 3445
	*xpp = (const void *)xp;
#line 3445
	return status;
#line 3445
#endif
#line 3445
}
#line 3445

int
#line 3446
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
#line 3446
{
#line 3446
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3446

#line 3446
 /* basic algorithm is:
#line 3446
  *   - ensure sane alignment of input data
#line 3446
  *   - copy (conversion happens automatically) input data
#line 3446
  *     to output
#line 3446
  *   - update xpp to point at next unconverted input, and tp to point
#line 3446
  *     at next location for converted output
#line 3446
  */
#line 3446
  long i, j, ni;
#line 3446
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3446
  float *xp;
#line 3446
  int nrange = 0;         /* number of range errors */
#line 3446
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3446
  long cxp = (long) *((char**)xpp);
#line 3446

#line 3446
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3446
  /* sjl: manually stripmine so we can limit amount of
#line 3446
   * vector work space reserved to LOOPCNT elements. Also
#line 3446
   * makes vectorisation easy */
#line 3446
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3446
    ni=Min(nelems-j,LOOPCNT);
#line 3446
    if (realign) {
#line 3446
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3446
      xp = tmp;
#line 3446
    } else {
#line 3446
      xp = (float *) *xpp;
#line 3446
    }
#line 3446
   /* copy the next block */
#line 3446
#pragma cdir loopcnt=LOOPCNT
#line 3446
#pragma cdir shortloop
#line 3446
    for (i=0; i<ni; i++) {
#line 3446
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3446
     /* test for range errors (not always needed but do it anyway) */
#line 3446
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3446
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3446
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3446
    }
#line 3446
   /* update xpp and tp */
#line 3446
    if (realign) xp = (float *) *xpp;
#line 3446
    xp += ni;
#line 3446
    tp += ni;
#line 3446
    *xpp = (void*)xp;
#line 3446
  }
#line 3446
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3446

#line 3446
#else   /* not SX */
#line 3446
	const char *xp = (const char *) *xpp;
#line 3446
	int status = NC_NOERR;
#line 3446

#line 3446
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3446
	{
#line 3446
		const int lstatus = ncx_get_float_uint(xp, tp);
#line 3446
		if (status == NC_NOERR) /* report the first encountered error */
#line 3446
			status = lstatus;
#line 3446
	}
#line 3446

#line 3446
	*xpp = (const void *)xp;
#line 3446
	return status;
#line 3446
#endif
#line 3446
}
#line 3446

int
#line 3447
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3447
{
#line 3447
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3447

#line 3447
 /* basic algorithm is:
#line 3447
  *   - ensure sane alignment of input data
#line 3447
  *   - copy (conversion happens automatically) input data
#line 3447
  *     to output
#line 3447
  *   - update xpp to point at next unconverted input, and tp to point
#line 3447
  *     at next location for converted output
#line 3447
  */
#line 3447
  long i, j, ni;
#line 3447
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3447
  float *xp;
#line 3447
  int nrange = 0;         /* number of range errors */
#line 3447
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3447
  long cxp = (long) *((char**)xpp);
#line 3447

#line 3447
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3447
  /* sjl: manually stripmine so we can limit amount of
#line 3447
   * vector work space reserved to LOOPCNT elements. Also
#line 3447
   * makes vectorisation easy */
#line 3447
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3447
    ni=Min(nelems-j,LOOPCNT);
#line 3447
    if (realign) {
#line 3447
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3447
      xp = tmp;
#line 3447
    } else {
#line 3447
      xp = (float *) *xpp;
#line 3447
    }
#line 3447
   /* copy the next block */
#line 3447
#pragma cdir loopcnt=LOOPCNT
#line 3447
#pragma cdir shortloop
#line 3447
    for (i=0; i<ni; i++) {
#line 3447
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3447
     /* test for range errors (not always needed but do it anyway) */
#line 3447
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3447
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3447
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3447
    }
#line 3447
   /* update xpp and tp */
#line 3447
    if (realign) xp = (float *) *xpp;
#line 3447
    xp += ni;
#line 3447
    tp += ni;
#line 3447
    *xpp = (void*)xp;
#line 3447
  }
#line 3447
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3447

#line 3447
#else   /* not SX */
#line 3447
	const char *xp = (const char *) *xpp;
#line 3447
	int status = NC_NOERR;
#line 3447

#line 3447
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3447
	{
#line 3447
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
#line 3447
		if (status == NC_NOERR) /* report the first encountered error */
#line 3447
			status = lstatus;
#line 3447
	}
#line 3447

#line 3447
	*xpp = (const void *)xp;
#line 3447
	return status;
#line 3447
#endif
#line 3447
}
#line 3447


int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
{
	const float *const end = tp + nelems;

	while (tp < end) {
				const struct vax_single *const vsp =
#line 3467
			 (const struct vax_single *)ip;
#line 3467
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);
#line 3467

#line 3467
		switch(vsp->exp){
#line 3467
		case 0 :
#line 3467
			/* all vax float with zero exponent map to zero */
#line 3467
			*isp = min.ieee;
#line 3467
			break;
#line 3467
		case 2 :
#line 3467
		case 1 :
#line 3467
		{
#line 3467
			/* These will map to subnormals */
#line 3467
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 3467
					 | vsp->mantissa2;
#line 3467
			mantissa >>= 3 - vsp->exp;
#line 3467
			mantissa += (1 << (20 + vsp->exp));
#line 3467
			isp->mant_lo_lo = mantissa;
#line 3467
			isp->mant_lo_hi = mantissa >> 8;
#line 3467
			isp->mant_hi = mantissa >> 16;
#line 3467
			isp->exp_lo = 0;
#line 3467
			isp->exp_hi = 0;
#line 3467
		}
#line 3467
			break;
#line 3467
		case 0xff : /* max.s.exp */
#line 3467
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 3467
			    vsp->mantissa1 == max.s.mantissa1)
#line 3467
			{
#line 3467
				/* map largest vax float to ieee infinity */
#line 3467
				*isp = max.ieee;
#line 3467
				break;
#line 3467
			} /* else, fall thru */
#line 3467
		default :
#line 3467
		{
#line 3467
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 3467
			isp->exp_hi = exp >> 1;
#line 3467
			isp->exp_lo = exp;
#line 3467
			isp->mant_lo_lo = vsp->mantissa2;
#line 3467
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 3467
			isp->mant_hi = vsp->mantissa1;
#line 3467
		}
#line 3467
		}
#line 3467

#line 3467
		isp->sign = vsp->sign;
#line 3467

		tp++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++) {
		int lstatus = ncx_put_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3488
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3488
{
#line 3488
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3488

#line 3488
 /* basic algorithm is:
#line 3488
  *   - ensure sane alignment of output data
#line 3488
  *   - copy (conversion happens automatically) input data
#line 3488
  *     to output
#line 3488
  *   - update tp to point at next unconverted input, and xpp to point
#line 3488
  *     at next location for converted output
#line 3488
  */
#line 3488
  long i, j, ni;
#line 3488
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3488
  float *xp;
#line 3488
  int nrange = 0;         /* number of range errors */
#line 3488
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3488
  long cxp = (long) *((char**)xpp);
#line 3488

#line 3488
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3488
  /* sjl: manually stripmine so we can limit amount of
#line 3488
   * vector work space reserved to LOOPCNT elements. Also
#line 3488
   * makes vectorisation easy */
#line 3488
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3488
    ni=Min(nelems-j,LOOPCNT);
#line 3488
    if (realign) {
#line 3488
      xp = tmp;
#line 3488
    } else {
#line 3488
      xp = (float *) *xpp;
#line 3488
    }
#line 3488
   /* copy the next block */
#line 3488
#pragma cdir loopcnt=LOOPCNT
#line 3488
#pragma cdir shortloop
#line 3488
    for (i=0; i<ni; i++) {
#line 3488
      /* the normal case: */
#line 3488
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3488
     /* test for range errors (not always needed but do it anyway) */
#line 3488
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3488
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3488
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3488
    }
#line 3488
   /* copy workspace back if necessary */
#line 3488
    if (realign) {
#line 3488
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3488
      xp = (float *) *xpp;
#line 3488
    }
#line 3488
   /* update xpp and tp */
#line 3488
    xp += ni;
#line 3488
    tp += ni;
#line 3488
    *xpp = (void*)xp;
#line 3488
  }
#line 3488
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3488

#line 3488
#else   /* not SX */
#line 3488

#line 3488
	char *xp = (char *) *xpp;
#line 3488
	int status = NC_NOERR;
#line 3488

#line 3488
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3488
	{
#line 3488
		int lstatus = ncx_put_float_schar(xp, tp, fillp);
#line 3488
		if (status == NC_NOERR) /* report the first encountered error */
#line 3488
			status = lstatus;
#line 3488
	}
#line 3488

#line 3488
	*xpp = (void *)xp;
#line 3488
	return status;
#line 3488
#endif
#line 3488
}
#line 3488

int
#line 3489
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3489
{
#line 3489
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3489

#line 3489
 /* basic algorithm is:
#line 3489
  *   - ensure sane alignment of output data
#line 3489
  *   - copy (conversion happens automatically) input data
#line 3489
  *     to output
#line 3489
  *   - update tp to point at next unconverted input, and xpp to point
#line 3489
  *     at next location for converted output
#line 3489
  */
#line 3489
  long i, j, ni;
#line 3489
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3489
  float *xp;
#line 3489
  int nrange = 0;         /* number of range errors */
#line 3489
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3489
  long cxp = (long) *((char**)xpp);
#line 3489

#line 3489
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3489
  /* sjl: manually stripmine so we can limit amount of
#line 3489
   * vector work space reserved to LOOPCNT elements. Also
#line 3489
   * makes vectorisation easy */
#line 3489
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3489
    ni=Min(nelems-j,LOOPCNT);
#line 3489
    if (realign) {
#line 3489
      xp = tmp;
#line 3489
    } else {
#line 3489
      xp = (float *) *xpp;
#line 3489
    }
#line 3489
   /* copy the next block */
#line 3489
#pragma cdir loopcnt=LOOPCNT
#line 3489
#pragma cdir shortloop
#line 3489
    for (i=0; i<ni; i++) {
#line 3489
      /* the normal case: */
#line 3489
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3489
     /* test for range errors (not always needed but do it anyway) */
#line 3489
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3489
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3489
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3489
    }
#line 3489
   /* copy workspace back if necessary */
#line 3489
    if (realign) {
#line 3489
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3489
      xp = (float *) *xpp;
#line 3489
    }
#line 3489
   /* update xpp and tp */
#line 3489
    xp += ni;
#line 3489
    tp += ni;
#line 3489
    *xpp = (void*)xp;
#line 3489
  }
#line 3489
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3489

#line 3489
#else   /* not SX */
#line 3489

#line 3489
	char *xp = (char *) *xpp;
#line 3489
	int status = NC_NOERR;
#line 3489

#line 3489
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3489
	{
#line 3489
		int lstatus = ncx_put_float_short(xp, tp, fillp);
#line 3489
		if (status == NC_NOERR) /* report the first encountered error */
#line 3489
			status = lstatus;
#line 3489
	}
#line 3489

#line 3489
	*xpp = (void *)xp;
#line 3489
	return status;
#line 3489
#endif
#line 3489
}
#line 3489

int
#line 3490
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3490
{
#line 3490
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3490

#line 3490
 /* basic algorithm is:
#line 3490
  *   - ensure sane alignment of output data
#line 3490
  *   - copy (conversion happens automatically) input data
#line 3490
  *     to output
#line 3490
  *   - update tp to point at next unconverted input, and xpp to point
#line 3490
  *     at next location for converted output
#line 3490
  */
#line 3490
  long i, j, ni;
#line 3490
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3490
  float *xp;
#line 3490
  int nrange = 0;         /* number of range errors */
#line 3490
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3490
  long cxp = (long) *((char**)xpp);
#line 3490

#line 3490
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3490
  /* sjl: manually stripmine so we can limit amount of
#line 3490
   * vector work space reserved to LOOPCNT elements. Also
#line 3490
   * makes vectorisation easy */
#line 3490
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3490
    ni=Min(nelems-j,LOOPCNT);
#line 3490
    if (realign) {
#line 3490
      xp = tmp;
#line 3490
    } else {
#line 3490
      xp = (float *) *xpp;
#line 3490
    }
#line 3490
   /* copy the next block */
#line 3490
#pragma cdir loopcnt=LOOPCNT
#line 3490
#pragma cdir shortloop
#line 3490
    for (i=0; i<ni; i++) {
#line 3490
      /* the normal case: */
#line 3490
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3490
     /* test for range errors (not always needed but do it anyway) */
#line 3490
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3490
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3490
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3490
    }
#line 3490
   /* copy workspace back if necessary */
#line 3490
    if (realign) {
#line 3490
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3490
      xp = (float *) *xpp;
#line 3490
    }
#line 3490
   /* update xpp and tp */
#line 3490
    xp += ni;
#line 3490
    tp += ni;
#line 3490
    *xpp = (void*)xp;
#line 3490
  }
#line 3490
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3490

#line 3490
#else   /* not SX */
#line 3490

#line 3490
	char *xp = (char *) *xpp;
#line 3490
	int status = NC_NOERR;
#line 3490

#line 3490
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3490
	{
#line 3490
		int lstatus = ncx_put_float_int(xp, tp, fillp);
#line 3490
		if (status == NC_NOERR) /* report the first encountered error */
#line 3490
			status = lstatus;
#line 3490
	}
#line 3490

#line 3490
	*xpp = (void *)xp;
#line 3490
	return status;
#line 3490
#endif
#line 3490
}
#line 3490

int
#line 3491
ncx_putn_float_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3491
{
#line 3491
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3491

#line 3491
 /* basic algorithm is:
#line 3491
  *   - ensure sane alignment of output data
#line 3491
  *   - copy (conversion happens automatically) input data
#line 3491
  *     to output
#line 3491
  *   - update tp to point at next unconverted input, and xpp to point
#line 3491
  *     at next location for converted output
#line 3491
  */
#line 3491
  long i, j, ni;
#line 3491
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3491
  float *xp;
#line 3491
  int nrange = 0;         /* number of range errors */
#line 3491
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3491
  long cxp = (long) *((char**)xpp);
#line 3491

#line 3491
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3491
  /* sjl: manually stripmine so we can limit amount of
#line 3491
   * vector work space reserved to LOOPCNT elements. Also
#line 3491
   * makes vectorisation easy */
#line 3491
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3491
    ni=Min(nelems-j,LOOPCNT);
#line 3491
    if (realign) {
#line 3491
      xp = tmp;
#line 3491
    } else {
#line 3491
      xp = (float *) *xpp;
#line 3491
    }
#line 3491
   /* copy the next block */
#line 3491
#pragma cdir loopcnt=LOOPCNT
#line 3491
#pragma cdir shortloop
#line 3491
    for (i=0; i<ni; i++) {
#line 3491
      /* the normal case: */
#line 3491
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3491
     /* test for range errors (not always needed but do it anyway) */
#line 3491
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3491
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3491
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3491
    }
#line 3491
   /* copy workspace back if necessary */
#line 3491
    if (realign) {
#line 3491
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3491
      xp = (float *) *xpp;
#line 3491
    }
#line 3491
   /* update xpp and tp */
#line 3491
    xp += ni;
#line 3491
    tp += ni;
#line 3491
    *xpp = (void*)xp;
#line 3491
  }
#line 3491
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3491

#line 3491
#else   /* not SX */
#line 3491

#line 3491
	char *xp = (char *) *xpp;
#line 3491
	int status = NC_NOERR;
#line 3491

#line 3491
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3491
	{
#line 3491
		int lstatus = ncx_put_float_long(xp, tp, fillp);
#line 3491
		if (status == NC_NOERR) /* report the first encountered error */
#line 3491
			status = lstatus;
#line 3491
	}
#line 3491

#line 3491
	*xpp = (void *)xp;
#line 3491
	return status;
#line 3491
#endif
#line 3491
}
#line 3491

int
#line 3492
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3492
{
#line 3492
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3492

#line 3492
 /* basic algorithm is:
#line 3492
  *   - ensure sane alignment of output data
#line 3492
  *   - copy (conversion happens automatically) input data
#line 3492
  *     to output
#line 3492
  *   - update tp to point at next unconverted input, and xpp to point
#line 3492
  *     at next location for converted output
#line 3492
  */
#line 3492
  long i, j, ni;
#line 3492
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3492
  float *xp;
#line 3492
  int nrange = 0;         /* number of range errors */
#line 3492
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3492
  long cxp = (long) *((char**)xpp);
#line 3492

#line 3492
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3492
  /* sjl: manually stripmine so we can limit amount of
#line 3492
   * vector work space reserved to LOOPCNT elements. Also
#line 3492
   * makes vectorisation easy */
#line 3492
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3492
    ni=Min(nelems-j,LOOPCNT);
#line 3492
    if (realign) {
#line 3492
      xp = tmp;
#line 3492
    } else {
#line 3492
      xp = (float *) *xpp;
#line 3492
    }
#line 3492
   /* copy the next block */
#line 3492
#pragma cdir loopcnt=LOOPCNT
#line 3492
#pragma cdir shortloop
#line 3492
    for (i=0; i<ni; i++) {
#line 3492
      /* the normal case: */
#line 3492
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3492
     /* test for range errors (not always needed but do it anyway) */
#line 3492
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3492
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3492
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3492
    }
#line 3492
   /* copy workspace back if necessary */
#line 3492
    if (realign) {
#line 3492
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3492
      xp = (float *) *xpp;
#line 3492
    }
#line 3492
   /* update xpp and tp */
#line 3492
    xp += ni;
#line 3492
    tp += ni;
#line 3492
    *xpp = (void*)xp;
#line 3492
  }
#line 3492
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3492

#line 3492
#else   /* not SX */
#line 3492

#line 3492
	char *xp = (char *) *xpp;
#line 3492
	int status = NC_NOERR;
#line 3492

#line 3492
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3492
	{
#line 3492
		int lstatus = ncx_put_float_double(xp, tp, fillp);
#line 3492
		if (status == NC_NOERR) /* report the first encountered error */
#line 3492
			status = lstatus;
#line 3492
	}
#line 3492

#line 3492
	*xpp = (void *)xp;
#line 3492
	return status;
#line 3492
#endif
#line 3492
}
#line 3492

int
#line 3493
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3493
{
#line 3493
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3493

#line 3493
 /* basic algorithm is:
#line 3493
  *   - ensure sane alignment of output data
#line 3493
  *   - copy (conversion happens automatically) input data
#line 3493
  *     to output
#line 3493
  *   - update tp to point at next unconverted input, and xpp to point
#line 3493
  *     at next location for converted output
#line 3493
  */
#line 3493
  long i, j, ni;
#line 3493
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3493
  float *xp;
#line 3493
  int nrange = 0;         /* number of range errors */
#line 3493
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3493
  long cxp = (long) *((char**)xpp);
#line 3493

#line 3493
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3493
  /* sjl: manually stripmine so we can limit amount of
#line 3493
   * vector work space reserved to LOOPCNT elements. Also
#line 3493
   * makes vectorisation easy */
#line 3493
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3493
    ni=Min(nelems-j,LOOPCNT);
#line 3493
    if (realign) {
#line 3493
      xp = tmp;
#line 3493
    } else {
#line 3493
      xp = (float *) *xpp;
#line 3493
    }
#line 3493
   /* copy the next block */
#line 3493
#pragma cdir loopcnt=LOOPCNT
#line 3493
#pragma cdir shortloop
#line 3493
    for (i=0; i<ni; i++) {
#line 3493
      /* the normal case: */
#line 3493
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3493
     /* test for range errors (not always needed but do it anyway) */
#line 3493
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3493
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3493
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3493
    }
#line 3493
   /* copy workspace back if necessary */
#line 3493
    if (realign) {
#line 3493
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3493
      xp = (float *) *xpp;
#line 3493
    }
#line 3493
   /* update xpp and tp */
#line 3493
    xp += ni;
#line 3493
    tp += ni;
#line 3493
    *xpp = (void*)xp;
#line 3493
  }
#line 3493
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3493

#line 3493
#else   /* not SX */
#line 3493

#line 3493
	char *xp = (char *) *xpp;
#line 3493
	int status = NC_NOERR;
#line 3493

#line 3493
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3493
	{
#line 3493
		int lstatus = ncx_put_float_longlong(xp, tp, fillp);
#line 3493
		if (status == NC_NOERR) /* report the first encountered error */
#line 3493
			status = lstatus;
#line 3493
	}
#line 3493

#line 3493
	*xpp = (void *)xp;
#line 3493
	return status;
#line 3493
#endif
#line 3493
}
#line 3493

int
#line 3494
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3494
{
#line 3494
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3494

#line 3494
 /* basic algorithm is:
#line 3494
  *   - ensure sane alignment of output data
#line 3494
  *   - copy (conversion happens automatically) input data
#line 3494
  *     to output
#line 3494
  *   - update tp to point at next unconverted input, and xpp to point
#line 3494
  *     at next location for converted output
#line 3494
  */
#line 3494
  long i, j, ni;
#line 3494
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3494
  float *xp;
#line 3494
  int nrange = 0;         /* number of range errors */
#line 3494
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3494
  long cxp = (long) *((char**)xpp);
#line 3494

#line 3494
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3494
  /* sjl: manually stripmine so we can limit amount of
#line 3494
   * vector work space reserved to LOOPCNT elements. Also
#line 3494
   * makes vectorisation easy */
#line 3494
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3494
    ni=Min(nelems-j,LOOPCNT);
#line 3494
    if (realign) {
#line 3494
      xp = tmp;
#line 3494
    } else {
#line 3494
      xp = (float *) *xpp;
#line 3494
    }
#line 3494
   /* copy the next block */
#line 3494
#pragma cdir loopcnt=LOOPCNT
#line 3494
#pragma cdir shortloop
#line 3494
    for (i=0; i<ni; i++) {
#line 3494
      /* the normal case: */
#line 3494
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3494
     /* test for range errors (not always needed but do it anyway) */
#line 3494
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3494
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3494
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3494
    }
#line 3494
   /* copy workspace back if necessary */
#line 3494
    if (realign) {
#line 3494
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3494
      xp = (float *) *xpp;
#line 3494
    }
#line 3494
   /* update xpp and tp */
#line 3494
    xp += ni;
#line 3494
    tp += ni;
#line 3494
    *xpp = (void*)xp;
#line 3494
  }
#line 3494
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3494

#line 3494
#else   /* not SX */
#line 3494

#line 3494
	char *xp = (char *) *xpp;
#line 3494
	int status = NC_NOERR;
#line 3494

#line 3494
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3494
	{
#line 3494
		int lstatus = ncx_put_float_uchar(xp, tp, fillp);
#line 3494
		if (status == NC_NOERR) /* report the first encountered error */
#line 3494
			status = lstatus;
#line 3494
	}
#line 3494

#line 3494
	*xpp = (void *)xp;
#line 3494
	return status;
#line 3494
#endif
#line 3494
}
#line 3494

int
#line 3495
ncx_putn_float_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3495
{
#line 3495
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3495

#line 3495
 /* basic algorithm is:
#line 3495
  *   - ensure sane alignment of output data
#line 3495
  *   - copy (conversion happens automatically) input data
#line 3495
  *     to output
#line 3495
  *   - update tp to point at next unconverted input, and xpp to point
#line 3495
  *     at next location for converted output
#line 3495
  */
#line 3495
  long i, j, ni;
#line 3495
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3495
  float *xp;
#line 3495
  int nrange = 0;         /* number of range errors */
#line 3495
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3495
  long cxp = (long) *((char**)xpp);
#line 3495

#line 3495
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3495
  /* sjl: manually stripmine so we can limit amount of
#line 3495
   * vector work space reserved to LOOPCNT elements. Also
#line 3495
   * makes vectorisation easy */
#line 3495
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3495
    ni=Min(nelems-j,LOOPCNT);
#line 3495
    if (realign) {
#line 3495
      xp = tmp;
#line 3495
    } else {
#line 3495
      xp = (float *) *xpp;
#line 3495
    }
#line 3495
   /* copy the next block */
#line 3495
#pragma cdir loopcnt=LOOPCNT
#line 3495
#pragma cdir shortloop
#line 3495
    for (i=0; i<ni; i++) {
#line 3495
      /* the normal case: */
#line 3495
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3495
     /* test for range errors (not always needed but do it anyway) */
#line 3495
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3495
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3495
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3495
    }
#line 3495
   /* copy workspace back if necessary */
#line 3495
    if (realign) {
#line 3495
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3495
      xp = (float *) *xpp;
#line 3495
    }
#line 3495
   /* update xpp and tp */
#line 3495
    xp += ni;
#line 3495
    tp += ni;
#line 3495
    *xpp = (void*)xp;
#line 3495
  }
#line 3495
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3495

#line 3495
#else   /* not SX */
#line 3495

#line 3495
	char *xp = (char *) *xpp;
#line 3495
	int status = NC_NOERR;
#line 3495

#line 3495
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3495
	{
#line 3495
		int lstatus = ncx_put_float_ushort(xp, tp, fillp);
#line 3495
		if (status == NC_NOERR) /* report the first encountered error */
#line 3495
			status = lstatus;
#line 3495
	}
#line 3495

#line 3495
	*xpp = (void *)xp;
#line 3495
	return status;
#line 3495
#endif
#line 3495
}
#line 3495

int
#line 3496
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3496
{
#line 3496
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3496

#line 3496
 /* basic algorithm is:
#line 3496
  *   - ensure sane alignment of output data
#line 3496
  *   - copy (conversion happens automatically) input data
#line 3496
  *     to output
#line 3496
  *   - update tp to point at next unconverted input, and xpp to point
#line 3496
  *     at next location for converted output
#line 3496
  */
#line 3496
  long i, j, ni;
#line 3496
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3496
  float *xp;
#line 3496
  int nrange = 0;         /* number of range errors */
#line 3496
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3496
  long cxp = (long) *((char**)xpp);
#line 3496

#line 3496
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3496
  /* sjl: manually stripmine so we can limit amount of
#line 3496
   * vector work space reserved to LOOPCNT elements. Also
#line 3496
   * makes vectorisation easy */
#line 3496
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3496
    ni=Min(nelems-j,LOOPCNT);
#line 3496
    if (realign) {
#line 3496
      xp = tmp;
#line 3496
    } else {
#line 3496
      xp = (float *) *xpp;
#line 3496
    }
#line 3496
   /* copy the next block */
#line 3496
#pragma cdir loopcnt=LOOPCNT
#line 3496
#pragma cdir shortloop
#line 3496
    for (i=0; i<ni; i++) {
#line 3496
      /* the normal case: */
#line 3496
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3496
     /* test for range errors (not always needed but do it anyway) */
#line 3496
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3496
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3496
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3496
    }
#line 3496
   /* copy workspace back if necessary */
#line 3496
    if (realign) {
#line 3496
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3496
      xp = (float *) *xpp;
#line 3496
    }
#line 3496
   /* update xpp and tp */
#line 3496
    xp += ni;
#line 3496
    tp += ni;
#line 3496
    *xpp = (void*)xp;
#line 3496
  }
#line 3496
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3496

#line 3496
#else   /* not SX */
#line 3496

#line 3496
	char *xp = (char *) *xpp;
#line 3496
	int status = NC_NOERR;
#line 3496

#line 3496
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3496
	{
#line 3496
		int lstatus = ncx_put_float_uint(xp, tp, fillp);
#line 3496
		if (status == NC_NOERR) /* report the first encountered error */
#line 3496
			status = lstatus;
#line 3496
	}
#line 3496

#line 3496
	*xpp = (void *)xp;
#line 3496
	return status;
#line 3496
#endif
#line 3496
}
#line 3496

int
#line 3497
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3497
{
#line 3497
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3497

#line 3497
 /* basic algorithm is:
#line 3497
  *   - ensure sane alignment of output data
#line 3497
  *   - copy (conversion happens automatically) input data
#line 3497
  *     to output
#line 3497
  *   - update tp to point at next unconverted input, and xpp to point
#line 3497
  *     at next location for converted output
#line 3497
  */
#line 3497
  long i, j, ni;
#line 3497
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3497
  float *xp;
#line 3497
  int nrange = 0;         /* number of range errors */
#line 3497
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3497
  long cxp = (long) *((char**)xpp);
#line 3497

#line 3497
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3497
  /* sjl: manually stripmine so we can limit amount of
#line 3497
   * vector work space reserved to LOOPCNT elements. Also
#line 3497
   * makes vectorisation easy */
#line 3497
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3497
    ni=Min(nelems-j,LOOPCNT);
#line 3497
    if (realign) {
#line 3497
      xp = tmp;
#line 3497
    } else {
#line 3497
      xp = (float *) *xpp;
#line 3497
    }
#line 3497
   /* copy the next block */
#line 3497
#pragma cdir loopcnt=LOOPCNT
#line 3497
#pragma cdir shortloop
#line 3497
    for (i=0; i<ni; i++) {
#line 3497
      /* the normal case: */
#line 3497
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3497
     /* test for range errors (not always needed but do it anyway) */
#line 3497
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3497
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3497
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3497
    }
#line 3497
   /* copy workspace back if necessary */
#line 3497
    if (realign) {
#line 3497
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3497
      xp = (float *) *xpp;
#line 3497
    }
#line 3497
   /* update xpp and tp */
#line 3497
    xp += ni;
#line 3497
    tp += ni;
#line 3497
    *xpp = (void*)xp;
#line 3497
  }
#line 3497
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3497

#line 3497
#else   /* not SX */
#line 3497

#line 3497
	char *xp = (char *) *xpp;
#line 3497
	int status = NC_NOERR;
#line 3497

#line 3497
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3497
	{
#line 3497
		int lstatus = ncx_put_float_ulonglong(xp, tp, fillp);
#line 3497
		if (status == NC_NOERR) /* report the first encountered error */
#line 3497
			status = lstatus;
#line 3497
	}
#line 3497

#line 3497
	*xpp = (void *)xp;
#line 3497
	return status;
#line 3497
#endif
#line 3497
}
#line 3497


/* double --------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_DOUBLE);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while (ip < end)
	{
	struct vax_double *const vdp =
#line 3522
			 (struct vax_double *)ip;
#line 3522
	const struct ieee_double *const idp =
#line 3522
			 (const struct ieee_double *) (*xpp);
#line 3522
	{
#line 3522
		const struct dbl_limits *lim;
#line 3522
		int ii;
#line 3522
		for (ii = 0, lim = dbl_limits;
#line 3522
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 3522
			ii++, lim++)
#line 3522
		{
#line 3522
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 3522
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 3522
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 3522
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 3522
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 3522
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 3522
				)
#line 3522
			{
#line 3522
				*vdp = lim->d;
#line 3522
				goto doneit;
#line 3522
			}
#line 3522
		}
#line 3522
	}
#line 3522
	{
#line 3522
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 3522
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 3522
	}
#line 3522
	{
#line 3522
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 3522
				 | (idp->mant_5 << 8)
#line 3522
				 | idp->mant_4);
#line 3522
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 3522
		vdp->mantissa1 = (mant_hi >> 13);
#line 3522
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 3522
				| (mant_lo >> 29);
#line 3522
		vdp->mantissa3 = (mant_lo >> 13);
#line 3522
		vdp->mantissa4 = (mant_lo << 3);
#line 3522
	}
#line 3522
	doneit:
#line 3522
		vdp->sign = idp->sign;
#line 3522

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}
#endif
int
#line 3547
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
#line 3547
{
#line 3547
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3547

#line 3547
 /* basic algorithm is:
#line 3547
  *   - ensure sane alignment of input data
#line 3547
  *   - copy (conversion happens automatically) input data
#line 3547
  *     to output
#line 3547
  *   - update xpp to point at next unconverted input, and tp to point
#line 3547
  *     at next location for converted output
#line 3547
  */
#line 3547
  long i, j, ni;
#line 3547
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3547
  double *xp;
#line 3547
  int nrange = 0;         /* number of range errors */
#line 3547
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3547
  long cxp = (long) *((char**)xpp);
#line 3547

#line 3547
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3547
  /* sjl: manually stripmine so we can limit amount of
#line 3547
   * vector work space reserved to LOOPCNT elements. Also
#line 3547
   * makes vectorisation easy */
#line 3547
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3547
    ni=Min(nelems-j,LOOPCNT);
#line 3547
    if (realign) {
#line 3547
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3547
      xp = tmp;
#line 3547
    } else {
#line 3547
      xp = (double *) *xpp;
#line 3547
    }
#line 3547
   /* copy the next block */
#line 3547
#pragma cdir loopcnt=LOOPCNT
#line 3547
#pragma cdir shortloop
#line 3547
    for (i=0; i<ni; i++) {
#line 3547
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3547
     /* test for range errors (not always needed but do it anyway) */
#line 3547
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3547
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3547
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3547
    }
#line 3547
   /* update xpp and tp */
#line 3547
    if (realign) xp = (double *) *xpp;
#line 3547
    xp += ni;
#line 3547
    tp += ni;
#line 3547
    *xpp = (void*)xp;
#line 3547
  }
#line 3547
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3547

#line 3547
#else   /* not SX */
#line 3547
	const char *xp = (const char *) *xpp;
#line 3547
	int status = NC_NOERR;
#line 3547

#line 3547
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3547
	{
#line 3547
		const int lstatus = ncx_get_double_schar(xp, tp);
#line 3547
		if (status == NC_NOERR) /* report the first encountered error */
#line 3547
			status = lstatus;
#line 3547
	}
#line 3547

#line 3547
	*xpp = (const void *)xp;
#line 3547
	return status;
#line 3547
#endif
#line 3547
}
#line 3547

int
#line 3548
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
#line 3548
{
#line 3548
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3548

#line 3548
 /* basic algorithm is:
#line 3548
  *   - ensure sane alignment of input data
#line 3548
  *   - copy (conversion happens automatically) input data
#line 3548
  *     to output
#line 3548
  *   - update xpp to point at next unconverted input, and tp to point
#line 3548
  *     at next location for converted output
#line 3548
  */
#line 3548
  long i, j, ni;
#line 3548
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3548
  double *xp;
#line 3548
  int nrange = 0;         /* number of range errors */
#line 3548
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3548
  long cxp = (long) *((char**)xpp);
#line 3548

#line 3548
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3548
  /* sjl: manually stripmine so we can limit amount of
#line 3548
   * vector work space reserved to LOOPCNT elements. Also
#line 3548
   * makes vectorisation easy */
#line 3548
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3548
    ni=Min(nelems-j,LOOPCNT);
#line 3548
    if (realign) {
#line 3548
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3548
      xp = tmp;
#line 3548
    } else {
#line 3548
      xp = (double *) *xpp;
#line 3548
    }
#line 3548
   /* copy the next block */
#line 3548
#pragma cdir loopcnt=LOOPCNT
#line 3548
#pragma cdir shortloop
#line 3548
    for (i=0; i<ni; i++) {
#line 3548
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3548
     /* test for range errors (not always needed but do it anyway) */
#line 3548
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3548
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3548
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3548
    }
#line 3548
   /* update xpp and tp */
#line 3548
    if (realign) xp = (double *) *xpp;
#line 3548
    xp += ni;
#line 3548
    tp += ni;
#line 3548
    *xpp = (void*)xp;
#line 3548
  }
#line 3548
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3548

#line 3548
#else   /* not SX */
#line 3548
	const char *xp = (const char *) *xpp;
#line 3548
	int status = NC_NOERR;
#line 3548

#line 3548
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3548
	{
#line 3548
		const int lstatus = ncx_get_double_short(xp, tp);
#line 3548
		if (status == NC_NOERR) /* report the first encountered error */
#line 3548
			status = lstatus;
#line 3548
	}
#line 3548

#line 3548
	*xpp = (const void *)xp;
#line 3548
	return status;
#line 3548
#endif
#line 3548
}
#line 3548

int
#line 3549
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
#line 3549
{
#line 3549
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3549

#line 3549
 /* basic algorithm is:
#line 3549
  *   - ensure sane alignment of input data
#line 3549
  *   - copy (conversion happens automatically) input data
#line 3549
  *     to output
#line 3549
  *   - update xpp to point at next unconverted input, and tp to point
#line 3549
  *     at next location for converted output
#line 3549
  */
#line 3549
  long i, j, ni;
#line 3549
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3549
  double *xp;
#line 3549
  int nrange = 0;         /* number of range errors */
#line 3549
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3549
  long cxp = (long) *((char**)xpp);
#line 3549

#line 3549
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3549
  /* sjl: manually stripmine so we can limit amount of
#line 3549
   * vector work space reserved to LOOPCNT elements. Also
#line 3549
   * makes vectorisation easy */
#line 3549
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3549
    ni=Min(nelems-j,LOOPCNT);
#line 3549
    if (realign) {
#line 3549
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3549
      xp = tmp;
#line 3549
    } else {
#line 3549
      xp = (double *) *xpp;
#line 3549
    }
#line 3549
   /* copy the next block */
#line 3549
#pragma cdir loopcnt=LOOPCNT
#line 3549
#pragma cdir shortloop
#line 3549
    for (i=0; i<ni; i++) {
#line 3549
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3549
     /* test for range errors (not always needed but do it anyway) */
#line 3549
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3549
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3549
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3549
    }
#line 3549
   /* update xpp and tp */
#line 3549
    if (realign) xp = (double *) *xpp;
#line 3549
    xp += ni;
#line 3549
    tp += ni;
#line 3549
    *xpp = (void*)xp;
#line 3549
  }
#line 3549
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3549

#line 3549
#else   /* not SX */
#line 3549
	const char *xp = (const char *) *xpp;
#line 3549
	int status = NC_NOERR;
#line 3549

#line 3549
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3549
	{
#line 3549
		const int lstatus = ncx_get_double_int(xp, tp);
#line 3549
		if (status == NC_NOERR) /* report the first encountered error */
#line 3549
			status = lstatus;
#line 3549
	}
#line 3549

#line 3549
	*xpp = (const void *)xp;
#line 3549
	return status;
#line 3549
#endif
#line 3549
}
#line 3549

int
#line 3550
ncx_getn_double_long(const void **xpp, size_t nelems, long *tp)
#line 3550
{
#line 3550
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3550

#line 3550
 /* basic algorithm is:
#line 3550
  *   - ensure sane alignment of input data
#line 3550
  *   - copy (conversion happens automatically) input data
#line 3550
  *     to output
#line 3550
  *   - update xpp to point at next unconverted input, and tp to point
#line 3550
  *     at next location for converted output
#line 3550
  */
#line 3550
  long i, j, ni;
#line 3550
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3550
  double *xp;
#line 3550
  int nrange = 0;         /* number of range errors */
#line 3550
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3550
  long cxp = (long) *((char**)xpp);
#line 3550

#line 3550
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3550
  /* sjl: manually stripmine so we can limit amount of
#line 3550
   * vector work space reserved to LOOPCNT elements. Also
#line 3550
   * makes vectorisation easy */
#line 3550
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3550
    ni=Min(nelems-j,LOOPCNT);
#line 3550
    if (realign) {
#line 3550
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3550
      xp = tmp;
#line 3550
    } else {
#line 3550
      xp = (double *) *xpp;
#line 3550
    }
#line 3550
   /* copy the next block */
#line 3550
#pragma cdir loopcnt=LOOPCNT
#line 3550
#pragma cdir shortloop
#line 3550
    for (i=0; i<ni; i++) {
#line 3550
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3550
     /* test for range errors (not always needed but do it anyway) */
#line 3550
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3550
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3550
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3550
    }
#line 3550
   /* update xpp and tp */
#line 3550
    if (realign) xp = (double *) *xpp;
#line 3550
    xp += ni;
#line 3550
    tp += ni;
#line 3550
    *xpp = (void*)xp;
#line 3550
  }
#line 3550
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3550

#line 3550
#else   /* not SX */
#line 3550
	const char *xp = (const char *) *xpp;
#line 3550
	int status = NC_NOERR;
#line 3550

#line 3550
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3550
	{
#line 3550
		const int lstatus = ncx_get_double_long(xp, tp);
#line 3550
		if (status == NC_NOERR) /* report the first encountered error */
#line 3550
			status = lstatus;
#line 3550
	}
#line 3550

#line 3550
	*xpp = (const void *)xp;
#line 3550
	return status;
#line 3550
#endif
#line 3550
}
#line 3550

int
#line 3551
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
#line 3551
{
#line 3551
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3551

#line 3551
 /* basic algorithm is:
#line 3551
  *   - ensure sane alignment of input data
#line 3551
  *   - copy (conversion happens automatically) input data
#line 3551
  *     to output
#line 3551
  *   - update xpp to point at next unconverted input, and tp to point
#line 3551
  *     at next location for converted output
#line 3551
  */
#line 3551
  long i, j, ni;
#line 3551
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3551
  double *xp;
#line 3551
  int nrange = 0;         /* number of range errors */
#line 3551
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3551
  long cxp = (long) *((char**)xpp);
#line 3551

#line 3551
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3551
  /* sjl: manually stripmine so we can limit amount of
#line 3551
   * vector work space reserved to LOOPCNT elements. Also
#line 3551
   * makes vectorisation easy */
#line 3551
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3551
    ni=Min(nelems-j,LOOPCNT);
#line 3551
    if (realign) {
#line 3551
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3551
      xp = tmp;
#line 3551
    } else {
#line 3551
      xp = (double *) *xpp;
#line 3551
    }
#line 3551
   /* copy the next block */
#line 3551
#pragma cdir loopcnt=LOOPCNT
#line 3551
#pragma cdir shortloop
#line 3551
    for (i=0; i<ni; i++) {
#line 3551
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3551
     /* test for range errors (not always needed but do it anyway) */
#line 3551
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3551
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3551
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3551
    }
#line 3551
   /* update xpp and tp */
#line 3551
    if (realign) xp = (double *) *xpp;
#line 3551
    xp += ni;
#line 3551
    tp += ni;
#line 3551
    *xpp = (void*)xp;
#line 3551
  }
#line 3551
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3551

#line 3551
#else   /* not SX */
#line 3551
	const char *xp = (const char *) *xpp;
#line 3551
	int status = NC_NOERR;
#line 3551

#line 3551
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3551
	{
#line 3551
		const int lstatus = ncx_get_double_float(xp, tp);
#line 3551
		if (status == NC_NOERR) /* report the first encountered error */
#line 3551
			status = lstatus;
#line 3551
	}
#line 3551

#line 3551
	*xpp = (const void *)xp;
#line 3551
	return status;
#line 3551
#endif
#line 3551
}
#line 3551

int
#line 3552
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3552
{
#line 3552
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3552

#line 3552
 /* basic algorithm is:
#line 3552
  *   - ensure sane alignment of input data
#line 3552
  *   - copy (conversion happens automatically) input data
#line 3552
  *     to output
#line 3552
  *   - update xpp to point at next unconverted input, and tp to point
#line 3552
  *     at next location for converted output
#line 3552
  */
#line 3552
  long i, j, ni;
#line 3552
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3552
  double *xp;
#line 3552
  int nrange = 0;         /* number of range errors */
#line 3552
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3552
  long cxp = (long) *((char**)xpp);
#line 3552

#line 3552
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3552
  /* sjl: manually stripmine so we can limit amount of
#line 3552
   * vector work space reserved to LOOPCNT elements. Also
#line 3552
   * makes vectorisation easy */
#line 3552
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3552
    ni=Min(nelems-j,LOOPCNT);
#line 3552
    if (realign) {
#line 3552
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3552
      xp = tmp;
#line 3552
    } else {
#line 3552
      xp = (double *) *xpp;
#line 3552
    }
#line 3552
   /* copy the next block */
#line 3552
#pragma cdir loopcnt=LOOPCNT
#line 3552
#pragma cdir shortloop
#line 3552
    for (i=0; i<ni; i++) {
#line 3552
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3552
     /* test for range errors (not always needed but do it anyway) */
#line 3552
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3552
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3552
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3552
    }
#line 3552
   /* update xpp and tp */
#line 3552
    if (realign) xp = (double *) *xpp;
#line 3552
    xp += ni;
#line 3552
    tp += ni;
#line 3552
    *xpp = (void*)xp;
#line 3552
  }
#line 3552
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3552

#line 3552
#else   /* not SX */
#line 3552
	const char *xp = (const char *) *xpp;
#line 3552
	int status = NC_NOERR;
#line 3552

#line 3552
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3552
	{
#line 3552
		const int lstatus = ncx_get_double_longlong(xp, tp);
#line 3552
		if (status == NC_NOERR) /* report the first encountered error */
#line 3552
			status = lstatus;
#line 3552
	}
#line 3552

#line 3552
	*xpp = (const void *)xp;
#line 3552
	return status;
#line 3552
#endif
#line 3552
}
#line 3552

int
#line 3553
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3553
{
#line 3553
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3553

#line 3553
 /* basic algorithm is:
#line 3553
  *   - ensure sane alignment of input data
#line 3553
  *   - copy (conversion happens automatically) input data
#line 3553
  *     to output
#line 3553
  *   - update xpp to point at next unconverted input, and tp to point
#line 3553
  *     at next location for converted output
#line 3553
  */
#line 3553
  long i, j, ni;
#line 3553
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3553
  double *xp;
#line 3553
  int nrange = 0;         /* number of range errors */
#line 3553
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3553
  long cxp = (long) *((char**)xpp);
#line 3553

#line 3553
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3553
  /* sjl: manually stripmine so we can limit amount of
#line 3553
   * vector work space reserved to LOOPCNT elements. Also
#line 3553
   * makes vectorisation easy */
#line 3553
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3553
    ni=Min(nelems-j,LOOPCNT);
#line 3553
    if (realign) {
#line 3553
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3553
      xp = tmp;
#line 3553
    } else {
#line 3553
      xp = (double *) *xpp;
#line 3553
    }
#line 3553
   /* copy the next block */
#line 3553
#pragma cdir loopcnt=LOOPCNT
#line 3553
#pragma cdir shortloop
#line 3553
    for (i=0; i<ni; i++) {
#line 3553
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3553
     /* test for range errors (not always needed but do it anyway) */
#line 3553
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3553
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3553
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3553
    }
#line 3553
   /* update xpp and tp */
#line 3553
    if (realign) xp = (double *) *xpp;
#line 3553
    xp += ni;
#line 3553
    tp += ni;
#line 3553
    *xpp = (void*)xp;
#line 3553
  }
#line 3553
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3553

#line 3553
#else   /* not SX */
#line 3553
	const char *xp = (const char *) *xpp;
#line 3553
	int status = NC_NOERR;
#line 3553

#line 3553
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3553
	{
#line 3553
		const int lstatus = ncx_get_double_uchar(xp, tp);
#line 3553
		if (status == NC_NOERR) /* report the first encountered error */
#line 3553
			status = lstatus;
#line 3553
	}
#line 3553

#line 3553
	*xpp = (const void *)xp;
#line 3553
	return status;
#line 3553
#endif
#line 3553
}
#line 3553

int
#line 3554
ncx_getn_double_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3554
{
#line 3554
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3554

#line 3554
 /* basic algorithm is:
#line 3554
  *   - ensure sane alignment of input data
#line 3554
  *   - copy (conversion happens automatically) input data
#line 3554
  *     to output
#line 3554
  *   - update xpp to point at next unconverted input, and tp to point
#line 3554
  *     at next location for converted output
#line 3554
  */
#line 3554
  long i, j, ni;
#line 3554
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3554
  double *xp;
#line 3554
  int nrange = 0;         /* number of range errors */
#line 3554
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3554
  long cxp = (long) *((char**)xpp);
#line 3554

#line 3554
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3554
  /* sjl: manually stripmine so we can limit amount of
#line 3554
   * vector work space reserved to LOOPCNT elements. Also
#line 3554
   * makes vectorisation easy */
#line 3554
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3554
    ni=Min(nelems-j,LOOPCNT);
#line 3554
    if (realign) {
#line 3554
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3554
      xp = tmp;
#line 3554
    } else {
#line 3554
      xp = (double *) *xpp;
#line 3554
    }
#line 3554
   /* copy the next block */
#line 3554
#pragma cdir loopcnt=LOOPCNT
#line 3554
#pragma cdir shortloop
#line 3554
    for (i=0; i<ni; i++) {
#line 3554
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3554
     /* test for range errors (not always needed but do it anyway) */
#line 3554
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3554
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3554
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3554
    }
#line 3554
   /* update xpp and tp */
#line 3554
    if (realign) xp = (double *) *xpp;
#line 3554
    xp += ni;
#line 3554
    tp += ni;
#line 3554
    *xpp = (void*)xp;
#line 3554
  }
#line 3554
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3554

#line 3554
#else   /* not SX */
#line 3554
	const char *xp = (const char *) *xpp;
#line 3554
	int status = NC_NOERR;
#line 3554

#line 3554
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3554
	{
#line 3554
		const int lstatus = ncx_get_double_ushort(xp, tp);
#line 3554
		if (status == NC_NOERR) /* report the first encountered error */
#line 3554
			status = lstatus;
#line 3554
	}
#line 3554

#line 3554
	*xpp = (const void *)xp;
#line 3554
	return status;
#line 3554
#endif
#line 3554
}
#line 3554

int
#line 3555
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
#line 3555
{
#line 3555
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3555

#line 3555
 /* basic algorithm is:
#line 3555
  *   - ensure sane alignment of input data
#line 3555
  *   - copy (conversion happens automatically) input data
#line 3555
  *     to output
#line 3555
  *   - update xpp to point at next unconverted input, and tp to point
#line 3555
  *     at next location for converted output
#line 3555
  */
#line 3555
  long i, j, ni;
#line 3555
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3555
  double *xp;
#line 3555
  int nrange = 0;         /* number of range errors */
#line 3555
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3555
  long cxp = (long) *((char**)xpp);
#line 3555

#line 3555
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3555
  /* sjl: manually stripmine so we can limit amount of
#line 3555
   * vector work space reserved to LOOPCNT elements. Also
#line 3555
   * makes vectorisation easy */
#line 3555
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3555
    ni=Min(nelems-j,LOOPCNT);
#line 3555
    if (realign) {
#line 3555
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3555
      xp = tmp;
#line 3555
    } else {
#line 3555
      xp = (double *) *xpp;
#line 3555
    }
#line 3555
   /* copy the next block */
#line 3555
#pragma cdir loopcnt=LOOPCNT
#line 3555
#pragma cdir shortloop
#line 3555
    for (i=0; i<ni; i++) {
#line 3555
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3555
     /* test for range errors (not always needed but do it anyway) */
#line 3555
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3555
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3555
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3555
    }
#line 3555
   /* update xpp and tp */
#line 3555
    if (realign) xp = (double *) *xpp;
#line 3555
    xp += ni;
#line 3555
    tp += ni;
#line 3555
    *xpp = (void*)xp;
#line 3555
  }
#line 3555
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3555

#line 3555
#else   /* not SX */
#line 3555
	const char *xp = (const char *) *xpp;
#line 3555
	int status = NC_NOERR;
#line 3555

#line 3555
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3555
	{
#line 3555
		const int lstatus = ncx_get_double_uint(xp, tp);
#line 3555
		if (status == NC_NOERR) /* report the first encountered error */
#line 3555
			status = lstatus;
#line 3555
	}
#line 3555

#line 3555
	*xpp = (const void *)xp;
#line 3555
	return status;
#line 3555
#endif
#line 3555
}
#line 3555

int
#line 3556
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3556
{
#line 3556
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3556

#line 3556
 /* basic algorithm is:
#line 3556
  *   - ensure sane alignment of input data
#line 3556
  *   - copy (conversion happens automatically) input data
#line 3556
  *     to output
#line 3556
  *   - update xpp to point at next unconverted input, and tp to point
#line 3556
  *     at next location for converted output
#line 3556
  */
#line 3556
  long i, j, ni;
#line 3556
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3556
  double *xp;
#line 3556
  int nrange = 0;         /* number of range errors */
#line 3556
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3556
  long cxp = (long) *((char**)xpp);
#line 3556

#line 3556
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3556
  /* sjl: manually stripmine so we can limit amount of
#line 3556
   * vector work space reserved to LOOPCNT elements. Also
#line 3556
   * makes vectorisation easy */
#line 3556
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3556
    ni=Min(nelems-j,LOOPCNT);
#line 3556
    if (realign) {
#line 3556
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3556
      xp = tmp;
#line 3556
    } else {
#line 3556
      xp = (double *) *xpp;
#line 3556
    }
#line 3556
   /* copy the next block */
#line 3556
#pragma cdir loopcnt=LOOPCNT
#line 3556
#pragma cdir shortloop
#line 3556
    for (i=0; i<ni; i++) {
#line 3556
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3556
     /* test for range errors (not always needed but do it anyway) */
#line 3556
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3556
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3556
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3556
    }
#line 3556
   /* update xpp and tp */
#line 3556
    if (realign) xp = (double *) *xpp;
#line 3556
    xp += ni;
#line 3556
    tp += ni;
#line 3556
    *xpp = (void*)xp;
#line 3556
  }
#line 3556
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3556

#line 3556
#else   /* not SX */
#line 3556
	const char *xp = (const char *) *xpp;
#line 3556
	int status = NC_NOERR;
#line 3556

#line 3556
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3556
	{
#line 3556
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
#line 3556
		if (status == NC_NOERR) /* report the first encountered error */
#line 3556
			status = lstatus;
#line 3556
	}
#line 3556

#line 3556
	*xpp = (const void *)xp;
#line 3556
	return status;
#line 3556
#endif
#line 3556
}
#line 3556


#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip, void *fillp)
{
	const double *const end = ip + ndoubles;

	while (ip < end)
	{
	const struct vax_double *const vdp =
#line 3579
			(const struct vax_double *)ip;
#line 3579
	struct ieee_double *const idp =
#line 3579
			 (struct ieee_double *) (*xpp);
#line 3579

#line 3579
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 3579
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 3579
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 3579
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 3579
		(vdp->exp == dbl_limits[0].d.exp))
#line 3579
	{
#line 3579
		*idp = dbl_limits[0].ieee;
#line 3579
		goto shipit;
#line 3579
	}
#line 3579
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 3579
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 3579
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 3579
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 3579
		(vdp->exp == dbl_limits[1].d.exp))
#line 3579
	{
#line 3579
		*idp = dbl_limits[1].ieee;
#line 3579
		goto shipit;
#line 3579
	}
#line 3579

#line 3579
	{
#line 3579
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 3579

#line 3579
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 3579
			(vdp->mantissa3 << 13) |
#line 3579
			((vdp->mantissa4 >> 3) & MASK(13));
#line 3579

#line 3579
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 3579
				 | (vdp->mantissa2 >> 3);
#line 3579

#line 3579
		if ((vdp->mantissa4 & 7) > 4)
#line 3579
		{
#line 3579
			/* round up */
#line 3579
			mant_lo++;
#line 3579
			if (mant_lo == 0)
#line 3579
			{
#line 3579
				mant_hi++;
#line 3579
				if (mant_hi > 0xffffff)
#line 3579
				{
#line 3579
					mant_hi = 0;
#line 3579
					exp++;
#line 3579
				}
#line 3579
			}
#line 3579
		}
#line 3579

#line 3579
		idp->mant_lo = SWAP4(mant_lo);
#line 3579
		idp->mant_6 = mant_hi >> 16;
#line 3579
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 3579
		idp->mant_4 = mant_hi;
#line 3579
		idp->exp_hi = exp >> 4;
#line 3579
		idp->exp_lo = exp;
#line 3579
	}
#line 3579

#line 3579
	shipit:
#line 3579
		idp->sign = vdp->sign;
#line 3579

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3604
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3604
{
#line 3604
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3604

#line 3604
 /* basic algorithm is:
#line 3604
  *   - ensure sane alignment of output data
#line 3604
  *   - copy (conversion happens automatically) input data
#line 3604
  *     to output
#line 3604
  *   - update tp to point at next unconverted input, and xpp to point
#line 3604
  *     at next location for converted output
#line 3604
  */
#line 3604
  long i, j, ni;
#line 3604
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3604
  double *xp;
#line 3604
  int nrange = 0;         /* number of range errors */
#line 3604
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3604
  long cxp = (long) *((char**)xpp);
#line 3604

#line 3604
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3604
  /* sjl: manually stripmine so we can limit amount of
#line 3604
   * vector work space reserved to LOOPCNT elements. Also
#line 3604
   * makes vectorisation easy */
#line 3604
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3604
    ni=Min(nelems-j,LOOPCNT);
#line 3604
    if (realign) {
#line 3604
      xp = tmp;
#line 3604
    } else {
#line 3604
      xp = (double *) *xpp;
#line 3604
    }
#line 3604
   /* copy the next block */
#line 3604
#pragma cdir loopcnt=LOOPCNT
#line 3604
#pragma cdir shortloop
#line 3604
    for (i=0; i<ni; i++) {
#line 3604
      /* the normal case: */
#line 3604
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3604
     /* test for range errors (not always needed but do it anyway) */
#line 3604
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3604
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3604
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3604
    }
#line 3604
   /* copy workspace back if necessary */
#line 3604
    if (realign) {
#line 3604
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3604
      xp = (double *) *xpp;
#line 3604
    }
#line 3604
   /* update xpp and tp */
#line 3604
    xp += ni;
#line 3604
    tp += ni;
#line 3604
    *xpp = (void*)xp;
#line 3604
  }
#line 3604
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3604

#line 3604
#else   /* not SX */
#line 3604

#line 3604
	char *xp = (char *) *xpp;
#line 3604
	int status = NC_NOERR;
#line 3604

#line 3604
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3604
	{
#line 3604
		int lstatus = ncx_put_double_schar(xp, tp, fillp);
#line 3604
		if (status == NC_NOERR) /* report the first encountered error */
#line 3604
			status = lstatus;
#line 3604
	}
#line 3604

#line 3604
	*xpp = (void *)xp;
#line 3604
	return status;
#line 3604
#endif
#line 3604
}
#line 3604

int
#line 3605
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3605
{
#line 3605
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3605

#line 3605
 /* basic algorithm is:
#line 3605
  *   - ensure sane alignment of output data
#line 3605
  *   - copy (conversion happens automatically) input data
#line 3605
  *     to output
#line 3605
  *   - update tp to point at next unconverted input, and xpp to point
#line 3605
  *     at next location for converted output
#line 3605
  */
#line 3605
  long i, j, ni;
#line 3605
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3605
  double *xp;
#line 3605
  int nrange = 0;         /* number of range errors */
#line 3605
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3605
  long cxp = (long) *((char**)xpp);
#line 3605

#line 3605
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3605
  /* sjl: manually stripmine so we can limit amount of
#line 3605
   * vector work space reserved to LOOPCNT elements. Also
#line 3605
   * makes vectorisation easy */
#line 3605
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3605
    ni=Min(nelems-j,LOOPCNT);
#line 3605
    if (realign) {
#line 3605
      xp = tmp;
#line 3605
    } else {
#line 3605
      xp = (double *) *xpp;
#line 3605
    }
#line 3605
   /* copy the next block */
#line 3605
#pragma cdir loopcnt=LOOPCNT
#line 3605
#pragma cdir shortloop
#line 3605
    for (i=0; i<ni; i++) {
#line 3605
      /* the normal case: */
#line 3605
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3605
     /* test for range errors (not always needed but do it anyway) */
#line 3605
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3605
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3605
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3605
    }
#line 3605
   /* copy workspace back if necessary */
#line 3605
    if (realign) {
#line 3605
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3605
      xp = (double *) *xpp;
#line 3605
    }
#line 3605
   /* update xpp and tp */
#line 3605
    xp += ni;
#line 3605
    tp += ni;
#line 3605
    *xpp = (void*)xp;
#line 3605
  }
#line 3605
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3605

#line 3605
#else   /* not SX */
#line 3605

#line 3605
	char *xp = (char *) *xpp;
#line 3605
	int status = NC_NOERR;
#line 3605

#line 3605
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3605
	{
#line 3605
		int lstatus = ncx_put_double_short(xp, tp, fillp);
#line 3605
		if (status == NC_NOERR) /* report the first encountered error */
#line 3605
			status = lstatus;
#line 3605
	}
#line 3605

#line 3605
	*xpp = (void *)xp;
#line 3605
	return status;
#line 3605
#endif
#line 3605
}
#line 3605

int
#line 3606
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3606
{
#line 3606
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3606

#line 3606
 /* basic algorithm is:
#line 3606
  *   - ensure sane alignment of output data
#line 3606
  *   - copy (conversion happens automatically) input data
#line 3606
  *     to output
#line 3606
  *   - update tp to point at next unconverted input, and xpp to point
#line 3606
  *     at next location for converted output
#line 3606
  */
#line 3606
  long i, j, ni;
#line 3606
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3606
  double *xp;
#line 3606
  int nrange = 0;         /* number of range errors */
#line 3606
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3606
  long cxp = (long) *((char**)xpp);
#line 3606

#line 3606
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3606
  /* sjl: manually stripmine so we can limit amount of
#line 3606
   * vector work space reserved to LOOPCNT elements. Also
#line 3606
   * makes vectorisation easy */
#line 3606
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3606
    ni=Min(nelems-j,LOOPCNT);
#line 3606
    if (realign) {
#line 3606
      xp = tmp;
#line 3606
    } else {
#line 3606
      xp = (double *) *xpp;
#line 3606
    }
#line 3606
   /* copy the next block */
#line 3606
#pragma cdir loopcnt=LOOPCNT
#line 3606
#pragma cdir shortloop
#line 3606
    for (i=0; i<ni; i++) {
#line 3606
      /* the normal case: */
#line 3606
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3606
     /* test for range errors (not always needed but do it anyway) */
#line 3606
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3606
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3606
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3606
    }
#line 3606
   /* copy workspace back if necessary */
#line 3606
    if (realign) {
#line 3606
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3606
      xp = (double *) *xpp;
#line 3606
    }
#line 3606
   /* update xpp and tp */
#line 3606
    xp += ni;
#line 3606
    tp += ni;
#line 3606
    *xpp = (void*)xp;
#line 3606
  }
#line 3606
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3606

#line 3606
#else   /* not SX */
#line 3606

#line 3606
	char *xp = (char *) *xpp;
#line 3606
	int status = NC_NOERR;
#line 3606

#line 3606
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3606
	{
#line 3606
		int lstatus = ncx_put_double_int(xp, tp, fillp);
#line 3606
		if (status == NC_NOERR) /* report the first encountered error */
#line 3606
			status = lstatus;
#line 3606
	}
#line 3606

#line 3606
	*xpp = (void *)xp;
#line 3606
	return status;
#line 3606
#endif
#line 3606
}
#line 3606

int
#line 3607
ncx_putn_double_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3607
{
#line 3607
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3607

#line 3607
 /* basic algorithm is:
#line 3607
  *   - ensure sane alignment of output data
#line 3607
  *   - copy (conversion happens automatically) input data
#line 3607
  *     to output
#line 3607
  *   - update tp to point at next unconverted input, and xpp to point
#line 3607
  *     at next location for converted output
#line 3607
  */
#line 3607
  long i, j, ni;
#line 3607
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3607
  double *xp;
#line 3607
  int nrange = 0;         /* number of range errors */
#line 3607
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3607
  long cxp = (long) *((char**)xpp);
#line 3607

#line 3607
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3607
  /* sjl: manually stripmine so we can limit amount of
#line 3607
   * vector work space reserved to LOOPCNT elements. Also
#line 3607
   * makes vectorisation easy */
#line 3607
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3607
    ni=Min(nelems-j,LOOPCNT);
#line 3607
    if (realign) {
#line 3607
      xp = tmp;
#line 3607
    } else {
#line 3607
      xp = (double *) *xpp;
#line 3607
    }
#line 3607
   /* copy the next block */
#line 3607
#pragma cdir loopcnt=LOOPCNT
#line 3607
#pragma cdir shortloop
#line 3607
    for (i=0; i<ni; i++) {
#line 3607
      /* the normal case: */
#line 3607
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3607
     /* test for range errors (not always needed but do it anyway) */
#line 3607
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3607
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3607
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3607
    }
#line 3607
   /* copy workspace back if necessary */
#line 3607
    if (realign) {
#line 3607
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3607
      xp = (double *) *xpp;
#line 3607
    }
#line 3607
   /* update xpp and tp */
#line 3607
    xp += ni;
#line 3607
    tp += ni;
#line 3607
    *xpp = (void*)xp;
#line 3607
  }
#line 3607
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3607

#line 3607
#else   /* not SX */
#line 3607

#line 3607
	char *xp = (char *) *xpp;
#line 3607
	int status = NC_NOERR;
#line 3607

#line 3607
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3607
	{
#line 3607
		int lstatus = ncx_put_double_long(xp, tp, fillp);
#line 3607
		if (status == NC_NOERR) /* report the first encountered error */
#line 3607
			status = lstatus;
#line 3607
	}
#line 3607

#line 3607
	*xpp = (void *)xp;
#line 3607
	return status;
#line 3607
#endif
#line 3607
}
#line 3607

int
#line 3608
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3608
{
#line 3608
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3608

#line 3608
 /* basic algorithm is:
#line 3608
  *   - ensure sane alignment of output data
#line 3608
  *   - copy (conversion happens automatically) input data
#line 3608
  *     to output
#line 3608
  *   - update tp to point at next unconverted input, and xpp to point
#line 3608
  *     at next location for converted output
#line 3608
  */
#line 3608
  long i, j, ni;
#line 3608
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3608
  double *xp;
#line 3608
  int nrange = 0;         /* number of range errors */
#line 3608
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3608
  long cxp = (long) *((char**)xpp);
#line 3608

#line 3608
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3608
  /* sjl: manually stripmine so we can limit amount of
#line 3608
   * vector work space reserved to LOOPCNT elements. Also
#line 3608
   * makes vectorisation easy */
#line 3608
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3608
    ni=Min(nelems-j,LOOPCNT);
#line 3608
    if (realign) {
#line 3608
      xp = tmp;
#line 3608
    } else {
#line 3608
      xp = (double *) *xpp;
#line 3608
    }
#line 3608
   /* copy the next block */
#line 3608
#pragma cdir loopcnt=LOOPCNT
#line 3608
#pragma cdir shortloop
#line 3608
    for (i=0; i<ni; i++) {
#line 3608
      /* the normal case: */
#line 3608
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3608
     /* test for range errors (not always needed but do it anyway) */
#line 3608
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3608
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3608
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3608
    }
#line 3608
   /* copy workspace back if necessary */
#line 3608
    if (realign) {
#line 3608
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3608
      xp = (double *) *xpp;
#line 3608
    }
#line 3608
   /* update xpp and tp */
#line 3608
    xp += ni;
#line 3608
    tp += ni;
#line 3608
    *xpp = (void*)xp;
#line 3608
  }
#line 3608
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3608

#line 3608
#else   /* not SX */
#line 3608

#line 3608
	char *xp = (char *) *xpp;
#line 3608
	int status = NC_NOERR;
#line 3608

#line 3608
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3608
	{
#line 3608
		int lstatus = ncx_put_double_float(xp, tp, fillp);
#line 3608
		if (status == NC_NOERR) /* report the first encountered error */
#line 3608
			status = lstatus;
#line 3608
	}
#line 3608

#line 3608
	*xpp = (void *)xp;
#line 3608
	return status;
#line 3608
#endif
#line 3608
}
#line 3608

int
#line 3609
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3609
{
#line 3609
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3609

#line 3609
 /* basic algorithm is:
#line 3609
  *   - ensure sane alignment of output data
#line 3609
  *   - copy (conversion happens automatically) input data
#line 3609
  *     to output
#line 3609
  *   - update tp to point at next unconverted input, and xpp to point
#line 3609
  *     at next location for converted output
#line 3609
  */
#line 3609
  long i, j, ni;
#line 3609
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3609
  double *xp;
#line 3609
  int nrange = 0;         /* number of range errors */
#line 3609
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3609
  long cxp = (long) *((char**)xpp);
#line 3609

#line 3609
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3609
  /* sjl: manually stripmine so we can limit amount of
#line 3609
   * vector work space reserved to LOOPCNT elements. Also
#line 3609
   * makes vectorisation easy */
#line 3609
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3609
    ni=Min(nelems-j,LOOPCNT);
#line 3609
    if (realign) {
#line 3609
      xp = tmp;
#line 3609
    } else {
#line 3609
      xp = (double *) *xpp;
#line 3609
    }
#line 3609
   /* copy the next block */
#line 3609
#pragma cdir loopcnt=LOOPCNT
#line 3609
#pragma cdir shortloop
#line 3609
    for (i=0; i<ni; i++) {
#line 3609
      /* the normal case: */
#line 3609
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3609
     /* test for range errors (not always needed but do it anyway) */
#line 3609
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3609
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3609
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3609
    }
#line 3609
   /* copy workspace back if necessary */
#line 3609
    if (realign) {
#line 3609
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3609
      xp = (double *) *xpp;
#line 3609
    }
#line 3609
   /* update xpp and tp */
#line 3609
    xp += ni;
#line 3609
    tp += ni;
#line 3609
    *xpp = (void*)xp;
#line 3609
  }
#line 3609
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3609

#line 3609
#else   /* not SX */
#line 3609

#line 3609
	char *xp = (char *) *xpp;
#line 3609
	int status = NC_NOERR;
#line 3609

#line 3609
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3609
	{
#line 3609
		int lstatus = ncx_put_double_longlong(xp, tp, fillp);
#line 3609
		if (status == NC_NOERR) /* report the first encountered error */
#line 3609
			status = lstatus;
#line 3609
	}
#line 3609

#line 3609
	*xpp = (void *)xp;
#line 3609
	return status;
#line 3609
#endif
#line 3609
}
#line 3609

int
#line 3610
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3610
{
#line 3610
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3610

#line 3610
 /* basic algorithm is:
#line 3610
  *   - ensure sane alignment of output data
#line 3610
  *   - copy (conversion happens automatically) input data
#line 3610
  *     to output
#line 3610
  *   - update tp to point at next unconverted input, and xpp to point
#line 3610
  *     at next location for converted output
#line 3610
  */
#line 3610
  long i, j, ni;
#line 3610
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3610
  double *xp;
#line 3610
  int nrange = 0;         /* number of range errors */
#line 3610
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3610
  long cxp = (long) *((char**)xpp);
#line 3610

#line 3610
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3610
  /* sjl: manually stripmine so we can limit amount of
#line 3610
   * vector work space reserved to LOOPCNT elements. Also
#line 3610
   * makes vectorisation easy */
#line 3610
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3610
    ni=Min(nelems-j,LOOPCNT);
#line 3610
    if (realign) {
#line 3610
      xp = tmp;
#line 3610
    } else {
#line 3610
      xp = (double *) *xpp;
#line 3610
    }
#line 3610
   /* copy the next block */
#line 3610
#pragma cdir loopcnt=LOOPCNT
#line 3610
#pragma cdir shortloop
#line 3610
    for (i=0; i<ni; i++) {
#line 3610
      /* the normal case: */
#line 3610
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3610
     /* test for range errors (not always needed but do it anyway) */
#line 3610
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3610
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3610
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3610
    }
#line 3610
   /* copy workspace back if necessary */
#line 3610
    if (realign) {
#line 3610
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3610
      xp = (double *) *xpp;
#line 3610
    }
#line 3610
   /* update xpp and tp */
#line 3610
    xp += ni;
#line 3610
    tp += ni;
#line 3610
    *xpp = (void*)xp;
#line 3610
  }
#line 3610
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3610

#line 3610
#else   /* not SX */
#line 3610

#line 3610
	char *xp = (char *) *xpp;
#line 3610
	int status = NC_NOERR;
#line 3610

#line 3610
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3610
	{
#line 3610
		int lstatus = ncx_put_double_uchar(xp, tp, fillp);
#line 3610
		if (status == NC_NOERR) /* report the first encountered error */
#line 3610
			status = lstatus;
#line 3610
	}
#line 3610

#line 3610
	*xpp = (void *)xp;
#line 3610
	return status;
#line 3610
#endif
#line 3610
}
#line 3610

int
#line 3611
ncx_putn_double_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3611
{
#line 3611
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3611

#line 3611
 /* basic algorithm is:
#line 3611
  *   - ensure sane alignment of output data
#line 3611
  *   - copy (conversion happens automatically) input data
#line 3611
  *     to output
#line 3611
  *   - update tp to point at next unconverted input, and xpp to point
#line 3611
  *     at next location for converted output
#line 3611
  */
#line 3611
  long i, j, ni;
#line 3611
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3611
  double *xp;
#line 3611
  int nrange = 0;         /* number of range errors */
#line 3611
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3611
  long cxp = (long) *((char**)xpp);
#line 3611

#line 3611
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3611
  /* sjl: manually stripmine so we can limit amount of
#line 3611
   * vector work space reserved to LOOPCNT elements. Also
#line 3611
   * makes vectorisation easy */
#line 3611
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3611
    ni=Min(nelems-j,LOOPCNT);
#line 3611
    if (realign) {
#line 3611
      xp = tmp;
#line 3611
    } else {
#line 3611
      xp = (double *) *xpp;
#line 3611
    }
#line 3611
   /* copy the next block */
#line 3611
#pragma cdir loopcnt=LOOPCNT
#line 3611
#pragma cdir shortloop
#line 3611
    for (i=0; i<ni; i++) {
#line 3611
      /* the normal case: */
#line 3611
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3611
     /* test for range errors (not always needed but do it anyway) */
#line 3611
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3611
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3611
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3611
    }
#line 3611
   /* copy workspace back if necessary */
#line 3611
    if (realign) {
#line 3611
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3611
      xp = (double *) *xpp;
#line 3611
    }
#line 3611
   /* update xpp and tp */
#line 3611
    xp += ni;
#line 3611
    tp += ni;
#line 3611
    *xpp = (void*)xp;
#line 3611
  }
#line 3611
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3611

#line 3611
#else   /* not SX */
#line 3611

#line 3611
	char *xp = (char *) *xpp;
#line 3611
	int status = NC_NOERR;
#line 3611

#line 3611
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3611
	{
#line 3611
		int lstatus = ncx_put_double_ushort(xp, tp, fillp);
#line 3611
		if (status == NC_NOERR) /* report the first encountered error */
#line 3611
			status = lstatus;
#line 3611
	}
#line 3611

#line 3611
	*xpp = (void *)xp;
#line 3611
	return status;
#line 3611
#endif
#line 3611
}
#line 3611

int
#line 3612
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3612
{
#line 3612
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3612

#line 3612
 /* basic algorithm is:
#line 3612
  *   - ensure sane alignment of output data
#line 3612
  *   - copy (conversion happens automatically) input data
#line 3612
  *     to output
#line 3612
  *   - update tp to point at next unconverted input, and xpp to point
#line 3612
  *     at next location for converted output
#line 3612
  */
#line 3612
  long i, j, ni;
#line 3612
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3612
  double *xp;
#line 3612
  int nrange = 0;         /* number of range errors */
#line 3612
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3612
  long cxp = (long) *((char**)xpp);
#line 3612

#line 3612
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3612
  /* sjl: manually stripmine so we can limit amount of
#line 3612
   * vector work space reserved to LOOPCNT elements. Also
#line 3612
   * makes vectorisation easy */
#line 3612
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3612
    ni=Min(nelems-j,LOOPCNT);
#line 3612
    if (realign) {
#line 3612
      xp = tmp;
#line 3612
    } else {
#line 3612
      xp = (double *) *xpp;
#line 3612
    }
#line 3612
   /* copy the next block */
#line 3612
#pragma cdir loopcnt=LOOPCNT
#line 3612
#pragma cdir shortloop
#line 3612
    for (i=0; i<ni; i++) {
#line 3612
      /* the normal case: */
#line 3612
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3612
     /* test for range errors (not always needed but do it anyway) */
#line 3612
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3612
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3612
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3612
    }
#line 3612
   /* copy workspace back if necessary */
#line 3612
    if (realign) {
#line 3612
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3612
      xp = (double *) *xpp;
#line 3612
    }
#line 3612
   /* update xpp and tp */
#line 3612
    xp += ni;
#line 3612
    tp += ni;
#line 3612
    *xpp = (void*)xp;
#line 3612
  }
#line 3612
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3612

#line 3612
#else   /* not SX */
#line 3612

#line 3612
	char *xp = (char *) *xpp;
#line 3612
	int status = NC_NOERR;
#line 3612

#line 3612
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3612
	{
#line 3612
		int lstatus = ncx_put_double_uint(xp, tp, fillp);
#line 3612
		if (status == NC_NOERR) /* report the first encountered error */
#line 3612
			status = lstatus;
#line 3612
	}
#line 3612

#line 3612
	*xpp = (void *)xp;
#line 3612
	return status;
#line 3612
#endif
#line 3612
}
#line 3612

int
#line 3613
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3613
{
#line 3613
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3613

#line 3613
 /* basic algorithm is:
#line 3613
  *   - ensure sane alignment of output data
#line 3613
  *   - copy (conversion happens automatically) input data
#line 3613
  *     to output
#line 3613
  *   - update tp to point at next unconverted input, and xpp to point
#line 3613
  *     at next location for converted output
#line 3613
  */
#line 3613
  long i, j, ni;
#line 3613
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3613
  double *xp;
#line 3613
  int nrange = 0;         /* number of range errors */
#line 3613
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3613
  long cxp = (long) *((char**)xpp);
#line 3613

#line 3613
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3613
  /* sjl: manually stripmine so we can limit amount of
#line 3613
   * vector work space reserved to LOOPCNT elements. Also
#line 3613
   * makes vectorisation easy */
#line 3613
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3613
    ni=Min(nelems-j,LOOPCNT);
#line 3613
    if (realign) {
#line 3613
      xp = tmp;
#line 3613
    } else {
#line 3613
      xp = (double *) *xpp;
#line 3613
    }
#line 3613
   /* copy the next block */
#line 3613
#pragma cdir loopcnt=LOOPCNT
#line 3613
#pragma cdir shortloop
#line 3613
    for (i=0; i<ni; i++) {
#line 3613
      /* the normal case: */
#line 3613
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3613
     /* test for range errors (not always needed but do it anyway) */
#line 3613
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3613
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3613
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3613
    }
#line 3613
   /* copy workspace back if necessary */
#line 3613
    if (realign) {
#line 3613
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3613
      xp = (double *) *xpp;
#line 3613
    }
#line 3613
   /* update xpp and tp */
#line 3613
    xp += ni;
#line 3613
    tp += ni;
#line 3613
    *xpp = (void*)xp;
#line 3613
  }
#line 3613
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3613

#line 3613
#else   /* not SX */
#line 3613

#line 3613
	char *xp = (char *) *xpp;
#line 3613
	int status = NC_NOERR;
#line 3613

#line 3613
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3613
	{
#line 3613
		int lstatus = ncx_put_double_ulonglong(xp, tp, fillp);
#line 3613
		if (status == NC_NOERR) /* report the first encountered error */
#line 3613
			status = lstatus;
#line 3613
	}
#line 3613

#line 3613
	*xpp = (void *)xp;
#line 3613
	return status;
#line 3613
#endif
#line 3613
}
#line 3613



/* longlong ------------------------------------------------------------------*/

#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3632
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3632
{
#line 3632
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3632

#line 3632
 /* basic algorithm is:
#line 3632
  *   - ensure sane alignment of input data
#line 3632
  *   - copy (conversion happens automatically) input data
#line 3632
  *     to output
#line 3632
  *   - update xpp to point at next unconverted input, and tp to point
#line 3632
  *     at next location for converted output
#line 3632
  */
#line 3632
  long i, j, ni;
#line 3632
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3632
  int64 *xp;
#line 3632
  int nrange = 0;         /* number of range errors */
#line 3632
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3632
  long cxp = (long) *((char**)xpp);
#line 3632

#line 3632
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3632
  /* sjl: manually stripmine so we can limit amount of
#line 3632
   * vector work space reserved to LOOPCNT elements. Also
#line 3632
   * makes vectorisation easy */
#line 3632
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3632
    ni=Min(nelems-j,LOOPCNT);
#line 3632
    if (realign) {
#line 3632
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3632
      xp = tmp;
#line 3632
    } else {
#line 3632
      xp = (int64 *) *xpp;
#line 3632
    }
#line 3632
   /* copy the next block */
#line 3632
#pragma cdir loopcnt=LOOPCNT
#line 3632
#pragma cdir shortloop
#line 3632
    for (i=0; i<ni; i++) {
#line 3632
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3632
     /* test for range errors (not always needed but do it anyway) */
#line 3632
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3632
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3632
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3632
    }
#line 3632
   /* update xpp and tp */
#line 3632
    if (realign) xp = (int64 *) *xpp;
#line 3632
    xp += ni;
#line 3632
    tp += ni;
#line 3632
    *xpp = (void*)xp;
#line 3632
  }
#line 3632
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3632

#line 3632
#else   /* not SX */
#line 3632
	const char *xp = (const char *) *xpp;
#line 3632
	int status = NC_NOERR;
#line 3632

#line 3632
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3632
	{
#line 3632
		const int lstatus = ncx_get_longlong_longlong(xp, tp);
#line 3632
		if (status == NC_NOERR) /* report the first encountered error */
#line 3632
			status = lstatus;
#line 3632
	}
#line 3632

#line 3632
	*xpp = (const void *)xp;
#line 3632
	return status;
#line 3632
#endif
#line 3632
}
#line 3632

#endif
int
#line 3634
ncx_getn_longlong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3634
{
#line 3634
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3634

#line 3634
 /* basic algorithm is:
#line 3634
  *   - ensure sane alignment of input data
#line 3634
  *   - copy (conversion happens automatically) input data
#line 3634
  *     to output
#line 3634
  *   - update xpp to point at next unconverted input, and tp to point
#line 3634
  *     at next location for converted output
#line 3634
  */
#line 3634
  long i, j, ni;
#line 3634
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3634
  int64 *xp;
#line 3634
  int nrange = 0;         /* number of range errors */
#line 3634
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3634
  long cxp = (long) *((char**)xpp);
#line 3634

#line 3634
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3634
  /* sjl: manually stripmine so we can limit amount of
#line 3634
   * vector work space reserved to LOOPCNT elements. Also
#line 3634
   * makes vectorisation easy */
#line 3634
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3634
    ni=Min(nelems-j,LOOPCNT);
#line 3634
    if (realign) {
#line 3634
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3634
      xp = tmp;
#line 3634
    } else {
#line 3634
      xp = (int64 *) *xpp;
#line 3634
    }
#line 3634
   /* copy the next block */
#line 3634
#pragma cdir loopcnt=LOOPCNT
#line 3634
#pragma cdir shortloop
#line 3634
    for (i=0; i<ni; i++) {
#line 3634
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3634
     /* test for range errors (not always needed but do it anyway) */
#line 3634
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3634
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3634
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3634
    }
#line 3634
   /* update xpp and tp */
#line 3634
    if (realign) xp = (int64 *) *xpp;
#line 3634
    xp += ni;
#line 3634
    tp += ni;
#line 3634
    *xpp = (void*)xp;
#line 3634
  }
#line 3634
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3634

#line 3634
#else   /* not SX */
#line 3634
	const char *xp = (const char *) *xpp;
#line 3634
	int status = NC_NOERR;
#line 3634

#line 3634
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3634
	{
#line 3634
		const int lstatus = ncx_get_longlong_schar(xp, tp);
#line 3634
		if (status == NC_NOERR) /* report the first encountered error */
#line 3634
			status = lstatus;
#line 3634
	}
#line 3634

#line 3634
	*xpp = (const void *)xp;
#line 3634
	return status;
#line 3634
#endif
#line 3634
}
#line 3634

int
#line 3635
ncx_getn_longlong_short(const void **xpp, size_t nelems, short *tp)
#line 3635
{
#line 3635
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3635

#line 3635
 /* basic algorithm is:
#line 3635
  *   - ensure sane alignment of input data
#line 3635
  *   - copy (conversion happens automatically) input data
#line 3635
  *     to output
#line 3635
  *   - update xpp to point at next unconverted input, and tp to point
#line 3635
  *     at next location for converted output
#line 3635
  */
#line 3635
  long i, j, ni;
#line 3635
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3635
  int64 *xp;
#line 3635
  int nrange = 0;         /* number of range errors */
#line 3635
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3635
  long cxp = (long) *((char**)xpp);
#line 3635

#line 3635
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3635
  /* sjl: manually stripmine so we can limit amount of
#line 3635
   * vector work space reserved to LOOPCNT elements. Also
#line 3635
   * makes vectorisation easy */
#line 3635
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3635
    ni=Min(nelems-j,LOOPCNT);
#line 3635
    if (realign) {
#line 3635
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3635
      xp = tmp;
#line 3635
    } else {
#line 3635
      xp = (int64 *) *xpp;
#line 3635
    }
#line 3635
   /* copy the next block */
#line 3635
#pragma cdir loopcnt=LOOPCNT
#line 3635
#pragma cdir shortloop
#line 3635
    for (i=0; i<ni; i++) {
#line 3635
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3635
     /* test for range errors (not always needed but do it anyway) */
#line 3635
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3635
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3635
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3635
    }
#line 3635
   /* update xpp and tp */
#line 3635
    if (realign) xp = (int64 *) *xpp;
#line 3635
    xp += ni;
#line 3635
    tp += ni;
#line 3635
    *xpp = (void*)xp;
#line 3635
  }
#line 3635
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3635

#line 3635
#else   /* not SX */
#line 3635
	const char *xp = (const char *) *xpp;
#line 3635
	int status = NC_NOERR;
#line 3635

#line 3635
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3635
	{
#line 3635
		const int lstatus = ncx_get_longlong_short(xp, tp);
#line 3635
		if (status == NC_NOERR) /* report the first encountered error */
#line 3635
			status = lstatus;
#line 3635
	}
#line 3635

#line 3635
	*xpp = (const void *)xp;
#line 3635
	return status;
#line 3635
#endif
#line 3635
}
#line 3635

int
#line 3636
ncx_getn_longlong_int(const void **xpp, size_t nelems, int *tp)
#line 3636
{
#line 3636
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3636

#line 3636
 /* basic algorithm is:
#line 3636
  *   - ensure sane alignment of input data
#line 3636
  *   - copy (conversion happens automatically) input data
#line 3636
  *     to output
#line 3636
  *   - update xpp to point at next unconverted input, and tp to point
#line 3636
  *     at next location for converted output
#line 3636
  */
#line 3636
  long i, j, ni;
#line 3636
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3636
  int64 *xp;
#line 3636
  int nrange = 0;         /* number of range errors */
#line 3636
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3636
  long cxp = (long) *((char**)xpp);
#line 3636

#line 3636
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3636
  /* sjl: manually stripmine so we can limit amount of
#line 3636
   * vector work space reserved to LOOPCNT elements. Also
#line 3636
   * makes vectorisation easy */
#line 3636
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3636
    ni=Min(nelems-j,LOOPCNT);
#line 3636
    if (realign) {
#line 3636
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3636
      xp = tmp;
#line 3636
    } else {
#line 3636
      xp = (int64 *) *xpp;
#line 3636
    }
#line 3636
   /* copy the next block */
#line 3636
#pragma cdir loopcnt=LOOPCNT
#line 3636
#pragma cdir shortloop
#line 3636
    for (i=0; i<ni; i++) {
#line 3636
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3636
     /* test for range errors (not always needed but do it anyway) */
#line 3636
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3636
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3636
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3636
    }
#line 3636
   /* update xpp and tp */
#line 3636
    if (realign) xp = (int64 *) *xpp;
#line 3636
    xp += ni;
#line 3636
    tp += ni;
#line 3636
    *xpp = (void*)xp;
#line 3636
  }
#line 3636
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3636

#line 3636
#else   /* not SX */
#line 3636
	const char *xp = (const char *) *xpp;
#line 3636
	int status = NC_NOERR;
#line 3636

#line 3636
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3636
	{
#line 3636
		const int lstatus = ncx_get_longlong_int(xp, tp);
#line 3636
		if (status == NC_NOERR) /* report the first encountered error */
#line 3636
			status = lstatus;
#line 3636
	}
#line 3636

#line 3636
	*xpp = (const void *)xp;
#line 3636
	return status;
#line 3636
#endif
#line 3636
}
#line 3636

int
#line 3637
ncx_getn_longlong_long(const void **xpp, size_t nelems, long *tp)
#line 3637
{
#line 3637
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3637

#line 3637
 /* basic algorithm is:
#line 3637
  *   - ensure sane alignment of input data
#line 3637
  *   - copy (conversion happens automatically) input data
#line 3637
  *     to output
#line 3637
  *   - update xpp to point at next unconverted input, and tp to point
#line 3637
  *     at next location for converted output
#line 3637
  */
#line 3637
  long i, j, ni;
#line 3637
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3637
  int64 *xp;
#line 3637
  int nrange = 0;         /* number of range errors */
#line 3637
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3637
  long cxp = (long) *((char**)xpp);
#line 3637

#line 3637
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3637
  /* sjl: manually stripmine so we can limit amount of
#line 3637
   * vector work space reserved to LOOPCNT elements. Also
#line 3637
   * makes vectorisation easy */
#line 3637
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3637
    ni=Min(nelems-j,LOOPCNT);
#line 3637
    if (realign) {
#line 3637
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3637
      xp = tmp;
#line 3637
    } else {
#line 3637
      xp = (int64 *) *xpp;
#line 3637
    }
#line 3637
   /* copy the next block */
#line 3637
#pragma cdir loopcnt=LOOPCNT
#line 3637
#pragma cdir shortloop
#line 3637
    for (i=0; i<ni; i++) {
#line 3637
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3637
     /* test for range errors (not always needed but do it anyway) */
#line 3637
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3637
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3637
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3637
    }
#line 3637
   /* update xpp and tp */
#line 3637
    if (realign) xp = (int64 *) *xpp;
#line 3637
    xp += ni;
#line 3637
    tp += ni;
#line 3637
    *xpp = (void*)xp;
#line 3637
  }
#line 3637
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3637

#line 3637
#else   /* not SX */
#line 3637
	const char *xp = (const char *) *xpp;
#line 3637
	int status = NC_NOERR;
#line 3637

#line 3637
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3637
	{
#line 3637
		const int lstatus = ncx_get_longlong_long(xp, tp);
#line 3637
		if (status == NC_NOERR) /* report the first encountered error */
#line 3637
			status = lstatus;
#line 3637
	}
#line 3637

#line 3637
	*xpp = (const void *)xp;
#line 3637
	return status;
#line 3637
#endif
#line 3637
}
#line 3637

int
#line 3638
ncx_getn_longlong_float(const void **xpp, size_t nelems, float *tp)
#line 3638
{
#line 3638
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3638

#line 3638
 /* basic algorithm is:
#line 3638
  *   - ensure sane alignment of input data
#line 3638
  *   - copy (conversion happens automatically) input data
#line 3638
  *     to output
#line 3638
  *   - update xpp to point at next unconverted input, and tp to point
#line 3638
  *     at next location for converted output
#line 3638
  */
#line 3638
  long i, j, ni;
#line 3638
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3638
  int64 *xp;
#line 3638
  int nrange = 0;         /* number of range errors */
#line 3638
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3638
  long cxp = (long) *((char**)xpp);
#line 3638

#line 3638
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3638
  /* sjl: manually stripmine so we can limit amount of
#line 3638
   * vector work space reserved to LOOPCNT elements. Also
#line 3638
   * makes vectorisation easy */
#line 3638
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3638
    ni=Min(nelems-j,LOOPCNT);
#line 3638
    if (realign) {
#line 3638
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3638
      xp = tmp;
#line 3638
    } else {
#line 3638
      xp = (int64 *) *xpp;
#line 3638
    }
#line 3638
   /* copy the next block */
#line 3638
#pragma cdir loopcnt=LOOPCNT
#line 3638
#pragma cdir shortloop
#line 3638
    for (i=0; i<ni; i++) {
#line 3638
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3638
     /* test for range errors (not always needed but do it anyway) */
#line 3638
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3638
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3638
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3638
    }
#line 3638
   /* update xpp and tp */
#line 3638
    if (realign) xp = (int64 *) *xpp;
#line 3638
    xp += ni;
#line 3638
    tp += ni;
#line 3638
    *xpp = (void*)xp;
#line 3638
  }
#line 3638
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3638

#line 3638
#else   /* not SX */
#line 3638
	const char *xp = (const char *) *xpp;
#line 3638
	int status = NC_NOERR;
#line 3638

#line 3638
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3638
	{
#line 3638
		const int lstatus = ncx_get_longlong_float(xp, tp);
#line 3638
		if (status == NC_NOERR) /* report the first encountered error */
#line 3638
			status = lstatus;
#line 3638
	}
#line 3638

#line 3638
	*xpp = (const void *)xp;
#line 3638
	return status;
#line 3638
#endif
#line 3638
}
#line 3638

int
#line 3639
ncx_getn_longlong_double(const void **xpp, size_t nelems, double *tp)
#line 3639
{
#line 3639
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3639

#line 3639
 /* basic algorithm is:
#line 3639
  *   - ensure sane alignment of input data
#line 3639
  *   - copy (conversion happens automatically) input data
#line 3639
  *     to output
#line 3639
  *   - update xpp to point at next unconverted input, and tp to point
#line 3639
  *     at next location for converted output
#line 3639
  */
#line 3639
  long i, j, ni;
#line 3639
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3639
  int64 *xp;
#line 3639
  int nrange = 0;         /* number of range errors */
#line 3639
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3639
  long cxp = (long) *((char**)xpp);
#line 3639

#line 3639
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3639
  /* sjl: manually stripmine so we can limit amount of
#line 3639
   * vector work space reserved to LOOPCNT elements. Also
#line 3639
   * makes vectorisation easy */
#line 3639
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3639
    ni=Min(nelems-j,LOOPCNT);
#line 3639
    if (realign) {
#line 3639
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3639
      xp = tmp;
#line 3639
    } else {
#line 3639
      xp = (int64 *) *xpp;
#line 3639
    }
#line 3639
   /* copy the next block */
#line 3639
#pragma cdir loopcnt=LOOPCNT
#line 3639
#pragma cdir shortloop
#line 3639
    for (i=0; i<ni; i++) {
#line 3639
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3639
     /* test for range errors (not always needed but do it anyway) */
#line 3639
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3639
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3639
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3639
    }
#line 3639
   /* update xpp and tp */
#line 3639
    if (realign) xp = (int64 *) *xpp;
#line 3639
    xp += ni;
#line 3639
    tp += ni;
#line 3639
    *xpp = (void*)xp;
#line 3639
  }
#line 3639
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3639

#line 3639
#else   /* not SX */
#line 3639
	const char *xp = (const char *) *xpp;
#line 3639
	int status = NC_NOERR;
#line 3639

#line 3639
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3639
	{
#line 3639
		const int lstatus = ncx_get_longlong_double(xp, tp);
#line 3639
		if (status == NC_NOERR) /* report the first encountered error */
#line 3639
			status = lstatus;
#line 3639
	}
#line 3639

#line 3639
	*xpp = (const void *)xp;
#line 3639
	return status;
#line 3639
#endif
#line 3639
}
#line 3639

int
#line 3640
ncx_getn_longlong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3640
{
#line 3640
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3640

#line 3640
 /* basic algorithm is:
#line 3640
  *   - ensure sane alignment of input data
#line 3640
  *   - copy (conversion happens automatically) input data
#line 3640
  *     to output
#line 3640
  *   - update xpp to point at next unconverted input, and tp to point
#line 3640
  *     at next location for converted output
#line 3640
  */
#line 3640
  long i, j, ni;
#line 3640
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3640
  int64 *xp;
#line 3640
  int nrange = 0;         /* number of range errors */
#line 3640
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3640
  long cxp = (long) *((char**)xpp);
#line 3640

#line 3640
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3640
  /* sjl: manually stripmine so we can limit amount of
#line 3640
   * vector work space reserved to LOOPCNT elements. Also
#line 3640
   * makes vectorisation easy */
#line 3640
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3640
    ni=Min(nelems-j,LOOPCNT);
#line 3640
    if (realign) {
#line 3640
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3640
      xp = tmp;
#line 3640
    } else {
#line 3640
      xp = (int64 *) *xpp;
#line 3640
    }
#line 3640
   /* copy the next block */
#line 3640
#pragma cdir loopcnt=LOOPCNT
#line 3640
#pragma cdir shortloop
#line 3640
    for (i=0; i<ni; i++) {
#line 3640
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3640
     /* test for range errors (not always needed but do it anyway) */
#line 3640
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3640
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3640
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3640
    }
#line 3640
   /* update xpp and tp */
#line 3640
    if (realign) xp = (int64 *) *xpp;
#line 3640
    xp += ni;
#line 3640
    tp += ni;
#line 3640
    *xpp = (void*)xp;
#line 3640
  }
#line 3640
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3640

#line 3640
#else   /* not SX */
#line 3640
	const char *xp = (const char *) *xpp;
#line 3640
	int status = NC_NOERR;
#line 3640

#line 3640
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3640
	{
#line 3640
		const int lstatus = ncx_get_longlong_uchar(xp, tp);
#line 3640
		if (status == NC_NOERR) /* report the first encountered error */
#line 3640
			status = lstatus;
#line 3640
	}
#line 3640

#line 3640
	*xpp = (const void *)xp;
#line 3640
	return status;
#line 3640
#endif
#line 3640
}
#line 3640

int
#line 3641
ncx_getn_longlong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3641
{
#line 3641
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3641

#line 3641
 /* basic algorithm is:
#line 3641
  *   - ensure sane alignment of input data
#line 3641
  *   - copy (conversion happens automatically) input data
#line 3641
  *     to output
#line 3641
  *   - update xpp to point at next unconverted input, and tp to point
#line 3641
  *     at next location for converted output
#line 3641
  */
#line 3641
  long i, j, ni;
#line 3641
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3641
  int64 *xp;
#line 3641
  int nrange = 0;         /* number of range errors */
#line 3641
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3641
  long cxp = (long) *((char**)xpp);
#line 3641

#line 3641
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3641
  /* sjl: manually stripmine so we can limit amount of
#line 3641
   * vector work space reserved to LOOPCNT elements. Also
#line 3641
   * makes vectorisation easy */
#line 3641
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3641
    ni=Min(nelems-j,LOOPCNT);
#line 3641
    if (realign) {
#line 3641
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3641
      xp = tmp;
#line 3641
    } else {
#line 3641
      xp = (int64 *) *xpp;
#line 3641
    }
#line 3641
   /* copy the next block */
#line 3641
#pragma cdir loopcnt=LOOPCNT
#line 3641
#pragma cdir shortloop
#line 3641
    for (i=0; i<ni; i++) {
#line 3641
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3641
     /* test for range errors (not always needed but do it anyway) */
#line 3641
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3641
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3641
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3641
    }
#line 3641
   /* update xpp and tp */
#line 3641
    if (realign) xp = (int64 *) *xpp;
#line 3641
    xp += ni;
#line 3641
    tp += ni;
#line 3641
    *xpp = (void*)xp;
#line 3641
  }
#line 3641
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3641

#line 3641
#else   /* not SX */
#line 3641
	const char *xp = (const char *) *xpp;
#line 3641
	int status = NC_NOERR;
#line 3641

#line 3641
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3641
	{
#line 3641
		const int lstatus = ncx_get_longlong_ushort(xp, tp);
#line 3641
		if (status == NC_NOERR) /* report the first encountered error */
#line 3641
			status = lstatus;
#line 3641
	}
#line 3641

#line 3641
	*xpp = (const void *)xp;
#line 3641
	return status;
#line 3641
#endif
#line 3641
}
#line 3641

int
#line 3642
ncx_getn_longlong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3642
{
#line 3642
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3642

#line 3642
 /* basic algorithm is:
#line 3642
  *   - ensure sane alignment of input data
#line 3642
  *   - copy (conversion happens automatically) input data
#line 3642
  *     to output
#line 3642
  *   - update xpp to point at next unconverted input, and tp to point
#line 3642
  *     at next location for converted output
#line 3642
  */
#line 3642
  long i, j, ni;
#line 3642
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3642
  int64 *xp;
#line 3642
  int nrange = 0;         /* number of range errors */
#line 3642
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3642
  long cxp = (long) *((char**)xpp);
#line 3642

#line 3642
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3642
  /* sjl: manually stripmine so we can limit amount of
#line 3642
   * vector work space reserved to LOOPCNT elements. Also
#line 3642
   * makes vectorisation easy */
#line 3642
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3642
    ni=Min(nelems-j,LOOPCNT);
#line 3642
    if (realign) {
#line 3642
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3642
      xp = tmp;
#line 3642
    } else {
#line 3642
      xp = (int64 *) *xpp;
#line 3642
    }
#line 3642
   /* copy the next block */
#line 3642
#pragma cdir loopcnt=LOOPCNT
#line 3642
#pragma cdir shortloop
#line 3642
    for (i=0; i<ni; i++) {
#line 3642
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3642
     /* test for range errors (not always needed but do it anyway) */
#line 3642
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3642
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3642
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3642
    }
#line 3642
   /* update xpp and tp */
#line 3642
    if (realign) xp = (int64 *) *xpp;
#line 3642
    xp += ni;
#line 3642
    tp += ni;
#line 3642
    *xpp = (void*)xp;
#line 3642
  }
#line 3642
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3642

#line 3642
#else   /* not SX */
#line 3642
	const char *xp = (const char *) *xpp;
#line 3642
	int status = NC_NOERR;
#line 3642

#line 3642
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3642
	{
#line 3642
		const int lstatus = ncx_get_longlong_uint(xp, tp);
#line 3642
		if (status == NC_NOERR) /* report the first encountered error */
#line 3642
			status = lstatus;
#line 3642
	}
#line 3642

#line 3642
	*xpp = (const void *)xp;
#line 3642
	return status;
#line 3642
#endif
#line 3642
}
#line 3642

int
#line 3643
ncx_getn_longlong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3643
{
#line 3643
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3643

#line 3643
 /* basic algorithm is:
#line 3643
  *   - ensure sane alignment of input data
#line 3643
  *   - copy (conversion happens automatically) input data
#line 3643
  *     to output
#line 3643
  *   - update xpp to point at next unconverted input, and tp to point
#line 3643
  *     at next location for converted output
#line 3643
  */
#line 3643
  long i, j, ni;
#line 3643
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3643
  int64 *xp;
#line 3643
  int nrange = 0;         /* number of range errors */
#line 3643
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3643
  long cxp = (long) *((char**)xpp);
#line 3643

#line 3643
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3643
  /* sjl: manually stripmine so we can limit amount of
#line 3643
   * vector work space reserved to LOOPCNT elements. Also
#line 3643
   * makes vectorisation easy */
#line 3643
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3643
    ni=Min(nelems-j,LOOPCNT);
#line 3643
    if (realign) {
#line 3643
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3643
      xp = tmp;
#line 3643
    } else {
#line 3643
      xp = (int64 *) *xpp;
#line 3643
    }
#line 3643
   /* copy the next block */
#line 3643
#pragma cdir loopcnt=LOOPCNT
#line 3643
#pragma cdir shortloop
#line 3643
    for (i=0; i<ni; i++) {
#line 3643
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3643
     /* test for range errors (not always needed but do it anyway) */
#line 3643
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3643
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3643
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3643
    }
#line 3643
   /* update xpp and tp */
#line 3643
    if (realign) xp = (int64 *) *xpp;
#line 3643
    xp += ni;
#line 3643
    tp += ni;
#line 3643
    *xpp = (void*)xp;
#line 3643
  }
#line 3643
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3643

#line 3643
#else   /* not SX */
#line 3643
	const char *xp = (const char *) *xpp;
#line 3643
	int status = NC_NOERR;
#line 3643

#line 3643
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3643
	{
#line 3643
		const int lstatus = ncx_get_longlong_ulonglong(xp, tp);
#line 3643
		if (status == NC_NOERR) /* report the first encountered error */
#line 3643
			status = lstatus;
#line 3643
	}
#line 3643

#line 3643
	*xpp = (const void *)xp;
#line 3643
	return status;
#line 3643
#endif
#line 3643
}
#line 3643


#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3659
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3659
{
#line 3659
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3659

#line 3659
 /* basic algorithm is:
#line 3659
  *   - ensure sane alignment of output data
#line 3659
  *   - copy (conversion happens automatically) input data
#line 3659
  *     to output
#line 3659
  *   - update tp to point at next unconverted input, and xpp to point
#line 3659
  *     at next location for converted output
#line 3659
  */
#line 3659
  long i, j, ni;
#line 3659
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3659
  int64 *xp;
#line 3659
  int nrange = 0;         /* number of range errors */
#line 3659
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3659
  long cxp = (long) *((char**)xpp);
#line 3659

#line 3659
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3659
  /* sjl: manually stripmine so we can limit amount of
#line 3659
   * vector work space reserved to LOOPCNT elements. Also
#line 3659
   * makes vectorisation easy */
#line 3659
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3659
    ni=Min(nelems-j,LOOPCNT);
#line 3659
    if (realign) {
#line 3659
      xp = tmp;
#line 3659
    } else {
#line 3659
      xp = (int64 *) *xpp;
#line 3659
    }
#line 3659
   /* copy the next block */
#line 3659
#pragma cdir loopcnt=LOOPCNT
#line 3659
#pragma cdir shortloop
#line 3659
    for (i=0; i<ni; i++) {
#line 3659
      /* the normal case: */
#line 3659
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3659
     /* test for range errors (not always needed but do it anyway) */
#line 3659
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3659
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3659
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3659
    }
#line 3659
   /* copy workspace back if necessary */
#line 3659
    if (realign) {
#line 3659
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3659
      xp = (int64 *) *xpp;
#line 3659
    }
#line 3659
   /* update xpp and tp */
#line 3659
    xp += ni;
#line 3659
    tp += ni;
#line 3659
    *xpp = (void*)xp;
#line 3659
  }
#line 3659
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3659

#line 3659
#else   /* not SX */
#line 3659

#line 3659
	char *xp = (char *) *xpp;
#line 3659
	int status = NC_NOERR;
#line 3659

#line 3659
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3659
	{
#line 3659
		int lstatus = ncx_put_longlong_longlong(xp, tp, fillp);
#line 3659
		if (status == NC_NOERR) /* report the first encountered error */
#line 3659
			status = lstatus;
#line 3659
	}
#line 3659

#line 3659
	*xpp = (void *)xp;
#line 3659
	return status;
#line 3659
#endif
#line 3659
}
#line 3659

#endif
int
#line 3661
ncx_putn_longlong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3661
{
#line 3661
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3661

#line 3661
 /* basic algorithm is:
#line 3661
  *   - ensure sane alignment of output data
#line 3661
  *   - copy (conversion happens automatically) input data
#line 3661
  *     to output
#line 3661
  *   - update tp to point at next unconverted input, and xpp to point
#line 3661
  *     at next location for converted output
#line 3661
  */
#line 3661
  long i, j, ni;
#line 3661
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3661
  int64 *xp;
#line 3661
  int nrange = 0;         /* number of range errors */
#line 3661
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3661
  long cxp = (long) *((char**)xpp);
#line 3661

#line 3661
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3661
  /* sjl: manually stripmine so we can limit amount of
#line 3661
   * vector work space reserved to LOOPCNT elements. Also
#line 3661
   * makes vectorisation easy */
#line 3661
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3661
    ni=Min(nelems-j,LOOPCNT);
#line 3661
    if (realign) {
#line 3661
      xp = tmp;
#line 3661
    } else {
#line 3661
      xp = (int64 *) *xpp;
#line 3661
    }
#line 3661
   /* copy the next block */
#line 3661
#pragma cdir loopcnt=LOOPCNT
#line 3661
#pragma cdir shortloop
#line 3661
    for (i=0; i<ni; i++) {
#line 3661
      /* the normal case: */
#line 3661
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3661
     /* test for range errors (not always needed but do it anyway) */
#line 3661
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3661
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3661
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3661
    }
#line 3661
   /* copy workspace back if necessary */
#line 3661
    if (realign) {
#line 3661
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3661
      xp = (int64 *) *xpp;
#line 3661
    }
#line 3661
   /* update xpp and tp */
#line 3661
    xp += ni;
#line 3661
    tp += ni;
#line 3661
    *xpp = (void*)xp;
#line 3661
  }
#line 3661
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3661

#line 3661
#else   /* not SX */
#line 3661

#line 3661
	char *xp = (char *) *xpp;
#line 3661
	int status = NC_NOERR;
#line 3661

#line 3661
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3661
	{
#line 3661
		int lstatus = ncx_put_longlong_schar(xp, tp, fillp);
#line 3661
		if (status == NC_NOERR) /* report the first encountered error */
#line 3661
			status = lstatus;
#line 3661
	}
#line 3661

#line 3661
	*xpp = (void *)xp;
#line 3661
	return status;
#line 3661
#endif
#line 3661
}
#line 3661

int
#line 3662
ncx_putn_longlong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3662
{
#line 3662
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3662

#line 3662
 /* basic algorithm is:
#line 3662
  *   - ensure sane alignment of output data
#line 3662
  *   - copy (conversion happens automatically) input data
#line 3662
  *     to output
#line 3662
  *   - update tp to point at next unconverted input, and xpp to point
#line 3662
  *     at next location for converted output
#line 3662
  */
#line 3662
  long i, j, ni;
#line 3662
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3662
  int64 *xp;
#line 3662
  int nrange = 0;         /* number of range errors */
#line 3662
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3662
  long cxp = (long) *((char**)xpp);
#line 3662

#line 3662
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3662
  /* sjl: manually stripmine so we can limit amount of
#line 3662
   * vector work space reserved to LOOPCNT elements. Also
#line 3662
   * makes vectorisation easy */
#line 3662
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3662
    ni=Min(nelems-j,LOOPCNT);
#line 3662
    if (realign) {
#line 3662
      xp = tmp;
#line 3662
    } else {
#line 3662
      xp = (int64 *) *xpp;
#line 3662
    }
#line 3662
   /* copy the next block */
#line 3662
#pragma cdir loopcnt=LOOPCNT
#line 3662
#pragma cdir shortloop
#line 3662
    for (i=0; i<ni; i++) {
#line 3662
      /* the normal case: */
#line 3662
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3662
     /* test for range errors (not always needed but do it anyway) */
#line 3662
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3662
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3662
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3662
    }
#line 3662
   /* copy workspace back if necessary */
#line 3662
    if (realign) {
#line 3662
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3662
      xp = (int64 *) *xpp;
#line 3662
    }
#line 3662
   /* update xpp and tp */
#line 3662
    xp += ni;
#line 3662
    tp += ni;
#line 3662
    *xpp = (void*)xp;
#line 3662
  }
#line 3662
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3662

#line 3662
#else   /* not SX */
#line 3662

#line 3662
	char *xp = (char *) *xpp;
#line 3662
	int status = NC_NOERR;
#line 3662

#line 3662
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3662
	{
#line 3662
		int lstatus = ncx_put_longlong_short(xp, tp, fillp);
#line 3662
		if (status == NC_NOERR) /* report the first encountered error */
#line 3662
			status = lstatus;
#line 3662
	}
#line 3662

#line 3662
	*xpp = (void *)xp;
#line 3662
	return status;
#line 3662
#endif
#line 3662
}
#line 3662

int
#line 3663
ncx_putn_longlong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3663
{
#line 3663
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3663

#line 3663
 /* basic algorithm is:
#line 3663
  *   - ensure sane alignment of output data
#line 3663
  *   - copy (conversion happens automatically) input data
#line 3663
  *     to output
#line 3663
  *   - update tp to point at next unconverted input, and xpp to point
#line 3663
  *     at next location for converted output
#line 3663
  */
#line 3663
  long i, j, ni;
#line 3663
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3663
  int64 *xp;
#line 3663
  int nrange = 0;         /* number of range errors */
#line 3663
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3663
  long cxp = (long) *((char**)xpp);
#line 3663

#line 3663
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3663
  /* sjl: manually stripmine so we can limit amount of
#line 3663
   * vector work space reserved to LOOPCNT elements. Also
#line 3663
   * makes vectorisation easy */
#line 3663
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3663
    ni=Min(nelems-j,LOOPCNT);
#line 3663
    if (realign) {
#line 3663
      xp = tmp;
#line 3663
    } else {
#line 3663
      xp = (int64 *) *xpp;
#line 3663
    }
#line 3663
   /* copy the next block */
#line 3663
#pragma cdir loopcnt=LOOPCNT
#line 3663
#pragma cdir shortloop
#line 3663
    for (i=0; i<ni; i++) {
#line 3663
      /* the normal case: */
#line 3663
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3663
     /* test for range errors (not always needed but do it anyway) */
#line 3663
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3663
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3663
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3663
    }
#line 3663
   /* copy workspace back if necessary */
#line 3663
    if (realign) {
#line 3663
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3663
      xp = (int64 *) *xpp;
#line 3663
    }
#line 3663
   /* update xpp and tp */
#line 3663
    xp += ni;
#line 3663
    tp += ni;
#line 3663
    *xpp = (void*)xp;
#line 3663
  }
#line 3663
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3663

#line 3663
#else   /* not SX */
#line 3663

#line 3663
	char *xp = (char *) *xpp;
#line 3663
	int status = NC_NOERR;
#line 3663

#line 3663
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3663
	{
#line 3663
		int lstatus = ncx_put_longlong_int(xp, tp, fillp);
#line 3663
		if (status == NC_NOERR) /* report the first encountered error */
#line 3663
			status = lstatus;
#line 3663
	}
#line 3663

#line 3663
	*xpp = (void *)xp;
#line 3663
	return status;
#line 3663
#endif
#line 3663
}
#line 3663

int
#line 3664
ncx_putn_longlong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3664
{
#line 3664
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3664

#line 3664
 /* basic algorithm is:
#line 3664
  *   - ensure sane alignment of output data
#line 3664
  *   - copy (conversion happens automatically) input data
#line 3664
  *     to output
#line 3664
  *   - update tp to point at next unconverted input, and xpp to point
#line 3664
  *     at next location for converted output
#line 3664
  */
#line 3664
  long i, j, ni;
#line 3664
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3664
  int64 *xp;
#line 3664
  int nrange = 0;         /* number of range errors */
#line 3664
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3664
  long cxp = (long) *((char**)xpp);
#line 3664

#line 3664
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3664
  /* sjl: manually stripmine so we can limit amount of
#line 3664
   * vector work space reserved to LOOPCNT elements. Also
#line 3664
   * makes vectorisation easy */
#line 3664
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3664
    ni=Min(nelems-j,LOOPCNT);
#line 3664
    if (realign) {
#line 3664
      xp = tmp;
#line 3664
    } else {
#line 3664
      xp = (int64 *) *xpp;
#line 3664
    }
#line 3664
   /* copy the next block */
#line 3664
#pragma cdir loopcnt=LOOPCNT
#line 3664
#pragma cdir shortloop
#line 3664
    for (i=0; i<ni; i++) {
#line 3664
      /* the normal case: */
#line 3664
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3664
     /* test for range errors (not always needed but do it anyway) */
#line 3664
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3664
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3664
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3664
    }
#line 3664
   /* copy workspace back if necessary */
#line 3664
    if (realign) {
#line 3664
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3664
      xp = (int64 *) *xpp;
#line 3664
    }
#line 3664
   /* update xpp and tp */
#line 3664
    xp += ni;
#line 3664
    tp += ni;
#line 3664
    *xpp = (void*)xp;
#line 3664
  }
#line 3664
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3664

#line 3664
#else   /* not SX */
#line 3664

#line 3664
	char *xp = (char *) *xpp;
#line 3664
	int status = NC_NOERR;
#line 3664

#line 3664
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3664
	{
#line 3664
		int lstatus = ncx_put_longlong_long(xp, tp, fillp);
#line 3664
		if (status == NC_NOERR) /* report the first encountered error */
#line 3664
			status = lstatus;
#line 3664
	}
#line 3664

#line 3664
	*xpp = (void *)xp;
#line 3664
	return status;
#line 3664
#endif
#line 3664
}
#line 3664

int
#line 3665
ncx_putn_longlong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3665
{
#line 3665
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3665

#line 3665
 /* basic algorithm is:
#line 3665
  *   - ensure sane alignment of output data
#line 3665
  *   - copy (conversion happens automatically) input data
#line 3665
  *     to output
#line 3665
  *   - update tp to point at next unconverted input, and xpp to point
#line 3665
  *     at next location for converted output
#line 3665
  */
#line 3665
  long i, j, ni;
#line 3665
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3665
  int64 *xp;
#line 3665
  int nrange = 0;         /* number of range errors */
#line 3665
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3665
  long cxp = (long) *((char**)xpp);
#line 3665

#line 3665
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3665
  /* sjl: manually stripmine so we can limit amount of
#line 3665
   * vector work space reserved to LOOPCNT elements. Also
#line 3665
   * makes vectorisation easy */
#line 3665
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3665
    ni=Min(nelems-j,LOOPCNT);
#line 3665
    if (realign) {
#line 3665
      xp = tmp;
#line 3665
    } else {
#line 3665
      xp = (int64 *) *xpp;
#line 3665
    }
#line 3665
   /* copy the next block */
#line 3665
#pragma cdir loopcnt=LOOPCNT
#line 3665
#pragma cdir shortloop
#line 3665
    for (i=0; i<ni; i++) {
#line 3665
      /* the normal case: */
#line 3665
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3665
     /* test for range errors (not always needed but do it anyway) */
#line 3665
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3665
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3665
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3665
    }
#line 3665
   /* copy workspace back if necessary */
#line 3665
    if (realign) {
#line 3665
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3665
      xp = (int64 *) *xpp;
#line 3665
    }
#line 3665
   /* update xpp and tp */
#line 3665
    xp += ni;
#line 3665
    tp += ni;
#line 3665
    *xpp = (void*)xp;
#line 3665
  }
#line 3665
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3665

#line 3665
#else   /* not SX */
#line 3665

#line 3665
	char *xp = (char *) *xpp;
#line 3665
	int status = NC_NOERR;
#line 3665

#line 3665
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3665
	{
#line 3665
		int lstatus = ncx_put_longlong_float(xp, tp, fillp);
#line 3665
		if (status == NC_NOERR) /* report the first encountered error */
#line 3665
			status = lstatus;
#line 3665
	}
#line 3665

#line 3665
	*xpp = (void *)xp;
#line 3665
	return status;
#line 3665
#endif
#line 3665
}
#line 3665

int
#line 3666
ncx_putn_longlong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3666
{
#line 3666
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3666

#line 3666
 /* basic algorithm is:
#line 3666
  *   - ensure sane alignment of output data
#line 3666
  *   - copy (conversion happens automatically) input data
#line 3666
  *     to output
#line 3666
  *   - update tp to point at next unconverted input, and xpp to point
#line 3666
  *     at next location for converted output
#line 3666
  */
#line 3666
  long i, j, ni;
#line 3666
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3666
  int64 *xp;
#line 3666
  int nrange = 0;         /* number of range errors */
#line 3666
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3666
  long cxp = (long) *((char**)xpp);
#line 3666

#line 3666
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3666
  /* sjl: manually stripmine so we can limit amount of
#line 3666
   * vector work space reserved to LOOPCNT elements. Also
#line 3666
   * makes vectorisation easy */
#line 3666
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3666
    ni=Min(nelems-j,LOOPCNT);
#line 3666
    if (realign) {
#line 3666
      xp = tmp;
#line 3666
    } else {
#line 3666
      xp = (int64 *) *xpp;
#line 3666
    }
#line 3666
   /* copy the next block */
#line 3666
#pragma cdir loopcnt=LOOPCNT
#line 3666
#pragma cdir shortloop
#line 3666
    for (i=0; i<ni; i++) {
#line 3666
      /* the normal case: */
#line 3666
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3666
     /* test for range errors (not always needed but do it anyway) */
#line 3666
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3666
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3666
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3666
    }
#line 3666
   /* copy workspace back if necessary */
#line 3666
    if (realign) {
#line 3666
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3666
      xp = (int64 *) *xpp;
#line 3666
    }
#line 3666
   /* update xpp and tp */
#line 3666
    xp += ni;
#line 3666
    tp += ni;
#line 3666
    *xpp = (void*)xp;
#line 3666
  }
#line 3666
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3666

#line 3666
#else   /* not SX */
#line 3666

#line 3666
	char *xp = (char *) *xpp;
#line 3666
	int status = NC_NOERR;
#line 3666

#line 3666
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3666
	{
#line 3666
		int lstatus = ncx_put_longlong_double(xp, tp, fillp);
#line 3666
		if (status == NC_NOERR) /* report the first encountered error */
#line 3666
			status = lstatus;
#line 3666
	}
#line 3666

#line 3666
	*xpp = (void *)xp;
#line 3666
	return status;
#line 3666
#endif
#line 3666
}
#line 3666

int
#line 3667
ncx_putn_longlong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3667
{
#line 3667
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3667

#line 3667
 /* basic algorithm is:
#line 3667
  *   - ensure sane alignment of output data
#line 3667
  *   - copy (conversion happens automatically) input data
#line 3667
  *     to output
#line 3667
  *   - update tp to point at next unconverted input, and xpp to point
#line 3667
  *     at next location for converted output
#line 3667
  */
#line 3667
  long i, j, ni;
#line 3667
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3667
  int64 *xp;
#line 3667
  int nrange = 0;         /* number of range errors */
#line 3667
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3667
  long cxp = (long) *((char**)xpp);
#line 3667

#line 3667
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3667
  /* sjl: manually stripmine so we can limit amount of
#line 3667
   * vector work space reserved to LOOPCNT elements. Also
#line 3667
   * makes vectorisation easy */
#line 3667
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3667
    ni=Min(nelems-j,LOOPCNT);
#line 3667
    if (realign) {
#line 3667
      xp = tmp;
#line 3667
    } else {
#line 3667
      xp = (int64 *) *xpp;
#line 3667
    }
#line 3667
   /* copy the next block */
#line 3667
#pragma cdir loopcnt=LOOPCNT
#line 3667
#pragma cdir shortloop
#line 3667
    for (i=0; i<ni; i++) {
#line 3667
      /* the normal case: */
#line 3667
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3667
     /* test for range errors (not always needed but do it anyway) */
#line 3667
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3667
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3667
      nrange += tp[i] > X_INT64_MAX ;
#line 3667
    }
#line 3667
   /* copy workspace back if necessary */
#line 3667
    if (realign) {
#line 3667
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3667
      xp = (int64 *) *xpp;
#line 3667
    }
#line 3667
   /* update xpp and tp */
#line 3667
    xp += ni;
#line 3667
    tp += ni;
#line 3667
    *xpp = (void*)xp;
#line 3667
  }
#line 3667
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3667

#line 3667
#else   /* not SX */
#line 3667

#line 3667
	char *xp = (char *) *xpp;
#line 3667
	int status = NC_NOERR;
#line 3667

#line 3667
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3667
	{
#line 3667
		int lstatus = ncx_put_longlong_uchar(xp, tp, fillp);
#line 3667
		if (status == NC_NOERR) /* report the first encountered error */
#line 3667
			status = lstatus;
#line 3667
	}
#line 3667

#line 3667
	*xpp = (void *)xp;
#line 3667
	return status;
#line 3667
#endif
#line 3667
}
#line 3667

int
#line 3668
ncx_putn_longlong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3668
{
#line 3668
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3668

#line 3668
 /* basic algorithm is:
#line 3668
  *   - ensure sane alignment of output data
#line 3668
  *   - copy (conversion happens automatically) input data
#line 3668
  *     to output
#line 3668
  *   - update tp to point at next unconverted input, and xpp to point
#line 3668
  *     at next location for converted output
#line 3668
  */
#line 3668
  long i, j, ni;
#line 3668
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3668
  int64 *xp;
#line 3668
  int nrange = 0;         /* number of range errors */
#line 3668
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3668
  long cxp = (long) *((char**)xpp);
#line 3668

#line 3668
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3668
  /* sjl: manually stripmine so we can limit amount of
#line 3668
   * vector work space reserved to LOOPCNT elements. Also
#line 3668
   * makes vectorisation easy */
#line 3668
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3668
    ni=Min(nelems-j,LOOPCNT);
#line 3668
    if (realign) {
#line 3668
      xp = tmp;
#line 3668
    } else {
#line 3668
      xp = (int64 *) *xpp;
#line 3668
    }
#line 3668
   /* copy the next block */
#line 3668
#pragma cdir loopcnt=LOOPCNT
#line 3668
#pragma cdir shortloop
#line 3668
    for (i=0; i<ni; i++) {
#line 3668
      /* the normal case: */
#line 3668
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3668
     /* test for range errors (not always needed but do it anyway) */
#line 3668
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3668
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3668
      nrange += tp[i] > X_INT64_MAX ;
#line 3668
    }
#line 3668
   /* copy workspace back if necessary */
#line 3668
    if (realign) {
#line 3668
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3668
      xp = (int64 *) *xpp;
#line 3668
    }
#line 3668
   /* update xpp and tp */
#line 3668
    xp += ni;
#line 3668
    tp += ni;
#line 3668
    *xpp = (void*)xp;
#line 3668
  }
#line 3668
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3668

#line 3668
#else   /* not SX */
#line 3668

#line 3668
	char *xp = (char *) *xpp;
#line 3668
	int status = NC_NOERR;
#line 3668

#line 3668
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3668
	{
#line 3668
		int lstatus = ncx_put_longlong_ushort(xp, tp, fillp);
#line 3668
		if (status == NC_NOERR) /* report the first encountered error */
#line 3668
			status = lstatus;
#line 3668
	}
#line 3668

#line 3668
	*xpp = (void *)xp;
#line 3668
	return status;
#line 3668
#endif
#line 3668
}
#line 3668

int
#line 3669
ncx_putn_longlong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3669
{
#line 3669
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3669

#line 3669
 /* basic algorithm is:
#line 3669
  *   - ensure sane alignment of output data
#line 3669
  *   - copy (conversion happens automatically) input data
#line 3669
  *     to output
#line 3669
  *   - update tp to point at next unconverted input, and xpp to point
#line 3669
  *     at next location for converted output
#line 3669
  */
#line 3669
  long i, j, ni;
#line 3669
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3669
  int64 *xp;
#line 3669
  int nrange = 0;         /* number of range errors */
#line 3669
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3669
  long cxp = (long) *((char**)xpp);
#line 3669

#line 3669
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3669
  /* sjl: manually stripmine so we can limit amount of
#line 3669
   * vector work space reserved to LOOPCNT elements. Also
#line 3669
   * makes vectorisation easy */
#line 3669
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3669
    ni=Min(nelems-j,LOOPCNT);
#line 3669
    if (realign) {
#line 3669
      xp = tmp;
#line 3669
    } else {
#line 3669
      xp = (int64 *) *xpp;
#line 3669
    }
#line 3669
   /* copy the next block */
#line 3669
#pragma cdir loopcnt=LOOPCNT
#line 3669
#pragma cdir shortloop
#line 3669
    for (i=0; i<ni; i++) {
#line 3669
      /* the normal case: */
#line 3669
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3669
     /* test for range errors (not always needed but do it anyway) */
#line 3669
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3669
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3669
      nrange += tp[i] > X_INT64_MAX ;
#line 3669
    }
#line 3669
   /* copy workspace back if necessary */
#line 3669
    if (realign) {
#line 3669
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3669
      xp = (int64 *) *xpp;
#line 3669
    }
#line 3669
   /* update xpp and tp */
#line 3669
    xp += ni;
#line 3669
    tp += ni;
#line 3669
    *xpp = (void*)xp;
#line 3669
  }
#line 3669
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3669

#line 3669
#else   /* not SX */
#line 3669

#line 3669
	char *xp = (char *) *xpp;
#line 3669
	int status = NC_NOERR;
#line 3669

#line 3669
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3669
	{
#line 3669
		int lstatus = ncx_put_longlong_uint(xp, tp, fillp);
#line 3669
		if (status == NC_NOERR) /* report the first encountered error */
#line 3669
			status = lstatus;
#line 3669
	}
#line 3669

#line 3669
	*xpp = (void *)xp;
#line 3669
	return status;
#line 3669
#endif
#line 3669
}
#line 3669

int
#line 3670
ncx_putn_longlong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3670
{
#line 3670
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3670

#line 3670
 /* basic algorithm is:
#line 3670
  *   - ensure sane alignment of output data
#line 3670
  *   - copy (conversion happens automatically) input data
#line 3670
  *     to output
#line 3670
  *   - update tp to point at next unconverted input, and xpp to point
#line 3670
  *     at next location for converted output
#line 3670
  */
#line 3670
  long i, j, ni;
#line 3670
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3670
  int64 *xp;
#line 3670
  int nrange = 0;         /* number of range errors */
#line 3670
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3670
  long cxp = (long) *((char**)xpp);
#line 3670

#line 3670
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3670
  /* sjl: manually stripmine so we can limit amount of
#line 3670
   * vector work space reserved to LOOPCNT elements. Also
#line 3670
   * makes vectorisation easy */
#line 3670
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3670
    ni=Min(nelems-j,LOOPCNT);
#line 3670
    if (realign) {
#line 3670
      xp = tmp;
#line 3670
    } else {
#line 3670
      xp = (int64 *) *xpp;
#line 3670
    }
#line 3670
   /* copy the next block */
#line 3670
#pragma cdir loopcnt=LOOPCNT
#line 3670
#pragma cdir shortloop
#line 3670
    for (i=0; i<ni; i++) {
#line 3670
      /* the normal case: */
#line 3670
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3670
     /* test for range errors (not always needed but do it anyway) */
#line 3670
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3670
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3670
      nrange += tp[i] > X_INT64_MAX ;
#line 3670
    }
#line 3670
   /* copy workspace back if necessary */
#line 3670
    if (realign) {
#line 3670
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3670
      xp = (int64 *) *xpp;
#line 3670
    }
#line 3670
   /* update xpp and tp */
#line 3670
    xp += ni;
#line 3670
    tp += ni;
#line 3670
    *xpp = (void*)xp;
#line 3670
  }
#line 3670
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3670

#line 3670
#else   /* not SX */
#line 3670

#line 3670
	char *xp = (char *) *xpp;
#line 3670
	int status = NC_NOERR;
#line 3670

#line 3670
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3670
	{
#line 3670
		int lstatus = ncx_put_longlong_ulonglong(xp, tp, fillp);
#line 3670
		if (status == NC_NOERR) /* report the first encountered error */
#line 3670
			status = lstatus;
#line 3670
	}
#line 3670

#line 3670
	*xpp = (void *)xp;
#line 3670
	return status;
#line 3670
#endif
#line 3670
}
#line 3670


/* uint64 --------------------------------------------------------------------*/

#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UNSIGNED_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3688
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3688
{
#line 3688
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3688

#line 3688
 /* basic algorithm is:
#line 3688
  *   - ensure sane alignment of input data
#line 3688
  *   - copy (conversion happens automatically) input data
#line 3688
  *     to output
#line 3688
  *   - update xpp to point at next unconverted input, and tp to point
#line 3688
  *     at next location for converted output
#line 3688
  */
#line 3688
  long i, j, ni;
#line 3688
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3688
  uint64 *xp;
#line 3688
  int nrange = 0;         /* number of range errors */
#line 3688
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3688
  long cxp = (long) *((char**)xpp);
#line 3688

#line 3688
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3688
  /* sjl: manually stripmine so we can limit amount of
#line 3688
   * vector work space reserved to LOOPCNT elements. Also
#line 3688
   * makes vectorisation easy */
#line 3688
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3688
    ni=Min(nelems-j,LOOPCNT);
#line 3688
    if (realign) {
#line 3688
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3688
      xp = tmp;
#line 3688
    } else {
#line 3688
      xp = (uint64 *) *xpp;
#line 3688
    }
#line 3688
   /* copy the next block */
#line 3688
#pragma cdir loopcnt=LOOPCNT
#line 3688
#pragma cdir shortloop
#line 3688
    for (i=0; i<ni; i++) {
#line 3688
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3688
     /* test for range errors (not always needed but do it anyway) */
#line 3688
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3688
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3688
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3688
    }
#line 3688
   /* update xpp and tp */
#line 3688
    if (realign) xp = (uint64 *) *xpp;
#line 3688
    xp += ni;
#line 3688
    tp += ni;
#line 3688
    *xpp = (void*)xp;
#line 3688
  }
#line 3688
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3688

#line 3688
#else   /* not SX */
#line 3688
	const char *xp = (const char *) *xpp;
#line 3688
	int status = NC_NOERR;
#line 3688

#line 3688
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3688
	{
#line 3688
		const int lstatus = ncx_get_ulonglong_ulonglong(xp, tp);
#line 3688
		if (status == NC_NOERR) /* report the first encountered error */
#line 3688
			status = lstatus;
#line 3688
	}
#line 3688

#line 3688
	*xpp = (const void *)xp;
#line 3688
	return status;
#line 3688
#endif
#line 3688
}
#line 3688

#endif
int
#line 3690
ncx_getn_ulonglong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3690
{
#line 3690
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3690

#line 3690
 /* basic algorithm is:
#line 3690
  *   - ensure sane alignment of input data
#line 3690
  *   - copy (conversion happens automatically) input data
#line 3690
  *     to output
#line 3690
  *   - update xpp to point at next unconverted input, and tp to point
#line 3690
  *     at next location for converted output
#line 3690
  */
#line 3690
  long i, j, ni;
#line 3690
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3690
  uint64 *xp;
#line 3690
  int nrange = 0;         /* number of range errors */
#line 3690
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3690
  long cxp = (long) *((char**)xpp);
#line 3690

#line 3690
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3690
  /* sjl: manually stripmine so we can limit amount of
#line 3690
   * vector work space reserved to LOOPCNT elements. Also
#line 3690
   * makes vectorisation easy */
#line 3690
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3690
    ni=Min(nelems-j,LOOPCNT);
#line 3690
    if (realign) {
#line 3690
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3690
      xp = tmp;
#line 3690
    } else {
#line 3690
      xp = (uint64 *) *xpp;
#line 3690
    }
#line 3690
   /* copy the next block */
#line 3690
#pragma cdir loopcnt=LOOPCNT
#line 3690
#pragma cdir shortloop
#line 3690
    for (i=0; i<ni; i++) {
#line 3690
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3690
     /* test for range errors (not always needed but do it anyway) */
#line 3690
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3690
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3690
      nrange += xp[i] > SCHAR_MAX ;
#line 3690
    }
#line 3690
   /* update xpp and tp */
#line 3690
    if (realign) xp = (uint64 *) *xpp;
#line 3690
    xp += ni;
#line 3690
    tp += ni;
#line 3690
    *xpp = (void*)xp;
#line 3690
  }
#line 3690
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3690

#line 3690
#else   /* not SX */
#line 3690
	const char *xp = (const char *) *xpp;
#line 3690
	int status = NC_NOERR;
#line 3690

#line 3690
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3690
	{
#line 3690
		const int lstatus = ncx_get_ulonglong_schar(xp, tp);
#line 3690
		if (status == NC_NOERR) /* report the first encountered error */
#line 3690
			status = lstatus;
#line 3690
	}
#line 3690

#line 3690
	*xpp = (const void *)xp;
#line 3690
	return status;
#line 3690
#endif
#line 3690
}
#line 3690

int
#line 3691
ncx_getn_ulonglong_short(const void **xpp, size_t nelems, short *tp)
#line 3691
{
#line 3691
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3691

#line 3691
 /* basic algorithm is:
#line 3691
  *   - ensure sane alignment of input data
#line 3691
  *   - copy (conversion happens automatically) input data
#line 3691
  *     to output
#line 3691
  *   - update xpp to point at next unconverted input, and tp to point
#line 3691
  *     at next location for converted output
#line 3691
  */
#line 3691
  long i, j, ni;
#line 3691
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3691
  uint64 *xp;
#line 3691
  int nrange = 0;         /* number of range errors */
#line 3691
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3691
  long cxp = (long) *((char**)xpp);
#line 3691

#line 3691
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3691
  /* sjl: manually stripmine so we can limit amount of
#line 3691
   * vector work space reserved to LOOPCNT elements. Also
#line 3691
   * makes vectorisation easy */
#line 3691
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3691
    ni=Min(nelems-j,LOOPCNT);
#line 3691
    if (realign) {
#line 3691
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3691
      xp = tmp;
#line 3691
    } else {
#line 3691
      xp = (uint64 *) *xpp;
#line 3691
    }
#line 3691
   /* copy the next block */
#line 3691
#pragma cdir loopcnt=LOOPCNT
#line 3691
#pragma cdir shortloop
#line 3691
    for (i=0; i<ni; i++) {
#line 3691
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3691
     /* test for range errors (not always needed but do it anyway) */
#line 3691
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3691
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3691
      nrange += xp[i] > SHORT_MAX ;
#line 3691
    }
#line 3691
   /* update xpp and tp */
#line 3691
    if (realign) xp = (uint64 *) *xpp;
#line 3691
    xp += ni;
#line 3691
    tp += ni;
#line 3691
    *xpp = (void*)xp;
#line 3691
  }
#line 3691
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3691

#line 3691
#else   /* not SX */
#line 3691
	const char *xp = (const char *) *xpp;
#line 3691
	int status = NC_NOERR;
#line 3691

#line 3691
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3691
	{
#line 3691
		const int lstatus = ncx_get_ulonglong_short(xp, tp);
#line 3691
		if (status == NC_NOERR) /* report the first encountered error */
#line 3691
			status = lstatus;
#line 3691
	}
#line 3691

#line 3691
	*xpp = (const void *)xp;
#line 3691
	return status;
#line 3691
#endif
#line 3691
}
#line 3691

int
#line 3692
ncx_getn_ulonglong_int(const void **xpp, size_t nelems, int *tp)
#line 3692
{
#line 3692
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3692

#line 3692
 /* basic algorithm is:
#line 3692
  *   - ensure sane alignment of input data
#line 3692
  *   - copy (conversion happens automatically) input data
#line 3692
  *     to output
#line 3692
  *   - update xpp to point at next unconverted input, and tp to point
#line 3692
  *     at next location for converted output
#line 3692
  */
#line 3692
  long i, j, ni;
#line 3692
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3692
  uint64 *xp;
#line 3692
  int nrange = 0;         /* number of range errors */
#line 3692
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3692
  long cxp = (long) *((char**)xpp);
#line 3692

#line 3692
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3692
  /* sjl: manually stripmine so we can limit amount of
#line 3692
   * vector work space reserved to LOOPCNT elements. Also
#line 3692
   * makes vectorisation easy */
#line 3692
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3692
    ni=Min(nelems-j,LOOPCNT);
#line 3692
    if (realign) {
#line 3692
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3692
      xp = tmp;
#line 3692
    } else {
#line 3692
      xp = (uint64 *) *xpp;
#line 3692
    }
#line 3692
   /* copy the next block */
#line 3692
#pragma cdir loopcnt=LOOPCNT
#line 3692
#pragma cdir shortloop
#line 3692
    for (i=0; i<ni; i++) {
#line 3692
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3692
     /* test for range errors (not always needed but do it anyway) */
#line 3692
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3692
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3692
      nrange += xp[i] > INT_MAX ;
#line 3692
    }
#line 3692
   /* update xpp and tp */
#line 3692
    if (realign) xp = (uint64 *) *xpp;
#line 3692
    xp += ni;
#line 3692
    tp += ni;
#line 3692
    *xpp = (void*)xp;
#line 3692
  }
#line 3692
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3692

#line 3692
#else   /* not SX */
#line 3692
	const char *xp = (const char *) *xpp;
#line 3692
	int status = NC_NOERR;
#line 3692

#line 3692
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3692
	{
#line 3692
		const int lstatus = ncx_get_ulonglong_int(xp, tp);
#line 3692
		if (status == NC_NOERR) /* report the first encountered error */
#line 3692
			status = lstatus;
#line 3692
	}
#line 3692

#line 3692
	*xpp = (const void *)xp;
#line 3692
	return status;
#line 3692
#endif
#line 3692
}
#line 3692

int
#line 3693
ncx_getn_ulonglong_long(const void **xpp, size_t nelems, long *tp)
#line 3693
{
#line 3693
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3693

#line 3693
 /* basic algorithm is:
#line 3693
  *   - ensure sane alignment of input data
#line 3693
  *   - copy (conversion happens automatically) input data
#line 3693
  *     to output
#line 3693
  *   - update xpp to point at next unconverted input, and tp to point
#line 3693
  *     at next location for converted output
#line 3693
  */
#line 3693
  long i, j, ni;
#line 3693
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3693
  uint64 *xp;
#line 3693
  int nrange = 0;         /* number of range errors */
#line 3693
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3693
  long cxp = (long) *((char**)xpp);
#line 3693

#line 3693
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3693
  /* sjl: manually stripmine so we can limit amount of
#line 3693
   * vector work space reserved to LOOPCNT elements. Also
#line 3693
   * makes vectorisation easy */
#line 3693
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3693
    ni=Min(nelems-j,LOOPCNT);
#line 3693
    if (realign) {
#line 3693
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3693
      xp = tmp;
#line 3693
    } else {
#line 3693
      xp = (uint64 *) *xpp;
#line 3693
    }
#line 3693
   /* copy the next block */
#line 3693
#pragma cdir loopcnt=LOOPCNT
#line 3693
#pragma cdir shortloop
#line 3693
    for (i=0; i<ni; i++) {
#line 3693
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3693
     /* test for range errors (not always needed but do it anyway) */
#line 3693
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3693
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3693
      nrange += xp[i] > LONG_MAX ;
#line 3693
    }
#line 3693
   /* update xpp and tp */
#line 3693
    if (realign) xp = (uint64 *) *xpp;
#line 3693
    xp += ni;
#line 3693
    tp += ni;
#line 3693
    *xpp = (void*)xp;
#line 3693
  }
#line 3693
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3693

#line 3693
#else   /* not SX */
#line 3693
	const char *xp = (const char *) *xpp;
#line 3693
	int status = NC_NOERR;
#line 3693

#line 3693
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3693
	{
#line 3693
		const int lstatus = ncx_get_ulonglong_long(xp, tp);
#line 3693
		if (status == NC_NOERR) /* report the first encountered error */
#line 3693
			status = lstatus;
#line 3693
	}
#line 3693

#line 3693
	*xpp = (const void *)xp;
#line 3693
	return status;
#line 3693
#endif
#line 3693
}
#line 3693

int
#line 3694
ncx_getn_ulonglong_float(const void **xpp, size_t nelems, float *tp)
#line 3694
{
#line 3694
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3694

#line 3694
 /* basic algorithm is:
#line 3694
  *   - ensure sane alignment of input data
#line 3694
  *   - copy (conversion happens automatically) input data
#line 3694
  *     to output
#line 3694
  *   - update xpp to point at next unconverted input, and tp to point
#line 3694
  *     at next location for converted output
#line 3694
  */
#line 3694
  long i, j, ni;
#line 3694
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3694
  uint64 *xp;
#line 3694
  int nrange = 0;         /* number of range errors */
#line 3694
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3694
  long cxp = (long) *((char**)xpp);
#line 3694

#line 3694
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3694
  /* sjl: manually stripmine so we can limit amount of
#line 3694
   * vector work space reserved to LOOPCNT elements. Also
#line 3694
   * makes vectorisation easy */
#line 3694
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3694
    ni=Min(nelems-j,LOOPCNT);
#line 3694
    if (realign) {
#line 3694
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3694
      xp = tmp;
#line 3694
    } else {
#line 3694
      xp = (uint64 *) *xpp;
#line 3694
    }
#line 3694
   /* copy the next block */
#line 3694
#pragma cdir loopcnt=LOOPCNT
#line 3694
#pragma cdir shortloop
#line 3694
    for (i=0; i<ni; i++) {
#line 3694
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3694
     /* test for range errors (not always needed but do it anyway) */
#line 3694
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3694
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3694
      nrange += xp[i] > FLOAT_MAX ;
#line 3694
    }
#line 3694
   /* update xpp and tp */
#line 3694
    if (realign) xp = (uint64 *) *xpp;
#line 3694
    xp += ni;
#line 3694
    tp += ni;
#line 3694
    *xpp = (void*)xp;
#line 3694
  }
#line 3694
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3694

#line 3694
#else   /* not SX */
#line 3694
	const char *xp = (const char *) *xpp;
#line 3694
	int status = NC_NOERR;
#line 3694

#line 3694
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3694
	{
#line 3694
		const int lstatus = ncx_get_ulonglong_float(xp, tp);
#line 3694
		if (status == NC_NOERR) /* report the first encountered error */
#line 3694
			status = lstatus;
#line 3694
	}
#line 3694

#line 3694
	*xpp = (const void *)xp;
#line 3694
	return status;
#line 3694
#endif
#line 3694
}
#line 3694

int
#line 3695
ncx_getn_ulonglong_double(const void **xpp, size_t nelems, double *tp)
#line 3695
{
#line 3695
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3695

#line 3695
 /* basic algorithm is:
#line 3695
  *   - ensure sane alignment of input data
#line 3695
  *   - copy (conversion happens automatically) input data
#line 3695
  *     to output
#line 3695
  *   - update xpp to point at next unconverted input, and tp to point
#line 3695
  *     at next location for converted output
#line 3695
  */
#line 3695
  long i, j, ni;
#line 3695
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3695
  uint64 *xp;
#line 3695
  int nrange = 0;         /* number of range errors */
#line 3695
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3695
  long cxp = (long) *((char**)xpp);
#line 3695

#line 3695
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3695
  /* sjl: manually stripmine so we can limit amount of
#line 3695
   * vector work space reserved to LOOPCNT elements. Also
#line 3695
   * makes vectorisation easy */
#line 3695
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3695
    ni=Min(nelems-j,LOOPCNT);
#line 3695
    if (realign) {
#line 3695
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3695
      xp = tmp;
#line 3695
    } else {
#line 3695
      xp = (uint64 *) *xpp;
#line 3695
    }
#line 3695
   /* copy the next block */
#line 3695
#pragma cdir loopcnt=LOOPCNT
#line 3695
#pragma cdir shortloop
#line 3695
    for (i=0; i<ni; i++) {
#line 3695
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3695
     /* test for range errors (not always needed but do it anyway) */
#line 3695
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3695
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3695
      nrange += xp[i] > DOUBLE_MAX ;
#line 3695
    }
#line 3695
   /* update xpp and tp */
#line 3695
    if (realign) xp = (uint64 *) *xpp;
#line 3695
    xp += ni;
#line 3695
    tp += ni;
#line 3695
    *xpp = (void*)xp;
#line 3695
  }
#line 3695
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3695

#line 3695
#else   /* not SX */
#line 3695
	const char *xp = (const char *) *xpp;
#line 3695
	int status = NC_NOERR;
#line 3695

#line 3695
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3695
	{
#line 3695
		const int lstatus = ncx_get_ulonglong_double(xp, tp);
#line 3695
		if (status == NC_NOERR) /* report the first encountered error */
#line 3695
			status = lstatus;
#line 3695
	}
#line 3695

#line 3695
	*xpp = (const void *)xp;
#line 3695
	return status;
#line 3695
#endif
#line 3695
}
#line 3695

int
#line 3696
ncx_getn_ulonglong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3696
{
#line 3696
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3696

#line 3696
 /* basic algorithm is:
#line 3696
  *   - ensure sane alignment of input data
#line 3696
  *   - copy (conversion happens automatically) input data
#line 3696
  *     to output
#line 3696
  *   - update xpp to point at next unconverted input, and tp to point
#line 3696
  *     at next location for converted output
#line 3696
  */
#line 3696
  long i, j, ni;
#line 3696
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3696
  uint64 *xp;
#line 3696
  int nrange = 0;         /* number of range errors */
#line 3696
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3696
  long cxp = (long) *((char**)xpp);
#line 3696

#line 3696
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3696
  /* sjl: manually stripmine so we can limit amount of
#line 3696
   * vector work space reserved to LOOPCNT elements. Also
#line 3696
   * makes vectorisation easy */
#line 3696
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3696
    ni=Min(nelems-j,LOOPCNT);
#line 3696
    if (realign) {
#line 3696
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3696
      xp = tmp;
#line 3696
    } else {
#line 3696
      xp = (uint64 *) *xpp;
#line 3696
    }
#line 3696
   /* copy the next block */
#line 3696
#pragma cdir loopcnt=LOOPCNT
#line 3696
#pragma cdir shortloop
#line 3696
    for (i=0; i<ni; i++) {
#line 3696
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3696
     /* test for range errors (not always needed but do it anyway) */
#line 3696
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3696
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3696
      nrange += xp[i] > LONGLONG_MAX ;
#line 3696
    }
#line 3696
   /* update xpp and tp */
#line 3696
    if (realign) xp = (uint64 *) *xpp;
#line 3696
    xp += ni;
#line 3696
    tp += ni;
#line 3696
    *xpp = (void*)xp;
#line 3696
  }
#line 3696
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3696

#line 3696
#else   /* not SX */
#line 3696
	const char *xp = (const char *) *xpp;
#line 3696
	int status = NC_NOERR;
#line 3696

#line 3696
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3696
	{
#line 3696
		const int lstatus = ncx_get_ulonglong_longlong(xp, tp);
#line 3696
		if (status == NC_NOERR) /* report the first encountered error */
#line 3696
			status = lstatus;
#line 3696
	}
#line 3696

#line 3696
	*xpp = (const void *)xp;
#line 3696
	return status;
#line 3696
#endif
#line 3696
}
#line 3696

int
#line 3697
ncx_getn_ulonglong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3697
{
#line 3697
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3697

#line 3697
 /* basic algorithm is:
#line 3697
  *   - ensure sane alignment of input data
#line 3697
  *   - copy (conversion happens automatically) input data
#line 3697
  *     to output
#line 3697
  *   - update xpp to point at next unconverted input, and tp to point
#line 3697
  *     at next location for converted output
#line 3697
  */
#line 3697
  long i, j, ni;
#line 3697
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3697
  uint64 *xp;
#line 3697
  int nrange = 0;         /* number of range errors */
#line 3697
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3697
  long cxp = (long) *((char**)xpp);
#line 3697

#line 3697
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3697
  /* sjl: manually stripmine so we can limit amount of
#line 3697
   * vector work space reserved to LOOPCNT elements. Also
#line 3697
   * makes vectorisation easy */
#line 3697
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3697
    ni=Min(nelems-j,LOOPCNT);
#line 3697
    if (realign) {
#line 3697
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3697
      xp = tmp;
#line 3697
    } else {
#line 3697
      xp = (uint64 *) *xpp;
#line 3697
    }
#line 3697
   /* copy the next block */
#line 3697
#pragma cdir loopcnt=LOOPCNT
#line 3697
#pragma cdir shortloop
#line 3697
    for (i=0; i<ni; i++) {
#line 3697
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3697
     /* test for range errors (not always needed but do it anyway) */
#line 3697
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3697
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3697
      nrange += xp[i] > UCHAR_MAX ;
#line 3697
    }
#line 3697
   /* update xpp and tp */
#line 3697
    if (realign) xp = (uint64 *) *xpp;
#line 3697
    xp += ni;
#line 3697
    tp += ni;
#line 3697
    *xpp = (void*)xp;
#line 3697
  }
#line 3697
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3697

#line 3697
#else   /* not SX */
#line 3697
	const char *xp = (const char *) *xpp;
#line 3697
	int status = NC_NOERR;
#line 3697

#line 3697
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3697
	{
#line 3697
		const int lstatus = ncx_get_ulonglong_uchar(xp, tp);
#line 3697
		if (status == NC_NOERR) /* report the first encountered error */
#line 3697
			status = lstatus;
#line 3697
	}
#line 3697

#line 3697
	*xpp = (const void *)xp;
#line 3697
	return status;
#line 3697
#endif
#line 3697
}
#line 3697

int
#line 3698
ncx_getn_ulonglong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3698
{
#line 3698
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3698

#line 3698
 /* basic algorithm is:
#line 3698
  *   - ensure sane alignment of input data
#line 3698
  *   - copy (conversion happens automatically) input data
#line 3698
  *     to output
#line 3698
  *   - update xpp to point at next unconverted input, and tp to point
#line 3698
  *     at next location for converted output
#line 3698
  */
#line 3698
  long i, j, ni;
#line 3698
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3698
  uint64 *xp;
#line 3698
  int nrange = 0;         /* number of range errors */
#line 3698
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3698
  long cxp = (long) *((char**)xpp);
#line 3698

#line 3698
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3698
  /* sjl: manually stripmine so we can limit amount of
#line 3698
   * vector work space reserved to LOOPCNT elements. Also
#line 3698
   * makes vectorisation easy */
#line 3698
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3698
    ni=Min(nelems-j,LOOPCNT);
#line 3698
    if (realign) {
#line 3698
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3698
      xp = tmp;
#line 3698
    } else {
#line 3698
      xp = (uint64 *) *xpp;
#line 3698
    }
#line 3698
   /* copy the next block */
#line 3698
#pragma cdir loopcnt=LOOPCNT
#line 3698
#pragma cdir shortloop
#line 3698
    for (i=0; i<ni; i++) {
#line 3698
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3698
     /* test for range errors (not always needed but do it anyway) */
#line 3698
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3698
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3698
      nrange += xp[i] > USHORT_MAX ;
#line 3698
    }
#line 3698
   /* update xpp and tp */
#line 3698
    if (realign) xp = (uint64 *) *xpp;
#line 3698
    xp += ni;
#line 3698
    tp += ni;
#line 3698
    *xpp = (void*)xp;
#line 3698
  }
#line 3698
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3698

#line 3698
#else   /* not SX */
#line 3698
	const char *xp = (const char *) *xpp;
#line 3698
	int status = NC_NOERR;
#line 3698

#line 3698
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3698
	{
#line 3698
		const int lstatus = ncx_get_ulonglong_ushort(xp, tp);
#line 3698
		if (status == NC_NOERR) /* report the first encountered error */
#line 3698
			status = lstatus;
#line 3698
	}
#line 3698

#line 3698
	*xpp = (const void *)xp;
#line 3698
	return status;
#line 3698
#endif
#line 3698
}
#line 3698

int
#line 3699
ncx_getn_ulonglong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3699
{
#line 3699
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3699

#line 3699
 /* basic algorithm is:
#line 3699
  *   - ensure sane alignment of input data
#line 3699
  *   - copy (conversion happens automatically) input data
#line 3699
  *     to output
#line 3699
  *   - update xpp to point at next unconverted input, and tp to point
#line 3699
  *     at next location for converted output
#line 3699
  */
#line 3699
  long i, j, ni;
#line 3699
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3699
  uint64 *xp;
#line 3699
  int nrange = 0;         /* number of range errors */
#line 3699
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3699
  long cxp = (long) *((char**)xpp);
#line 3699

#line 3699
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3699
  /* sjl: manually stripmine so we can limit amount of
#line 3699
   * vector work space reserved to LOOPCNT elements. Also
#line 3699
   * makes vectorisation easy */
#line 3699
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3699
    ni=Min(nelems-j,LOOPCNT);
#line 3699
    if (realign) {
#line 3699
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3699
      xp = tmp;
#line 3699
    } else {
#line 3699
      xp = (uint64 *) *xpp;
#line 3699
    }
#line 3699
   /* copy the next block */
#line 3699
#pragma cdir loopcnt=LOOPCNT
#line 3699
#pragma cdir shortloop
#line 3699
    for (i=0; i<ni; i++) {
#line 3699
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3699
     /* test for range errors (not always needed but do it anyway) */
#line 3699
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3699
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3699
      nrange += xp[i] > UINT_MAX ;
#line 3699
    }
#line 3699
   /* update xpp and tp */
#line 3699
    if (realign) xp = (uint64 *) *xpp;
#line 3699
    xp += ni;
#line 3699
    tp += ni;
#line 3699
    *xpp = (void*)xp;
#line 3699
  }
#line 3699
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3699

#line 3699
#else   /* not SX */
#line 3699
	const char *xp = (const char *) *xpp;
#line 3699
	int status = NC_NOERR;
#line 3699

#line 3699
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3699
	{
#line 3699
		const int lstatus = ncx_get_ulonglong_uint(xp, tp);
#line 3699
		if (status == NC_NOERR) /* report the first encountered error */
#line 3699
			status = lstatus;
#line 3699
	}
#line 3699

#line 3699
	*xpp = (const void *)xp;
#line 3699
	return status;
#line 3699
#endif
#line 3699
}
#line 3699


#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const unsigned long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3715
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3715
{
#line 3715
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3715

#line 3715
 /* basic algorithm is:
#line 3715
  *   - ensure sane alignment of output data
#line 3715
  *   - copy (conversion happens automatically) input data
#line 3715
  *     to output
#line 3715
  *   - update tp to point at next unconverted input, and xpp to point
#line 3715
  *     at next location for converted output
#line 3715
  */
#line 3715
  long i, j, ni;
#line 3715
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3715
  uint64 *xp;
#line 3715
  int nrange = 0;         /* number of range errors */
#line 3715
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3715
  long cxp = (long) *((char**)xpp);
#line 3715

#line 3715
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3715
  /* sjl: manually stripmine so we can limit amount of
#line 3715
   * vector work space reserved to LOOPCNT elements. Also
#line 3715
   * makes vectorisation easy */
#line 3715
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3715
    ni=Min(nelems-j,LOOPCNT);
#line 3715
    if (realign) {
#line 3715
      xp = tmp;
#line 3715
    } else {
#line 3715
      xp = (uint64 *) *xpp;
#line 3715
    }
#line 3715
   /* copy the next block */
#line 3715
#pragma cdir loopcnt=LOOPCNT
#line 3715
#pragma cdir shortloop
#line 3715
    for (i=0; i<ni; i++) {
#line 3715
      /* the normal case: */
#line 3715
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3715
     /* test for range errors (not always needed but do it anyway) */
#line 3715
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3715
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3715
      nrange += tp[i] > X_UINT64_MAX ;
#line 3715
    }
#line 3715
   /* copy workspace back if necessary */
#line 3715
    if (realign) {
#line 3715
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3715
      xp = (uint64 *) *xpp;
#line 3715
    }
#line 3715
   /* update xpp and tp */
#line 3715
    xp += ni;
#line 3715
    tp += ni;
#line 3715
    *xpp = (void*)xp;
#line 3715
  }
#line 3715
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3715

#line 3715
#else   /* not SX */
#line 3715

#line 3715
	char *xp = (char *) *xpp;
#line 3715
	int status = NC_NOERR;
#line 3715

#line 3715
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3715
	{
#line 3715
		int lstatus = ncx_put_ulonglong_ulonglong(xp, tp, fillp);
#line 3715
		if (status == NC_NOERR) /* report the first encountered error */
#line 3715
			status = lstatus;
#line 3715
	}
#line 3715

#line 3715
	*xpp = (void *)xp;
#line 3715
	return status;
#line 3715
#endif
#line 3715
}
#line 3715

#endif
int
#line 3717
ncx_putn_ulonglong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3717
{
#line 3717
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3717

#line 3717
 /* basic algorithm is:
#line 3717
  *   - ensure sane alignment of output data
#line 3717
  *   - copy (conversion happens automatically) input data
#line 3717
  *     to output
#line 3717
  *   - update tp to point at next unconverted input, and xpp to point
#line 3717
  *     at next location for converted output
#line 3717
  */
#line 3717
  long i, j, ni;
#line 3717
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3717
  uint64 *xp;
#line 3717
  int nrange = 0;         /* number of range errors */
#line 3717
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3717
  long cxp = (long) *((char**)xpp);
#line 3717

#line 3717
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3717
  /* sjl: manually stripmine so we can limit amount of
#line 3717
   * vector work space reserved to LOOPCNT elements. Also
#line 3717
   * makes vectorisation easy */
#line 3717
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3717
    ni=Min(nelems-j,LOOPCNT);
#line 3717
    if (realign) {
#line 3717
      xp = tmp;
#line 3717
    } else {
#line 3717
      xp = (uint64 *) *xpp;
#line 3717
    }
#line 3717
   /* copy the next block */
#line 3717
#pragma cdir loopcnt=LOOPCNT
#line 3717
#pragma cdir shortloop
#line 3717
    for (i=0; i<ni; i++) {
#line 3717
      /* the normal case: */
#line 3717
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3717
     /* test for range errors (not always needed but do it anyway) */
#line 3717
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3717
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3717
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3717
    }
#line 3717
   /* copy workspace back if necessary */
#line 3717
    if (realign) {
#line 3717
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3717
      xp = (uint64 *) *xpp;
#line 3717
    }
#line 3717
   /* update xpp and tp */
#line 3717
    xp += ni;
#line 3717
    tp += ni;
#line 3717
    *xpp = (void*)xp;
#line 3717
  }
#line 3717
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3717

#line 3717
#else   /* not SX */
#line 3717

#line 3717
	char *xp = (char *) *xpp;
#line 3717
	int status = NC_NOERR;
#line 3717

#line 3717
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3717
	{
#line 3717
		int lstatus = ncx_put_ulonglong_schar(xp, tp, fillp);
#line 3717
		if (status == NC_NOERR) /* report the first encountered error */
#line 3717
			status = lstatus;
#line 3717
	}
#line 3717

#line 3717
	*xpp = (void *)xp;
#line 3717
	return status;
#line 3717
#endif
#line 3717
}
#line 3717

int
#line 3718
ncx_putn_ulonglong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3718
{
#line 3718
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3718

#line 3718
 /* basic algorithm is:
#line 3718
  *   - ensure sane alignment of output data
#line 3718
  *   - copy (conversion happens automatically) input data
#line 3718
  *     to output
#line 3718
  *   - update tp to point at next unconverted input, and xpp to point
#line 3718
  *     at next location for converted output
#line 3718
  */
#line 3718
  long i, j, ni;
#line 3718
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3718
  uint64 *xp;
#line 3718
  int nrange = 0;         /* number of range errors */
#line 3718
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3718
  long cxp = (long) *((char**)xpp);
#line 3718

#line 3718
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3718
  /* sjl: manually stripmine so we can limit amount of
#line 3718
   * vector work space reserved to LOOPCNT elements. Also
#line 3718
   * makes vectorisation easy */
#line 3718
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3718
    ni=Min(nelems-j,LOOPCNT);
#line 3718
    if (realign) {
#line 3718
      xp = tmp;
#line 3718
    } else {
#line 3718
      xp = (uint64 *) *xpp;
#line 3718
    }
#line 3718
   /* copy the next block */
#line 3718
#pragma cdir loopcnt=LOOPCNT
#line 3718
#pragma cdir shortloop
#line 3718
    for (i=0; i<ni; i++) {
#line 3718
      /* the normal case: */
#line 3718
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3718
     /* test for range errors (not always needed but do it anyway) */
#line 3718
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3718
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3718
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3718
    }
#line 3718
   /* copy workspace back if necessary */
#line 3718
    if (realign) {
#line 3718
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3718
      xp = (uint64 *) *xpp;
#line 3718
    }
#line 3718
   /* update xpp and tp */
#line 3718
    xp += ni;
#line 3718
    tp += ni;
#line 3718
    *xpp = (void*)xp;
#line 3718
  }
#line 3718
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3718

#line 3718
#else   /* not SX */
#line 3718

#line 3718
	char *xp = (char *) *xpp;
#line 3718
	int status = NC_NOERR;
#line 3718

#line 3718
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3718
	{
#line 3718
		int lstatus = ncx_put_ulonglong_short(xp, tp, fillp);
#line 3718
		if (status == NC_NOERR) /* report the first encountered error */
#line 3718
			status = lstatus;
#line 3718
	}
#line 3718

#line 3718
	*xpp = (void *)xp;
#line 3718
	return status;
#line 3718
#endif
#line 3718
}
#line 3718

int
#line 3719
ncx_putn_ulonglong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3719
{
#line 3719
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3719

#line 3719
 /* basic algorithm is:
#line 3719
  *   - ensure sane alignment of output data
#line 3719
  *   - copy (conversion happens automatically) input data
#line 3719
  *     to output
#line 3719
  *   - update tp to point at next unconverted input, and xpp to point
#line 3719
  *     at next location for converted output
#line 3719
  */
#line 3719
  long i, j, ni;
#line 3719
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3719
  uint64 *xp;
#line 3719
  int nrange = 0;         /* number of range errors */
#line 3719
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3719
  long cxp = (long) *((char**)xpp);
#line 3719

#line 3719
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3719
  /* sjl: manually stripmine so we can limit amount of
#line 3719
   * vector work space reserved to LOOPCNT elements. Also
#line 3719
   * makes vectorisation easy */
#line 3719
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3719
    ni=Min(nelems-j,LOOPCNT);
#line 3719
    if (realign) {
#line 3719
      xp = tmp;
#line 3719
    } else {
#line 3719
      xp = (uint64 *) *xpp;
#line 3719
    }
#line 3719
   /* copy the next block */
#line 3719
#pragma cdir loopcnt=LOOPCNT
#line 3719
#pragma cdir shortloop
#line 3719
    for (i=0; i<ni; i++) {
#line 3719
      /* the normal case: */
#line 3719
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3719
     /* test for range errors (not always needed but do it anyway) */
#line 3719
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3719
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3719
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3719
    }
#line 3719
   /* copy workspace back if necessary */
#line 3719
    if (realign) {
#line 3719
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3719
      xp = (uint64 *) *xpp;
#line 3719
    }
#line 3719
   /* update xpp and tp */
#line 3719
    xp += ni;
#line 3719
    tp += ni;
#line 3719
    *xpp = (void*)xp;
#line 3719
  }
#line 3719
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3719

#line 3719
#else   /* not SX */
#line 3719

#line 3719
	char *xp = (char *) *xpp;
#line 3719
	int status = NC_NOERR;
#line 3719

#line 3719
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3719
	{
#line 3719
		int lstatus = ncx_put_ulonglong_int(xp, tp, fillp);
#line 3719
		if (status == NC_NOERR) /* report the first encountered error */
#line 3719
			status = lstatus;
#line 3719
	}
#line 3719

#line 3719
	*xpp = (void *)xp;
#line 3719
	return status;
#line 3719
#endif
#line 3719
}
#line 3719

int
#line 3720
ncx_putn_ulonglong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3720
{
#line 3720
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3720

#line 3720
 /* basic algorithm is:
#line 3720
  *   - ensure sane alignment of output data
#line 3720
  *   - copy (conversion happens automatically) input data
#line 3720
  *     to output
#line 3720
  *   - update tp to point at next unconverted input, and xpp to point
#line 3720
  *     at next location for converted output
#line 3720
  */
#line 3720
  long i, j, ni;
#line 3720
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3720
  uint64 *xp;
#line 3720
  int nrange = 0;         /* number of range errors */
#line 3720
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3720
  long cxp = (long) *((char**)xpp);
#line 3720

#line 3720
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3720
  /* sjl: manually stripmine so we can limit amount of
#line 3720
   * vector work space reserved to LOOPCNT elements. Also
#line 3720
   * makes vectorisation easy */
#line 3720
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3720
    ni=Min(nelems-j,LOOPCNT);
#line 3720
    if (realign) {
#line 3720
      xp = tmp;
#line 3720
    } else {
#line 3720
      xp = (uint64 *) *xpp;
#line 3720
    }
#line 3720
   /* copy the next block */
#line 3720
#pragma cdir loopcnt=LOOPCNT
#line 3720
#pragma cdir shortloop
#line 3720
    for (i=0; i<ni; i++) {
#line 3720
      /* the normal case: */
#line 3720
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3720
     /* test for range errors (not always needed but do it anyway) */
#line 3720
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3720
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3720
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3720
    }
#line 3720
   /* copy workspace back if necessary */
#line 3720
    if (realign) {
#line 3720
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3720
      xp = (uint64 *) *xpp;
#line 3720
    }
#line 3720
   /* update xpp and tp */
#line 3720
    xp += ni;
#line 3720
    tp += ni;
#line 3720
    *xpp = (void*)xp;
#line 3720
  }
#line 3720
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3720

#line 3720
#else   /* not SX */
#line 3720

#line 3720
	char *xp = (char *) *xpp;
#line 3720
	int status = NC_NOERR;
#line 3720

#line 3720
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3720
	{
#line 3720
		int lstatus = ncx_put_ulonglong_long(xp, tp, fillp);
#line 3720
		if (status == NC_NOERR) /* report the first encountered error */
#line 3720
			status = lstatus;
#line 3720
	}
#line 3720

#line 3720
	*xpp = (void *)xp;
#line 3720
	return status;
#line 3720
#endif
#line 3720
}
#line 3720

int
#line 3721
ncx_putn_ulonglong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3721
{
#line 3721
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3721

#line 3721
 /* basic algorithm is:
#line 3721
  *   - ensure sane alignment of output data
#line 3721
  *   - copy (conversion happens automatically) input data
#line 3721
  *     to output
#line 3721
  *   - update tp to point at next unconverted input, and xpp to point
#line 3721
  *     at next location for converted output
#line 3721
  */
#line 3721
  long i, j, ni;
#line 3721
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3721
  uint64 *xp;
#line 3721
  int nrange = 0;         /* number of range errors */
#line 3721
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3721
  long cxp = (long) *((char**)xpp);
#line 3721

#line 3721
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3721
  /* sjl: manually stripmine so we can limit amount of
#line 3721
   * vector work space reserved to LOOPCNT elements. Also
#line 3721
   * makes vectorisation easy */
#line 3721
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3721
    ni=Min(nelems-j,LOOPCNT);
#line 3721
    if (realign) {
#line 3721
      xp = tmp;
#line 3721
    } else {
#line 3721
      xp = (uint64 *) *xpp;
#line 3721
    }
#line 3721
   /* copy the next block */
#line 3721
#pragma cdir loopcnt=LOOPCNT
#line 3721
#pragma cdir shortloop
#line 3721
    for (i=0; i<ni; i++) {
#line 3721
      /* the normal case: */
#line 3721
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3721
     /* test for range errors (not always needed but do it anyway) */
#line 3721
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3721
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3721
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3721
    }
#line 3721
   /* copy workspace back if necessary */
#line 3721
    if (realign) {
#line 3721
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3721
      xp = (uint64 *) *xpp;
#line 3721
    }
#line 3721
   /* update xpp and tp */
#line 3721
    xp += ni;
#line 3721
    tp += ni;
#line 3721
    *xpp = (void*)xp;
#line 3721
  }
#line 3721
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3721

#line 3721
#else   /* not SX */
#line 3721

#line 3721
	char *xp = (char *) *xpp;
#line 3721
	int status = NC_NOERR;
#line 3721

#line 3721
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3721
	{
#line 3721
		int lstatus = ncx_put_ulonglong_float(xp, tp, fillp);
#line 3721
		if (status == NC_NOERR) /* report the first encountered error */
#line 3721
			status = lstatus;
#line 3721
	}
#line 3721

#line 3721
	*xpp = (void *)xp;
#line 3721
	return status;
#line 3721
#endif
#line 3721
}
#line 3721

int
#line 3722
ncx_putn_ulonglong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3722
{
#line 3722
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3722

#line 3722
 /* basic algorithm is:
#line 3722
  *   - ensure sane alignment of output data
#line 3722
  *   - copy (conversion happens automatically) input data
#line 3722
  *     to output
#line 3722
  *   - update tp to point at next unconverted input, and xpp to point
#line 3722
  *     at next location for converted output
#line 3722
  */
#line 3722
  long i, j, ni;
#line 3722
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3722
  uint64 *xp;
#line 3722
  int nrange = 0;         /* number of range errors */
#line 3722
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3722
  long cxp = (long) *((char**)xpp);
#line 3722

#line 3722
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3722
  /* sjl: manually stripmine so we can limit amount of
#line 3722
   * vector work space reserved to LOOPCNT elements. Also
#line 3722
   * makes vectorisation easy */
#line 3722
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3722
    ni=Min(nelems-j,LOOPCNT);
#line 3722
    if (realign) {
#line 3722
      xp = tmp;
#line 3722
    } else {
#line 3722
      xp = (uint64 *) *xpp;
#line 3722
    }
#line 3722
   /* copy the next block */
#line 3722
#pragma cdir loopcnt=LOOPCNT
#line 3722
#pragma cdir shortloop
#line 3722
    for (i=0; i<ni; i++) {
#line 3722
      /* the normal case: */
#line 3722
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3722
     /* test for range errors (not always needed but do it anyway) */
#line 3722
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3722
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3722
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3722
    }
#line 3722
   /* copy workspace back if necessary */
#line 3722
    if (realign) {
#line 3722
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3722
      xp = (uint64 *) *xpp;
#line 3722
    }
#line 3722
   /* update xpp and tp */
#line 3722
    xp += ni;
#line 3722
    tp += ni;
#line 3722
    *xpp = (void*)xp;
#line 3722
  }
#line 3722
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3722

#line 3722
#else   /* not SX */
#line 3722

#line 3722
	char *xp = (char *) *xpp;
#line 3722
	int status = NC_NOERR;
#line 3722

#line 3722
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3722
	{
#line 3722
		int lstatus = ncx_put_ulonglong_double(xp, tp, fillp);
#line 3722
		if (status == NC_NOERR) /* report the first encountered error */
#line 3722
			status = lstatus;
#line 3722
	}
#line 3722

#line 3722
	*xpp = (void *)xp;
#line 3722
	return status;
#line 3722
#endif
#line 3722
}
#line 3722

int
#line 3723
ncx_putn_ulonglong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3723
{
#line 3723
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3723

#line 3723
 /* basic algorithm is:
#line 3723
  *   - ensure sane alignment of output data
#line 3723
  *   - copy (conversion happens automatically) input data
#line 3723
  *     to output
#line 3723
  *   - update tp to point at next unconverted input, and xpp to point
#line 3723
  *     at next location for converted output
#line 3723
  */
#line 3723
  long i, j, ni;
#line 3723
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3723
  uint64 *xp;
#line 3723
  int nrange = 0;         /* number of range errors */
#line 3723
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3723
  long cxp = (long) *((char**)xpp);
#line 3723

#line 3723
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3723
  /* sjl: manually stripmine so we can limit amount of
#line 3723
   * vector work space reserved to LOOPCNT elements. Also
#line 3723
   * makes vectorisation easy */
#line 3723
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3723
    ni=Min(nelems-j,LOOPCNT);
#line 3723
    if (realign) {
#line 3723
      xp = tmp;
#line 3723
    } else {
#line 3723
      xp = (uint64 *) *xpp;
#line 3723
    }
#line 3723
   /* copy the next block */
#line 3723
#pragma cdir loopcnt=LOOPCNT
#line 3723
#pragma cdir shortloop
#line 3723
    for (i=0; i<ni; i++) {
#line 3723
      /* the normal case: */
#line 3723
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3723
     /* test for range errors (not always needed but do it anyway) */
#line 3723
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3723
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3723
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3723
    }
#line 3723
   /* copy workspace back if necessary */
#line 3723
    if (realign) {
#line 3723
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3723
      xp = (uint64 *) *xpp;
#line 3723
    }
#line 3723
   /* update xpp and tp */
#line 3723
    xp += ni;
#line 3723
    tp += ni;
#line 3723
    *xpp = (void*)xp;
#line 3723
  }
#line 3723
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3723

#line 3723
#else   /* not SX */
#line 3723

#line 3723
	char *xp = (char *) *xpp;
#line 3723
	int status = NC_NOERR;
#line 3723

#line 3723
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3723
	{
#line 3723
		int lstatus = ncx_put_ulonglong_longlong(xp, tp, fillp);
#line 3723
		if (status == NC_NOERR) /* report the first encountered error */
#line 3723
			status = lstatus;
#line 3723
	}
#line 3723

#line 3723
	*xpp = (void *)xp;
#line 3723
	return status;
#line 3723
#endif
#line 3723
}
#line 3723

int
#line 3724
ncx_putn_ulonglong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3724
{
#line 3724
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3724

#line 3724
 /* basic algorithm is:
#line 3724
  *   - ensure sane alignment of output data
#line 3724
  *   - copy (conversion happens automatically) input data
#line 3724
  *     to output
#line 3724
  *   - update tp to point at next unconverted input, and xpp to point
#line 3724
  *     at next location for converted output
#line 3724
  */
#line 3724
  long i, j, ni;
#line 3724
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3724
  uint64 *xp;
#line 3724
  int nrange = 0;         /* number of range errors */
#line 3724
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3724
  long cxp = (long) *((char**)xpp);
#line 3724

#line 3724
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3724
  /* sjl: manually stripmine so we can limit amount of
#line 3724
   * vector work space reserved to LOOPCNT elements. Also
#line 3724
   * makes vectorisation easy */
#line 3724
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3724
    ni=Min(nelems-j,LOOPCNT);
#line 3724
    if (realign) {
#line 3724
      xp = tmp;
#line 3724
    } else {
#line 3724
      xp = (uint64 *) *xpp;
#line 3724
    }
#line 3724
   /* copy the next block */
#line 3724
#pragma cdir loopcnt=LOOPCNT
#line 3724
#pragma cdir shortloop
#line 3724
    for (i=0; i<ni; i++) {
#line 3724
      /* the normal case: */
#line 3724
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3724
     /* test for range errors (not always needed but do it anyway) */
#line 3724
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3724
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3724
      nrange += tp[i] > X_UINT64_MAX ;
#line 3724
    }
#line 3724
   /* copy workspace back if necessary */
#line 3724
    if (realign) {
#line 3724
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3724
      xp = (uint64 *) *xpp;
#line 3724
    }
#line 3724
   /* update xpp and tp */
#line 3724
    xp += ni;
#line 3724
    tp += ni;
#line 3724
    *xpp = (void*)xp;
#line 3724
  }
#line 3724
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3724

#line 3724
#else   /* not SX */
#line 3724

#line 3724
	char *xp = (char *) *xpp;
#line 3724
	int status = NC_NOERR;
#line 3724

#line 3724
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3724
	{
#line 3724
		int lstatus = ncx_put_ulonglong_uchar(xp, tp, fillp);
#line 3724
		if (status == NC_NOERR) /* report the first encountered error */
#line 3724
			status = lstatus;
#line 3724
	}
#line 3724

#line 3724
	*xpp = (void *)xp;
#line 3724
	return status;
#line 3724
#endif
#line 3724
}
#line 3724

int
#line 3725
ncx_putn_ulonglong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3725
{
#line 3725
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3725

#line 3725
 /* basic algorithm is:
#line 3725
  *   - ensure sane alignment of output data
#line 3725
  *   - copy (conversion happens automatically) input data
#line 3725
  *     to output
#line 3725
  *   - update tp to point at next unconverted input, and xpp to point
#line 3725
  *     at next location for converted output
#line 3725
  */
#line 3725
  long i, j, ni;
#line 3725
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3725
  uint64 *xp;
#line 3725
  int nrange = 0;         /* number of range errors */
#line 3725
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3725
  long cxp = (long) *((char**)xpp);
#line 3725

#line 3725
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3725
  /* sjl: manually stripmine so we can limit amount of
#line 3725
   * vector work space reserved to LOOPCNT elements. Also
#line 3725
   * makes vectorisation easy */
#line 3725
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3725
    ni=Min(nelems-j,LOOPCNT);
#line 3725
    if (realign) {
#line 3725
      xp = tmp;
#line 3725
    } else {
#line 3725
      xp = (uint64 *) *xpp;
#line 3725
    }
#line 3725
   /* copy the next block */
#line 3725
#pragma cdir loopcnt=LOOPCNT
#line 3725
#pragma cdir shortloop
#line 3725
    for (i=0; i<ni; i++) {
#line 3725
      /* the normal case: */
#line 3725
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3725
     /* test for range errors (not always needed but do it anyway) */
#line 3725
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3725
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3725
      nrange += tp[i] > X_UINT64_MAX ;
#line 3725
    }
#line 3725
   /* copy workspace back if necessary */
#line 3725
    if (realign) {
#line 3725
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3725
      xp = (uint64 *) *xpp;
#line 3725
    }
#line 3725
   /* update xpp and tp */
#line 3725
    xp += ni;
#line 3725
    tp += ni;
#line 3725
    *xpp = (void*)xp;
#line 3725
  }
#line 3725
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3725

#line 3725
#else   /* not SX */
#line 3725

#line 3725
	char *xp = (char *) *xpp;
#line 3725
	int status = NC_NOERR;
#line 3725

#line 3725
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3725
	{
#line 3725
		int lstatus = ncx_put_ulonglong_ushort(xp, tp, fillp);
#line 3725
		if (status == NC_NOERR) /* report the first encountered error */
#line 3725
			status = lstatus;
#line 3725
	}
#line 3725

#line 3725
	*xpp = (void *)xp;
#line 3725
	return status;
#line 3725
#endif
#line 3725
}
#line 3725

int
#line 3726
ncx_putn_ulonglong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3726
{
#line 3726
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3726

#line 3726
 /* basic algorithm is:
#line 3726
  *   - ensure sane alignment of output data
#line 3726
  *   - copy (conversion happens automatically) input data
#line 3726
  *     to output
#line 3726
  *   - update tp to point at next unconverted input, and xpp to point
#line 3726
  *     at next location for converted output
#line 3726
  */
#line 3726
  long i, j, ni;
#line 3726
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3726
  uint64 *xp;
#line 3726
  int nrange = 0;         /* number of range errors */
#line 3726
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3726
  long cxp = (long) *((char**)xpp);
#line 3726

#line 3726
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3726
  /* sjl: manually stripmine so we can limit amount of
#line 3726
   * vector work space reserved to LOOPCNT elements. Also
#line 3726
   * makes vectorisation easy */
#line 3726
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3726
    ni=Min(nelems-j,LOOPCNT);
#line 3726
    if (realign) {
#line 3726
      xp = tmp;
#line 3726
    } else {
#line 3726
      xp = (uint64 *) *xpp;
#line 3726
    }
#line 3726
   /* copy the next block */
#line 3726
#pragma cdir loopcnt=LOOPCNT
#line 3726
#pragma cdir shortloop
#line 3726
    for (i=0; i<ni; i++) {
#line 3726
      /* the normal case: */
#line 3726
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3726
     /* test for range errors (not always needed but do it anyway) */
#line 3726
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3726
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3726
      nrange += tp[i] > X_UINT64_MAX ;
#line 3726
    }
#line 3726
   /* copy workspace back if necessary */
#line 3726
    if (realign) {
#line 3726
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3726
      xp = (uint64 *) *xpp;
#line 3726
    }
#line 3726
   /* update xpp and tp */
#line 3726
    xp += ni;
#line 3726
    tp += ni;
#line 3726
    *xpp = (void*)xp;
#line 3726
  }
#line 3726
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3726

#line 3726
#else   /* not SX */
#line 3726

#line 3726
	char *xp = (char *) *xpp;
#line 3726
	int status = NC_NOERR;
#line 3726

#line 3726
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3726
	{
#line 3726
		int lstatus = ncx_put_ulonglong_uint(xp, tp, fillp);
#line 3726
		if (status == NC_NOERR) /* report the first encountered error */
#line 3726
			status = lstatus;
#line 3726
	}
#line 3726

#line 3726
	*xpp = (void *)xp;
#line 3726
	return status;
#line 3726
#endif
#line 3726
}
#line 3726



/*
 * Other aggregate conversion functions.
 */

/* text */

int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3738
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3738
	return NC_NOERR;
#line 3738

}

int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3744

#line 3744
	if (rndup)
#line 3744
		rndup = X_ALIGN - rndup;
#line 3744

#line 3744
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3744
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3744

#line 3744
	return NC_NOERR;
#line 3744

}

int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3750
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3750

#line 3750
	return NC_NOERR;
#line 3750

}

int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3756

#line 3756
	if (rndup)
#line 3756
		rndup = X_ALIGN - rndup;
#line 3756

#line 3756
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3756
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3756

#line 3756
	if (rndup)
#line 3756
	{
#line 3756
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3756
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3756
	}
#line 3756

#line 3756
	return NC_NOERR;
#line 3756

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3765
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3765
	return NC_NOERR;
#line 3765

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3771

#line 3771
	if (rndup)
#line 3771
		rndup = X_ALIGN - rndup;
#line 3771

#line 3771
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3771
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3771

#line 3771
	return NC_NOERR;
#line 3771

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3777
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3777

#line 3777
	return NC_NOERR;
#line 3777

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3783

#line 3783
	if (rndup)
#line 3783
		rndup = X_ALIGN - rndup;
#line 3783

#line 3783
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3783
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3783

#line 3783
	if (rndup)
#line 3783
	{
#line 3783
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3783
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3783
	}
#line 3783

#line 3783
	return NC_NOERR;
#line 3783

}
