# This file is part of the nesC compiler.
#    Copyright (C) 2002 Intel Corporation
# 
# The attached "nesC" software is provided to you under the terms and
# conditions of the GNU General Public License Version 2 as published by the
# Free Software Foundation.
# 
# nesC is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with nesC; see the file COPYING.  If not, write to
# the Free Software Foundation, 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

true;

sub gen() {
    print "/**\n";
    print " * This file is automatically generated by ncg. DO NOT EDIT THIS FILE.\n";
    print " * It includes values of some nesC constants from\n";
    print " * $cfile.\n";
    print " */\n\n";

    print "enum {\n";
    foreach $name (keys %csts) {
	$val = $csts{$name};
	# Find smallest type that will hold val to avoid annoying
	# java "loss of precision" errors
	print ",\n" if $notfirst;
	$notfirst = 1;
	$name = "${c_prefix}_$name" if $c_prefix;
	print "    $name = $val";
    }

    print "\n};\n";
}
