/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "globus_object_hierarchy.h"
#include "globus_libc.h"

/* the following code all generated by running the script
 * ./globus_object_hierarchy.h.sh definitions < globus_object_hierarchy.idl
 */

const globus_object_type_t GLOBUS_OBJECT_TYPE_RESOURCE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_PRINTABLE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_RESOURCE   */
extern globus_object_t *
globus_object_construct_resource (
)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_RESOURCE);

  object = globus_object_initialize_resource (
    newobject
);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_RESOURCE   */
extern globus_object_t *
globus_object_initialize_resource (
    globus_object_t * object
)
{

  return globus_object_initialize_printable (
    object
);
}


typedef struct globus_object_computer_instance_s {
  char *   computer_hostname;
} globus_object_computer_instance_t;

static globus_object_computer_instance_t *
globus_l_object_computer_instance_data (globus_object_t *object)
{
  globus_object_computer_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_COMPUTER);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_computer_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_computer_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->computer_hostname = NULL;
    return instance_data;
  }
}

static void globus_l_object_computer_copy (void *srcvp, void **dstvpp)
{
  globus_object_computer_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_computer_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_computer_instance_t));
  dst = ((globus_object_computer_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->computer_hostname = src->computer_hostname;
}

static void globus_l_object_computer_destroy (void *datavp)
{
  globus_object_computer_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_computer_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_COMPUTER_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_RESOURCE_DEFINITION),
        globus_l_object_computer_copy,
        globus_l_object_computer_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_COMPUTER   */
extern globus_object_t *
globus_object_construct_computer (
    char * computer_hostname)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_COMPUTER);

  object = globus_object_initialize_computer (
    newobject,
    computer_hostname);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_COMPUTER   */
extern globus_object_t *
globus_object_initialize_computer (
    globus_object_t * object,
    char * computer_hostname)
{
  globus_object_computer_set_computer_hostname (object, computer_hostname);

  return globus_object_initialize_resource (
    object
);
}

/* return the computer_hostname instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_COMPUTER   */
extern char *
globus_object_computer_get_computer_hostname (globus_object_t * object)
{
  globus_object_computer_instance_t * instance_data;
  instance_data
   = globus_l_object_computer_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->computer_hostname);
  }
  else return NULL;
}

/* set the computer_hostname instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_COMPUTER   */
extern void
globus_object_computer_set_computer_hostname (
    globus_object_t * object,
    char * value)
{
  globus_object_computer_instance_t * instance_data;
  instance_data
   = globus_l_object_computer_instance_data (object);
  if (instance_data != NULL) {
    instance_data->computer_hostname = value;
  }
}


typedef struct globus_object_gram_resource_instance_s {
  char *   gram_resource_contact;
} globus_object_gram_resource_instance_t;

static globus_object_gram_resource_instance_t *
globus_l_object_gram_resource_instance_data (globus_object_t *object)
{
  globus_object_gram_resource_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_GRAM_RESOURCE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_gram_resource_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_gram_resource_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->gram_resource_contact = NULL;
    return instance_data;
  }
}

static void globus_l_object_gram_resource_copy (void *srcvp, void **dstvpp)
{
  globus_object_gram_resource_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_gram_resource_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_gram_resource_instance_t));
  dst = ((globus_object_gram_resource_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->gram_resource_contact = src->gram_resource_contact;
}

static void globus_l_object_gram_resource_destroy (void *datavp)
{
  globus_object_gram_resource_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_gram_resource_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_GRAM_RESOURCE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_COMPUTER_DEFINITION),
        globus_l_object_gram_resource_copy,
        globus_l_object_gram_resource_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_GRAM_RESOURCE   */
extern globus_object_t *
globus_object_construct_gram_resource (
    char * computer_hostname,
    char * gram_resource_contact)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_GRAM_RESOURCE);

  object = globus_object_initialize_gram_resource (
    newobject,
    computer_hostname,
    gram_resource_contact);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_GRAM_RESOURCE   */
extern globus_object_t *
globus_object_initialize_gram_resource (
    globus_object_t * object,
    char * computer_hostname,
    char * gram_resource_contact)
{
  globus_object_gram_resource_set_gram_resource_contact (object, gram_resource_contact);

  return globus_object_initialize_computer (
    object,
    computer_hostname);
}

/* return the gram_resource_contact instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRAM_RESOURCE   */
extern char *
globus_object_gram_resource_get_gram_resource_contact (globus_object_t * object)
{
  globus_object_gram_resource_instance_t * instance_data;
  instance_data
   = globus_l_object_gram_resource_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->gram_resource_contact);
  }
  else return NULL;
}

/* set the gram_resource_contact instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRAM_RESOURCE   */
extern void
globus_object_gram_resource_set_gram_resource_contact (
    globus_object_t * object,
    char * value)
{
  globus_object_gram_resource_instance_t * instance_data;
  instance_data
   = globus_l_object_gram_resource_instance_data (object);
  if (instance_data != NULL) {
    instance_data->gram_resource_contact = value;
  }
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_FD_TABLE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_RESOURCE_DEFINITION),
        NULL,
        NULL,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_FD_TABLE   */
extern globus_object_t *
globus_object_construct_fd_table (
)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_FD_TABLE);

  object = globus_object_initialize_fd_table (
    newobject
);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_FD_TABLE   */
extern globus_object_t *
globus_object_initialize_fd_table (
    globus_object_t * object
)
{

  return globus_object_initialize_resource (
    object
);
}


typedef struct globus_object_storage_instance_s {
  long   storage_size;
} globus_object_storage_instance_t;

static globus_object_storage_instance_t *
globus_l_object_storage_instance_data (globus_object_t *object)
{
  globus_object_storage_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_STORAGE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_storage_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_storage_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->storage_size = -1;
    return instance_data;
  }
}

static void globus_l_object_storage_copy (void *srcvp, void **dstvpp)
{
  globus_object_storage_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_storage_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_storage_instance_t));
  dst = ((globus_object_storage_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->storage_size = src->storage_size;
}

static void globus_l_object_storage_destroy (void *datavp)
{
  globus_object_storage_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_storage_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_STORAGE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_RESOURCE_DEFINITION),
        globus_l_object_storage_copy,
        globus_l_object_storage_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_STORAGE   */
extern globus_object_t *
globus_object_construct_storage (
    long storage_size)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_STORAGE);

  object = globus_object_initialize_storage (
    newobject,
    storage_size);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_STORAGE   */
extern globus_object_t *
globus_object_initialize_storage (
    globus_object_t * object,
    long storage_size)
{
  globus_object_storage_set_storage_size (object, storage_size);

  return globus_object_initialize_resource (
    object
);
}

/* return the storage_size instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_STORAGE   */
extern long
globus_object_storage_get_storage_size (globus_object_t * object)
{
  globus_object_storage_instance_t * instance_data;
  instance_data
   = globus_l_object_storage_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->storage_size);
  }
  else return -1;
}

/* set the storage_size instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_STORAGE   */
extern void
globus_object_storage_set_storage_size (
    globus_object_t * object,
    long value)
{
  globus_object_storage_instance_t * instance_data;
  instance_data
   = globus_l_object_storage_instance_data (object);
  if (instance_data != NULL) {
    instance_data->storage_size = value;
  }
}


typedef struct globus_object_file_instance_s {
  char *   file_filename;
  int   file_fd;
  FILE*   file_filep;
} globus_object_file_instance_t;

static globus_object_file_instance_t *
globus_l_object_file_instance_data (globus_object_t *object)
{
  globus_object_file_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_FILE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_file_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_file_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->file_filename = NULL;
    instance_data->file_fd = -1;
    instance_data->file_filep = NULL;
    return instance_data;
  }
}

static void globus_l_object_file_copy (void *srcvp, void **dstvpp)
{
  globus_object_file_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_file_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_file_instance_t));
  dst = ((globus_object_file_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->file_filename = src->file_filename;
  dst->file_fd = src->file_fd;
  dst->file_filep = src->file_filep;
}

static void globus_l_object_file_destroy (void *datavp)
{
  globus_object_file_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_file_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_FILE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_STORAGE_DEFINITION),
        globus_l_object_file_copy,
        globus_l_object_file_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_FILE   */
extern globus_object_t *
globus_object_construct_file (
    long storage_size,
    char * file_filename,
    int file_fd,
    FILE* file_filep)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_FILE);

  object = globus_object_initialize_file (
    newobject,
    storage_size,
    file_filename,
    file_fd,
    file_filep);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_FILE   */
extern globus_object_t *
globus_object_initialize_file (
    globus_object_t * object,
    long storage_size,
    char * file_filename,
    int file_fd,
    FILE* file_filep)
{
  globus_object_file_set_file_filename (object, file_filename);
  globus_object_file_set_file_fd (object, file_fd);
  globus_object_file_set_file_filep (object, file_filep);

  return globus_object_initialize_storage (
    object,
    storage_size);
}

/* return the file_filename instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_FILE   */
extern char *
globus_object_file_get_file_filename (globus_object_t * object)
{
  globus_object_file_instance_t * instance_data;
  instance_data
   = globus_l_object_file_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->file_filename);
  }
  else return NULL;
}

/* set the file_filename instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_FILE   */
extern void
globus_object_file_set_file_filename (
    globus_object_t * object,
    char * value)
{
  globus_object_file_instance_t * instance_data;
  instance_data
   = globus_l_object_file_instance_data (object);
  if (instance_data != NULL) {
    instance_data->file_filename = value;
  }
}

/* return the file_fd instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_FILE   */
extern int
globus_object_file_get_file_fd (globus_object_t * object)
{
  globus_object_file_instance_t * instance_data;
  instance_data
   = globus_l_object_file_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->file_fd);
  }
  else return -1;
}

/* set the file_fd instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_FILE   */
extern void
globus_object_file_set_file_fd (
    globus_object_t * object,
    int value)
{
  globus_object_file_instance_t * instance_data;
  instance_data
   = globus_l_object_file_instance_data (object);
  if (instance_data != NULL) {
    instance_data->file_fd = value;
  }
}

/* return the file_filep instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_FILE   */
extern FILE*
globus_object_file_get_file_filep (globus_object_t * object)
{
  globus_object_file_instance_t * instance_data;
  instance_data
   = globus_l_object_file_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->file_filep);
  }
  else return NULL;
}

/* set the file_filep instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_FILE   */
extern void
globus_object_file_set_file_filep (
    globus_object_t * object,
    FILE* value)
{
  globus_object_file_instance_t * instance_data;
  instance_data
   = globus_l_object_file_instance_data (object);
  if (instance_data != NULL) {
    instance_data->file_filep = value;
  }
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_MEMORY_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_STORAGE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_MEMORY   */
extern globus_object_t *
globus_object_construct_memory (
    long storage_size)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_MEMORY);

  object = globus_object_initialize_memory (
    newobject,
    storage_size);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_MEMORY   */
extern globus_object_t *
globus_object_initialize_memory (
    globus_object_t * object,
    long storage_size)
{

  return globus_object_initialize_storage (
    object,
    storage_size);
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_BUFFER_POOL_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_STORAGE_DEFINITION),
        NULL,
        NULL,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_BUFFER_POOL   */
extern globus_object_t *
globus_object_construct_buffer_pool (
    long storage_size)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_BUFFER_POOL);

  object = globus_object_initialize_buffer_pool (
    newobject,
    storage_size);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_BUFFER_POOL   */
extern globus_object_t *
globus_object_initialize_buffer_pool (
    globus_object_t * object,
    long storage_size)
{

  return globus_object_initialize_storage (
    object,
    storage_size);
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_COMMUNICATOR_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_RESOURCE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_COMMUNICATOR   */
extern globus_object_t *
globus_object_construct_communicator (
)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_COMMUNICATOR);

  object = globus_object_initialize_communicator (
    newobject
);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_COMMUNICATOR   */
extern globus_object_t *
globus_object_initialize_communicator (
    globus_object_t * object
)
{

  return globus_object_initialize_resource (
    object
);
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_SOCKET_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_COMMUNICATOR_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_SOCKET   */
extern globus_object_t *
globus_object_construct_socket (
)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_SOCKET);

  object = globus_object_initialize_socket (
    newobject
);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_SOCKET   */
extern globus_object_t *
globus_object_initialize_socket (
    globus_object_t * object
)
{

  return globus_object_initialize_communicator (
    object
);
}


typedef struct globus_object_task_instance_s {
  globus_object_t *   task_request;
} globus_object_task_instance_t;

static globus_object_task_instance_t *
globus_l_object_task_instance_data (globus_object_t *object)
{
  globus_object_task_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_TASK);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_task_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_task_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->task_request = NULL;
    return instance_data;
  }
}

static void globus_l_object_task_copy (void *srcvp, void **dstvpp)
{
  globus_object_task_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_task_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_task_instance_t));
  dst = ((globus_object_task_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->task_request = globus_object_copy(src->task_request);
}

static void globus_l_object_task_destroy (void *datavp)
{
  globus_object_task_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_task_instance_t *) datavp);
  globus_object_free (data->task_request);
  data->task_request = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_TASK_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_PRINTABLE_DEFINITION),
        globus_l_object_task_copy,
        globus_l_object_task_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_TASK   */
extern globus_object_t *
globus_object_construct_task (
    globus_object_t * task_request)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_TASK);

  object = globus_object_initialize_task (
    newobject,
    task_request);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_TASK   */
extern globus_object_t *
globus_object_initialize_task (
    globus_object_t * object,
    globus_object_t * task_request)
{
  globus_object_task_set_task_request (object, task_request);

  return globus_object_initialize_printable (
    object
);
}

/* return the task_request instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_TASK   */
extern globus_object_t *
globus_object_task_get_task_request (globus_object_t * object)
{
  globus_object_task_instance_t * instance_data;
  instance_data
   = globus_l_object_task_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->task_request);
  }
  else return NULL;
}

/* set the task_request instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_TASK   */
extern void
globus_object_task_set_task_request (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_task_instance_t * instance_data;
  instance_data
   = globus_l_object_task_instance_data (object);
  if (instance_data != NULL) {
    instance_data->task_request = value;
  }
}


typedef struct globus_object_process_instance_s {
  globus_object_t *   process_computer;
  long   process_pid;
} globus_object_process_instance_t;

static globus_object_process_instance_t *
globus_l_object_process_instance_data (globus_object_t *object)
{
  globus_object_process_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_PROCESS);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_process_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_process_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->process_computer = NULL;
    instance_data->process_pid = -1;
    return instance_data;
  }
}

static void globus_l_object_process_copy (void *srcvp, void **dstvpp)
{
  globus_object_process_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_process_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_process_instance_t));
  dst = ((globus_object_process_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->process_computer = globus_object_copy(src->process_computer);
  dst->process_pid = src->process_pid;
}

static void globus_l_object_process_destroy (void *datavp)
{
  globus_object_process_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_process_instance_t *) datavp);
  globus_object_free (data->process_computer);
  data->process_computer = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_PROCESS_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_TASK_DEFINITION),
        globus_l_object_process_copy,
        globus_l_object_process_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_PROCESS   */
extern globus_object_t *
globus_object_construct_process (
    globus_object_t * task_request,
    globus_object_t * process_computer,
    long process_pid)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_PROCESS);

  object = globus_object_initialize_process (
    newobject,
    task_request,
    process_computer,
    process_pid);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_PROCESS   */
extern globus_object_t *
globus_object_initialize_process (
    globus_object_t * object,
    globus_object_t * task_request,
    globus_object_t * process_computer,
    long process_pid)
{
  globus_object_process_set_process_computer (object, process_computer);
  globus_object_process_set_process_pid (object, process_pid);

  return globus_object_initialize_task (
    object,
    task_request);
}

/* return the process_computer instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_PROCESS   */
extern globus_object_t *
globus_object_process_get_process_computer (globus_object_t * object)
{
  globus_object_process_instance_t * instance_data;
  instance_data
   = globus_l_object_process_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->process_computer);
  }
  else return NULL;
}

/* set the process_computer instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_PROCESS   */
extern void
globus_object_process_set_process_computer (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_process_instance_t * instance_data;
  instance_data
   = globus_l_object_process_instance_data (object);
  if (instance_data != NULL) {
    instance_data->process_computer = value;
  }
}

/* return the process_pid instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_PROCESS   */
extern long
globus_object_process_get_process_pid (globus_object_t * object)
{
  globus_object_process_instance_t * instance_data;
  instance_data
   = globus_l_object_process_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->process_pid);
  }
  else return -1;
}

/* set the process_pid instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_PROCESS   */
extern void
globus_object_process_set_process_pid (
    globus_object_t * object,
    long value)
{
  globus_object_process_instance_t * instance_data;
  instance_data
   = globus_l_object_process_instance_data (object);
  if (instance_data != NULL) {
    instance_data->process_pid = value;
  }
}


typedef struct globus_object_gramjob_instance_s {
  globus_object_t *   gramjob_gram_resource;
  char *   gramjob_contact;
} globus_object_gramjob_instance_t;

static globus_object_gramjob_instance_t *
globus_l_object_gramjob_instance_data (globus_object_t *object)
{
  globus_object_gramjob_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_GRAMJOB);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_gramjob_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_gramjob_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->gramjob_gram_resource = NULL;
    instance_data->gramjob_contact = NULL;
    return instance_data;
  }
}

static void globus_l_object_gramjob_copy (void *srcvp, void **dstvpp)
{
  globus_object_gramjob_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_gramjob_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_gramjob_instance_t));
  dst = ((globus_object_gramjob_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->gramjob_gram_resource = globus_object_copy(src->gramjob_gram_resource);
  dst->gramjob_contact = src->gramjob_contact;
}

static void globus_l_object_gramjob_destroy (void *datavp)
{
  globus_object_gramjob_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_gramjob_instance_t *) datavp);
  globus_object_free (data->gramjob_gram_resource);
  data->gramjob_gram_resource = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_GRAMJOB_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_TASK_DEFINITION),
        globus_l_object_gramjob_copy,
        globus_l_object_gramjob_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_GRAMJOB   */
extern globus_object_t *
globus_object_construct_gramjob (
    globus_object_t * task_request,
    globus_object_t * gramjob_gram_resource,
    char * gramjob_contact)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_GRAMJOB);

  object = globus_object_initialize_gramjob (
    newobject,
    task_request,
    gramjob_gram_resource,
    gramjob_contact);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_GRAMJOB   */
extern globus_object_t *
globus_object_initialize_gramjob (
    globus_object_t * object,
    globus_object_t * task_request,
    globus_object_t * gramjob_gram_resource,
    char * gramjob_contact)
{
  globus_object_gramjob_set_gramjob_gram_resource (object, gramjob_gram_resource);
  globus_object_gramjob_set_gramjob_contact (object, gramjob_contact);

  return globus_object_initialize_task (
    object,
    task_request);
}

/* return the gramjob_gram_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRAMJOB   */
extern globus_object_t *
globus_object_gramjob_get_gramjob_gram_resource (globus_object_t * object)
{
  globus_object_gramjob_instance_t * instance_data;
  instance_data
   = globus_l_object_gramjob_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->gramjob_gram_resource);
  }
  else return NULL;
}

/* set the gramjob_gram_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRAMJOB   */
extern void
globus_object_gramjob_set_gramjob_gram_resource (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_gramjob_instance_t * instance_data;
  instance_data
   = globus_l_object_gramjob_instance_data (object);
  if (instance_data != NULL) {
    instance_data->gramjob_gram_resource = value;
  }
}

/* return the gramjob_contact instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRAMJOB   */
extern char *
globus_object_gramjob_get_gramjob_contact (globus_object_t * object)
{
  globus_object_gramjob_instance_t * instance_data;
  instance_data
   = globus_l_object_gramjob_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->gramjob_contact);
  }
  else return NULL;
}

/* set the gramjob_contact instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRAMJOB   */
extern void
globus_object_gramjob_set_gramjob_contact (
    globus_object_t * object,
    char * value)
{
  globus_object_gramjob_instance_t * instance_data;
  instance_data
   = globus_l_object_gramjob_instance_data (object);
  if (instance_data != NULL) {
    instance_data->gramjob_contact = value;
  }
}


typedef struct globus_object_operation_instance_s {
  globus_object_t *   operation_identity;
  globus_object_t *   operation_computer;
} globus_object_operation_instance_t;

static globus_object_operation_instance_t *
globus_l_object_operation_instance_data (globus_object_t *object)
{
  globus_object_operation_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_OPERATION);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_operation_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_operation_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->operation_identity = NULL;
    instance_data->operation_computer = NULL;
    return instance_data;
  }
}

static void globus_l_object_operation_copy (void *srcvp, void **dstvpp)
{
  globus_object_operation_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_operation_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_operation_instance_t));
  dst = ((globus_object_operation_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->operation_identity = globus_object_copy(src->operation_identity);
  dst->operation_computer = globus_object_copy(src->operation_computer);
}

static void globus_l_object_operation_destroy (void *datavp)
{
  globus_object_operation_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_operation_instance_t *) datavp);
  globus_object_free (data->operation_identity);
  data->operation_identity = NULL;
  globus_object_free (data->operation_computer);
  data->operation_computer = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_OPERATION_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_PRINTABLE_DEFINITION),
        globus_l_object_operation_copy,
        globus_l_object_operation_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_OPERATION   */
extern globus_object_t *
globus_object_construct_operation (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_OPERATION);

  object = globus_object_initialize_operation (
    newobject,
    operation_identity,
    operation_computer);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_OPERATION   */
extern globus_object_t *
globus_object_initialize_operation (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer)
{
  globus_object_operation_set_operation_identity (object, operation_identity);
  globus_object_operation_set_operation_computer (object, operation_computer);

  return globus_object_initialize_printable (
    object
);
}

/* return the operation_identity instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_OPERATION   */
extern globus_object_t *
globus_object_operation_get_operation_identity (globus_object_t * object)
{
  globus_object_operation_instance_t * instance_data;
  instance_data
   = globus_l_object_operation_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->operation_identity);
  }
  else return NULL;
}

/* set the operation_identity instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_OPERATION   */
extern void
globus_object_operation_set_operation_identity (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_operation_instance_t * instance_data;
  instance_data
   = globus_l_object_operation_instance_data (object);
  if (instance_data != NULL) {
    instance_data->operation_identity = value;
  }
}

/* return the operation_computer instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_OPERATION   */
extern globus_object_t *
globus_object_operation_get_operation_computer (globus_object_t * object)
{
  globus_object_operation_instance_t * instance_data;
  instance_data
   = globus_l_object_operation_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->operation_computer);
  }
  else return NULL;
}

/* set the operation_computer instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_OPERATION   */
extern void
globus_object_operation_set_operation_computer (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_operation_instance_t * instance_data;
  instance_data
   = globus_l_object_operation_instance_data (object);
  if (instance_data != NULL) {
    instance_data->operation_computer = value;
  }
}


typedef struct globus_object_read_instance_s {
  globus_object_t *   read_resource;
  long   read_offset;
  long   read_size;
} globus_object_read_instance_t;

static globus_object_read_instance_t *
globus_l_object_read_instance_data (globus_object_t *object)
{
  globus_object_read_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_READ);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_read_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_read_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->read_resource = NULL;
    instance_data->read_offset = -1;
    instance_data->read_size = -1;
    return instance_data;
  }
}

static void globus_l_object_read_copy (void *srcvp, void **dstvpp)
{
  globus_object_read_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_read_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_read_instance_t));
  dst = ((globus_object_read_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->read_resource = globus_object_copy(src->read_resource);
  dst->read_offset = src->read_offset;
  dst->read_size = src->read_size;
}

static void globus_l_object_read_destroy (void *datavp)
{
  globus_object_read_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_read_instance_t *) datavp);
  globus_object_free (data->read_resource);
  data->read_resource = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_READ_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_OPERATION_DEFINITION),
        globus_l_object_read_copy,
        globus_l_object_read_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_READ   */
extern globus_object_t *
globus_object_construct_read (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * read_resource,
    long read_offset,
    long read_size)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_READ);

  object = globus_object_initialize_read (
    newobject,
    operation_identity,
    operation_computer,
    read_resource,
    read_offset,
    read_size);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_READ   */
extern globus_object_t *
globus_object_initialize_read (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * read_resource,
    long read_offset,
    long read_size)
{
  globus_object_read_set_read_resource (object, read_resource);
  globus_object_read_set_read_offset (object, read_offset);
  globus_object_read_set_read_size (object, read_size);

  return globus_object_initialize_operation (
    object,
    operation_identity,
    operation_computer);
}

/* return the read_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_READ   */
extern globus_object_t *
globus_object_read_get_read_resource (globus_object_t * object)
{
  globus_object_read_instance_t * instance_data;
  instance_data
   = globus_l_object_read_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->read_resource);
  }
  else return NULL;
}

/* set the read_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_READ   */
extern void
globus_object_read_set_read_resource (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_read_instance_t * instance_data;
  instance_data
   = globus_l_object_read_instance_data (object);
  if (instance_data != NULL) {
    instance_data->read_resource = value;
  }
}

/* return the read_offset instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_READ   */
extern long
globus_object_read_get_read_offset (globus_object_t * object)
{
  globus_object_read_instance_t * instance_data;
  instance_data
   = globus_l_object_read_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->read_offset);
  }
  else return -1;
}

/* set the read_offset instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_READ   */
extern void
globus_object_read_set_read_offset (
    globus_object_t * object,
    long value)
{
  globus_object_read_instance_t * instance_data;
  instance_data
   = globus_l_object_read_instance_data (object);
  if (instance_data != NULL) {
    instance_data->read_offset = value;
  }
}

/* return the read_size instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_READ   */
extern long
globus_object_read_get_read_size (globus_object_t * object)
{
  globus_object_read_instance_t * instance_data;
  instance_data
   = globus_l_object_read_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->read_size);
  }
  else return -1;
}

/* set the read_size instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_READ   */
extern void
globus_object_read_set_read_size (
    globus_object_t * object,
    long value)
{
  globus_object_read_instance_t * instance_data;
  instance_data
   = globus_l_object_read_instance_data (object);
  if (instance_data != NULL) {
    instance_data->read_size = value;
  }
}


typedef struct globus_object_write_instance_s {
  globus_object_t *   write_resource;
  long   write_offset;
  long   write_size;
} globus_object_write_instance_t;

static globus_object_write_instance_t *
globus_l_object_write_instance_data (globus_object_t *object)
{
  globus_object_write_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_WRITE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_write_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_write_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->write_resource = NULL;
    instance_data->write_offset = -1;
    instance_data->write_size = -1;
    return instance_data;
  }
}

static void globus_l_object_write_copy (void *srcvp, void **dstvpp)
{
  globus_object_write_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_write_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_write_instance_t));
  dst = ((globus_object_write_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->write_resource = globus_object_copy(src->write_resource);
  dst->write_offset = src->write_offset;
  dst->write_size = src->write_size;
}

static void globus_l_object_write_destroy (void *datavp)
{
  globus_object_write_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_write_instance_t *) datavp);
  globus_object_free (data->write_resource);
  data->write_resource = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_WRITE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_OPERATION_DEFINITION),
        globus_l_object_write_copy,
        globus_l_object_write_destroy,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_WRITE   */
extern globus_object_t *
globus_object_construct_write (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * write_resource,
    long write_offset,
    long write_size)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_WRITE);

  object = globus_object_initialize_write (
    newobject,
    operation_identity,
    operation_computer,
    write_resource,
    write_offset,
    write_size);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_WRITE   */
extern globus_object_t *
globus_object_initialize_write (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * write_resource,
    long write_offset,
    long write_size)
{
  globus_object_write_set_write_resource (object, write_resource);
  globus_object_write_set_write_offset (object, write_offset);
  globus_object_write_set_write_size (object, write_size);

  return globus_object_initialize_operation (
    object,
    operation_identity,
    operation_computer);
}

/* return the write_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_WRITE   */
extern globus_object_t *
globus_object_write_get_write_resource (globus_object_t * object)
{
  globus_object_write_instance_t * instance_data;
  instance_data
   = globus_l_object_write_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->write_resource);
  }
  else return NULL;
}

/* set the write_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_WRITE   */
extern void
globus_object_write_set_write_resource (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_write_instance_t * instance_data;
  instance_data
   = globus_l_object_write_instance_data (object);
  if (instance_data != NULL) {
    instance_data->write_resource = value;
  }
}

/* return the write_offset instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_WRITE   */
extern long
globus_object_write_get_write_offset (globus_object_t * object)
{
  globus_object_write_instance_t * instance_data;
  instance_data
   = globus_l_object_write_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->write_offset);
  }
  else return -1;
}

/* set the write_offset instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_WRITE   */
extern void
globus_object_write_set_write_offset (
    globus_object_t * object,
    long value)
{
  globus_object_write_instance_t * instance_data;
  instance_data
   = globus_l_object_write_instance_data (object);
  if (instance_data != NULL) {
    instance_data->write_offset = value;
  }
}

/* return the write_size instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_WRITE   */
extern long
globus_object_write_get_write_size (globus_object_t * object)
{
  globus_object_write_instance_t * instance_data;
  instance_data
   = globus_l_object_write_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->write_size);
  }
  else return -1;
}

/* set the write_size instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_WRITE   */
extern void
globus_object_write_set_write_size (
    globus_object_t * object,
    long value)
{
  globus_object_write_instance_t * instance_data;
  instance_data
   = globus_l_object_write_instance_data (object);
  if (instance_data != NULL) {
    instance_data->write_size = value;
  }
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_APPEND_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_WRITE_DEFINITION),
        NULL,
        NULL,
        ( NULL ));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_APPEND   */
extern globus_object_t *
globus_object_construct_append (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * write_resource,
    long write_offset,
    long write_size)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_APPEND);

  object = globus_object_initialize_append (
    newobject,
    operation_identity,
    operation_computer,
    write_resource,
    write_offset,
    write_size);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_APPEND   */
extern globus_object_t *
globus_object_initialize_append (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * write_resource,
    long write_offset,
    long write_size)
{

  return globus_object_initialize_write (
    object,
    operation_identity,
    operation_computer,
    write_resource,
    write_offset,
    write_size);
}


typedef struct globus_object_execute_instance_s {
  globus_object_t *   execute_program;
} globus_object_execute_instance_t;

static globus_object_execute_instance_t *
globus_l_object_execute_instance_data (globus_object_t *object)
{
  globus_object_execute_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_EXECUTE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_execute_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_execute_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->execute_program = NULL;
    return instance_data;
  }
}

static void globus_l_object_execute_copy (void *srcvp, void **dstvpp)
{
  globus_object_execute_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_execute_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_execute_instance_t));
  dst = ((globus_object_execute_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->execute_program = globus_object_copy(src->execute_program);
}

static void globus_l_object_execute_destroy (void *datavp)
{
  globus_object_execute_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_execute_instance_t *) datavp);
  globus_object_free (data->execute_program);
  data->execute_program = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_EXECUTE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_OPERATION_DEFINITION),
        globus_l_object_execute_copy,
        globus_l_object_execute_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_EXECUTE   */
extern globus_object_t *
globus_object_construct_execute (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_EXECUTE);

  object = globus_object_initialize_execute (
    newobject,
    operation_identity,
    operation_computer,
    execute_program);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_EXECUTE   */
extern globus_object_t *
globus_object_initialize_execute (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program)
{
  globus_object_execute_set_execute_program (object, execute_program);

  return globus_object_initialize_operation (
    object,
    operation_identity,
    operation_computer);
}

/* return the execute_program instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_EXECUTE   */
extern globus_object_t *
globus_object_execute_get_execute_program (globus_object_t * object)
{
  globus_object_execute_instance_t * instance_data;
  instance_data
   = globus_l_object_execute_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->execute_program);
  }
  else return NULL;
}

/* set the execute_program instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_EXECUTE   */
extern void
globus_object_execute_set_execute_program (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_execute_instance_t * instance_data;
  instance_data
   = globus_l_object_execute_instance_data (object);
  if (instance_data != NULL) {
    instance_data->execute_program = value;
  }
}


typedef struct globus_object_fork_instance_s {
  globus_object_t *   fork_parent;
} globus_object_fork_instance_t;

static globus_object_fork_instance_t *
globus_l_object_fork_instance_data (globus_object_t *object)
{
  globus_object_fork_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_FORK);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_fork_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_fork_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->fork_parent = NULL;
    return instance_data;
  }
}

static void globus_l_object_fork_copy (void *srcvp, void **dstvpp)
{
  globus_object_fork_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_fork_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_fork_instance_t));
  dst = ((globus_object_fork_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->fork_parent = globus_object_copy(src->fork_parent);
}

static void globus_l_object_fork_destroy (void *datavp)
{
  globus_object_fork_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_fork_instance_t *) datavp);
  globus_object_free (data->fork_parent);
  data->fork_parent = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_FORK_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_EXECUTE_DEFINITION),
        globus_l_object_fork_copy,
        globus_l_object_fork_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_FORK   */
extern globus_object_t *
globus_object_construct_fork (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program,
    globus_object_t * fork_parent)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_FORK);

  object = globus_object_initialize_fork (
    newobject,
    operation_identity,
    operation_computer,
    execute_program,
    fork_parent);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_FORK   */
extern globus_object_t *
globus_object_initialize_fork (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program,
    globus_object_t * fork_parent)
{
  globus_object_fork_set_fork_parent (object, fork_parent);

  return globus_object_initialize_execute (
    object,
    operation_identity,
    operation_computer,
    execute_program);
}

/* return the fork_parent instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_FORK   */
extern globus_object_t *
globus_object_fork_get_fork_parent (globus_object_t * object)
{
  globus_object_fork_instance_t * instance_data;
  instance_data
   = globus_l_object_fork_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->fork_parent);
  }
  else return NULL;
}

/* set the fork_parent instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_FORK   */
extern void
globus_object_fork_set_fork_parent (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_fork_instance_t * instance_data;
  instance_data
   = globus_l_object_fork_instance_data (object);
  if (instance_data != NULL) {
    instance_data->fork_parent = value;
  }
}


typedef struct globus_object_sys_exec_instance_s {
  globus_list_t *   sys_exec_arguments;
} globus_object_sys_exec_instance_t;

static globus_object_sys_exec_instance_t *
globus_l_object_sys_exec_instance_data (globus_object_t *object)
{
  globus_object_sys_exec_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_SYS_EXEC);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_sys_exec_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_sys_exec_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->sys_exec_arguments = NULL;
    return instance_data;
  }
}

static void globus_l_object_sys_exec_copy (void *srcvp, void **dstvpp)
{
  globus_object_sys_exec_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_sys_exec_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_sys_exec_instance_t));
  dst = ((globus_object_sys_exec_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->sys_exec_arguments = src->sys_exec_arguments;
}

static void globus_l_object_sys_exec_destroy (void *datavp)
{
  globus_object_sys_exec_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_sys_exec_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_SYS_EXEC_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_EXECUTE_DEFINITION),
        globus_l_object_sys_exec_copy,
        globus_l_object_sys_exec_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_SYS_EXEC   */
extern globus_object_t *
globus_object_construct_sys_exec (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program,
    globus_list_t * sys_exec_arguments)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_SYS_EXEC);

  object = globus_object_initialize_sys_exec (
    newobject,
    operation_identity,
    operation_computer,
    execute_program,
    sys_exec_arguments);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_SYS_EXEC   */
extern globus_object_t *
globus_object_initialize_sys_exec (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program,
    globus_list_t * sys_exec_arguments)
{
  globus_object_sys_exec_set_sys_exec_arguments (object, sys_exec_arguments);

  return globus_object_initialize_execute (
    object,
    operation_identity,
    operation_computer,
    execute_program);
}

/* return the sys_exec_arguments instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_SYS_EXEC   */
extern globus_list_t *
globus_object_sys_exec_get_sys_exec_arguments (globus_object_t * object)
{
  globus_object_sys_exec_instance_t * instance_data;
  instance_data
   = globus_l_object_sys_exec_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->sys_exec_arguments);
  }
  else return NULL;
}

/* set the sys_exec_arguments instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_SYS_EXEC   */
extern void
globus_object_sys_exec_set_sys_exec_arguments (
    globus_object_t * object,
    globus_list_t * value)
{
  globus_object_sys_exec_instance_t * instance_data;
  instance_data
   = globus_l_object_sys_exec_instance_data (object);
  if (instance_data != NULL) {
    instance_data->sys_exec_arguments = value;
  }
}


typedef struct globus_object_sys_execle_instance_s {
  globus_list_t *   sys_execle_environment;
} globus_object_sys_execle_instance_t;

static globus_object_sys_execle_instance_t *
globus_l_object_sys_execle_instance_data (globus_object_t *object)
{
  globus_object_sys_execle_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_SYS_EXECLE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_sys_execle_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_sys_execle_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->sys_execle_environment = NULL;
    return instance_data;
  }
}

static void globus_l_object_sys_execle_copy (void *srcvp, void **dstvpp)
{
  globus_object_sys_execle_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_sys_execle_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_sys_execle_instance_t));
  dst = ((globus_object_sys_execle_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->sys_execle_environment = src->sys_execle_environment;
}

static void globus_l_object_sys_execle_destroy (void *datavp)
{
  globus_object_sys_execle_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_sys_execle_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_SYS_EXECLE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_SYS_EXEC_DEFINITION),
        globus_l_object_sys_execle_copy,
        globus_l_object_sys_execle_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_SYS_EXECLE   */
extern globus_object_t *
globus_object_construct_sys_execle (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program,
    globus_list_t * sys_exec_arguments,
    globus_list_t * sys_execle_environment)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_SYS_EXECLE);

  object = globus_object_initialize_sys_execle (
    newobject,
    operation_identity,
    operation_computer,
    execute_program,
    sys_exec_arguments,
    sys_execle_environment);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_SYS_EXECLE   */
extern globus_object_t *
globus_object_initialize_sys_execle (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program,
    globus_list_t * sys_exec_arguments,
    globus_list_t * sys_execle_environment)
{
  globus_object_sys_execle_set_sys_execle_environment (object, sys_execle_environment);

  return globus_object_initialize_sys_exec (
    object,
    operation_identity,
    operation_computer,
    execute_program,
    sys_exec_arguments);
}

/* return the sys_execle_environment instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_SYS_EXECLE   */
extern globus_list_t *
globus_object_sys_execle_get_sys_execle_environment (globus_object_t * object)
{
  globus_object_sys_execle_instance_t * instance_data;
  instance_data
   = globus_l_object_sys_execle_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->sys_execle_environment);
  }
  else return NULL;
}

/* set the sys_execle_environment instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_SYS_EXECLE   */
extern void
globus_object_sys_execle_set_sys_execle_environment (
    globus_object_t * object,
    globus_list_t * value)
{
  globus_object_sys_execle_instance_t * instance_data;
  instance_data
   = globus_l_object_sys_execle_instance_data (object);
  if (instance_data != NULL) {
    instance_data->sys_execle_environment = value;
  }
}


typedef struct globus_object_gram_request_instance_s {
  globus_object_t *   gram_request_resource;
} globus_object_gram_request_instance_t;

static globus_object_gram_request_instance_t *
globus_l_object_gram_request_instance_data (globus_object_t *object)
{
  globus_object_gram_request_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_GRAM_REQUEST);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_gram_request_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_gram_request_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->gram_request_resource = NULL;
    return instance_data;
  }
}

static void globus_l_object_gram_request_copy (void *srcvp, void **dstvpp)
{
  globus_object_gram_request_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_gram_request_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_gram_request_instance_t));
  dst = ((globus_object_gram_request_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->gram_request_resource = globus_object_copy(src->gram_request_resource);
}

static void globus_l_object_gram_request_destroy (void *datavp)
{
  globus_object_gram_request_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_gram_request_instance_t *) datavp);
  globus_object_free (data->gram_request_resource);
  data->gram_request_resource = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_GRAM_REQUEST_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_EXECUTE_DEFINITION),
        globus_l_object_gram_request_copy,
        globus_l_object_gram_request_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_GRAM_REQUEST   */
extern globus_object_t *
globus_object_construct_gram_request (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program,
    globus_object_t * gram_request_resource)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_GRAM_REQUEST);

  object = globus_object_initialize_gram_request (
    newobject,
    operation_identity,
    operation_computer,
    execute_program,
    gram_request_resource);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_GRAM_REQUEST   */
extern globus_object_t *
globus_object_initialize_gram_request (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * execute_program,
    globus_object_t * gram_request_resource)
{
  globus_object_gram_request_set_gram_request_resource (object, gram_request_resource);

  return globus_object_initialize_execute (
    object,
    operation_identity,
    operation_computer,
    execute_program);
}

/* return the gram_request_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRAM_REQUEST   */
extern globus_object_t *
globus_object_gram_request_get_gram_request_resource (globus_object_t * object)
{
  globus_object_gram_request_instance_t * instance_data;
  instance_data
   = globus_l_object_gram_request_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->gram_request_resource);
  }
  else return NULL;
}

/* set the gram_request_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRAM_REQUEST   */
extern void
globus_object_gram_request_set_gram_request_resource (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_gram_request_instance_t * instance_data;
  instance_data
   = globus_l_object_gram_request_instance_data (object);
  if (instance_data != NULL) {
    instance_data->gram_request_resource = value;
  }
}


typedef struct globus_object_open_create_instance_s {
  globus_object_t *   open_create_resource;
} globus_object_open_create_instance_t;

static globus_object_open_create_instance_t *
globus_l_object_open_create_instance_data (globus_object_t *object)
{
  globus_object_open_create_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_OPEN_CREATE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_open_create_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_open_create_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->open_create_resource = NULL;
    return instance_data;
  }
}

static void globus_l_object_open_create_copy (void *srcvp, void **dstvpp)
{
  globus_object_open_create_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_open_create_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_open_create_instance_t));
  dst = ((globus_object_open_create_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->open_create_resource = globus_object_copy(src->open_create_resource);
}

static void globus_l_object_open_create_destroy (void *datavp)
{
  globus_object_open_create_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_open_create_instance_t *) datavp);
  globus_object_free (data->open_create_resource);
  data->open_create_resource = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_OPEN_CREATE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_OPERATION_DEFINITION),
        globus_l_object_open_create_copy,
        globus_l_object_open_create_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_OPEN_CREATE   */
extern globus_object_t *
globus_object_construct_open_create (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * open_create_resource)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_OPEN_CREATE);

  object = globus_object_initialize_open_create (
    newobject,
    operation_identity,
    operation_computer,
    open_create_resource);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_OPEN_CREATE   */
extern globus_object_t *
globus_object_initialize_open_create (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * open_create_resource)
{
  globus_object_open_create_set_open_create_resource (object, open_create_resource);

  return globus_object_initialize_operation (
    object,
    operation_identity,
    operation_computer);
}

/* return the open_create_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_OPEN_CREATE   */
extern globus_object_t *
globus_object_open_create_get_open_create_resource (globus_object_t * object)
{
  globus_object_open_create_instance_t * instance_data;
  instance_data
   = globus_l_object_open_create_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->open_create_resource);
  }
  else return NULL;
}

/* set the open_create_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_OPEN_CREATE   */
extern void
globus_object_open_create_set_open_create_resource (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_open_create_instance_t * instance_data;
  instance_data
   = globus_l_object_open_create_instance_data (object);
  if (instance_data != NULL) {
    instance_data->open_create_resource = value;
  }
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_OPEN_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_OPEN_CREATE_DEFINITION),
        NULL,
        NULL,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_OPEN   */
extern globus_object_t *
globus_object_construct_open (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * open_create_resource)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_OPEN);

  object = globus_object_initialize_open (
    newobject,
    operation_identity,
    operation_computer,
    open_create_resource);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_OPEN   */
extern globus_object_t *
globus_object_initialize_open (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * open_create_resource)
{

  return globus_object_initialize_open_create (
    object,
    operation_identity,
    operation_computer,
    open_create_resource);
}


typedef struct globus_object_create_instance_s {
  globus_list_t *   create_mode;
} globus_object_create_instance_t;

static globus_object_create_instance_t *
globus_l_object_create_instance_data (globus_object_t *object)
{
  globus_object_create_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_CREATE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_create_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_create_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->create_mode = NULL;
    return instance_data;
  }
}

static void globus_l_object_create_copy (void *srcvp, void **dstvpp)
{
  globus_object_create_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_create_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_create_instance_t));
  dst = ((globus_object_create_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->create_mode = src->create_mode;
}

static void globus_l_object_create_destroy (void *datavp)
{
  globus_object_create_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_create_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_CREATE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_OPEN_CREATE_DEFINITION),
        globus_l_object_create_copy,
        globus_l_object_create_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_CREATE   */
extern globus_object_t *
globus_object_construct_create (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * open_create_resource,
    globus_list_t * create_mode)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_CREATE);

  object = globus_object_initialize_create (
    newobject,
    operation_identity,
    operation_computer,
    open_create_resource,
    create_mode);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_CREATE   */
extern globus_object_t *
globus_object_initialize_create (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * open_create_resource,
    globus_list_t * create_mode)
{
  globus_object_create_set_create_mode (object, create_mode);

  return globus_object_initialize_open_create (
    object,
    operation_identity,
    operation_computer,
    open_create_resource);
}

/* return the create_mode instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_CREATE   */
extern globus_list_t *
globus_object_create_get_create_mode (globus_object_t * object)
{
  globus_object_create_instance_t * instance_data;
  instance_data
   = globus_l_object_create_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->create_mode);
  }
  else return NULL;
}

/* set the create_mode instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_CREATE   */
extern void
globus_object_create_set_create_mode (
    globus_object_t * object,
    globus_list_t * value)
{
  globus_object_create_instance_t * instance_data;
  instance_data
   = globus_l_object_create_instance_data (object);
  if (instance_data != NULL) {
    instance_data->create_mode = value;
  }
}


typedef struct globus_object_close_instance_s {
  globus_object_t *   close_resource;
} globus_object_close_instance_t;

static globus_object_close_instance_t *
globus_l_object_close_instance_data (globus_object_t *object)
{
  globus_object_close_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_CLOSE);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_close_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_close_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->close_resource = NULL;
    return instance_data;
  }
}

static void globus_l_object_close_copy (void *srcvp, void **dstvpp)
{
  globus_object_close_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_close_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_close_instance_t));
  dst = ((globus_object_close_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->close_resource = globus_object_copy(src->close_resource);
}

static void globus_l_object_close_destroy (void *datavp)
{
  globus_object_close_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_close_instance_t *) datavp);
  globus_object_free (data->close_resource);
  data->close_resource = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_CLOSE_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_OPERATION_DEFINITION),
        globus_l_object_close_copy,
        globus_l_object_close_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_CLOSE   */
extern globus_object_t *
globus_object_construct_close (
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * close_resource)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_CLOSE);

  object = globus_object_initialize_close (
    newobject,
    operation_identity,
    operation_computer,
    close_resource);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_CLOSE   */
extern globus_object_t *
globus_object_initialize_close (
    globus_object_t * object,
    globus_object_t * operation_identity,
    globus_object_t * operation_computer,
    globus_object_t * close_resource)
{
  globus_object_close_set_close_resource (object, close_resource);

  return globus_object_initialize_operation (
    object,
    operation_identity,
    operation_computer);
}

/* return the close_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_CLOSE   */
extern globus_object_t *
globus_object_close_get_close_resource (globus_object_t * object)
{
  globus_object_close_instance_t * instance_data;
  instance_data
   = globus_l_object_close_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->close_resource);
  }
  else return NULL;
}

/* set the close_resource instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_CLOSE   */
extern void
globus_object_close_set_close_resource (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_close_instance_t * instance_data;
  instance_data
   = globus_l_object_close_instance_data (object);
  if (instance_data != NULL) {
    instance_data->close_resource = value;
  }
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_USERDATA_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_PRINTABLE_DEFINITION),
        NULL,
        NULL,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_USERDATA   */
extern globus_object_t *
globus_object_construct_userdata (
)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_USERDATA);

  object = globus_object_initialize_userdata (
    newobject
);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_USERDATA   */
extern globus_object_t *
globus_object_initialize_userdata (
    globus_object_t * object
)
{

  return globus_object_initialize_printable (
    object
);
}


typedef struct globus_object_rsl_instance_s {
  char *   rsl_string;
  void *   rsl_globus_rsl;
} globus_object_rsl_instance_t;

static globus_object_rsl_instance_t *
globus_l_object_rsl_instance_data (globus_object_t *object)
{
  globus_object_rsl_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_RSL);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_rsl_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_rsl_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->rsl_string = NULL;
    instance_data->rsl_globus_rsl = NULL;
    return instance_data;
  }
}

static void globus_l_object_rsl_copy (void *srcvp, void **dstvpp)
{
  globus_object_rsl_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_rsl_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_rsl_instance_t));
  dst = ((globus_object_rsl_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->rsl_string = src->rsl_string;
  dst->rsl_globus_rsl = src->rsl_globus_rsl;
}

static void globus_l_object_rsl_destroy (void *datavp)
{
  globus_object_rsl_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_rsl_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_RSL_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_USERDATA_DEFINITION),
        globus_l_object_rsl_copy,
        globus_l_object_rsl_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_RSL   */
extern globus_object_t *
globus_object_construct_rsl (
    char * rsl_string,
    void * rsl_globus_rsl)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_RSL);

  object = globus_object_initialize_rsl (
    newobject,
    rsl_string,
    rsl_globus_rsl);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_RSL   */
extern globus_object_t *
globus_object_initialize_rsl (
    globus_object_t * object,
    char * rsl_string,
    void * rsl_globus_rsl)
{
  globus_object_rsl_set_rsl_string (object, rsl_string);
  globus_object_rsl_set_rsl_globus_rsl (object, rsl_globus_rsl);

  return globus_object_initialize_userdata (
    object
);
}

/* return the rsl_string instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_RSL   */
extern char *
globus_object_rsl_get_rsl_string (globus_object_t * object)
{
  globus_object_rsl_instance_t * instance_data;
  instance_data
   = globus_l_object_rsl_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->rsl_string);
  }
  else return NULL;
}

/* set the rsl_string instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_RSL   */
extern void
globus_object_rsl_set_rsl_string (
    globus_object_t * object,
    char * value)
{
  globus_object_rsl_instance_t * instance_data;
  instance_data
   = globus_l_object_rsl_instance_data (object);
  if (instance_data != NULL) {
    instance_data->rsl_string = value;
  }
}

/* return the rsl_globus_rsl instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_RSL   */
extern void *
globus_object_rsl_get_rsl_globus_rsl (globus_object_t * object)
{
  globus_object_rsl_instance_t * instance_data;
  instance_data
   = globus_l_object_rsl_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->rsl_globus_rsl);
  }
  else return NULL;
}

/* set the rsl_globus_rsl instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_RSL   */
extern void
globus_object_rsl_set_rsl_globus_rsl (
    globus_object_t * object,
    void * value)
{
  globus_object_rsl_instance_t * instance_data;
  instance_data
   = globus_l_object_rsl_instance_data (object);
  if (instance_data != NULL) {
    instance_data->rsl_globus_rsl = value;
  }
}


const globus_object_type_t GLOBUS_OBJECT_TYPE_IDENTITY_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_PRINTABLE_DEFINITION),
        NULL,
        NULL,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_IDENTITY   */
extern globus_object_t *
globus_object_construct_identity (
)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_IDENTITY);

  object = globus_object_initialize_identity (
    newobject
);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_IDENTITY   */
extern globus_object_t *
globus_object_initialize_identity (
    globus_object_t * object
)
{

  return globus_object_initialize_printable (
    object
);
}


typedef struct globus_object_local_identity_instance_s {
  globus_object_t *   local_identity_computer;
  char *   local_identity_username;
} globus_object_local_identity_instance_t;

static globus_object_local_identity_instance_t *
globus_l_object_local_identity_instance_data (globus_object_t *object)
{
  globus_object_local_identity_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_local_identity_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_local_identity_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->local_identity_computer = NULL;
    instance_data->local_identity_username = NULL;
    return instance_data;
  }
}

static void globus_l_object_local_identity_copy (void *srcvp, void **dstvpp)
{
  globus_object_local_identity_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_local_identity_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_local_identity_instance_t));
  dst = ((globus_object_local_identity_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->local_identity_computer = globus_object_copy(src->local_identity_computer);
  dst->local_identity_username = src->local_identity_username;
}

static void globus_l_object_local_identity_destroy (void *datavp)
{
  globus_object_local_identity_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_local_identity_instance_t *) datavp);
  globus_object_free (data->local_identity_computer);
  data->local_identity_computer = NULL;
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_IDENTITY_DEFINITION),
        globus_l_object_local_identity_copy,
        globus_l_object_local_identity_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY   */
extern globus_object_t *
globus_object_construct_local_identity (
    globus_object_t * local_identity_computer,
    char * local_identity_username)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY);

  object = globus_object_initialize_local_identity (
    newobject,
    local_identity_computer,
    local_identity_username);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY   */
extern globus_object_t *
globus_object_initialize_local_identity (
    globus_object_t * object,
    globus_object_t * local_identity_computer,
    char * local_identity_username)
{
  globus_object_local_identity_set_local_identity_computer (object, local_identity_computer);
  globus_object_local_identity_set_local_identity_username (object, local_identity_username);

  return globus_object_initialize_identity (
    object
);
}

/* return the local_identity_computer instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY   */
extern globus_object_t *
globus_object_local_identity_get_local_identity_computer (globus_object_t * object)
{
  globus_object_local_identity_instance_t * instance_data;
  instance_data
   = globus_l_object_local_identity_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->local_identity_computer);
  }
  else return NULL;
}

/* set the local_identity_computer instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY   */
extern void
globus_object_local_identity_set_local_identity_computer (
    globus_object_t * object,
    globus_object_t * value)
{
  globus_object_local_identity_instance_t * instance_data;
  instance_data
   = globus_l_object_local_identity_instance_data (object);
  if (instance_data != NULL) {
    instance_data->local_identity_computer = value;
  }
}

/* return the local_identity_username instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY   */
extern char *
globus_object_local_identity_get_local_identity_username (globus_object_t * object)
{
  globus_object_local_identity_instance_t * instance_data;
  instance_data
   = globus_l_object_local_identity_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->local_identity_username);
  }
  else return NULL;
}

/* set the local_identity_username instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_LOCAL_IDENTITY   */
extern void
globus_object_local_identity_set_local_identity_username (
    globus_object_t * object,
    char * value)
{
  globus_object_local_identity_instance_t * instance_data;
  instance_data
   = globus_l_object_local_identity_instance_data (object);
  if (instance_data != NULL) {
    instance_data->local_identity_username = value;
  }
}


typedef struct globus_object_grid_identity_instance_s {
  char *   grid_identity_subject;
} globus_object_grid_identity_instance_t;

static globus_object_grid_identity_instance_t *
globus_l_object_grid_identity_instance_data (globus_object_t *object)
{
  globus_object_grid_identity_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_GRID_IDENTITY);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_grid_identity_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_grid_identity_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->grid_identity_subject = NULL;
    return instance_data;
  }
}

static void globus_l_object_grid_identity_copy (void *srcvp, void **dstvpp)
{
  globus_object_grid_identity_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_grid_identity_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_grid_identity_instance_t));
  dst = ((globus_object_grid_identity_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->grid_identity_subject = src->grid_identity_subject;
}

static void globus_l_object_grid_identity_destroy (void *datavp)
{
  globus_object_grid_identity_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_grid_identity_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_GRID_IDENTITY_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_IDENTITY_DEFINITION),
        globus_l_object_grid_identity_copy,
        globus_l_object_grid_identity_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_GRID_IDENTITY   */
extern globus_object_t *
globus_object_construct_grid_identity (
    char * grid_identity_subject)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_GRID_IDENTITY);

  object = globus_object_initialize_grid_identity (
    newobject,
    grid_identity_subject);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_GRID_IDENTITY   */
extern globus_object_t *
globus_object_initialize_grid_identity (
    globus_object_t * object,
    char * grid_identity_subject)
{
  globus_object_grid_identity_set_grid_identity_subject (object, grid_identity_subject);

  return globus_object_initialize_identity (
    object
);
}

/* return the grid_identity_subject instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRID_IDENTITY   */
extern char *
globus_object_grid_identity_get_grid_identity_subject (globus_object_t * object)
{
  globus_object_grid_identity_instance_t * instance_data;
  instance_data
   = globus_l_object_grid_identity_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->grid_identity_subject);
  }
  else return NULL;
}

/* set the grid_identity_subject instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_GRID_IDENTITY   */
extern void
globus_object_grid_identity_set_grid_identity_subject (
    globus_object_t * object,
    char * value)
{
  globus_object_grid_identity_instance_t * instance_data;
  instance_data
   = globus_l_object_grid_identity_instance_data (object);
  if (instance_data != NULL) {
    instance_data->grid_identity_subject = value;
  }
}


typedef struct globus_object_kerberos_identity_instance_s {
  char *   kerberos_identity_principal;
} globus_object_kerberos_identity_instance_t;

static globus_object_kerberos_identity_instance_t *
globus_l_object_kerberos_identity_instance_data (globus_object_t *object)
{
  globus_object_kerberos_identity_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_KERBEROS_IDENTITY);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_kerberos_identity_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_kerberos_identity_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->kerberos_identity_principal = NULL;
    return instance_data;
  }
}

static void globus_l_object_kerberos_identity_copy (void *srcvp, void **dstvpp)
{
  globus_object_kerberos_identity_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_kerberos_identity_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_kerberos_identity_instance_t));
  dst = ((globus_object_kerberos_identity_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->kerberos_identity_principal = src->kerberos_identity_principal;
}

static void globus_l_object_kerberos_identity_destroy (void *datavp)
{
  globus_object_kerberos_identity_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_kerberos_identity_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_KERBEROS_IDENTITY_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_IDENTITY_DEFINITION),
        globus_l_object_kerberos_identity_copy,
        globus_l_object_kerberos_identity_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_KERBEROS_IDENTITY   */
extern globus_object_t *
globus_object_construct_kerberos_identity (
    char * kerberos_identity_principal)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_KERBEROS_IDENTITY);

  object = globus_object_initialize_kerberos_identity (
    newobject,
    kerberos_identity_principal);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_KERBEROS_IDENTITY   */
extern globus_object_t *
globus_object_initialize_kerberos_identity (
    globus_object_t * object,
    char * kerberos_identity_principal)
{
  globus_object_kerberos_identity_set_kerberos_identity_principal (object, kerberos_identity_principal);

  return globus_object_initialize_identity (
    object
);
}

/* return the kerberos_identity_principal instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_KERBEROS_IDENTITY   */
extern char *
globus_object_kerberos_identity_get_kerberos_identity_principal (globus_object_t * object)
{
  globus_object_kerberos_identity_instance_t * instance_data;
  instance_data
   = globus_l_object_kerberos_identity_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->kerberos_identity_principal);
  }
  else return NULL;
}

/* set the kerberos_identity_principal instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_KERBEROS_IDENTITY   */
extern void
globus_object_kerberos_identity_set_kerberos_identity_principal (
    globus_object_t * object,
    char * value)
{
  globus_object_kerberos_identity_instance_t * instance_data;
  instance_data
   = globus_l_object_kerberos_identity_instance_data (object);
  if (instance_data != NULL) {
    instance_data->kerberos_identity_principal = value;
  }
}


typedef struct globus_object_time_instance_s {
  time_t *   time_time;
} globus_object_time_instance_t;

static globus_object_time_instance_t *
globus_l_object_time_instance_data (globus_object_t *object)
{
  globus_object_time_instance_t * instance_data;
  globus_object_t * local_object;

  local_object 
  = globus_object_upcast (object, GLOBUS_OBJECT_TYPE_TIME);

  if (local_object==NULL) return NULL;

  instance_data 
  = ((globus_object_time_instance_t *)
     globus_object_get_local_instance_data (local_object));

  if (instance_data!=NULL) return instance_data;
  else {
    instance_data 
    = globus_malloc (sizeof(globus_object_time_instance_t));
    globus_object_set_local_instance_data (local_object,
                                           instance_data);

    instance_data->time_time = NULL;
    return instance_data;
  }
}

static void globus_l_object_time_copy (void *srcvp, void **dstvpp)
{
  globus_object_time_instance_t *src, *dst;
  if (srcvp==NULL || dstvpp==NULL) return;
  src = ((globus_object_time_instance_t *) srcvp);
  (*dstvpp) = globus_malloc (sizeof(globus_object_time_instance_t));
  dst = ((globus_object_time_instance_t *) (*dstvpp));
  if (dst==NULL) return;
  dst->time_time = src->time_time;
}

static void globus_l_object_time_destroy (void *datavp)
{
  globus_object_time_instance_t *data;
  if (datavp==NULL) return;
  data = ((globus_object_time_instance_t *) datavp);
  globus_free (data);
}

const globus_object_type_t GLOBUS_OBJECT_TYPE_TIME_DEFINITION
= globus_object_type_static_initializer (
        (&GLOBUS_OBJECT_TYPE_PRINTABLE_DEFINITION),
        globus_l_object_time_copy,
        globus_l_object_time_destroy,
        ( NULL));

/* allocate and initialize an object of type
 * GLOBUS_OBJECT_TYPE_TIME   */
extern globus_object_t *
globus_object_construct_time (
    time_t * time_time)
{
  globus_object_t * newobject, * object;
  newobject = globus_object_construct (GLOBUS_OBJECT_TYPE_TIME);

  object = globus_object_initialize_time (
    newobject,
    time_time);

  if (object==NULL) globus_object_free (newobject);

  return object;
}

/* initialize and return an object of type
 * GLOBUS_OBJECT_TYPE_TIME   */
extern globus_object_t *
globus_object_initialize_time (
    globus_object_t * object,
    time_t * time_time)
{
  globus_object_time_set_time_time (object, time_time);

  return globus_object_initialize_printable (
    object
);
}

/* return the time_time instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_TIME   */
extern time_t *
globus_object_time_get_time_time (globus_object_t * object)
{
  globus_object_time_instance_t * instance_data;
  instance_data
   = globus_l_object_time_instance_data (object);
  if (instance_data != NULL) {
    return (instance_data->time_time);
  }
  else return NULL;
}

/* set the time_time instance data of an object
 * derived from GLOBUS_OBJECT_TYPE_TIME   */
extern void
globus_object_time_set_time_time (
    globus_object_t * object,
    time_t * value)
{
  globus_object_time_instance_t * instance_data;
  instance_data
   = globus_l_object_time_instance_data (object);
  if (instance_data != NULL) {
    instance_data->time_time = value;
  }
}




