
"Fog."

import OpenGL.GL as gl

import glitch

class Fog(glitch.Node):
    "Set OpenGL fog parameters."

    def __init__(self,
            r=0.2, g=0.2, b=0.2, a=0, density=0.3, start=0, end=1, **kw):
        glitch.Node.__init__(self, **kw)
        (self.r, self.g, self.b, self.a) = (r, g, b, a)
        self.density = density
        (self.start, self.end) = start, end

    def render(self, ctx):
        gl.glPushAttrib(gl.GL_ENABLE_BIT)
        gl.glEnable(gl.GL_FOG)
        gl.glFogi(gl.GL_FOG_MODE, gl.GL_EXP2)
        gl.glFogfv(gl.GL_FOG_COLOR, [self.r, self.g, self.b, self.a])
        gl.glFogf(gl.GL_FOG_DENSITY, self.density)
        gl.glFogf(gl.GL_FOG_START, self.start)
        gl.glFogf(gl.GL_FOG_END, self.end)
        gl.glHint(gl.GL_FOG_HINT, gl.GL_NICEST)
        glitch.Node.render(self, ctx)
        gl.glPopAttrib()

