//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: FunctionExpressionNot.hpp,v 1.1 2006/07/20 17:29:18 delpinux Exp $

#ifndef FUNCTION_EXPRESSION_NOT_HPP
#define FUNCTION_EXPRESSION_NOT_HPP

#include <FunctionExpression.hpp>

/**
 * @file   FunctionExpressionNot.hpp
 * @author Stephane Del Pino
 * @date   Wed Jul 19 00:46:03 2006
 * 
 * @brief  Describes the boolean unary operator @b not
 * 
 */
class FunctionExpressionNot
  : public FunctionExpression
{
private:
  ReferenceCounting<FunctionExpression> __givenFunction; /**< the operand function */

public:
  /** 
   * Executes the expression
   * 
   */
  void execute();

  /** 
   * Checks if the expression requires a boundary for evaluation
   * 
   * @return @b true if __givenFunction requires a boundary
   */
  bool hasBoundaryExpression() const;

  /** 
   * Constructor
   * 
   * @param f the operand function
   * 
   */
  FunctionExpressionNot(ReferenceCounting<FunctionExpression> f);

  /** 
   * Copy constructor
   * 
   * @param f the original function expression
   */
  FunctionExpressionNot(const FunctionExpressionNot& f);

  /** 
   * Destructor
   * 
   */
  ~FunctionExpressionNot();
};

#endif // FUNCTION_EXPRESSION_NOT_HPP
