/* $Id: localio.h,v 1.4 2003/05/22 09:42:33 sjoerd Exp $ */
#ifndef FFRENZY_LOCALIO_H
#define FFRENZY_LOCALIO_H

#include <stdio.h>
#include <SDL.h>

#include "global.h"
#include "list.h"

/** \defgroup localio localio
 * Local Input Output layer
 */

typedef struct {
  uint32_t player;
  SDLKey key;
  uint32_t action;
} Key_Action;

typedef struct {
  uint32_t numplayers;
  uint32_t *events;
  List *key_actions;
} Local_io;

/** \ingroup localio
 * Local io constructor. 
 * Creates a i/o handler for \a players players
 */
Local_io *new_local_io(uint32_t players);
/** \ingroup localio
 * Local io destructor
 */
void del_local_io(Local_io *io);

/** \ingroup localio
 * Bind a \a key to \a action of player number \a player
 */
void local_io_register_key(Local_io *io, SDLKey key,
                          uint32_t player, uint32_t action);
/** \ingroup localio
 * Update the state of all players
 */
void local_io_update(Local_io *io);

/** \ingroup localio
 * Get the current event mask of a player 
 */
uint32_t local_io_get_events(Local_io *io, uint32_t player);

#endif /* FFRENZY_LOCALIO_H */
