/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class MNGReader
extends FormatReader {
    private Vector offsets;
    private Vector lengths;

    public MNGReader() {
        super("Multiple Network Graphics", "mng");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 8) {
            return false;
        }
        return block[0] == 138 && block[1] == 77 && block[2] == 78 && block[3] == 71 && block[4] == 13 && block[5] == 10 && block[6] == 26 && block[7] == 10;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        buf = ImageTools.getBytes(this.openImage(no), true, this.core.sizeC[0]);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        long offset = (Long)this.offsets.get(no);
        this.in.seek(offset);
        long end = (Long)this.lengths.get(no);
        byte[] b = new byte[(int)(end - offset + 8L)];
        this.in.read(b, 8, b.length - 8);
        b[0] = -119;
        b[1] = 80;
        b[2] = 78;
        b[3] = 71;
        b[4] = 13;
        b[5] = 10;
        b[6] = 26;
        b[7] = 10;
        return ImageIO.read(new ByteArrayInputStream(b));
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("MNGReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(false);
        this.status("Verifying MNG format");
        this.offsets = new Vector();
        this.lengths = new Vector();
        this.in.skipBytes(8);
        this.in.skipBytes(4);
        byte[] b = new byte[4];
        this.in.read(b);
        if (!"MHDR".equals(new String(b))) {
            throw new FormatException("Invalid MNG file.");
        }
        this.status("Reading dimensions");
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        this.in.skipBytes(24);
        Vector<Long> stack = new Vector<Long>();
        int maxIterations = 0;
        int currentIteration = 0;
        this.status("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            int len = this.in.readInt();
            this.in.read(b);
            String code = new String(b);
            long fp = this.in.getFilePointer();
            if (code.equals("IHDR")) {
                this.offsets.add(new Long(this.in.getFilePointer() - 8L));
                this.core.imageCount[0] = this.core.imageCount[0] + 1;
            } else if (code.equals("IEND")) {
                this.lengths.add(new Long(fp + (long)len + 4L));
            } else if (code.equals("LOOP")) {
                stack.add(new Long(this.in.getFilePointer() + (long)len + 4L));
                this.in.skipBytes(1);
                maxIterations = this.in.readInt();
            } else if (code.equals("ENDL")) {
                int seek = (Integer)stack.get(stack.size() - 1);
                if (currentIteration < maxIterations) {
                    this.in.seek(seek);
                    ++currentIteration;
                } else {
                    stack.remove(stack.size() - 1);
                    maxIterations = 0;
                    currentIteration = 0;
                }
            }
            this.in.seek(fp + (long)len + 4L);
        }
        this.status("Populating metadata");
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = this.openImage(0).getRaster().getNumBands();
        this.core.sizeT[0] = this.core.imageCount[0];
        this.core.currentOrder[0] = "XYCZT";
        this.core.pixelType[0] = 1;
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = false;
        this.core.metadataComplete[0] = true;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

