/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.plugins.helpers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;

class JarClassLoader
extends URLClassLoader {
    Map<String, JarClassLoader> children = new HashMap<String, JarClassLoader>();
    Set<String> loadedExtensions = new HashSet<String>();
    Map<String, String> classCache = new HashMap<String, String>();

    public JarClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
    }

    public JarClassLoader() {
        this(JarClassLoader.class.getClassLoader());
    }

    public JarClassLoader addExtension(String string) throws MalformedURLException {
        JarClassLoader jarClassLoader = new JarClassLoader(JarClassLoader.class.getClassLoader());
        jarClassLoader.addJar(string);
        this.children.put(string, jarClassLoader);
        this.loadedExtensions.add(string);
        return jarClassLoader;
    }

    public JarClassLoader removeExtension(String string) {
        this.loadedExtensions.remove(string);
        return this.children.remove(string);
    }

    private void addJar(String string) throws MalformedURLException {
        URL uRL = new URL("jar", "", "file:" + string + "!/");
        this.addURL(uRL);
    }

    public Class loadExtensionClass(String string) {
        Object object;
        if (this.classCache.containsKey(string) && (object = this.children.get(this.classCache.get(string))) != null) {
            try {
                return ((ClassLoader)object).loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.classCache.remove(string);
            }
        }
        try {
            object = this.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = null;
        }
        if (object != null) {
            return object;
        }
        for (Map.Entry<String, JarClassLoader> entry : this.children.entrySet()) {
            object = entry.getValue().loadExtensionClass(string);
            if (object == null) continue;
            this.classCache.put(string, entry.getKey());
            return object;
        }
        return null;
    }

    public void loadAllExtensions(String string) throws Exception {
        File[] fileArray;
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".jar");
            }
        })) {
            this.addExtension(file2.getAbsolutePath());
        }
    }

    public Map<String, String> getPackageVersions() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator<String> iterator = this.loadedExtensions.iterator();
        while (iterator.hasNext()) {
            JarClassLoader.getPackageVersion(new File(iterator.next()), hashMap);
        }
        return hashMap;
    }

    private static void getPackageVersion(File file, Map<String, String> map) throws IOException {
        if (!file.exists()) {
            return;
        }
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        map.put(file.getName(), attributes.getValue("Implementation-Version"));
    }

    public String loadPackagedFile(Class clazz, String string) {
        try {
            InputStream inputStream = clazz.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            return IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Class[] findAnnotatedClasses(String string, Class clazz) throws IOException, ClassNotFoundException {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.addAll(this.findAnnotatedClassesLocal(string, clazz));
        for (JarClassLoader jarClassLoader : this.children.values()) {
            hashSet.addAll(jarClassLoader.findAnnotatedClassesLocal(string, clazz));
        }
        return hashSet.toArray(new Class[hashSet.size()]);
    }

    public Set<Class> findAnnotatedClassesLocal(String string, Class clazz) throws IOException, ClassNotFoundException {
        Object object;
        String string2 = string.replace('.', '/');
        Enumeration<URL> enumeration = this.getResources(string2);
        HashSet<File> hashSet = new HashSet<File>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            hashSet.add(new File(((URL)object).getFile()));
        }
        for (URL uRL : this.getURLs()) {
            hashSet.add(new File(uRL.getFile()));
        }
        object = new HashSet();
        for (File file : hashSet) {
            ((AbstractCollection)object).addAll(this.findClasses(file, string, clazz));
        }
        return object;
    }

    private Set<Class> findClasses(File file, String string, Class clazz) throws ClassNotFoundException, IOException {
        HashSet<Class> hashSet = new HashSet<Class>();
        if (!file.exists()) {
            String string2 = file.toString();
            String string3 = string2.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
            JarFile jarFile = new JarFile(string3);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string4 = jarEntry.getName();
                if (!string4.endsWith(".class") || string4.contains("$")) continue;
                String string5 = string4.replace('/', '.').replace('\\', '.').replace(".class", "");
                Class<?> clazz2 = this.loadClass(string5);
                if (clazz != null && !clazz2.isAnnotationPresent(clazz)) continue;
                hashSet.add(clazz2);
            }
        } else {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    assert (!file2.getName().contains("."));
                    hashSet.addAll(this.findClasses(file2, string + "." + file2.getName(), clazz));
                    continue;
                }
                if (!file2.getName().endsWith(".class")) continue;
                Class<?> clazz3 = this.loadClass(string + '.' + file2.getName().substring(0, file2.getName().length() - 6));
                if (clazz != null && !clazz3.isAnnotationPresent(clazz)) continue;
                hashSet.add(clazz3);
            }
        }
        return hashSet;
    }
}

