/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlrpc.common.XmlRpcController;
import org.apache.xmlrpc.common.XmlRpcLoadException;
import org.apache.xmlrpc.common.XmlRpcWorker;

public abstract class XmlRpcWorkerFactory {
    private final XmlRpcWorker singleton = this.newWorker();
    private final XmlRpcController controller;
    private final List pool = new ArrayList();
    private int numThreads;

    public XmlRpcWorkerFactory(XmlRpcController pController) {
        this.controller = pController;
    }

    protected abstract XmlRpcWorker newWorker();

    public XmlRpcController getController() {
        return this.controller;
    }

    public synchronized XmlRpcWorker getWorker() throws XmlRpcLoadException {
        int max = this.controller.getMaxThreads();
        if (max > 0 && this.numThreads == max) {
            throw new XmlRpcLoadException("Maximum number of concurrent requests exceeded: " + max);
        }
        if (max == 0) {
            return this.singleton;
        }
        ++this.numThreads;
        if (this.pool.size() == 0) {
            return this.newWorker();
        }
        return (XmlRpcWorker)this.pool.remove(this.pool.size() - 1);
    }

    public synchronized void releaseWorker(XmlRpcWorker pWorker) {
        --this.numThreads;
        int max = this.controller.getMaxThreads();
        if (pWorker != this.singleton && this.pool.size() < max) {
            this.pool.add(pWorker);
        }
    }

    public synchronized int getCurrentRequests() {
        return this.numThreads;
    }
}

