from __future__ import absolute_import, division, print_function
from libtbx import easy_run

input_model = '''
CRYST1  130.690  260.300  281.800  90.00  90.00  90.00 P 21 21 21
SCALE1      0.007652  0.000000  0.000000        0.00000
SCALE2      0.000000  0.003842  0.000000        0.00000
SCALE3      0.000000  0.000000  0.003549        0.00000
ATOM     91  N   LEU A  54      20.742 150.819  94.874  1.00120.00           N
ATOM     92  CA  LEU A  54      20.638 151.937  95.856  1.00120.00           C
ATOM     93  C   LEU A  54      21.814 152.929  95.898  1.00120.00           C
ATOM     94  O   LEU A  54      22.823 152.732  95.186  1.00120.00           O
ATOM     95  CB  LEU A  54      20.461 151.285  97.237  1.00120.00           C
ATOM     96  CG  LEU A  54      19.658 149.983  97.288  1.00120.00           C
ATOM     97  CD1 LEU A  54      18.167 150.245  97.141  1.00120.00           C
ATOM     98  CD2 LEU A  54      19.941 149.218  98.572  1.00120.00           C
ATOM     99  H   LEU A  54      21.018 150.068  95.285  1.00120.00           H
ATOM    100  HA  LEU A  54      19.822 152.444  95.639  1.00120.00           H
ATOM    101  HB2 LEU A  54      21.349 151.110  97.606  1.00120.00           H
ATOM    102  HB3 LEU A  54      20.025 151.935  97.825  1.00120.00           H
ATOM    103  HG  LEU A  54      19.944 149.418  96.528  1.00120.00           H
ATOM    104 HD11 LEU A  54      17.684 149.401  97.174  1.00120.00           H
ATOM    105 HD12 LEU A  54      17.865 150.819  97.866  1.00120.00           H
ATOM    106 HD13 LEU A  54      17.996 150.683  96.289  1.00120.00           H
ATOM    107 HD21 LEU A  54      19.528 148.338  98.525  1.00120.00           H
ATOM    108 HD22 LEU A  54      20.903 149.118  98.685  1.00120.00           H
ATOM    109 HD23 LEU A  54      19.576 149.707  99.329  1.00120.00           H
ATOM    110  N   ASN A  55      21.617 153.948  96.766  1.00120.00           N
ATOM    111  CA  ASN A  55      22.531 155.021  97.266  1.00120.00           C
ATOM    112  C   ASN A  55      22.509 156.274  96.393  1.00120.00           C
ATOM    113  O   ASN A  55      23.555 156.637  95.831  1.00120.00           O
ATOM    114  CB  ASN A  55      23.913 154.482  97.623  1.00120.00           C
ATOM    115  CG  ASN A  55      23.739 153.392  98.653  1.00120.00           C
ATOM    116  OD1 ASN A  55      22.618 153.017  98.980  1.00120.00           O
ATOM    117  ND2 ASN A  55      24.791 152.757  99.098  1.00120.00           N
ATOM    118  H   ASN A  55      20.770 154.146  97.037  1.00120.00           H
ATOM    119  HA  ASN A  55      22.147 155.301  98.130  1.00120.00           H
ATOM    120  HB2 ASN A  55      24.346 154.121  96.823  1.00120.00           H
ATOM    121  HB3 ASN A  55      24.466 155.203  97.988  1.00120.00           H
ATOM    122  N   GLU A  56      21.318 156.876  96.301  1.00120.00           N
ATOM    123  CA  GLU A  56      20.966 158.175  95.651  1.00120.00           C
ATOM    124  C   GLU A  56      21.609 158.222  94.246  1.00120.00           C
ATOM    125  O   GLU A  56      21.438 157.225  93.524  1.00120.00           O
ATOM    126  CB  GLU A  56      21.082 159.334  96.668  1.00120.00           C
ATOM    127  CG  GLU A  56      22.375 159.494  97.470  1.00120.00           C
ATOM    128  CD  GLU A  56      23.607 159.913  96.688  1.00120.00           C
ATOM    129  OE1 GLU A  56      23.490 160.899  95.937  1.00120.00           O
ATOM    130  OE2 GLU A  56      24.665 159.272  96.825  1.00120.00           O
ATOM    131  H   GLU A  56      20.593 156.517  96.721  1.00120.00           H
ATOM    132  HA  GLU A  56      20.000 158.107  95.471  1.00120.00           H
ATOM    133  HB2 GLU A  56      20.925 160.170  96.181  1.00120.00           H
ATOM    134  HB3 GLU A  56      20.345 159.236  97.307  1.00120.00           H
ATOM    135  HG2 GLU A  56      22.217 160.188  98.145  1.00120.00           H
ATOM    136  HG3 GLU A  56      22.570 158.680  97.960  1.00120.00           H
ATOM    226  C1  NAG A2001      26.288 152.579  99.625  1.00120.00           C
ATOM    227  C2  NAG A2001      26.292 152.561 101.153  1.00120.00           C
ATOM    228  C3  NAG A2001      27.587 152.013 101.713  1.00120.00           C
ATOM    229  C4  NAG A2001      27.713 150.595 101.193  1.00120.00           C
ATOM    230  C5  NAG A2001      27.692 150.594  99.662  1.00120.00           C
ATOM    231  C6  NAG A2001      27.611 149.183  99.103  1.00120.00           C
ATOM    232  C7  NAG A2001      25.896 154.087 102.985  1.00120.00           C
ATOM    233  C8  NAG A2001      25.579 155.489 103.409  1.00120.00           C
ATOM    234  N2  NAG A2001      25.996 153.879 101.677  1.00120.00           N
ATOM    235  O3  NAG A2001      27.573 151.975 103.140  1.00120.00           O
ATOM    236  O4  NAG A2001      28.804 149.907 101.844  1.00120.00           O
ATOM    237  O5  NAG A2001      26.501 151.233  99.203  1.00120.00           O
ATOM    238  O6  NAG A2001      28.880 148.767  98.602  1.00120.00           O
ATOM    239  O7  NAG A2001      26.050 153.186 103.791  1.00120.00           O
ATOM    240  H1  NAG A2001      27.390 152.977  99.425  1.00120.00           H
ATOM    241  H2  NAG A2001      25.486 151.888 101.475  1.00120.00           H
ATOM    242  H3  NAG A2001      28.406 152.641 101.354  1.00120.00           H
ATOM    243  H4  NAG A2001      26.791 150.081 101.500  1.00120.00           H
ATOM    244  H5  NAG A2001      28.561 151.116  99.240  1.00120.00           H
ATOM    245  H61 NAG A2001      27.285 148.496  99.886  1.00120.00           H
ATOM    246  H62 NAG A2001      26.873 149.154  98.299  1.00120.00           H
ATOM    247  H81 NAG A2001      24.530 155.631 103.405  1.00120.00           H
ATOM    248  H82 NAG A2001      25.958 155.658 104.383  1.00120.00           H
ATOM    249  H83 NAG A2001      26.026 156.170 102.733  1.00120.00           H
ATOM    250  HN2 NAG A2001      25.863 154.643 101.030  1.00120.00           H
ATOM    251  HO3 NAG A2001      28.407 151.606 103.462  1.00120.00           H
ATOM    252  HO6 NAG A2001      28.770 147.934  98.122  1.00120.00           H
ATOM    253  C1  NAG A2002      30.262 150.211 101.739  1.00120.00           C
ATOM    254  C2  NAG A2002      31.006 150.060 103.073  1.00120.00           C
ATOM    255  C3  NAG A2002      32.407 149.482 102.952  1.00120.00           C
ATOM    256  C4  NAG A2002      32.454 148.412 101.885  1.00120.00           C
ATOM    257  C5  NAG A2002      32.105 149.120 100.586  1.00120.00           C
ATOM    258  C6  NAG A2002      32.380 148.310  99.327  1.00120.00           C
ATOM    259  C7  NAG A2002      31.892 151.549 104.798  1.00120.00           C
ATOM    260  C8  NAG A2002      31.972 152.967 105.272  1.00120.00           C
ATOM    261  N2  NAG A2002      31.169 151.363 103.693  1.00120.00           N
ATOM    262  O3  NAG A2002      32.826 148.946 104.211  1.00120.00           O
ATOM    263  O4  NAG A2002      33.752 147.807 101.946  1.00120.00           O
ATOM    264  O5  NAG A2002      30.712 149.394 100.650  1.00120.00           O
ATOM    265  O6  NAG A2002      33.791 148.107  99.189  1.00120.00           O
ATOM    266  O7  NAG A2002      32.453 150.645 105.392  1.00120.00           O
ATOM    267  H1  NAG A2002      30.373 151.261 101.436  1.00120.00           H
ATOM    268  H2  NAG A2002      30.414 149.417 103.739  1.00120.00           H
ATOM    269  H3  NAG A2002      33.090 150.291 102.656  1.00120.00           H
ATOM    270  H4  NAG A2002      31.679 147.664 102.100  1.00120.00           H
ATOM    271  H5  NAG A2002      32.671 150.061 100.533  1.00120.00           H
ATOM    272  H61 NAG A2002      31.996 148.844  98.454  1.00120.00           H
ATOM    273  H62 NAG A2002      31.871 147.346  99.388  1.00120.00           H
ATOM    274  H81 NAG A2002      30.999 153.323 105.488  1.00120.00           H
ATOM    275  H82 NAG A2002      32.408 153.567 104.516  1.00120.00           H
ATOM    276  H83 NAG A2002      32.567 153.014 106.147  1.00120.00           H
ATOM    277  HN2 NAG A2002      30.731 152.159 103.253  1.00120.00           H
ATOM    278  HO3 NAG A2002      33.766 148.727 104.169  1.00120.00           H
ATOM    279  HO6 NAG A2002      33.969 147.611  98.378  1.00120.00           H
ATOM    280  C1  BMA A2003      33.732 146.369 102.120  1.00120.00           C
ATOM    281  C2  BMA A2003      33.505 145.870 103.554  1.00120.00           C
ATOM    282  C3  BMA A2003      33.759 144.371 103.613  1.00120.00           C
ATOM    283  C4  BMA A2003      32.968 143.668 102.521  1.00120.00           C
ATOM    284  C5  BMA A2003      33.280 144.312 101.185  1.00120.00           C
ATOM    285  C6  BMA A2003      32.604 143.536 100.068  1.00120.00           C
ATOM    286  O2  BMA A2003      32.172 146.059 104.040  1.00120.00           O
ATOM    287  O3  BMA A2003      33.360 143.861 104.889  1.00120.00           O
ATOM    288  O4  BMA A2003      33.303 142.277 102.454  1.00120.00           O
ATOM    289  O5  BMA A2003      32.868 145.676 101.229  1.00120.00           O
ATOM    290  O6  BMA A2003      32.891 142.146 100.256  1.00120.00           O
ATOM    291  H1  BMA A2003      34.747 146.032 101.870  1.00120.00           H
ATOM    292  H2  BMA A2003      34.221 146.372 104.221  1.00120.00           H
ATOM    293  H3  BMA A2003      34.831 144.185 103.453  1.00120.00           H
ATOM    294  H4  BMA A2003      31.896 143.786 102.728  1.00120.00           H
ATOM    295  H5  BMA A2003      34.366 144.267 101.026  1.00120.00           H
ATOM    296  H61 BMA A2003      32.984 143.868  99.099  1.00120.00           H
ATOM    297  H62 BMA A2003      31.526 143.704 100.092  1.00120.00           H
ATOM    298  HO2 BMA A2003      32.067 146.963 104.365  1.00120.00           H
ATOM    299  HO3 BMA A2003      33.846 144.320 105.588  1.00120.00           H
ATOM    300  HO4 BMA A2003      33.053 141.845 103.282  1.00120.00           H
'''

result = '''Links applied
    BETA1-4
      " NAG A2001 " - " NAG A2002 "
      " NAG A2002 " - " BMA A2003 "
    NAG-ASN
      " NAG A2001 " - " ASN A  55 "'''

def main():
  input_model_filename = 'carbo_linking_output.pdb'
  with open(input_model_filename, 'w') as f:
    f.write(input_model)
  cmd = 'phenix.pdb_interpretation %s' % input_model_filename
  rc = easy_run.go(cmd)
  lines = '\n'.join(rc.stdout_lines)
  assert lines.find(result)>-1
  print('OK')

if __name__ == '__main__':
  main()
