# - Look for GNU flex, the lexer generator.
# Defines the following:
#  FLEX_EXECUTABLE - path to the flex executable
#  FLEX_FILE - parse a file with flex
#  FLEX_PREFIX_OUTPUTS - Set to true to make FLEX_FILE produce outputs of
#                        lex.${filename}.c, not lex.yy.c . Passes -P to flex.

IF(NOT DEFINED FLEX_PREFIX_OUTPUTS)
  SET(FLEX_PREFIX_OUTPUTS FALSE)
ENDIF(NOT DEFINED FLEX_PREFIX_OUTPUTS)

IF(NOT FLEX_EXECUTABLE)
  FIND_PROGRAM(FLEX_EXECUTABLE flex)
  IF (FLEX_EXECUTABLE)
    MESSAGE (STATUS "Found flex -- ${FLEX_EXECUTABLE}")
  ELSE (FLEX_EXECUTABLE)
    MESSAGE (ERROR "flex not found")
  ENDIF(FLEX_EXECUTABLE)
ENDIF(NOT FLEX_EXECUTABLE)

IF(FLEX_EXECUTABLE)
  MACRO(FLEX OUT_FILE SWITCHES IN_FILE)
    GET_FILENAME_COMPONENT(PATH "${IN_FILE}" PATH)

    IF(NOT EXISTS "${CMAKE_CURRENT_BINARY_DIR}/${PATH}")
      FILE(MAKE_DIRECTORY "${CMAKE_CURRENT_BINARY_DIR}/${PATH}")
    ENDIF(NOT EXISTS "${CMAKE_CURRENT_BINARY_DIR}/${PATH}")

    SET(FULL_OUT_FILE "${CMAKE_CURRENT_BINARY_DIR}/${PATH}${OUT_FILE}")
    SET(FULL_IN_FILE  "${CMAKE_CURRENT_SOURCE_DIR}/${IN_FILE}")

    ADD_CUSTOM_COMMAND(
      OUTPUT  "${FULL_OUT_FILE}"
      COMMAND "${FLEX_EXECUTABLE}"
      ARGS    "${SWITCHES}"
              -o"${FULL_OUT_FILE}"
              "${FULL_IN_FILE}"
      DEPENDS "${FULL_IN_FILE}")

    SET_SOURCE_FILES_PROPERTIES("${FULL_OUT_FILE}" PROPERTIES GENERATED TRUE)
  ENDMACRO(FLEX)
ENDIF(FLEX_EXECUTABLE)
