!{\src2tex{textfont=tt}}
!!****f* ABINIT/diffvc
!! NAME
!! diffvc
!!
!! FUNCTION
!! Given the charge density of a homogenous e-gas, this calculates
!! the differential of the correlation potential wrt rho.
!! It does this by evaluating the differential of the Ceperley-Alder
!! expression given by PERDEW & ZUNGER (PRB,Vol 23,No 10,P.5048,15 May 1981)
!! Gamma,Beta1,Beta2,A,B,C,D are parameters for the fit, in atomic units.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  rho=density in real space, at one point
!!
!! OUTPUT
!!  function diffvc=differential of the correlation potential wrt rho
!!
!! TODO
!!  Use the other abinit routine
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

function diffvc(rho)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 real(dp) :: diffvc
 real(dp),intent(in) :: rho

!Local variables-------------------------------
!scalars
 real(dp),parameter :: a=0.0311,b=-0.0480,beta1=1.0529,beta2=0.3334,c=0.0020
 real(dp),parameter :: d=-0.0116,gamma=-0.1423
 real(dp) :: rs,stor1,stor2,stor3

! *************************************************************************

!calculate Rs from the density
 rs=(3.0/(4.0*pi*rho))**third
!two different calculations depending if Rs<>1
 if(rs>1.0) then
  stor1=(1.0+beta1*sqrt(rs)+beta2*rs)**(-3.0)
  stor2=-0.41666667*beta1*(rs**(-0.5))-0.5833333*(beta1**2)-0.66666667*beta2
  stor3=-1.75*beta1*beta2*sqrt(rs)-1.3333333*rs*(beta2**2)
  diffvc=gamma*stor1*(stor2+stor3)
 else
  diffvc=a/rs+0.66666667*(c*log(rs)+d)+0.33333333*c
 end if
 diffvc=diffvc*(-4.0*pi/9.0)*(rs**4)
 return
 end function diffvc
!!***
