subroutine  inivel(vel,npart,ndim,masse,reall,options)

  !Definit les positions initiales
  !variables
  !  vel(npart,ndim):position des particules
  !  npart:nombre de particules
  !  velopt:type de reseau 
  !  ndim: dimensionlite de l'espace
  !  temp: temperature pour les gaussiennes
  !  var: variance des gaussiennes
  !  ran1,ran2: nombres aleatoires unif dans 0,1, pour la formule de Box Muller (cf num recipes)
  USE types_def
  IMPLICIT NONE
  TYPE(options_type) :: options
  !input
  integer :: ndim,npart
  double precision :: vel(npart,ndim)
  double precision :: masse, reall
  character*10 :: velopt
  !local variables
  integer :: inunit=5,ipart,idim
  double precision :: temp,var
  real ::  ran1,ran2, pi=3.1415926538
  namelist /vel_data/ temp
  if (options%velopt=='gaussien') then
     read(unit=inunit,nml=vel_data)
     var=1./sqrt(masse/temp)
     do ipart=1,npart
        do idim=1,ndim
           call random_number(ran1)
           call random_number(ran2)
           vel(ipart,idim)=sqrt(-log(ran1))*cos(2.*pi*ran2)*var
        enddo
     enddo
     elseif(options%velopt=="file")then
        open(unit=19,file="velfile")
        read(19,*)(vel(ipart,:),ipart=1,npart)
  endif
  vel(:,:)=vel(:,:)/reall
  print*,'vel:'
  print*,(vel(ipart,:),ipart=1,npart)
  return
end subroutine inivel


