#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Strangeland
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241215.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='strangeland'
GAME_NAME='Strangeland'

ARCHIVE_BASE_4_NAME='strangeland_3_5c_78464.sh'
ARCHIVE_BASE_4_MD5='6be43bac931e5350ab03f671ed37ebf9'
ARCHIVE_BASE_4_SIZE='4301875'
ARCHIVE_BASE_4_VERSION='3.5c-gog78464'
ARCHIVE_BASE_4_URL='https://www.gog.com/game/strangeland'

ARCHIVE_BASE_3_NAME='strangeland_3_57270.sh'
ARCHIVE_BASE_3_MD5='68e18616d01d902c0982a3a1d1a8e3cd'
ARCHIVE_BASE_3_SIZE='4400000'
ARCHIVE_BASE_3_VERSION='3.0-gog57270'

ARCHIVE_BASE_2_NAME='strangeland_2_7_55701.sh'
ARCHIVE_BASE_2_MD5='719e693167ba8014aea03b858d9cd9c1'
ARCHIVE_BASE_2_SIZE='4400000'
ARCHIVE_BASE_2_VERSION='2.7-gog55701'

ARCHIVE_BASE_1_NAME='strangeland_2_6c_54396.sh'
ARCHIVE_BASE_1_MD5='afa5999b3074480966c2226f2356f6b9'
ARCHIVE_BASE_1_SIZE='4400000'
ARCHIVE_BASE_1_VERSION='2.6c-gog54396'

ARCHIVE_BASE_0_NAME='strangeland_2_3a_49446.sh'
ARCHIVE_BASE_0_MD5='a313a7ee812815b5e53ebc643c53da76'
ARCHIVE_BASE_0_SIZE='4400000'
ARCHIVE_BASE_0_VERSION='2.3a-gog49446'

CONTENT_PATH_DEFAULT='data/noarch/game/data'
CONTENT_GAME_MAIN_FILES='
Music
Sounds
*.ags
*.cfg
*.exe
*.ogv
*.tra
*.vox'
## TODO: Check if this "ENGV.tmp" file is actually useful
CONTENT_GAME0_MAIN_FILES='
ENGV.tmp'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_SCUMMID='ags:strangeland'
## Strangeland.exe is too big, wrestool crashes when trying to handle it.
APP_MAIN_ICON='winsetup.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
