/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardCalcType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardDataType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardFetchType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardInterval;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardValueType;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardViewTypeDescriptor;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardDatabaseSelectDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DashboardEditDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.DashboardEditDialog";
    private final DashboardDescriptor dashboardDescriptor;
    private Text idText;
    private Text nameText;
    private Text descriptionText;
    private Text queryText;
    private Combo viewTypeCombo;
    private Text updatePeriodText;
    private Text maxItemsText;
    private List<DashboardViewType> viewTypes;
    private Combo dataTypeCombo;
    private Combo calcTypeCombo;
    private Combo valueTypeCombo;
    private Combo intervalCombo;
    private Combo fetchTypeCombo;
    private DBPNamedObject targetDatabase;

    public DashboardEditDialog(Shell shell, DashboardDescriptor dashboardDescriptor) {
        super(shell, NLS.bind((String)UIDashboardMessages.dialog_edit_dashboard_title, (Object)dashboardDescriptor.getName()), null);
        this.dashboardDescriptor = dashboardDescriptor;
        List<DBPNamedObject> dataSourceMappings = dashboardDescriptor.getDataSourceMappings();
        if (!dataSourceMappings.isEmpty()) {
            this.targetDatabase = dataSourceMappings.get(0);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        Enum dvt;
        int baseStyle;
        Composite composite = super.createDialogArea(parent);
        boolean readOnly = !this.dashboardDescriptor.isCustom();
        int n = baseStyle = !readOnly ? 0 : 8;
        if (readOnly) {
            UIUtils.createInfoLabel((Composite)composite, (String)UIDashboardMessages.dialog_edit_dashboard_infolabels_predifined_dashboard);
        }
        Group infoGroup = UIUtils.createControlGroup((Composite)composite, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo, (int)4, (int)768, (int)0);
        this.idText = UIUtils.createLabelText((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_id, (String)this.dashboardDescriptor.getId(), (int)(0x800 | baseStyle));
        this.idText.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.idText.addModifyListener(e -> this.updateButtons());
        this.nameText = UIUtils.createLabelText((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_name, (String)this.dashboardDescriptor.getName(), (int)(0x800 | baseStyle));
        this.nameText.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.nameText.addModifyListener(e -> this.updateButtons());
        UIUtils.createControlLabel((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_db);
        Composite dbSelectorPanel = UIUtils.createComposite((Composite)infoGroup, (int)2);
        GridData gd22 = new GridData(768);
        gd22.horizontalSpan = 3;
        dbSelectorPanel.setLayoutData((Object)gd22);
        final Text dbSelectorText22 = new Text(dbSelectorPanel, 2056);
        dbSelectorText22.setLayoutData((Object)new GridData(768));
        if (this.targetDatabase != null) {
            dbSelectorText22.setText(this.targetDatabase.getName());
        }
        UIUtils.createPushButton((Composite)dbSelectorPanel, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_buttons_select, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardDatabaseSelectDialog selectDialog = new DashboardDatabaseSelectDialog(DashboardEditDialog.this.getShell());
                if (selectDialog.open() == 0) {
                    DashboardEditDialog.this.targetDatabase = selectDialog.getTarget();
                    dbSelectorText22.setText(DashboardEditDialog.this.targetDatabase.getName());
                }
                DashboardEditDialog.this.updateButtons();
            }
        });
        this.dataTypeCombo = UIUtils.createLabelCombo((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_datatype, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_datatype_tooltip, (int)2060);
        Enum[] enumArray = DashboardDataType.values();
        int dbSelectorText22 = enumArray.length;
        int gd22 = 0;
        while (gd22 < dbSelectorText22) {
            DashboardDataType ddt = enumArray[gd22];
            this.dataTypeCombo.add(ddt.name());
            ++gd22;
        }
        this.dataTypeCombo.setText(this.dashboardDescriptor.getDataType().name());
        this.dataTypeCombo.setEnabled(!readOnly);
        this.calcTypeCombo = UIUtils.createLabelCombo((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_calctype, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_calctype_tooltip, (int)2060);
        enumArray = DashboardCalcType.values();
        dbSelectorText22 = enumArray.length;
        gd22 = 0;
        while (gd22 < dbSelectorText22) {
            Enum dct = enumArray[gd22];
            this.calcTypeCombo.add(dct.name());
            ++gd22;
        }
        this.calcTypeCombo.setText(this.dashboardDescriptor.getCalcType().name());
        this.calcTypeCombo.setEnabled(!readOnly);
        this.valueTypeCombo = UIUtils.createLabelCombo((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_valuetype, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_valuetype_tooltip, (int)2060);
        enumArray = DashboardValueType.values();
        dbSelectorText22 = enumArray.length;
        gd22 = 0;
        while (gd22 < dbSelectorText22) {
            dvt = enumArray[gd22];
            this.valueTypeCombo.add(dvt.name());
            ++gd22;
        }
        this.valueTypeCombo.setText(this.dashboardDescriptor.getValueType().name());
        this.valueTypeCombo.setEnabled(!readOnly);
        this.intervalCombo = UIUtils.createLabelCombo((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_interval, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_interval_tooltip, (int)2060);
        enumArray = DashboardInterval.values();
        dbSelectorText22 = enumArray.length;
        gd22 = 0;
        while (gd22 < dbSelectorText22) {
            dvt = enumArray[gd22];
            this.intervalCombo.add(dvt.name());
            ++gd22;
        }
        this.intervalCombo.setText(this.dashboardDescriptor.getInterval().name());
        this.intervalCombo.setEnabled(!readOnly);
        this.fetchTypeCombo = UIUtils.createLabelCombo((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_fetchtype, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_combos_fetchtype_tooltip, (int)2060);
        enumArray = DashboardFetchType.values();
        dbSelectorText22 = enumArray.length;
        gd22 = 0;
        while (gd22 < dbSelectorText22) {
            Enum dft = enumArray[gd22];
            this.fetchTypeCombo.add(dft.name());
            ++gd22;
        }
        this.fetchTypeCombo.setText(this.dashboardDescriptor.getFetchType().name());
        this.fetchTypeCombo.setEnabled(!readOnly);
        UIUtils.createEmptyLabel((Composite)infoGroup, (int)2, (int)1);
        this.descriptionText = UIUtils.createLabelText((Composite)infoGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_description, (String)CommonUtils.notEmpty((String)this.dashboardDescriptor.getDescription()), (int)(0xA42 | baseStyle));
        ((GridData)this.descriptionText.getLayoutData()).heightHint = 30;
        ((GridData)this.descriptionText.getLayoutData()).widthHint = 300;
        ((GridData)this.descriptionText.getLayoutData()).horizontalSpan = 3;
        Group sqlGroup = UIUtils.createControlGroup((Composite)composite, (String)UIDashboardMessages.dialog_edit_dashboard_queries, (int)1, (int)1808, (int)0);
        this.queryText = new Text((Composite)sqlGroup, 0xA42 | baseStyle);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 400;
        this.queryText.setLayoutData((Object)gd);
        UIUtils.createInfoLabel((Composite)sqlGroup, (String)UIDashboardMessages.dialog_edit_dashboard_queries_infolabels_separator);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder sql = new StringBuilder();
        for (DashboardDescriptor.QueryMapping query : this.dashboardDescriptor.getQueries()) {
            sql.append(query.getQueryText().trim()).append(lineSeparator).append(lineSeparator);
        }
        if (this.dashboardDescriptor.getMapQuery() != null) {
            sql.append(this.dashboardDescriptor.getMapQuery().getQueryText()).append(lineSeparator).append(lineSeparator);
            if (!ArrayUtils.isEmpty((Object[])this.dashboardDescriptor.getMapKeys())) {
                sql.append(UIDashboardMessages.dialog_edit_dashboard_queries_keys).append(" ").append(Arrays.toString(this.dashboardDescriptor.getMapKeys())).append(lineSeparator);
            }
            if (!ArrayUtils.isEmpty((Object[])this.dashboardDescriptor.getMapLabels())) {
                sql.append(UIDashboardMessages.dialog_edit_dashboard_queries_labels).append(" ").append(Arrays.toString(this.dashboardDescriptor.getMapLabels())).append(lineSeparator);
            }
        }
        this.queryText.setText(sql.toString().trim());
        Group updateGroup = UIUtils.createControlGroup((Composite)composite, (String)UIDashboardMessages.dialog_edit_dashboard_rendering, (int)2, (int)768, (int)0);
        this.viewTypeCombo = UIUtils.createLabelCombo((Composite)updateGroup, (String)UIDashboardMessages.dialog_edit_dashboard_rendering_combos_defaultview, (String)UIDashboardMessages.dialog_edit_dashboard_rendering_combos_defaultview_tooltip, (int)2056);
        this.viewTypeCombo.setLayoutData((Object)new GridData(768));
        this.viewTypes = DashboardRegistry.getInstance().getAllViewTypes();
        for (DashboardViewType viewType : this.viewTypes) {
            this.viewTypeCombo.add(viewType.getTitle());
        }
        this.viewTypeCombo.setText(this.dashboardDescriptor.getDefaultViewType().getTitle());
        if (this.viewTypeCombo.getSelectionIndex() < 0) {
            this.viewTypeCombo.select(0);
        }
        this.viewTypeCombo.setEnabled(!readOnly);
        this.updatePeriodText = UIUtils.createLabelText((Composite)updateGroup, (String)UIDashboardMessages.dialog_edit_dashboard_rendering_labels_updateperiod, (String)String.valueOf(this.dashboardDescriptor.getUpdatePeriod()), (int)(0x800 | baseStyle), (Object)new GridData(768));
        this.maxItemsText = UIUtils.createLabelText((Composite)updateGroup, (String)UIDashboardMessages.dialog_edit_dashboard_rendering_labels_maxitems, (String)String.valueOf(this.dashboardDescriptor.getMaxItems()), (int)(0x800 | baseStyle), (Object)new GridData(768));
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtons();
        return contents;
    }

    private void updateButtons() {
        Button okButton = this.getButton(0);
        okButton.setEnabled(this.dashboardDescriptor.isCustom() && !this.idText.getText().isEmpty() && !this.nameText.getText().isEmpty() && !this.queryText.getText().isEmpty() && this.viewTypeCombo.getSelectionIndex() >= 0 && this.targetDatabase != null);
    }

    private void saveSettings() {
        this.dashboardDescriptor.setId(this.idText.getText());
        this.dashboardDescriptor.setName(this.nameText.getText());
        this.dashboardDescriptor.setDataSourceMappings(Collections.singletonList(this.targetDatabase));
        this.dashboardDescriptor.setDescription(this.descriptionText.getText());
        this.dashboardDescriptor.setDataType(DashboardDataType.values()[this.dataTypeCombo.getSelectionIndex()]);
        this.dashboardDescriptor.setCalcType(DashboardCalcType.values()[this.calcTypeCombo.getSelectionIndex()]);
        this.dashboardDescriptor.setValueType(DashboardValueType.values()[this.valueTypeCombo.getSelectionIndex()]);
        this.dashboardDescriptor.setInterval(DashboardInterval.values()[this.intervalCombo.getSelectionIndex()]);
        this.dashboardDescriptor.setFetchType(DashboardFetchType.values()[this.fetchTypeCombo.getSelectionIndex()]);
        this.dashboardDescriptor.setQueries(this.queryText.getText().split("\\n\\s*\\n"));
        this.dashboardDescriptor.setDefaultViewType((DashboardViewTypeDescriptor)this.viewTypes.get(this.viewTypeCombo.getSelectionIndex()));
        this.dashboardDescriptor.setUpdatePeriod(CommonUtils.toLong((Object)this.updatePeriodText.getText(), (long)this.dashboardDescriptor.getUpdatePeriod()));
        this.dashboardDescriptor.setMaxItems(CommonUtils.toInt((Object)this.maxItemsText.getText(), (int)this.dashboardDescriptor.getMaxItems()));
    }

    protected void okPressed() {
        this.saveSettings();
        DashboardRegistry.getInstance().saveSettings();
        super.okPressed();
    }
}

