/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableKeyColumn;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;

public class ExasolTableUniqueKey
extends JDBCTableConstraint<ExasolTable>
implements DBSEntityReferrer,
DBPScriptObject,
DBPNamedObject2 {
    private String owner;
    private Boolean enabled;
    private List<ExasolTableKeyColumn> columns;

    public ExasolTableUniqueKey(DBRProgressMonitor monitor, ExasolTable table, ResultSet dbResult, DBSEntityConstraintType type) throws DBException {
        super((JDBCTable)table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME"), null, type, true);
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_OWNER");
        this.enabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CONSTRAINT_ENABLED");
    }

    public ExasolTableUniqueKey(ExasolTable exasolTable, DBSEntityConstraintType constraintType, Boolean enabled, String name) {
        super((JDBCTable)exasolTable, name, "", constraintType, false);
        this.enabled = enabled;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getTable().getContainer(), this.getTable(), this});
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.getTable().getDataSource();
    }

    public List<? extends DBSEntityAttributeRef> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.columns;
    }

    public void setColumns(List<ExasolTableKeyColumn> columns) {
        this.columns = columns;
    }

    @Property(viewable=true, editable=false, order=2)
    public ExasolTable getTable() {
        return (ExasolTable)super.getTable();
    }

    @Property(viewable=true, editable=false, order=3)
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return super.getConstraintType();
    }

    @Property(viewable=false, editable=false, length=PropertyLength.MULTILINE, order=4)
    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, editable=true, updatable=true)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean hasColumn(ExasolTableColumn column) {
        if (this.columns != null) {
            for (ExasolTableKeyColumn constColumn : this.columns) {
                if (constColumn.getAttribute() != column) continue;
                return true;
            }
        }
        return false;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return ExasolUtils.getPKDdl(this, monitor);
    }

    public void setEnabled(Boolean enable) {
        this.enabled = enable;
    }
}

