/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLBlockToggleToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;

public class SQLDollarQuoteRule
implements TPPredicateRule {
    private final boolean partitionRule;
    private final TPToken stringToken;
    private final TPToken delimiterToken;

    public SQLDollarQuoteRule(DBPDataSourceContainer dataSource, boolean partitionRule) {
        this.partitionRule = partitionRule;
        this.stringToken = new TPTokenDefault(SQLTokenType.T_STRING);
        this.delimiterToken = new SQLBlockToggleToken();
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    @Override
    public TPToken getSuccessToken() {
        return this.stringToken;
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner, boolean resume) {
        int totalRead = 0;
        int c = scanner.read();
        ++totalRead;
        if (c == 36) {
            int charsRead = 0;
            do {
                c = scanner.read();
                ++charsRead;
                ++totalRead;
                if (c != 36) continue;
                if (charsRead <= 1) {
                    boolean stringEndFound = false;
                    while (true) {
                        c = scanner.read();
                        ++totalRead;
                        if (c == -1) break;
                        if (c != 36) continue;
                        int c2 = scanner.read();
                        ++totalRead;
                        if (c2 == 36) {
                            stringEndFound = true;
                            break;
                        }
                        scanner.unread();
                        --totalRead;
                    }
                    if (!stringEndFound) {
                        if (this.partitionRule) break;
                        SQLDollarQuoteRule.unread(scanner, totalRead - 2);
                        return this.delimiterToken;
                    }
                    return this.stringToken;
                }
                if (this.partitionRule) break;
                return this.delimiterToken;
            } while (Character.isLetterOrDigit(c) || c == 95);
        }
        SQLDollarQuoteRule.unread(scanner, totalRead);
        return TPTokenAbstract.UNDEFINED;
    }

    private static void unread(TPCharacterScanner scanner, int totalRead) {
        while (totalRead-- > 0) {
            scanner.unread();
        }
    }
}

