/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.generator;

import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.generator.SQLGeneratorResultSet;

public class SQLGeneratorUpdateFromData
extends SQLGeneratorResultSet {
    public boolean isDMLOption() {
        return true;
    }

    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, IResultSetController object) throws DBException {
        for (ResultSetRow firstRow : this.getSelectedRows()) {
            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, object);
            Collection valueAttributes = this.getValueAttributes(monitor, object, keyAttributes);
            sql.append("UPDATE ").append(this.getEntityName(this.getSingleEntity()));
            sql.append(this.getLineSeparator()).append("SET ");
            boolean hasAttr = false;
            for (DBSAttributeBase dBSAttributeBase : valueAttributes) {
                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
                if (hasAttr) {
                    sql.append(", ");
                }
                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                DBDAttributeBinding binding = this.getController().getModel().getAttributeBinding(dBSAttributeBase);
                if (binding == null) {
                    this.appendDefaultValue(sql, dBSAttributeBase);
                } else {
                    this.appendAttributeValue(this.getController(), sql, binding, firstRow);
                }
                hasAttr = true;
            }
            sql.append(this.getLineSeparator()).append("WHERE ");
            hasAttr = false;
            for (DBDAttributeBinding dBDAttributeBinding : keyAttributes) {
                if (hasAttr) {
                    sql.append(" AND ");
                }
                this.appendValueCondition(this.getController(), sql, dBDAttributeBinding, firstRow);
                hasAttr = true;
            }
            sql.append(";\n");
        }
    }
}

