/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLSyntaxManager {
    @NotNull
    private SQLDialect sqlDialect = BasicSQLDialect.INSTANCE;
    @NotNull
    private DBPPreferenceStore preferenceStore = ModelPreferences.getPreferences();
    @Nullable
    private String[][] identifierQuoteStrings;
    private String[][] stringQuoteStrings;
    private char structSeparator;
    private boolean parametersEnabled;
    private boolean anonymousParametersEnabled;
    private char anonymousParameterMark;
    private String[] namedParameterPrefixes;
    private String controlCommandPrefix;
    private boolean variablesEnabled;
    @NotNull
    private String catalogSeparator = String.valueOf('.');
    @NotNull
    private String[] statementDelimiters = new String[0];
    private char escapeChar;
    private boolean blankLineDelimiter;

    @NotNull
    public SQLDialect getDialect() {
        return this.sqlDialect;
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public char getStructSeparator() {
        return this.structSeparator;
    }

    @NotNull
    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    @NotNull
    public String[] getStatementDelimiters() {
        return this.statementDelimiters;
    }

    public boolean isBlankLineDelimiter() {
        return this.blankLineDelimiter;
    }

    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return this.identifierQuoteStrings;
    }

    public String[][] getStringQuoteStrings() {
        return this.stringQuoteStrings;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public boolean isParametersEnabled() {
        return this.parametersEnabled;
    }

    public boolean isAnonymousParametersEnabled() {
        return this.anonymousParametersEnabled;
    }

    public char getAnonymousParameterMark() {
        return this.anonymousParameterMark;
    }

    public String[] getNamedParameterPrefixes() {
        return this.namedParameterPrefixes;
    }

    public String getControlCommandPrefix() {
        return this.controlCommandPrefix;
    }

    public boolean isVariablesEnabled() {
        return this.variablesEnabled;
    }

    public void init(@NotNull DBPDataSource dataSource) {
        this.init(SQLUtils.getDialectFromObject(dataSource), dataSource.getContainer().getPreferenceStore());
    }

    public void init(@NotNull SQLDialect dialect, @NotNull DBPPreferenceStore preferenceStore) {
        this.statementDelimiters = new String[0];
        this.sqlDialect = dialect;
        this.preferenceStore = preferenceStore;
        this.identifierQuoteStrings = this.sqlDialect.getIdentifierQuoteStrings();
        this.stringQuoteStrings = this.sqlDialect.getStringQuoteStrings();
        this.structSeparator = this.sqlDialect.getStructSeparator();
        this.catalogSeparator = this.sqlDialect.getCatalogSeparator();
        this.escapeChar = dialect.getStringEscapeCharacter();
        if (!preferenceStore.getBoolean("script.sql.ignoreNativeDelimiter")) {
            String[] scriptDelimiters = this.sqlDialect.getScriptDelimiters();
            this.statementDelimiters = new String[scriptDelimiters.length];
            int i = 0;
            while (i < scriptDelimiters.length) {
                this.statementDelimiters[i] = scriptDelimiters[i].toLowerCase();
                ++i;
            }
        }
        String extraDelimiters = preferenceStore.getString("script.sql.delimiter");
        StringTokenizer st = new StringTokenizer(extraDelimiters, " \t,");
        while (st.hasMoreTokens()) {
            String delim = st.nextToken();
            if (ArrayUtils.contains((Object[])this.statementDelimiters, (Object)delim)) continue;
            this.statementDelimiters = (String[])ArrayUtils.add(String.class, (Object[])this.statementDelimiters, (Object)delim);
        }
        this.blankLineDelimiter = preferenceStore.getBoolean("script.sql.delimiter.blank");
        this.parametersEnabled = preferenceStore.getBoolean("sql.parameter.enabled");
        this.anonymousParametersEnabled = preferenceStore.getBoolean("sql.parameter.anonymous.enabled");
        this.variablesEnabled = preferenceStore.getBoolean("sql.variables.enabled");
        String markString = preferenceStore.getString("sql.parameter.mark");
        this.anonymousParameterMark = CommonUtils.isEmpty((String)markString) ? (char)63 : markString.charAt(0);
        LinkedHashSet<String> paramsPrefixes = new LinkedHashSet<String>();
        String paramPrefixString = preferenceStore.getString("sql.parameter.prefix");
        if (!CommonUtils.isEmpty((String)paramPrefixString)) {
            paramsPrefixes.add(paramPrefixString);
        }
        Collections.addAll(paramsPrefixes, dialect.getParametersPrefixes());
        this.namedParameterPrefixes = paramsPrefixes.toArray(new String[0]);
        this.controlCommandPrefix = preferenceStore.getString("sql.command.prefix");
        if (CommonUtils.isEmpty((String)this.controlCommandPrefix)) {
            this.controlCommandPrefix = "@";
        }
    }

    @NotNull
    public DBPIdentifierCase getKeywordCase() {
        String caseName = this.preferenceStore.getString("sql.format.keywordCase");
        if (CommonUtils.isEmpty((String)caseName)) {
            return this.sqlDialect.storesUnquotedCase();
        }
        return (DBPIdentifierCase)CommonUtils.valueOf(DBPIdentifierCase.class, (String)caseName.toUpperCase(), (Enum)DBPIdentifierCase.MIXED);
    }
}

