/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver;

import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.bundle.ModelActivator;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class Log {
    private static final boolean TRACE_LOG_ENABLED = CommonUtils.getBoolean((String)System.getProperty("dbeaver.trace.enabled"));
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static ILog eclipseLog;
    private static Listener[] listeners;
    private final String name;
    private static ThreadLocal<PrintStream> logWriter;
    private static boolean quietMode;
    private final boolean doEclipseLog;
    @Nullable
    private static PrintStream defaultDebugStream;

    static {
        listeners = new Listener[0];
        ModelActivator instance = ModelActivator.getInstance();
        try {
            eclipseLog = instance == null ? null : instance.getLog();
        }
        catch (Throwable throwable) {
            eclipseLog = null;
        }
        quietMode = ArrayUtils.contains((Object[])Platform.getApplicationArgs(), (Object)"-q");
        logWriter = new ThreadLocal();
    }

    public static void setDefaultDebugStream(@NotNull PrintStream defaultDebugStream) {
        Log.defaultDebugStream = defaultDebugStream;
    }

    public static Log getLog(Class<?> forClass) {
        return new Log(forClass.getName(), true);
    }

    public static Log getLog(String name) {
        return new Log(name, true);
    }

    public static Log getLog(String name, boolean doEclipseLog) {
        return new Log(name, doEclipseLog);
    }

    public static boolean isQuietMode() {
        return quietMode;
    }

    public static PrintStream getLogWriter() {
        return logWriter.get();
    }

    public static void setLogWriter(OutputStream logWriter) {
        if (logWriter == null) {
            Log.logWriter.remove();
        } else if (logWriter instanceof PrintStream) {
            Log.logWriter.set((PrintStream)logWriter);
        } else {
            Log.logWriter.set(new PrintStream(logWriter, true));
        }
    }

    public void log(IStatus status) {
        if (status == null) {
            return;
        }
        int severity = status.getSeverity();
        String message = status.getMessage();
        Throwable exception = status.getException();
        switch (severity) {
            case 8: {
                this.debug(message, exception);
                break;
            }
            case 4: {
                this.error(message, exception);
                break;
            }
            case 2: {
                this.warn(message, exception);
                break;
            }
            case 1: {
                this.info(message, exception);
                break;
            }
            case 0: {
                this.trace(message, exception);
                break;
            }
        }
    }

    private Log(String name, boolean doEclipseLog) {
        this.name = name;
        this.doEclipseLog = doEclipseLog;
    }

    public void flush() {
        PrintStream logStream = logWriter.get();
        if (logStream != null) {
            logStream.flush();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(Object message) {
        if (message instanceof Throwable) {
            this.trace(message.toString(), (Throwable)message);
        } else {
            this.trace(message, null);
        }
    }

    public void trace(Object message, Throwable t) {
        if (TRACE_LOG_ENABLED) {
            this.debug(message, t);
        }
    }

    public void debug(Object message) {
        if (message instanceof Throwable) {
            this.debug(message.toString(), (Throwable)message);
        } else {
            this.debug(message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        this.debugMessage(message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugMessage(Object message, Throwable t) {
        PrintStream logStream = logWriter.get();
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            PrintStream debugWriter;
            PrintStream printStream = logStream != null ? logStream : (debugWriter = quietMode ? null : defaultDebugStream);
            if (debugWriter == null && !quietMode) {
                debugWriter = System.err;
            }
            if (debugWriter == null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            debugWriter.print(String.valueOf(sdf.format(new Date())) + " - ");
            if (message != null) {
                debugWriter.println(message);
            }
            if (t != null) {
                t.printStackTrace(debugWriter);
            }
            if (message == null && t == null) {
                debugWriter.println();
            }
            debugWriter.flush();
            Listener[] listenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Listener listener = listenerArray[n2];
                listener.loggedMessage(message, t);
                ++n2;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (t != null) {
                Throwable ex = t;
                while (ex != null) {
                    if (ex instanceof SQLException) {
                        SQLException error = ((SQLException)ex).getNextException();
                        while (error != null) {
                            String chainedMessage = error.getMessage();
                            if (!CommonUtils.isEmpty((String)chainedMessage)) {
                                this.debug(chainedMessage.trim());
                            }
                            error = error.getNextException();
                        }
                    }
                    ex = ex.getCause();
                }
            }
            return;
        }
    }

    public void info(Object message) {
        if (message instanceof Throwable) {
            this.info(message.toString(), (Throwable)message);
            return;
        }
        this.debugMessage(message, null);
        int severity = 1;
        this.writeEclipseLog((IStatus)Log.createStatus(severity, message));
    }

    public void info(Object message, Throwable t) {
        this.writeExceptionStatus(1, message, t);
    }

    public void warn(Object message) {
        if (message instanceof Throwable) {
            this.warn(message.toString(), (Throwable)message);
            return;
        }
        this.debugMessage(message, null);
        int severity = 2;
        this.writeEclipseLog((IStatus)Log.createStatus(severity, message));
    }

    public void warn(Object message, Throwable t) {
        this.writeExceptionStatus(2, message, t);
    }

    public void error(Object message) {
        if (message instanceof Throwable) {
            this.error(null, (Throwable)message);
            return;
        }
        this.debugMessage(message, null);
        int severity = 4;
        this.writeEclipseLog((IStatus)Log.createStatus(severity, message));
    }

    public void error(Object message, Throwable t) {
        this.writeExceptionStatus(4, message, t);
    }

    public void fatal(Object message) {
        this.error(message);
    }

    public void fatal(Object message, Throwable t) {
        this.error(message, t);
    }

    private void writeExceptionStatus(int severity, Object message, Throwable t) {
        this.debugMessage(message, t);
        if (logWriter.get() == null) {
            if (t == null) {
                this.writeEclipseLog((IStatus)Log.createStatus(severity, message));
            } else if (message == null) {
                this.writeEclipseLog(GeneralUtils.makeExceptionStatus(severity, t));
            } else {
                this.writeEclipseLog(GeneralUtils.makeExceptionStatus(severity, message.toString(), t));
            }
        }
    }

    private void writeEclipseLog(IStatus status) {
        if (this.doEclipseLog && logWriter.get() == null && eclipseLog != null) {
            eclipseLog.log(status);
        }
    }

    private static Status createStatus(int severity, Object message) {
        return new Status(severity, "org.jkiss.dbeaver.model", message == null ? null : message.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(Listener listener) {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            listeners = (Listener[])ArrayUtils.add(Listener.class, (Object[])listeners, (Object)listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(Listener listener) {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            listeners = (Listener[])ArrayUtils.remove(Listener.class, (Object[])listeners, (Object)listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static interface Listener {
        public void loggedMessage(Object var1, Throwable var2);
    }
}

