/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import ancestris.reports.ScopeOptions;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import org.openide.util.NbBundle;

public class FormatPlaceOptions {
    public static final int PLACE_ALL = 0;
    public static final int PLACE_CITY = 1;
    public static final int PLACE_CUSTOM = 2;
    public int reportPlaceFormat = 0;
    public String[] reportPlaceFormats = new String[]{NbBundle.getMessage(ScopeOptions.class, (String)"place.allJurisdictions"), NbBundle.getMessage(ScopeOptions.class, (String)"place.city"), NbBundle.getMessage(ScopeOptions.class, (String)"reportPlaceFormatCustom")};
    public String reportPlaceFormatCustom = "";

    public String getPlace(Property property) {
        return FormatPlaceOptions.getPlaceValue(property, this.reportPlaceFormat, this.reportPlaceFormatCustom);
    }

    public String getPlaceFormat() {
        switch (this.reportPlaceFormat) {
            case 0: {
                return "{ $P}";
            }
            case 1: {
                return "{ $p}";
            }
            case 2: {
                return this.reportPlaceFormatCustom;
            }
        }
        throw new AssertionError();
    }

    public boolean isCustom() {
        return this.reportPlaceFormat == 2;
    }

    public String getCustomFormat(Property event) {
        Object ret = "";
        if (this.reportPlaceFormat == 2) {
            Property pPlace = event.getProperty("PLAC");
            Object object = ret = pPlace != null ? pPlace.format(this.reportPlaceFormatCustom) : "";
            if (!((String)ret).isBlank()) {
                ret = " " + ((String)ret).trim();
            }
        }
        return ret;
    }

    public static String getPlaceValue(Property place, int reportPlaceFormat, String format) {
        if (place == null) {
            return "";
        }
        if (place instanceof PropertyPlace) {
            PropertyPlace pPlace = (PropertyPlace)place;
            switch (reportPlaceFormat) {
                case 0: {
                    String strPlace = pPlace.getValue();
                    strPlace = strPlace.replaceAll(", ,", ", ");
                    strPlace = strPlace.replaceAll("(^,|,$)", "");
                    return strPlace.trim();
                }
                case 1: {
                    return pPlace.getCity();
                }
                case 2: {
                    return place.format(format);
                }
            }
            throw new AssertionError();
        }
        if (place.getTag().equals("ADDR")) {
            if (reportPlaceFormat == 1) {
                Property pCity = place.getProperty("CITY");
                if (pCity == null) {
                    return "";
                }
                return pCity.getDisplayValue();
            }
            String sep = ", ";
            StringBuilder sb = new StringBuilder();
            sb.append((String)(!place.getDisplayValue().isBlank() ? place.getDisplayValue() + sep : ""));
            Property pAdr1 = place.getProperty("ADR1");
            sb.append((String)(pAdr1 != null ? pAdr1.getDisplayValue() + sep : ""));
            Property pAdr2 = place.getProperty("ADR2");
            sb.append((String)(pAdr2 != null ? pAdr2.getDisplayValue() + sep : ""));
            Property pAdr3 = place.getProperty("ADR3");
            sb.append((String)(pAdr3 != null ? pAdr3.getDisplayValue() + sep : ""));
            Property pCity = place.getProperty("CITY");
            sb.append((String)(pCity != null ? pCity.getDisplayValue() + sep : ""));
            Property pStae = place.getProperty("STAE");
            sb.append((String)(pStae != null ? pStae.getDisplayValue() + sep : ""));
            Property pPost = place.getProperty("POST");
            sb.append((String)(pPost != null ? pPost.getDisplayValue() + sep : ""));
            Property pCtry = place.getProperty("CTRY");
            sb.append((String)(pCtry != null ? pCtry.getDisplayValue() + sep : ""));
            return sb.toString();
        }
        return place.toString();
    }
}

