/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import org.openide.util.Exceptions;

public class FormatDateOptions {
    public boolean reportDatesOnlyYears = false;

    public String getDate(Property property) {
        return FormatDateOptions.getDateValue(property, this.reportDatesOnlyYears);
    }

    public String getDateFormat() {
        return this.reportDatesOnlyYears ? "{ $y}" : "{ $D}";
    }

    public static String getDateValue(Property date, boolean yearsOnly) {
        if (date == null) {
            return "";
        }
        if (date instanceof PropertyDate) {
            PropertyDate pDate = (PropertyDate)date;
            if (yearsOnly) {
                try {
                    return "" + pDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return "" + pDate.getStart().getYear();
                }
            }
            return pDate.getShortReportValue();
        }
        return "";
    }
}

