/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.table;

import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.FieldDate;
import ancestris.modules.releve.model.FieldPicture;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordMarriage;
import ancestris.modules.releve.table.TableModelRecordAbstract;
import genj.gedcom.Gedcom;
import java.util.ResourceBundle;
import javax.swing.RowFilter;

public class TableModelRecordAll
extends TableModelRecordAbstract {
    final String[] columnName = new String[]{ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.column.Id"), ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.column.City"), ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.column.Date"), ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.column.EventType"), ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.column.Participant1"), ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.column.Participant2"), ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.column.Picture")};
    final Class<?>[] columnType = new Class[]{Integer.class, String.class, FieldDate.class, String.class, String.class, String.class, FieldPicture.class};

    public TableModelRecordAll(DataManager dataManager) {
        super(dataManager);
    }

    @Override
    public int getColumnCount() {
        return this.columnName.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnName[col];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.columnType[column];
    }

    @Override
    public Object getValueAt(int row, int col) {
        AbstractRecord record = this.getRecord(row);
        if (record == null) {
            return null;
        }
        return switch (col) {
            case 0 -> row + 1;
            case 1 -> record.getCity();
            case 2 -> record.getField(AbstractRecord.FieldType.eventDate);
            case 3 -> {
                if (record instanceof RecordBirth) {
                    yield Gedcom.getName((String)"BIRT");
                }
                if (record instanceof RecordMarriage) {
                    yield Gedcom.getName((String)"MARR");
                }
                if (record instanceof RecordDeath) {
                    yield Gedcom.getName((String)"DEAT");
                }
                yield record.getFieldValue(AbstractRecord.FieldType.eventTag);
            }
            case 4 -> record.getFieldValue(AbstractRecord.FieldType.indiLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.indiFirstName);
            case 5 -> record.getFieldValue(AbstractRecord.FieldType.wifeLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.wifeFirstName);
            case 6 -> record.getFieldValue(AbstractRecord.FieldType.cote) + " " + record.getFieldValue(AbstractRecord.FieldType.freeComment);
            default -> super.getValueAt(row, col);
        };
    }

    @Override
    public RowFilter<TableModelRecordAbstract, Integer> getRecordFilter() {
        return new RowFilter<TableModelRecordAbstract, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModelRecordAbstract, ? extends Integer> entry) {
                return true;
            }
        };
    }

    @Override
    public String getModelName() {
        return "all";
    }
}

