/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.renderer.Blueprint;
import genj.renderer.DPI;
import genj.renderer.views.I18NView;
import genj.renderer.views.MarkView;
import genj.renderer.views.MediaView;
import genj.renderer.views.MyView;
import genj.renderer.views.PropertyView;
import genj.renderer.views.RootView;
import genj.util.EnvironmentChecker;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.text.html.parser.TagElement;
import org.openide.util.Exceptions;

public class BlueprintRenderer {
    private static final Logger LOG = Logger.getLogger("ancestris.renderer");
    private static final DTD dtd = null;
    private final RootView root;
    private HTMLDocument doc = new MyHTMLDocument();
    private MyHTMLFactory factory = new MyHTMLFactory();
    private Property entity;
    private List<MyView> volatileViews = new ArrayList<MyView>(64);
    private List<View> tableViews = new ArrayList<View>(4);
    private boolean isDebug = false;
    private Graphics2D graphics;
    private Font plain;
    private Font bold;
    private Font italic;
    private Font bolditalic;
    private static final String BLUEPRINT_TAGS = "prop|ifvalue|name|i18n|mark|media";
    private List<TagAttribute> tagAttributes = new ArrayList<TagAttribute>();
    private String blueprintHTMLtemplate = "";

    public BlueprintRenderer(Blueprint bp) {
        Object html = bp.getHTML();
        if (!((String)html).contains("<body")) {
            html = "<body>" + (String)html + "</body>";
        }
        if (!((String)html).contains("<html")) {
            html = "<html>" + (String)html + "</html>";
        }
        try {
            MyHTMLReader reader = new MyHTMLReader(this.doc);
            new MyDocumentParser(DTD.getDTD("html32")).parse(new StringReader((String)html), reader, false);
            reader.flush();
        }
        catch (IOException | BadLocationException t) {
            Logger.getLogger("ancestris.renderer").log(Level.WARNING, "can't parse blueprint " + bp, t);
        }
        this.root = new RootView(this.factory.create(this.doc.getDefaultRootElement()), this);
    }

    public void prepareHTMLBlueprint() {
        HTMLEditorKit kit = new HTMLEditorKit();
        this.doc.setParser(new ParserDelegator());
        int i = 0;
        for (MyView view : this.volatileViews) {
            Element elem = view.getElement();
            int index = this.volatileViews.indexOf(view);
            TagAttribute tagAttribute = this.tagAttributes.get(index);
            Stack<String> tags = new Stack<String>();
            StringBuilder sb = new StringBuilder();
            for (String attr : tagAttribute.attributes) {
                String tag = attr.split("\\s+")[0].replaceAll("<", "").replaceAll(">", "");
                tags.push(tag);
                sb.append(attr);
            }
            sb.append("{").append(i).append("}");
            while (!tags.empty()) {
                sb.append("</");
                sb.append((String)tags.pop());
                sb.append(">");
            }
            try {
                this.doc.setOuterHTML(elem, sb.toString());
            }
            catch (IOException | BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ++i;
        }
        StringWriter writer = new StringWriter();
        try {
            kit.write(writer, (Document)this.doc, 0, this.doc.getLength());
        }
        catch (IOException | BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.blueprintHTMLtemplate = writer.toString();
    }

    public String renderHTML(Property e, int width, int height, File parentDir) {
        this.entity = e;
        ArrayList<String> htmlValues = new ArrayList<String>();
        for (MyView view : this.volatileViews) {
            view.invalidate();
            Element elem = view.getElement();
            htmlValues.add(view.getHTMLValue(width, height, parentDir));
        }
        String[] values = (String[])htmlValues.toArray(String[]::new);
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile("\\{([0-9]*?)\\}");
        Matcher matcher = pattern.matcher(this.blueprintHTMLtemplate);
        int cursor = 0;
        while (matcher.find()) {
            result.append(this.blueprintHTMLtemplate.substring(cursor, matcher.start()));
            int key = Integer.parseInt(matcher.group(1));
            result.append(values[key]);
            cursor = matcher.end();
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics g, Property e, Rectangle r) {
        this.entity = e;
        this.graphics = (Graphics2D)g;
        Font font = g.getFont();
        if (EnvironmentChecker.isWindows()) {
            float factor = (float)DPI.get(this.graphics).vertical() / 72.0f;
            font = font.deriveFont(factor * font.getSize2D());
        }
        this.plain = font;
        this.bold = font.deriveFont(1);
        this.italic = font.deriveFont(2);
        this.bolditalic = font.deriveFont(3);
        try {
            this.volatileViews.forEach(pv -> pv.invalidate());
            this.tableViews.forEach(tv -> tv.replace(0, 0, null));
            this.root.setSize((float)r.getWidth(), (float)r.getHeight());
            Rectangle oc = g.getClipBounds();
            g.clipRect(r.x, r.y, r.width, r.height);
            try {
                this.root.paint(g, r);
            }
            finally {
                g.setClip(oc.x, oc.y, oc.width, oc.height);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "can't render", t);
        }
    }

    public void setDebug(boolean set) {
        this.isDebug = set;
    }

    public Property getProperty(Property entity, TagPath path) {
        return entity.getProperty(path);
    }

    public RootView getRoot() {
        return this.root;
    }

    public HTMLDocument getDoc() {
        return this.doc;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public ViewFactory getFactory() {
        return this.factory;
    }

    public Property getEntity() {
        return this.entity;
    }

    public boolean isIsDebug() {
        return this.isDebug;
    }

    static {
        new ParserDelegator();
    }

    private class MyHTMLDocument
    extends HTMLDocument {
        private MyHTMLDocument() {
        }

        @Override
        public Font getFont(AttributeSet attr) {
            Font result = BlueprintRenderer.this.plain;
            if (StyleConstants.isBold(attr) && StyleConstants.isItalic(attr)) {
                result = BlueprintRenderer.this.bolditalic;
            } else if (StyleConstants.isBold(attr)) {
                result = BlueprintRenderer.this.bold;
            } else if (StyleConstants.isItalic(attr)) {
                result = BlueprintRenderer.this.italic;
            }
            if (attr.isDefined(StyleConstants.FontSize)) {
                result = result.deriveFont((float)StyleConstants.getFontSize(attr));
            }
            return result;
        }
    }

    private class MyHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private MyHTMLFactory() {
        }

        @Override
        public View create(Element elem) {
            String name = elem.getName();
            if ("prop".equals(name) || "ifvalue".equals(name)) {
                PropertyView result = new PropertyView(elem, BlueprintRenderer.this);
                BlueprintRenderer.this.volatileViews.add(result);
                return result;
            }
            if ("mark".equals(name)) {
                MarkView result = new MarkView(elem, BlueprintRenderer.this);
                BlueprintRenderer.this.volatileViews.add(result);
                return result;
            }
            if ("name".equals(name) || "i18n".equals(name)) {
                I18NView result = new I18NView(elem, BlueprintRenderer.this);
                BlueprintRenderer.this.volatileViews.add(result);
                return result;
            }
            if ("media".equals(name)) {
                MediaView result = new MediaView(elem, BlueprintRenderer.this);
                BlueprintRenderer.this.volatileViews.add(result);
                return result;
            }
            View result = super.create(elem);
            if ("table".equals(elem.getName())) {
                BlueprintRenderer.this.tableViews.add(result);
            }
            return result;
        }
    }

    private static class MyHTMLReader
    extends HTMLDocument.HTMLReader {
        private boolean skipContent;

        protected MyHTMLReader(HTMLDocument doc) {
            HTMLDocument hTMLDocument = doc;
            Objects.requireNonNull(hTMLDocument);
            super(hTMLDocument, 0);
            this.skipContent = false;
        }

        @Override
        protected void blockClose(HTML.Tag t) {
            this.skipContent = true;
            super.blockClose(t);
            this.skipContent = false;
        }

        @Override
        protected void addContent(char[] data, int offs, int length, boolean generateImpliedPIfNecessary) {
            if (!this.skipContent) {
                super.addContent(data, offs, length, generateImpliedPIfNecessary);
            }
        }
    }

    private class MyDocumentParser
    extends DocumentParser {
        private final Stack<String> attributes;

        private MyDocumentParser(DTD dtd) {
            super(dtd);
            this.attributes = new Stack();
            this.strict = true;
        }

        @Override
        protected void handleStartTag(TagElement tag) {
            if (!tag.getHTMLTag().isBlock() && !tag.getHTMLTag().toString().equals("html")) {
                String attrs = this.getAttributes().toString().trim();
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                sb.append(tag.getHTMLTag());
                if (!attrs.isBlank()) {
                    sb.append(" ");
                    sb.append(attrs);
                }
                sb.append(">");
                this.attributes.push(sb.toString());
            }
            super.handleStartTag(tag);
        }

        @Override
        protected void handleEndTag(TagElement tag) {
            if (!(tag.getHTMLTag().isBlock() || tag.getHTMLTag().toString().equals("html") || this.attributes.empty())) {
                this.attributes.pop();
            }
            super.handleEndTag(tag);
        }

        @Override
        protected void handleError(int ln, String errorMsg) {
            String[] bits;
            String tag;
            if (errorMsg.contains("tag.unrecognized") && (tag = (bits = errorMsg.split("\\s+"))[1]).matches(BlueprintRenderer.BLUEPRINT_TAGS)) {
                BlueprintRenderer.this.tagAttributes.add(new TagAttribute(tag, new ArrayList<String>(this.attributes)));
            }
            super.handleError(ln, errorMsg);
        }
    }

    private class TagAttribute {
        private String tag;
        private List<String> attributes = new ArrayList<String>();

        public TagAttribute(String tag, List<String> attributes) {
            this.tag = tag;
            this.attributes = attributes;
        }
    }
}

