# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# config.py
#
# fichier de configuration du backend zephir
#
###########################################################################
from zephir.config import *
import os

# paramètres de connexion à la base postgresql

DB_HOST = "127.0.0.1"
DB_USER = "zephir"
DB_NAME = "zephir"
# récupération du mdp postgresql pour zephir (possible seulement pour root)
f_pwd = '/usr/share/zephir/utils/conf_db'
try:
    exec(open(f_pwd).read())
    assert DB_PASSWD
except:
    DB_PASSWD = ""

# paths
TEMPLATE_DIR = ROOT_DIR + 'backend/template/'
SCHEDULER_DELAY = 60
AAF_DIR = os.path.join(PATH_ZEPHIR, 'aaf')

# fonctions utiles

def u(objet):
    if isinstance(objet, (list, tuple, set)):
        l = []
        for item in objet:
            l.append(u(item))
        return l
    if type(objet) == dict:
        dico = {}
        for cle in objet:
            dico[cle] = u(objet[cle])
        return dico
    return objet

# fonction renvoyant le statut d'un fichier (manquant, fichier ou répertoire)
def get_file_info(f_local):
    f_info = "missing"
    if os.path.exists(f_local):
        if os.path.isdir(f_local):
            f_info = "dir"
        else:
            f_info = "file"
    return f_info

# dictionnaires de conversion des jours/mois pour les logs
days={'Mon':'Lun', 'Tue':'Mar', 'Wed':'Mer', 'Thu':'Jeu', 'Fri':'Ven', 'Sat':'Sam', 'Sun':'Dim'}
months={'Jan':'Jan', 'Feb':'Fév', 'Mar':'Mar', 'Apr':'Avr', 'May':'Mai', 'Jun':'Jun', 'Jul':'Jui', 'Aug':'Aoû', 'Sep':'Sep', 'Oct':'Oct', 'Nov':'Nov', 'Dec':'Déc'}

# template de configuration uucp pour un serveur
CONFIG_UUCP="""# configuration du serveur %s
system %s
call-login %s
call-password %s
time any
port tcp
protocol t
pubdir /var/spool/uucppublic
protocol-parameter g timeout 20
protocol-parameter g retries 10
remote-send ~
remote-receive ~
local-receive ~
local-send /
"""

FILE_SECTION = """# section 1
# liste des fichiers à sauvegarder
# (ne pas modifier sauf pour créer ou mettre à jour la variante)"""
RPM_SECTION = """# section 2
# inscrire les noms des paquetages qui seront installés à la mise à jour du serveur
# (ils doivent être présents sur le serveur de mise à jour)"""

# liste des paquets indispensable à la création d'un nouveau module
minimum_paqs = """eole/eole-server\neole/eole-zephir-module"""

held_packages = ["^linux-.*server$","^linux-.*generic$"]

migration_files = {'amon-2.0':{'files':[('filtres-users','filtres-users',True),
                                    ('serialize_btn.srz','serialize_btn.srz',False),
                                    ('local','local',False),
                                    ('perso','perso',False),
                                    ('tmp','tmp',True),
                                    ('horaires.txt','tmp/horaires.txt',True)],
                           'rights':[('filtres-users','','www-data','www-data','0644'),
                                     ('local','-R','www-data','proxy','0755'),
                                     ('local/*','','www-data','proxy','0644'),
                                     ('local/liste_blanche','-R','www-data','proxy','0755'),
                                     ('local/liste_blanche/*','','www-data','proxy','0644'),
                                     ('tmp','','www-data','www-data','0777'),
                                     ('tmp/*','','www-data','www-data','0644'),
                                     ('serialize_btn.srz','','www-data','www-data','0644')],
                           'exclude':['rapport-maj.html','blacklist-date.txt','Reconf.log']}
                  }

DEFAULT_PARAMS = {'agents':1
                  ,'dico_ok':0
                  ,'config_ok':0
                  ,'migration_ok':1
                  ,'cle_ok':0
                  ,'new_key':(0,'')
                  ,'maj_ok':[-2,'']
                  ,'reboot_ok':[-2,'']
                  ,'service_restart_ok':[-2,'']
                  ,'query_maj':[-2,'']
                  ,'reconfigure_ok':[-2,'']
                  ,'configure_ok':[-2,'']
                  ,'sauvegarde_ok':[-2,'']
                  ,'upgrade_ok':[-2,'']
                  ,'perso_ok':[-2,'']
                  ,'dictpaqs_ok':[-2,'']
                  ,'lock_ok':[1,'']
                  ,'timeout':[1,'']
                  ,'md5s':[-1,'']
                  ,'last_log':'journal vide'
                }
