try:
    from zephir.backend.uucp_utils import uucp_pool, UUCPError, COMMANDS
except:
    sys.exit("zephir doit être dans le PYTHONPATH \nexport PYTHONPATH=/usr/share\n")
import sys,time

# id_uucp correspond à l'identifiant du serveur dans la conf uucp
# (dans zephir : numero_rne-identifiant_serveur)
id_uucp = "0210056X-1"

try:
    # ajout d'un fichier
    print "ajout fichier ..."
    id_file = uucp_pool.add_file(id_uucp,"/tmp/config.rpt")

    # ajout d'une commande
    print "ajout de 2 commandes ..."
    id_cmd1 = uucp_pool.add_cmd(id_uucp,"zephir_client configure")
    id_cmd2 = uucp_pool.add_cmd(id_uucp,"zephir_client reconfigure")
    
    # affichage de la file d'attente de ce serveur (on met un petit temps d'attente
    # pour être sur que la commande est bien ajoutée avant l'affichage)
    time.sleep(0.5)
    print "commandes : %s \n fichiers : %s \n" % (uucp_pool.list_cmd(id_uucp),uucp_pool.list_files(id_uucp))

    # on supprime le fichier de la file
    print "suppression commande 1 ..."
    uucp_pool.remove_cmd(id_uucp,id_cmd2)
    print "commandes : %s \n fichiers : %s \n" % (uucp_pool.list_cmd(id_uucp),uucp_pool.list_files(id_uucp))

    # on purge toutes les commandes
    print "vidage complet ..."
    uucp_pool.flush([id_uucp])
    print "commandes : %s \n fichiers : %s \n" % (uucp_pool.list_cmd(id_uucp),uucp_pool.list_files(id_uucp))
except UUCPError,e:
    sys.exit(("Erreur UUCP %s" % str(e)))

