# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# rapport.py
#
# Interface d'écriture de rapport pour Zephir
#
###########################################################################
import random,os
from zephir.rapports import connecteur, rml
from zephir import config

class Rapport:

    def __init__(self,server,rne_rapport=None):
        self.PATH = config.PATH_TEMP
        if not os.path.isdir(config.PATH_TEMP):
            os.makedirs(config.PATH_TEMP)
        self.connect = connecteur.Connecteur(server,rne_rapport)
        self.rml = rml.RML()

    def rapport_global(self):
        """
        Rapport concernant le zephir dans son ensemble
        """
        xml = self.modules() + self.rml.page_break()
        xml += self.variantes() + self.rml.page_break()
        xml += self.liste_etabs() + self.rml.page_break()
        xml += self.detail_etabs() + self.rml.page_break()
        pdf_string = self.rml.page("Rapport global",xml)
        pdf = self.rml.dump_pdf(pdf_string)
        filename = os.path.join(self.PATH,"rapport.pdf")
        fh = open(filename,'w')
        fh.write(pdf)
        fh.close()


    def pdf_file(self, pdf_string):
        """Serialisation de la chaine pdf
        dans un fichier au nom aléatoire
        """
        filename = os.path.join(self.PATH, str(random.random()) + ".pdf")

        fh = open(filename,'wb')
        fh.write(pdf_string)
        fh.close()

        return filename

    def modules(self):
        """Liste des modules
        """
        module = self.connect.module()
        table = self.rml.list_to_table(module)

        xml = self.rml.sect("Liste des modules disponibles", table )

        return xml

    def variante_module(self, id_module):
        """
        """
        # récupération du nom du module
        title = "Variantes du module : %s" % self.connect.nom_module(id_module)

        # récupération des variantes
        variante = self.connect._dict_variante(id_module)
        xml = ""
        for id_variante in variante.keys():
            xml = self.rml.list_to_table(self.connect.get_variante(id_variante))
        rml_string = self.rml.sect(title, xml)
        return rml_string

    def variantes(self):
        title = "Liste des variantes"
        xml = ""
        for id_module in self.connect.dict_module().keys():
            xml += self.variante_module(id_module)
        return xml


    def detail_etab(self, id_etab):
        # on ignore les établissements n'ayant pas de serveurs
        serveurs= self.connect.id_serveur_etab(id_etab)
        if serveurs == []:
            serveurs = ""
        else:
            serveurs= self._liste_serveurs_etab(id_etab)
        title = "Détails de l'établissement %s" % self.connect.nom_etab(id_etab)
        etab = self.connect.get_etab(id_etab)
        xml = self.rml.dict_to_list(etab)
        rml_string = self.rml.sect(title, xml)
        return rml_string + serveurs

    def liste_etabs(self):
        title = "Liste des établissements"
        list_etab = self.connect.noms_etab()
        xml = self.rml.list_to_list(list_etab)
        rml_string = self.rml.sect(title, xml)
        return rml_string

    def detail_etabs(self):
        title = "Détail des établissements ayant des serveurs"
        xml = ""
        for id_etab in self.connect.id_etab():
            serveurs= self.connect.id_serveur_etab(id_etab)
            # on ignore les établissements n'ayant pas de serveurs
            if serveurs != []:
                xml += self.detail_etab(id_etab)
                xml += self.rml.page_break()
        rml_string = self.rml.sect(title, xml)
        return rml_string

    def _liste_serveurs_etab(self,id_etab):
        """Liste simple des serveurs d'un etab
        """
        title="Liste des serveurs de l'établissement : %s" % self.connect.nom_etab(id_etab)

        list_serveur = self.connect.libelle_serveur_etab(id_etab)
        xml = self.rml.list_to_list(list_serveur)

        return self.rml.sect(title, xml)

    def serveurs_etab(self, id_etab):
        """liste détaillée des serveurs d'un etab
        """
        title="Liste détaillées des serveurs de l'établissement : %s" % self.connect.nom_etab(id_etab)
        list_serv = self.connect.id_serveur_etab(id_etab)

        rml_string=""
        for id_serveur in list_serv:
            rml_string += self.serveur(id_serveur)

        return self.rml.sect(title, rml_string)

    def serveur(self, id_serveur):
        """Description détaillée d'un serveur
        """
        title = "Description du serveur : %s" % self.connect.nom_serveur(id_serveur)
        serveur = self.connect.get_serveur(id_serveur)

        # rml = self.rml.dict_to_list(serveur)

        dict_materiel = {
            'materiel': serveur['materiel'],
            'processeur': serveur['processeur'],
            'disque_dur': serveur['disque_dur']
            }

        materiel = """<para>
        <i>materiel</i> : %(materiel)s ,
        <i>processeur</i> : %(processeur)s,
        <i>disque dur</i> : %(disque_dur)s
        </para>
        """ % dict_materiel

        dict_module = {
            'module_actuel': serveur['module_actuel'],
            'module_initial' : serveur['module_initial'],
            'variante':serveur['variante']
            }

        module = """<para>
        <i>module initial </i> : %(module_initial)s,
        <i>module actuel installé </i> : %(module_actuel)s,
        <i>variante du module installé </i> : %(variante)s
        </para>
        """ % dict_module

        dict_description = {
            'installateur': serveur['installateur'],
            'tel': serveur['tel'],
            'remarques' : serveur['remarques'],
            'date_install': serveur['date_install'],
            'rne': serveur['rne']
            }

        description = """<para>
        <i>installateur</i> : %(installateur)s,
        <i>rne établissement</i> : %(rne)s,
        <i>contact téléphonique</i> : %(tel)s,
        <i>date d'installation</i> : %(date_install)s,
        <i>remarques</i> : %(remarques)s
        </para>
        """ % dict_description

        list = [description, materiel, module]
        xml = "".join(list)

        return self.rml.sect(title, xml)

    def pdf(self, method_name, param=""):
        """hack d'éval pour éviter les hooks
        """
        method = "self." + method_name + "(" + param + ")"
        xml = self.rml.page("Bilan de l'état du Zéphir", eval(method))
        pdf = self.rml.dump_pdf(xml)
        return self.pdf_file(pdf)

if __name__ == "__main__":
    """
    Si le module est exécuté tel quel,
    un rappport générique est créé dans le répertoire temporaire
    """
    r = Rapport()
    r.rapport_global()
    # print r.pdf("modules")
    # r.pdf("variante_module",1)
    # r.pdf("detail_etabs")
    # print r.pdf("detail_etab","'0210056X'")
