#!/bin/bash
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# update_theme.sh
#
# mise à jour des images et couleurs pour le thème de l'application web
#
###########################################################################

#procédure de mise à jour du thème de l'application web zephir
wpath=/usr/share/zephir/web
c_theme=$1

# création des répertoires
mkdir -p $wpath/css
mkdir -p $wpath/fonts

# nettoyage des répertoires utilisés par l'ancien thème
/bin/rm -f $wpath/images/*.*
/bin/rm -f $wpath/css/*.*
/bin/rm -f $wpath/fonts/*.*

# images spécifiques au thème
/bin/cp -f $wpath/themes/$c_theme/images/*.* $wpath/images/
/bin/cp -f $wpath/themes/$c_theme/fonts/*.* $wpath/fonts/
/bin/cp -f $wpath/themes/$c_theme/css/*.* $wpath/css/
/bin/cp -f $wpath/themes/$c_theme/agents/*.* /usr/share/zephir/monitor/static/img/
/bin/cp -f $wpath/themes/$c_theme/agents/*.* /var/lib/zephir/sites/img/
# sauvegarde du nom de thème activé
/bin/echo "$c_theme" > $wpath/current_theme
