# Zéphir

## How to update the EOLE XML schemas for a release

The `dl-schemas` tool replaces the old `maj_dicos.py` and download the
EOLE XML schema directly from the `.deb` repositories.

You can list all the options with the following command:

```
./outils/dl-schemas --help
```

By default, the tool:

* download the `.deb` packages from http://eole.ac-dijon.fr
* download for the 3 stable distributions:
  * `eole-<release>`
  * `eole-<release>-security`
  * `eole-<release>-updates`
* store the result under the `data/dictionnaires/` of this repository

You can download the `-unstable` packages with the `--devel` option:

```
./outils/dl-schemas --release 2.7.0 --devel --verbose
```

You can download for a list of releases:

```
./outils/dl-schemas --release 2.6.0,2.6.1,2.6.2
```

You can download for all the releases declared in the builtin
`EOLE_ENVOLE_MAPPING` variable:

```
./outils/dl-schemas --release all
```

### How to add a new release to the `dl-schemas` tool

Simply edit the `EOLE_ENVOLE_MAPPING` variable to add the new release
with its associated Envole distribution or `None` if Envole does not
support the new release.

## How to add a new module

Here is the minimalist steps:

* in the directory `/data/eolemodules/<EOLE VERSION ID>/`
* create a new file named `<module name>-<EOLE VERSION>` listing all packages with EOLE XML dictionaries:
  * execute the tool `outils/zephir_dicts.sh` on the freshly installed EOLE server to get the list
  * unarchive the `tar.gz`, the `.paqs` file is our file but need some adaptation:
	* remove the line `eole/zephir-stats`
	* add the line `eole/eole-zephir-module`
* to test before the commit:
  * copy the new file in the directory `/usr/share/zephir/eole_modules/<EOLE VERSION ID>/` of a Zéphir server with configuration
  * copy the directories of the new dictionary packages or the modified ones in the directory `/usr/share/zephir/dictionnaires/<VERSION>/`
* execute `reconfigure`
* verify the default variable modification of the new module in the web interface of Zéphir
  * go in `modules` menu
  * clic on `modifier` of your new module
  * clic on the button `Changer les valeurs par défaut avec l’interface de configuration`
  * a new window with GenConfig must be opened
