# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent FreshClam
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData, HTMLData
#from twisted.internet.utils import getProcessOutput
from zephir.monitor.agentmanager import status
from os.path import isfile
from zephir.monitor.agentmanager.util import status_to_img
from pyeole.diagnose import test_freshclam
import os


class Freshclam(Agent):
    """
    Utilisateurs connectes
    """
    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.status = status.Unknown()
        self.table = TableData([
            ('status', 'état', {'align':'center'}, status_to_img),
            ('msg', 'message', {'align':'left'}, None)
        ])
        self.data = [self.table]

#    def init_data(self, archive_dir):
#        title1 = HTMLData("<h3>Mise à jour de ClamAV<h3>")
#        self.data.extend([title1, self.table])
#        Agent.init_data(self, archive_dir)

    def measure(self):
        ret = test_freshclam()
        self.status = {'On': status.OK(), 'Off': status.Error(),
                       '': status.Unknown()}.get(ret['status'])
        return [ret]

    def check_status(self):
        return self.status

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value
