#!/bin/bash
#############################################
#					    #
# Script de remise en place des ACLs	    #
# sur les partages classe (donnees/travail) #
#					    #
# développé par eole <eole@ac-dijon.fr>     #
#					    #
#############################################

liste_classe=`ldapsearch -x description=classe* cn|grep "cn:"|awk '{print $2}'`
liste_groupe=`ldapsearch -x '(&(objectClass=posixGroup)(!(type=Groupe)))' cn|grep "cn:"|awk '{print $2}'`

err_group=""
err_prof=""
err_ele=""

for grp in $liste_groupe
do
    [ -n "$1" ] && [ "$1" != "$grp" ] && continue
	REP=/home/workgroups/${grp}
	if [ -d "${REP}" ]
	then
		if [ -d "${REP}/donnees" -a -d "${REP}/travail" ]
		then
			echo "Mise en place des ACLs pour le groupe (type classe) : ${grp}"
			donnees=${REP}/donnees
		        travail=${REP}/travail
			setfacl -Rbk ${REP}
			chown -R root:${grp} ${REP}
			chmod -R 700 ${REP}
			setfacl -m g:profs-${grp}:r-x ${REP}
			[ $? -ne 0 ] && err_prof="$err_prof profs-${grp}"
			setfacl -m g:profs-${grp}:rwx ${REP}/*
			[ -d "${travail}" ] && setfacl -Rm g:profs-${grp}:rwx ${travail}
			[ -d "${donnees}" ] && setfacl -Rm g:profs-${grp}:rwx ${donnees}
			# si le groupe est inexistant => erreur
			setfacl -m g:${grp}:r-x ${REP}
			[ $? -ne 0 ] && err_group="$err_ele ${grp}"
			setfacl -m g:${grp}:r-x ${REP}/*
			[ -d "${travail}" ] && setfacl -Rm g:${grp}:rwx ${travail}
			[ -d "${donnees}" ] && setfacl -Rm g:${grp}:r-x ${donnees}
			#ACLs par defaut
			getfacl --access --absolute-names  ${REP} | setfacl -d -R -M- ${REP}
			[ -d "${travail}" ] && getfacl --access --absolute-names  ${travail} | setfacl -d -R -M- ${travail}
			[ -d "${donnees}" ] && getfacl --access --absolute-names  ${donnees} | setfacl -d -R -M- ${donnees}
		else
			if [ "${grp:0:6}" == "profs-" ]
			then
				echo "Mise en place des ACLs pour le groupe profs : ${grp}"
				chown -R root:${grp} ${REP}
				chmod -R 700 ${REP}
				setfacl -bm g:${grp}:rwx ${REP}
				getfacl --access --absolute-names  ${REP} | setfacl -d -R -M- ${REP}
			else
				if [ "${grp}" != "professeurs" ]
				then
					echo "Mise en place des ACLs pour le groupe : ${grp}"
					setfacl -Rbk ${REP}
					chown -R root ${REP}
					chmod -R 700 ${REP}
					# si le groupe est inexistant => erreur
					setfacl -RPm g:${grp}:rwx ${REP}
					[ $? -ne 0 ] && err_group="$err_group ${grp}"
					#ACLs par defaut
					getfacl --access --absolute-names  ${REP} | setfacl -d -R -M- ${REP}
				fi
			fi
		fi
	fi
done

for classe in $liste_classe
do
    [ -n "$1" ] && [ "$1" != "$grp" ] && continue
	REP=/home/workgroups/${classe}
	REP_PR=/home/workgroups/profs-${classe}
	if [ -d "${REP}" ]
	then
		echo "Mise en place des ACLs pour la classe : ${classe}"
		donnees=${REP}/donnees
		travail=${REP}/travail
		setfacl -Rbk ${REP}
		chown -R root:${classe} ${REP}
		chmod -R 700 ${REP}
		chown -R root:profs-${classe} ${REP_PR}
		# si le groupe est inexistant => erreur
		setfacl -m g:profs-${classe}:r-x ${REP}
		[ $? -ne 0 ] && err_prof="$err_prof profs-${classe}"
		setfacl -m g:profs-${classe}:rwx ${REP}/*
		setfacl -m g:profs-${classe}:rwx ${REP_PR}
		[ -d "${travail}" ] && setfacl -Rm g:profs-${classe}:rwx ${travail}
		[ -d "${donnees}" ] && setfacl -Rm g:profs-${classe}:rwx ${donnees}
		# si le groupe est inexistant => erreur
		setfacl -m g:${classe}:r-x ${REP}
		[ $? -ne 0 ] && err_ele="$err_ele ${classe}"
		setfacl -m g:${classe}:r-x ${REP}/*
		[ -d "${travail}" ] && setfacl -Rm g:${classe}:rwx ${travail}
		[ -d "${donnees}" ] && setfacl -Rm g:${classe}:r-x ${donnees}
		#ACLs par defaut
		getfacl --access --absolute-names  ${REP} | setfacl -d -R -M- ${REP}
		getfacl --access --absolute-names  ${REP_PR} | setfacl -d -R -M- ${REP_PR}
		[ -d "${travail}" ] && getfacl --access --absolute-names  ${travail} | setfacl -d -R -M- ${travail}
		[ -d "${donnees}" ] && getfacl --access --absolute-names  ${donnees} | setfacl -d -R -M- ${donnees}
	fi
done

echo "Terminé"
[ "$err_group" != "" ] && echo "Erreur sur les groupes : $err_group"
[ "$err_prof" != "" ] && echo "Erreur sur les groupes : $err_prof"
[ "$err_ele" != "" ] && echo "Erreur sur les groupes : $err_ele"
setfacl -m g:professeurs:r-x /home/classes/
setfacl -m g:professeurs:r-x /home/classes/*
exit 0
