#!/bin/bash

####################################
# Programme permettant de regnrer
# les alias Exim pour les listes
# de diffusion Sympa
####################################

container_path_mail=$(CreoleGet container_path_mail)

etab=$(CreoleGet domaine_messagerie_etab)
fich="$container_path_mail/etc/mail/sympa/aliases"

CreoleService exim4 stop

echo "sympa: \"|/usr/lib/sympa/bin/queue sympa\"" > $fich

# gnration des listes externes
for j in $(ls $container_path_mail/var/lib/sympa/expl | grep -v i-$etab)
do
	echo "$etab-$j: \"|/usr/lib/sympa/bin/queue $j@$etab\"" >> $fich
	echo "$etab-$j-request: \"|/usr/lib/sympa/bin/queue $j-request@$etab\"" >> $fich
	echo "$etab-$j-editor: \"|/usr/lib/sympa/bin/queue $j-editor@$etab\"" >> $fich
	echo "$etab-$j-owner: \"|/usr/lib/sympa/bin/bouncequeue $j@$etab\"" >> $fich
done

# gnration des listes internes
for j in $(ls $container_path_mail/var/lib/sympa/expl/i-$etab)
do
	echo "i-$etab-$j: \"|/usr/lib/sympa/bin/queue $j@i-$etab\"" >> $fich
	echo "i-$etab-$j-request: \"|/usr/lib/sympa/bin/queue $j-request@i-$etab\"" >> $fich
	echo "i-$etab-$j-editor: \"|/usr/lib/sympa/bin/queue $j-editor@i-$etab\"" >> $fich
	echo "i-$etab-$j-owner: \"|/usr/lib/sympa/bin/bouncequeue $j@i-$etab\"" >> $fich
done
CreoleService exim4 start

# on force la regnration des inscrits
rm -f "$container_path_mail/var/lib/sympa/expl/*/subscribers.db"
rm -f "$container_path_mail/var/lib/sympa/expl/*/*/subscribers.db"

