#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
script pour ajouter un professeur sur Scribe
"""

import sys
import getopt
from scribe.enseignants import Enseignant
from scribe.errors import MissingUserCreateKey, LdapExistingUser
from scribe.eoletools import is_empty

def main():
    """
    boucle principale
    """
    try:
        options, args = getopt.getopt(sys.argv[1:],
            'u:c:m:p:f:d:M:w:x:z:q:G:e:P:t:sh',
            ['user=',
             'classe=',
             'mdp=',
             'prenom=',
             'fnom=',
             'sexe=',
             'date_naiss=',
             'mail=',
             'quota=',
             'droits=',
             'groupes=',
             'etab='
             'profil=',
             'temporary=',
             'shell',
             'help'])

    except getopt.GetoptError:
        er_type, er_value, er_traceback = sys.exc_info()
        er_msg = str(er_value)
        sys.exit("l'option -%s est inconnue ou nécessite un argument" % er_msg[er_msg.index('-')+1])

    prof = {}
    for (opt, val) in options:
        # login de l'enseignant
        if (opt == '-u') or (opt == '--user'):
            prof['login'] = val
        # classe
        elif (opt == '-c') or (opt == '--classe'):
            prof['classe'] = val
        # mot de passe
        elif (opt == '-m') or (opt == '--mdp'):
            prof['password'] = val
        # prénom
        elif (opt == '-p') or (opt == '--prenom'):
            prof['prenom'] = val
        # nom (de famille)
        elif (opt == '-f') or (opt == '--fnom'):
            prof['nom'] = val
        # sexe 1/2/3
        elif (opt == '-x') or (opt == '--sexe'):
            prof['civilite'] = val
        # date de naissance
        elif (opt == '-d') or (opt == '--date_naiss'):
            prof['date'] = val
        # mail
        elif (opt == '-M') or (opt == '--mail'):
            prof['mail'] = val
        # niveau de droits
        elif (opt == '-z') or (opt == '--droits'):
            if val == '1':
                prof['admin'] = True
        # groupes
        elif (opt == '-G') or (opt == '--groupes'):
            prof['groups'] = val.split(',')

        elif (opt == '-e') or (opt == '--etab'):
            prof['etab'] = val
        # quota
        elif (opt == '-q') or (opt == '--quota'):
            prof['quota'] = val
        # profil
        elif (opt == '-P') or (opt == '--profil'):
            prof['profil'] = val
        # shell
        elif (opt == '-s') or (opt == '--shell'):
            prof['shell'] = True
        # shell
        elif (opt == '-t') or (opt == '--temporary'):
            prof['temporary'] = val


        # et... l'aide
        elif (opt == '-h') or (opt == '--help'):
            sys.exit("""options :
                -u login prof
                -m mot de passe
                -p prenom
                -f nom de famille
                [-d date de naissance (jj/mm/aaaa)]
                [-c classe (classe administrée)]
                [-x civilité (1=M., 2=Mme, 3=Mlle)]
                [-M adresse mail ou mot clé "internet/restreint/aucun"]
                [-z niveau de droits (1 pour admin)]
                [-G groupe1,groupe2]
                [-q quota]
                [-e établissement]
                [-P profil (1=local, 2=obligatoire-1, 3=obligatoire-2, 4=itinérant)]
                [-s activation du shell]
                [-t nombre de jours d'activation]
                -h (aide)
                """)

    if is_empty(prof, 'date'):
        # date de naissance bidon si nécessaire
        prof['date'] = '01/01/0000'
    if is_empty(prof, 'civilite'):
        # mec si nécessaire
        prof['civilite'] = '1'

    ldapprof = Enseignant()
    ldapprof.ldap_admin.connect()

    for grp in prof.get('groups', []):
        if not ldapprof._is_group(grp):
            print("Erreur : le groupe %s n'existe pas" % grp)
            sys.exit(1)
    try:
        ldapprof._add(**prof)
        ldapprof.ldap_admin.close()
    except MissingUserCreateKey as msg:
        print("Erreur : Il manque un argument obligatoire (%s)" % msg)
        sys.exit(1)
    except LdapExistingUser:
        print("Erreur : Le login %(login)s n'est pas disponible" % prof)
        sys.exit(1)
    except Exception as msg:
        print("Erreur : %s" % str(msg))
        sys.exit(1)

    print("L'utilisateur %(login)s (%(prenom)s %(nom)s) a été ajouté" % prof)
    sys.exit(0)

if __name__ == "__main__":
    main()
