# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# templates python pour le backend ScribeNg
#
###########################################################################

# template de configuration d'une liste Sympa
tmpl = """
ttl 7200

subscribe open_notify

update
date_epoch 998698638
email %(email)s

send public

review owner


archive
web_access private
mail_access default

digest 1,4 12:0

subject liste %(type)s %(groupe)s

serial 2

creation
date obsoleted
email %(email)s
date_epoch 998698638

user_data_source include


unsubscribe open_notify

visibility noconceal

status open

topics %(type)s


"""

# template sympa pour les groupes Eole
liste_tmpl = tmpl + """
include_ldap_2level_query
suffix2 %(racine)s
port 389
filter1 (objectClass=posixGroup)
select1 all
timeout2 30
host %(host)s
timeout1 30
suffix1 %(branche)s
ca_verify required
filter2 (uid=[attrs1])
ssl_ciphers ALL
select2 first
scope2 sub
use_tls none
attrs2 mail
ssl_version tlsv1
attrs1 memberUid
scope1 base
"""

# template sympa pour les responsables Eole
resp_list_tmpl = tmpl + """
include_ldap_2level_query
suffix2 %(branche)s
port 389
filter1 (&(objectClass=eleves)(Divcod=%(groupe)s))
select1 all
timeout2 30
host %(host)s
timeout1 30
suffix1 %(branche)s
ca_verify required
filter2 (&(objectClass=responsable)(eleve=[attrs1]))
ssl_ciphers ALL
user cn=reader,o=gouv,c=fr
passwd %(pwd)s
select2 all
scope2 sub
use_tls none
attrs2 mail
ssl_version tlsv1
attrs1 uid
scope1 sub
"""

creation_list_xml = """<?xml version="1.0" ?>
<list>
    <type>discussion_list</type>
    <listname>%(groupe)s</listname>
    <subject>liste %(type)s %(groupe)s</subject>
    <description/>
    <status>open</status>
    <shared_edit>editor</shared_edit>
    <shared_read>private</shared_read>
    <language>fr</language>
    <owner multiple="1">
        <email>%(email)s</email>
    </owner>
    <topic>%(type)s</topic>
    <editor multiple="1">
        <email>%(email)s</email>
    </editor>
</list>
"""

# alias mail pour une liste Sympa
alias_tmpl =  """%(ldomaine)s-%(groupe)s: \"|/usr/lib/sympa/bin/queue %(groupe)s@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-request: \"|/usr/lib/sympa/bin/queue %(groupe)s-request@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-editor: \"|/usr/lib/sympa/bin/queue %(groupe)s-editor@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-owner: \"|/usr/lib/sympa/bin/bouncequeue %(groupe)s@%(ldomaine)s\"
"""

