#!/bin/bash

. /usr/lib/eole/ihm.sh
container_path_mail=$(CreoleGet container_path_mail)
container_path_annuaire=$(CreoleGet container_path_annuaire)
old=$1
new=$2
if [ "$old" == "" -o "$new" == "" ];then
	echo -e "\nScript de migration du nom de domaine de l'établissement\n"
	echo -e "usage : $0 anciendomaine nouveaudomaine\n"
	exit 1
fi
Question_ouinon "Migrer de $1 vers $2"
if [ $? -ne 0 ];then
	echo "Abandon"
	exit 1
fi
symparoot="$container_path_mail/var/lib/sympa/expl"
oldsympa="$symparoot/i-$old"
newsympa="$symparoot/i-$new"
oldetc="$container_path_mail/etc/sympa/i-$old"
newetc="$container_path_mail/etc/sympa/i-$new"
ldif="/root/annuaire-`date +%Y%m%d`.ldif"
ldif2="/root/annuaire-`date +%Y%m%d`-2.ldif"
# vérifications préalables...
if [ ! -d $oldsympa ];then
	echo "Erreur : le répertoire $oldsympa n'existe pas !"
	exit 1
fi
if [ ! -d $oldetc ];then
	echo "Erreur : le répertoire $oldetc n'existe pas !"
	exit 1
fi
if [ -d $newsympa ];then
	echo "Erreur : le répertoire $newsympa existe déjà !"
	exit 1
fi
if [ -f $ldif ];then
	echo "Erreur : Le fichier $ldif existe déjà !"
	exit 1
fi
echo "# Sauvegarde de l'annuaire dans $ldif..."
CreoleService -c annuaire slapd stop
CreoleRun "slapcat -v -f /etc/ldap/slapd.conf" annuaire > $ldif
cp -f $ldif $container_path_annuaire/$ldif2
echo "# Modification de l'annuaire..."
sed -i "s/$old/$new/g" $container_path_annuaire/$ldif2

rm -f $container_path_annuaire/var/lib/ldap/*.*
CreoleRun "/usr/sbin/slapadd -f /etc/ldap/slapd.conf -l $ldif2" annuaire
CreoleRun "chown openldap:openldap /var/lib/ldap/*.*" annuaire
CreoleService -c annuaire slapd start
rm -f $container_path_annuaire/$ldif2
echo "# Migration des configurations sympa..."
mv $oldetc $newetc
mv $oldsympa $newsympa
for confsympa in `find $symparoot -name config`;do
	sed -i "s/$old/$new/g" $confsympa
done
echo "# Migration des alias Exim4..."
sed -i "s/$old/$new/g" $container_path_mail/etc/mail/sympa/aliases
sed -i "s/$old/$new/g" $container_path_mail/etc/aliases
echo -e "\nMigration terminée : modifiez la variable \"Nom de domaine de la messagerie\""
echo -e "puis lancez la commande *reconfigure*\n"
exit 0
