# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
 librairie pour le parsing des fichiers de données

 - parse_csv_eleves : parsing des fichiers CSV/Scribe élèves
 - parse_csv_profs  : parsing des fichiers CSV/Scribe enseignants

"""
from csv import reader
from scribe.eoletools import convert_file, replace_cars, replace_more_cars
from scribe.importation import log
from scribe.importation.config import DEBUG_NUM
from scribe.storage import Eleve, Niveau, Classe, Enseignant


##########################################
# Extraction CSV Elèves
# Fichier :
# - eleves.csv
##########################################
def parse_csv_eleves(storage, csvfile):
    """
    parsing des élèves
    définition du fichier :
     0. numéro élève
     1. nom
     2. prénom
     3. sexe
     4. date de naissance
     5. niveau
     6. classe
    (7) login forcé
    (8) mot de passe forcé
    """
    num = 0
    log.infolog("Lecture des élèves...", title=True)
    # fichier en UTF-8 ?
    convert_file(csvfile)
    csvreader = reader(open(csvfile), delimiter=';')
    for data in csvreader:
        if len(data) < 7:
            # trop court
            log.infolog("ligne %s invalide" % str(data))
            continue
        eleve = {}
        eleve['numero'] = unicode(data[0])
        eleve['int_id'] = u''
        eleve['nom'] = unicode(replace_more_cars(data[1]))
        eleve['prenom'] = unicode(replace_more_cars(data[2]))
        if data[3] == 'F':
            eleve['civilite'] = u'3' #Mlle
        else:
            eleve['civilite'] = u'1' #M.
        #FIXME : normalement la date est au format jj/mm/aaaa
        eleve['date'] = unicode(data[4])
        if len(data) >= 8:
            eleve['force_login'] = unicode(data[7])
            if len(data) >= 9:
                eleve['force_password'] = unicode(data[8])
        try:
            niveau = unicode(replace_cars(data[5]))
            if not niveau:
                raise TypeError("niveau invalide")
            classe = unicode(replace_cars(data[6]))
            if not classe:
                raise TypeError("classe invalide")
            my_eleve = Eleve(store=storage, **eleve)
            my_niveau = storage.findOrCreate(Niveau, nom=niveau)
            my_classe = storage.findOrCreate(Classe, nom=classe,
                                             niveau=my_niveau)
            # affectation de l'élève
            my_eleve.classe = my_classe
            my_eleve.niveau = my_niveau
            num += 1
            if num % DEBUG_NUM == 0:
                log.debuglog("%d élèves lus..." % num)
        except TypeError, msg:
            log.errorlog("Erreur sur l'élève %s : %s" % (data[0], msg))
    log.infolog("TOTAL : %d élèves" % num)


##########################################
# Extraction CSV Enseignants
# Fichier :
# - enseignants.csv
##########################################
def parse_csv_profs(storage, csvfile):
    """
    parsing des enseignants
    définition du fichier :
     0. numéro prof
     1. nom
     2. prénom
     3. sexe
     4. date de naissance
    (5) login forcé
    (6) mot de passe forcé
    """
    num = 0
    log.infolog("Lecture des enseignants...", title=True)
    # fichier en UTF-8 ?
    convert_file(csvfile)
    csvreader = reader(open(csvfile), delimiter=';')
    for data in csvreader:
        if len(data) < 5:
            # trop court
            log.infolog("ligne %s invalide" % str(data))
            continue
        professeur = {'int_id':u''}
        professeur['nom'] = unicode(replace_more_cars(data[1]))
        professeur['prenom'] = unicode(replace_more_cars(data[2]))
        # FIXME : quel format ?
        if data[3] == 'F':
            professeur['civilite'] = u'2' #Mme
        else:
            professeur['civilite'] = u'1' #M.
        #FIXME : normalement la date est au format jj/mm/aaaa
        professeur['date'] = unicode(data[4])
        if len(data) >= 6:
            professeur['force_login'] = unicode(data[5])
            if len(data) >= 7:
                professeur['force_password'] = unicode(data[6])
        try:
            Enseignant(store=storage, **professeur)
            num += 1
        except Exception, msg:
            log.infolog("Erreur sur l'enseigant %s : %s" % (data[0], msg))
        if num % DEBUG_NUM == 0:
            log.debuglog("%d personnels lus..." % num)
    log.infolog("TOTAL : %d personnels" % num)

