# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# templates python pour le backend ScribeNg
#
###########################################################################

# template de configuration d'une liste Sympa
tmpl = """
ttl 7200

subscribe closed

update
date_epoch 998698638
email %(email)s

send %(list_type)s

review owner


archive
web_access private
mail_access default

digest 1,4 12:0

subject liste %(type)s %(groupe)s

serial 2

creation
date obsoleted
email %(email)s
date_epoch 998698638

user_data_source include


unsubscribe closed
invite closed

visibility noconceal

status open

topics %(type)s

%(moderation)s

"""

# templates sympa pour la modération
tmpl_modo = "editor_include\nsource ldap-%(moderateur)s\n"

tmpl_modo_request = """
include_ldap_2level_query
scope2 sub
suffix2 %(racine)s
select2 first
ca_verify none
attrs1 memberUid
timeout1 30
filter1 (objectClass=posixGroup)
host 127.0.0.1
suffix1 %(modo_branche)s
select1 all
port 389
ssl_ciphers ALL
attrs2 mail
use_tls none
filter2 (uid=[attrs1])
ssl_version tlsv1_3
timeout2 30
scope1 base
"""
# template sympa pour les groupes Eole
_liste_tmpl = tmpl + """
include_ldap_2level_query
port 389
filter1 (objectClass=posixGroup)
select1 all
timeout2 30
host %(host)s
timeout1 30
suffix1 %(branche)s
ca_verify none
ssl_ciphers ALL
select2 first
scope2 sub
attrs2 mail
ssl_version tlsv1_3
scope1 base"""

liste_tmpl = _liste_tmpl + """
suffix2 %(racine)s
filter2 (uid=[attrs1])
attrs1 memberUid
use_tls none
"""

liste_tmpl_ad = _liste_tmpl + """
suffix2 [attrs1]
filter2 (objectClass=person)
attrs1 member
use_tls starttls
user %(bind_dn)s
passwd %(bind_password)s
"""

# template sympa pour les responsables Eole
_resp_list_tmpl = tmpl + """
include_ldap_2level_query
port 389
filter1 (&(objectClass=eleves)(Divcod=%(groupe)s))
select1 all
timeout2 30
host %(host)s
timeout1 30
suffix1 %(branche)s
ca_verify none
filter2 (&(objectClass=responsable)(eleve=[attrs1]))
ssl_ciphers ALL
user cn=reader,o=gouv,c=fr
passwd %(pwd)s
select2 all
scope2 sub
attrs2 mail
ssl_version tlsv1_3
attrs1 uid
scope1 sub"""

resp_list_tmpl = _resp_list_tmpl + """
suffix2 %(branche)s
use_tls none
"""
resp_list_tmpl_ad = _resp_list_tmpl + """
suffix2 [attrs1]
use_tls starttls
user %(bind_dn)s
passwd %(bind_password)s
"""

creation_list_xml = """<?xml version="1.0" ?>
<list>
    <type>discussion_list</type>
    <listname>%(groupe)s</listname>
    <subject>liste %(type)s %(groupe)s</subject>
    <description/>
    <status>open</status>
    <shared_edit>editor</shared_edit>
    <shared_read>private</shared_read>
    <language>fr</language>
    <owner multiple="1">
        <email>%(email)s</email>
    </owner>
    <topic>%(type)s</topic>
    <editor multiple="1">
        <email>%(email)s</email>
    </editor>
</list>
"""

# alias mail pour une liste Sympa
alias_tmpl =  """%(ldomaine)s-%(groupe)s: \"|/usr/lib/sympa/bin/queue %(groupe)s@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-request: \"|/usr/lib/sympa/bin/queue %(groupe)s-request@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-editor: \"|/usr/lib/sympa/bin/queue %(groupe)s-editor@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-owner: \"|/usr/lib/sympa/bin/bouncequeue %(groupe)s@%(ldomaine)s\"
"""

