from creole.client import CreoleClient
from pyeole.process import system_code
from creole.loader import creole_loader, config_save_values
from time import sleep


client = CreoleClient()

def test_dhcp():
    if client.get_creole('activer_dhcp') == 'non':
        return
    assert system_code(["pgrep", "-u", "dhcpd", "dhcpd"], container='dhcp') == 0
    config = creole_loader(rw=True, owner='test')
    del config.creole.dhcp.global_domain_wpad_dhcp
    config_save_values(config, 'creole')
    assert system_code(['CreoleCat', '-t', 'dhcpd.conf']) == 0
    assert system_code(['CreoleService', 'isc-dhcp-server', 'restart']) == 0
    sleep(2)
    assert system_code(["pgrep", "-u", "dhcpd", "dhcpd"], container="dhcp") == 0
