# -*- coding: utf-8 -*-

from py.test import raises

from pyeole import service

CONTAINER_ROOT = {'path': ''}
CONTAINER_TEST = {'path': '/path/container'}

def fake_raise(cmd):
    raise ValueError('you must set {0} function'.format(cmd))

#system_out
def fake_system_out(cmd, container, pty=False, env=None):
    global FAKE_SYS_OUT_CMD, FAKE_SYS_OUT_CONT, FAKE_SYS_OUT_ENV, \
                FAKE_SYS_OUT_PTY
    FAKE_SYS_OUT_CMD.append(cmd)
    FAKE_SYS_OUT_CONT.append(container)
    FAKE_SYS_OUT_ENV.append(env)
    FAKE_SYS_OUT_PTY.append(pty)
    return 0, '', ''

def fake_system_out_err(cmd, container):
    fake_system_out(cmd, container)
    return 1, 'stdout', 'stderr'

def fake_system_out_raise(*args, **targs):
    fake_raise('system_out')

#creole_system_code
def fake_system_code(cmd, container='root', pty=False, env=None):
    global FAKE_SYS_CODE_CMD, FAKE_SYS_CODE_CONT, FAKE_SYS_CODE_ENV, \
            FAKE_SYS_CODE_PTY
    FAKE_SYS_CODE_CMD.append(cmd)
    FAKE_SYS_CODE_CONT.append(container)
    FAKE_SYS_CODE_ENV.append(env)
    FAKE_SYS_CODE_PTY.append(pty)
    return 0

def fake_system_code_err(cmd, container):
    fake_system_code(cmd, container)
    return 1

def fake_system_code_raise(*args):
    fake_raise('creole_system_code')

#glob
def fake_glob_init(filename):
    global FAKE_GLOB_FILENAME
    FAKE_GLOB_FILENAME.append(filename)
    if filename.endswith("/etc/rc2.d/S??test"):
        return ['/etc/rc2.d/S50test']
    elif filename.endswith("/etc/rc0.d/K??test"):
        return ['/etc/rc0.d/K50test']
    else:
        raise Exception('Unknown filename {}'.format(filename))

def fake_glob_init_empty(filename):
    global FAKE_GLOB_FILENAME
    FAKE_GLOB_FILENAME.append(filename)
    return []

def fake_glob_raise(*args):
    fake_raise('glob')

#isfile
def fake_isfile_true(filename):
    global FAKE_ISFILE_NAME
    FAKE_ISFILE_NAME.append(filename)
    return True

def fake_isfile_false(filename):
    global FAKE_ISFILE_NAME
    FAKE_ISFILE_NAME.append(filename)
    return False

def fake_isfile_raise(*args):
    fake_raise('isfile')

#move
def fake_move(filename, destfilename):
    global FAKE_MOVE_NAME
    FAKE_MOVE_NAME.append((filename, destfilename))
    return False

def fake_move_raise(*args):
    fake_raise('move')

#unlink
def fake_unlink(filename):
    global FAKE_UNLINK_NAME
    FAKE_UNLINK_NAME.append(filename)
    return False

def fake_unlink_raise(*args):
    fake_raise('unlink')

def fake_open_raise(*args):
    fake_raise('open')

class fake_open_upstart_tic():
    def __init__(self, name, mode):
        global FAKE_OPEN_FILENAME
        FAKE_OPEN_FILENAME.append(name)
    def readlines(self):
        return 'description: fake'
    def write(self, text):
        global FAKE_OPENT_TEXT
        FAKE_OPENT_TEXT.append(text)
    def close(self):
        pass

def setup_function(function):
    global FAKE_SYS_OUT_CMD, FAKE_SYS_OUT_CONT, FAKE_GLOB_FILENAME, \
            FAKE_ISFILE_NAME, FAKE_MOVE_NAME, FAKE_UNLINK_NAME, \
            FAKE_SYS_CODE_CMD, FAKE_SYS_CODE_CONT, FAKE_SYS_CODE_ENV, \
            FAKE_SYS_CODE_PTY, FAKE_OPEN_FILENAME, FAKE_SYS_OUT_ENV, \
            FAKE_SYS_OUT_PTY, FAKE_OPENT_TEXT
    FAKE_OPENT_TEXT = []
    FAKE_OPEN_FILENAME = []
    FAKE_SYS_OUT_CMD = []
    FAKE_SYS_OUT_CONT = []
    FAKE_SYS_OUT_ENV = []
    FAKE_SYS_OUT_PTY = []
    FAKE_SYS_CODE_CMD = []
    FAKE_SYS_CODE_CONT = []
    FAKE_SYS_CODE_ENV = []
    FAKE_SYS_CODE_PTY = []
    FAKE_GLOB_FILENAME = []
    FAKE_ISFILE_NAME = []
    FAKE_MOVE_NAME= []
    FAKE_UNLINK_NAME= []
    service.glob = fake_glob_raise
    service.system_out = fake_system_out_raise
    service.creole_system_out = fake_system_out_raise
    service.creole_system_code = fake_system_code_raise
    service.isfile = fake_isfile_raise
    service.move = fake_move_raise
    service.unlink = fake_unlink_raise
    service.open = fake_open_raise

##################################################
# creole_service_out
##################################################

def test_creole_service_out_start_service():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'service',
                        'container': 'root'}
    tcontainer = {'name': 'root', 'path': ''}
    service.creole_service_out(tservice, 'start', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_start_upstart():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
                        'container': 'root'}
    tcontainer = {'name': 'root', 'path': ''}
    service.creole_service_out(tservice, 'start', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/sbin/start', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_start_apache():
    tservice = {'name': 'test', 'method': 'apache',
                        'container': 'root'}
    tcontainer = {'name': 'root', 'path': ''}
    service.creole_service_out(tservice, 'start', tcontainer)

def test_creole_service_out_stop_service():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'service',
                        'container': 'root'}
    tcontainer = {'name': 'root', 'path': ''}
    service.creole_service_out(tservice, 'stop', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'stop']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_stop_upstart():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
                        'container': 'root'}
    tcontainer = {'name': 'root', 'path': ''}
    service.creole_service_out(tservice, 'stop', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/sbin/stop', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_restart_service():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'service',
                        'container': 'root'}
    tcontainer = {'name': 'root', 'path': ''}
    service.creole_service_out(tservice, 'restart', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'stop'],
            ['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_OUT_CONT == [tcontainer, tcontainer]

def test_creole_service_out_restart_upstart():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
                        'container': 'root'}
    tcontainer = {'name': 'root', 'path': ''}
    service.creole_service_out(tservice, 'restart', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/sbin/restart', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_start_service_container():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'service',
                        'container': 'container'}
    tcontainer = {'name': 'container', 'path': '/path/container'}
    service.creole_service_out(tservice, 'start', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_start_upstart_container():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
                        'container': 'container'}
    tcontainer = {'name': 'container', 'path': '/path/container'}
    service.creole_service_out(tservice, 'start', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/sbin/start', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_start_apache_container():
    tservice = {'name': 'test', 'method': 'apache',
                        'container': 'container'}
    tcontainer = {'name': 'container', 'path': '/path/container'}
    service.creole_service_out(tservice, 'start', tcontainer)

def test_creole_service_out_stop_service_container():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'service',
                        'container': 'container'}
    tcontainer = {'name': 'container', 'path': '/path/container'}
    service.creole_service_out(tservice, 'stop', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'stop']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_stop_upstart_container():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
                        'container': 'container'}
    tcontainer = {'name': 'container', 'path': '/path/container'}
    service.creole_service_out(tservice, 'stop', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/sbin/stop', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

def test_creole_service_out_restart_service_container():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'service',
                        'container': 'container'}
    tcontainer = {'name': 'container', 'path': '/path/container'}
    service.creole_service_out(tservice, 'restart', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'stop'],
            ['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_OUT_CONT == [tcontainer, tcontainer]

def test_creole_service_out_restart_upstart_container():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
                        'container': 'container'}
    tcontainer = {'name': 'container', 'path': '/path/container'}
    service.creole_service_out(tservice, 'restart', tcontainer)
    assert FAKE_SYS_OUT_CMD == [['/sbin/restart', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]

##################################################
# creole_service_code
##################################################

def test_creole_service_code_start_service():
    service.creole_system_code = fake_system_code
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'pty': False}
    tcontainer = {'path': ''}
    service.creole_service_code(tservice, 'start', tcontainer)
    assert FAKE_SYS_CODE_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_CODE_CONT == [tcontainer]
    assert FAKE_SYS_CODE_ENV == [None]
    assert FAKE_SYS_CODE_PTY == [False]

def test_creole_service_code_start_upstart():
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'root', 'pty': False}
    tcontainer = {'path': ''}
    service.isfile = fake_isfile_upstart_activate
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'start', tcontainer)
    assert FAKE_OPEN_FILENAME == ['/etc/init/test.conf']
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf']
    assert FAKE_SYS_OUT_CMD == [['/sbin/start', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]
    assert FAKE_SYS_OUT_ENV == [None]
    assert FAKE_SYS_OUT_PTY == [False]

def test_creole_service_code_start_apache():
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'root', 'pty': False}
    tcontainer = {'path': ''}
    service.creole_service_code(tservice, 'start', tcontainer)

def test_creole_service_code_stop_service():
    service.creole_system_code = fake_system_code
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'pty': False}
    tcontainer = {'path': ''}
    service.creole_service_code(tservice, 'stop', tcontainer)
    assert FAKE_SYS_CODE_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'stop']]
    assert FAKE_SYS_CODE_CONT == [tcontainer]
    assert FAKE_SYS_CODE_ENV == [None]
    assert FAKE_SYS_CODE_PTY == [False]

def test_creole_service_code_stop_upstart():
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'root', 'pty': False}
    tcontainer = {'path': ''}
    service.isfile = fake_isfile_upstart_activate
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'stop', tcontainer)
    assert FAKE_OPEN_FILENAME == ['/etc/init/test.conf']
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf']
    assert FAKE_SYS_OUT_CMD == [['/sbin/stop', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]
    assert FAKE_SYS_OUT_ENV == [None]
    assert FAKE_SYS_OUT_PTY == [False]

def test_creole_service_code_restart_service():
    service.creole_system_code = fake_system_code
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'pty': False}
    tcontainer = {'path': ''}
    service.creole_service_code(tservice, 'restart', tcontainer)
    assert FAKE_SYS_CODE_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'stop'],
            ['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_CODE_CONT == [tcontainer, tcontainer]
    assert FAKE_SYS_CODE_ENV == [None, None]
    assert FAKE_SYS_CODE_PTY == [False, False]

def test_creole_service_code_restart_upstart():
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'root', 'pty': False}
    tcontainer = {'path': ''}
    service.isfile = fake_isfile_upstart_activate
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'restart', tcontainer)
    assert FAKE_OPEN_FILENAME == ['/etc/init/test.conf']
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf']
    assert FAKE_SYS_OUT_CMD == [['/sbin/status', 'test'],
            ['/sbin/restart', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer, tcontainer]
    assert FAKE_SYS_OUT_ENV == [None, None]
    assert FAKE_SYS_OUT_PTY == [False, False]

def test_creole_service_code_start_service_container():
    service.creole_system_code = fake_system_code
    tservice = {'name': 'test', 'method': 'service',
            'container': 'container', 'pty': False}
    tcontainer = {'path': '/path/container'}
    service.creole_service_code(tservice, 'start', tcontainer)
    assert FAKE_SYS_CODE_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_CODE_CONT == [tcontainer]
    assert FAKE_SYS_CODE_ENV == [None]
    assert FAKE_SYS_CODE_PTY == [False]

def test_creole_service_code_start_upstart_container():
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'container', 'pty': False}
    tcontainer = {'path': '/path/container'}
    service.isfile = fake_isfile_upstart_activate
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'start', tcontainer)
    assert FAKE_OPEN_FILENAME == ['/path/container/etc/init/test.conf']
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf']
    assert FAKE_SYS_OUT_CMD == [['/sbin/start', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]
    assert FAKE_SYS_OUT_ENV == [None]
    assert FAKE_SYS_OUT_PTY == [False]

def test_creole_service_code_start_apache_container():
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'container', 'pty': False}
    tcontainer = {'path': '/path/container'}
    service.creole_service_code(tservice, 'start', tcontainer)

def test_creole_service_code_stop_service_container():
    service.creole_system_code = fake_system_code
    tservice = {'name': 'test', 'method': 'service',
            'container': 'container', 'pty': False}
    tcontainer = {'path': '/path/container'}
    service.creole_service_code(tservice, 'stop', tcontainer)
    assert FAKE_SYS_CODE_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'stop']]
    assert FAKE_SYS_CODE_CONT == [tcontainer]
    assert FAKE_SYS_CODE_ENV == [None]
    assert FAKE_SYS_CODE_PTY == [False]

def test_creole_service_code_stop_upstart_container():
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'container', 'pty': False}
    tcontainer = {'path': '/path/container'}
    service.isfile = fake_isfile_upstart_activate
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'stop', tcontainer)
    assert FAKE_OPEN_FILENAME == ['/path/container/etc/init/test.conf']
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf']
    assert FAKE_SYS_OUT_CMD == [['/sbin/stop', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]
    assert FAKE_SYS_OUT_ENV == [None]
    assert FAKE_SYS_OUT_PTY == [False]

def test_creole_service_code_restart_service_container():
    service.creole_system_code = fake_system_code
    tservice = {'name': 'test', 'method': 'service',
            'container': 'container', 'pty': False}
    tcontainer = {'path': '/path/container'}
    service.creole_service_code(tservice, 'restart', tcontainer)
    assert FAKE_SYS_CODE_CMD == [['/usr/sbin/invoke-rc.d', 'test', 'stop'],
            ['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_CODE_CONT == [tcontainer, tcontainer]
    assert FAKE_SYS_CODE_ENV == [None, None]
    assert FAKE_SYS_CODE_PTY == [False, False]

def test_creole_service_code_restart_upstart_container():
    service.creole_system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'container', 'pty': False}
    tcontainer = {'path': '/path/container'}
    service.isfile = fake_isfile_upstart_activate
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'restart', tcontainer)
    assert FAKE_OPEN_FILENAME == ['/path/container/etc/init/test.conf']
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf']
    assert FAKE_SYS_OUT_CMD == [['/sbin/status', 'test'],
            ['/sbin/restart', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer, tcontainer]
    assert FAKE_SYS_OUT_ENV == [None, None]
    assert FAKE_SYS_OUT_PTY == [False, False]

##################################################
# creole_service_code avec pty
##################################################

def test_creole_service_code_pty_start_service():
    service.unlink = fake_unlink
    service.creole_system_code = fake_system_code
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'pty': True}
    tcontainer = {'path': ''}
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'start', tcontainer)
    assert FAKE_SYS_CODE_CMD == [
            ['/usr/bin/tic', '-o', '/etc/terminfo/', '/tmp/eole.ti'],
            ['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_CODE_CONT == ['root', tcontainer]
    assert FAKE_SYS_CODE_ENV == [None, {'TERM': 'eole'}]
    assert FAKE_SYS_CODE_PTY == [False, True]
    assert FAKE_UNLINK_NAME == ['/tmp/eole.ti']

def test_creole_service_code_pty_start_upstart():
    service.unlink = fake_unlink
    service.creole_system_out = fake_system_out
    service.creole_system_code = fake_system_code
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'root', 'pty': True}
    tcontainer = {'path': ''}
    service.isfile = fake_isfile_upstart_activate
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'start', tcontainer)
    assert FAKE_OPEN_FILENAME == ['/tmp/eole.ti', '/etc/init/test.conf']
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf']
    assert FAKE_SYS_CODE_CMD == [
            ['/usr/bin/tic', '-o', '/etc/terminfo/', '/tmp/eole.ti']]
    assert FAKE_SYS_OUT_CMD == [['/sbin/start', 'test']]
    assert FAKE_SYS_CODE_CONT == ['root']
    assert FAKE_SYS_CODE_ENV == [None]
    assert FAKE_SYS_CODE_PTY == [False]
    assert FAKE_SYS_OUT_CONT == [tcontainer]
    assert FAKE_SYS_OUT_ENV == [{'TERM': 'eole'}]
    assert FAKE_SYS_OUT_PTY == [True]
    assert FAKE_UNLINK_NAME == ['/tmp/eole.ti']

def test_creole_service_code_pty_start_apache():
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'root', 'pty': True}
    tcontainer = {'path': ''}
    service.creole_service_code(tservice, 'start', tcontainer)

def test_creole_service_code_pty_start_service_container():
    service.unlink = fake_unlink
    service.creole_system_code = fake_system_code
    service.open = fake_open_upstart_tic
    tservice = {'name': 'test', 'method': 'service',
            'container': 'container', 'pty': True}
    tcontainer = {'path': '/path/container'}
    service.creole_service_code(tservice, 'start', tcontainer)
    assert FAKE_SYS_CODE_CMD == [['/usr/bin/tic', '-o', '/path/container/etc/terminfo/', '/tmp/eole.ti'],
            ['/usr/sbin/invoke-rc.d', 'test', 'start']]
    assert FAKE_SYS_CODE_CONT == ['root', tcontainer]
    assert FAKE_SYS_CODE_ENV == [None, {'TERM': 'eole'}]
    assert FAKE_SYS_CODE_PTY == [False, True]
    assert FAKE_UNLINK_NAME == ['/tmp/eole.ti']

def test_creole_service_code_pty_start_upstart_container():
    service.unlink = fake_unlink
    service.creole_system_code = fake_system_code
    service.creole_system_out = fake_system_out
    service.isfile = fake_isfile_upstart_activate
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'container', 'pty': True}
    tcontainer = {'path': '/path/container'}
    service.isfile = fake_isfile_upstart_activate
    service.open = fake_open_upstart_tic
    service.creole_service_code(tservice, 'start', tcontainer)
    assert FAKE_OPEN_FILENAME == ['/tmp/eole.ti',
            '/path/container/etc/init/test.conf']
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf']
    assert FAKE_SYS_CODE_CMD == [
            ['/usr/bin/tic', '-o', '/path/container/etc/terminfo/',
                '/tmp/eole.ti']]
    assert FAKE_SYS_CODE_CONT == ['root']
    assert FAKE_SYS_CODE_ENV == [None]
    assert FAKE_SYS_CODE_PTY == [False]
    assert FAKE_SYS_OUT_CMD == [['/sbin/start', 'test']]
    assert FAKE_SYS_OUT_CONT == [tcontainer]
    assert FAKE_SYS_OUT_ENV == [{'TERM': 'eole'}]
    assert FAKE_SYS_OUT_PTY == [True]
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf']
    assert FAKE_UNLINK_NAME == ['/tmp/eole.ti']

def test_creole_service_code_pty_start_apache_container():
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'container', 'pty': True}
    tcontainer = {'path': '/path/container'}
    service.creole_service_code(tservice, 'start', tcontainer)

##############################################################################
##############################################################################
##############################################################################

##################################################
# _test_unsupport_level
##################################################

def test_unsupport_level():
    tservice = {'name': 'test', 'method': 'apache',
                        'container': 'root'}
    service._test_unsupport_level(tservice)

def test_unsupport_level_error():
    tservice = {'name': 'test', 'method': 'apache',
                        'container': 'root',
                        'startlevel': 1}
    raises(KeyError, "service._test_unsupport_level(tservice)")
    tservice = {'name': 'test', 'method': 'apache',
                        'container': 'root',
                        'stoplevel': 1}
    raises(KeyError, "service._test_unsupport_level(tservice)")
    tservice = {'name': 'test', 'method': 'apache',
                        'container': 'root',
                        'startlevel': 1,
                        'stoplevel': 1}
    raises(KeyError, "service._test_unsupport_level(tservice)")

##################################################
# _special_rcd
##################################################

def test_special_rcd_unknown():
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'unknown',
            'container': 'root'}
    raises(ValueError, "service._special_rcd(tservice, 'set')")

def test_special_rcd_action_unknown():
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'root'}
    raises(ValueError, "service._special_rcd(tservice, 'unknown')")

def test_special_rcd_unsupport_level():
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'root', 'stoplevel': 1}
    raises(KeyError, "service._special_rcd(tservice, 'set')")

def test_special_rcd_error():
    service.system_out = fake_system_out_err
    service.isfile = fake_isfile_upstart_activate
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'root'}
    raises(service.NotUpdate, "service._special_rcd(tservice, 'set')")

def test_special_rcd_space_name():
    service.system_out = fake_system_out
    tservice = {'name': 'test withspace', 'method': 'apache',
                        'container': 'root'}
    raises(ValueError, "service._special_rcd(tservice, 'set')")

def test_special_rcd_apache_set():
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'root'}
    service._special_rcd(tservice, 'set')
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/a2ensite', 'test']]
    assert FAKE_SYS_OUT_CONT == ['root']

def test_special_rcd_apache_set_container():
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'test'}
    service._special_rcd(tservice, 'set')
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/a2ensite', 'test']]
    assert FAKE_SYS_OUT_CONT == ['test']

def test_special_rcd_apache_remove():
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'root'}
    service._special_rcd(tservice, 'remove')
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/a2dissite', 'test']]
    assert FAKE_SYS_OUT_CONT == ['root']

def test_special_rcd_apache_remove_container():
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'test'}
    service._special_rcd(tservice, 'remove')
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/a2dissite', 'test']]
    assert FAKE_SYS_OUT_CONT == ['test']

def test_creole_update_rcd_apache():
    """
    test _special_rcd with creole_update_rcd
    """
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'root'}
    service._special_rcd(tservice, 'set')
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/a2ensite', 'test']]
    assert FAKE_SYS_OUT_CONT == ['root']

def test_creole_update_rcd_apache_container():
    service.system_out = fake_system_out
    tservice = {'name': 'test', 'method': 'apache',
            'container': 'test'}
    service._special_rcd(tservice, 'remove')
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/a2dissite', 'test']]
    assert FAKE_SYS_OUT_CONT == ['test']

##################################################
# _service_rcd
##################################################

def test_service_rcd_init_filename_start():
    container = CONTAINER_ROOT
    filename = service._service_rcd_init_filename('test', container) #, startlevel='??', action='start')
    assert filename == '/etc/rc2.d/S??test'

def test_service_rcd_init_filename_stop():
    container = CONTAINER_ROOT
    filename = service._service_rcd_init_filename('test', container, action='stop')
    assert filename == '/etc/rc0.d/K??test'

def test_service_rcd_init_filename_start_container():
    container = CONTAINER_TEST
    filename = service._service_rcd_init_filename('test', container)
    assert filename == '/path/container/etc/rc2.d/S??test'

def test_service_rcd_init_filename_stop_container():
    container = CONTAINER_TEST
    filename = service._service_rcd_init_filename('test', container, action='stop')
    assert filename == '/path/container/etc/rc0.d/K??test'

def test_service_rcd_init_filename_start_startlevel():
    container = CONTAINER_ROOT
    filename = service._service_rcd_init_filename('test', container, level='50')
    assert filename == '/etc/rc2.d/S50test'

def test_service_rcd_init_filename_stop_stoplevel():
    container = CONTAINER_ROOT
    filename = service._service_rcd_init_filename('test', container, level='50', action='stop')
    assert filename == '/etc/rc0.d/K50test'

################### fake_glob_init_empty
def test_init_rcd_set_empty():
    service.system_out = fake_system_out
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test']

def test_init_rcd_set_empty_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test'}
    container = CONTAINER_TEST
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test']

def test_init_rcd_set_empty_startlevel():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'startlevel': '1'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults', '1']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test']

def test_init_rcd_set_empty_startlevel_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test', 'startlevel': '1'}
    container = CONTAINER_TEST
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults', '1']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test']

def test_init_rcd_set_empty_stoplevel():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'startlevel': '1', 'stoplevel': '2'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults',
                                '1', '2']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test', '/etc/rc0.d/K??test']

def test_init_rcd_set_empty_stoplevel_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test', 'startlevel': '1', 'stoplevel': '2'}
    container = CONTAINER_TEST
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults',
                                '1', '2']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test', '/path/container/etc/rc0.d/K??test']

def test_init_rcd_set_empty_stoplevel_without_start():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'stoplevel': '2'}
    container = CONTAINER_ROOT
    raises (ValueError, "service._service_rcd(tservice, 'set', container)")

################### fake_glob_init
def test_init_rcd_set():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == []
    assert FAKE_SYS_OUT_CONT == []
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test']

def test_init_rcd_set_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test'}
    container = CONTAINER_TEST
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == []
    assert FAKE_SYS_OUT_CONT == []
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test']

def test_init_rcd_set_startlevel():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'startlevel': '1'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', '-f', 'test',
            'remove'], ['/usr/sbin/update-rc.d', 'test', 'defaults', '1']]
    assert FAKE_SYS_OUT_CONT == [container, container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test', '/etc/rc2.d/S??test']

def test_init_rcd_set_startlevel_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test', 'startlevel': '1'}
    container = CONTAINER_TEST
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', '-f', 'test',
            'remove'], ['/usr/sbin/update-rc.d', 'test', 'defaults', '1']]
    assert FAKE_SYS_OUT_CONT == [container, container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test',
            '/path/container/etc/rc2.d/S??test']

def test_init_rcd_set_startlevel_same_level():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'startlevel': '50'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == []
    assert FAKE_SYS_OUT_CONT == []
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test']

def test_init_rcd_set_stoplevel():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'startlevel': '50', 'stoplevel': '2'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', '-f', 'test',
                'remove'], ['/usr/sbin/update-rc.d', 'test', 'defaults',
                '50', '2']]
    assert FAKE_SYS_OUT_CONT == [container, container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test', '/etc/rc0.d/K??test', '/etc/rc2.d/S??test']

def test_init_rcd_set_startlevel_same_level():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'startlevel': '50', 'stoplevel': '50'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == []
    assert FAKE_SYS_OUT_CONT == []
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test', '/etc/rc0.d/K??test']

def test_init_rcd_set_stoplevel_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test', 'startlevel': '50', 'stoplevel': '2'}
    container = CONTAINER_TEST
    service._service_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', '-f', 'test',
                'remove'], ['/usr/sbin/update-rc.d', 'test', 'defaults',
                '50', '2']]
    assert FAKE_SYS_OUT_CONT == [container, container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test',
            '/path/container/etc/rc0.d/K??test',
            '/path/container/etc/rc2.d/S??test']

def test_init_rcd_remove():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root'}
    container = CONTAINER_ROOT
    service._service_rcd(tservice, 'remove', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', '-f', 'test', 'remove']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test']

def test_init_rcd_remove_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test'}
    container = CONTAINER_TEST
    service._service_rcd(tservice, 'remove', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', '-f', 'test', 'remove']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test']

############# creole_update_rcd
def test_creole_init_rcd_set_empty():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root'}
    container = CONTAINER_ROOT
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test']

def test_creole_init_rcd_set_empty_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test'}
    container = CONTAINER_TEST
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test']

def test_creole_init_rcd_set_empty_startlevel():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'startlevel': '1'}
    container = CONTAINER_ROOT
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults', '1']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test']

def test_creole_init_rcd_set_empty_startlevel_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test', 'startlevel': '1'}
    container = CONTAINER_TEST
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults', '1']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test']

def test_creole_init_rcd_set_empty_stoplevel():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'startlevel': '1', 'stoplevel': '2'}
    container = CONTAINER_ROOT
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults',
                                '1', '2']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test', '/etc/rc0.d/K??test']

def test_creole_init_rcd_set_empty_stoplevel_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test', 'startlevel': '1', 'stoplevel': '2'}
    container = CONTAINER_TEST
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults',
                                '1', '2']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test', '/path/container/etc/rc0.d/K??test']

def test_creole_init_rcd_set_empty_stoplevel_without_start():
    service.system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root', 'stoplevel': '2'}
    container = CONTAINER_ROOT
    raises (ValueError, "service.creole_update_rcd(tservice, 'set', container)")

def test_creole_init_rcd_set_empty():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'root'}
    container = CONTAINER_ROOT
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??test']

def test_creole_init_rcd_set_empty_container():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init_empty
    tservice = {'name': 'test', 'method': 'service',
            'container': 'test'}
    container = CONTAINER_TEST
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_SYS_OUT_CMD == [['/usr/sbin/update-rc.d', 'test', 'defaults']]
    assert FAKE_SYS_OUT_CONT == [container]
    assert FAKE_GLOB_FILENAME == ['/path/container/etc/rc2.d/S??test']

######### unknown
def test_init_rcd_set():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'unknown', 'method': 'service',
            'container': 'root'}
    container = CONTAINER_ROOT
    raises(Exception, "service._service_rcd(tservice, 'set', container)")
    assert FAKE_SYS_OUT_CMD == []
    assert FAKE_SYS_OUT_CONT == []
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??unknown']

def test_init_rcd_remove():
    service.creole_system_out = fake_system_out
    service.glob = fake_glob_init
    tservice = {'name': 'unknown', 'method': 'service',
            'container': 'root'}
    container = CONTAINER_ROOT
    raises(Exception, "service._service_rcd(tservice, 'remove', container)")
    assert FAKE_SYS_OUT_CMD == []
    assert FAKE_SYS_OUT_CONT == []
    assert FAKE_GLOB_FILENAME == ['/etc/rc2.d/S??unknown']

##################################################
# _upstart_rcd
##################################################

def fake_isfile_upstart_activate(filename):
    if filename.endswith('etc/init/test.conf'):
        return fake_isfile_true(filename)
    if filename.endswith('etc/init/test.noexec'):
        return fake_isfile_false(filename)
    raise ValueError('unknown filename {0}'.format(filename))

def fake_isfile_upstart_desactivate(filename):
    if filename.endswith('etc/init/test.conf'):
        return fake_isfile_false(filename)
    if filename.endswith('etc/init/test.noexec'):
        return fake_isfile_true(filename)
    raise ValueError('unknown filename {0}'.format(filename))

def fake_isfile_upstart_inconsistent(filename):
    if filename.endswith('etc/init/test.conf'):
        return fake_isfile_true(filename)
    if filename.endswith('etc/init/test.noexec'):
        return fake_isfile_true(filename)
    raise ValueError('unknown filename {0}'.format(filename))

def test_upstart_rcd_no_stop_start_level():
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'root', 'startlevel': '1', 'stoplevel': '2'}

    container = CONTAINER_ROOT
    raises(KeyError, "service._upstart_rcd(tservice, 'set', container)")

def test_upstart_rcd_set_activate():
    service.isfile = fake_isfile_upstart_activate
    service.unlink = fake_unlink
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service._upstart_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == []

def test_upstart_rcd_remove_activate():
    service.isfile = fake_isfile_upstart_activate
    service.unlink = fake_unlink
    service.move = fake_move
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service._upstart_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == []
    assert FAKE_MOVE_NAME == [('/etc/init/test.conf', '/etc/init/test.noexec')]

def test_upstart_rcd_set_desactivate():
    service.isfile = fake_isfile_upstart_desactivate
    service.move = fake_move
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service._upstart_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']
    assert FAKE_MOVE_NAME == [('/etc/init/test.noexec', '/etc/init/test.conf')]

def test_upstart_rcd_remove_desactivate():
    service.isfile = fake_isfile_upstart_desactivate
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service._upstart_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']

def test_upstart_rcd_set_inconsistent():
    service.isfile = fake_isfile_upstart_inconsistent
    service.unlink = fake_unlink
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service._upstart_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == ['/etc/init/test.noexec']

def test_upstart_rcd_remove_desactivate():
    service.isfile = fake_isfile_upstart_inconsistent
    service.move = fake_move
    service.unlink = fake_unlink
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service._upstart_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']
    assert FAKE_MOVE_NAME == [('/etc/init/test.conf', '/etc/init/test.noexec')]
    assert FAKE_UNLINK_NAME == ['/etc/init/test.noexec']

######### container
def test_upstart_rcd_no_stop_start_level_container():
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'test', 'startlevel': '1', 'stoplevel': '2'}

    container = CONTAINER_TEST
    raises(KeyError, "service._upstart_rcd(tservice, 'set', container)")

def test_upstart_rcd_set_activate_container():
    service.isfile = fake_isfile_upstart_activate
    service.unlink = fake_unlink
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'test'}

    container = CONTAINER_TEST
    service._upstart_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == []

def test_upstart_rcd_remove_activate_container():
    service.isfile = fake_isfile_upstart_activate
    service.unlink = fake_unlink
    service.move = fake_move
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'test'}

    container = CONTAINER_TEST
    service._upstart_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == []
    assert FAKE_MOVE_NAME == [('/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec')]

def test_upstart_rcd_set_desactivate_container():
    service.isfile = fake_isfile_upstart_desactivate
    service.move = fake_move
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'test'}

    container = CONTAINER_TEST
    service._upstart_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec']
    assert FAKE_MOVE_NAME == [('/path/container/etc/init/test.noexec', '/path/container/etc/init/test.conf')]

def test_upstart_rcd_remove_desactivate_container():
    service.isfile = fake_isfile_upstart_desactivate
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'test'}

    container = CONTAINER_TEST
    service._upstart_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec']

def test_upstart_rcd_set_inconsistent_container():
    service.isfile = fake_isfile_upstart_inconsistent
    service.unlink = fake_unlink
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'test'}

    container = CONTAINER_TEST
    service._upstart_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == ['/path/container/etc/init/test.noexec']

def test_upstart_rcd_remove_desactivate_container():
    service.isfile = fake_isfile_upstart_inconsistent
    service.move = fake_move
    service.unlink = fake_unlink
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'test'}

    container = CONTAINER_TEST
    service._upstart_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec']
    assert FAKE_MOVE_NAME == [('/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec')]
    assert FAKE_UNLINK_NAME == ['/path/container/etc/init/test.noexec']

######### unknown
def test_upstart_rcd_set_unknown():
    service.isfile = fake_isfile_false
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    raises(Exception, "service.creole_update_rcd(tservice, 'set', container)")

def test_upstart_rcd_remove_unknown():
    service.isfile = fake_isfile_false
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    raises(Exception, "service.creole_update_rcd(tservice, 'remove', container)")

######### creole
def test_creole_upstart_rcd_no_stop_start_level():
    tservice = {'name': 'test', 'method': 'upstart',
            'container': 'root', 'startlevel': '1', 'stoplevel': '2'}

    container = CONTAINER_ROOT
    raises(KeyError, "service.creole_update_rcd(tservice, 'set', container)")

def test_creole_upstart_rcd_set_activate():
    service.isfile = fake_isfile_upstart_activate
    service.unlink = fake_unlink
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == []

def test_creole_upstart_rcd_remove_activate():
    service.isfile = fake_isfile_upstart_activate
    service.unlink = fake_unlink
    service.move = fake_move
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service.creole_update_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == []
    assert FAKE_MOVE_NAME == [('/etc/init/test.conf', '/etc/init/test.noexec')]

def test_creole_upstart_rcd_set_desactivate():
    service.isfile = fake_isfile_upstart_desactivate
    service.move = fake_move
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']
    assert FAKE_MOVE_NAME == [('/etc/init/test.noexec', '/etc/init/test.conf')]

def test_creole_upstart_rcd_remove_desactivate():
    service.isfile = fake_isfile_upstart_desactivate
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'root'}

    container = CONTAINER_ROOT
    service.creole_update_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/etc/init/test.conf', '/etc/init/test.noexec']

def test_creole_upstart_rcd_set_activate_container():
    service.isfile = fake_isfile_upstart_activate
    service.unlink = fake_unlink
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'test'}

    container = CONTAINER_TEST
    service.creole_update_rcd(tservice, 'set', container)
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == []

def test_creoleupstart_rcd_remove_activate_container():
    service.isfile = fake_isfile_upstart_activate
    service.unlink = fake_unlink
    service.move = fake_move
    tservice = {'name': 'test', 'method': 'upstart', 'container': 'test'}

    container = CONTAINER_TEST
    service.creole_update_rcd(tservice, 'remove', container)
    assert FAKE_ISFILE_NAME == ['/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec']
    assert FAKE_UNLINK_NAME == []
    assert FAKE_MOVE_NAME == [('/path/container/etc/init/test.conf', '/path/container/etc/init/test.noexec')]

